/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Position;
import nxm.sys.lib.Table;
import nxm.sys.libg.Layer1D;

public class LayerPA
extends Layer1D {
    public static String protoList = "Raw,USB2,USB3,PCIE,TGBE";
    private static int P_RAW = 1;
    private static int P_USB2 = 2;
    private static int P_USB3 = 3;
    private static int P_PCIE = 4;
    private static int P_TGBE = 5;
    private int proto = P_RAW;

    public boolean setFile(PlotFile plotFile, Table table, Args args) {
        this.setFile(plotFile);
        this.setXAxis(plotFile.getXStart(), plotFile.getXDelta());
        int n = (int)Math.min(plotFile.getSize(), 1.0E7);
        int n2 = args.getL("/FS", Math.min(n, 32768));
        this.setFrame(n2);
        int n3 = args.getL("/LPS", 1);
        this.setSize(n3);
        this.setData(plotFile.getDataBuffer(n2 * n3));
        this.isPaged = !this.realtime && n2 * n3 < n;
        this.xIsTime = plotFile.getXUnits() == 1;
        this.setTimeAlign(args.getState("/TIMEALIGN", false));
        return true;
    }

    public void setProto(String string) {
        this.proto = Parser.find((String)protoList, (String)string, (int)0);
    }

    public String getProto() {
        return Parser.get((String)protoList, (int)this.proto);
    }

    public void process() {
        this.ndata = 0;
        if (this.data == null) {
            return;
        }
        this.ndata = this.data.size * this.data.ape;
        this.fbuf = this.data2fa(this.data, this.ndata, this.fbuf, 0, this.MP.mode);
    }

    public String getReadOut(Position position) {
        int n = (int)position.y;
        int n2 = (int)(position.x / this.xdelta);
        String string = " PA ()";
        return string;
    }
}

