/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.text.DecimalFormat;
import javax.swing.JOptionPane;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.GPrimitive;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.MFormat;
import nxm.sys.lib.Message;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPrompt;
import nxm.sys.libg.GValue;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MWindow;
import nxm.sys.libg.Theme;

public class view
extends GPrimitive
implements Keyable {
    private int controls = 1;
    private int scale = 0;
    private int mode = 0;
    private int view = 0;
    private int type = 0;
    private int realtime = 0;
    private int hilite = 1;
    private int exit = -1;
    private int poll = 0;
    private int flags = 0;
    private int outtype = 1;
    private int settings = -1;
    private int curmode = 0;
    private int colrIdx = 1;
    private long polltime = System.currentTimeMillis();
    private DataFile hcb;
    private Object obj;
    private Table tab;
    private Keywords tkw;
    private Table ttbl;
    private Data data;
    private Data datb;
    private KeyVector kv;
    private Table kvo;
    private double offset;
    private double size;
    private boolean rescale = false;
    private boolean isReadyF;
    private boolean isReadyT;
    private boolean isEdit;
    private boolean isEditing;
    private String form;
    private String currentName;
    private String templateName;
    private int th = 12;
    private int ta = 16;
    private int tw = 8;
    private int tv;
    private int selRow;
    private int selCol;
    private int curRow;
    private int curCol;
    private int numRows;
    private int numCols;
    private int nc;
    private int ds;
    private int dh;
    private int bh;
    private int ch;
    private int cw;
    private int sx;
    private int sw = 6;
    private int sy;
    private int sh;
    private Color cbg0;
    private Color cbg1;
    private Color cbg2;
    private Color cbs0;
    private Color cbs1;
    private Color cwfh;
    private boolean showLN;
    private boolean useTemplate;
    private boolean useDataList;
    private boolean useTable;
    private boolean useAuto;
    private boolean isTable;
    private boolean isFile;
    private GWidget gedit;
    static final String exitList = "RETURN,MENU,MESSAGE";
    static final int EXIT_RETURN = 1;
    static final int EXIT_MENU = 2;
    static final int EXIT_MESSAGE = 4;
    static final int EXIT_ALL = 15;
    static final int ONCLICK = 1;
    static final int ONMOTION = 2;
    static final int T_CELL = 1;
    static final int T_ROW = 2;
    static final int T_COL = 3;
    static final int GRID = 1;
    static final int FILL = 2;
    static final int SCROLL = 4;
    static final int CENTER = 8;
    static final int HEADER = 16;
    static final int NUMBER = 32;
    static final int SDEF_FILE = 61;
    static final int SDEF_TABLE = 12;
    static final String settingsList = "Grid,Fill,Scroll,Center,Header,Number";
    private Column[] columns;
    private static String[] keys = new String[]{"NUMROWS", "NUMCOLS", "CURROW", "CURCOL", "CELL"};

    public int open() {
        this.hilite = this.MA.getSelectionIndex("HILITE", "BACK,FORE", 1);
        this.controls = this.MA.getSelectionIndex("CNT=", "CLICK,CONT", 1);
        this.poll = this.MA.getI("/POLL", (short)0);
        this.curmode = this.MA.getSelectionIndex("CURSOR", "CELL,ROW,COL", 1);
        if (this.curmode == -1) {
            this.curmode = 1;
        }
        this.realtime = this.MA.getL("/RT", 0);
        this.exit = this.M.pipeMode == 1 ? 0 : -1;
        this.exit = this.MA.getOptionMask("/EXIT", exitList, this.exit);
        if (this.MA.getState("/HEX")) {
            this.flags |= 1;
        } else if (this.MA.getState("/BIN")) {
            this.flags |= 2;
        }
        this.showLN = this.MA.getState("/L", true);
        this.isEdit = this.MA.getState("/EDIT", false);
        this.MW = new MWView("View", (MessageHandler)this);
        this.MW.open();
        this.MW.setSize(800, 500);
        this.MW.addTo((Object)this);
        if (this.MW.fm != null) {
            this.tw = this.MW.fm.charWidth('0');
            this.th = this.MW.fm.getHeight();
            this.ta = this.MW.fm.getAscent();
        }
        this.bh = 4;
        this.dh = 0;
        this.cw = this.tw;
        this.ch = this.dh + this.th + this.bh - 2;
        this.tv = this.tw / 2;
        this.cbg0 = this.MW.theme.cwms;
        this.cbs0 = this.MW.theme.cwbs;
        this.cbg1 = this.MW.theme.cwbs;
        this.cbs1 = this.MW.theme.cwts;
        this.cbg2 = this.MW.theme.cwbs.brighter();
        this.cwfh = this.MW.theme.cwfh;
        this.selRow = 0;
        this.selCol = 0;
        this.openTemplateFile(this.MA.getCS("TEMPLATE"));
        this.openAny(this.MA.getCS("FILE"));
        this.refresh(1);
        return 0;
    }

    private boolean isVisible() {
        if (this.MW.panel == null) {
            return false;
        }
        Frame frame = JOptionPane.getFrameForComponent(this.MW.panel);
        if (!this.MW.panel.isShowing()) {
            return false;
        }
        return frame == null || frame.getExtendedState() != 1;
    }

    public int process() {
        if (this.MW.status == -2) {
            return -1;
        }
        if (this.checkPollTime()) {
            this.refresh();
            return 0;
        }
        return -1;
    }

    public int close() {
        if (this.hcb != null) {
            this.hcb.close();
        }
        this.MW.close();
        return 0;
    }

    private boolean checkPollTime() {
        if (this.poll <= 0) {
            return false;
        }
        long l = System.currentTimeMillis();
        if (l - this.polltime > (long)(this.poll * 1000)) {
            this.polltime = l;
            return true;
        }
        return false;
    }

    private boolean autoConfig() {
        int n = this.nc;
        int n2 = this.numRows;
        this.applyTemplate();
        return this.isTable || this.nc != n || this.numRows != n2;
    }

    private void openAny(String string) {
        Object object = this.MR.getO(string.toUpperCase());
        if (string.endsWith(".tbl")) {
            object = this.openTableFromFile(string);
        }
        if (object instanceof Table) {
            this.openTable((Table)object);
        } else {
            this.openFile(string);
        }
    }

    private Table openTableFromFile(String string) {
        TextFile textFile = new TextFile((MidasReference)this.M, (Object)string);
        return new Table(textFile);
    }

    private void openTable(Table table) {
        this.tab = table;
        this.isTable = true;
        this.isFile = false;
        this.parseTable();
        this.applyTemplate();
        this.isReadyF = true;
        this.refresh();
    }

    private void closeTable() {
        this.tab = new Table();
    }

    private void parseTable() {
        if (this.kv == null) {
            this.kv = new KeyVector();
        }
        if (this.kvo == null) {
            this.kvo = new Table();
        }
        this.kv.clear();
        this.addTable(this.tab, 0, "");
        this.size = this.kv.getSize();
    }

    private void addTable(Table table, int n, String string) {
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            string2 = string2 + "  ";
        }
        Table.Iterator iterator = table.iterator();
        while (iterator.getNext()) {
            if (iterator.value instanceof Table) {
                string = string + iterator.key;
                Table table2 = (Table)iterator.value;
                boolean bl = this.kvo.containsKey(string);
                this.kv.add(string2 + iterator.key + "@" + string, (Object)table2);
                String string3 = table2.getS("TOSTR");
                if (string3 != null) {
                    this.kvo.put(string + "_TOSTR", (Object)string3);
                }
                if (!bl) continue;
                this.addTable(table2, n + 1, string);
                continue;
            }
            if (iterator.key.equals("TOSTR")) continue;
            this.kv.add(string2 + iterator.key, iterator.value);
        }
    }

    private void openFile(String string) {
        int n;
        this.isReadyF = false;
        this.closeFile();
        if (!string.equals(this.currentName)) {
            this.offset = 0.0;
        }
        this.isTable = false;
        this.isFile = true;
        this.hcb = new DataFile();
        this.hcb.init((MidasReference)this.M, (Object)string);
        int n2 = n = this.isEdit ? 3 : 1;
        if (this.hcb.open(n | 0x40)) {
            this.size = this.hcb.size;
            this.data = this.hcb.getDataBuffer(1);
            this.datb = this.hcb.getDataBuffer(1);
            this.form = this.hcb.getFormat();
            this.autoConfig();
            this.isReadyF = true;
        }
        this.refresh();
    }

    private boolean is(int n) {
        return (this.settings & n) != 0;
    }

    private void getSettings() {
        if (this.settings >= 0) {
            return;
        }
        this.settings = this.isTable ? 12 : 61;
        this.settings = this.MA.getOptionMask("/SETTINGS", settingsList, this.settings);
    }

    private void openTemplateFile(String string) {
        this.tkw = null;
        this.ttbl = null;
        this.isReadyT = false;
        this.templateName = string.toLowerCase();
        this.useAuto = this.templateName.equals("auto");
        this.useTable = this.templateName.endsWith(".tbl");
        this.useDataList = this.templateName.equals("");
        boolean bl = this.useTemplate = !this.useDataList && !this.useAuto && !this.useTable;
        if (this.useTemplate && this.tkw == null) {
            DataFile dataFile = new DataFile();
            dataFile.init((MidasReference)this.M, (Object)this.templateName);
            dataFile.open();
            this.tkw = dataFile.keywords;
            dataFile.close();
        }
        if (this.useTable && this.ttbl == null) {
            this.ttbl = Convert.o2t((Object)this.templateName, (Object)((Object)this));
        }
    }

    private void applyTemplate() {
        this.isReadyT = false;
        this.getSettings();
        this.numRows = this.MW.pos.h / this.ch;
        if (this.is(16)) {
            --this.numRows;
        }
        if (this.isTable) {
            this.numCols = 1;
        } else if (this.useDataList) {
            this.numCols = 1;
        } else if (this.useAuto) {
            this.numCols = this.hcb.getSubSize();
        } else if (this.useTable) {
            this.numCols = this.ttbl.getL("FIELDS");
        } else {
            this.tkw.setScope("SECTION=XDATALIST");
            this.numCols = this.tkw.getL("FIELDS", 0);
        }
        if (this.columns == null || this.numCols + 1 > this.columns.length) {
            this.columns = new Column[this.numCols + 1];
        }
        int n = 0;
        int n2 = this.useDataList || this.useAuto ? 5 : 3;
        boolean bl = this.is(8);
        boolean bl2 = this.is(32);
        boolean bl3 = this.is(4);
        this.nc = 1;
        String string = "CFG";
        for (int i = 0; i <= this.numCols; ++i) {
            Object object;
            Column column = new Column();
            if (i == 0 && !bl2) {
                column.width = 0;
            } else if (i == 0 && (this.isTable || this.useDataList || this.useAuto || this.useTable)) {
                column.label = "#";
                column.width = n2;
            } else if (this.isTable) {
                column.width = -1;
            } else if (this.useDataList) {
                column.width = -1;
                if (this.hcb != null && this.hcb.isOpen) {
                    this.nc = this.hcb.listElementsPerLine(this.MW.pos.w / this.cw - (this.showLN ? 6 : 1), this.form, this.flags);
                    if (this.nc < 1) {
                        this.nc = 1;
                    }
                    this.nc = this.MA.getL("/NC", this.nc);
                    column.label = "FILE=" + this.hcb.getURL() + " TYPE=" + this.hcb.getType() + " FORM=" + this.hcb.getFormat() + " SIZE=" + this.hcb.getSize();
                }
            } else if (this.useAuto) {
                object = this.hcb.getRecName(i - 1);
                String string2 = this.hcb.getRecFormat(i - 1);
                char c = string2.charAt(1);
                column.subr = object;
                column.label = ((String)object).substring(0, 1) + ((String)object).substring(1).toLowerCase();
                if (c == 'A') {
                    column.form = "ASCII";
                } else {
                    column.df = c == 'F' || c == 'D' ? new DecimalFormat("#.000") : new DecimalFormat("##");
                }
                column.width = 8;
                column.soff = -1;
                column.center = bl;
            } else {
                if (this.useTable && this.ttbl.getO("FIELD" + i) != null) {
                    object = this.ttbl.getTable("FIELD" + i);
                    column.subr = object.getS("SUBR", "NONE").trim();
                    column.form = object.getS("DISPFORM", "ASCII").trim();
                    column.label = object.getS("LABEL", "").trim();
                    column.width = object.getL("WIDTH", n2);
                    column.items = object.getS("ITEMS");
                    string = object.getS("COLOR", "CFG").trim();
                } else if (this.useTemplate && this.tkw.setScope("SECTION=XDATALIST,FIELD=" + i) == 2) {
                    column.subr = this.tkw.getS("SUBR", "NONE").trim();
                    column.form = this.tkw.getS("DISPFORM", "ASCII").trim();
                    column.label = this.tkw.getS("LABEL", "").trim();
                    column.width = this.tkw.getL("WIDTH", n2);
                    string = this.tkw.getS("COLOR", "CFG").trim();
                    column.items = this.tkw.getS("ITEMS", null);
                } else {
                    column.form = "ASCII";
                    column.label = "";
                    column.width = n2;
                }
                column.soff = -1;
                boolean bl4 = column.center = i > 0 && bl;
                if (column.form.equals("TOGGLE")) {
                    column.toggle = true;
                    column.colors = new Color[3];
                    column.letters = new String[3];
                    column.letters[0] = "-";
                    column.colors[0] = Color.RED.darker();
                    column.letters[1] = "*";
                    column.colors[1] = Color.GREEN.darker();
                    column.letters[2] = "?";
                    column.colors[2] = Color.BLUE.darker();
                } else if (column.form.equals("METER")) {
                    column.meter = true;
                } else if (column.form.equals("MENU")) {
                    column.menu = true;
                } else if (!column.form.equals("ASCII")) {
                    if (column.form.indexOf(35) >= 0) {
                        column.df = new DecimalFormat(column.form);
                    } else {
                        column.mf = MFormat.getNumberFormatFor((String)column.form);
                    }
                }
            }
            object = this.MW.theme.getColor(string);
            if (object == null) {
                object = MColor.getColor((Object)string);
            }
            column.color = object;
            int n3 = column.pw = column.width >= 0 ? (column.width + 1) * this.cw : this.MW.pos.w - n - this.sw;
            if (i == 0 && column.width == 0 && bl3) {
                column.pw = this.sw + this.cw;
            }
            column.px = n;
            n += column.pw;
            this.columns[i] = column;
        }
        this.isReadyT = true;
    }

    private void closeFile() {
        this.isReadyF = false;
        if (this.hcb != null && this.hcb.isOpen()) {
            this.hcb.close();
        }
        this.refresh();
    }

    private String padi(int n, int n2) {
        if (!this.showLN) {
            return " ";
        }
        String string = "" + n;
        --n2;
        while (string.length() < n2) {
            string = " " + string;
        }
        return string;
    }

    private String formatCell(Data data, int n) {
        Column column = this.columns[n];
        if (column.soff < 0) {
            int n2 = this.hcb.findRec(column.subr);
            if (n2 < 0) {
                this.M.warning((CharSequence)("Subrecord " + column.subr + " not found in file: " + this.hcb.getURL()));
            }
            column.soff = this.hcb.getRecOffset(n2);
            column.sfmt = this.hcb.getRecFormat(n2);
            column.sbpa = Data.getBPA((String)column.sfmt);
            column.type = column.sfmt.charAt(1);
        }
        Object object = this.getValue(data, n);
        if (column.toggle) {
            int n3;
            int n4 = column.type != 'A' ? Convert.o2l((Object)object) : (n3 = object.toString().equalsIgnoreCase("On") ? 1 : 0);
            if (n3 < 0 || n3 > 2) {
                n3 = 0;
            }
            column.dcolor = column.colors[n3];
            return column.letters[n3];
        }
        if (column.mf != null || column.df != null) {
            double d = Convert.o2d((Object)object);
            if (column.df != null) {
                return column.df.format(d);
            }
            return column.mf.format((Object)d);
        }
        if (column.form.equals("ASCII") || column.form.equals("MENU")) {
            int n5;
            for (n5 = 0; data.buf[column.soff + n5] > 32 && n5 < column.sbpa; ++n5) {
            }
            return new String(data.buf, column.soff, n5);
        }
        return null;
    }

    private Object getValue(Data data, int n) {
        Column column = this.columns[n];
        switch (column.type) {
            case 'D': {
                return Convert.unpackD((byte[])data.buf, (int)column.soff);
            }
            case 'F': {
                return Float.valueOf(Convert.unpackF((byte[])data.buf, (int)column.soff));
            }
            case 'L': {
                return Convert.unpackL((byte[])data.buf, (int)column.soff);
            }
            case 'I': {
                return Convert.unpackI((byte[])data.buf, (int)column.soff);
            }
            case 'B': {
                return Convert.unpackB((byte[])data.buf, (int)column.soff);
            }
            case 'A': {
                return Convert.unpackS((byte[])data.buf, (int)column.soff, (int)column.sbpa);
            }
        }
        return null;
    }

    private Object getValue(int n, int n2) {
        if (this.isTable) {
            return this.getTableLineAll(n - 1);
        }
        if (this.useDataList) {
            return null;
        }
        if (n <= 0) {
            return null;
        }
        double d = n - 1;
        if (d < 0.0 || d >= this.size) {
            return null;
        }
        if (this.hcb == null || !this.hcb.isOpen) {
            return null;
        }
        if (this.hcb.read(this.datb, d, 1) != 1) {
            return null;
        }
        if (n2 > 0) {
            return this.getValue(this.datb, n2);
        }
        Table table = new Table();
        for (n2 = 1; n2 <= this.numCols; ++n2) {
            Column column = this.columns[n2];
            table.put(column.subr, this.getValue(this.datb, n2));
        }
        return table;
    }

    private void setValue(int n, int n2, Object object) {
        if (this.useDataList) {
            return;
        }
        double d = n - 1;
        if (d < 0.0 || d >= this.size) {
            return;
        }
        if (this.hcb == null || !this.hcb.isOpen) {
            return;
        }
        if (this.hcb.read(this.datb, d, 1) != 1) {
            return;
        }
        Column column = this.columns[n2];
        if (column.type == 'D') {
            Convert.packD((byte[])this.datb.buf, (int)column.soff, (double)Convert.o2d((Object)object));
        }
        if (column.type == 'F') {
            Convert.packF((byte[])this.datb.buf, (int)column.soff, (float)Convert.o2f((Object)object));
        }
        if (column.type == 'L') {
            Convert.packL((byte[])this.datb.buf, (int)column.soff, (int)Convert.o2l((Object)object));
        }
        if (column.type == 'A') {
            Convert.packS((byte[])this.datb.buf, (int)column.soff, (int)column.sbpa, (String)object.toString());
        }
        if (this.hcb.write(this.datb, d, 1) != 1) {
            return;
        }
    }

    public void drawSymbol(String string, int n, int n2, int n3, Graphics graphics) {
        if (string.equals("*")) {
            graphics.drawOval(n, n2, n3, n3);
        }
        if (string.equals("-")) {
            graphics.drawRect(n, n2, n3, n3);
        }
    }

    private void refresh() {
        this.refresh(0);
    }

    private void refresh(int n) {
        this.MW.refresh();
    }

    private void resize() {
        this.MW.resize(1);
        if (this.autoConfig()) {
            this.refresh();
        }
    }

    private void getCurrent() {
        this.curCol = -1;
        for (int i = 0; i <= this.numCols; ++i) {
            Column column = this.columns[i];
            if (this.MW.px <= column.px || this.MW.px >= column.px + column.pw) continue;
            this.curCol = i;
        }
        this.curRow = this.MW.py / this.ch;
        if (!this.is(16)) {
            ++this.curRow;
        }
        if (this.curRow > 0) {
            this.curRow += (int)this.offset;
        }
        if ((double)this.curRow > this.size) {
            this.curRow = -1;
        }
    }

    private void select() {
        this.getCurrent();
        if (this.curRow < 0 || this.curCol < 0) {
            return;
        }
        this.select(this.curRow, this.curCol, true);
    }

    private void select(int n, int n2) {
        this.select(n, n2, false);
    }

    private void editCell(int n, int n2) {
        Column column = this.columns[n2];
        Object object = this.getValue(n == 0 ? 1 : n, n2);
        if (column.toggle) {
            int n3;
            Object object2;
            if (column.type == 'A') {
                object2 = object.toString().equalsIgnoreCase("On") ? "Off" : "On";
            } else {
                n3 = Convert.o2l((Object)object);
                object2 = Convert.l2o((int)(1 - n3));
            }
            if (n > 0) {
                this.setValue(n, n2, object2);
            } else {
                n3 = 1;
                while ((double)n3 <= this.size) {
                    this.setValue(n3, n2, object2);
                    ++n3;
                }
            }
            this.refresh();
            return;
        }
        if (this.isEditing) {
            this.isEditing = false;
            return;
        }
        this.isEditing = true;
        String string = "Edit-" + n + "-" + n2 + "-" + column.subr;
        char c = column.type;
        int n4 = 0;
        if (column.menu) {
            this.gedit = new GMenu((Object)this.MW, string, column.items, 0, n4 |= 0x400000, (MessageHandler)this);
        } else if (c == 'L' || c == 'F' || c == 'D' || c == 'T') {
            double d = Convert.o2d((Object)object);
            this.gedit = new GValue((Object)this.MW, string, d, 1.0, -1.0, 1.0, c, n4, (MessageHandler)this);
        } else {
            String string2 = object.toString();
            this.gedit = new GPrompt((Object)this.MW, string, string2, n4, (MessageHandler)this);
        }
    }

    private void sendCell(int n, int n2, String string) {
        Table table = new Table();
        table.put("TYPE", (Object)(n2 == 0 ? "ROW" : (n == 0 ? "COL" : "CELL")));
        table.put("ROW", (Object)n);
        table.put("COLUMN", (Object)n2);
        table.put("NAME", (Object)this.columns[n2].subr);
        table.put("VALUE", this.getValue(n, n2));
        this.sendMessage(string, 0, table);
    }

    private void select(int n, int n2, boolean bl) {
        this.selRow = n;
        this.selCol = n2;
        if ((double)this.selRow >= this.offset + (double)this.numRows) {
            this.offset = Math.max(0.0, Math.min(this.size, (double)n) - (double)this.numRows + 1.0);
        }
        if ((double)this.selRow < this.offset + 2.0) {
            this.offset = Math.max(0, n - this.numRows / 2);
        }
        this.offset = Math.floor(this.offset / (double)this.nc) * (double)this.nc;
        this.refresh();
        if (bl) {
            this.sendCell(n, n2, "SELECT");
        }
    }

    private void deselect(boolean bl) {
        this.isEditing = false;
        this.select(0, 0, bl);
    }

    private String getTableLine(int n) {
        String string;
        String string2;
        if (n < 0 || (double)n >= this.size) {
            return "Oops";
        }
        String string3 = this.kv.getKey(n);
        Object object = this.kv.get(n);
        if (object instanceof Table) {
            Table table = (Table)object;
            int n2 = string3.indexOf(64);
            String string4 = string3.substring(n2 + 1);
            string3 = string3.substring(0, n2);
            boolean bl = this.kvo.containsKey(string4);
            string2 = this.kvo.getS(string4 + "_TOSTR");
            if (string2 == null) {
                string2 = "Table of " + table.getSize() + " entries";
            }
            string = bl ? "- " : "+ ";
        } else {
            string2 = object.toString();
            string = "  ";
        }
        return string + string3 + " : " + string2;
    }

    private String getTableLineAll(int n) {
        String string;
        if (n < 0 || (double)n >= this.size) {
            return "Oops";
        }
        String string2 = this.kv.getKey(n);
        Object object = this.kv.get(n);
        if (object instanceof Table) {
            Table table = (Table)object;
            int n2 = string2.indexOf(64);
            String string3 = string2.substring(n2 + 1);
            string2 = string2.substring(0, n2);
            string = table.toString();
        } else {
            string = object.toString();
        }
        return string2 + ":" + string;
    }

    private void handleTableHit(int n) {
        int n2 = n - 1;
        if (n2 < 0 || (double)n2 >= this.size) {
            return;
        }
        String string = this.kv.getKey(n2);
        Object object = this.kv.get(n2);
        if (object instanceof Table) {
            Table table = (Table)object;
            int n3 = string.indexOf(64);
            String string2 = string.substring(n3 + 1);
            if (this.kvo.containsKey(string2)) {
                this.kvo.remove(string2);
            } else {
                this.kvo.put(string2, (Object)"Open");
            }
            this.parseTable();
            this.applyTemplate();
        }
    }

    private void scroll(int n) {
        double d = this.offset;
        this.offset = Math.max(0.0, Math.min(this.size + (double)(2 * this.nc) - Math.floor(this.numRows * this.nc), Math.floor(this.offset + (double)n)));
        this.offset = Math.floor(this.offset / (double)this.nc) * (double)this.nc;
        if (this.offset != d) {
            this.refresh();
        }
    }

    private void getHit() {
        this.getHit(this.MW.px, this.MW.py, 0, 0, false);
    }

    private void getHit(int n, int n2, int n3, int n4, boolean bl) {
        if (n >= this.sx && n <= this.sx + this.sw && n2 >= this.sy && n2 < this.sy + this.sh) {
            this.offset = (double)(n2 + n4 - this.sy) * this.size / (double)this.sh;
            this.offset = Math.max(0.0, Math.min(this.size + (double)(2 * this.nc) - Math.floor(this.numRows * this.nc), Math.floor(this.offset)));
            this.offset = Math.floor(this.offset / (double)this.nc) * (double)this.nc;
        } else if (!bl) {
            this.getCurrent();
            if (this.curRow < 0 || this.curCol < 0) {
                return;
            }
            if (this.isTable && this.curRow >= 0 && this.curCol > 0 && this.curRow == this.selRow && this.curCol == this.selCol) {
                this.handleTableHit(this.curRow);
            } else if (this.isEdit && this.curRow >= 0 && this.curCol > 0 && this.curRow == this.selRow && this.curCol == this.selCol) {
                this.editCell(this.curRow, this.curCol);
            } else {
                this.isEditing = false;
                this.select();
            }
        }
        this.refresh();
    }

    public int processMessage(Message message) {
        String string;
        if (this.MW == null || this.MW.status == 0 || !this.thisIsMe()) {
            if (message.name.equals("POINTER")) {
                this.MQ.remove(message.name);
            }
            if (message.name.equals("REFRESH") || message.name.equals("RESIZE")) {
                this.MQ.remove(message.name);
            }
            if (message.name.startsWith("PAN") || message.name.startsWith("DRAG")) {
                this.MQ.remove(message.name);
            }
            this.MQ.put(message);
            return -1;
        }
        if (message.name.equals("KEYPRESS")) {
            String string2 = (String)message.data;
            if (string2.equalsIgnoreCase("M")) {
                message.name = "MENU";
            }
            if (string2.equalsIgnoreCase("Enter") && (this.exit & 1) != 0) {
                message.name = "EXIT";
            }
        }
        if (message.name.equals("BUTTON") && message.info == 2) {
            message.name = "MENU";
        }
        boolean bl = true;
        if (message.name.equals("POINTER")) {
            if (this.controls == 2) {
                message.data = null;
                this.sendMessage(message);
            }
        } else if (message.name.equals("BUTTON")) {
            if (message.info == 1) {
                this.getHit();
            }
            if (message.info == 3) {
                this.deselect(true);
            }
        } else if (message.name.equals("DRAG")) {
            string = (MBox)message.data;
            if (message.info == 1) {
                this.getHit(((MBox)string).x, ((MBox)string).y, ((MBox)string).w, ((MBox)string).h, true);
            }
        } else if (message.name.startsWith("EDIT-")) {
            string = message.name;
            int n = string.indexOf(45);
            int n2 = string.indexOf(45, n + 1);
            int n3 = string.indexOf(45, n2 + 1);
            int n4 = Convert.s2l((String)string.substring(n + 1, n2));
            int n5 = Convert.s2l((String)string.substring(n2 + 1, n3));
            if (n4 > 0) {
                this.setValue(n4, n5, message.data);
            } else {
                int n6 = 1;
                while ((double)n6 <= this.size) {
                    this.setValue(n6, n5, message.data);
                    ++n6;
                }
            }
            this.refresh();
            this.sendCell(n4, n5, "UPDATE");
            this.isEditing = false;
        } else {
            bl = false;
        }
        if (bl) {
            return 0;
        }
        switch (message.name) {
            case "SCROLL": {
                this.scroll(message.info);
                break;
            }
            case "REFRESH": {
                this.refresh(1);
                break;
            }
            case "RESIZE": {
                this.resize();
                break;
            }
            case "SELECTROW": {
                this.select(Convert.o2l((Object)message.data), 0);
                break;
            }
            case "SELECTCOL": {
                this.select(0, Convert.o2l((Object)message.data));
                break;
            }
            case "SELECTCELL": {
                Table table = Convert.o2t((Object)message.data);
                this.select(table.getL("ROW"), table.getL("COL"));
                break;
            }
            case "DESELECT": {
                this.deselect(false);
                break;
            }
            case "MENU": {
                new GMenu((Object)this.MW, "List", "Files...,Template...,Settings...,Control...,Window...,Other...,Exit", 0, 0, (MessageHandler)this);
                break;
            }
            case "LIST": {
                switch ((String)message.data) {
                    case "FILES...": {
                        new GMenu((Object)this.MW, "Files", "Open,Close,Reread,ReOpen", 0, 0, (MessageHandler)this);
                        break;
                    }
                    case "TEMPLATE...": {
                        new GMenu((Object)this.MW, "Template", "Open,Default", 0, 0, (MessageHandler)this);
                        break;
                    }
                    case "CONTROL...": {
                        new GMenu((Object)this.MW, "Controls", "Off,Click,Continuous,Assign...", this.controls + 1, 0, (MessageHandler)this);
                        break;
                    }
                    case "WINDOW...": {
                        new GMenu((Object)this.MW, "Window", "Toggle,Push,Pop", 0, 0, (MessageHandler)this);
                        break;
                    }
                    case "OTHER...": {
                        new GMenu((Object)this.MW, "Other", "Theme", 0, 0, (MessageHandler)this);
                        break;
                    }
                    case "SETTINGS...": {
                        new GMenu((Object)this.MW, "Settings", settingsList, this.settings, 1024, (MessageHandler)this);
                        break;
                    }
                    case "EXIT": {
                        message.name = "EXIT";
                        if ((this.exit & 2) == 0) break;
                        this.MQ.put(message);
                    }
                }
                break;
            }
            case "FILES": {
                switch ((String)message.data) {
                    case "OPEN": {
                        new GPrompt((Object)this.MW, "OpenFile", "", 0, (MessageHandler)this);
                        break;
                    }
                    case "CLOSE": {
                        this.closeFile();
                        break;
                    }
                    case "REREAD": {
                        if (this.isTable) {
                            this.parseTable();
                            this.applyTemplate();
                        }
                        this.refresh();
                        break;
                    }
                    case "REOPEN": {
                        this.openFile(this.currentName);
                    }
                }
                break;
            }
            case "TEMPLATE": {
                switch ((String)message.data) {
                    case "OPEN": {
                        new GPrompt((Object)this.MW, "OPENTEMPLATE", "", 0, (MessageHandler)this);
                        break;
                    }
                    case "DEFAULT": {
                        this.openFile(this.currentName);
                    }
                }
                break;
            }
            case "SETTINGS": {
                this.settings = message.info;
                this.applyTemplate();
                this.refresh();
                break;
            }
            case "CONTROLS": {
                if (message.info == 4) break;
                this.controls = message.info - 1;
                break;
            }
            case "WINDOW": {
                break;
            }
            case "OTHER": {
                switch ((String)message.data) {
                    case "THEME": {
                        new GMenu((Object)this.MW, "THEME", "DeskTop,Default,WoB,GoB,BoW,MnM,Browser,Gear1,Gear2,Gear3,Gear4,Nak", 0, 0, (MessageHandler)this);
                    }
                }
                break;
            }
            case "OPENTABLE": {
                this.openTable((Table)message.data);
                break;
            }
            case "CLOSETABLE": {
                this.closeTable();
                break;
            }
            case "OPENFILE": {
                if (message.info >= 0) {
                    this.isEdit = message.info > 0;
                }
                this.openFile((String)message.data);
                break;
            }
            case "CLOSEFILE": {
                this.closeFile();
                break;
            }
            case "OPENTEMPLATE": {
                this.openTemplateFile((String)message.data);
                break;
            }
            case "APPLYTEMPLATE": {
                this.openTemplateFile((String)message.data);
                break;
            }
            case "THEME": {
                this.MW.setTheme((String)message.data);
                this.refresh();
                break;
            }
            case "CURSOR": {
                this.curmode = message.info;
                break;
            }
            case "COLOR": {
                this.colrIdx = message.info;
                break;
            }
            case "POP": {
                this.MW.pop(-1);
                this.refresh(1);
                break;
            }
            case "EXIT": {
                if ((this.exit & 4) == 0) break;
                return 9;
            }
            case "FINISH": {
                return 9;
            }
        }
        return 0;
    }

    public Object getCell(int n, int n2) {
        return null;
    }

    public Object setKey(String string, Object object) {
        switch (string) {
            case "CURROW": {
                this.curRow = Convert.o2l((Object)object);
                break;
            }
            case "CURCOL": {
                this.curCol = Convert.o2l((Object)object);
                break;
            }
            case "SELECTROW": {
                this.select(Convert.o2l((Object)object), 0);
                break;
            }
            case "SELECTCOL": {
                this.select(0, Convert.o2l((Object)object));
                break;
            }
            case "SELECTCELL": {
                Table table = Convert.o2t((Object)object);
                this.select(table.getL("ROW"), table.getL("COL"));
                break;
            }
            case "DESELECT": {
                this.deselect(false);
                break;
            }
            case "ADDROW": 
            case "ADDROWS": 
            case "SETROW": 
            case "ROWBYVALUE": 
            case "REMOVEROW": 
            case "REMOVECURRROW": 
            case "SELECTMROW": 
            case "SELECTCELLS": 
            case "SORTA": 
            case "SORTD": 
            case "SHOWCOL": 
            case "HIDECOL": 
            case "SHOWALL": 
            case "HIDEALL": 
            case "SETCELL": 
            case "SETCELLCOLORS": 
            case "SETROWCOLORS": 
            case "SETCOLCOLORS": {
                this.M.warning((CharSequence)("Key " + string + " not supported for this version of list"));
                break;
            }
            default: {
                return null;
            }
        }
        return object;
    }

    public String[] getKeys() {
        return keys;
    }

    public Object getKey(String string) {
        switch (string) {
            case "NUMROWS": {
                return this.numRows;
            }
            case "NUMCOLS": {
                return this.numCols;
            }
            case "CURROW": {
                return this.curRow;
            }
            case "CURCOL": {
                return this.curCol;
            }
            case "SELROW": {
                return this.selRow;
            }
            case "SELCOL": {
                return this.selCol;
            }
            case "SELECTEDROW": {
                return this.selRow;
            }
            case "SELECTEDCOL": {
                return this.selCol;
            }
            case "CELL": {
                return this.getCell(this.curRow, this.curCol);
            }
        }
        return null;
    }

    public int getPollInterval() {
        return this.poll;
    }

    public void setPollInterval(int n) {
        this.poll = n;
    }

    private class MWView
    extends MWindow {
        public MWView(String string, MessageHandler messageHandler) {
            super(string, messageHandler, (Object)true);
        }

        public synchronized void paintComponent(Graphics graphics) {
            int n = 0;
            int n2 = 0;
            if (view.this.state != 2) {
                return;
            }
            if (!view.this.isReadyF || !view.this.isReadyT) {
                graphics.setColor(view.this.cbg1);
                graphics.fillRect(0, 0, this.pos.w, this.pos.h);
                return;
            }
            boolean bl = view.this.is(2);
            boolean bl2 = view.this.is(1);
            boolean bl3 = view.this.is(4);
            boolean bl4 = view.this.is(16);
            boolean bl5 = view.this.is(32);
            int n3 = bl4 ? 0 : 1;
            boolean bl6 = bl4;
            long l = (long)view.this.offset / 1000L * 1000L;
            for (int i = n3; i <= view.this.numRows; ++i) {
                boolean bl7 = i == 0;
                double d = view.this.offset + (double)((i - 1) * view.this.nc);
                long l2 = -1L;
                long l3 = -1L;
                if (!bl7) {
                    if (d >= view.this.size) break;
                    l3 = (long)(d + 1.0);
                    l2 = (long)(d + 1.0);
                    if (!view.this.isTable) {
                        if (view.this.useDataList) {
                            if (view.this.hcb == null || !((view)view.this).hcb.isOpen || view.this.state != 2) break;
                            l2 = (long)d;
                        } else if (view.this.hcb == null || !((view)view.this).hcb.isOpen || view.this.state != 2 || view.this.hcb.read(view.this.data, d, 1) != 1) break;
                    }
                }
                for (int j = 0; j <= view.this.numCols; ++j) {
                    Column column = view.this.columns[j];
                    boolean bl8 = j == 0 || i == 0;
                    boolean bl9 = bl7 || column.center;
                    boolean bl10 = !((long)view.this.selRow != l3 && view.this.selRow != 0 || view.this.selCol != j && view.this.selCol != 0 || view.this.selRow == 0 && view.this.selCol == 0);
                    n = column.px;
                    int n4 = column.pw;
                    graphics.setColor(bl8 ? view.this.cbg0 : (bl10 ? view.this.cbg2 : view.this.cbg1));
                    graphics.fillRect(n, n2, n4, view.this.ch);
                    if (j == 0 && !bl5) continue;
                    String string = null;
                    string = i == 0 ? (j == 0 && l > 0L ? "" + l + "+" : column.label) : (j == 0 ? view.this.padi((int)(l2 - l), column.width) : (view.this.isTable ? view.this.getTableLine((int)d) : (view.this.useDataList ? view.this.hcb.listElements(d, view.this.nc, view.this.form, view.this.flags) : view.this.formatCell(view.this.data, j))));
                    if (string != null) {
                        int n5;
                        if (i == 0 && j == 0) {
                            n4 -= view.this.sw;
                        }
                        int n6 = string.length();
                        int n7 = n5 = bl9 ? n4 - n6 * view.this.cw >> 1 : view.this.tv;
                        if (n5 < 0) {
                            n5 = 0;
                        }
                        int n8 = view.this.useDataList ? n6 * view.this.tw : n4 - 1;
                        graphics.setColor(view.this.cbs1);
                        if (bl2 && !bl8 && j != view.this.numCols) {
                            graphics.drawLine(n + n8, n2 + 1, n + n8, n2 + view.this.ch - 2);
                        }
                        if (bl2 && !bl8) {
                            graphics.drawLine(n + 1, n2 + view.this.ch - 1, n + n8 - 2, n2 + view.this.ch - 1);
                        }
                        graphics.setColor(bl10 ? view.this.cwfh : (column.toggle && !bl8 ? column.dcolor : column.color));
                        graphics.drawString(string, n + n5, n2 + view.this.ch - view.this.bh);
                    }
                    n += column.pw;
                }
                n2 += view.this.ch;
            }
            graphics.setColor(bl ? view.this.cbg0 : view.this.cbg1);
            if (n < this.pos.w) {
                graphics.fillRect(n, 0, this.pos.w - n, this.pos.h);
            }
            if (n2 < this.pos.h) {
                graphics.fillRect(0, n2, n, this.pos.h - n2);
            }
            graphics.setColor(view.this.cbs1);
            graphics.drawLine(0, 0, n, 0);
            graphics.drawLine(0, 0, 0, n2);
            graphics.setColor(bl ? view.this.cbg2 : view.this.cbg0);
            graphics.drawLine(0, n2, n, n2);
            graphics.drawLine(n, 0, n, n2);
            if (bl3) {
                Column column = view.this.columns[0];
                view.this.sx = column.px + column.pw - view.this.sw;
                view.this.sy = view.this.ch;
                view.this.sh = n2 - view.this.ch;
                MWView.drawVSlider((int)view.this.sx, (int)view.this.sy, (int)view.this.sw, (int)view.this.sh, (double)(view.this.offset / Math.max(1.0, view.this.size)), (int)0, (Graphics)graphics, (Theme)this.theme);
            }
        }
    }

    private class Column {
        int px;
        int pw;
        int width;
        int soff;
        int sbpa;
        String subr;
        String form;
        String label;
        String sfmt;
        String items;
        Color color;
        Color dcolor;
        Color[] colors;
        String[] letters;
        char type;
        DecimalFormat df;
        MFormat mf;
        boolean toggle;
        boolean menu;
        boolean meter;
        boolean center;

        private Column() {
        }
    }
}

