/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.inc.PicSlave;
import nxm.ice.lib.Archiver;
import nxm.ice.lib.DevIce;
import nxm.ice.lib.ICEPacket;
import nxm.ice.lib.MDevIce;
import nxm.ice.lib.RamDiskResource;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.PacketHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileResource;
import nxm.sys.lib.NFileResource;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.PipeResource;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libg.GValue;

public final class sourcepic
extends Primitive
implements PicSlave,
Keyable {
    public static String replayList = "-NShot,File,Stopped,OneShot,Continuous,StopTop,StopNow,Spin,Archive,Restart,Abort,Finish,NewDevice,Reopen,Reconnect,Release";
    public static int rFILE = -1;
    public static int rSTOPPED = 0;
    public static int rONESHOT = 1;
    public static int rCONTINUOUS = 2;
    public static int rSTOPTOP = 3;
    public static int rSTOPNOW = 4;
    public static int rSPIN = 5;
    public static int rARCHIVE = 6;
    public static int rRESTART = 7;
    public static int rABORT = 8;
    public static int rFINISH = 9;
    public static int rNEWDEVICE = 10;
    public static int rREOPEN = 11;
    public static int rRECONNECT = 12;
    public static int rRELEASE = 13;
    public static int rRESTART_WAIT = 99;
    private static int replayListOffset = -3;
    public static String syncList = "Master,SlaveWait,SlaveRun";
    private static int sMASTER = 1;
    private static int sWAIT = 2;
    private static int sRUN = 3;
    public static String archList = "Off,Open,SnapShot,RealTime";
    private static int aOFF = 0;
    private static int aOPEN = 1;
    private static int aSNAP = 2;
    private static int aRT = 3;
    public static String pktmodeList = "Off,Ice,IceT,SDDS";
    private static int pOFF = 0;
    private static int pICE = 1;
    private static int pICET = 2;
    private static int pSDDS = 3;
    public static String monitorList = "Off,Async,Info,Full";
    private static int mOFF = 0;
    private static int mASYNC = 1;
    private static int mINFO = 2;
    private static int mFULL = 3;
    private long rndx;
    private long ondx;
    private long andx;
    private long ramsz;
    private int rcyc;
    private int ocyc;
    private int acyc;
    private int stats;
    private int pmin;
    private int pmax;
    private int pavg;
    private int ptot;
    private int snaptc;
    private int autors;
    private int renum;
    private int status;
    private int frame;
    private int bytes;
    private int dmamode;
    private int skip;
    private int oskip;
    private int nchan;
    private int nchano;
    private int multi;
    private int chan = 0;
    private int dmac;
    private int port;
    private int bits;
    private int rate;
    private int xfer;
    private int dec;
    private int rfgain;
    private int gain;
    private int replay;
    private int block;
    private int lost;
    private int lostc;
    private int mcs;
    private int vctl;
    private int packet;
    private int apacket;
    private int pktmod;
    private int apktmod;
    private int ptype;
    private int mnbytes;
    private int tinc;
    private int tcmode;
    private int tcpp;
    private int tccnt;
    private int archmode = aOFF;
    private int archtl;
    private int archtc;
    private int archcn;
    private int ipflag;
    private int aipflag;
    private int archsf;
    private int monitor;
    private int maxGain;
    private int minGain;
    private int select = -1;
    private boolean module;
    private boolean tuner;
    private boolean core;
    private boolean host;
    private boolean fdec;
    private boolean flush;
    private boolean autoss;
    private boolean sgo;
    private boolean sss;
    private boolean xts;
    private boolean reset;
    private boolean isSlave;
    private boolean sdds;
    private boolean nodma;
    private boolean rtfile;
    private boolean nyfreq;
    private boolean skiponcard;
    private boolean w2e;
    private boolean isPipe;
    private double freq;
    private double afreq;
    private double dfreq;
    private double rffreq;
    private double mtodo;
    private double delta;
    private double ratio;
    private double drate;
    private double wait;
    private double sfactor;
    private double maxout;
    private double fscale;
    private double tctolr;
    private double tcmaxtolr;
    private double tcows;
    private double tcofs = 0.0;
    private double timer;
    private double timetop;
    private double timeout;
    private double timeRTF;
    private double timecur;
    private double archfs;
    private double archto;
    private double archdur = -1.0;
    private double archoff = -1.0;
    private double syncoff;
    private double timearch;
    private double agcLevel;
    private double agcWidth;
    private double agcTime;
    private double agcPeriod = 0.0;
    private String sport;
    private String alias;
    private String slave;
    private String archfn;
    private String pmss;
    private String apmss;
    private DevIce.TimeCode tc = new DevIce.TimeCode();
    private DevIce.TimeCode tclast = new DevIce.TimeCode();
    private Time tco;
    private Time time = new Time();
    private DataFile hr;
    private DataFile ho;
    private Archiver ha;
    private DevIce.DmaMap map;
    private DevIce.DmaMap smap;
    private ICEPacket pkt;
    private ICEPacket apkt;
    private MDevIce pic;
    private int[] dmacs;
    private int[] ports;
    private int[] gains;
    private PicSlave picSlave;
    private Table keys = new Table();
    private float mbps = 0.0f;
    private byte[] tbuf;
    private GValue gpw;
    private Table archkw;
    int tcretry = 5;
    private Table agcFreqs = null;
    private int agcFreq = 0;
    short[] mcsbuf = new short[8];
    short[] agcbuf;

    /*
     * Unable to fully structure code
     */
    public int open() {
        this.alias = this.MA.getS("DEV");
        this.pic = new MDevIce(this.MA, this.alias);
        if (this.pic.open() <= 0) {
            this.M.error("Problem opening device: " + this.alias);
        }
        this.autors = this.MA.getL("/AUTORS");
        this.autoss = this.MA.getState("/AUTOSS");
        this.renum = this.MA.getL("/RENUM");
        this.sdds = this.MA.getState("/SDDS");
        this.rtfile = this.MA.getState("/RTFILE");
        this.multi = this.MA.getL("/MULTI", 1);
        this.nyfreq = this.MA.getState("/NYFREQ");
        this.w2e = this.MA.getState("/WARN2ERR");
        this.archfn = this.MA.getS("/ARCH");
        this.dmacs = new int[this.multi];
        this.ports = new int[this.multi];
        this.ptype = this.pic.getKeyL(0, 102);
        this.port = this.pic.getKeyL(0, 103);
        this.reset = this.ptype != 0 && this.port != 0 && (this.multi <= 1 || this.autoss != false);
        this.reset = this.MA.getState("/RESET", this.reset);
        this.tinc = this.pic.getKeyL(this.port, 114);
        if (this.ptype == 4) ** GOTO lbl-1000
        if (this.ptype == 9) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        this.tuner = v0;
        if (this.ptype == 7) ** GOTO lbl-1000
        if (this.ptype == 8) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        this.core = v1;
        this.module = this.ptype == 3;
        this.host = this.MA.getState("/HOST", this.module);
        this.nchan = this.ptype == 9 ? this.pic.getKeyL(this.port, 107) : 1;
        this.nchan = this.MA.getL("/NCHN", this.nchan);
        this.nchano = this.MA.getL("/NCHNOUT", this.nchan);
        this.fdec = this.MA.getState("/FRAMEDEC");
        this.gains = new int[this.nchan];
        this.pktmod = sourcepic.pOFF;
        this.apacket = this.MA.getLength("/APACKET");
        if (this.apacket >= 0) {
            this.apmss = this.parsePacketMode(this.MA.getS("/APACKET"));
        }
        this.apktmod = this.pktmod;
        if (this.apktmod == sourcepic.pSDDS) {
            this.apacket = -1;
        }
        this.pktmod = sourcepic.pOFF;
        this.packet = this.MA.getLength("/PACKET");
        if (this.packet >= 0) {
            this.pmss = this.parsePacketMode(this.MA.getS("/PACKET"));
        }
        if (this.pktmod == sourcepic.pOFF && this.apktmod == sourcepic.pSDDS) {
            this.pktmod = this.apktmod;
            this.pmss = this.apmss;
        }
        if (this.pktmod == sourcepic.pSDDS) {
            this.packet = -1;
        }
        this.ipflag = 2 | (this.pktmod == sourcepic.pICET ? 1 : 0);
        this.aipflag = 2 | (this.apktmod == sourcepic.pICET ? 1 : 0);
        this.mcs = this.pic.getIntFlagDef("MCS", 0);
        this.vctl = this.pic.getIntFlagDef("VCTL", -1);
        this.hr = this.MA.getDataFile("IN");
        this.hr.open(3);
        this.hr.setOutput(false);
        v2 = this.frame = this.hr.typeClass == 2 ? this.hr.getSubSize() : 1;
        if (this.pktmod == sourcepic.pSDDS) {
            this.frame = this.frame * 1088 / 1024;
        }
        this.bits = this.hr.bps > 0 ? this.hr.bps * 8 : -this.hr.bps;
        if (this.hr.spa == 2) {
            this.bits = -this.bits;
        }
        this.bits = this.MA.getL("/BITS", this.bits);
        this.dec = Math.max(1, this.MA.getL("DEC"));
        this.skip = Math.max(1, this.MA.getL("/SKIP"));
        this.skiponcard = this.module != false && this.host == false && this.dec == 1 && this.skip > 1;
        this.skiponcard = this.MA.getState("/SKIPONCARD", this.skiponcard);
        v3 = this.skiponcard = this.MA.getState("/SKIPONHOST", this.skiponcard == false) == false;
        if (this.module && this.host && this.dec > 1 && !this.skiponcard) {
            this.skip *= this.dec;
            this.dec = 1;
        }
        this.oskip = this.skiponcard != false ? 1 : this.skip;
        this.delta = this.hr.getXDelta();
        this.ratio = this.MA.getD("/RATIO");
        if (this.ratio > 0.0) {
            this.pic.setKeyD(0, 13, this.ratio);
        }
        this.xfer = this.frame * this.MA.getL("/TL", this.frame > 1 ? 1 : 4096);
        this.replay = this.M.pipeMode == 1 ? sourcepic.rCONTINUOUS : sourcepic.rFILE;
        this.replay = this.MA.getSelectionIndex("/REPLAY", sourcepic.replayList, this.replay, sourcepic.replayListOffset);
        this.flush = this.MA.getState("/FLUSH");
        this.wait = this.MA.getD("/WAIT");
        this.timeout = this.MA.getD("/TIMEOUT", 2.0);
        this.maxout = this.MA.getD("/MAXOUT");
        this.pkt = new ICEPacket(this.hr.getFormat(), this.xfer, this.ipflag);
        this.pkt.setChannel(this.renum > 0 ? this.renum : this.port);
        this.ho = this.MA.getDataFile("OUT", this.hr, 0);
        this.ho.setYDelta(this.delta * (double)this.frame * (double)this.skip);
        this.ho.size = (this.hr.size - 1.0) / (double)this.oskip + 1.0;
        this.ho.setDataRep(this.hr.getDataRep());
        if (this.pktmod == sourcepic.pICE || this.pktmod == sourcepic.pICET) {
            this.ho.setPacketHandler((PacketHandler)this.pkt);
            if (this.packet > 0) {
                this.ho.setPacket(this.ho.getPacket() + this.pmss);
            }
        }
        this.ho.open(128 | 64);
        if (this.pktmod == sourcepic.pSDDS) {
            this.ho.keywords.putMain("PACKET", this.pmss);
        }
        this.isPipe = this.ho.isPipe();
        this.hr.setFS(0);
        this.hr.update();
        this.ramsz = (long)this.hr.size;
        if ((this.ramsz % (long)this.xfer != 0L || this.ramsz == (long)this.xfer) && this.ho.isOpen) {
            this.M.info((CharSequence)("Ram size=" + this.ramsz + " not a multiple>1 of /TL=" + this.xfer + ". Allow for frame offsets."));
        }
        this.bytes = (int)((double)this.xfer * this.hr.dbpe);
        this.block = this.MA.getL("/BLOCK", this.bytes);
        if (this.oskip > 1 || this.dec > 1) {
            this.block = -1;
        }
        this.drate = 1.0 / this.delta;
        if (this.tuner) {
            this.drate = (double)(this.hr.spa * this.dec) / this.delta;
        }
        if (this.core && !this.fdec) {
            this.drate = (double)this.dec / this.delta;
        }
        if (this.ratio > 0.0) {
            this.drate /= this.ratio;
        }
        if (this.pic.getIntFlagDef("PRER2C", 0) > 0) {
            this.drate *= 2.0;
        }
        this.drate = this.MA.getD("/SRATE", this.drate);
        this.freq = this.MA.getD("FREQ", 0.0);
        this.dfreq = this.MA.getD("/DFREQ", 0.0);
        this.gain = this.MA.getL("GAIN");
        this.fscale = this.nyfreq != false ? 1.0 : 2.0 / this.drate;
        var1_1 = this.MA.getTable("/AGC");
        if (var1_1 != null) {
            this.setAGC(var1_1);
        }
        this.rate = (int)Math.round(this.drate);
        this.gains = new int[this.nchan];
        for (var2_2 = 0; var2_2 < this.nchan; ++var2_2) {
            this.gains[var2_2] = this.gain;
        }
        this.time.fromCurrent();
        this.tcmode = this.pic.getKeyL(0, 116);
        if (this.tcmode != 0) {
            this.pic.setKeyD(0, 9, this.time.getWSec(), this.time.getFSec(), -1.0);
        }
        if (this.tcmode == 1) ** GOTO lbl-1000
        if (this.tcmode == 12) ** GOTO lbl-1000
        if (this.tcmode == 8) lbl-1000:
        // 3 sources

        {
            this.tcows = 0.0;
        } else {
            this.tcows = this.time.getYiS();
        }
        this.tco = this.MA.getTime("/TCOFF");
        if (this.tco != null) {
            this.tcows = this.tco.getWSec();
            this.tcofs = this.tco.getFSec();
        }
        this.tctolr = this.MA.getD("/TCTOLR");
        this.tcmaxtolr = this.MA.getD("/TCMAXTOLR");
        var2_3 = this.MA.getD("/TCPS");
        var4_4 = var2_3 > 0.0 ? 1.0 / (var2_3 * this.delta) : this.hr.size / 2.0 / (double)Math.max(this.multi, this.nchan);
        this.tcpp = Math.max(1, (int)Math.round(var4_4 / (double)(this.multi * this.xfer * this.skip)));
        this.tcpp = this.MA.getL("/TCPP", this.tcpp);
        this.tcpp *= this.oskip;
        this.slave = this.MA.getS("/SLAVE", "NONE");
        this.isSlave = this.slave.equals("NONE") == false;
        this.sss = this.slave.equals("SS");
        this.xts = this.slave.equals("XT");
        this.sgo = this.isSlave != false && this.sss == false && this.xts == false;
        this.slave = this.MA.getS("/MASTER", null);
        this.status = this.reset != false ? this.pic.reset(0) : 1;
        if (this.status < 0) {
            this.M.error("Problem resetting device");
        }
        this.map = this.pic.mapFile(this.hr);
        if (this.map == null) {
            this.M.error("Problem mapping DMA memory");
        }
        if (this.multi > 1 || !this.MA.getState("/PAGED", true)) {
            this.map.setPaged(false);
        }
        if (this.ptype == 1) {
            this.map.setPaged(false);
            this.map.getVirtualAddress(0L, (int)this.map.bytes);
        }
        this.openPorts();
        this.MR.put(this.MA.getU("/DMAC"), this.dmac);
        v4 = this.nodma = this.pic.getKeyL(this.dmac, 37) > 0;
        if (this.skiponcard) {
            this.pic.setKeyL(this.dmac, 6, this.frame * this.nchano);
            this.pic.setKeyL(this.dmac, 28, this.skip);
        }
        if (this.ratio > 0.0) {
            this.setRatio(this.ratio);
        }
        this.sport = this.pic.getPortKey();
        this.hr.keywords.put("PORT", (Object)this.sport);
        if (this.archfn != null) {
            this.hr.keywords.put("ARCHIVE", (Object)this.getArchFN());
        }
        if (this.pic.getDblFlagDef("RFFREQ", 0.0) > 0.0) {
            this.rffreq = this.pic.getKeyD(this.dmac, 61);
            this.hr.keywords.put("D:RFFREQ", (Object)this.rffreq);
            this.rfgain = this.pic.getKeyL(this.dmac, 62);
            this.hr.keywords.put("L:RFGAIN", (Object)this.rfgain);
        }
        if (this.multi > 1) {
            this.hr.keywords.put("L:MULTI", (Object)this.multi);
        }
        if (this.nchan > 1) {
            this.hr.keywords.put("L:NCHAN", (Object)this.nchan);
        }
        if (this.tuner) {
            this.hr.keywords.put("D:FREQ", (Object)this.freq);
        }
        this.hr.update();
        if (this.isSlave) {
            this.replay = sourcepic.rSTOPPED;
        }
        if (!this.MA.find("/POLL")) {
            this.setPollTime(0.025);
        }
        this.dmamode = 0;
        this.mtodo = this.smap.bytes;
        this.todo = 0.0;
        this.acyc = 0;
        this.ocyc = 0;
        this.andx = 0L;
        this.ondx = 0L;
        this.sfactor = 100.0 / (double)this.smap.bytes;
        if ((long)(this.bytes * this.oskip) > this.smap.bytes) {
            this.M.error("Skip cannot be greater than one buffer");
        }
        if (this.rtfile) {
            this.updateRTF(true);
        }
        this.archtl = this.MA.getL("/ARCHTL", 131072);
        this.archto = this.MA.getL("/ARCHTO", -1);
        this.archsf = this.MA.getL("/ARCHSF", 0);
        this.archfs = this.MA.getD("/ARCHSFS", -1.0);
        this.archcn = this.MA.getL("/ARCHCHN");
        this.archkw = this.MA.getTable("/ARCHKW");
        if (this.archsf != 0 && this.archsf == 1) {
            this.archsf = -1;
        }
        if (this.nchano > 1 && (this.apacket >= 0 || this.archcn >= 0)) {
            this.archtl = this.xfer;
        }
        this.apkt = new ICEPacket(this.ho.getFormat(), this.archtl, this.aipflag);
        if (this.apktmod == sourcepic.pSDDS) {
            this.archtl = this.archtl * 1088 / 1024;
        }
        this.startArch(this.archfn, this.archoff, this.archdur);
        this.setDelta(this.delta);
        this.stats = this.MA.getL("/STATS");
        var6_5 = this.MA.getO("/GPWR");
        if (var6_5 instanceof GValue) {
            this.gpw = (GValue)var6_5;
        }
        if (this.gpw != null) {
            this.gpw.setValue(0.0);
        }
        this.monitor = this.MA.getSelectionIndex("/MONITOR", sourcepic.monitorList, sourcepic.mFULL, -1);
        this.setKeys(this.MA.getTable("/PICKEYS"));
        return 0;
    }

    public synchronized int process() {
        int n;
        int n2;
        int n3;
        int n4;
        this.timecur = Time.current();
        if (this.rtfile) {
            this.updateRTF(false);
        }
        if (this.replay == rABORT) {
            return 9;
        }
        if (this.replay == rRELEASE) {
            for (n4 = 0; n4 < this.multi; ++n4) {
                this.pic.dmaFunc(this.dmacs[n4], -8);
            }
            this.replay = rSTOPPED;
        }
        if (this.todo == 0.0) {
            if (this.replay == rSTOPTOP || this.replay == rSTOPNOW) {
                this.replay = rSTOPPED;
            }
            if (this.replay == rSTOPPED) {
                return -1;
            }
            if (this.replay == rFINISH) {
                return 9;
            }
            if (this.replay == rRESTART && this.autors >= 2) {
                Time.sleep((double)0.2);
                this.pic.dmaFunc(this.dmac, -15);
                this.replay = rRESTART_WAIT;
                this.timer = Time.current();
            }
            if (this.replay == rRESTART_WAIT) {
                if (this.pic.dmaFunc(this.dmac, -12) == 0) {
                    Time.sleep((double)0.2);
                } else {
                    if (Time.current() - this.timer < this.timeout + 1.0) {
                        return -1;
                    }
                    if (this.autors >= 3) {
                        this.pic.dmaFunc(this.dmac, -16);
                    }
                    this.warning("All DMA channels on this input did not shut down");
                    Time.sleep((double)0.5);
                }
                this.replay = rCONTINUOUS;
            }
            this.lostc = 0;
            this.lost = 0;
            this.acyc = 0;
            this.ocyc = 0;
            this.rcyc = 0;
            this.andx = 0L;
            this.ondx = 0L;
            this.rndx = 0L;
            this.pmin = 100;
            this.pmax = 0;
            this.ptot = 0;
            this.pkt.setCount(0);
            this.apkt.setCount(0);
            int n5 = this.nodma ? -20 : (this.replay == rONESHOT ? 1 : (n4 = -2));
            if (this.slave != null) {
                this.setSlaveReplay(this.replay, n4);
            }
            if (this.wait > 0.0) {
                Time.sleep((double)this.wait);
            }
            if (this.stats > 0) {
                this.M.info((CharSequence)("Sourcepic-" + this.dmac + " START"));
            }
            for (int i = this.multi - 1; i >= 0; --i) {
                this.pic.dmaFunc(this.dmacs[i], n4);
            }
            this.dmamode = n4;
            this.todo = this.mtodo;
            this.snaptc = 1;
            this.tc.initMetrics();
            this.tclast.initMetrics();
            this.timearch = this.agcTime = (this.timecur = Time.current());
            this.timetop = this.agcTime;
            this.timer = this.agcTime;
        }
        if (this.ha.isOpen && this.archto > 0.0 && this.timecur - this.timearch > this.archto) {
            this.ha.checkChannels();
            this.ha.flush();
            this.timearch = this.timecur;
        }
        if (this.archmode == aOPEN) {
            this.startArch(this.archfn, this.archoff, this.archdur);
        }
        if (this.replay == rSPIN) {
            return -1;
        }
        long l = this.pic.dmaFuncX(this.dmac, -4);
        if (l == -1L) {
            if (this.pic.getKeyL(0, 147) < 0) {
                this.replay = rSTOPNOW;
            }
        }
        if (this.replay == rSTOPNOW || this.replay == rRESTART || this.replay == rFINISH) {
            this.todo = 0.0;
        }
        if (this.agcPeriod > 0.0 && !this.tuner && this.timer - this.agcTime > this.agcPeriod) {
            this.processWBAGC();
        }
        if (this.todo > 0.0) {
            int n6;
            if (l < this.rndx) {
                this.rcyc = this.pic.dmaFunc(this.dmac, -5);
            }
            if (this.rcyc - this.ocyc > 10 || this.ocyc - this.rcyc > 10) {
                this.warning("Probable bad rcyc=" + this.rcyc + " ocyc=" + this.ocyc + " read");
                this.rcyc = this.pic.dmaFunc(this.dmac, -5);
            }
            this.rndx = l;
            n3 = this.rcyc - (this.ocyc + this.lost);
            if (n3 > 1 || n3 == 1 && this.rndx > this.ondx) {
                this.warning("Falling behind " + n3 + " buffers. Rcyc=" + this.rcyc + " Ocyc=" + this.ocyc + " Lost=" + this.lost + " ID=" + this.id);
                this.lost = this.rcyc - this.ocyc;
            }
            int n7 = n2 = this.bytes * this.nchano;
            if (this.ha.isOpen) {
                n7 *= this.oskip;
            }
            if (this.ondx + (long)n7 > this.smap.bytes) {
                n7 = (int)(this.smap.bytes - this.ondx);
            }
            if (this.rcyc < this.ocyc + this.lost || this.rndx < this.ondx + (long)n7 && this.rcyc <= this.ocyc + this.lost) {
                if (this.timeout <= 0.0 || this.timecur - this.timer < this.timeout) {
                    return -1;
                }
                this.warning("Detected DMA stall > timeout. Rcyc=" + this.rcyc + " Ocyc=" + this.ocyc + " Lost=" + this.lost);
                if (this.autors > 0) {
                    this.setReplay(rRESTART);
                }
                this.timer = this.timecur;
                return -1;
            }
            for (n = 1; n < this.multi; ++n) {
                l = this.pic.dmaFuncX(this.dmacs[n], -4);
                if (l >= this.ondx + (long)n7 || this.rcyc > this.ocyc + this.lost) continue;
                return -1;
            }
            if (this.tcmode != 0) {
                this.processTimeCode();
            }
            if (this.ho.isOpen) {
                long l2 = this.ondx + (long)n2 > this.smap.bytes ? this.map.getVirtualAddress(this.ondx - (long)n2, n2) : this.map.getVirtualAddress(this.ondx, n2);
                if (this.nchano > 1 || this.mcs > 0) {
                    if (this.packet < 0) {
                        this.ho_write(l2, 0, n2);
                    } else {
                        for (n6 = 0; n6 < this.nchano; ++n6) {
                            if (this.mcs > 0) {
                                this.pkt.setChannel(this.getMCSchn(l2, n6, this.bytes));
                            } else {
                                this.pkt.setChannel(n6 + 1);
                            }
                            this.ho_write(l2, 0 + n6 * this.bytes, this.bytes);
                        }
                    }
                } else if (this.multi > 1) {
                    for (n6 = 0; n6 < this.multi; ++n6) {
                        this.pkt.setChannel(this.renum > 0 ? this.renum + n6 : this.ports[n6]);
                        this.ho_write(l2, 0 + n6 * (int)this.smap.bytes, this.bytes);
                    }
                } else {
                    this.ho_write(l2, 0, this.bytes);
                }
                if (this.maxout > 0.0 && this.ho.seek() >= this.maxout) {
                    return 9;
                }
            }
            if (this.ha.isOpen) {
                l = this.ondx + (long)n7;
                n2 = (int)((double)this.archtl * this.ha.dbpe);
                if (this.nchano > 1 && (this.apacket >= 0 || this.archcn >= 0)) {
                    n2 *= this.nchano;
                }
                while (this.acyc < this.ocyc || this.acyc == this.ocyc && this.andx + (long)n2 <= l) {
                    long l3 = this.map.getVirtualAddress(this.andx, n2);
                    if (this.nchano > 1) {
                        if (this.archcn == -2) {
                            this.ha.write(l3, 0, n2, -2);
                        } else if (this.apacket < 0 && this.archcn < 0) {
                            this.ha.write(l3, 0, n2, -1);
                        } else {
                            for (n6 = 0; n6 < this.nchano; ++n6) {
                                this.apkt.setChannel(n6 + 1);
                                if (this.archcn >= 0 && n6 != this.archcn) continue;
                                this.ha.write(l3, 0 + n6 * this.bytes, this.bytes, n6);
                            }
                        }
                    } else if (this.multi == 1) {
                        this.ha.write(l3, 0, n2, -1);
                    } else {
                        for (n6 = 0; n6 < this.multi; ++n6) {
                            this.apkt.setChannel(this.renum > 0 ? this.renum + n6 : this.ports[n6]);
                            this.ha.write(l3, 0 + n6 * (int)this.smap.bytes, n2, n6);
                        }
                    }
                    this.apkt.upCount();
                    this.apkt.decTCO(this.archtl);
                    this.andx += (long)n2;
                    if (!((double)this.andx >= this.mtodo)) continue;
                    ++this.acyc;
                    this.andx = 0L;
                }
                if (this.archmode == aSNAP && this.ha.seek() * this.delta > this.archdur) {
                    this.archmode = aOFF;
                }
                if (this.archmode == aOFF) {
                    this.stopArch();
                }
                if (this.ha.isFinished()) {
                    return 9;
                }
            }
            this.ondx += (long)(this.bytes * this.nchano * this.oskip);
            this.todo = this.mtodo - (double)this.ondx;
            this.pkt.decTCO(this.xfer * this.skip);
            this.pkt.upCount(this.skip);
            this.time.addSec(this.delta * (double)this.xfer * (double)this.skip);
            this.timer = this.timecur;
        }
        if (this.todo <= 0.0) {
            if (this.replay == rONESHOT) {
                if (this.pic.dmaFunc(this.dmac, -13) != 0) {
                    this.todo = -1.0;
                    return -1;
                }
            }
            ++this.ocyc;
            this.todo = 0.0;
            this.ondx -= this.smap.bytes;
            int n8 = n3 = this.replay == rSTOPNOW || this.replay == rRESTART || this.replay == rFINISH ? 1 : 0;
            if (n3 == 0) {
                this.mbps = (float)(1.0E-6 * (double)this.multi * (double)this.smap.bytes / Math.max(0.01, this.timer - this.timetop));
            }
            if (this.stats > 0 && n3 == 0) {
                n2 = 0;
                if (this.pic.dmaFunc(this.dmac, -5) == this.ocyc + this.lost) {
                    n2 = (int)Math.round(this.sfactor * (double)this.pic.dmaFuncX(this.dmac, -22));
                }
                if (n2 == 100) {
                    n2 = 0;
                }
                if (n2 < this.pmin) {
                    this.pmin = n2;
                }
                if (n2 > this.pmax) {
                    this.pmax = n2;
                }
                this.ptot += n2;
                if (this.ocyc % this.stats == 0) {
                    this.pavg = this.ptot / this.stats;
                    String string = "CYC=" + this.ocyc + ",LOST=" + this.lost + ",FAVG=" + this.pavg;
                    if (this.sdds) {
                        n = this.pic.getKeyL(this.dmac, 39);
                        string = string + ",GMIN=" + (n & 0xFFFF) + ",GMAX=" + (n >> 16 & 0xFFFF);
                    } else if (this.stats > 1) {
                        string = string + ",FMIN=" + this.pmin + ",FMAX=" + this.pmax;
                    }
                    this.M.info((CharSequence)("Sourcepic-" + this.dmac + " STATS={" + string + ",MBPS=" + this.mbps + "}"));
                    this.pmin = 100;
                    this.pmax = 0;
                    this.ptot = 0;
                }
            }
            this.timetop = this.timer;
            if (this.agcPeriod != 0.0 && this.tuner) {
                this.processNBAGC();
            }
            if (this.ha.isOpen && this.flush) {
                this.ha.flush();
            }
            if ((n2 = this.pic.dmaFunc(this.dmac, -10)) > this.lostc) {
                this.warning("Sourcepic-" + this.dmac + " LOST=" + (n2 - this.lostc) + " card buffers");
                this.lostc = n2;
            }
            if (this.replay < rFILE) {
                ++this.replay;
                this.todo = this.mtodo;
                return 0;
            }
            if (this.replay == rCONTINUOUS) {
                this.todo = this.mtodo;
                return 0;
            }
            if (this.replay == rRESTART && this.autors >= 2) {
                Time.sleep((double)0.2);
                this.pic.dmaFunc(this.dmac, -15);
            }
            if (this.stats > 0) {
                this.M.info((CharSequence)("Sourcepic-" + this.dmac + " STOP"));
            }
            for (int i = 0; i < this.multi; ++i) {
                this.pic.dmaFunc(this.dmacs[i], 0);
                this.pic.dmaFunc(this.dmacs[i], -8);
            }
            this.dmamode = 0;
            if (this.slave != null) {
                this.setSlaveReplay(this.replay, this.dmamode);
            }
            if (this.replay == rFILE || this.replay == rFINISH) {
                return 9;
            }
            if (this.replay == rONESHOT) {
                if (this.snaptc < 0) {
                    this.hr.update();
                }
                if (this.flush) {
                    this.flushRamBuffer();
                }
                this.rcyc = 1;
            }
            this.replay = this.replay != rRESTART ? rSTOPPED : (this.autors >= 2 ? rRESTART_WAIT : rCONTINUOUS);
            this.timer = this.timecur;
            if (this.ha.isOpen) {
                this.ha.checkChannels();
            }
            if (this.ha.isOpen) {
                this.ha.discontinue();
            }
        }
        if (this.gpw != null) {
            this.gpw.setValue(this.getProgress());
        }
        return 0;
    }

    public int close() {
        if (this.dmamode != 0 && this.stats > 0) {
            this.M.info((CharSequence)"Sourcepic CANCEL");
        }
        for (int i = 0; i < this.multi; ++i) {
            if (this.dmacs == null || this.dmacs[i] <= 0) continue;
            this.pic.dmaFunc(this.dmacs[i], -9);
        }
        this.stopArch();
        if (this.gpw != null) {
            this.gpw.setValue(1.0);
        }
        if (this.hr != null) {
            this.hr.close();
        }
        if (this.ho != null) {
            this.ho.close();
        }
        if (this.map != null) {
            this.map.close();
        }
        if (this.pic != null) {
            this.pic.close();
        }
        this.replay = rSTOPPED;
        this.dmamode = 0;
        return 0;
    }

    private void warning(String string) {
        if (this.w2e) {
            this.M.error(string);
        } else {
            this.M.warning((CharSequence)string);
        }
    }

    private void ho_write(long l, int n, int n2) {
        long l2;
        if (this.monitor == mOFF) {
            return;
        }
        if (this.isPipe && (l2 = this.ho.io.avail()) < (long)n2 && n2 <= ((PipeResource)this.ho.io).pipeSize) {
            for (int i = 0; i < 20 && l2 < (long)n2; ++i) {
                Time.sleep((double)0.01);
                l2 = this.ho.io.avail();
            }
            if (l2 <= (long)n2) {
                if (this.monitor == mINFO) {
                    this.M.info((CharSequence)"Dropping monitor frame");
                } else {
                    return;
                }
            }
        }
        this.ho.write(l, n, n2);
    }

    private void flushRamBuffer() {
        if (this.hr.io instanceof RamDiskResource) {
            return;
        }
        int n = (int)(this.hr.size * this.hr.dbpe);
        this.hr.setOutput(true);
        this.hr.seek(0.0);
        long l = this.map.getVirtualAddress(0L, n);
        this.hr.write(l, 0, n);
        this.hr.setOutput(false);
    }

    private void updateRTF(boolean bl) {
        if (bl) {
            this.timeRTF = Time.current();
        } else if (this.timecur - this.timeRTF < 0.05) {
            return;
        }
        this.timeRTF = this.timecur;
        if (this.snaptc < 0) {
            sourcepic.setTime(this.hr, this.tc.wsec, this.tc.fsec - this.tc.offset * this.delta);
        }
        double d = this.getBytes();
        this.hr.setInByte(d);
        this.hr.ioh.write(this.hr.hb, 80, 8, 80L);
        this.hr.ioh.read(this.hr.hb, 88, 8, 88L);
        double d2 = (d - this.hr.getOutByte(0)) / (double)this.map.bytes;
        if (this.vctl > 0) {
            this.pic.setKeyD(this.dmac, 174, d2);
        }
    }

    private void openPorts() {
        int n;
        if (this.ptype == 9) {
            n = this.MA.getL("/PKTLEN", this.bytes);
            this.pic.setKeyL(this.port, 107, this.nchan);
            this.pic.setKeyL(this.port, 19, n);
            this.pic.setKeyD(this.port, 20, this.dfreq * this.fscale);
        }
        for (n = 0; n < this.multi; ++n) {
            int n2 = 0;
            if (n == 0) {
                if (this.sgo) {
                    n2 = 0x100000;
                }
                if (this.sss) {
                    n2 = 0x40000000;
                }
                if (this.xts) {
                    n2 = 0x800000 | 0x200000;
                }
            } else {
                n2 = n == 1 && !this.autoss ? 0x100000 : 0x40000000;
            }
            double d = (this.freq + (double)n * this.dfreq) * 2.0 / (double)this.rate;
            this.dmac = this.pic.ioPort(this.ptype, this.port, -1, -1, this.bits, this.rate, d, this.dec, this.gain, n2);
            if (this.dmac <= 0) {
                this.M.error("Problem setting up IO port");
            }
            this.smap = this.map.getSubMap(n, this.multi);
            this.status = this.pic.dmaSetup(this.dmac, -1, this.smap, this.block, 0);
            if (this.status < 0) {
                this.M.error("Problem setting up DMA channel " + this.status);
            }
            this.dmacs[n] = this.dmac;
            this.ports[n] = this.port++;
            if (this.autoss) {
                this.port += this.tinc;
                continue;
            }
            if (n % 2 == 0) continue;
            this.port = this.port - 1 + this.tinc;
        }
        this.dmac = this.dmacs[0];
        this.port = this.ports[0];
        this.afreq = this.pic.getKeyD(this.dmac, 2) / this.fscale;
    }

    private String parsePacketMode(String string) {
        String string2 = string == null || string.length() == 0 ? "ICE" : (string.startsWith("DET") ? "ICE/" + string : (string.equals("SDDS") ? "SDDS/ICE" : string));
        if (string2.startsWith("SDDS")) {
            this.pktmod = pSDDS;
        } else if (string2.startsWith("ICET")) {
            this.pktmod = pICET;
            string2 = string2.substring(4);
        } else if (string2.startsWith("ICE")) {
            this.pktmod = pICE;
            string2 = string2.substring(3);
        } else {
            this.M.error("Illegal Packet Mode Switch String: " + string);
        }
        return string2;
    }

    private void processTimeCode() {
        int n;
        if (this.snaptc > 0 && this.snaptc < this.tcretry) {
            ++this.snaptc;
        } else if (this.archtc > 0 && this.archtc < this.tcretry) {
            ++this.archtc;
        } else {
            this.tccnt += this.oskip;
            if (this.tccnt < this.tcpp) {
                return;
            }
            this.tccnt -= this.tcpp;
        }
        int n2 = this.pic.tc(this.dmac, -1.0, this.delta, this.tc, 0);
        if (this.tcmode != 1 && n2 > 0 && this.tc.wsec < 100.0 && ((n = (int)Math.round(-(this.tc.diff(this.tclast) + this.tcows) / 86400.0)) == 365 || n == 366)) {
            this.tcows += (double)(n * 86400);
        }
        this.tc.wsec += this.tcows;
        this.tc.fsec += this.tcofs;
        double d = (double)(this.ocyc + this.lost) * this.mtodo;
        int n3 = this.skiponcard ? this.skip : 1;
        double d2 = this.tc.offset - (double)n3 * (d + (double)this.ondx) / (double)this.hr.bpa / (double)this.nchano;
        this.pkt.setTC(this.tcmode, n2, d2, this.tc.wsec, this.tc.fsec);
        if (n2 == -7) {
            this.warning("Time code NOCLOCK err detected");
            if (this.autors > 0) {
                this.setReplay(rRESTART);
            }
        }
        if (n2 < 0 && n2 != -9) {
            return;
        }
        if (this.tctolr > 0.0 && this.tclast.delta >= 0.0) {
            double d3 = this.tc.err(this.tclast);
            if (this.tcmaxtolr > 0.0 && Math.abs(d3) > this.tcmaxtolr) {
                this.warning("Time code slip=" + d3 + " > maxtolr=" + this.tcmaxtolr + ". Assumed bogus and ignored");
                this.tclast.update(this.tc);
                return;
            }
            if (Math.abs(d3) > this.tctolr) {
                this.warning("Time code slip=" + d3 + " > tolr=" + this.tctolr + " delta=" + this.tc.delta);
                if (this.autors > 0) {
                    this.setReplay(rRESTART);
                }
            }
        }
        this.tc.computeMetrics(this.tclast, this.delta);
        if (this.snaptc > 0) {
            this.snaptc = -1;
            sourcepic.setTime(this.hr, this.tc.wsec, this.tc.fsec - this.tc.offset * this.delta);
            this.hr.update();
            sourcepic.setTime(this.ho, this.tc.wsec, this.tc.fsec - this.tc.offset * this.delta);
        }
        this.ho.setTimeAt(this.tc.wsec + (this.tc.fsec - d2 * this.delta));
        if (this.ha.isOpen) {
            d2 = this.tc.offset - (d + (double)this.andx) / (double)this.hr.bpa / (double)this.nchano;
            if (this.archtc != 0) {
                this.archtc = 0;
                this.ha.setTime(this.tc.wsec, this.tc.fsec - (this.tc.offset - this.archoff) * this.delta);
            }
            this.apkt.setTC(this.tcmode, n2, d2, this.tc.wsec, this.tc.fsec);
            this.ha.setTimeAt(this.tc.wsec + (this.tc.fsec - d2 * this.delta));
        }
        this.pkt.getTC(this.time, 0.0, this.delta);
        this.tclast.update(this.tc);
    }

    public void setArchFN(String string) {
        this.archfn = string;
    }

    public void setArchDur(double d) {
        this.archdur = d;
    }

    public void setArchOff(double d) {
        this.archoff = d;
    }

    public void setSyncOff(double d) {
        this.syncoff = ((double)this.rcyc * this.mtodo + (double)this.rndx) / (double)this.hr.bpa;
    }

    public void setArchMode(String string) {
        this.setArchMode(Parser.find((String)archList, (String)string, (int)this.archmode, (int)-1));
    }

    private void setArchMode(int n) {
        if (n == aOFF) {
            this.stopArchiver();
        } else if (this.archmode != aOFF) {
            this.warning("Cannot restart an archive without stopping first");
        } else if (n == aSNAP) {
            if (this.archdur < 0.0) {
                this.archdur = this.hr.getLength();
            }
            this.archmode = aOPEN;
        } else if (n == aRT) {
            this.archdur = -1.0;
            this.archmode = aOPEN;
        } else {
            this.archmode = n;
        }
    }

    public void startArchiver(String string) {
        this.archfn = string;
        this.startArchiver();
    }

    public void startArchiver(String string, double d) {
        this.archfn = string;
        this.archdur = d;
        this.startArchiver();
    }

    public void startArchiver(String string, double d, double d2) {
        this.archfn = string;
        this.archoff = d;
        this.archdur = d2;
        this.startArchiver();
    }

    public void startArchiver() {
        this.setArchMode(aOPEN);
    }

    public void stopArchiver() {
        this.archmode = aOFF;
    }

    private void startArch(String string, double d, double d2) {
        this.stopArch();
        this.ha = new Archiver(this);
        if (string == null || string.length() == 0 || string.startsWith("NULL")) {
            return;
        }
        if (this.ramsz <= (long)this.archtl) {
            this.M.error("Ram buffer length=" + this.ramsz + " must be increased to at least 2x the /ARCHTL=" + this.archtl);
        }
        if (this.ramsz % (long)this.archtl != 0L) {
            this.M.error("Ram size=" + this.ramsz + " must be an integer multiple>1 of /ARCHTL=" + this.archtl);
        }
        if (this.MA.getL("/SDDSMULTI") > 0) {
            this.M.error("Switch /SDDSMULTI=n deprecated. Replace with file qualifier {FUNC=SDDSUNPACK,MULTI=n}");
        }
        this.ha.init((MidasReference)this, string, this.hr, 0);
        if (this.multi > 1) {
            this.ha.setMulti(this.multi);
        }
        if (this.nchan > 1) {
            this.ha.setNChan(this.nchan);
        }
        if (this.archsf != 0) {
            this.ha.setMulti(-1);
            this.ha.setMaxLines(this.archsf);
            this.ha.setMaxLineSize(this.archfs > 0.0 ? this.archfs : (double)this.map.bytes);
        }
        if (this.apacket >= 0) {
            this.apkt.setCount(0);
            this.ha.setPacketHandler(this.apkt);
        }
        if (this.apacket > 0) {
            this.ha.setPacket(this.ha.getPacket() + this.apmss);
        }
        this.ha.setFS(0);
        this.ha.open(0x80 | 0x40);
        if (!this.ha.isOpen) {
            return;
        }
        if (this.apktmod == pSDDS) {
            this.ha.keywords.putMain("PACKET", this.apmss);
        }
        if (this.ha.io instanceof FileResource && !(this.ha.io instanceof NFileResource)) {
            this.warning("UhOh. Using slower non-native file access.  Check installation.");
        }
        this.archmode = d2 > 0.0 ? aSNAP : aRT;
        this.archtc = 1;
        int n = (int)((double)this.archtl * this.ha.dbpe);
        if (this.archoff >= 0.0) {
            this.archoff *= (double)this.hr.bpa;
            this.acyc = (int)(this.archoff / this.mtodo);
            this.andx = (long)(this.archoff - (double)this.acyc * this.mtodo);
            this.andx = this.andx / (long)n * (long)n;
        } else {
            this.acyc = this.ocyc;
            this.andx = this.ondx / (long)n * (long)n;
        }
        this.archoff = ((double)this.acyc * this.mtodo + (double)this.andx) / (double)this.hr.bpa;
        this.ha.keywords.put("D:ARCHOFF", (Object)this.archoff);
    }

    private void stopArch() {
        this.archmode = aOFF;
        this.archoff = -1.0;
        if (this.ha != null && this.ha.isOpen) {
            this.ha.close();
        }
    }

    @Override
    public void setReplay(String string) {
        if (string.equalsIgnoreCase("STOP")) {
            string = "STOPNOW";
        }
        if (string.equalsIgnoreCase("START")) {
            string = "CONTINUOUS";
        }
        int n = Parser.find((String)replayList, (String)string, (int)this.replay, (int)replayListOffset);
        this.setReplay(n);
    }

    private void setReplay(int n) {
        if (n == 0 && this.replay != 0) {
            this.replay = rSTOPNOW;
        } else if (n == rRESTART && this.replay == 0) {
            this.replay = rCONTINUOUS;
        } else if (n == rONESHOT && this.replay == rCONTINUOUS) {
            this.replay = rSTOPTOP;
        } else if (n >= rNEWDEVICE && this.replay != 0) {
            this.warning("Port must be Stopped to perform NewDevice|Reopen|Reconnect");
        } else {
            this.replay = n;
        }
        if (this.replay == rSTOPNOW) {
            this.process();
        }
        if (this.replay == rRECONNECT) {
            this.openPorts();
            this.replay = 0;
        }
        if (this.replay >= rABORT && this.slave != null) {
            this.setSlaveReplay(this.replay, 0);
        }
        if (this.replay == rCONTINUOUS && this.nodma) {
            this.replay = rSPIN;
        }
    }

    private void setSlaveReplay(int n, int n2) {
        int n3;
        if (this.picSlave == null) {
            this.picSlave = (PicSlave)this.M.registry.get(this.slave);
        }
        if (this.picSlave == null) {
            this.warning("Slave=" + this.slave + " does not exist");
            return;
        }
        if (n2 == 0 && n < rABORT) {
            n = rSTOPNOW;
        }
        if (this.nodma && n == rSPIN) {
            n = rCONTINUOUS;
        }
        this.picSlave.setReplay(this.getReplay(n));
        while ((n3 = this.picSlave.getDmaMode()) != n2) {
            if (n3 == -20) {
                if (n2 == -2) break;
            }
            if (n2 == -20) {
                if (n3 == -2) break;
            }
            Time.sleep((double)this.pollTime);
        }
    }

    public void setRate(int n) {
        if (n == this.rate) {
            return;
        }
        if (this.pic.setKeyL(this.dmac, 1, this.rate) < 0) {
            this.MA.put("/SRATE", "" + n);
            this.setState(7);
        } else {
            this.rate = n;
        }
        this.fscale = this.nyfreq ? 1.0 : 2.0 / (double)this.rate;
    }

    public void setFreq(double d) {
        this.freq = d;
        if (this.ptype == 9) {
            this.pic.setKeyD(this.dmac, 2, d * this.fscale);
        } else if (this.chan > 0) {
            this.pic.setKeyD(this.dmacs[this.chan - 1], 2, d * this.fscale);
        } else {
            for (int i = 0; i < this.multi; ++i) {
                this.pic.setKeyD(this.dmacs[i], 2, (d + (double)i * this.dfreq) * this.fscale);
            }
        }
        this.afreq = this.pic.getKeyD(this.dmac, 2) / this.fscale;
    }

    public void setFreqs(Data data) {
        for (int i = 0; i < data.size; ++i) {
            this.pic.setKeyL(this.dmac, 16, i + 1);
            this.pic.setKeyD(this.dmac, 2, data.getD(i) * this.fscale);
        }
    }

    public void setDec(int n) {
        for (int i = 0; i < this.multi; ++i) {
            this.pic.setKeyL(this.dmacs[i], 3, n);
        }
        this.dec = this.pic.getKeyL(this.dmac, 3);
        if (this.dec != n) {
            this.M.info((CharSequence)("Decimation " + n + " rounded to " + this.dec));
        }
        if (this.dmamode != 0 && this.autors > 0) {
            this.setReplay(rRESTART);
        }
        this.setDelta(this.getDelta());
    }

    private void setDelta(double d) {
        this.delta = d;
        if ((this.ipflag & 1) != 0) {
            this.pkt.setAbscissa(0.0, this.delta);
        }
        if ((this.aipflag & 1) != 0) {
            this.apkt.setAbscissa(0.0, this.delta);
        }
    }

    public void setGain(int n) {
        if (this.agcPeriod > 0.0 && (n = Math.max(this.minGain, Math.min(this.maxGain, n))) == this.gain) {
            return;
        }
        this.gain = n;
        if (this.ptype == 9) {
            this.pic.setKeyL(this.dmac, 4, this.gain);
        } else if (this.chan > 0) {
            this.pic.setKeyL(this.dmacs[this.chan - 1], 4, this.gain);
        } else {
            for (int i = 0; i < this.multi; ++i) {
                this.pic.setKeyL(this.dmacs[i], 4, this.gain);
            }
        }
    }

    public void setRatio(double d) {
        if (this.ptype == 9) {
            this.pic.setKeyD(this.dmac, 13, d);
        } else if (this.chan > 0) {
            this.pic.setKeyD(this.dmacs[this.chan - 1], 13, d);
        } else {
            for (int i = 0; i < this.multi; ++i) {
                this.pic.setKeyD(this.dmacs[i], 13, d);
            }
        }
        this.ratio = this.pic.getKeyD(this.dmac, 13);
    }

    public void setSelect(int n) {
        int n2;
        if (n == this.select) {
            return;
        }
        for (n2 = 1; n2 <= this.mcs; ++n2) {
            if (n < 0 || this.select >= 0 && n2 != this.select) continue;
            this.pic.setKeyL(this.dmac, 16, n2);
            this.pic.setKeyL(this.dmac, 165, 0);
        }
        for (n2 = 1; n2 <= this.mcs; ++n2) {
            if (n >= 0 && (n <= 0 || n2 != n)) continue;
            this.pic.setKeyL(this.dmac, 16, n2);
            this.pic.setKeyL(this.dmac, 165, 1);
        }
        this.select = n;
    }

    public void setChannel(int n) {
        if (this.multi > 1) {
            this.chan = Math.max(1, Math.min(this.multi, n));
            this.gain = this.pic.getKeyL(this.dmacs[this.chan - 1], 4);
            this.afreq = this.pic.getKeyD(this.dmacs[this.chan - 1], 2) / this.fscale;
            this.chan = Math.max(0, Math.min(this.multi, n));
        } else if (this.ptype == 9) {
            this.chan = n;
            this.pic.setKeyL(this.dmac, 16, this.chan);
            this.afreq = this.pic.getKeyD(this.dmac, 2) / this.fscale;
        } else if (n > 1) {
            this.M.warning((CharSequence)"Should not be setting channel>1 when not in TBANK or MULTI modes");
        } else {
            this.chan = n;
        }
    }

    public void setEnable(int n) {
        this.pic.setKeyL(this.dmac, 165, n);
    }

    public void setMonitor(String string) {
        this.monitor = Parser.find((String)monitorList, (String)string, (int)this.monitor, (int)-1);
    }

    public void setStats(int n) {
        this.stats = n;
    }

    public void setMinGain(int n) {
        this.minGain = n;
    }

    public void setMaxGain(int n) {
        this.maxGain = n;
    }

    public void setAgcLevel(double d) {
        this.agcLevel = d;
    }

    public void setAgcWidth(double d) {
        this.agcWidth = d;
    }

    public void setGPW(GValue gValue) {
        this.gpw = gValue;
    }

    private String getReplay(int n) {
        return Parser.get((String)replayList, (int)(n - replayListOffset));
    }

    @Override
    public String getReplay() {
        return this.getReplay(this.replay);
    }

    public int getDec() {
        return this.dec;
    }

    public int getGain() {
        return this.gain;
    }

    public int getRate() {
        return this.rate;
    }

    public double getRatio() {
        return this.ratio;
    }

    public double getFreq() {
        return this.afreq;
    }

    public String getPort() {
        return this.sport;
    }

    public int getRfGain() {
        return this.rfgain;
    }

    public double getRfFreq() {
        return this.rffreq;
    }

    public int getChannel() {
        return this.chan;
    }

    public int getCycle() {
        return this.rcyc;
    }

    public long getIndex() {
        return this.rndx;
    }

    public double getProgress() {
        if (this.maxout > 0.0) {
            return this.ho.seek() / this.maxout;
        }
        if (this.archdur > 0.0) {
            return this.ha.getOffset() * this.ha.getDelta() / this.archdur;
        }
        return (double)this.rndx / (double)this.map.bytes;
    }

    public double getBytes() {
        return (double)this.rcyc * (double)this.map.bytes + (double)this.rndx;
    }

    public double getBytesOut() {
        return (double)this.ocyc * (double)this.map.bytes + (double)this.ondx;
    }

    public int getSkip() {
        return this.skip;
    }

    public String getMonitor() {
        return Parser.get((String)monitorList, (int)this.monitor, (int)-1);
    }

    public Time getTime() {
        return this.time;
    }

    public DevIce.TimeCode getTimeCode() {
        return this.tclast;
    }

    public String getFormat() {
        return this.hr.getFormat();
    }

    public int getHBLost() {
        return this.lost;
    }

    public int getPFull() {
        return this.pavg;
    }

    public int getCBLost() {
        return this.lostc;
    }

    @Override
    public int getDmaMode() {
        return this.dmamode;
    }

    public double getOffset() {
        return this.ha.isOpen ? this.ha.getOffset() : this.ho.getOffset();
    }

    public MDevIce getDevIce() {
        return this.pic;
    }

    public Archiver getArchiver() {
        return this.ha;
    }

    public String getArchFN() {
        if (this.archfn == null) {
            return null;
        }
        int n = this.archfn.indexOf(123);
        if (n > 0) {
            return this.archfn.substring(0, n);
        }
        return this.archfn;
    }

    public String getArchMode() {
        return Parser.get((String)archList, (int)(this.archmode + 1));
    }

    public double getArchDur() {
        return this.archmode == aRT ? this.ha.getLength() : this.archdur;
    }

    public double getArchOff() {
        return this.archmode == aRT ? this.ha.getOffset() * this.ha.getDelta() : this.archoff;
    }

    public double getArchTop() {
        return this.archmode == aRT ? this.ha.getTimeAt(0.0) : 0.0;
    }

    public Table getArchKW() {
        return this.archkw;
    }

    public double getSyncOff() {
        return this.syncoff;
    }

    public ICEPacket getPkt() {
        return this.pkt;
    }

    public ICEPacket getAPkt() {
        return this.apkt;
    }

    public float getMBPS() {
        return this.mbps;
    }

    public int getTCMode() {
        return this.tcmode;
    }

    public boolean isTuner() {
        return this.tuner;
    }

    public double getDelta() {
        double d = 1.0 / (double)this.rate;
        if (this.core) {
            d *= (double)this.dec;
        }
        if (this.tuner) {
            d *= (double)(this.hr.spa * this.dec);
        }
        if (this.ratio > 0.0) {
            d /= this.ratio;
        }
        return d;
    }

    public double getChannelFreq(int n) {
        double d = 0.0;
        if (this.ptype == 9) {
            this.pic.setKeyL(this.dmac, 16, n);
            Data data = new Data(this.freq * 2.0 / (double)this.rate);
            this.pic.getKey(this.dmac, 51, data);
            this.pic.setKeyL(this.dmac, 16, this.chan);
            d = data.getD(0);
        } else {
            int n2 = Math.max(1, Math.min(this.multi, n)) - 1;
            d = this.pic.getKeyD(this.dmacs[n2], 2);
        }
        return d * (double)this.rate / 2.0;
    }

    public void setAGC(Table table) {
        this.agcLevel = table.getD("LEVEL", 0.0);
        this.agcWidth = table.getD("WIDTH", 1.0);
        this.maxGain = table.getL("MAXGAIN", 100);
        this.minGain = table.getL("MINGAIN", -100);
        this.agcPeriod = table.getD("PERIOD", 1.0);
        this.agcTime = Time.current();
    }

    public void setRfGain(int n) {
        this.pic.setKeyL(this.dmac, 62, n);
        this.rfgain = this.pic.getKeyL(this.dmac, 62);
        this.hr.keywords.put("L:RFGAIN", (Object)this.rfgain);
        this.hr.update();
    }

    public void setRfFreqKWO(double d) {
        this.rffreq = d;
    }

    public void setRfFreq(double d) {
        if (this.agcLevel != 0.0) {
            int n = (int)(Math.round(d * 0.1) * 10L);
            if (n != this.agcFreq && this.agcFreq != 0) {
                if (this.agcFreqs == null) {
                    this.agcFreqs = new Table();
                }
                this.agcFreqs.put("F" + this.agcFreq, this.gain);
                Object object = this.agcFreqs.get("F" + n);
                if (object != null) {
                    this.setGain(Convert.o2l((Object)object));
                    this.agcTime = Time.current();
                }
            }
            this.agcFreq = n;
        }
        this.pic.setKeyD(this.dmac, 61, d);
        this.rffreq = this.pic.getKeyD(this.dmac, 61);
        this.hr.keywords.put("D:RFFREQ", (Object)this.rffreq);
        this.hr.update();
        this.ha.addEventKey("RFFREQ", this.rffreq);
    }

    public Table getTable(Table table) {
        return new Table(this.pic.getKeyTable(this.dmac, table.toString()));
    }

    private void setKeys(Table table) {
        if (table == null || table.size() == 0) {
            return;
        }
        Table.Iterator iterator = table.iterator();
        while (iterator.getNext()) {
            String string;
            String string2 = string = iterator.value == null ? "QUERY" : iterator.value.toString();
            if (string.length() == 0 || string.equals("QUERY")) {
                this.keys.put(iterator.key, iterator.value);
                continue;
            }
            this.setKey(iterator.key, iterator.value);
        }
    }

    public String[] getKeys() {
        return this.keys.getKeys();
    }

    public synchronized Object setKey(String string, Object object) {
        block10: {
            byte by;
            int n;
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                block13: {
                                                    block12: {
                                                        block11: {
                                                            block9: {
                                                                if (!string.equals("REPLAY")) break block9;
                                                                this.setReplay(Convert.o2s((Object)object));
                                                                break block10;
                                                            }
                                                            if (!string.equals("RATE")) break block11;
                                                            this.setRate(Convert.o2l((Object)object));
                                                            break block10;
                                                        }
                                                        if (!string.equals("FREQ")) break block12;
                                                        this.setFreq(Convert.o2d((Object)object));
                                                        break block10;
                                                    }
                                                    if (!string.equals("DEC")) break block13;
                                                    this.setDec(Convert.o2l((Object)object));
                                                    break block10;
                                                }
                                                if (!string.equals("GAIN")) break block14;
                                                this.setGain(Convert.o2l((Object)object));
                                                break block10;
                                            }
                                            if (!string.equals("RATIO")) break block15;
                                            this.setRatio(Convert.o2d((Object)object));
                                            break block10;
                                        }
                                        if (!string.equals("RFFREQ")) break block16;
                                        this.setRfFreq(Convert.o2d((Object)object));
                                        break block10;
                                    }
                                    if (!string.equals("RFGAIN")) break block17;
                                    this.setRfGain(Convert.o2l((Object)object));
                                    break block10;
                                }
                                if (!string.equals("TABLE")) break block18;
                                object = this.pic.setKeyTable(this.dmac, object.toString());
                                break block10;
                            }
                            if (!string.startsWith("CHAN")) break block19;
                            this.setChannel(Convert.o2l((Object)object));
                            break block10;
                        }
                        if (!string.startsWith("SELECT")) break block20;
                        this.setSelect(Convert.o2l((Object)object));
                        break block10;
                    }
                    n = this.pic.name2key(string);
                    if (n <= 0 && string.equals("VLAN")) {
                        n = 404;
                    }
                    if (n <= 0 && string.equals("JOIN")) {
                        n = 402;
                    }
                    if (n <= 0 && string.equals("LEAVE")) {
                        n = 403;
                    }
                    if (n <= 0) {
                        return null;
                    }
                    by = this.pic.getKeyType(n);
                    if (n == 402) break block21;
                    if (n != 403) break block22;
                }
                object = this.pic.str2ip(Convert.o2s((Object)object));
            }
            if (by == 68) {
                this.pic.setKeyD(this.dmac, n, Convert.o2d((Object)object));
            } else {
                this.pic.setKeyL(this.dmac, n, Convert.o2l((Object)object));
            }
            this.keys.put(string, object);
        }
        return object;
    }

    public synchronized Object getKey(String string) {
        Object object = null;
        if (string.equals("REPLAY")) {
            object = this.getReplay();
        } else if (string.equals("RATE")) {
            object = Convert.l2o((int)this.getRate());
        } else if (string.equals("FREQ")) {
            object = Convert.d2o((double)this.getFreq());
        } else if (string.equals("DEC")) {
            object = Convert.l2o((int)this.getDec());
        } else if (string.equals("GAIN")) {
            object = Convert.l2o((int)this.getGain());
        } else if (string.equals("RATIO")) {
            object = Convert.d2o((double)this.getRatio());
        } else {
            int n = this.pic.name2key(string);
            if (n <= 0) {
                return null;
            }
            byte by = this.pic.getKeyType(n);
            object = by == 68 ? Convert.d2o((double)this.pic.getKeyD(this.dmac, n)) : Convert.l2o((int)this.pic.getKeyL(this.dmac, n));
        }
        return object;
    }

    private int getMCSchn(long l, int n, int n2) {
        int n3 = n * n2;
        Native.p2ja((long)l, (int)n3, (Object)this.mcsbuf, (int)0, (int)8);
        int n4 = ((this.mcsbuf[0] & 1) << 0) + ((this.mcsbuf[1] & 1) << 1) + ((this.mcsbuf[2] & 1) << 2) + ((this.mcsbuf[3] & 1) << 3);
        if (++n4 >= this.mcs) {
            n4 = this.mcs;
        }
        return n4;
    }

    private void processWBAGC() {
        this.agcTime = Time.current();
        int n = this.pic.getKeyL(this.dmac, 155);
        if (n <= -90) {
            return;
        }
        double d = (double)n - this.agcLevel;
        int n2 = 0;
        if (d > 6.0) {
            n2 = -3;
        } else if (d > 1.0) {
            n2 = -1;
        } else if (d < -1.0) {
            n2 = 1;
        } else if (d < -6.0) {
            n2 = 3;
        }
        if (n2 != 0) {
            this.setGain(this.gain + n2);
        }
    }

    private void processNBAGC() {
        int n = this.ptype == 9 ? 256 : 8192;
        int n2 = this.ptype == 9 ? this.nchan * 4 : 1;
        int n3 = n * 4;
        int n4 = (1 << this.nchan) - 1;
        long l = this.map.bytes / 2L;
        if (this.agcbuf == null) {
            this.agcbuf = new short[n * 2];
        }
        for (int i = 0; i < n2 && n4 != 0; ++i) {
            long l2 = this.map.getVirtualAddress(l, n3);
            Native.p2ja((long)l2, (int)0, (Object)this.agcbuf, (int)0, (int)n3);
            float f = this.hr.spa == 2 ? this.calcAvgM(this.agcbuf, n) : this.calcAvg(this.agcbuf, n * 2);
            f = (float)(20.0 * Math.log(f));
            int n5 = 0;
            if ((double)f < this.agcLevel - this.agcWidth) {
                n5 = 1;
            }
            if ((double)f < this.agcLevel - this.agcWidth * 4.0) {
                n5 = 2;
            }
            if ((double)f > this.agcLevel + this.agcWidth) {
                n5 = -1;
            }
            if ((double)f > this.agcLevel + this.agcWidth * 4.0) {
                n5 = -2;
            }
            if (n5 != 0) {
                if (this.ptype == 9) {
                    int n6 = this.chan;
                    int n7 = this.gain;
                    this.chan = this.getMCSchn(l2, 0, n3);
                    int n8 = 1 << this.chan - 1;
                    if ((n8 & n4) != 0) {
                        this.gain = this.gains[this.chan - 1];
                        this.pic.setKeyL(this.dmac, 16, this.chan);
                        this.setGain(this.gain + n5);
                        this.gains[this.chan - 1] = this.gain;
                        this.chan = n6;
                        this.gain = n7;
                        this.pic.setKeyL(this.dmac, 16, this.chan);
                        n4 ^= n8;
                    }
                } else {
                    this.setGain(this.gain + n5);
                    n4 = 0;
                }
            }
            l += (long)n3;
        }
    }

    public int getChnGain(int n) {
        return this.gains[Math.max(1, Math.min(this.nchan, n)) - 1];
    }

    private float calcAvg(short[] sArray, int n) {
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            f += (float)Math.abs(sArray[i]);
        }
        return f / ((float)n * 32768.0f);
    }

    private float calcAvgM(short[] sArray, int n) {
        float f = 0.0f;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            float f2 = sArray[n2++];
            float f3 = sArray[n2++];
            f = (float)((double)f + Math.sqrt(f2 * f2 + f3 * f3));
        }
        return f / ((float)n * 32768.0f);
    }

    public static void setTime(DataFile dataFile, double d, double d2) {
        double d3 = 1.0E-6 * Math.floor(d2 * 1000000.0 + 0.5);
        int n = (int)Math.floor((d2 - d3) * 1.0E12 + 0.5);
        dataFile.setTimeCode(d + d3);
        dataFile.keywords.putMain("TC_PREC", "" + n + "e-12");
    }
}

