/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.inc.PicSlave;
import nxm.ice.lib.ArchSFN;
import nxm.ice.lib.DevIce;
import nxm.ice.lib.ICEPacket;
import nxm.ice.lib.MDevIce;
import nxm.ice.lib.RamDiskResource;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasThread;
import nxm.sys.lib.Parser;
import nxm.sys.lib.PipeResource;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public final class sinkpic
extends Primitive
implements PicSlave,
Keyable {
    public static String replayList = "-NShot,File,Stopped,OneShot,Continuous,StopTop,StopNow,Spin,Archive,Restart,Abort,Finish,NewDevice,Reopen,Reconnect,Release";
    public static int rFILE = -1;
    public static int rSTOPPED = 0;
    public static int rONESHOT = 1;
    public static int rCONTINUOUS = 2;
    public static int rSTOPTOP = 3;
    public static int rSTOPNOW = 4;
    public static int rSPIN = 5;
    public static int rARCHIVE = 6;
    public static int rRESTART = 7;
    public static int rABORT = 8;
    public static int rFINISH = 9;
    public static int rNEWDEVICE = 10;
    public static int rREOPEN = 11;
    public static int rRECONNECT = 12;
    public static int rRELEASE = 13;
    public static int rRESTART_WAIT = 99;
    private static int replayListOffset = -3;
    public static String syncList = "Master,SlaveWait,SlaveRun";
    private static int sSTOP = 1;
    private static int sWAIT = 2;
    private static int sRUN = 3;
    public static String throttleList = "Off,OneShots,Continuous,Throttled,OnDemand,Bypass";
    private static int tOFF = 0;
    private static int tONESHOTS = 1;
    private static int tCONTINUOUS = 2;
    private static int tTHROTTLED = 3;
    private static int tONDEMAND = 4;
    private static int tBYPASS = 5;
    public static String monitorList = "Off,Async,Info,Full";
    private static int mOFF = 0;
    private static int mASYNC = 1;
    private static int mINFO = 2;
    private static int mFULL = 3;
    private long ondx;
    private long indx;
    private long lndx;
    private long rndx;
    private long bdelay;
    private long bstart;
    private long ramsz;
    private int ocyc;
    private int icyc;
    private int lcyc;
    private int rcyc;
    private int status;
    private int frame;
    private int bytes;
    private int bpa;
    private int flags;
    private int dmamode;
    private int throttle;
    private int monitor;
    private int dmac;
    private int port;
    private int bits;
    private int gain;
    private int rate;
    private int trate;
    private int xfer;
    private int dec;
    private int skip;
    private int oskip;
    private int replay;
    private int lost;
    private int lostc;
    private int block;
    private int packet;
    private int pktmod;
    private int ipkt;
    private int ptype;
    private int mnbytes;
    private int tinc;
    private int tcmode;
    private int tcpp;
    private int archtl;
    private int archsf;
    private int nchn;
    private int rtfile;
    private int stats;
    private int pmin;
    private int pmax;
    private int pavg;
    private int ptot;
    private boolean sgo;
    private boolean sss;
    private boolean xts;
    private boolean autors;
    private boolean reset;
    private boolean inmem;
    private boolean ramoncard;
    private boolean wrap;
    private boolean doneReading;
    private boolean isSlave;
    private boolean isCX;
    private boolean isPipe;
    private boolean nodma;
    private boolean async;
    private boolean w2e;
    private boolean skiponcard;
    private boolean lbdma;
    private boolean nopref;
    private boolean tuner;
    private boolean core;
    private double freq;
    private double dfreq;
    private double fscale;
    private double mtodo;
    private double delta;
    private double ratio;
    private double drate;
    private double tcoff;
    private double poll;
    private double wait;
    private double delay;
    private double prefill;
    private double sfactor;
    private double timer;
    private double timetop;
    private double tctolr = 1.0E-8;
    private String archfn;
    private String alias;
    private String slave;
    private DevIce.TimeCode tc = new DevIce.TimeCode();
    private Time tcs;
    private Time time = new Time();
    private DataFile hr;
    private DataFile ho;
    private DataFile hi;
    private MDevIce pic;
    private DevIce.DmaMap map;
    private DevIce.DmaMap omap;
    private ICEPacket pkt;
    private PicSlave picSlave;
    private Table keys = new Table();
    private float mbps = 0.0f;
    private ArchSFN asfn;

    /*
     * Unable to fully structure code
     */
    public int open() {
        this.alias = this.MA.getS("DEV");
        this.pic = new MDevIce(this.MA, this.alias);
        if (this.pic.open() <= 0) {
            this.M.error("Problem opening device: " + this.alias);
        }
        this.stats = this.MA.getL("/STATS");
        this.autors = this.MA.getState("/AUTORS");
        this.wrap = this.MA.getState("/WRAP");
        this.rtfile = this.MA.getL("/RTFILE");
        this.throttle = this.MA.getSelectionIndex("/THROTTLE", sinkpic.throttleList, 0, -1);
        this.w2e = this.MA.getState("/WARN2ERR");
        this.lbdma = this.pic.getIntFlagDef("LBDMA", 0) > 0;
        this.nopref = this.pic.getIntFlagDef("NOPREFILL", 0) > 0;
        this.ptype = this.pic.getKeyL(0, 102);
        this.port = this.pic.getKeyL(0, 103);
        if (this.ptype == 4) ** GOTO lbl-1000
        if (this.ptype == 9) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        this.tuner = v0;
        if (this.ptype == 7) ** GOTO lbl-1000
        if (this.ptype == 8) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        this.core = v1;
        this.reset = this.ptype != 0 && this.port != 0;
        this.reset = this.MA.getState("/RESET", this.reset);
        this.archfn = this.MA.getCS("IN");
        this.archsf = this.MA.getL("/ARCHSF", 0);
        this.archtl = this.MA.getL("/ARCHTL", 0x100000);
        if (this.archsf != 0) {
            if (this.archsf == 1) {
                this.archsf = -1;
            }
            this.asfn = new ArchSFN(this, this.archfn, this.archsf);
            this.asfn.setTL(this.archtl);
            this.asfn.setTop(this.MA.getD("/ARCHTOP"));
            this.asfn.setDur(this.MA.getD("/ARCHDUR"));
            this.openNextFile(true);
        } else {
            this.hi = this.MA.getDataFile("IN");
            this.hi.open(128);
        }
        this.tcs = this.hi.getTime();
        this.hr = this.MA.getDataFile("OUT");
        this.hr.open(3);
        this.hr.setOutput(false);
        this.frame = this.hr.typeClass == 2 ? this.hr.getSubSize() : 1;
        this.isCX = this.hr.getSPA() == 2;
        this.bpa = this.hr.getBPA();
        this.dec = this.MA.getL("DEC");
        this.skip = Math.max(1, this.MA.getL("/SKIP"));
        this.skiponcard = this.MA.getState("/SKIPONCARD");
        if (this.ptype == 3 && this.dec > 1 && this.skip == 1) {
            this.skip = this.dec;
            this.dec = 1;
        }
        this.oskip = this.skiponcard != false ? 1 : this.skip;
        this.delta = this.hr.getXDelta();
        this.ratio = this.MA.getD("/RATIO");
        this.nchn = this.MA.getL("/NCHN", 1);
        this.ho = this.MA.getDataFile("/MON", this.hr, 0);
        this.ho.setYDelta(this.delta * (double)this.frame * (double)this.skip);
        this.ho.size = (this.hr.size - 1.0) / (double)this.oskip + 1.0;
        this.ho.open(64);
        this.isPipe = this.ho.isPipe();
        this.hi.setDFS(0);
        this.hr.setFS(0);
        this.hr.update();
        this.bits = this.hr.bps > 0 ? this.hr.bps * 8 : -this.hr.bps;
        if (this.hr.spa == 2) {
            this.bits = -this.bits;
        }
        this.bits = this.MA.getL("/BITS", this.bits);
        this.drate = this.MA.getD("/SRATE");
        if (this.dec <= 0) {
            this.dec = Math.max(1, (int)Math.round(this.delta * this.drate));
        }
        this.drate = Math.round((double)this.dec / this.delta);
        this.dfreq = this.MA.getD("/DFREQ", this.drate);
        if (this.ratio > 0.0) {
            this.drate *= this.ratio;
        }
        this.drate = this.MA.getD("/SRATE", this.drate);
        if (this.ratio < 0.0) {
            this.ratio = this.drate / ((double)this.dec / this.delta);
        }
        this.delay = this.MA.getD("/DELAY", 0.2);
        this.prefill = this.MA.getD("/PREFILL", this.nopref != false ? 0.0 : -1.0);
        this.nopref |= this.prefill == 0.0;
        if (this.prefill > 0.0) {
            this.delay = this.prefill;
        }
        this.freq = this.MA.getD("FREQ", 0.0 * this.drate);
        this.gain = this.MA.getL("GAIN");
        this.rate = (int)Math.round(this.drate);
        this.trate = this.MA.getL("/TRATE", Math.max(10000, this.rate / 8));
        v2 = this.fscale = this.isCX != false ? 1.0 / this.drate : 2.0 / this.drate;
        if (this.ratio > 0.0 && this.ratio != 1.0) {
            this.pic.setKeyD(0, 13, this.ratio);
        }
        if (this.ptype == 9) {
            this.ratio = this.drate * this.delta;
            this.pic.setKeyD(0, 20, this.fscale * this.dfreq);
            this.pic.setKeyD(0, 13, this.ratio);
            this.pic.setKeyL(0, 107, this.nchn);
        }
        this.xfer = this.frame * this.MA.getL("/TL", this.hr.typeClass == 2 ? 1 : 4096);
        this.ramsz = (long)this.hr.size;
        if ((this.ramsz % (long)this.xfer != 0L || this.ramsz == (long)this.xfer) && this.ho.isOpen) {
            this.warning("Ram size=" + this.ramsz + " not a multiple>1 of /TL=" + this.xfer + ". Allow for frame offsets.");
        }
        this.bytes = (int)((double)this.xfer * this.hr.dbpe);
        this.ramsz = (long)(this.hr.size * this.hr.dbpe);
        if ((long)(this.bytes * this.oskip) > this.ramsz / 2L) {
            this.warning("/TL * DEC should be less than 1/2 ram buffer");
        }
        this.block = this.MA.getL("/BLOCK", -1);
        this.replay = this.M.pipeMode == 1 ? sinkpic.rCONTINUOUS : sinkpic.rFILE;
        this.replay = this.MA.getSelectionIndex("/REPLAY", sinkpic.replayList, this.replay, sinkpic.replayListOffset);
        this.tcmode = this.pic.getKeyL(0, 116);
        if (!this.tcs.isZero()) {
            this.time.fromTime(this.tcs);
        } else {
            this.time.fromCurrent();
        }
        this.tcoff = this.tcmode == 1 ? 0.0 : this.time.getYiS();
        this.tcoff = this.MA.getD("/TCOFF", this.tcoff);
        this.tctolr = this.MA.getD("/TCTOLR", this.tctolr);
        this.tcpp = this.MA.getL("/TCPP", Math.max(1, (int)(this.hr.size / (double)this.xfer / (double)this.oskip)));
        this.packet = this.MA.getLength("/PACKET");
        this.pktmod = this.MA.getL("/PKTMODE", -1);
        this.pkt = new ICEPacket(this.hi.getFormat(), this.xfer, this.pktmod);
        this.slave = this.MA.getS("/SLAVE", "NONE");
        this.isSlave = this.slave.equals("NONE") == false;
        this.sss = this.slave.equals("SS");
        this.xts = this.slave.equals("XT");
        this.sgo = this.isSlave != false && this.sss == false && this.xts == false && this.slave.equals("NS") == false;
        this.slave = this.MA.getS("/MASTER", null);
        this.status = this.reset != false ? this.pic.reset(0) : 1;
        if (this.status < 0) {
            this.M.error("Problem resetting device");
        }
        this.map = this.pic.mapFile(this.hr);
        if (this.map == null) {
            this.M.error("Problem mapping DMA memory");
        }
        if (!this.MA.getState("/PAGED", true)) {
            this.map.setPaged(false);
        }
        if (this.ptype == 1) {
            this.map.setPaged(false);
            this.map.getVirtualAddress(0L, (int)this.map.bytes);
        }
        this.omap = this.map.getSubMap(0, 1);
        this.flags = 0;
        if (this.sgo) {
            this.flags = 0x100000;
        }
        if (this.sss) {
            this.flags = 0x40000000;
        }
        if (this.xts) {
            this.flags = 0x800000 | 0x200000;
        }
        if (this.throttle == sinkpic.tONESHOTS || this.throttle == sinkpic.tONDEMAND) {
            this.flags |= 2048;
        }
        this.openPorts();
        this.status = this.pic.dmaSetup(this.dmac, 1, this.map, this.block, 0);
        if (this.status < 0) {
            this.M.error("Problem setting up DMA channel " + this.status);
        }
        this.MR.put(this.MA.getU("/DMAC"), this.dmac);
        v3 = this.nodma = this.pic.getKeyL(this.dmac, 37) > 0;
        if (this.skiponcard) {
            this.pic.setKeyL(this.dmac, 6, this.frame);
            this.pic.setKeyL(this.dmac, 28, this.skip);
        }
        this.inmem = this.hi.getURL().equals(this.hr.getURL());
        this.inmem = this.MA.getState("/INMEM", this.inmem);
        this.ramoncard = this.MA.getState("/RAMONCARD");
        this.wait = this.MA.getD("/WAIT");
        if (this.replay == sinkpic.rSTOPPED && this.MA.getState("/RELEASE")) {
            this.replay = sinkpic.rSTOPNOW;
        }
        if (this.isSlave) {
            this.replay = sinkpic.rSTOPPED;
        }
        if (!this.MA.find("/POLL")) {
            this.setPollTime(0.025);
        }
        if (!this.tcs.isZero()) {
            this.pic.setKeyD(this.dmac, 9, this.tcs.getWSec(), this.tcs.getFSec());
        }
        this.dmamode = 0;
        this.todo = 0.0;
        this.mtodo = this.map.bytes;
        this.rcyc = 0;
        this.lcyc = 0;
        this.icyc = 0;
        this.ocyc = 0;
        this.rndx = 0L;
        this.lndx = 0L;
        this.indx = 0L;
        this.ondx = 0L;
        if (this.inmem && this.rtfile != 1) {
            this.doneReading = this.loadRamBuffer();
        }
        this.sfactor = 100.0 / (double)this.map.bytes;
        if (this.ramoncard) {
            for (var1_1 = 4096L; var1_1 < this.map.bytes; var1_1 *= 2L) {
            }
            if (var1_1 != this.map.bytes) {
                this.M.warning((CharSequence)("RamOnCard file size=" + this.map.bytes + " must be a power of 2"));
            }
        }
        var1_2 = this.pic.getKeyL(this.dmac, 112);
        this.bdelay = Math.round(this.delay / this.delta * this.hi.dbpe);
        this.bstart = Math.min((long)(0.95 * (double)this.map.bytes), this.bdelay);
        if (this.bstart > 0L) {
            this.bstart = Math.min(this.map.bytes, Math.max(this.bstart, (long)(2 * var1_2)));
        }
        if (this.throttle == sinkpic.tONESHOTS) {
            this.bstart = this.map.bytes;
        }
        if (this.throttle == sinkpic.tONDEMAND && this.prefill < 0.0) {
            this.bstart = 0L;
        }
        if (this.nodma | this.lbdma | this.nopref) {
            this.bstart = 0L;
        }
        if (this.lbdma) {
            this.pic.setKeyD(this.dmac, 164, this.delay * 1.0E9);
        }
        this.async = this.MA.getState("/ASYNC");
        if (this.async && !this.doneReading) {
            var2_3 = new DeArchiver();
            var3_4 = new MidasThread(this.M, (Runnable)var2_3);
            var3_4.start();
        }
        var2_3 = this.pic.getPortKey();
        this.hr.keywords.put("PORT", var2_3);
        if (this.archfn != null) {
            this.hr.keywords.put("ARCHIVE", (Object)this.getArchFN());
        }
        if ((var3_5 = this.pic.getKeyD(this.dmac, 61)) > 0.0) {
            this.hr.keywords.put("D:RFFREQ", (Object)var3_5);
        }
        this.hr.update();
        this.monitor = this.MA.getSelectionIndex("/MONITOR", sinkpic.monitorList, sinkpic.mFULL, -1);
        this.setKeys(this.MA.getTable("/PICKEYS"));
        return 0;
    }

    public synchronized int process() {
        int n;
        int n2;
        long l;
        if (this.replay == rABORT) {
            return 9;
        }
        int n3 = -1;
        if (this.replay != rSTOPPED) {
            if (!this.async && !this.doneReading && this.readBuffer()) {
                n3 = 0;
            }
            if (this.throttle == tONDEMAND && this.indx != this.lndx) {
                this.pic.setKeyL(this.dmac, 60, (int)(this.indx >> 6));
            }
            if (this.throttle == tONESHOTS && this.icyc != this.lcyc && this.icyc > 1) {
                this.pic.dmaFunc(this.dmac, -11);
            }
            if (this.throttle == tCONTINUOUS || this.throttle == tTHROTTLED) {
                double d;
                l = this.pic.dmaFuncX(this.dmac, -4);
                double d2 = d = this.doneReading ? 1.0 : (double)(this.indx - l) / (double)this.map.bytes;
                if (d <= 0.0) {
                    d += 1.0;
                }
                if (this.throttle == tCONTINUOUS && d < 0.25) {
                    this.pic.setKeyL(this.dmac, 1, this.trate);
                    this.throttle = tTHROTTLED;
                }
                if (this.throttle == tTHROTTLED && d > 0.75) {
                    this.pic.setKeyL(this.dmac, 1, this.rate);
                    this.throttle = tCONTINUOUS;
                }
            }
            this.lndx = this.indx;
            this.lcyc = this.icyc;
        }
        if (this.todo == 0.0) {
            int n4;
            if (this.replay == rSTOPTOP || this.replay == rSTOPNOW) {
                this.pic.dmaFunc(this.dmac, -8);
                this.replay = rSTOPPED;
            }
            if (this.replay == rSTOPPED) {
                return n3;
            }
            this.lostc = 0;
            this.lost = 0;
            this.rcyc = 0;
            this.ocyc = 0;
            this.rndx = 0L;
            this.ondx = 0L;
            this.pkt.setCount(0);
            if (this.icyc == 0 && this.indx < this.bstart && !this.doneReading) {
                return n3;
            }
            if (this.rtfile > 1) {
                this.updateRTF();
            }
            int n5 = this.nodma ? -20 : (this.ramoncard ? -19 : (this.lbdma ? -23 : (n4 = -2)));
            if (this.replay == rSPIN) {
                n4 = -1;
            }
            if (this.replay == rONESHOT) {
                n4 = 1;
            }
            if (this.throttle == tONESHOTS) {
                n4 = -11;
            }
            if (this.throttle == tONDEMAND) {
                n4 = -17;
            }
            if (this.slave != null) {
                this.setSlaveReplay(this.replay, n4);
            }
            if (this.wait > 0.0) {
                Time.sleep((double)this.wait);
            }
            if (this.stats > 0) {
                this.M.info((CharSequence)("Sinkpic-" + this.dmac + " START"));
            }
            this.pic.dmaFunc(this.dmac, n4);
            this.dmamode = n4;
            this.todo = this.mtodo;
            this.timer = this.timetop = Time.current();
        }
        if (this.replay == rSPIN) {
            return n3;
        }
        l = this.pic.dmaFuncX(this.dmac, -4);
        if (l == -1L) {
            if (this.pic.getKeyL(0, 147) < 0) {
                this.replay = rSTOPNOW;
            }
        }
        if (this.replay == rSTOPNOW || this.replay == rFINISH) {
            this.todo = 0.0;
        }
        if (this.todo > 0.0) {
            int n6;
            if (l < this.rndx) {
                this.rcyc = this.pic.dmaFunc(this.dmac, -5);
            }
            this.rndx = l;
            if (this.inmem && this.rtfile != 1) {
                this.indx = this.rndx;
                this.icyc = this.rcyc + 1;
            }
            if (this.rcyc < this.ocyc + this.lost) {
                return n3;
            }
            if (this.doneReading && !this.inmem && (this.ocyc > this.icyc || this.ondx >= this.indx)) {
                this.replay = rFINISH;
                return 0;
            }
            int n7 = this.rcyc - (this.icyc + this.lost);
            if (l > this.indx) {
                ++n7;
            }
            if (n7 > 0) {
                if (!this.inmem) {
                    this.warning("Falling behind " + n7 + " buffers");
                }
                this.lost += n7;
            }
            if (this.ondx + (long)(n6 = this.bytes) > this.map.bytes) {
                n6 = (int)(this.map.bytes - this.ondx);
            }
            if (l < this.ondx + (long)n6 && this.rcyc <= this.ocyc + this.lost) {
                return n3;
            }
            n2 = this.pkt.getCount();
            if (this.tcmode != 0 && n2 % this.tcpp == 0) {
                n = this.pic.tc(this.dmac, -1.0, this.delta, this.tc, 0);
                this.tc.wsec += this.tcoff;
                this.pkt.setTC(this.tcmode, n, this.tc.offset, this.tc.wsec, this.tc.fsec);
                if (n2 == 0) {
                    this.ho.setTime(this.tc.wsec, this.tc.fsec - this.tc.offset * this.delta);
                }
            }
            if (this.rtfile > 1) {
                this.updateRTF();
            }
            if (this.ho.isOpen && n6 > 0) {
                long l2 = this.ondx + (long)this.bytes > this.map.bytes ? this.omap.getVirtualAddress(this.ondx - (long)this.bytes, this.bytes) : this.omap.getVirtualAddress(this.ondx, this.bytes);
                this.ho_write(l2, 0, this.bytes);
            }
            if (n6 <= 0) {
                this.todo = 0.0;
            } else {
                this.ondx += (long)(this.bytes * this.oskip);
                this.todo = this.mtodo - (double)this.ondx;
                this.pkt.upCount();
            }
            if (this.tcmode == 1) {
                this.time.fromCurrent();
            } else if (this.tcmode != 0) {
                double d = (double)((long)this.ocyc * this.map.bytes + this.ondx) / this.hr.dbpe;
                if (this.wrap && d > this.hi.size) {
                    d %= this.hi.size;
                }
                this.time.fromJ1950(this.hi.getTimeAt(d));
            }
        }
        if (this.todo <= 0.0) {
            int n8;
            ++this.ocyc;
            this.todo = 0.0;
            this.ondx -= this.map.bytes;
            long l3 = this.rndx - this.indx + (long)(this.rcyc - this.icyc - this.lost + 1) * this.map.bytes;
            n2 = this.doneReading ? 0 : (int)Math.round(this.sfactor * (double)l3);
            this.timer = Time.current();
            int n9 = n = this.replay == rSTOPNOW || this.replay == rFINISH ? 1 : 0;
            if (this.stats > 0 && n == 0) {
                if (n2 < this.pmin) {
                    this.pmin = n2;
                }
                if (n2 > this.pmax) {
                    this.pmax = n2;
                }
                this.ptot += n2;
                if (this.ocyc % this.stats == 0) {
                    this.pavg = this.ptot / this.stats;
                    this.mbps = (float)(1.0E-6 * (double)this.map.bytes * (double)this.stats / Math.max(0.01, this.timer - this.timetop));
                    String string = this.stats > 1 ? ",FMIN=" + this.pmin + ",FMAX=" + this.pmax : "";
                    this.M.info((CharSequence)("Sinkpic-" + this.dmac + " STATS={CYC=" + this.ocyc + ",LOST=" + this.lost + ",FAVG=" + this.pavg + string + ",MBPS=" + this.mbps + "}"));
                    this.pmin = 100;
                    this.pmax = 0;
                    this.ptot = 0;
                    this.timetop = this.timer;
                }
            }
            if ((n8 = this.pic.dmaFunc(this.dmac, -10)) > this.lostc) {
                this.warning("Lost " + (n8 - this.lostc) + " card buffers");
                this.lostc = n8;
            }
            if (this.rtfile > 1) {
                this.updateRTF();
            }
            if (this.replay == rCONTINUOUS) {
                this.todo = this.mtodo;
                return n3;
            }
            if (this.replay == rONESHOT) {
                this.pic.dmaFunc(this.dmac, -3);
                this.rcyc = 1;
            }
            if (this.stats > 0) {
                this.M.info((CharSequence)("Sinkpic-" + this.dmac + " STOP"));
            }
            this.pic.dmaFunc(this.dmac, 0);
            this.pic.dmaFunc(this.dmac, -8);
            this.dmamode = 0;
            if (this.slave != null) {
                this.setSlaveReplay(this.replay, this.dmamode);
            }
            if (this.replay == rFILE || this.replay == rFINISH) {
                return 9;
            }
            this.replay = this.replay == rRESTART ? rCONTINUOUS : rSTOPPED;
        }
        return 0;
    }

    public int close() {
        while (this.async) {
            this.doneReading = true;
            Time.sleep((double)0.1);
        }
        if (this.dmac > 0) {
            this.pic.dmaFunc(this.dmac, -9);
        }
        if (this.dmamode != 0 && this.stats > 0) {
            this.M.info((CharSequence)("Sinkpic-" + this.dmac + " CANCEL"));
        }
        if (this.hr != null) {
            this.hr.close();
        }
        if (this.ho != null) {
            this.ho.close();
        }
        if (this.hi != null) {
            this.hi.close();
        }
        if (this.omap != null) {
            this.omap.close(10);
        }
        if (this.map != null) {
            this.map.close();
        }
        if (this.pic != null) {
            this.pic.close();
        }
        this.replay = rSTOPPED;
        this.dmamode = 0;
        return 0;
    }

    private void ho_write(long l, int n, int n2) {
        long l2;
        if (this.monitor == mOFF) {
            return;
        }
        if (this.isPipe && (l2 = this.ho.io.avail()) < (long)n2 && n2 <= ((PipeResource)this.ho.io).pipeSize) {
            for (int i = 0; i < 20 && l2 < (long)n2; ++i) {
                Time.sleep((double)0.01);
                l2 = this.ho.io.avail();
            }
            if (l2 <= (long)n2) {
                if (this.monitor == mINFO) {
                    this.M.info((CharSequence)"Dropping monitor frame");
                } else {
                    return;
                }
            }
        }
        this.ho.write(l, n, n2);
    }

    private void warning(String string) {
        if (this.w2e) {
            this.M.error(string);
        } else {
            this.M.warning((CharSequence)string);
        }
    }

    private void openPorts() {
        this.dmac = this.pic.ioPort(this.ptype, this.port, -1, 1, this.bits, this.rate, this.fscale * this.freq, this.dec, this.gain, this.flags);
        if (this.dmac <= 0) {
            this.M.error("Problem setting up IO port");
        }
    }

    private boolean loadRamBuffer() {
        if (!(this.hi.io instanceof RamDiskResource)) {
            int n = (int)(this.hr.size * this.hr.dbpe);
            long l = this.map.getVirtualAddress(0L, n);
            this.hi.read(l, 0, n);
        }
        this.icyc = 1;
        this.indx = 0L;
        return true;
    }

    private boolean readBuffer() {
        boolean bl;
        boolean bl2 = bl = this.rtfile == 1 || this.hi.isStream();
        long l = this.rtfile == 1 ? this.availRTF() : (bl ? this.hi.io.avail() : (long)((this.hi.size - this.hi.seek()) * this.hi.dbpe));
        int n = (int)Math.min(0x40000000L, l);
        int n2 = (int)Math.min((long)(this.archtl * this.bpa), this.map.bytes - this.indx);
        if (n > 0) {
            n2 = Math.min(n2, n);
        } else if (!(bl || this.archsf != 0 && this.openNextFile(false))) {
            if (this.wrap) {
                this.hi.seek(0.0);
            } else {
                this.doneReading = true;
            }
        }
        if (n > 0 && n < n2) {
            n2 = n;
        }
        if (this.icyc > this.rcyc - this.lost && this.indx + (long)n2 > this.rndx || this.icyc > this.ocyc && this.indx + (long)n2 > this.ondx) {
            n = 0;
        }
        if (this.packet >= 0) {
            if (n > 64) {
                this.hi.read(this.pkt.buf, 0, 64);
                n = n2 = this.pkt.getBytes();
            }
        }
        if (n >= n2) {
            if (!this.inmem) {
                long l2 = this.map.getVirtualAddress(this.indx, n2);
                n2 = this.hi.read(l2, 0, n2);
            }
            if (n2 > 0) {
                this.indx += (long)n2;
                if (this.indx >= this.map.bytes) {
                    ++this.icyc;
                    this.indx = 0L;
                }
                if (this.wrap && !bl && (long)n2 == l && this.archsf == 0) {
                    this.hi.seek(0.0);
                }
            }
            return true;
        }
        return false;
    }

    private boolean openNextFile(boolean bl) {
        int n;
        String string;
        if (this.hi != null && this.hi.isOpen()) {
            this.hi.close();
        }
        if ((string = this.asfn.getSFN(n = bl ? this.asfn.getIndex() : this.asfn.nextIndex())) == null || string.equals("NULL") || string.equals("NONE")) {
            return false;
        }
        if (this.archsf < 0 && this.hi != null) {
            this.hi.setName((Object)string);
            if (!this.hi.find(-1)) {
                n = this.asfn.resetIndex();
                string = this.asfn.getSFN(n);
            }
        }
        if (this.stats != 0 && (this.archsf > 0 || this.asfn.isLegit())) {
            this.M.info((CharSequence)("Sinkpic-" + this.dmac + " ArchSF index=" + n + " fn=" + string));
        }
        this.hi = new DataFile((MidasReference)this, (Object)string, "", "", 0);
        this.hi.open(128);
        if (!this.hi.isOpen) {
            return false;
        }
        this.tcs = this.hi.getTime();
        if (this.tcmode != 0) {
            if (this.tcmode != 1 && !this.tcs.isZero()) {
                double d = (double)((long)this.icyc * this.map.bytes + this.indx) / this.hr.dbpe;
                this.pic.setKeyD(this.dmac, 9, this.tcs.getWSec(), this.tcs.getFSec(), d);
            }
        }
        this.hi.setDFS(0);
        return !this.asfn.isTop();
    }

    private void updateRTF() {
        long l = this.map.bytes * (long)this.rcyc + this.rndx;
        this.hr.setOutByte(0, (double)l);
        this.hr.ioh.write(this.hr.hb, 88, 8, 88L);
    }

    private long availRTF() {
        long l = this.map.bytes * (long)this.icyc + this.indx;
        long l2 = (long)this.hi.getInByte();
        long l3 = l2 - l;
        if (this.throttle == tONDEMAND && this.prefill < 0.0) {
            l3 -= this.bdelay;
        }
        if (l3 < (long)(this.archtl * this.bpa)) {
            this.hi.ioh.read(this.hi.hb, 80, 8, 80L);
        }
        if (this.inmem) {
            this.updateRTF();
        }
        return l3;
    }

    @Override
    public void setReplay(String string) {
        int n;
        if (string.equalsIgnoreCase("STOP")) {
            string = "STOPNOW";
        }
        if (string.equalsIgnoreCase("START")) {
            string = "CONTINUOUS";
        }
        if ((n = Parser.find((String)replayList, (String)string, (int)this.replay, (int)replayListOffset)) > replayListOffset) {
            this.setReplay(n);
        } else {
            this.warning("Illegal replay mode: " + string);
        }
    }

    private void setReplay(int n) {
        if (n == 0 && this.replay != 0) {
            this.replay = rSTOPNOW;
        } else if (n == rRESTART && this.replay == 0) {
            this.replay = rCONTINUOUS;
        } else if (n == rONESHOT && this.replay == rCONTINUOUS) {
            this.replay = rSTOPTOP;
        } else if (n == rRECONNECT) {
            this.openPorts();
            this.replay = 0;
        } else {
            this.replay = n;
        }
        if (this.replay == rSTOPNOW) {
            this.process();
        }
        if (this.replay >= rABORT && this.slave != null) {
            this.setSlaveReplay(this.replay, 0);
        }
        if (this.replay == rCONTINUOUS && this.nodma) {
            this.replay = rSPIN;
        }
    }

    private void setSlaveReplay(int n, int n2) {
        int n3;
        if (this.picSlave == null) {
            this.picSlave = (PicSlave)this.M.registry.get(this.slave);
        }
        if (this.picSlave == null) {
            this.warning("Slave=" + this.slave + " does not exist");
            return;
        }
        if (n2 == 0 && n < rABORT) {
            n = rSTOPNOW;
        }
        if (this.nodma && n == rSPIN) {
            n = rCONTINUOUS;
        }
        this.picSlave.setReplay(this.getReplay(n));
        while ((n3 = this.picSlave.getDmaMode()) != n2) {
            if (n3 == -20) {
                if (n2 == -2) break;
            }
            if (n2 == -20) {
                if (n3 == -2) break;
            }
            if (n2 == -17) {
                if (n3 == -2) break;
            }
            Time.sleep((double)this.pollTime);
        }
    }

    public void setMonitor(String string) {
        this.monitor = Parser.find((String)monitorList, (String)string, (int)this.monitor, (int)-1);
    }

    public void setChan(int n) {
        this.pic.setKeyD(this.dmac, 16, n);
    }

    public void setRate(int n) {
        this.rate = n;
        this.pic.setKeyL(this.dmac, 1, this.rate);
    }

    public void setFreq(double d) {
        this.freq = d;
        this.pic.setKeyD(this.dmac, 2, this.fscale * this.freq);
    }

    public void setDec(int n) {
        this.dec = n;
    }

    public void setGain(int n) {
        this.gain = n;
        this.pic.setKeyL(this.dmac, 4, this.gain);
    }

    public void setSkip(int n) {
        this.skip = n;
    }

    public void setStats(int n) {
        this.stats = n;
    }

    public String setSFName(String string) {
        if (string != null && string.length() > 0) {
            String string2;
            int n;
            if (string.startsWith("_") && (n = (string2 = this.hi.getName().toString()).lastIndexOf(95)) > 0) {
                string = string2.substring(0, n) + string;
            }
            this.asfn.setFormat(string);
        }
        if (this.archsf < 0 && !this.asfn.isLegit()) {
            this.archsf = 0;
        }
        return string;
    }

    public void setArchTop(double d) {
        if (this.archsf != 0) {
            this.asfn.setTop(d);
            this.openNextFile(true);
        }
    }

    public void setArchDur(double d) {
        if (this.archsf != 0) {
            this.asfn.setDur(d);
        }
    }

    private String getReplay(int n) {
        return Parser.get((String)replayList, (int)(n - replayListOffset));
    }

    @Override
    public String getReplay() {
        return this.getReplay(this.replay);
    }

    public int getRate() {
        return this.rate;
    }

    public double getFreq() {
        return this.freq;
    }

    public int getDec() {
        return this.dec;
    }

    public int getGain() {
        return this.gain;
    }

    public int getSkip() {
        return this.skip;
    }

    public int getCycle() {
        return this.rcyc;
    }

    public long getIndex() {
        return this.rndx;
    }

    public double getProgress() {
        return this.doneReading ? (double)this.rndx / (double)this.map.bytes : this.hi.seek() / this.hi.size;
    }

    public String getMonitor() {
        return Parser.get((String)monitorList, (int)this.monitor, (int)-1);
    }

    public String getThrottle() {
        return Parser.get((String)throttleList, (int)this.throttle, (int)-1);
    }

    public DevIce.TimeCode getTimeCode() {
        return this.tc;
    }

    public Time getTime() {
        return this.time;
    }

    public int getHBLost() {
        return this.lost;
    }

    public int getCBLost() {
        return this.lostc;
    }

    public int getPFull() {
        return this.pavg;
    }

    public ArchSFN getASFN() {
        return this.asfn;
    }

    public ArchSFN getArchiver() {
        return this.asfn;
    }

    public double getArchDur() {
        return this.archsf != 0 ? this.asfn.getLength() : this.hi.getLength();
    }

    public double getArchOff() {
        return this.archsf != 0 ? this.asfn.getLengthTo(this.hi.getOffset()) : this.hi.getOffset() * this.hi.getDelta();
    }

    public double getArchTop() {
        return this.archsf != 0 ? this.asfn.getTimeTop() : this.hi.getTimeAt(0.0);
    }

    public String getSFName() {
        return this.asfn.getSFN();
    }

    @Override
    public int getDmaMode() {
        return this.dmamode;
    }

    public double getOffset() {
        return this.hi.getOffset();
    }

    public double getDelta() {
        return this.hi.getDelta();
    }

    public MDevIce getDevIce() {
        return this.pic;
    }

    public float getMBPS() {
        return this.mbps;
    }

    public String getArchFN() {
        if (this.archfn == null) {
            return null;
        }
        int n = this.archfn.indexOf(123);
        if (n > 0) {
            return this.archfn.substring(0, n);
        }
        return this.archfn;
    }

    public Table getTable(Table table) {
        return new Table(this.pic.getKeyTable(this.dmac, table.toString()));
    }

    private void setKeys(Table table) {
        if (table == null || table.size() == 0) {
            return;
        }
        Table.Iterator iterator = table.iterator();
        while (iterator.getNext()) {
            String string;
            String string2 = string = iterator.value == null ? "QUERY" : iterator.value.toString();
            if (string.length() == 0 || string.equals("QUERY")) {
                this.keys.put(iterator.key, iterator.value);
                continue;
            }
            this.setKey(iterator.key, iterator.value);
        }
    }

    public String[] getKeys() {
        return this.keys.getKeys();
    }

    public synchronized Object setKey(String string, Object object) {
        block8: {
            byte by;
            int n;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block7: {
                                            if (!string.equals("REPLAY")) break block7;
                                            this.setReplay(Convert.o2s((Object)object));
                                            break block8;
                                        }
                                        if (!string.equals("RATE")) break block9;
                                        this.setRate(Convert.o2l((Object)object));
                                        break block8;
                                    }
                                    if (!string.equals("FREQ")) break block10;
                                    this.setFreq(Convert.o2d((Object)object));
                                    break block8;
                                }
                                if (!string.equals("DEC")) break block11;
                                this.setDec(Convert.o2l((Object)object));
                                break block8;
                            }
                            if (!string.equals("GAIN")) break block12;
                            this.setGain(Convert.o2l((Object)object));
                            break block8;
                        }
                        if (!string.equals("TABLE")) break block13;
                        object = this.pic.setKeyTable(this.dmac, object.toString());
                        break block8;
                    }
                    n = this.pic.name2key(string);
                    if (n <= 0) {
                        return null;
                    }
                    by = this.pic.getKeyType(n);
                    if (n == 402) break block14;
                    if (n != 403) break block15;
                }
                object = this.pic.str2ip(Convert.o2s((Object)object));
            }
            if (by == 68) {
                this.pic.setKeyD(this.dmac, n, Convert.o2d((Object)object));
            } else {
                this.pic.setKeyL(this.dmac, n, Convert.o2l((Object)object));
            }
            if (n == 61) {
                this.hr.keywords.put("D:RFFREQ", (Object)this.pic.getKeyD(this.dmac, 61));
                this.hr.update();
            }
            this.keys.put(string, object);
        }
        return object;
    }

    public synchronized Object getKey(String string) {
        Object object = null;
        if (string.equals("REPLAY")) {
            object = this.getReplay();
        } else if (string.equals("RATE")) {
            object = Convert.l2o((int)this.getRate());
        } else if (string.equals("FREQ")) {
            object = Convert.d2o((double)this.getFreq());
        } else if (string.equals("DEC")) {
            object = Convert.l2o((int)this.getDec());
        } else if (string.equals("GAIN")) {
            object = Convert.l2o((int)this.getGain());
        } else {
            int n = this.pic.name2key(string);
            if (n <= 0) {
                return null;
            }
            byte by = this.pic.getKeyType(n);
            object = by == 68 ? Convert.d2o((double)this.pic.getKeyD(this.dmac, n)) : Convert.l2o((int)this.pic.getKeyL(this.dmac, n));
        }
        return object;
    }

    private class DeArchiver
    implements Runnable {
        private DeArchiver() {
        }

        @Override
        public void run() {
            while (!sinkpic.this.doneReading) {
                if (sinkpic.this.state == 2 && sinkpic.this.readBuffer()) continue;
                Time.sleep((double)0.01);
            }
            sinkpic.this.async = false;
        }
    }
}

