/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.sys.inc.MidasReference;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;

public class icemux
extends Primitive {
    private DataFile ho;
    private DataFile hi;
    private DataFile[] his;
    private double[] tis;
    private double[] tid;
    private boolean ctag;
    private boolean strip;
    private int nc;
    private int icm;
    private int bpe;
    private Data db;

    public int open() {
        this.nc = this.MA.getL("NCHAN");
        this.xfer = this.MA.getL("/TL", 256);
        this.ctag = this.MA.getState("/CTAG");
        this.strip = this.MA.getState("/STRIP");
        String string = this.MA.getCS("IN");
        this.his = new DataFile[this.nc];
        this.tis = new double[this.nc];
        this.tid = new double[this.nc];
        this.icm = -1;
        for (int i = 0; i < this.nc; ++i) {
            this.hi = new DataFile();
            this.hi.init((MidasReference)this, (Object)(string + (i + 1)), "1000", "S#,C#", 0);
            if (this.hi.exists()) {
                this.hi.open();
            }
            if (this.hi.isOpen && this.icm < 0) {
                this.icm = i;
            }
            this.his[i] = this.hi;
            this.tis[i] = this.hi.getXStart();
            this.tid[i] = this.hi.getXDelta() * (double)this.xfer;
        }
        this.ho = this.MA.getDataFile("OUT", this.his[this.icm], 0);
        if (this.strip) {
            this.ho.setPacketHandler(null);
        }
        this.ho.open(2);
        this.db = this.ho.getDataBuffer(this.xfer);
        this.bpe = (int)this.ho.getBPE();
        return 0;
    }

    public int process() {
        int n;
        double d = 0.0;
        this.icm = -1;
        for (n = 0; n < this.nc; ++n) {
            this.hi = this.his[n];
            if (!this.hi.isOpen || this.icm >= 0 && !(this.tis[n] < d)) continue;
            d = this.tis[n];
            this.icm = n;
        }
        if (this.icm < 0) {
            return 9;
        }
        this.hi = this.his[this.icm];
        n = this.hi.read(this.db);
        if (n < 0) {
            this.hi.close();
        }
        if (this.ctag && n > 0) {
            this.ctag(this.db.buf, this.icm, n);
        }
        if (n == this.xfer) {
            this.ho.write(this.db);
            int n2 = this.icm;
            this.tis[n2] = this.tis[n2] + this.tid[this.icm];
        }
        return 0;
    }

    public int close() {
        for (int i = 0; i < this.nc; ++i) {
            this.his[i].close();
        }
        this.ho.close();
        return 0;
    }

    private void ctagx(byte[] byArray, int n, int n2) {
        int n3 = n2 * this.bpe >> 1;
        for (int i = 0; i < n3; ++i) {
            byArray[i + i] = (byte)(byArray[i + i] & 0xFE | n >> (i & 3) & 1);
        }
    }

    private void ctag(byte[] byArray, int n, int n2) {
        int n3 = n2 * this.bpe;
        for (int i = 0; i < n3; i += 1024) {
            byArray[i + 0] = (byte)(byArray[i + 0] & 0xFE | n >> 0 & 1);
            byArray[i + 2] = (byte)(byArray[i + 2] & 0xFE | n >> 1 & 1);
            byArray[i + 4] = (byte)(byArray[i + 4] & 0xFE | n >> 2 & 1);
            byArray[i + 6] = (byte)(byArray[i + 6] & 0xFE | n >> 3 & 1);
        }
    }
}

