/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Time;

public class icediff
extends Primitive {
    private DataFile hd;
    private DataFile h1;
    private DataFile h2;
    private Data dd;
    private Data d1;
    private Data d2;
    private boolean all;
    private boolean sync;
    private int diffs;
    private int maxSeek;
    private int maxShow;
    private int maxChk;
    private int find;
    private int mask;
    private double offset = 0.0;
    private double total = 0.0;

    public int open() {
        this.h1 = this.MA.getDataFile("IN1", "1000,2000", "S#,C#", 0);
        this.h1.open();
        this.h2 = this.MA.getDataFile("IN2", "1000,2000", "S#,C#", 0);
        this.h2.open();
        this.maxChk = this.MA.getL("/MAXCHK", -1);
        this.maxSeek = this.MA.getL("/SEEK", 64);
        this.maxShow = this.MA.getL("/SHOW", 16);
        this.find = this.MA.getL("/FIND", -1);
        this.mask = this.MA.getL("/MASK", -1);
        this.sync = this.all = this.MA.getState("/ALL");
        byte by = this.h1.getFormatType();
        if (this.h1.getXDelta() != this.h2.getXDelta()) {
            this.M.warning((CharSequence)"File xdeltas do not match");
        }
        if (this.h1.getXUnits() != this.h2.getXUnits()) {
            this.M.warning((CharSequence)"File xunits do not match");
        }
        by = Data.promoteType((byte)this.h1.getFormatType(), (byte)this.h2.getFormatType());
        this.hd = this.MA.getDataFile("OUT", this.h1, 0);
        this.hd.setFormatType(by);
        this.hd.open(2 | 0x40);
        if (this.h1.typeClass == 2) {
            this.h1.setDFS(0);
            this.h2.setDFS(0);
            this.hd.setDFS(0);
        }
        this.xfer = Math.max(1, (int)((double)this.bufSize / this.hd.dbpe));
        if (this.maxChk > 0 && this.maxChk < this.xfer) {
            this.xfer = this.maxChk;
        }
        this.xfer = this.MA.getL("/TL", this.xfer);
        this.d1 = this.h1.getDataBuffer(this.xfer, by);
        this.d2 = this.h2.getDataBuffer(this.xfer, by);
        this.dd = this.hd.getDataBuffer(this.xfer, by);
        return 0;
    }

    public int process() {
        this.offset = this.h1.seek();
        if (this.maxChk > 0 && this.offset >= (double)this.maxChk) {
            return 9;
        }
        int n = this.h1.read(this.d1);
        if (n <= 0) {
            return 9;
        }
        int n2 = this.h2.read(this.d2);
        if (n2 <= 0) {
            return 9;
        }
        int n3 = Math.min(n, n2);
        if (this.sync) {
            this.total += (double)n3;
        }
        if (this.find > 0) {
            for (int i = 0; i < n3 - this.find; ++i) {
                this.diffs = 0;
                this.checkBytes(this.d1, this.d2, 0, i, this.hd.bpa, this.find, false);
                if (this.diffs != 0) continue;
                this.M.info((CharSequence)("Found pattern match at offset=" + ((long)this.h2.seek() - (long)n3 + (long)i)));
            }
            this.h1.seek(0.0);
        } else if (this.sync) {
            this.checkBytes(this.d1, this.d2, 0, 0, this.hd.bpa, n3, true);
        } else {
            int n4 = this.maxSeek;
            for (int i = 0; i < this.maxSeek; ++i) {
                this.checkBytes(this.d1, this.d2, this.maxSeek, this.maxSeek + i, this.hd.bpa, this.maxSeek, false);
                if (this.diffs == 0) {
                    n4 = i;
                    break;
                }
                this.diffs = 0;
                this.checkBytes(this.d1, this.d2, this.maxSeek, this.maxSeek - i, this.hd.bpa, this.maxSeek, false);
                if (this.diffs == 0) {
                    n4 = -i;
                    break;
                }
                this.diffs = 0;
            }
            if (n4 == this.maxSeek) {
                this.M.warning((CharSequence)"No correlation found");
                n4 = 0;
            } else if (n4 != 0) {
                this.M.warning((CharSequence)("Files appear to be offset by " + n4 + " samples"));
            }
            if (n4 == 0) {
                this.h1.seek(0.0);
                this.h2.seek(0.0);
            } else {
                this.h1.seek((double)this.maxSeek);
                this.h2.seek((double)(this.maxSeek + n4));
            }
            this.sync = true;
        }
        return 0;
    }

    public int close() {
        this.MR.put(this.MA.getU("/STAT"), this.diffs);
        this.M.info((CharSequence)("Total of " + this.diffs + " differences found in " + this.total + " samples at " + Time.toString((double)Time.current())));
        this.h1.close();
        this.h2.close();
        this.hd.close();
        return 0;
    }

    private String l2x(int n) {
        return Convert.l2x((int)n);
    }

    private String x2x(long l) {
        byte[] byArray = new byte[8];
        Convert.packX((byte[])byArray, (int)0, (long)l);
        return Convert.bb2hex((byte[])byArray, (int)0, (int)8);
    }

    private void checkBytes(Data data, Data data2, int n, int n2, int n3, int n4, boolean bl) {
        byte[] byArray = data.buf;
        byte[] byArray2 = data2.buf;
        if (n3 < 0) {
            n4 = n4 * -n3 / 8;
            n3 = 1;
        }
        n *= n3;
        n2 *= n3;
        n4 *= n3;
        int n5 = n3 > 4 ? 8 : 4;
        int n6 = 0;
        while (n6 < n4) {
            block11: {
                block9: {
                    int n7;
                    block10: {
                        if (this.all) break block9;
                        if (this.mask != -1) break block10;
                        boolean bl2 = true;
                        for (n7 = 0; n7 < n5; ++n7) {
                            if (byArray[n + n7] == byArray2[n2 + n7]) continue;
                            bl2 = false;
                        }
                        if (!bl2) break block9;
                        break block11;
                    }
                    int n8 = this.mask & Convert.unpackL((byte[])byArray, (int)n);
                    if (n8 == (n7 = this.mask & Convert.unpackL((byte[])byArray2, (int)n2))) break block11;
                }
                ++this.diffs;
                if (this.all || bl && this.diffs <= this.maxShow) {
                    long l = (long)(this.offset + (double)(n6 / n3));
                    if (n5 == 8) {
                        long l2 = Convert.unpackX((byte[])byArray, (int)n);
                        long l3 = Convert.unpackX((byte[])byArray2, (int)n2);
                        this.M.info((CharSequence)(" b1=" + this.x2x(l2) + " b2=" + this.x2x(l3) + " xor=" + this.x2x(l2 ^ l3) + " at " + this.l2x((int)l) + " or " + l));
                    } else {
                        int n9 = Convert.unpackL((byte[])byArray, (int)n);
                        int n10 = Convert.unpackL((byte[])byArray2, (int)n2);
                        this.M.info((CharSequence)(" b1=" + this.l2x(n9) + " b2=" + this.l2x(n10) + " xor=" + this.l2x(n9 ^ n10) + " at " + this.l2x((int)l) + " or " + l));
                    }
                }
            }
            n6 += n5;
            n += n5;
            n2 += n5;
        }
    }
}

