/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.sys.inc.Chainable;
import nxm.sys.inc.DataTypes;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libg.GValue;

public class icecore
extends Primitive
implements Chainable,
Keyable,
DataTypes {
    private int dump;
    private int tmode;
    private int tl = 4096;
    private int itl;
    private int otl;
    private int ilen;
    private int olen;
    private int iptl;
    private int optl;
    private int icvt = 0;
    private int ocvt = 0;
    private int flow;
    private int tagcnt = -1;
    private DataFile hi;
    private DataFile ho;
    private DataFile hip;
    private DataFile hop;
    private DataFile hcsf;
    private DataFile ht;
    private Data dcsf;
    private Data dt;
    private Data d;
    private Core core;
    private Table keys;
    private String csfkeys;
    private double csfdt = 1.0;
    private double csft = 0.0;
    private double csfdi;
    private double csfi;
    private double startOffset;
    private double tcs;
    private CoreComponent.Buffer bi;
    private CoreComponent.Buffer bo;
    private CoreComponent.Buffer bip;
    private CoreComponent.Buffer bop;
    private boolean isThreaded;
    private boolean isPacket;
    private boolean isICEX;
    private boolean mimicRT;
    private GValue gpw;

    public int open() {
        Table table;
        this.hi = this.MA.getDataFile("IN", "1000,2000", "S#,C#", 0);
        this.hi.open(64);
        this.startOffset = this.hi.getOffset();
        String string = this.hi.getFormat();
        String string2 = this.MA.getS("/IFMT", string);
        this.ilen = this.MA.getL("/ILEN");
        String string3 = this.MA.getS("/OFMT", string2);
        this.olen = this.MA.getL("/OLEN");
        this.tmode = this.MA.getL("/TRACE", 0);
        this.csfdt = this.MA.getD("/CPOLL", this.csfdt);
        Object object = this.MA.getO("/GPWR");
        if (object instanceof GValue) {
            this.gpw = (GValue)object;
        }
        String string4 = this.MA.getCS("FUNC", "Bogus");
        this.core = (Core)this.MA.getO("/CIN");
        if (this.core == null) {
            this.core = Core.forName(string4, this.MA);
        }
        if (this.core == null) {
            this.M.error("Opening core name=" + string4);
            return 9;
        }
        this.core.setFormats(string2, string3);
        this.core.setTraceMode(this.tmode);
        this.flow = this.core.halo.flow;
        this.isThreaded = this.core.halo.impl > 1;
        this.keys = this.MA.getTable("/CFG");
        if (this.keys == null) {
            this.keys = new Table();
        }
        this.keys.setMode("KV");
        for (int i = 4; i <= this.MA.numberOf(); ++i) {
            String string5 = this.MA.getKey(i);
            Data data = this.MA.getData(string5);
            if (string5.length() > 2 && string5.charAt(1) == ':') {
                string5 = string5.substring(2);
            }
            this.keys.put(string5, (Object)data);
        }
        this.verbose = this.MA.getState("/VERBOSE");
        this.core.setKeyTable(null, this.keys, this.verbose);
        this.core.open();
        double d = this.hi.getXDelta();
        double d2 = this.hi.getXStart();
        this.d = this.core.get("XDIO?", (byte)68);
        if (this.d != null) {
            d *= this.d.toD();
        }
        this.d = this.core.get("XDO?", (byte)68);
        if (this.d != null) {
            d = this.d.toD();
        }
        this.d = this.core.get("XSIO?", (byte)68);
        if (this.d != null) {
            d2 += this.d.toD();
        }
        d = this.MA.getD("/OXD", d);
        d2 = this.MA.getD("/OXS", d2);
        this.ho = this.MA.getDataFile("OUT", this.hi, 0);
        this.ho.setXDelta(d);
        this.ho.setXStart(d2);
        this.ho.setFormat(string3);
        this.ho.open(64);
        String string6 = this.ho.getFormat();
        if (this.hi.typeClass == 2) {
            this.tl = this.hi.getSubsize();
        }
        this.tl = this.MA.getL("/TL", this.tl);
        this.itl = this.MA.getL("/ITL", this.tl);
        this.otl = this.MA.getL("/OTL", this.itl);
        this.hip = this.MA.getDataFile("/PIN", "1000", "SL", 0);
        this.hip.open(64);
        if (this.hip.isOpen) {
            this.iptl = this.MA.getL("/IPTL", this.itl);
        }
        if (this.flow == 4) {
            this.bip = this.core.getBuffer(128, 4, 4);
        }
        this.hop = this.MA.getDataFile("/POUT", this.hip, 0);
        this.hop.open(64);
        if (this.hop.isOpen) {
            this.optl = this.MA.getL("/OPTL", this.otl);
        }
        if (this.flow == 4) {
            this.bop = this.core.getBuffer(1024, 8, 4);
        }
        if ((table = this.MA.getTable("/CSF")) != null) {
            this.hcsf = new DataFile((MidasReference)this.M, (Object)table.getS("FN"), "3000", "NH", 0);
            this.hcsf.setSubRecords(table.getS("FMT"));
            this.csfdt = table.getD("DT");
            this.hcsf.setXDelta(this.csfdt);
            this.csfkeys = table.getS("KEYS");
            this.hcsf.open(2);
            this.dcsf = this.hcsf.getDataBuffer(1);
        }
        if (this.hi.isOpen) {
            this.csfdi = this.hi.dbpe * this.csfdt / this.hi.getDelta();
        }
        this.mimicRT = this.MA.getState("/MRT");
        this.isICEX = this.MA.getS("/CORE").equals("ICEX");
        if (this.gpw != null) {
            this.gpw.setValue(0.0);
        }
        this.tcs = this.MA.getD("/TCS");
        this.d = this.core.get("D:STARTUP?", (byte)68);
        if (this.d != null && this.tcs > 0.0) {
            this.core.set("D:STARTUP", this.tcs + -6.31152E8);
        }
        this.dump = this.MA.getL("/DUMP", 0);
        if ((this.dump & 1) != 0) {
            this.dumpKeys();
        }
        this.bi = this.core.getBuffer(this.itl, string, string2);
        this.bo = this.core.getBuffer(this.otl, string3, string6);
        return 0;
    }

    public int process() {
        boolean bl;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = this.mimicRT ? this.csfi > this.csfdi : (bl = Time.current() - this.csft > this.csfdt);
        if (bl) {
            this.core.poll();
            if (this.hcsf != null) {
                this.core.getList(this.csfkeys, this.dcsf);
                this.hcsf.write(this.dcsf);
            }
            this.csft = Time.current();
            this.csfi = 0.0;
        }
        if (this.isICEX) {
            return -1;
        }
        if (this.hi.isOpen && this.ilen != 0) {
            n = this.core.load(this.bi, this.hi);
        }
        if (this.hip.isOpen) {
            n3 = this.core.load(this.bip, this.hip);
        } else if (this.flow == 4) {
            n3 = this.gentags(this.bi, n, this.bip);
        }
        if (this.flow == 1) {
            this.core.process((CoreComponent.Stream)this.bi, (CoreComponent.Stream)this.bo);
        } else if (this.flow == 2) {
            this.core.process(this.bi, this.bo);
        } else if (this.flow == 3) {
            this.core.process(this.bi, (CoreComponent.Stream)this.bo);
        } else if (this.flow == 4) {
            this.core.process(this.bi, this.bip, this.bo, this.bop);
        } else {
            return -1;
        }
        if (this.ho.isOpen) {
            n2 = this.core.unload(this.bo, this.ho);
        }
        if (this.hop.isOpen) {
            n4 = this.core.unload(this.bop, this.hop);
        } else if (this.flow == 4) {
            n4 = this.flush(this.bop);
        }
        int n5 = n + n2 + n3 + n4;
        if (n5 == 0) {
            return -1;
        }
        if (n5 < 0) {
            return 9;
        }
        if (this.olen > 0 && this.ho.getOffset() >= (double)this.olen) {
            return 9;
        }
        if (this.ilen > 0 && this.hi.getOffset() >= (double)this.ilen) {
            return 9;
        }
        if (this.ilen == -2 && this.hi.getOffset() >= this.hi.getSize()) {
            this.hi.seek(0.0);
        }
        this.csfdi += (double)n;
        if (this.gpw != null) {
            this.gpw.setValue(this.getProgress());
        }
        return 0;
    }

    public int close() {
        String string;
        this.updateStatusKeys();
        if (this.gpw != null) {
            this.gpw.setValue(1.0);
        }
        if (this.tmode != 0) {
            this.dumpTrace();
        }
        if ((this.dump & 2) != 0) {
            this.dumpKeys();
        }
        if (!StringUtil.isNullOrEmpty((Object)(string = this.MA.getU("/COUT")))) {
            this.MR.put(string, (Object)this.core);
        } else {
            this.core.close();
        }
        this.hi.close();
        this.ho.close();
        this.hip.close();
        this.hop.close();
        if (this.hcsf != null) {
            this.hcsf.close();
        }
        return 0;
    }

    public double getProgress() {
        return this.hi.seek() / this.hi.getSize();
    }

    private int gentags(CoreComponent.Buffer buffer, int n, CoreComponent.Buffer buffer2) {
        int n2 = 0;
        for (int i = -n; i < 0; i += 4) {
            if (buffer.xgetL(i) == 0x55555555 && (buffer.xgetL(i + 4) & 0xFFFF) == 54613) {
                if (!this.isThreaded) {
                    if (this.tagcnt > 0) {
                        buffer2.xwrL(65536);
                        buffer2.xwrL(0x20000 | this.tagcnt);
                        n2 += 8;
                    }
                    this.tagcnt = 0;
                } else {
                    if (this.tagcnt > 0) {
                        buffer2.xwrL(0x20000 | this.tagcnt);
                        n2 += 4;
                    }
                    this.tagcnt = 0;
                    buffer2.xwrL(0x10000 | this.tagcnt);
                    n2 += 4;
                }
            }
            if (this.tagcnt < 0) continue;
            this.tagcnt += 4;
        }
        if (n < 0 && this.tagcnt >= 0) {
            if (!this.isThreaded) {
                buffer2.xwrL(65536);
            }
            buffer2.xwrL(0x20000 | this.tagcnt);
        }
        return n2;
    }

    private int flush(CoreComponent.Buffer buffer) {
        int n = buffer.bib;
        buffer.rnxt(n);
        return n;
    }

    private void updateStatusKeys() {
        String[] stringArray = this.keys.getKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Object object = this.keys.get(string);
            if (object != null && !object.equals("NULL") && !object.equals("")) continue;
            this.keys.put(string, (Object)this.core.get(string));
        }
    }

    private void dumpTrace() {
        int n = this.MA.getL("/TRACESZ", 4096);
        this.ht = this.MA.getDataFile("/TRACEFN", "1000", "SL", 0);
        this.ht.setSize((double)n);
        this.ht.open(2);
        this.dt = this.ht.getDataBuffer(1);
        boolean bl = (this.tmode & 3) != 3;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = this.core.getTraceData(i);
            this.dt.setL(0, n3);
            int n4 = n2 = bl ? n3 >> 28 & 0xF : 1;
            while (n2 > 0) {
                this.ht.write(this.dt);
                --n2;
            }
        }
        this.ht.close();
    }

    private void dumpKeys() {
        String[] stringArray = this.keys.getKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            byte by = 76;
            if (string.charAt(1) == ':') {
                by = (byte)string.charAt(0);
            }
            Data data = this.core.get(string, by);
            this.MT.writeln((CharSequence)("Key=" + string + " Value=" + data + " Hex=" + Convert.l2x((int)Convert.o2l((Object)data))));
        }
    }

    public Object getNextLink() {
        return this.core;
    }

    public Object getPrevLink() {
        return null;
    }

    public String[] getKeys() {
        return this.keys.getKeys();
    }

    public Object setKey(String string, Object object) {
        Data data;
        Data data2 = data = object instanceof Data ? (Data)object : new Data(object);
        if (string.equals("STATE")) {
            this.setState((String)object);
        } else if (string.equals("MCID")) {
            this.core.setMCID(Convert.o2l((Object)object));
        } else {
            this.core.set(string, data);
        }
        return object;
    }

    public Object getKey(String string) {
        if (string.equals("STATE")) {
            return this.getState();
        }
        if (string.equals("PROGRESS")) {
            return this.getProgress();
        }
        Data data = this.core.get(string);
        if (this.verbose) {
            this.MT.writeln((CharSequence)("Get Key=" + string + " Value=" + data));
        }
        return data;
    }
}

