/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.lib.NetIO;
import nxm.sys.lib.Message;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class iceconnector
extends Primitive {
    private Table node;
    private Table nodes;
    private NetIO nio;
    private int port;
    private int xfer;
    private int nstat;
    private double timeLast;
    private double timeUpdate = 2.0;
    private String hname;
    private String haddr;
    private String addr;
    private String rname;
    private String sname;
    private byte[] msgbuf;

    public int open() {
        this.port = this.MA.getL("PORT");
        this.addr = this.MA.getS("ADDR");
        this.node = this.MA.getTable("NODE");
        this.rname = this.MA.getU("NODES");
        this.hname = this.MR.getS("ENV.HOSTNAME");
        this.haddr = this.MR.getS("ENV.HOSTADDR");
        this.sname = this.hname + "-" + this.haddr;
        this.sname = this.sname.replace(".", "_");
        this.nodes = new Table(2);
        this.nodes.put(this.sname, (Object)this.node);
        this.MR.put(this.rname, (Object)this.nodes);
        this.nio = new NetIO(true);
        String string = "udp:" + this.haddr + ":" + this.port + "/" + this.addr + ":" + this.port;
        this.M.info((CharSequence)("IceConnector opening: " + string));
        this.nstat = this.nio.open(string, 0, NetIO.INPUT | NetIO.OUTPUT);
        if (this.nstat < 0) {
            this.M.warning((CharSequence)("Problem opening: " + string + " - local reporting only"));
        }
        this.xfer = 8192;
        this.msgbuf = new byte[this.xfer];
        this.timeUpdate = this.MA.getD("/TIMEUPD", this.timeUpdate);
        return 0;
    }

    public int process() {
        int n = this.recvNode();
        double d = Time.current();
        if (d - this.timeLast > this.timeUpdate) {
            this.sendNode();
            this.timeLast = d;
        }
        return n > 0 ? 0 : -1;
    }

    public int close() {
        if (this.nstat >= 0) {
            this.nio.close();
        }
        return 0;
    }

    private int recvNode() {
        if (this.nstat < 0) {
            return 0;
        }
        int n = this.nio.recv(0, this.msgbuf, 0, this.xfer, 0);
        if (n > 0) {
            String string = new String(this.msgbuf, 0, n);
            int n2 = string.indexOf("={");
            String string2 = string.substring(0, n2);
            if (string2.equals(this.sname)) {
                return 0;
            }
            Table table = new Table(this.msgbuf, n2 + 1, n - n2 - 1);
            this.nodes.put(string2, (Object)table);
        }
        return n;
    }

    private void sendNode() {
        if (this.nstat < 0) {
            return;
        }
        String string = this.sname + "=" + this.node.toString();
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        this.nio.send(0, byArray, 0, n, 0);
    }

    public int processMessage(Message message) {
        if (message.name.equals("UPDATE")) {
            this.sendNode();
        } else if (message.name.equals("EXIT")) {
            return 9;
        }
        return 0;
    }
}

