/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.net;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import nxm.ice.net.HPage;
import nxm.ice.net.HSource;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Table;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MPanel;
import nxm.sys.libg.Theme;
import nxm.sys.prim.panel;

public class HDisplay
extends HSource {
    private Midas M;
    private panel panel;
    private GraphicsEnvironment ge;
    private GraphicsDevice gd;
    private Robot robot;
    private boolean headless;
    int[] rgb = null;
    int[] rgbs = null;

    public HDisplay(String string, Midas midas) {
        this.M = midas;
        this.name = string + "/";
        this.headless = Theme.isHeadless();
        if (!this.headless) {
            this.ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.gd = this.ge.getDefaultScreenDevice();
            try {
                this.robot = new Robot();
            }
            catch (Exception exception) {
                midas.printStackTrace((CharSequence)"Unable to instantiate Robot class for event generation ", (Throwable)exception);
            }
        }
    }

    @Override
    public void handleRequest(String string, HPage hPage) {
        String string2 = string.substring(this.name.length() + 1);
        String string3 = null;
        int n = string2.indexOf(63);
        if (n >= 0) {
            string3 = string2.substring(n + 1);
            string2 = string2.substring(0, n);
        }
        if (this.panel == null && this.M != null) {
            this.panel = (panel)this.M.registry.get("PANEL");
        }
        if (string2.length() == 0) {
            String string4 = string2 = this.panel != null ? "js/Pane0" : "js/Screen";
        }
        if (string2.startsWith("sc/")) {
            this.scPage(hPage, string2.substring(3), string3);
        } else if (string2.startsWith("js/")) {
            this.jsPage(hPage, string2.substring(3), string3);
        } else if (string2.startsWith("ws/")) {
            this.wsPage(hPage, string2.substring(3), string3);
        } else {
            this.homePage(hPage, string2);
        }
    }

    public void homePage(HPage hPage, String string) {
        int n;
        Object object;
        hPage.openToBody("HDisplay " + string);
        hPage.writeln("<br>");
        hPage.writeln("<center><h3> Display Capture </h3></center>");
        hPage.writeln("<br>");
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[i];
            object = graphicsDevice.getDefaultConfiguration().getBounds();
            int n2 = (int)((Rectangle)object).getWidth();
            int n3 = (int)((Rectangle)object).getHeight();
            hPage.writeln("<center><a href='sc/Screen'>Full Session Screen (" + n2 + "x" + n3 + ")</a></center>");
        }
        panel.Pane[] paneArray = this.panel.getPanesArray();
        for (n = 0; n < paneArray.length; ++n) {
            object = n == 0 ? "APP" : paneArray[n].name;
            String string2 = n == 0 ? this.M.macro.args.name : paneArray[n].title;
            hPage.writeln("<center><a href='sc/Pane" + n + "'>" + (String)object + " = " + string2 + "</a></center>");
        }
        hPage.writeln("<br>");
        hPage.writeln("<center><h3> Display Server </h3></center>");
        hPage.writeln("<br>");
        hPage.writeln("<center><a href='js/Screen'>Full Session Screen</a></center>");
        for (n = 0; n < paneArray.length; ++n) {
            object = n == 0 ? "APP" : paneArray[n].name;
            String string3 = n == 0 ? this.M.macro.args.name : paneArray[n].title;
            hPage.writeln("<center><a href='js/Pane" + n + "'>" + (String)object + " = " + string3 + "</a></center>");
        }
        hPage.closeFromBody();
    }

    public void scPage(HPage hPage, String string, String string2) {
        Object object;
        Rectangle rectangle = null;
        if (!this.headless) {
            rectangle = this.gd.getDefaultConfiguration().getBounds();
        }
        if (string.startsWith("Pane")) {
            int n = Convert.s2l((String)string.substring(4));
            object = this.panel.getPanesArray();
            panel.Pane pane = object[n];
            MBox mBox = this.panel.MW.pos;
            if (n == 0) {
                rectangle.setBounds(mBox.x, mBox.y, mBox.w, mBox.h);
            } else {
                rectangle.setBounds(mBox.x + pane.pos.x, mBox.y + pane.pos.y, pane.pos.w, pane.pos.h);
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = this.robot.createScreenCapture(rectangle);
            ImageIO.write((RenderedImage)object, "png", byteArrayOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        hPage.setContentType("image/png");
        hPage.setContentLength(byteArrayOutputStream.size());
        hPage.open();
        if (!hPage.getMethod().equals("HEAD")) {
            hPage.write(byteArrayOutputStream);
        }
        hPage.close();
    }

    public MBox getMBox(String string) {
        MBox mBox = new MBox();
        Data data = (Data)Convert.s2o((String)string, (char)'L', (Object)this.M);
        mBox.x = data.getL(0);
        mBox.y = data.getL(1);
        mBox.w = data.getL(2);
        mBox.h = data.getL(3);
        return mBox;
    }

    public void jsPage(HPage hPage, String string, String string2) {
        MBox mBox = new MBox(0, 0, 100, 100);
        if (string.startsWith("Pane")) {
            int n = Convert.s2l((String)string.substring(4));
            panel.Pane[] paneArray = this.panel.getPanesArray();
            panel.Pane pane = paneArray[n];
            mBox = new MBox(this.panel.MW.pos);
            if (n > 0) {
                mBox.setBounds(mBox.x + pane.pos.x, mBox.y + pane.pos.y, pane.pos.w, pane.pos.h);
            }
            if (string2 != null && string2.startsWith("insets=(")) {
                MBox mBox2 = this.getMBox(string2.substring(7));
                mBox.x -= mBox2.x;
                mBox.w += mBox2.x + mBox2.y;
                mBox.y -= mBox2.w;
                mBox.h += mBox2.w + mBox2.h;
            }
        } else {
            Rectangle rectangle = this.gd.getDefaultConfiguration().getBounds();
            mBox.w = (int)rectangle.getWidth();
            mBox.h = (int)rectangle.getHeight();
        }
        String string3 = this.server.getHostAddr();
        int n = this.server.getPort();
        hPage.openUpToBody("HDisplay " + string);
        hPage.writeln("<script type='text/javascript' src='/nmroot/nxm/ice/net/hdisplay.js'></script>");
        hPage.writeln("<body onload=\"hdisplay('" + string3 + "'," + n + "," + mBox.x + "," + mBox.y + "," + mBox.w + "," + mBox.h + ",'" + string + "');\">");
        hPage.writeln("<canvas id=canvas width='" + mBox.w + "' height='" + mBox.h + "'></canvas>");
        hPage.closeFromBody();
    }

    public void wsPage(HPage hPage, String string, String string2) {
        int n;
        Object object;
        Rectangle rectangle = null;
        if (string2 != null && string2.startsWith("pos=(")) {
            object = this.getMBox(string2.substring(4));
            rectangle = new Rectangle(object.x, object.y, object.w, object.h);
        } else {
            rectangle = this.headless ? new Rectangle(0, 0, 1280, 1024) : this.gd.getDefaultConfiguration().getBounds();
        }
        hPage.openWS("vnc-client");
        if (this.rgbs != null) {
            for (int i = 0; i < this.rgbs.length; ++i) {
                this.rgbs[i] = 0;
            }
        }
        object = new byte[1040];
        while (this.panel.state == 2 && (n = hPage.recvWS((byte[])object, 0, ((MBox)object).length)) >= 0) {
            int n2;
            int n3;
            int n4;
            if (n == 3 && object[0] == 82 && object[1] == 85) {
                this.updateRFB(hPage, rectangle, (byte[])object);
                for (int i = 0; i < 8; ++i) {
                    object[i] = (MBox)false;
                }
                hPage.sendWS((byte[])object, 0, 8);
                continue;
            }
            object[2] = (MBox)123;
            object[n] = (MBox)125;
            Table table = new Table((byte[])object, 2, n - 1);
            int n5 = table.getL("X", 0);
            int n6 = table.getL("Y", 0);
            if (n5 > 0 || n6 > 0) {
                this.robot.mouseMove(n5 + (int)rectangle.getX(), n6 + (int)rectangle.getY());
            }
            int n7 = (n4 = Math.abs(n3 = table.getL("B", 0))) == 3 ? 4096 : (n2 = n4 == 2 ? 2048 : 1024);
            if (n3 > 0) {
                this.robot.mousePress(n2);
            }
            if (n3 < 0) {
                this.robot.mouseRelease(n2);
            }
            int n8 = table.getL("K", 0);
            int n9 = this.keymap(Math.abs(n8));
            if (n8 > 0) {
                this.robot.keyPress(n9);
            }
            if (n8 >= 0) continue;
            this.robot.keyRelease(n9);
        }
        hPage.closeWS();
    }

    private void updateRFB(HPage hPage, Rectangle rectangle, byte[] byArray) {
        int n = (int)rectangle.getWidth();
        int n2 = (int)rectangle.getHeight();
        int n3 = n2 * n;
        int n4 = 0;
        int n5 = 0;
        if (this.rgb == null || n3 > this.rgb.length) {
            this.rgb = new int[n3];
            this.rgbs = new int[n3];
        }
        BufferedImage bufferedImage = this.getImage1(rectangle);
        bufferedImage.getRGB(0, 0, n, n2, this.rgb, 0, n);
        for (int i = 0; i < n2; i += 16) {
            if (i + 16 > n2) {
                i = n2 - 16;
            }
            for (int j = 0; j < n; j += 16) {
                if (j + 16 > n) {
                    j = n - 16;
                }
                int[] nArray = Convert.castL((byte[])byArray, (boolean)false);
                boolean bl = true;
                int n6 = i * n + j;
                int n7 = 2;
                int n8 = 0;
                while (n8 < 16) {
                    int n9 = 0;
                    while (n9 < 16) {
                        int n10;
                        nArray[n7] = n10 = this.rgb[n6];
                        if (n10 != this.rgbs[n6]) {
                            bl = false;
                            this.rgbs[n6] = n10;
                        }
                        ++n9;
                        ++n6;
                        ++n7;
                    }
                    ++n8;
                    n6 += n - 16;
                }
                nArray[0] = i << 16 | j;
                nArray[1] = 0x100010;
                Convert.uncast((int[])nArray, (byte[])byArray, (boolean)false);
                if (!bl) {
                    for (n8 = 8; n8 < 1032; n8 += 4) {
                        byte by = byArray[n8];
                        byArray[n8] = byArray[n8 + 2];
                        byArray[n8 + 2] = by;
                    }
                    hPage.sendWS(byArray, 0, 1032);
                    ++n5;
                }
                ++n4;
            }
        }
    }

    private BufferedImage getImage1(Rectangle rectangle) {
        BufferedImage bufferedImage = this.robot.createScreenCapture(rectangle);
        return bufferedImage;
    }

    private BufferedImage getImage2(Rectangle rectangle) {
        Container container = this.panel.MW.panel;
        Rectangle rectangle2 = container.getBounds();
        int n = container.getX();
        int n2 = container.getY();
        int n3 = container.getWidth();
        int n4 = container.getHeight();
        try {
            BufferedImage bufferedImage = new BufferedImage(n3, n4, 1);
            Graphics graphics = bufferedImage.getGraphics();
            container.paint(graphics);
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = container.getComponent(i);
                if (!(component instanceof MPanel)) continue;
                MPanel mPanel = (MPanel)component;
                Rectangle rectangle3 = mPanel.getBounds();
                if (!(mPanel.MW instanceof GWidget) || !rectangle2.contains(rectangle3.getX(), rectangle3.getY())) continue;
                graphics.translate((int)rectangle3.getX() - n, (int)rectangle3.getY() - n2);
                mPanel.paint(graphics);
            }
            return bufferedImage;
        }
        catch (Exception exception) {
            System.out.println("Unable to export image: " + exception);
            return null;
        }
    }

    private int keymap(int n) {
        switch (n) {
            case 13: {
                n = 10;
                break;
            }
            case 46: {
                n = 127;
                break;
            }
            case 188: {
                n = 44;
                break;
            }
            case 190: {
                n = 46;
                break;
            }
        }
        return n;
    }
}

