/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.libg;

import java.awt.Color;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Position;
import nxm.sys.lib.Table;
import nxm.sys.libg.Layer;
import nxm.sys.libg.MColor;

public class LayerTV
extends Layer {
    private int nx;
    private int ny;
    private int nchan;
    private int nfs;
    private int bpe;
    private double factor;
    private double delx;
    private double xframe;
    private DataFile df;
    private int select = -1;
    private int selected = -1;
    private int single = -1;
    private int[] lbuf;
    private int[] bits;
    private int[] offs;
    private boolean clear;
    private String[] names;
    private Color cgrid = new Color(0x505050);
    private Color cselect = null;
    private static int MAXFRAME = 32768;

    public LayerTV() {
        super("TV");
    }

    public boolean setFile(PlotFile plotFile, Table table, Args args) {
        this.setFile(plotFile);
        this.df = (DataFile)plotFile;
        this.nfs = (int)this.df.getSize();
        this.bpe = (int)this.df.getBPE();
        boolean bl = this.isPaged = this.nfs > MAXFRAME;
        if (this.isPaged) {
            this.nfs = MAXFRAME;
        }
        this.setXAxis(plotFile.getXStart(), plotFile.getXDelta());
        this.lbuf = new int[this.nfs];
        this.setNChan(this.bpe * 8);
        this.setup();
        return true;
    }

    public void setNChan(int n) {
        this.nchan = n;
        this.nx = 1;
        this.ny = this.nchan;
        this.bits = new int[n];
        this.offs = new int[n];
        this.names = new String[n];
        for (int i = 0; i < n; ++i) {
            this.offs[i] = i;
            this.bits[i] = 1;
            this.names[i] = "Bit" + i;
        }
        this.setYAxis(0.0, this.ny);
    }

    public int getNChan() {
        return this.nchan;
    }

    private void redo() {
        this.findRange();
        this.MP.findRange();
        this.MP.useRange();
        this.MP.setup();
        this.refresh();
    }

    private void setup() {
        this.delx = this.df.getXDelta();
        this.setFrame(this.nfs);
        this.setSize(1);
        this.setData(this.df.getDataBuffer(this.nfs));
        this.setColor(1);
        this.ndata = 0;
    }

    public int getData(int n) {
        int n2 = 0;
        if (this.df == null || !this.df.isOpen() || this.data == null || this.isDone) {
            return n2;
        }
        int n3 = (int)this.df.avail();
        if (n3 > 0) {
            if (n3 > this.nfs) {
                n3 = this.nfs;
            }
            this.fseek = this.pf.seek();
            if (this.isPaged) {
                double d = this.df.getStart();
                double d2 = this.df.getDelta();
                n3 = Math.min(n3, (int)((this.MP.rx2 - d) / d2 - this.fseek + 2.0));
                this.setXStart(d + this.fseek * d2);
                if (this.isReset) {
                    this.xframe = this.xstart;
                }
            }
        }
        if (n3 > 0) {
            n3 = this.df.read(this.data, n3);
            if (this.bpe == 1) {
                for (int i = 0; i < n3; ++i) {
                    this.lbuf[i] = this.data.getB(i);
                }
            }
            if (this.bpe == 2) {
                for (int i = 0; i < n3; ++i) {
                    this.lbuf[i] = this.data.getI(i);
                }
            }
            if (this.bpe == 4) {
                for (int i = 0; i < n3; ++i) {
                    this.lbuf[i] = this.data.getL(i);
                }
            }
            this.ndata = n3;
            n2 = this.isPaged ? 2 : 0;
            this.isReset = false;
        } else if (this.isPaged) {
            this.df.seek(this.df.getSize());
            this.setXStart(this.df.getStart());
            this.isDone = true;
            this.ndata = 0;
        } else if (!this.realtime) {
            n2 = 0;
        } else if (this.df.isStream() && !this.df.isStreaming()) {
            n2 = -1;
        }
        this.a1 = 0.0;
        this.a2 = this.ny;
        return n2;
    }

    public void findRange() {
        this.x1 = this.xstart;
        this.x2 = this.xstart + (double)(this.nfs - 2) * this.xdelta;
        this.y1 = 0.0;
        this.y2 = this.ny;
    }

    public void findFullRange() {
        this.findFullRange(this.pf);
    }

    public void findFullRange(PlotFile plotFile) {
        this.fx1 = this.x1;
        this.fx2 = this.x2;
        this.fy1 = this.y1;
        this.fy2 = this.y2;
        if (plotFile != null && !this.realtime) {
            this.fx1 = plotFile.getXStart();
            this.fx2 += plotFile.getXDelta() * plotFile.getSize();
        }
    }

    public void draw(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.needRefresh = false;
        if (!this.MP.is2D) {
            return;
        }
        Color color = this.MP.getOption(8) ? Color.black : this.MP.theme.cbg;
        double d = this.MP.mxx * this.xdelta;
        if (n != 2 || this.clear) {
            this.MP.gc.setColor(color);
            this.MP.gc.fillRect(this.MP.ix1, this.MP.iy1, this.MP.ix21, this.MP.iy21);
            this.MP.setColor(this.cgrid);
            int n6 = this.MP.ix1;
            int n7 = this.MP.ix2;
            for (n5 = 0; n5 <= this.ny; ++n5) {
                n4 = (int)(this.MP.myy * (double)n5 + this.MP.myb);
                if (n4 > this.MP.iy1 && n4 < this.MP.iy2) {
                    this.MP.gc.drawLine(this.MP.ix1, n4, this.MP.ix2, n4);
                }
                if (!(d > 5.0)) continue;
                for (n3 = 0; n3 < this.nfs; ++n3) {
                    n2 = (int)(this.MP.mxx * (this.xframe + this.xdelta * (double)n3) + this.MP.mxb);
                    if (n2 <= this.MP.ix1 || n2 >= this.MP.ix2) continue;
                    this.MP.gc.drawLine(n2, n4 + 2, n2, n4 - 2);
                }
            }
            this.clear = false;
        }
        if (this.ndata <= 0) {
            return;
        }
        for (int i = 0; i < this.nchan; ++i) {
            int n8 = this.bits[i];
            int n9 = this.offs[i];
            int n10 = (1 << n8) - 1;
            n2 = 0;
            n4 = i;
            n5 = this.MP.myy > 0.0 ? n4 : n4 + 1;
            int n11 = (int)(this.MP.myy * (double)n5 + this.MP.myb) + 3;
            n5 = this.MP.myy > 0.0 ? n4 + 1 : n4;
            int n12 = (int)(this.MP.myy * (double)n5 + this.MP.myb) - 3;
            if (n11 > this.MP.iy2 || n12 < this.MP.iy1) continue;
            double d2 = 0.0;
            double d3 = n10;
            double d4 = (double)(n11 - n12) / (d3 - d2);
            double d5 = (double)n12 - d2 * d4;
            int n13 = n11 + 1;
            int n14 = n12 - 1;
            int[] nArray = this.MP.pix.x;
            int[] nArray2 = this.MP.pix.y;
            int n15 = nArray.length;
            n3 = 0;
            n5 = 0;
            while (n5 < this.ndata) {
                if (n3 == n15) {
                    this.MP.drawPixels(nArray, nArray2, n15, this.line);
                    n3 = 0;
                }
                n2 = (int)(this.MP.mxx * (this.xstart + this.xdelta * (double)n5) + this.MP.mxb);
                int n16 = this.lbuf[n5] >> n9 & n10;
                n4 = (int)((double)n16 * d4 + d5);
                if (n4 < n13) {
                    n4 = n13;
                } else if (n4 > n14) {
                    n4 = n14;
                }
                nArray[n3] = n2;
                nArray2[n3] = n4;
                ++n5;
                ++n3;
            }
            this.MP.drawPixels(nArray, nArray2, n3, this.line);
        }
    }

    public void setTraceConfig(String string) {
        if (string.equals("NONE")) {
            return;
        }
        if (string.startsWith("{")) {
            string = string.substring(1, string.length() - 1);
        }
        Parser parser = new Parser(string);
        this.setNChan(parser.elements());
        int n = 0;
        for (int i = 0; i < this.nchan; ++i) {
            String string2;
            this.names[i] = string2 = parser.get(this.nchan - i);
            this.bits[i] = 1;
            this.offs[i] = n;
            if (string2.endsWith("]")) {
                int n2 = string2.indexOf("[");
                int n3 = string2.indexOf(":");
                if (n2 > 0 && n3 > 0) {
                    this.bits[i] = Convert.s2l((String)string2.substring(n2 + 1, n3)) - Convert.s2l((String)string2.substring(n3 + 1, string2.length() - 1)) + 1;
                }
            }
            n += this.bits[i];
        }
        System.out.println("TraceConfig {" + string + "} nchan=" + this.nchan + " Bits=" + n);
    }

    private int getChan(Position position) {
        int n = (int)position.y;
        this.select = n < 0 || n >= this.ny ? -1 : n;
        return this.select;
    }

    public void select(Position position) {
        this.select = this.getChan(position);
    }

    public int select() {
        return this.select;
    }

    public int getSelect() {
        return this.select;
    }

    public void setSelect(int n) {
        this.selected = n;
    }

    public void setSelectColor(String string) {
        this.cselect = MColor.getColor((Object)string);
    }

    public void single(int n) {
        this.single = n;
    }

    public int single() {
        return this.single;
    }

    public String getReadOut(Position position) {
        int n = (int)position.y;
        int n2 = (int)((position.x - this.xframe) / this.xdelta);
        int n3 = n;
        int n4 = 1;
        int n5 = 1;
        String string = "Bit" + n;
        int n6 = 0;
        if (n >= 0 && n < this.nchan && n2 > 0 && n2 < this.nfs) {
            string = this.names[n];
            n4 = this.bits[n];
            n3 = this.offs[n];
            n5 = (1 << n4) - 1;
            n6 = this.lbuf[n2] >> n3 & n5;
        }
        String string2 = "" + n6;
        if (string.indexOf(91) > 0) {
            string2 = Convert.l2x((int)n6);
            while (string2.length() > 3 && string2.indexOf("0x0") == 0) {
                string2 = string2.replace("0x0", "0x");
            }
        }
        String string3 = " TV (" + string + "=" + string2 + ")";
        return string3;
    }
}

