/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.libg;

import java.awt.Color;
import java.awt.image.ImageObserver;
import nxm.ice.lib.ICEPacket;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Position;
import nxm.sys.lib.Table;
import nxm.sys.libg.Layer;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MImage;
import nxm.sys.libg.MWindow;
import nxm.sys.libm.Fft;
import nxm.sys.libm.LogarithmBounded;
import nxm.sys.libm.MagSquared;
import nxm.sys.libm.Multiply;
import nxm.sys.libm.Window;

public class LayerMC
extends Layer {
    private float[] fbuf;
    private float[] wind;
    private float[] fbs;
    private ICEPacket pkth;
    private int nx;
    private int ny;
    private int nchan;
    private int ichan;
    private int nfft;
    private int navg;
    private int nout;
    private int nrot;
    private int spa;
    private int nfftx;
    private int navgx;
    private int nfs;
    private int iyrast;
    private int myrast;
    private int iexp;
    private double factor;
    private double delx;
    private double delf;
    private double dbRange = 120.0;
    private double fixMin;
    private double fixMax;
    private double minRange;
    private double maxRange;
    private DataFile df;
    private Fft fft;
    private int skip = 1;
    private int select = -1;
    private int selected = -1;
    private int single = -1;
    private int scaling = S_AUTOP;
    private String wname = "HANN";
    private int type = T_LINE;
    private int proc = P_FFT;
    private int keep = 0;
    private int[] ikeep;
    private boolean demux;
    private double a1s;
    private double a2s;
    private double asrat = 0.9;
    private MImage mimage;
    private byte[] buf;
    private boolean yx = false;
    private boolean clear;
    private boolean first;
    private double[] ca1s;
    private double[] ca2s;
    private Color cgrid = new Color(0x505050);
    private Color cselect = null;
    private int[] iyrasts;
    private int mcs = 0;
    public static String typeList = "Line,Raster,Point,XYPoint";
    public static String processList = "Raw,Magnitude,FFT,Histogram,Envelope";
    public static String windowList = Window.nameList;
    public static String scalingList = "FixMin,FixMax,AutoChan,AutoPage";
    private static int T_LINE = 1;
    private static int T_RASTER = 2;
    private static int T_POINT = 3;
    private static int T_XYPOINT = 4;
    private static int P_RAW = 1;
    private static int P_MAG = 2;
    private static int P_FFT = 3;
    private static int P_HIST = 4;
    private static int P_ENV = 5;
    private static int S_FIXMIN = 1;
    private static int S_FIXMAX = 2;
    private static int S_AUTOC = 4;
    private static int S_AUTOP = 8;

    public LayerMC() {
        this.name = "MC";
        this.zaxis = true;
    }

    public boolean setFile(PlotFile plotFile, Table table, Args args) {
        this.setFile(plotFile);
        this.df = (DataFile)plotFile;
        this.pkth = (ICEPacket)this.df.getPacketHandler();
        if (this.pkth != null) {
            this.nfs = this.pkth.getFixedSize();
        } else if (this.mcs > 0) {
            this.nfs = 256;
        } else if (this.df.typeClass == 2) {
            this.nfs = this.df.getFrameSize();
        } else {
            throw new MidasException("LayerMC input must be framed as type2000 or ICE Packets");
        }
        this.df.setDFS(0);
        this.cmap = args.getSelectionIndex("CMAP", "GrayScale,Ramp,XRamp,Wheel,Terrain,Multi,T5Layer,MapLine,Grid,Spectrum,XDatalist", 2);
        this.cmap = args.getSelectionIndex("/CMAP", "GrayScale,Ramp,XRamp,Wheel,Terrain,Multi,T5Layer,MapLine,Grid,Spectrum,XDatalist", this.cmap);
        this.ncolors = args.getL("NC", 32);
        this.colors = MColor.getColorMap((int)this.cmap, (int)this.ncolors);
        this.spa = this.df.getSPA();
        this.setNChan(0);
        this.setNFft(256);
        this.ichan = 0;
        this.first = true;
        return true;
    }

    public void setKeep(int n) {
        this.keep = n;
        this.ikeep = new int[this.nchan];
    }

    public void update() {
        if (this.ndata > 0) {
            this.process();
        }
    }

    public void setNChan(int n) {
        int n2 = 0;
        for (int i = 2; i <= 6; ++i) {
            if (i * i != n) continue;
            this.nx = this.ny = i;
            n2 = this.ny;
        }
        if (n2 == 0) {
            this.nx = 1;
            while (this.nx < 64) {
                this.ny = 1;
                while (this.ny < this.nx * 2 && this.nx * this.ny < n) {
                    ++this.ny;
                }
                if (this.nx * this.ny >= n) break;
                this.nx *= 2;
            }
        }
        this.nchan = n;
        this.setXAxis(0.0, this.nx);
        this.setYAxis(0.0, this.ny);
    }

    public int getNChan() {
        return this.nchan;
    }

    private void redo() {
        this.findRange();
        this.MP.findRange();
        this.MP.useRange();
        this.MP.setup();
        this.refresh();
    }

    public void setNX(int n) {
        this.nx = Math.max(1, n);
        this.setXAxis(0.0, this.nx);
        if (this.nchan > 0) {
            this.setNY((this.nchan - 1) / this.nx + 1);
        }
    }

    public int getNX() {
        return this.nx;
    }

    public void setNY(int n) {
        this.ny = Math.max(1, n);
        if (this.nchan <= 0) {
            this.nchan = this.nx * this.ny;
        }
        this.setYAxis(0.0, this.ny);
    }

    public int getNY() {
        return this.ny;
    }

    public void setWindow(String string) {
        this.wname = string;
        this.wind = Window.get((String)string, (int)this.nfft, (double)this.factor);
    }

    public String getWindow() {
        return this.wname;
    }

    public void setProcess(String string) {
        this.proc = Parser.find((String)processList, (String)string, (int)0);
        this.nfftx = this.nfft;
        this.clear = true;
    }

    public String getProcess() {
        return Parser.get((String)processList, (int)this.proc);
    }

    public void setType(String string) {
        this.type = Parser.find((String)typeList, (String)string, (int)0);
        this.clear = true;
    }

    public String getType() {
        return Parser.get((String)typeList, (int)this.type);
    }

    public void setMCS(int n) {
        this.mcs = n;
        if (n > 0) {
            this.nfs = 256;
        }
    }

    public void setNFft(int n) {
        this.nfftx = n;
    }

    public int getNFft() {
        return this.nfft;
    }

    public void setNAvg(int n) {
        this.navgx = n;
    }

    public int getNAvg() {
        return this.navg;
    }

    public void setMin(double d) {
        this.fixMin = d;
        this.scaling |= S_FIXMIN;
    }

    public double getMin() {
        return this.fixMin;
    }

    public void setMax(double d) {
        this.fixMax = d;
        this.scaling |= S_FIXMAX;
    }

    public double getMax() {
        return this.fixMax;
    }

    public void setMinRange(double d) {
        this.minRange = d;
    }

    public double getMinRange() {
        return this.minRange;
    }

    public void setMaxRange(double d) {
        this.maxRange = d;
    }

    public double getMaxRange() {
        return this.maxRange;
    }

    public void setDbRange(double d) {
        this.dbRange = d;
    }

    public double getDbRange() {
        return this.dbRange;
    }

    public void setAutoScaleRatio(double d) {
        this.asrat = d;
    }

    public double getAutoScaleRatio() {
        return this.asrat;
    }

    public void setScaling(String string) {
        this.scaling = Parser.mask((String)scalingList, (String)string, (int)this.scaling);
    }

    public String getScaling() {
        return Parser.mask2s((String)scalingList, (int)this.scaling);
    }

    private void setup() {
        this.delx = this.df.getXDelta();
        this.delf = 1.0 / ((double)this.nfft * this.delx);
        int n = 40;
        if (this.proc == P_FFT) {
            if (this.spa == 2) {
                this.nout = this.nfft;
                this.nrot = this.nfft / 2 - 1;
                n |= 2;
                this.factor = 1.0 / (double)this.nfft;
            } else {
                this.nout = this.nfft / 2;
                this.nrot = 0;
                n |= 1;
                this.factor = 1.0 / (double)(2 * this.nfft);
            }
            this.fft = new Fft(this.nfft, n);
            this.fbuf = new float[this.nout * 2];
        } else {
            this.nout = this.nfft;
            this.fbuf = new float[this.nout * this.spa];
            if (this.type == T_POINT || this.type == T_XYPOINT) {
                this.line.setType(2);
            }
        }
        this.setFrame(this.nout);
        this.setSize(1);
        this.setData(this.df.getDataBuffer(this.nfft));
        this.setColor(1);
        this.setWindow(this.wname);
        this.ndata = 0;
        this.iyrast = 0;
        this.iyrasts = new int[this.nchan];
        if (this.type != T_RASTER && this.nchan <= 16) {
            this.fbs = new float[this.nout * this.spa * this.nchan];
        }
    }

    public int getData(int n) {
        int n2 = 0;
        if (this.df == null || !this.df.isOpen()) {
            return 0;
        }
        if (this.nfftx > 0) {
            this.nfft = this.nfftx;
            this.setup();
            this.nfftx = 0;
        }
        int n3 = 0;
        int n4 = (int)this.df.avail();
        if (n4 > 0) {
            n4 = Math.min(this.nfft, this.nfs);
            this.myrast = (int)(this.MP.myy > 0.0 ? this.MP.myy : -this.MP.myy) - 4;
            if (this.pkth == null) {
                this.df.read(this.data, n4);
                if (this.nfs > this.nfft) {
                    this.df.skip(this.nfs - this.nfft);
                }
                if (this.mcs > 0) {
                    this.ichan = this.getMCSchan(this.data.buf);
                } else {
                    this.ichan = this.ichan % this.nchan + 1;
                    if (this.ichan == this.nchan && this.skip > 1) {
                        this.df.skip(this.nfs * this.nchan * (this.skip - 1));
                    }
                }
                if (this.ichan <= 1 && ++this.iyrast > this.myrast) {
                    this.iyrast = 0;
                }
            } else {
                this.df.read(this.data, n4);
                n4 = this.pkth.getSize();
                this.ichan = this.pkth.getChannel();
                if (n4 > this.nfft) {
                    this.df.skip(n4 - this.nfft);
                }
                if ((n2 = this.ichan - 1) < 0 || n2 >= this.nchan) {
                    n2 = 0;
                }
                this.iyrast = this.iyrasts[n2];
                if (++this.iyrast > this.myrast) {
                    this.iyrast = 0;
                }
                this.iyrasts[n2] = this.iyrast;
            }
            this.process();
            n3 = 2;
        } else if (!this.realtime) {
            n3 = 0;
        } else if (this.df.isStream() && !this.df.isStreaming()) {
            n3 = -1;
        }
        return n3;
    }

    public void process() {
        boolean bl;
        int n;
        int n2;
        this.ndata = 0;
        if (this.data == null) {
            return;
        }
        this.navg = this.navgx;
        if (this.single >= 0 && this.ichan != this.single) {
            return;
        }
        int n3 = this.ichan - 1;
        if (this.yx) {
            n2 = n3 / this.ny;
            n = n3 - n2 * this.ny;
        } else {
            n = n3 / this.nx;
            n2 = n3 - n * this.nx;
        }
        if (this.MP.mxx > 0.0) {
            if ((int)(this.MP.mxx * (double)n2 + this.MP.mxb) > this.MP.ix2) {
                return;
            }
            if ((int)(this.MP.mxx * (double)(n2 + 1) + this.MP.mxb) < this.MP.ix1) {
                return;
            }
        }
        if (this.MP.myy > 0.0) {
            if ((int)(this.MP.myy * (double)n + this.MP.myb) > this.MP.iy2) {
                return;
            }
            if ((int)(this.MP.myy * (double)(n + 1) + this.MP.myb) < this.MP.iy1) {
                return;
            }
        }
        boolean bl2 = bl = (this.scaling & S_AUTOC) != 0;
        if (this.proc == P_FFT) {
            this.processFFT();
        } else if (this.proc == P_RAW) {
            this.processRaw();
        } else if (this.proc == P_MAG) {
            this.processMag();
        } else if (this.proc == P_HIST) {
            this.processHist();
        } else if (this.proc == P_ENV) {
            this.processEnv();
        }
        if (bl && (this.ca1s == null || this.ca1s.length < this.nchan)) {
            this.ca1s = new double[this.nchan];
            this.ca2s = new double[this.nchan];
            for (int i = 0; i < this.nchan; ++i) {
                this.ca2s[i] = 0.0;
                this.ca1s[i] = 0.0;
            }
        }
        if (bl) {
            this.a1s = this.ca1s[n3];
            this.a2s = this.ca2s[n3];
        }
        this.a1s = this.a1 * this.asrat + this.a1s * (1.0 - this.asrat);
        this.a2s = this.a2 * this.asrat + this.a2s * (1.0 - this.asrat);
        if (this.first) {
            this.a1s = this.a1;
            this.a2s = this.a2;
            this.first = false;
        }
        double d = (this.a2s - this.a1s) * 0.05;
        this.a1 = Math.min(this.a1, this.a1s - d);
        this.a2 = Math.max(this.a2, this.a2s + d);
        if ((this.scaling & S_FIXMIN) != 0) {
            this.a1 = this.fixMin;
        }
        if ((this.scaling & S_FIXMAX) != 0) {
            this.a2 = this.fixMax;
        }
        if (bl) {
            this.ca1s[n3] = this.a1s;
            this.ca2s[n3] = this.a2s;
        }
    }

    private void processAvg(float[] fArray, int n) {
        float f = 1.0f / (float)this.navg;
        float f2 = 1.0f - f;
        int n2 = (this.ichan - 1) * this.nout * this.spa;
        int n3 = 0;
        while (n3 < n) {
            this.fbs[n2] = fArray[n3] = fArray[n3] * f + this.fbs[n2] * f2;
            ++n3;
            ++n2;
        }
    }

    private void processFFT() {
        int n;
        Convert.bb2ja((byte[])this.data.buf, (int)0, (byte)this.data.type, (Object)this.fbuf, (int)0, (byte)70, (int)(this.nfft * this.spa));
        if (this.nfs < this.nfft) {
            for (n = this.nfs * this.spa; n < this.nfft * this.spa; ++n) {
                this.fbuf[n] = 0.0f;
            }
        }
        if (this.spa == 2) {
            Multiply.CSC((float[])this.fbuf, (float[])this.wind, (float[])this.fbuf, (int)this.nfft);
        } else {
            Multiply.SSS((float[])this.fbuf, (float[])this.wind, (float[])this.fbuf, (int)this.nfft);
        }
        this.fft.work((Object)this.fbuf);
        MagSquared.CS((float[])this.fbuf, (float[])this.fbuf, (int)this.nout);
        if (this.fbs != null && this.navg > 1) {
            this.processAvg(this.fbuf, this.nout);
        }
        if (this.data.type == 66 || this.data.type == 73) {
            Native.dbf((Object)this.fbuf, (int)this.nout, (int)0);
        } else {
            LogarithmBounded.SS((float[])this.fbuf, (float[])this.fbuf, (int)this.nout, (double)Math.log(10.0));
        }
        if (this.spa == 2) {
            this.fft.rotateSF(this.fbuf);
        }
        this.a2 = this.fbuf[0];
        for (n = 1; n < this.nout; ++n) {
            if (!((double)this.fbuf[n] > this.a2)) continue;
            this.a2 = this.fbuf[n];
        }
        this.a1 = this.a2 - this.dbRange;
        this.ndata = this.nout;
    }

    private void processRaw() {
        if (this.spa == 2 && this.type == T_RASTER) {
            this.processMag();
            return;
        }
        Convert.bb2ja((byte[])this.data.buf, (int)0, (byte)this.data.type, (Object)this.fbuf, (int)0, (byte)70, (int)(this.nout * this.spa));
        this.a1 = this.a2 = (double)this.fbuf[0];
        for (int i = 1; i < this.nout * this.spa; ++i) {
            if ((double)this.fbuf[i] < this.a1) {
                this.a1 = this.fbuf[i];
            }
            if (!((double)this.fbuf[i] > this.a2)) continue;
            this.a2 = this.fbuf[i];
        }
        this.ndata = this.nout;
    }

    private void processMag() {
        if (this.spa == 1) {
            this.processRaw();
            return;
        }
        Convert.bb2ja((byte[])this.data.buf, (int)0, (byte)this.data.type, (Object)this.fbuf, (int)0, (byte)70, (int)(this.nout * this.spa));
        this.fbuf[0] = this.fbuf[0] * this.fbuf[0] + this.fbuf[1] * this.fbuf[1];
        this.a1 = this.a2 = (double)this.fbuf[0];
        int n = 1;
        int n2 = 2;
        while (n < this.nout) {
            float f = this.fbuf[n2] * this.fbuf[n2] + this.fbuf[n2 + 1] * this.fbuf[n2 + 1];
            if ((double)f < this.a1) {
                this.a1 = f;
            }
            if ((double)f > this.a2) {
                this.a2 = f;
            }
            this.fbuf[n] = f;
            ++n;
            n2 += 2;
        }
        this.ndata = this.nout;
    }

    private void processHist() {
    }

    private void processEnv() {
    }

    public void findRange() {
        this.x1 = 0.0;
        this.x2 = this.nx;
        this.y1 = 0.0;
        this.y2 = this.ny;
    }

    public void draw(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Color color;
        super.draw(n);
        if (!this.MP.is2D) {
            return;
        }
        Color color2 = color = this.MP.getOption(8) ? Color.black : this.MP.theme.cbg;
        if (n != 2 || this.clear) {
            this.MP.gc.setColor(color);
            this.MP.gc.fillRect(this.MP.ix1, this.MP.iy1, this.MP.ix21, this.MP.iy21);
            this.MP.setColor(this.cgrid);
            n8 = this.MP.myy > 0.0 ? 0 : this.ny;
            n7 = Math.max(this.MP.iy1, (int)(this.MP.myy * (double)n8 + this.MP.myb));
            n8 = this.MP.myy > 0.0 ? this.ny : 0;
            n6 = Math.min(this.MP.iy2, (int)(this.MP.myy * (double)n8 + this.MP.myb));
            for (n8 = 0; n8 <= this.nx; ++n8) {
                n5 = (int)(this.MP.mxx * (double)n8 + this.MP.mxb);
                if (n5 <= this.MP.ix1 || n5 >= this.MP.ix2) continue;
                this.MP.gc.drawLine(n5, n7, n5, n6);
            }
            n8 = this.MP.mxx > 0.0 ? 0 : this.nx;
            n4 = Math.max(this.MP.ix1, (int)(this.MP.mxx * (double)n8 + this.MP.mxb));
            n8 = this.MP.mxx > 0.0 ? this.nx : 0;
            n3 = Math.min(this.MP.ix2, (int)(this.MP.mxx * (double)n8 + this.MP.mxb));
            for (n8 = 0; n8 <= this.ny; ++n8) {
                n2 = (int)(this.MP.myy * (double)n8 + this.MP.myb);
                if (n2 <= this.MP.iy1 || n2 >= this.MP.iy2) continue;
                this.MP.gc.drawLine(n4, n2, n3, n2);
            }
            this.myrast = (int)(this.MP.myy > 0.0 ? this.MP.myy : -this.MP.myy) - 4;
            this.clear = false;
        }
        if (this.ndata <= 0) {
            return;
        }
        if (this.single >= 0 && this.ichan != this.single) {
            return;
        }
        n8 = this.ichan - 1;
        if (this.yx) {
            n5 = n8 / this.ny;
            n2 = n8 - n5 * this.ny;
        } else {
            n2 = n8 / this.nx;
            n5 = n8 - n2 * this.nx;
        }
        n8 = this.MP.mxx > 0.0 ? n5 : n5 + 1;
        n4 = (int)(this.MP.mxx * (double)n8 + this.MP.mxb) + 2;
        n8 = this.MP.mxx > 0.0 ? n5 + 1 : n5;
        n3 = (int)(this.MP.mxx * (double)n8 + this.MP.mxb) - 2;
        n8 = this.MP.myy > 0.0 ? n2 : n2 + 1;
        n7 = (int)(this.MP.myy * (double)n8 + this.MP.myb) + 2;
        n8 = this.MP.myy > 0.0 ? n2 + 1 : n2;
        n6 = (int)(this.MP.myy * (double)n8 + this.MP.myb) - 2;
        if (n4 > this.MP.ix2 || n3 < this.MP.ix1) {
            return;
        }
        if (n7 > this.MP.iy2 || n6 < this.MP.iy1) {
            return;
        }
        double d = this.a2;
        double d2 = this.a1;
        if (this.minRange != 0.0 && d - d2 < this.minRange) {
            d = d2 + this.minRange;
        }
        if (this.maxRange != 0.0 && d - d2 > this.maxRange) {
            d2 = d - this.maxRange;
        }
        if (this.type == T_RASTER) {
            if (this.buf == null || this.buf.length < this.nout) {
                this.buf = new byte[this.nout];
                this.mimage = new MImage((MWindow)this.MP, this.nout, 1, this.buf, this.colors);
            }
            int n9 = this.ncolors;
            float f = (float)d2;
            float f2 = (float)((double)this.ncolors / (d - d2));
            for (n8 = 0; n8 < this.nout; ++n8) {
                int n10 = (int)((this.fbuf[n8] - f) * f2);
                if (n10 < 0) {
                    n10 = 0;
                }
                if (++n10 > n9) {
                    n10 = n9;
                }
                this.buf[n8] = (byte)n10;
            }
            this.mimage.source.newPixels(0, 0, this.nout, 1);
            this.MP.gc.drawImage(this.mimage.image, n4, n7 + this.iyrast, n3, n7 + this.iyrast + 1, 0, 0, this.nout, 1, (ImageObserver)this.mimage);
            int n11 = n7 + this.iyrast + 1;
            int n12 = Math.max(n4, this.MP.ix1);
            int n13 = Math.min(n3, this.MP.ix2);
            int n14 = n13 - n12 >> 4;
            if (n14 < 1) {
                n14 = 1;
            }
            if (this.iyrast < this.myrast && n11 > this.MP.iy1 && n11 < this.MP.iy2) {
                this.MP.setColor(this.cgrid);
                this.MP.gc.drawLine(n12 + 1, n11, n12 + n14, n11);
                this.MP.gc.drawLine(n13 - n14, n11, n13 - 1, n11);
            }
            return;
        }
        boolean bl = true;
        n8 = this.ichan - 1;
        if (this.keep > 1 && this.ichan > 0 && this.ichan <= this.nchan) {
            int n15 = n8 = this.ichan - 1;
            this.ikeep[n15] = this.ikeep[n15] + 1;
            if (this.ikeep[n15] >= this.keep) {
                this.ikeep[n8] = 0;
            } else {
                bl = false;
            }
        }
        if (bl) {
            this.MP.gc.setColor(color);
            this.MP.gc.fillRect(n4 - 1, n7 - 1, n3 - n4 + 2, n6 - n7 + 2);
        }
        int[] nArray = this.MP.pix.x;
        int[] nArray2 = this.MP.pix.y;
        double d3 = (double)(n7 - n6) / (d - d2);
        double d4 = (double)n6 - d2 * d3;
        double d5 = (double)(n3 - n4) / (d - d2);
        double d6 = (double)n4 - d2 * d5;
        double d7 = n4;
        double d8 = (double)(n3 - n4) / (double)this.nout;
        int n16 = n7 + 1;
        int n17 = n6 - 1;
        if (this.cselect != null) {
            if (this.selected == this.ichan) {
                this.setColor(this.cselect);
            } else {
                this.setColor(1);
            }
        }
        if (this.type == T_XYPOINT && this.spa == 2) {
            int n18 = 0;
            for (n8 = 0; n8 < this.nout; ++n8) {
                n5 = (int)((double)this.fbuf[n18++] * d5 + d6);
                n2 = (int)((double)this.fbuf[n18++] * d3 + d4);
                if (n5 < n4) {
                    n5 = 1;
                } else if (n5 > n3) {
                    n5 = n3;
                }
                nArray[n8] = n5;
                if (n2 < n7) {
                    n2 = 1;
                } else if (n2 > n6) {
                    n2 = n6;
                }
                nArray2[n8] = n2;
            }
            this.MP.drawPixels(nArray, nArray2, this.nout, this.line);
        } else if (this.proc == P_RAW && this.spa == 2) {
            int n19;
            n8 = 0;
            int n20 = 0;
            while (n8 < this.nout) {
                nArray[n8] = (int)d7;
                n19 = (int)((double)this.fbuf[n20] * d3 + d4);
                if (n19 < n16) {
                    n19 = n16;
                } else if (n19 > n17) {
                    n19 = n17;
                }
                nArray2[n8] = n19;
                ++n8;
                n20 += 2;
                d7 += d8;
            }
            this.MP.drawPixels(nArray, nArray2, this.nout, this.line);
            n8 = 0;
            n20 = 1;
            while (n8 < this.nout) {
                n19 = (int)((double)this.fbuf[n20] * d3 + d4);
                if (n19 < n16) {
                    n19 = n16;
                } else if (n19 > n17) {
                    n19 = n17;
                }
                nArray2[n8] = n19;
                ++n8;
                n20 += 2;
            }
            this.MP.drawPixels(nArray, nArray2, this.nout, this.line);
        } else {
            n8 = 0;
            while (n8 < this.nout) {
                nArray[n8] = (int)d7;
                int n21 = (int)((double)this.fbuf[n8] * d3 + d4);
                if (n21 < n16) {
                    n21 = n16;
                } else if (n21 > n17) {
                    n21 = n17;
                }
                nArray2[n8] = n21;
                ++n8;
                d7 += d8;
            }
            this.MP.drawPixels(nArray, nArray2, this.nout, this.line);
        }
    }

    private int getChan(Position position) {
        int n = (int)position.x;
        int n2 = (int)position.y;
        this.select = n < 0 || n >= this.nx || n2 < 0 || n2 >= this.ny ? 0 : (this.yx ? n * this.ny + n2 + 1 : n2 * this.nx + n + 1);
        return this.select;
    }

    public void select(Position position) {
        this.select = this.getChan(position);
    }

    public int select() {
        return this.select;
    }

    public int getSelect() {
        return this.select;
    }

    public void setSelect(int n) {
        this.selected = n;
    }

    public void setSelectColor(String string) {
        this.cselect = MColor.getColor((Object)string);
    }

    public void single(int n) {
        this.single = n;
    }

    public int single() {
        return this.single;
    }

    public void skip(int n) {
        this.skip = n;
    }

    public int skip() {
        return this.skip;
    }

    public String getReadOut(Position position) {
        int n;
        int n2 = this.getChan(position);
        double d = position.x % 1.0;
        double d2 = position.y % 1.0;
        int n3 = (int)(d * (double)this.nout);
        d2 = this.a1 + (1.0 - d2) * (this.a2 - this.a1);
        int n4 = this.getTicExp(0.0, this.a2 - this.a1);
        if (this.proc == P_FFT) {
            d = (double)(n3 - this.nrot) * this.delf;
            n = this.getTicExp(0.0, this.delf * (double)this.nout);
        } else if (this.type == T_XYPOINT) {
            d = this.a1 + d * (this.a2 - this.a1);
            n = n4;
        } else {
            d = (double)n3 * this.delx;
            n = this.getTicExp(0.0, this.delx * (double)this.nout);
        }
        String string = " MC (Chan=" + n2 + " x=" + this.MP.formNumber(d, n, 0);
        if (this.type != T_RASTER) {
            string = string + " y=" + this.MP.formNumber(d2, n4, 0);
        }
        if (this.type != T_RASTER && this.proc == P_FFT && n2 > 0 && this.ca2s != null) {
            string = string + " dyPk=" + this.MP.formNumber(d2 - this.ca2s[n2 - 1], n4, 0);
        }
        string = string + ")";
        return string;
    }

    private int getTicExp(double d, double d2) {
        double d3 = Math.max(Math.abs(d), Math.abs(d2));
        if (d3 == 0.0) {
            return 0;
        }
        int n = (int)(0.1447648 * Math.log(d3 / 2.0));
        if (d3 < 1.0) {
            --n;
        }
        return n * 3;
    }

    public void setYX(boolean bl) {
        this.yx = bl;
    }

    public int getMCSchan(byte[] byArray) {
        int n = (byArray[0] & 1) << 0 | (byArray[2] & 1) << 1 | (byArray[4] & 1) << 2 | (byArray[6] & 1) << 3;
        if (++n >= this.mcs) {
            n = this.mcs;
        }
        return n;
    }
}

