/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.DevIce;
import nxm.ice.lib.IceBlockResource;
import nxm.ice.lib.RamDiskResource;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.Args;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Results;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;

public class MDevIce
extends DevIce
implements Keyable {
    public Midas M;
    public String config;

    public MDevIce() {
        this.config = "ICEPIC,DEVNO=0,AUTODETECT,";
        MDevIce.load();
    }

    public MDevIce(Args args, String string) {
        this(args.M, MDevIce.getConfig(args, string));
    }

    public MDevIce(Midas midas, String string) {
        this.M = midas;
        this.config = string;
        MDevIce.load();
    }

    public static boolean load() {
        if (!useNative) {
            try {
                useNative = Shell.loadLibrary((String)"ice", (String)"lib", (String)"DevIce");
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return useNative;
    }

    public static int detect() {
        return MDevIce.detect(0);
    }

    public static int detect(int n) {
        MDevIce.load();
        return DevIce.detect(n);
    }

    @Override
    public int open(String string, int n) {
        int n2 = super.open(string, n);
        long l = this.getIntFlagDef("MAXALLOC", -1);
        if (l > 0L) {
            this.setMaxAlloc(l << 20);
        }
        return n2;
    }

    public int open(int n) {
        return this.open(this.config, n);
    }

    public int open() {
        return this.open(this.config, 0);
    }

    public static String getConfig(Args args, String string) {
        int n;
        Object object;
        String string2 = args.M.results.getString("ENV.HWFILE");
        Data data = args.M.results.getData("ENV.ICEPICS");
        String string3 = null;
        String string4 = string;
        if (string4 == null || string4.length() == 0) {
            return null;
        }
        if (string4.equals("DUMMY")) {
            return "DEVNO=99,TEST,NOLOCK,";
        }
        for (Results results = args.M.results; results != null && string3 == null; results = results.getPrevious()) {
            object = results.get("HWALIAS." + string);
            if (object != null && object instanceof String) {
                string3 = (String)object;
            }
            if ((object = results.get("HWALIAS_" + string)) == null || !(object instanceof String)) continue;
            string3 = (String)object;
        }
        if (string3 != null) {
            string4 = string3;
        } else if (string2 != null) {
            int n2;
            object = new DataFile();
            object.init((MidasReference)args.M, (Object)string2);
            object.open();
            Object object2 = object.keywords.get(string);
            if (object2 instanceof String) {
                string4 = (String)object2;
            }
            if (string4.startsWith("ALIAS=") && (object2 = object.keywords.get(string = string4.substring(6, n2 = string4.indexOf(44)))) instanceof String) {
                string4 = (String)object2 + string4.substring(n2);
            }
            object.close();
        }
        string4 = string4.trim();
        if (!string4.endsWith(",")) {
            string4 = string4 + ",";
        }
        if (data != null && (n = string4.indexOf("DEVNO=")) >= 0) {
            int n3 = string4.charAt(n + 6) - 48;
            n3 = data.getL(n3);
            string4 = string4.substring(0, n + 6) + n3 + string4.substring(n + 7);
        }
        if (args.find("/FLAGS")) {
            string4 = args.getS("/FLAGS") + "," + string4;
        }
        if (string4.indexOf(94) >= 0) {
            string4 = args.evaluateCarets(string4);
        }
        if (args.find("/VERBOSE")) {
            string4 = string4 + "VERBOSE=" + args.getL("/VERBOSE") + ",";
        }
        if (args.find("/VB")) {
            string4 = string4 + "VERBOSE=" + args.getL("/VB") + ",";
        }
        if (args.getState("/SKIPONCARD")) {
            string4 = string4 + "SKIPONCARD,";
        }
        if (args.getState("/SKIPONCORE")) {
            string4 = string4 + "SKIPONCORE,";
        }
        if (args.find("/PORT")) {
            string4 = string4 + "PORT=" + args.getS("/PORT") + ",";
        }
        if (args.find("/TC") && !args.find("/NOTC")) {
            String string5 = args.getS("/TC");
            if (string5.length() == 0) {
                string5 = "SDN4";
            }
            string4 = string4 + "TC=" + string5 + ",";
        }
        return string4;
    }

    public static String getConfigEntry(String string, String string2) {
        Table table = new Table("{" + string + "}");
        return table.getS(string2);
    }

    public String getPortKey() {
        String string;
        String string2 = this.getStrFlagDef("PORT", "Unknown");
        if (string2.indexOf("CORE") >= 0 && (string = this.getKeyS(0, 370, 4)) != null) {
            string2 = string2 + ":" + string;
        }
        return string2;
    }

    public int setKey(int n, int n2, Data data) {
        data = data.convertTo((char)this.getKeyType(n2));
        return this.setKey(n, n2, data.buf, data.size * data.bpe);
    }

    public int getKey(int n, int n2, Data data) {
        data.setType(this.getKeyType(n2));
        data.setSize(this.getKeySize(n2));
        return this.getKey(n, n2, data.buf, data.size * data.bpe);
    }

    public Data getKey(int n, int n2) {
        Data data = new Data(0);
        int n3 = this.getKey(n, n2, data);
        if (n3 < 0) {
            data = null;
        }
        return data;
    }

    public DevIce.DmaMap mapFile(DataFile dataFile) {
        DevIce.DmaMap dmaMap;
        if (dataFile.io instanceof IceBlockResource) {
            IceBlockResource iceBlockResource = (IceBlockResource)dataFile.io;
            dmaMap = iceBlockResource.map;
        } else if (dataFile.io instanceof RamDiskResource) {
            RamDiskResource ramDiskResource = (RamDiskResource)dataFile.io;
            dmaMap = ramDiskResource.map;
        } else {
            dmaMap = new DevIce.DmaMap();
            dmaMap.vbytes = dmaMap.bytes = (long)dataFile.getDataSize();
            int n = this.long2phys(dmaMap.bytes);
            dmaMap.mode = 3;
            if (this.mapMem(dmaMap, n, 1) < 0) {
                return null;
            }
        }
        dmaMap.dev = this;
        return dmaMap;
    }

    public String getConfig() {
        return this.config;
    }

    public String getMcfg(int n) {
        int n2 = this.getKeyL(0, 101);
        boolean bl = n2 >= 5 && n2 <= 8;
        String string = bl ? "ENA,LEN,TEN,SEN,PLY,COE,MCOE,MCEN,8BIT,1BIT,BIT1,BIT4,LSBX,UOPT,CLKI,MSBI,SGO,TGO,GGO,XGO,IQ,MUX,VHS,ALT,LP1,LP2,FLIP,CLKM,IOM1,IOM2,?,BMUX" : "ENA,LEN,TEN,SEN,PLY,COE,MCOE,MCEN,8BIT,1BIT,BIT1,BIT4,LSBX,UOPT,CLKI,MSBI,SGO,TGO,GGO,XGO,DUAL,MUX,VHS,ALT,LP1,LP2,LP3,SP1,IOM1,IOM2,?,?";
        return Parser.mask2s((String)string, (int)this.getKeyL(n, 14));
    }

    public String getFlag(int n) {
        return Parser.mask2s((String)"Test,NoBrk,BigEnd,HS,MuxClk,IntClk,TC,Resv,NoLock,Disable,Verbose,NcClk,Boot,Tuner,ClkInv,MsbInv,VHS,Dual,Mux,Alt,SGo,TGo,GGo,XGo,Op1,Op2,Op3,Op4,Bit0,Bit4,RGo,NIO", (int)this.getKeyL(n, 10));
    }

    public String toString() {
        String string = Parser.get((String)cardList, (int)this.getKeyL(0, 101));
        String string2 = Parser.get((String)ioptList, (int)this.getKeyL(0, 102));
        int n = this.getKeyL(0, 103);
        int n2 = this.getKeyL(0, 191);
        int n3 = this.getKeyL(0, 191);
        String string3 = n2 < 0 ? Parser.get((String)imtList, (int)(-n2)) : Parser.get((String)omtList, (int)n2);
        String string4 = n3 < 0 ? Parser.get((String)imtList, (int)(-n3)) : Parser.get((String)omtList, (int)n3);
        return "ICE-DSP Card=" + string + " Port=" + string2 + n + " Mod1=" + string3 + " Mod2=" + string4;
    }

    public void modifyAlgorithm(int n, int n2) {
        int[] nArray = new int[]{n, n2};
        this.modifyAlgorithm(nArray);
    }

    public void modifyAlgorithm(int n, int n2, int n3) {
        int[] nArray = new int[]{n, n2, n3};
        this.modifyAlgorithm(nArray);
    }

    public void modifyAlgorithm(int n, int n2, int n3, int n4) {
        int[] nArray = new int[]{n, n2, n3, n4};
        this.modifyAlgorithm(nArray);
    }

    public void modifyAlgorithm(int[] nArray) {
        byte[] byArray = new byte[8];
        Data data = new Data(nArray);
        Convert.packI((byte[])byArray, (int)0, (short)7);
        this.send(0, byArray, data.buf, data.buf.length, 0x200000);
    }

    public String[] getKeys() {
        return keys;
    }

    public Object getKey(String string) {
        Data data = null;
        int n = this.name2key(string);
        if (n <= 0) {
            return null;
        }
        byte by = this.getKeyType(n);
        if (by == 76) {
            data = new Data(this.getKeyL(-1, n));
        }
        if (by == 68) {
            data = new Data(this.getKeyD(-1, n));
        }
        return data;
    }

    public Object setKey(String string, Object object) {
        int n = this.name2key(string);
        if (n <= 0) {
            return null;
        }
        byte by = this.getKeyType(n);
        if (by == 76) {
            this.setKeyL(-1, n, Convert.o2l((Object)object));
        }
        if (by == 68) {
            this.setKeyD(-1, n, Convert.o2d((Object)object));
        }
        return object;
    }

    public int setKeyD(int n, int n2, double d, double d2) {
        byte[] byArray = new byte[16];
        Convert.packD((byte[])byArray, (int)0, (double)d);
        Convert.packD((byte[])byArray, (int)8, (double)d2);
        return this.setKey(n, n2, byArray, 16);
    }

    public int setKeyD(int n, int n2, double d, double d2, double d3) {
        byte[] byArray = new byte[24];
        Convert.packD((byte[])byArray, (int)0, (double)d);
        Convert.packD((byte[])byArray, (int)8, (double)d2);
        Convert.packD((byte[])byArray, (int)16, (double)d3);
        return this.setKey(n, n2, byArray, 24);
    }

    public String setKeyTable(int n, String string) {
        byte[] byArray = string.getBytes();
        int n2 = byArray.length;
        int n3 = Math.max(n2, 1024);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2] = 0;
        int n4 = this.setKey(n, 350, byArray2, n3);
        return new String(byArray2, 0, n4);
    }

    public String getKeyTable(int n, String string) {
        byte[] byArray = string.getBytes();
        int n2 = byArray.length;
        int n3 = Math.max(n2, 1024);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2] = 0;
        int n4 = this.getKey(n, 350, byArray2, n3);
        return new String(byArray2, 0, n4);
    }
}

