/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;
import nxm.sys.lib.Args;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class Core
extends CoreComponent {
    public HALO halo = new HALO();
    public String name;

    public static Core forName(String string, Args args) {
        Core core = CoreFactory.getCore(string, args);
        return core;
    }

    public Core() {
        this.setFlow(0);
    }

    public void initSub(int n, HALO hALO) {
        this.halo.scid = n;
        this.halo.vbpr = hALO.vbpr;
        this.halo.impl = hALO.impl;
        if (n > 0) {
            this.init();
        }
    }

    public void allocNative(String string) {
        System.out.println("Err: Should not be calling allocNative from this implementation");
    }

    public CoreComponent.Buffer getBuffer(int n, int n2, int n3) {
        boolean bl = this.halo.impl > 0;
        return new CoreComponent.Buffer(n * 2, n2 * 8, n3 * 8, bl);
    }

    public CoreComponent.Buffer getBuffer(int n, String string, String string2) {
        int n2 = 0;
        int n3 = Data.getBPA((String)string);
        int n4 = Data.getBPA((String)string2);
        if (!(string.equals(string2) || string.equals("NH") || string2.equals("NH"))) {
            if (string.charAt(1) == 'B' && string2.charAt(1) == 'I') {
                n2 = 1;
            } else if (string.equals("CJ") && string2.equals("CI")) {
                n2 = 2;
            } else if (n3 != n4) {
                System.out.println("Buffer format convert " + string + " to " + string2 + " not handled yet");
            }
        }
        CoreComponent.Buffer buffer = this.getBuffer(n, n3, n4);
        buffer.cvt = n2;
        return buffer;
    }

    public void setFlow(int n) {
        this.halo.flow = n;
    }

    public int init() {
        return 0;
    }

    public int open() {
        this.halo.state = 1;
        return 0;
    }

    public int process() {
        System.out.println("This method process() should have been overridden");
        Time.sleep((double)1.0);
        return -1;
    }

    public int process(CoreComponent.Buffer buffer, CoreComponent.Buffer buffer2) {
        if (this.halo.flow == 1) {
            return this.process((CoreComponent.Stream)buffer, (CoreComponent.Stream)buffer2);
        }
        System.out.println("This flow=BUFFER method process(bi,bo) should have been overridden");
        Time.sleep((double)1.0);
        return -1;
    }

    public int process(CoreComponent.Buffer buffer, CoreComponent.Stream stream) {
        System.out.println("This flow=BUFSTR method process(bi,so) should have been overridden");
        Time.sleep((double)1.0);
        return -1;
    }

    @Override
    public int process(CoreComponent.Stream stream, CoreComponent.Stream stream2) {
        System.out.println("This flow=STREAM method process(si,so) should have been overridden");
        Time.sleep((double)1.0);
        return -1;
    }

    public int process(CoreComponent.Buffer buffer, CoreComponent.Stream stream, CoreComponent.Stream stream2, CoreComponent.Stream stream3) {
        System.out.println("This flow=PACKET method process(bi,sip,so,sop) should have been overridden");
        Time.sleep((double)1.0);
        return -1;
    }

    public int poll() {
        return 0;
    }

    public int close() {
        this.halo.state = 0;
        return 0;
    }

    public boolean isMatch(String string, String string2) {
        boolean bl;
        if (string.endsWith("?")) {
            string = string.substring(0, string.length() - 1);
        }
        boolean bl2 = string.length() > 2 && string.charAt(1) == ':';
        boolean bl3 = bl = string2.length() > 2 && string2.charAt(1) == ':';
        if (!(!bl2 || bl && string.startsWith("S:"))) {
            string = string.substring(2);
        }
        if (!(!bl || bl2 && string2.startsWith("S:"))) {
            string2 = string2.substring(2);
        }
        return string2.equalsIgnoreCase(string);
    }

    public boolean isSubMatch(String string, String string2) {
        int n = string.indexOf(95);
        if (n <= 0) {
            return false;
        }
        string = string.substring(0, n);
        return this.isMatch(string, string2);
    }

    public String subKey(String string) {
        int n = string.indexOf(95);
        if (n <= 0) {
            return "";
        }
        return string.substring(n + 1);
    }

    public int set(String string, CoreComponent.Value value) {
        if (this.halo.scid > 0) {
            return -1;
        }
        if (!string.startsWith("NAME") && !string.startsWith("S:NAME")) {
            if (string.equals("ICE.CONFIG")) {
                System.out.println("Setting the key=" + string + " to " + value);
            } else {
                throw new MidasException("Problem setting key=" + string + " to value=" + value);
            }
        }
        return 0;
    }

    public synchronized int set(String string, Data data) {
        CoreComponent.Value value = new CoreComponent.Value(data.buf, data.mode, data.type, 0, data.size);
        return this.set(string, value);
    }

    public int set(String string, String string2) {
        return this.set(string, new Data(string2));
    }

    public int set(String string, double d) {
        return this.set(string, new Data(d));
    }

    public int set(String string, float f) {
        return this.set(string, new Data(f));
    }

    public int set(String string, int n) {
        return this.set(string, new Data(n));
    }

    public int set(String string, boolean bl) {
        return this.set(string, new Data(bl ? 1 : 0));
    }

    public int set(String string, float[] fArray) {
        return this.set(string, new Data(fArray));
    }

    public int set(String string, int[] nArray) {
        return this.set(string, new Data(nArray));
    }

    public int set(String string, short[] sArray) {
        return this.set(string, new Data(sArray));
    }

    public int set(String string, byte[] byArray) {
        return this.set(string, new Data(byArray));
    }

    public int setKeyFile(String string, boolean bl) {
        Table table = Convert.o2t((Object)string, (Object)Shell.getMidasContext());
        return this.setKeyTable(null, table, bl);
    }

    public int setKeyTable(String string, Table table, boolean bl) {
        int n = 0;
        table.setMode("KV");
        String[] stringArray = table.getKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Object object = table.get(string2);
            if (object instanceof Table) {
                this.setKeyTable(string2, (Table)object, bl);
                continue;
            }
            if (object == null || object.equals("") || object.equals("NULL")) continue;
            Data data = table.getData(string2);
            String string3 = data.getFormat().substring(1, 2);
            if (string3.equals("A")) {
                string3 = "S";
            }
            if (string != null) {
                string2 = string + "_" + string2;
            }
            if ("SLFD".indexOf(string3) >= 0) {
                string2 = string3 + ":" + string2;
            }
            if (bl) {
                System.out.println("Set Key=" + string2 + " Value=" + object);
            }
            this.set(string2, data);
            ++n;
        }
        return n;
    }

    public int get(String string, CoreComponent.Value value) {
        value = null;
        int n = 0;
        if (this.halo.scid > 0) {
            return -1;
        }
        if (!string.startsWith("BOGUS")) {
            if (string.equals("NAME") || string.equals("S:NAME")) {
                value.fromS(this.name);
            } else if (string.endsWith("?")) {
                n = -1;
            } else if (string.equals("TIME") || string.equals("D:TIME")) {
                value.fromD(Time.current());
            } else if (string.equals("SSM") || string.equals("F:SSM")) {
                value.fromF((float)Time.currentTime().getSoD());
            } else {
                System.out.println("Core get of key=" + string + " not handled");
                n = -1;
            }
        }
        return n;
    }

    public int get(String string, Data data) {
        CoreComponent.Value value = new CoreComponent.Value(data.buf, data.mode, data.type, 0, data.size);
        return this.get(string, value);
    }

    public int get(String string, Data data, int n, int n2) {
        CoreComponent.Value value = new CoreComponent.Value(data.buf, data.mode, data.type, n, n2);
        return this.get(string, value);
    }

    public Data get(String string, byte by) {
        Data data = new Data();
        data.setType(by);
        data.setSize(1);
        int n = this.get(string, data);
        return n < 0 ? null : data;
    }

    public Data get(String string) {
        byte by = 76;
        if (string.indexOf(58) == 1) {
            by = (byte)string.charAt(0);
        }
        return this.get(string, by);
    }

    public String getS(String string) {
        Data data = this.get(string, (byte)83);
        return data.toString();
    }

    public double getD(String string) {
        Data data = this.get(string, (byte)68);
        return data.toD();
    }

    public float getF(String string) {
        Data data = this.get(string, (byte)70);
        return data.toF();
    }

    public int getL(String string) {
        Data data = this.get(string, (byte)76);
        return data.toL();
    }

    public boolean getState(String string) {
        Data data = this.get(string, (byte)76);
        return data.toL() > 0;
    }

    public int getList(String string, Data data) {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        if (string.charAt(0) == '(') {
            ++n2;
            --n4;
        }
        while (n2 < n4) {
            String string2;
            n3 = string.indexOf(44, n2);
            if (n3 < 0) {
                n3 = n4;
            }
            char c = (string2 = string.substring(n2, n3)).charAt(1) == ':' ? (char)string2.charAt(0) : (char)'F';
            int n5 = this.get(string2, data, n, 1);
            if (n5 >= 0) {
                n += Data.getBPS((char)c);
            }
            n2 = n3 + 1;
        }
        return n;
    }

    public boolean isSet(String string, String string2, int n) {
        int n2 = Parser.mask((String)string, (String)string2, (int)0);
        return (n & n2) != 0;
    }

    public byte getDataType() {
        return CoreFactory.getDataType(this.halo.impl);
    }

    public static int getFormats(String string) {
        char c = string.charAt(0);
        char c2 = string.charAt(1);
        int n = 0;
        if (c2 == 'I') {
            n = 0;
        } else if (c2 == 'B') {
            n = 1;
        } else if (c2 == 'N') {
            n = 2;
        } else if (c2 == 'P') {
            n = 3;
        } else if (c2 == 'L') {
            n = 4;
        } else if (c2 == 'X') {
            n = 5;
        } else if (c2 == 'F') {
            n = 6;
        } else if (c2 == 'D') {
            n = 7;
        }
        if (c == 'C') {
            n |= 8;
        }
        return n;
    }

    public static int getFormats(String string, String string2) {
        return Core.getFormats(string) << 0 | Core.getFormats(string2) << 8;
    }

    public static int getFormats(String string, String string2, String string3) {
        return Core.getFormats(string) << 0 | Core.getFormats(string2) << 8 | Core.getFormats(string3) << 16;
    }

    public int getFormatBits(int n, int n2) {
        int n3 = n >> (n2 - 1) * 8 & 0xFF;
        int n4 = 1;
        if ((n3 & 8) != 0) {
            n4 = 2;
            n3 &= 7;
        }
        if (n3 == 0) {
            n4 *= 16;
        } else if (n3 == 1) {
            n4 *= 8;
        } else if (n3 == 2) {
            n4 *= 4;
        } else if (n3 == 3) {
            n4 *= 1;
        } else if (n3 == 4) {
            n4 *= 32;
        } else if (n3 == 5) {
            n4 *= 64;
        } else if (n3 == 6) {
            n4 *= 32;
        } else if (n3 == 7) {
            n4 *= 64;
        }
        return n4;
    }

    public int getFormatBytes(int n, int n2) {
        int n3 = this.getFormatBits(n, n2) >> 3;
        return n3 <= 0 ? 1 : n3;
    }

    public int getFormatBytes(int n) {
        return this.getFormatBytes(this.halo.fmts, n);
    }

    public int getFormatBits(int n) {
        return this.getFormatBits(this.halo.fmts, n);
    }

    public int getFormatMode(int n, int n2) {
        int n3 = n >> (n2 - 1) * 8 & 0xFF;
        int n4 = (n3 & 8) != 0 ? 2 : 1;
        return n4;
    }

    public int getFormatMode(int n) {
        return this.getFormatMode(this.halo.fmts, n);
    }

    public int setFormats(String string, String string2) {
        this.halo.fmts = Core.getFormats(string, string2);
        return this.halo.fmts;
    }

    public int setSCID(int n) {
        this.halo.scid = n;
        return this.halo.scid;
    }

    public int setMCID(int n) {
        this.halo.mcid = n;
        return this.halo.mcid;
    }

    public int setTraceMode(int n) {
        this.halo.flgs |= n << 24;
        return this.halo.flgs;
    }

    public int getTraceData(int n) {
        return 0;
    }

    public void getVars(String string) {
    }

    public void putVars(String string) {
    }

    public void upDate(String string) {
    }

    public int load(CoreComponent.Stream stream, DataFile dataFile) {
        if (this.halo.impl > 0) {
            long l = CoreNative.loadStreamBuffer(stream.handle);
            int n = CoreNative.loadStreamAvail(stream.handle);
            int n2 = dataFile.read(l, 0, n);
            if (dataFile.getFormatType() == 70 && this.halo.impl >= 5) {
                CoreNative.fp2fptx(l, n2);
            }
            return CoreNative.loadStreamStatus(stream.handle, n2);
        }
        return stream.load(dataFile);
    }

    public int unload(CoreComponent.Stream stream, DataFile dataFile) {
        if (this.halo.impl > 0) {
            long l = CoreNative.unloadStreamBuffer(stream.handle);
            int n = CoreNative.unloadStreamAvail(stream.handle);
            if (dataFile.getFormatType() == 70 && this.halo.impl >= 5) {
                CoreNative.fptx2fp(l, n);
            }
            int n2 = dataFile.write(l, 0, n);
            return CoreNative.unloadStreamStatus(stream.handle, n2);
        }
        return stream.unload(dataFile);
    }

    public class HALO {
        public int sys;
        public int dec;
        public int gain;
        public int rate;
        public int ratio;
        public int frame;
        public int freq;
        public int flag;
        public int user0;
        public int user1;
        public int user2;
        public int user3;
        public int user4;
        public int user5;
        public int user6;
        public int user7;
        public int func;
        public int fmts;
        public int flow;
        public int impl;
        public int flgs;
        public int psize;
        public int status;
        public int scid;
        public int mcid;
        public int ncvar;
        public int name1;
        public int name2;
        public int state;
        public int vbpr;
        public boolean prep;
        public int loadOff;
        public long config;
        public long setkey;
        public long getkey;
        public long init;
        public long work;
        public long free;
        public long set;
        public long get;
        public long open;
        public long process;
        public long close;
    }
}

