/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.core.Filters;
import nxm.ice.core.Modefs;
import nxm.ice.core.Modems;
import nxm.ice.lib.Core;
import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class AWG
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int SELFPACE = 1;
    public static final int IFMT = 2;
    public static final int BW = 32;
    public static final int OSEQ = 11;
    public static final int NSEQ = 2048;
    public static final int OLUT = 10;
    public static final int NLUT = 1024;
    public static final int OFILT = 7;
    public static final int NFILT = 128;
    public static final int OTAP = 5;
    public static final int RTAP = 32;
    public static final int PTAP = 16;
    public static final int HTAP = 8;
    public static final int FPS = 15;
    public static final int MAXCR = 250000000;
    public static final int OMSEQ = 24;

    public static class CORE
    extends Core
    implements Modefs {
        public int mod;
        public int map;
        public int scr;
        public int ups;
        public double gain;
        public boolean isFPGA;
        public int nlut;
        double ps;
        double dps;
        double p;
        double dp;
        float fscl;
        float lfps;
        int bpw;
        int iper;
        int nper;
        int mper;
        int flgs;
        int pr;
        int princ;
        int mlut;
        float[] xlut;
        float[] ylut;
        int din;
        int dinc;
        int ntap;
        int nrpt;
        int ntot;
        CoreComponent.CxTapBuf vd;
        CoreComponent.RomF2Di rft;
        int scrvec;
        int[] seq;
        int iseq;
        int mseq;
        int di;
        int db;
        int imon;
        int mmon;
        int cups;
        int cper;
        int ifbd;
        int mfbd;
        public double midx;
        public double fS;
        public double fSym;
        public double tOff;
        public double fC;
        public double fbwf;
        public int obpw;
        public int lmod;
        public int bups;
        public int fbd;
        public boolean mute;

        public void dump(String string) {
            System.out.printf("set=%s fsym=%f dps=%f nper=%d imon=%d mmon=%d cper=%d cups=%d mseq=%d bpw=%d flgs=%d\n", string, this.fSym, this.dps, this.nper, this.imon, this.mmon, this.cper, this.cups, this.mseq, this.bpw, this.flgs);
        }

        public int findMoN(double d) {
            if (d < 1.0E-4) {
                return 0;
            }
            for (int i = 2; i < 0x100000; ++i) {
                double d2 = d * (double)i;
                double d3 = CORE.fabs(d2 - CORE.round(d2));
                if (!(d3 < 1.0E-12)) continue;
                return i;
            }
            return 0;
        }

        public void genFilt() {
            int n;
            int n2;
            int n3 = this.nrpt * this.ntap;
            int n4 = this.nrpt / 2;
            float f = CORE.d2f((double)(this.nrpt * 15) / this.fbwf);
            double d = this.fbwf;
            if (this.mod == 4) {
                d = 2.0 * this.midx / (double)this.nper;
            }
            if (this.mod == 5) {
                d = 4.0 * this.midx / (double)this.nper;
            }
            float[] fArray = new float[n3 * 2];
            Filters.genFirKais(1, d / (double)this.nrpt, 0.0, 0.05 / (double)this.nrpt, 90.0, fArray, n3);
            this.rft.clear();
            int n5 = 0;
            for (n2 = 0; n2 < this.ntap; ++n2) {
                n = 0;
                while (n < this.nrpt) {
                    this.rft.set(n, n2, fArray[n5] * f);
                    ++n;
                    n5 += 2;
                }
            }
            if (this.mod == 8) {
                n5 = 0;
                for (n2 = 0; n2 < this.ntap; ++n2) {
                    n = 0;
                    while (n < this.nrpt) {
                        this.rft.set(n + n4, n2 + 8, fArray[n5] * f);
                        ++n;
                        n5 += 2;
                    }
                }
            }
        }

        public void genRotates() {
            boolean bl;
            int n = 16;
            boolean bl2 = false;
            boolean bl3 = bl = this.mod == 11;
            int n2 = this.mod == 11 ? 2 : (this.mod == 9 ? 2 : (this.princ = this.mod == 10 ? 6 : 0));
            if (this.princ == 0) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                float f = bl ? (float)i / 8.0f : (bl2 ? (float)this.princ / 16.0f : 0.0f);
                float f2 = CORE.coscf(f);
                float f3 = CORE.sincf(f);
                for (int j = 0; j < this.nlut; ++j) {
                    float f4 = this.xlut[j];
                    float f5 = this.ylut[j];
                    this.xlut[(i << 4) + j] = f4 * f2 - f5 * f3;
                    this.ylut[(i << 4) + j] = f4 * f3 + f5 * f2;
                }
                bl2 = !bl2;
            }
            this.princ = 1;
        }

        public void setDPS() {
            double d = this.dps;
            double d2 = this.dps * this.fS;
            this.dps = CORE.dptx2d(CORE.d2dptx(this.dps));
            this.fSym = this.dps * this.fS * (double)this.nper;
            this.mmon = 0;
            if (this.fSym != d2) {
                this.mmon = this.findMoN(d);
                if (this.mmon > 1) {
                    double d3 = CORE.frac(this.dps * (double)this.mmon);
                    if (d3 > 0.5) {
                        this.dps = CORE.dptx2d(CORE.d2dptx(this.dps) + 4L);
                        d3 = CORE.frac(this.dps * (double)this.mmon);
                        this.fSym = this.dps * this.fS;
                    }
                    if (d3 > 0.001 && this.fSym != d2) {
                        System.out.printf("AWG fS=%18.9f fSym=%18.9f fActual=%18.9f MoN=%d perr=%8.6f\n", this.fS, d2, this.fSym, this.mmon, d3);
                    }
                    this.fSym = d * this.fS;
                } else {
                    System.out.printf("AWG fS=%18.9f fSym=%18.9f fActual=%18.9f\n", this.fS, d2, this.fSym);
                }
            }
            this.mmon = this.mmon == 0 ? 0 : this.mmon - 1;
            this.flgs = CORE.setBit(this.flgs, 4, this.mmon > 0);
            this.putVars("dps,mmon,flgs");
        }

        public void setRate(double d) {
            if (d > 5.0E8) {
                System.out.printf("Desired sample rate = %f limited to max supported rate of %d\n", d, 500000000);
                d = 5.0E8;
            }
            this.ups = d > 2.5E8 ? 2 : 1;
            this.fS = d / (double)this.ups;
        }

        public void setCUPS(int n) {
            this.cups = n >= 0 ? n : (this.mute ? 0 : this.bups + 2);
            this.putVars("cups");
        }

        public void setMute(int n) {
            this.mute = n != 0;
            this.setCUPS(-1);
        }

        public void setFcny(double d) {
            this.bups = 0;
            this.dp = d;
            if (this.ups == 2) {
                if (d < -0.125) {
                    this.bups = -1;
                    this.dp = (d + 0.25) * (double)this.ups;
                } else if (d < 0.125) {
                    this.bups = 0;
                    this.dp = (d - 0.0) * (double)this.ups;
                } else {
                    this.bups = 1;
                    this.dp = (d - 0.25) * (double)this.ups;
                }
            }
            if (d < -0.5 || d > 0.5) {
                this.bups = 0;
            }
            if (this.isFPGA) {
                this.dp = CORE.dptx2d(CORE.d2dptx(this.dp));
            }
            this.cups = this.mute ? 0 : this.bups + 2;
            this.fC = (this.dp / (double)this.ups + (double)this.bups * 0.25) * this.fS * (double)this.ups;
            this.putVars("dp,cups");
        }

        public void setFreq(double d) {
            this.setFcny(d / (this.fS * (double)this.ups));
        }

        public void setGain(double d) {
            this.gain = d;
            if (this.mod >= 4) {
                d -= 3.0;
            }
            if (this.mod > 8) {
                d -= 3.0;
            }
            this.fscl = CORE.d2f(CORE.pow(2.0, d / 6.0) * this.fbwf / 15.0);
            this.putVars("fscl");
        }

        public void setSpec(double d) {
            boolean bl = false;
            int n = 0x1000000;
            this.midx = d;
            if (this.mod == 1 && this.fS > 0.0) {
                this.mseq = 0;
                if (this.midx > 0.0) {
                    bl = true;
                    this.mseq = CORE.d2i(this.fS * this.dps / this.midx / 65536.0);
                    if (this.mseq < 1) {
                        System.out.printf("Unable to perform CW sweep parameters min=%d\n", this.mseq);
                        this.mseq = 1;
                    }
                    if (this.mseq > n) {
                        System.out.printf("Unable to perform CW sweep parameters max=%d\n", this.mseq);
                        this.mseq = n;
                    }
                }
                this.flgs = CORE.setBit(this.flgs, 5, bl);
                if (this.mseq > 0) {
                    --this.mseq;
                }
                this.putVars("flgs,mseq");
                if (!bl) {
                    this.dinc = 0;
                }
                this.putVars("dinc");
            }
        }

        public void genSeq(int n) {
            int n2 = 123456;
            int n3 = ~n2;
            int n4 = (1 << n) - 1;
            int n5 = 0x1000000;
            this.mseq = 2045;
            if (this.mod == 1) {
                this.scr = 0;
                this.mseq = 1;
                this.seq[0] = 0;
                this.setSpec(this.midx);
            } else {
                for (int i = 0; i < this.mseq; ++i) {
                    if (this.scr != 1) {
                        n3 = 0;
                    } else {
                        for (int j = 0; j < 8; ++j) {
                            n3 = n3 << 1 | 1 ^ CORE.getBits(n3, 0, 0) ^ CORE.getBits(n3, 1, 1) ^ CORE.getBits(n3, 5, 5) ^ CORE.getBits(n3, 25, 25);
                        }
                    }
                    this.seq[i] = n3 & 0x3FF;
                }
            }
            --this.mseq;
        }

        public void genMod() {
            switch (this.mod) {
                case 4: {
                    this.nper = (int)(this.midx * 2.0);
                    this.mper = 2 * this.nper - 1;
                    break;
                }
                case 5: {
                    this.nper = (int)(this.midx * 4.0);
                    this.mper = 2 * this.nper - 1;
                    break;
                }
                default: {
                    this.nper = 1;
                    this.mper = 0;
                }
            }
            int n = Modems.getBitsPerSym(this.mod);
            this.nlut = Modems.getSymbolMap(this.mod, this.map, 1.0, this.midx, this.nper, this.xlut, this.ylut);
            this.mlut = this.nlut - 1;
            this.bpw = this.mod == 0 ? 32 : (this.obpw >= 0 ? this.obpw : n);
            this.dinc = 0;
            this.genSeq(n);
            this.putVars("seq,mseq,nper,mper,dinc");
            this.putVars("xlut,ylut,mlut,bpw");
            this.lmod = this.mod;
        }

        public void setFBWF(double d) {
            this.fbwf = d;
            if (this.halo.state == 1) {
                this.setGain(this.gain);
                this.genFilt();
                this.putVars("rft");
            }
        }

        public void setFsym(double d) {
            this.fSym = d;
            this.dps = (double)this.nper * this.fSym / this.fS;
            this.setDPS();
            if (this.halo.state == 1) {
                this.genFilt();
                this.putVars("rft");
            }
            this.mfbd = CORE.d2i(this.fS / (1.5 * this.fSym)) - 1;
        }

        @Override
        public int init() {
            this.mod = 0;
            this.midx = 1.0;
            this.fbwf = 1.0;
            this.fS = -1.0;
            this.dp = 0.0;
            this.dps = 0.25;
            this.tOff = 0.0;
            this.gain = -3.0;
            this.ntap = -1;
            this.obpw = -1;
            this.iseq = 0;
            this.scr = -1;
            this.map = -1;
            this.nper = 1;
            this.mper = 0;
            this.ups = 1;
            this.bups = 0;
            this.fbd = -1;
            this.mfbd = 0;
            this.flgs = 0;
            this.isFPGA = this.halo.impl >= 5;
            return 0;
        }

        @Override
        public int set(String string, CoreComponent.Value value) {
            int n = this.mod;
            double d = this.midx;
            double d2 = this.fSym;
            if (this.isMatch(string, "S:SHAPE")) {
                this.mod = value.toItem("NONE,CW,AM,FM,FSK,4FSK,BPSK,QPSK,OQPSK,1P4QPSK,3P4QPSK,1P4DQPSK,8PSK,16PSK,16APSK,32APSK,64APSK,128APSK,256APSK,16CQAM,64CQAM,128CQAM,256CQAM,8QAM,16QAM,32QAM,64QAM,128QAM,256QAM,512QAM,1024QAM");
            } else if (this.isMatch(string, "D:MIDX")) {
                this.setSpec(value.toD());
            } else if (this.isMatch(string, "D:SPEC")) {
                this.setSpec(value.toD());
            } else if (this.isMatch(string, "S:MOD")) {
                this.mod = value.toItem("NONE,CW,AM,FM,FSK,4FSK,BPSK,QPSK,OQPSK,1P4QPSK,3P4QPSK,1P4DQPSK,8PSK,16PSK,16APSK,32APSK,64APSK,128APSK,256APSK,16CQAM,64CQAM,128CQAM,256CQAM,8QAM,16QAM,32QAM,64QAM,128QAM,256QAM,512QAM,1024QAM");
            } else if (this.isMatch(string, "L:MOD")) {
                this.mod = value.toL();
            } else if (this.isMatch(string, "S:MAP")) {
                this.map = value.toItem("LINEAR,BRGC,BRGCIB,BRGCIX,BRGCIY,BRGCIXY,BRGCNT,BRGCBE");
            } else if (this.isMatch(string, "S:SCR")) {
                this.scr = value.toItem("NONE,LRS,V35,IES");
            } else if (this.isMatch(string, "D:FS")) {
                this.setRate(value.toD());
            } else if (this.isMatch(string, "D:FREQ")) {
                this.setFreq(value.toD());
            } else if (this.isMatch(string, "D:COFF")) {
                this.setFreq(value.toD());
            } else if (this.isMatch(string, "D:FCNY")) {
                this.setFcny(value.toD());
            } else if (this.isMatch(string, "D:FSYM")) {
                this.setFsym(value.toD());
            } else if (this.isMatch(string, "D:BAUD")) {
                this.setFsym(value.toD());
            } else if (this.isMatch(string, "D:FBWF")) {
                this.setFBWF(value.toD());
            } else if (this.isMatch(string, "D:TOFF")) {
                this.tOff = value.toD();
            } else if (this.isMatch(string, "L:NTAP")) {
                this.ntap = value.toL();
            } else if (this.isMatch(string, "L:BPW")) {
                this.obpw = value.toL();
            } else if (this.isMatch(string, "L:FBD")) {
                this.fbd = value.toL();
            } else if (this.isMatch(string, "D:GAIN")) {
                this.setGain(value.toD());
            } else if (this.isMatch(string, "L:GAIN")) {
                this.setGain(value.toD());
            } else if (this.isMatch(string, "L:CUPS")) {
                this.setCUPS(value.toL());
            } else if (this.isMatch(string, "L:MUTE")) {
                this.setMute(value.toL());
            } else {
                return super.set(string, value);
            }
            if (this.halo.state == 0) {
                return 0;
            }
            if (this.mod >= 4 && this.mod <= 5 && (this.midx != d || this.fSym != d2)) {
                n = 0;
            }
            if (this.mod != n) {
                this.genMod();
            }
            return 0;
        }

        @Override
        public int get(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "D:FS")) {
                value.fromD(this.fS * (double)this.ups);
            } else if (this.isMatch(string, "D:XDO")) {
                value.fromD(1.0 / (this.fS * (double)this.ups));
            } else if (this.isMatch(string, "D:FSYM")) {
                value.fromD(this.fSym);
            } else if (this.isMatch(string, "D:FREQ")) {
                value.fromD(this.fC);
            } else if (this.isMatch(string, "L:CUPS")) {
                value.fromL(this.cups);
            } else if (this.isMatch(string, "L:MOD")) {
                value.fromL(this.mod);
            } else if (this.isMatch(string, "L:FBD")) {
                value.fromL((this.mfbd + 1) * this.ups);
            } else if (this.isMatch(string, "S:MODLIST")) {
                value.fromS("NONE,CW,AM,FM,FSK,4FSK,BPSK,QPSK,OQPSK,1P4QPSK,3P4QPSK,1P4DQPSK,8PSK,16PSK,16APSK,32APSK,64APSK,128APSK,256APSK,16CQAM,64CQAM,128CQAM,256CQAM,8QAM,16QAM,32QAM,64QAM,128QAM,256QAM,512QAM,1024QAM");
            } else if (this.isMatch(string, "S:MAPLIST")) {
                value.fromS("LINEAR,BRGC,BRGCIB,BRGCIX,BRGCIY,BRGCIXY,BRGCNT,BRGCBE");
            } else if (this.isMatch(string, "S:SCRLIST")) {
                value.fromS("NONE,LRS,V35,IES");
            } else {
                return super.get(string, value);
            }
            return 0;
        }

        @Override
        public int open() {
            int n;
            if (this.scr < 0) {
                this.scr = 0;
            }
            if (this.map < 0) {
                this.map = 2;
            }
            this.seq = new int[2048];
            this.xlut = new float[1024];
            this.ylut = new float[1024];
            this.genMod();
            this.setFsym(this.fSym);
            this.setGain(this.gain);
            int n2 = n = this.isFPGA ? 16 : 32;
            if (this.ntap <= 0) {
                int n3 = this.mod <= 0 ? n : (this.ntap = this.mod == 4 || this.mod == 5 ? 21 : 7);
            }
            if (this.ntap >= 8 && this.mod == 8) {
                System.out.printf("Warn ntap=%d limited to ntap=%d for OQPSK\n", this.ntap, 7);
                this.ntap = 7;
            }
            if (this.ntap > 32) {
                System.out.printf("Warn ntap=%d limited to ntap=%d for this compile\n", this.ntap, 32);
                this.ntap = 32;
            }
            this.cper = (this.ntap + 16 - 1) / 16;
            int n4 = n = this.isFPGA ? 16 * CORE.imax(1, CORE.d2i(2.5E8 / this.fS)) : 32;
            if (this.ntap > n) {
                System.out.printf("Number taps=%d at fS=%f too large max=%d for FPGA load PTAP=%d RTAP=%d\n", this.ntap, this.fS, n, 16, 32);
                this.ntap = n;
                this.cper = this.ntap / 16;
            }
            this.nrpt = 128;
            this.ntot = this.ntap;
            this.vd = new CoreComponent.CxTapBuf(5, 1, 16, 0);
            this.vd.setLength(this.ntap);
            this.rft = new CoreComponent.RomF2Di(7, 5, 16);
            this.genFilt();
            this.pr = 0;
            this.ps = 0.0;
            this.p = 0.0;
            this.di = 0;
            this.lfps = 1.0f;
            this.iper = 0;
            this.ifbd = 0;
            this.imon = 1;
            this.scrvec = 0;
            this.flgs = 0;
            this.flgs = CORE.setBit(this.flgs, 0, this.bpw == 0);
            this.flgs = CORE.setBit(this.flgs, 1, this.bpw == 32);
            this.flgs = CORE.setBit(this.flgs, 2, this.mod == 1);
            this.flgs = CORE.setBit(this.flgs, 3, this.mod == 8);
            this.flgs = CORE.setBit(this.flgs, 4, this.mmon > 0);
            this.flgs = CORE.setBit(this.flgs, 5, this.mod == 1 && this.midx > 0.0);
            if (this.fbd > 0) {
                this.mfbd = this.fbd / this.ups - 1;
            }
            this.genRotates();
            this.setCUPS(-1);
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("AWG mod=%d fSym=%f fS=%f fbwf=%f mmon=%d ntap=%d bpw=%d cper=%d\n", this.mod, this.fSym, this.fS, this.fbwf, this.mmon, this.ntap, this.bpw, this.cper);
            }
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream stream, CoreComponent.Stream stream2) {
            CoreCommon.CxFloat cxFloat = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat2 = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat3 = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat4 = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat5 = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat6 = CoreCommon.CxFloat.stk();
            CoreCommon.CxFloat cxFloat7 = CoreCommon.CxFloat.stk();
            boolean bl = CORE.getBit(this.flgs, 0);
            boolean bl2 = CORE.getBit(this.flgs, 1);
            boolean bl3 = CORE.getBit(this.flgs, 2);
            boolean bl4 = CORE.getBit(this.flgs, 3);
            boolean bl5 = CORE.getBit(this.flgs, 4);
            boolean bl6 = CORE.getBit(this.flgs, 5);
            stream2.setC(this.cups);
            while ((bl || stream.rok) && stream2.wok) {
                float f = CORE.fracf(CORE.d2f(this.ps));
                this.ps = bl5 && this.imon == 0 ? 0.0 : CORE.frac(this.ps + this.dps);
                this.imon = this.imon >= this.mmon ? 0 : this.imon + 1;
                boolean bl7 = f < this.lfps;
                this.lfps = f;
                if (bl7) {
                    boolean bl8 = this.iper == 0 || this.iper == this.nper;
                    int n = this.iper;
                    int n2 = this.iper = this.iper == this.mper ? 0 : this.iper + 1;
                    if (bl8) {
                        this.scrvec = this.seq[this.iseq & 0x7FF];
                        this.iseq = this.iseq >= this.mseq ? 0 : this.iseq + 1;
                        boolean bl9 = this.iseq == 0;
                        this.di = bl | bl3 ? this.din & 0x3FF : stream.rdBits(this.bpw);
                        this.din += this.dinc >> 6;
                        if (bl6 && bl9) {
                            ++this.dinc;
                        }
                    }
                    int n3 = (this.di ^ this.scrvec) & this.mlut;
                    this.db = n3 | n << 4 | this.pr << 4;
                    this.pr = this.pr + this.princ & 0xF;
                    cxFloat.x = this.xlut[this.db];
                    cxFloat.y = this.ylut[this.db];
                    cxFloat2.x = CORE.CI2Fx(this.di);
                    cxFloat2.y = CORE.CI2Fy(this.di);
                    this.vd.load(bl2 ? cxFloat2 : cxFloat);
                }
                cxFloat4.x = 0.0f;
                cxFloat4.y = 0.0f;
                for (int i = 0; i < this.ntot; ++i) {
                    CoreCommon.CxFloat cxFloat8 = CoreCommon.CxFloat.stk();
                    CoreCommon.CxFloat cxFloat9 = CoreCommon.CxFloat.stk();
                    CoreCommon.CxFloat cxFloat10 = CoreCommon.CxFloat.stk();
                    this.rft.getrNc(this.lfps, i, bl4, cxFloat8);
                    this.vd.get(i, cxFloat9);
                    cxFloat10 = cxFloat9;
                    cxFloat4.x += cxFloat8.x * cxFloat10.x;
                    cxFloat4.y += cxFloat8.y * cxFloat10.y;
                }
                cxFloat5 = cxFloat4;
                float f2 = CORE.d2f(this.p + this.dp);
                this.p = CORE.frac(this.p + this.dp);
                CORE.sincoscf(f2, cxFloat3);
                CORE.mulcc(cxFloat5, cxFloat3, cxFloat6);
                boolean bl10 = this.ifbd == this.mfbd;
                this.ifbd = this.ifbd == this.mfbd ? 0 : this.ifbd + 1;
                CORE.mulcf(cxFloat6, this.fscl, cxFloat7);
                stream2.wrCFI(cxFloat7);
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

