/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.test;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Command;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataFileHeader;
import nxm.sys.lib.FileName;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Position;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libg.DragBox;
import nxm.sys.libg.ExportImage;
import nxm.sys.libg.Feature;
import nxm.sys.libg.GAlert;
import nxm.sys.libg.GDialog;
import nxm.sys.libg.GFiles;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GQuery;
import nxm.sys.libg.GValue;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.Layer;
import nxm.sys.libg.LayerDrawable;
import nxm.sys.libg.LayerKML;
import nxm.sys.libg.MJPopup;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.Theme;
import nxm.sys.net.Rmif;
import nxm.sys.prim.plot;
import nxm.sys.prim.prescaler;
import nxm.sys.prim.rmif;

public class plottester
extends plot {
    protected int type;
    protected int controls = 1;
    private int nice;
    private int ocm;
    private int oview;
    private int realtime = 0;
    private int exit = -1;
    private int openWarn = 1;
    private int rescale = 0;
    private int automask = 2;
    private Table laytab;
    private double atime = 0.0;
    private final double atime1 = 0.0;
    private final double atime2 = 86400.0;
    private final double atinc = 1.0;
    private boolean focus;
    private boolean exiting;
    private boolean unitsInit;
    private rmif rmif;
    private Table zoomTo = null;
    private int pointerCount;
    private double pointerTime;
    private Message pointerMsg;
    private Table mtag = null;
    private boolean imageFlag = false;
    private int compression = 0;
    private Table setupTable = null;
    private boolean needScaleTable;
    public static final int EXIT_RETURN = 1;
    public static final int EXIT_MENU = 2;
    public static final int EXIT_MESSAGE = 4;
    public static final int EXIT_WINDOW = 8;
    public static final int EXIT_ALL = 15;
    public static final int EXIT_AUTO = 16;
    public static final String exitList = "RETURN,MENU,MESSAGE,WINDOW,AUTO";
    public static final int OPENWARN_POPUP = 1;
    public static final int OPENWARN_PRINT = 2;
    public static final String openWarnList = "POPUP,PRINT";
    public static final int ONCLICK = 1;
    public static final int ONMOTION = 2;
    public static final int ONDRAG = 4;
    public static final String pointerMessageList = "Click,Motion,Drag";
    private final Map<String, MessageHandler> mimic = new LinkedHashMap<String, MessageHandler>(1);
    private final boolean ENABLE_JEFF_TITLE_CHANGES = false;
    private StealsMouseClick stealNextClick = null;
    public static String compressionList = "Off,Data,Plot";
    public MPlot MP;
    private String inFile;
    private Table scaleTable;
    private final PrescaleSetup prescaleSetup = new PrescaleSetup();

    @Override
    public int open() {
        Table zoomto;
        Table ftab;
        String specifiedView;
        this.type = this.MA.getSelectionIndex("TYPE", "LINE,RASTER,CONTOUR,MESH,POINT,DOT", this.type);
        String controlsStr = this.MA.getS("CNT", "DEF");
        if (controlsStr.equals("DEF")) {
            controlsStr = this.MA.getS("/XCNT", "DEF");
        }
        this.setXCnt(controlsStr);
        if (this.MA.find("/MTAG")) {
            String str = this.MA.getCS("/MTAG", null);
            if (str != null && str.startsWith("(")) {
                this.setMTagXMidas(str);
            } else {
                this.setMTag(this.MA.getTable("/MTAG", null));
            }
        }
        this.realtime = this.MA.getL("/RT", 0);
        this.nice = this.M.pipeMode == 0 ? 0 : 1;
        this.nice = this.MA.getL("/NICE", this.nice);
        this.exit = this.M.pipeMode == 1 ? 0 : 15;
        this.exit = this.MA.getOptionMask("/EXIT", exitList, this.exit);
        this.openWarn = this.MA.getOptionMask("/OPENWARN", openWarnList, 3);
        this.focus = this.MA.getState("/FOCUS", this.M.macro == null);
        this.MP = new MPlot("Plot", this);
        this.MP.setButtonAction(this.MA.getTable("BUTTONACTION"));
        this.MW = this.MP;
        if (Theme.getOption(64) && Theme.getOption(8)) {
            this.M.warning("Use of SWING-based widgets and menus in conjunction with REALTIME drawing mode for PLOTs can cause widgets/menus to disappear");
        }
        this.MP.open();
        this.MP.setAxisIndex(this.MA.getState("/INDEX", false));
        this.MP.setAxisIndex(this.MA.getState("/AXISINDEX", this.MP.isAxisIndex()));
        if (this.MA.find("/AXISBUFFER")) {
            this.MP.setAxisBuffer(this.MA.getD("/AXISBUFFER"));
        }
        if ((specifiedView = this.MA.getS("VIEW")).length() > 0) {
            this.MP.setView(specifiedView);
        }
        this.oview = this.MP.view;
        String defCM = "";
        if (this.MA.getState("/DB")) {
            defCM = "10LOG";
        }
        if (this.MA.getState("/DB2")) {
            defCM = "20LOG";
        }
        this.MP.setMode(this.MA.getS("CM", defCM));
        this.ocm = this.MP.mode;
        String specifiedAxis = this.MA.getS("AXIS");
        if (specifiedAxis.length() > 0) {
            this.MP.setAxis(specifiedAxis);
        }
        if (this.M.macro == null) {
            this.MP.setReadout("+ONAXIS");
        }
        String readoutString = this.MA.getS("READOUT", "");
        this.MP.setReadout(this.MA.getS("/READOUT", readoutString));
        if (this.MA.find("/DATEFORMAT")) {
            this.MP.setDateFormat(this.MA.getS("/DATEFORMAT"));
        }
        if (this.MA.find("DRANGEUNITS")) {
            this.MP.setDRangeUnits(this.MA.getS("DRANGEUNITS"));
        }
        if (this.MA.find("/PRECISION")) {
            this.MP.setPrecision(this.MA.getL("/PRECISION", -1));
        }
        String opts = this.MA.getS("OPTIONS");
        this.MP.setOptions(opts);
        if (opts == null || !opts.contains("DRAGZOOM")) {
            this.MP.setOptions("+DRAGZOOM");
        }
        if (this.MA.getState("/ALL")) {
            this.MP.setOptions("+ALL|BS");
        }
        if (this.MA.find("Y1") || this.MA.find("YMIN") || this.MA.find("Z1") || this.MA.find("ZMIN")) {
            this.MP.scale &= 0xFFFFFFFE;
        }
        if (this.MA.find("Y2") || this.MA.find("YMAX") || this.MA.find("Z2") || this.MA.find("ZMAX")) {
            this.MP.scale &= 0xFFFFFFFD;
        }
        this.MP.setScale(this.MA.getS("SCALE"));
        if (this.MA.find("RANGE")) {
            this.MP.setRange(this.MA.getD("RANGE"));
        }
        if (this.MA.find("MINRANGE")) {
            this.MP.setMinRange(this.MA.getD("MINRANGE"));
        }
        if (this.MA.find("MAXRANGE")) {
            this.MP.setMaxRange(this.MA.getD("MAXRANGE"));
        }
        this.laytab = this.MA.getTable("/LAYER", this.MA.getTable("LAYER"));
        this.automask = this.M.pipeMode == 0 ? -1 : 2;
        this.automask = this.MA.getL("AUTOM", this.automask);
        this.setMimic(this.MA.getS("MIMIC"), true);
        this.MP.addTo(this);
        this.resize(1);
        this.setupTable = this.MA.getTable("SETUP");
        if (this.setupTable != null) {
            KeyObject.setKeys(this, this.setupTable, this.args, 1);
        }
        if (this.MA.find("SCALETABLE")) {
            this.scaleTable = this.MA.getTable("SCALETABLE");
        }
        this.inFile = this.MA.getRaw("FILE");
        boolean waitingOnPrescale = false;
        if (this.MA.find("/PRESCALE")) {
            waitingOnPrescale = this.prescaleSetup.open();
        }
        if (!waitingOnPrescale) {
            this.openFile(this.inFile);
            this.prescaleSetup.processScaleTable();
        }
        this.MP.setScaleAvg(this.MA.getL("AUTOL", this.MP.getScaleAvg()));
        this.MP.setMult(this.MA.getO("/XMULT", new Data(0), false), 'X');
        this.MP.setMult(this.MA.getO("/YMULT", new Data(0), false), 'Y');
        this.MP.setZoomAdjust(this.MA.getF("/ZOOMADJ", this.MP.getZoomAdjust()));
        this.MP.setZoomMult(this.MA.getF("/ZOOMMULT", this.MP.getZoomMult()));
        this.MP.setDblClickZoom(this.MA.getState("/DBLCLICKZOOM", this.MP.getDblClickZoom()));
        this.MP.setMouseWheelZoom(this.MA.getState("/MOUSEWHEELZOOM", this.MP.getMouseWheelZoom()));
        Table tmp = this.MR.getTable("ENV.KEYMAP");
        this.MP.setKeyMapTable(tmp != null ? tmp.getTable("PLOT") : null);
        if (this.MA.find("/LEGEND")) {
            this.parseLegend();
        }
        if ((ftab = this.MA.getTable("FEATURES")) != null) {
            this.MP.loadFeatures(ftab);
        }
        if (this.MA.find("ZOOMTO") && (zoomto = this.MA.getTable("ZOOMTO")) != null && zoomto.size() > 0) {
            this.zoomTo = zoomto;
        }
        if (this.MA.find("/DRAGDROP")) {
            this.MP.setDragAndDrop(this.MA.getState("/DRAGDROP"), this.MQ);
        }
        if (!this.MA.find("MIMIC") && this.MA.find("/USEMOUSEPOSITION")) {
            this.MP.setUseMousePosition(this.MA.getState("/USEMOUSEPOSITION"));
        }
        return 0;
    }

    private void setMTagXMidas(String str) {
        try {
            String tableStr = str.toUpperCase().replaceAll("[(]", "{").replaceAll("[)]", "}");
            tableStr = tableStr.replaceAll(":", "=");
            Table tab = new Table(tableStr);
            this.setMTag(tab);
        }
        catch (Exception e) {
            this.M.printStackTrace("Unable to parse X-Midas style /MTAG string=" + str + ".", e);
        }
    }

    private void setBoundsFromArgs() {
        if (this.MA.find("X1")) {
            this.MP.setUserLimits("X1", this.MA.getD("X1"), true);
            this.MP.orx1 = this.MA.getD("X1");
        }
        if (this.MA.find("XMIN")) {
            this.MP.setUserLimits("X1", this.MA.getD("XMIN"), true);
            this.MP.orx1 = this.MA.getD("XMIN");
        }
        if (this.MA.find("X2")) {
            this.MP.setUserLimits("X2", this.MA.getD("X2"), true);
            this.MP.orx2 = this.MA.getD("X2");
        }
        if (this.MA.find("XMAX")) {
            this.MP.setUserLimits("X2", this.MA.getD("XMAX"), true);
            this.MP.orx2 = this.MA.getD("XMAX");
        }
        if (this.MA.find("Y1")) {
            this.MP.setUserLimits("Y1", this.MA.getD("Y1"), true);
            this.MP.ory1 = this.MA.getD("Y1");
        }
        if (this.MA.find("YMIN")) {
            this.MP.setUserLimits("Y1", this.MA.getD("YMIN"), true);
            this.MP.ory1 = this.MA.getD("YMIN");
        }
        if (this.MA.find("Y2")) {
            this.MP.setUserLimits("Y2", this.MA.getD("Y2"), true);
            this.MP.ory2 = this.MA.getD("Y2");
        }
        if (this.MA.find("YMAX")) {
            this.MP.setUserLimits("Y2", this.MA.getD("YMAX"), true);
            this.MP.ory2 = this.MA.getD("YMAX");
        }
        if (this.MA.find("Z1")) {
            this.MP.setUserLimits("Z1", this.MA.getD("Z1"), true);
            this.MP.orz1 = this.MA.getD("Z1");
        }
        if (this.MA.find("ZMIN")) {
            this.MP.setUserLimits("Z1", this.MA.getD("ZMIN"), true);
            this.MP.orz1 = this.MA.getD("ZMIN");
        }
        if (this.MA.find("Z2")) {
            this.MP.setUserLimits("Z2", this.MA.getD("Z2"), true);
            this.MP.orz2 = this.MA.getD("Z2");
        }
        if (this.MA.find("ZMAX")) {
            this.MP.setUserLimits("Z2", this.MA.getD("ZMAX"), true);
            this.MP.orz2 = this.MA.getD("ZMAX");
        }
    }

    private void parseLegend() {
        Table table = this.MA.getTable("/LEGEND", null, 32);
        GWidget legend = this.MP.createLegend();
        if (table != null) {
            KeyObject.setKeys(legend, table);
        } else {
            String legStr = this.MA.getS("/LEGEND", "TL");
            if (legStr == null || legStr.length() == 0) {
                legStr = "TL";
            }
            this.MP.getLegend().setCorner(legStr);
        }
    }

    @Override
    public int process() {
        if (this.needScaleTable && !this.prescaleSetup.processPrescalar()) {
            return -1;
        }
        if (this.MP.status == -2) {
            return -1;
        }
        if (this.exiting) {
            return 9;
        }
        if (this.focus) {
            boolean bl = this.focus = !this.MP.getFocus();
        }
        if (this.nice == 2 && this.MP.status == -1 || this.nice == -2 && this.MP.status == 1) {
            this.nice = -this.nice;
            for (int n = 1; n < this.MP.layers.size(); ++n) {
                Layer lay = (Layer)this.MP.layers.get(n);
                if (lay.pf == null) continue;
                lay.pf.connect(this.nice);
            }
        }
        int stat = 0;
        int mode = this.MP.dataMode();
        if (mode != 0) {
            stat = this.getData();
        }
        if (mode >= 0) {
            if (stat > 0) {
                this.refresh(stat);
            } else if (stat == 0 && this.MP.needRefresh()) {
                Time.sleep(0.1);
                this.refresh(this.MP.needLayerRefresh() ? 0 : 1);
            }
        }
        if (this.zoomTo != null) {
            this.processMessage(new Message("ZOOM", 0, this.zoomTo));
            this.zoomTo = null;
        }
        if (this.pointerCount > 0 && Time.current() - this.pointerTime > 0.1) {
            this.updatePointer();
        }
        if (this.MP.needCrossHairRefresh()) {
            this.MP.updateCursor();
        }
        if (stat <= 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public int close() {
        this.MP.features.clear();
        this.closeFile("*");
        this.MP.close();
        return 0;
    }

    @Override
    public int processReady() {
        return 1;
    }

    @Override
    public void setFile(String names) {
        this.openFile(names);
    }

    @Override
    public void openFile(String names) {
        this.openFile(names, null);
    }

    @Override
    public void openFile(String names, Table newargs) {
        this.MP.setAxisIndex(this.MA.getState("/INDEX", false));
        this.MP.setAxisIndex(this.MA.getState("/AXISINDEX", this.MP.isAxisIndex()));
        this.MP.viewLimits = new Table();
        if (names == null) {
            names = "";
        }
        if (newargs != null) {
            this.updateArgs(newargs);
        }
        Args.SplitArg sa = this.MA.getSplitArg(names, '|');
        HashSet<String> tags = new HashSet<String>();
        for (int i = 0; i < sa.getFields(); ++i) {
            Layer lay;
            String fname = sa.getField(i);
            if (fname.length() == 0) continue;
            if (this.MR.containsKey(fname.toUpperCase())) {
                Object nameO = this.MR.get(fname.toUpperCase());
                if (nameO instanceof Table) {
                    fname = nameO.toString();
                } else if (nameO instanceof String && (((String)nameO).startsWith("{") || ((String)nameO).endsWith(".tbl"))) {
                    fname = (String)nameO;
                }
            }
            Table tab = null;
            if (fname.startsWith("{") || fname.endsWith(".tbl")) {
                tab = Convert.o2t(fname, this.M);
                String fn = tab.getS("FILENAME");
                if (fn != null) {
                    fname = fn;
                    tab.remove("FILENAME");
                } else {
                    lay = Layer.getLayer(tab);
                    KeyObject.setKeys(lay, tab, this.args, 0);
                    if (this.MP.getLayers() != null && this.MP.getLayers().findKey(lay.getName()) >= 0) {
                        this.M.warning("PLOT: Multiple layers found with TAG=" + lay.getName() + ". Use new TAG=<tag> qualifier in order to show both layers.");
                    }
                    this.MP.addLayer(lay);
                    continue;
                }
            }
            BaseFile bf = BaseFile.getInstanceFor(this, (Object)fname);
            if (!fname.startsWith("_") && !bf.find(-1)) {
                if ((this.openWarn & 1) != 0) {
                    if (Theme.getOption(64)) {
                        MJPopup popup2 = MJPopup.createOk(this.MP.getPanel(), this.getID() + ": NoFile", 0, "File " + bf.getName() + " not found");
                        popup2.display(0);
                    } else {
                        new GAlert(this.MP, "NoFile", "File " + bf.getName() + " not found", "OK", 1, 0, this);
                    }
                }
                if ((this.openWarn & 2) == 0) continue;
                this.M.warning("PLOT: File " + bf.getName() + " not found");
                continue;
            }
            if (bf instanceof PlotFile) {
                bf.setFlags(16384);
                lay = new Layer();
                lay.setFile((PlotFile)((Object)bf));
                if (tags.contains(lay.pf.getTag())) {
                    this.M.warning("PLOT: Multiple layers found with TAG=" + lay.pf.getTag() + ". Use new TAG=<tag> qualifier in order to show both layers.");
                }
                tags.add(lay.pf.getTag());
                Table layquals = Convert.o2t(bf.getQualifier("LAYER"));
                if (layquals == null || layquals.get("GROUP") == null) {
                    this.MP.addLayer(lay.pf.getTag(), lay);
                }
                this.openLayerFile(lay, lay.pf, tab);
                continue;
            }
            this.M.warning("File " + bf.getName() + " is not a PlotFile");
        }
    }

    private void updateArgs(Table newArgs) {
        String[] keys;
        if (newArgs == null) {
            return;
        }
        for (String key : keys = newArgs.getKeys()) {
            key = key.toUpperCase();
            this.args.put(key, newArgs.get(key).toString());
            if (key.equals("/ALL")) {
                this.MP.setOptions("+ALL|BS");
                continue;
            }
            if (!key.equals("/NICE")) continue;
            this.nice = newArgs.getL("/NICE", this.nice);
        }
    }

    private void openLayerFile(Layer oldLayer, PlotFile pf, Table flaytab) {
        this.MP.viewLimits = new Table();
        String layerName = oldLayer.name;
        int layerIndex = this.MP.layers.find(layerName);
        if (this.nice > 0 && !pf.find(-1)) {
            return;
        }
        if (!pf.open(64)) {
            return;
        }
        if (flaytab == null) {
            flaytab = Convert.o2t(pf.getQualifier("LAYER"), this.M);
        }
        if (flaytab == null && pf instanceof DataFile) {
            DataFile df = (DataFile)pf;
            flaytab = Convert.o2t(df.keywords.get("PLOTLAYERTABLE"), this.M);
        }
        if (flaytab == null) {
            flaytab = this.laytab;
        } else if (this.laytab != null) {
            flaytab.setPrevious(this.laytab);
        }
        Layer lay = Layer.getLayer(flaytab, pf, this.type);
        if (lay == null) {
            this.M.warning("File type not supported by plotter: " + pf);
            pf.close();
            return;
        }
        lay.init(this, layerName, layerIndex, pf, flaytab, oldLayer);
        if (this.laytab != null) {
            KeyObject.setKeys(lay, this.laytab, this.args, 0);
        }
        if (flaytab != this.laytab) {
            KeyObject.setKeys(lay, flaytab, this.args, 0);
        }
        this.MP.addLayer(lay);
        if (lay.isBaseLayer()) {
            this.adjustPlotNewBaselayer(lay);
        }
        if (this.MP.getZoomLevel() == 0) {
            this.rescale = 1;
        }
    }

    @Override
    public void setBaseLayer(String layName) {
        Layer lay = (Layer)this.MP.layers.get(layName);
        if (lay != null) {
            this.setBaseLayer(lay);
        } else {
            this.M.error("Layer " + layName + " does not exist - not updating Base Layer");
        }
    }

    @Override
    public void setBaseLayer(Layer lay) {
        if (!lay.isBaseLayer()) {
            Layer previousBaseLayer = this.MP.getBaseLayer();
            if (previousBaseLayer != null) {
                previousBaseLayer.setBaseLayer(false);
            }
            this.MP.setBaseLayer(lay);
            this.adjustPlotNewBaselayer(lay);
        }
    }

    private void adjustPlotNewBaselayer(Layer lay) {
        if (this.ocm == 0) {
            this.MP.setMode(this.determineComplexMode(lay), false);
        }
        if (this.MP.getZoomLevel() == 0) {
            this.MP.rescale(true);
        }
        if (this.oview == 0) {
            this.MP.setView(lay.getDefaultView());
        }
        if (!this.unitsInit) {
            this.MP.setXYZUnits(lay.getXUnits(), lay.getYUnits(), lay.getZUnits(), true);
            this.unitsInit = true;
        }
    }

    @Override
    public void closeFile(String match) {
        this.MP.viewLimits = new Table();
        for (int n = this.MP.layers.size() - 1; n > 0; --n) {
            String layerName = this.MP.layers.getKey(n);
            Layer lay = (Layer)this.MP.layers.get(n);
            if (match.equals("*") || layerName.equalsIgnoreCase(match)) {
                this.MP.removeLayer(layerName);
                if (lay.pf == null) continue;
                lay.pf.close();
                continue;
            }
            if (!(lay instanceof LayerDrawable)) continue;
            ((LayerDrawable)lay).removeDrawable(match);
        }
        if (this.state == 3 || this.state == 10) {
            return;
        }
        this.MP.reset(-1);
        if (this.MP.layers.size() == 1) {
            this.MP.unzoom(0);
        }
        this.refresh();
    }

    @Override
    public void removeFeature(String match) {
        KeyVector features = this.MP.getFeatures();
        boolean all = match.equals("*");
        for (int i = features.size() - 1; i >= 0; --i) {
            String featureName = features.getKey(i);
            if (!all && !featureName.equalsIgnoreCase(match)) continue;
            this.MP.removeFeature(featureName);
        }
        for (int n = this.MP.layers.size() - 1; n > 0; --n) {
            Layer lay = (Layer)this.MP.layers.get(n);
            if (!(lay instanceof LayerDrawable)) continue;
            ((LayerDrawable)lay).removeDrawable(match);
        }
    }

    private int getData() {
        int status = 0;
        boolean autoscale = this.rescale == 0 && (this.MP.scale & 3) != 0 && this.MP.getScaleAvg() > 0;
        for (int n = 1; n < this.MP.layers.size(); ++n) {
            Layer lay = (Layer)this.MP.layers.get(n);
            if (lay == null) continue;
            PlotFile pf = lay.pf;
            if (pf != null && (pf.isOpen() || lay instanceof LayerKML) || lay instanceof LayerDrawable) {
                int stat = lay.getData(0);
                if (stat > 0) {
                    status = stat;
                    if (autoscale && !lay.isPaged) {
                        lay.findRange();
                    }
                } else if (stat == -1) {
                    pf.close();
                }
                if (this.exit != 16 || stat > 0) continue;
                this.exiting = true;
                continue;
            }
            if (pf != null && this.nice > 0) {
                this.openLayerFile(lay, pf, null);
                continue;
            }
            if (!autoscale || !lay.getNeedsRescale()) continue;
            this.rescale = 1;
            status = 1;
        }
        if (status > 0 || this.imageFlag) {
            if (this.rescale > 0) {
                this.MP.findRange();
                this.setBoundsFromArgs();
                this.MP.applyUserBounds("OUTER");
                if (this.MA.find("XU")) {
                    this.MP.setXUnits(this.MA.getS("XU"));
                }
                if (this.MA.find("YU")) {
                    this.MP.setYUnits(this.MA.getS("YU"));
                }
                if (this.MA.find("ZU")) {
                    this.MP.setZUnits(this.MA.getS("ZU"));
                }
                this.MP.useRange();
                this.MP.applyUserBounds("VIEW");
                this.rescale = 2;
            } else if (autoscale && status != 3 && this.MP.getZoomLevel() == 0 && this.MP.autoScale(this.automask, false)) {
                this.rescale = 2;
            }
        }
        if (this.imageFlag) {
            this.MP.setView(this.MP.view, false, true);
            this.imageFlag = false;
        }
        return status;
    }

    private void refresh() {
        this.refresh(0);
    }

    private void refresh(int flag) {
        if (this.state == 6 || this.state == 3 || this.state == 10 || this.exiting) {
            return;
        }
        if (flag != 2) {
            this.MQ.remove("REFRESH");
        }
        if (this.rescale > 0) {
            flag = 0;
        }
        if (this.MP.status == 1) {
            this.MP.refresh(flag);
        }
        if (this.rescale == 2) {
            this.rescale = 0;
        }
    }

    private void resize(int mode) {
        this.MP.resize();
    }

    @Override
    public boolean isRealTimeMode() {
        return this.realtime > 0;
    }

    @Override
    public boolean isReverseColorsMode() {
        return this.MA.getState("/REVERSECOLORS", false);
    }

    @Override
    @InternalUseOnly
    public void setImageFlag(boolean imgFlag) {
        this.imageFlag = imgFlag;
    }

    @Override
    public void setDragAndDrop(boolean allow) {
        this.MP.setDragAndDrop(allow, this.MQ);
    }

    @Override
    public void setXCnt(int mode) {
        if (mode == this.controls) {
            return;
        }
        this.controls = mode;
    }

    @Override
    public void setXCnt(String mode) {
        this.setXCnt(Parser.mask(pointerMessageList, mode, this.controls));
    }

    @Override
    public void setMTag(Table tbl) {
        this.mtag = tbl;
    }

    @Override
    public Table getMTag() {
        return this.mtag;
    }

    @Override
    public int processMessage(Message msg) {
        return this.processMessage(msg, false);
    }

    @Override
    public int processMessage(Message msg, boolean direct) {
        String text;
        Table quals = Convert.o2t(msg.quals);
        switch (msg.name) {
            case "KEYPRESS": {
                text = (String)msg.data;
                if ("M".equalsIgnoreCase(text)) {
                    msg.name = "MENU";
                    break;
                }
                if ("A".equalsIgnoreCase(text)) {
                    this.MP.setReadout("~INDEX");
                    return -1;
                }
                if (!"Enter".equalsIgnoreCase(text)) break;
                if ((this.exit & 1) != 0) {
                    this.exiting = true;
                    this.MP.cancel = true;
                }
                return -1;
            }
            case "KEYRELEASE": {
                return -1;
            }
            case "DRAG": {
                if (this.M == null || this.M.pipeMode != 3) break;
                this.MP.refresh();
                this.sendMouseMessage(msg, 4);
            }
        }
        if (!direct && !this.thisIsMe()) {
            switch (msg.name) {
                case "PAINT": 
                case "POINTER": 
                case "DRAG": 
                case "PAN": 
                case "PANOBS": 
                case "PANGEO": {
                    break;
                }
                default: {
                    if (this.MQ != null) {
                        this.MQ.put(msg);
                    }
                    return -1;
                }
            }
        }
        if ("PAINT".equals(msg.name)) {
            this.MP.refresh();
        } else if (!"KEYPRESS".equals(msg.name)) {
            if ("RESIZE".equals(msg.name)) {
                this.setCursorAndRefresh(null, false);
                this.resize(0);
                if (this.M.pipeMode == 3) {
                    this.MP.cancel = false;
                }
            } else if ((this.MP == null || this.MP.processMessage(msg, this.getMessageHandler(), this) != 1) && super.processMessage(msg) == -1) {
                block81 : switch (msg.name) {
                    case "POINTER": 
                    case "DRAG": {
                        if (msg.info == 9) {
                            return 0;
                        }
                        if (++this.pointerCount == 1) {
                            this.pointerTime = Time.current();
                        }
                        this.pointerMsg = msg;
                        break;
                    }
                    case "FOCUS": 
                    case "MOVED": {
                        break;
                    }
                    case "HOVER": {
                        msg.data = this.MP.getPosition(this.MP.px, this.MP.py);
                        this.sendMouseMessage(msg, 1);
                        break;
                    }
                    case "BUTTON": {
                        if (msg.info % 100 != 1) break;
                        this.processMarkMessage(msg);
                        break;
                    }
                    case "MARK_MESSAGE": {
                        this.processMarkMessage(msg);
                        break;
                    }
                    case "REFRESH": {
                        this.MP.resetForRefresh();
                        this.refresh();
                        break;
                    }
                    case "HOLDREFRESH": {
                        this.MP.setHoldRefresh((String)msg.data);
                        break;
                    }
                    case "RESIZE": {
                        this.setCursorAndRefresh(null, false);
                        this.resize(0);
                        break;
                    }
                    case "DRAGBOX": {
                        this.setCursorAndRefresh(null, true);
                        this.sendMessage(msg);
                        this.MP.panel.repaint();
                        break;
                    }
                    case "DBLCLICK": {
                        this.MP.setDblClickZoom(Convert.o2z(msg.data));
                        break;
                    }
                    case "DBLCLICKZOOM": 
                    case "DBLCLICKUNZOOM": {
                        this.sendMessage(msg);
                        break;
                    }
                    case "ZOOMIN": 
                    case "ZOOMOUT": {
                        this.handlePercentZoomMessage(msg);
                        break;
                    }
                    case "ZOOM": 
                    case "ZOOMX": 
                    case "ZOOMY": {
                        int flags = 0;
                        this.setCursorAndRefresh(null, true);
                        if (msg.name.indexOf(88) > 0) {
                            flags |= 1;
                        }
                        if (msg.name.indexOf(89) > 0) {
                            flags |= 2;
                        }
                        if (quals != null && !StringUtil.isEmpty(quals.getS("MIMIC_ORIGIN"))) {
                            flags = 1;
                        }
                        if (!this.MP.zoom(msg.data, flags)) break;
                        this.refresh();
                        this.sendMessage(msg);
                        break;
                    }
                    case "UNZOOM": {
                        if (this.MP.unzoom()) {
                            this.refresh();
                            msg.info = this.MP.getZoomLevel();
                        } else {
                            msg.info = -1;
                        }
                        DragBox db = this.MP.getZoomBounds();
                        this.addTimeValuesFromPlot(db);
                        msg.data = db;
                        this.sendMessage(msg);
                        break;
                    }
                    case "PANXY": {
                        String cursor = msg.info == -9 ? "NERESIZE" : "MOVE";
                        int flags = 3;
                        this.setCursorAndRefresh(cursor, false);
                        if (quals != null && !StringUtil.isEmpty(quals.getS("MIMIC_ORIGIN"))) {
                            flags = 1;
                        }
                        if (!this.MP.panxy(msg.data, flags)) break;
                        this.refresh(3);
                        this.sendMessage(msg);
                        break;
                    }
                    case "PANX": {
                        if (this.MP.panxy(msg.data, 1)) {
                            this.setCursorAndRefresh("MOVE", true);
                            this.sendMessage(msg);
                            break;
                        }
                        this.setCursorAndRefresh("MOVE", false);
                        break;
                    }
                    case "PANY": {
                        int flags = 2;
                        if (quals != null && !StringUtil.isEmpty(quals.getS("MIMIC_ORIGIN"))) {
                            flags = 1;
                        }
                        if (this.MP.panxy(msg.data, flags)) {
                            this.setCursorAndRefresh("MOVE", true);
                            this.sendMessage(msg);
                            break;
                        }
                        this.setCursorAndRefresh("MOVE", false);
                        break;
                    }
                    case "PANTW": {
                        if (this.MP.pantw(msg.data, msg.info)) {
                            this.setCursorAndRefresh("MOVE", true);
                            this.sendMessage(msg);
                            break;
                        }
                        this.setCursorAndRefresh("MOVE", false);
                        break;
                    }
                    case "PANOBS": 
                    case "PANGEO": {
                        if (this.MP.panobs(msg.data)) {
                            this.setCursorAndRefresh("HAND", false);
                            this.MP.refresh(3);
                            this.sendMessage(msg);
                            break;
                        }
                        this.setCursorAndRefresh("HAND", false);
                        break;
                    }
                    case "MENU": {
                        new GMenu(this.MP, "Plot", "Files,Layers,Features,View,Mode,Scale,Axis,Readout,Legend,Options,Query,Export,More,Exit", 0, 0, this);
                        break;
                    }
                    case "PLOT": {
                        switch ((String)msg.data) {
                            case "FILES": {
                                int i = this.MP.layers.size();
                                new GMenu(this.MP, "File", "AddNew,Reread," + this.MP.layers.getKeyList(1, i), 0, 0, this);
                                break;
                            }
                            case "QUERY": {
                                new GQuery(this.MP, "Query Plot", this, 0, (MessageHandler)this);
                                break;
                            }
                            case "FEATURES": {
                                String menuitems = this.MP.features.size() > 0 ? "Load,Save,AddNew,DeleteAll," + this.MP.features.getKeyList() : "Load,Save,AddNew";
                                new GMenu(this.MP, "Feature", menuitems, 0, 0, this);
                                break;
                            }
                            case "MORE": {
                                new GMenu(this.MP, "More", "About,Window,Controls,Animate,Theme,Precision,Type,~Dots,Locate,GoToLocation", 0, 0, this);
                                break;
                            }
                            case "TYPE": {
                                new GMenu(this.MP, "Type", "LINE,RASTER,CONTOUR,MESH,POINT,DOT", 0, 0, this);
                                break;
                            }
                            case "EXIT": {
                                if ((this.exit & 2) == 0) break block81;
                                this.exiting = true;
                                this.MP.cancel = true;
                                break;
                            }
                            case "EXPORT": {
                                Object[] types = ExportImage.getFileTypes(true);
                                String ext = ExportImage.getSuggestedType();
                                String filter = "*." + StringUtil.join(types, "|");
                                if (types.length == 0) {
                                    new GDialog((Object)this.MP, "Can not export plot: Java can not find an appropriate export library.", 0, 0, 0, null);
                                    break;
                                }
                                int flags = Parser.mask(GFiles.flagsList, "QUAL|SINGLEAUX|HIDEOPTS", 0);
                                new GFiles(this.MP, "ExportImage", "myplot." + ext, filter, null, this.M, 0, 0, flags, this);
                                break;
                            }
                            default: {
                                this.MP.configure((String)msg.data);
                                break;
                            }
                        }
                        break;
                    }
                    case "EXPORTIMAGE": {
                        FileName fname = FileName.toFileName(msg.data);
                        String ext = fname.getExt();
                        if (ext == null || ext.length() == 0) {
                            ext = ExportImage.getSuggestedType();
                            fname.setExt(ext);
                        }
                        this.M.info("Exporting image " + fname);
                        try {
                            this.MP.exportImage().writeToFile(fname.toLocalFileName(), ext);
                        }
                        catch (Exception e) {
                            this.M.printStackTrace("Unable to export image TYPE=" + fname.getExt() + " FILENAME=" + fname + ".", e);
                        }
                        break;
                    }
                    case "NOFILE": {
                        break;
                    }
                    case "MORE": {
                        switch ((String)msg.data) {
                            case "WINDOW": {
                                new GMenu(this.MP, "Window", "Toggle,Push,Pop,Panel", 0, 0, this);
                                break;
                            }
                            case "CONTROLS": {
                                new GMenu(this.MP, "Controls", pointerMessageList, this.controls, 1024, this);
                                break;
                            }
                            case "ANIMATE": {
                                new GValue(this.MP, "Time", this.atime, 0.0, 86400.0, 1.0, 'T', 0, this);
                                break;
                            }
                            case "THEME": {
                                new GMenu(this.MP, "Theme", "DeskTop,Default,WoB,GoB,BoW,MnM,Browser,Gear1,Gear2,Gear3,Gear4,Nak", 0, 0, this);
                                break;
                            }
                            case "PRECISION": {
                                new GValue(this.MP, "Precision", this.MP.getPrecision(), -1.0, 20.0, 1.0, 'L', 0, this);
                                break;
                            }
                            case "TYPE": {
                                new GMenu(this.MP, "Type", "LINE,RASTER,CONTOUR,MESH,POINT,DOT", this.type, 0, this);
                                break;
                            }
                            case "~DOTS": {
                                for (int n = 1; n < this.MP.layers.size(); ++n) {
                                    Object layerOrFeature = this.MP.layers.get(n);
                                    if (layerOrFeature instanceof Feature) {
                                        ((Feature)this.MP.layers.get(n)).getLine().setType("~DOT");
                                        continue;
                                    }
                                    if (!(layerOrFeature instanceof Layer)) continue;
                                    ((Layer)this.MP.layers.get(n)).getLine().setType("~DOT");
                                }
                                break block81;
                            }
                            case "LOCATE": {
                                Position pos = this.MP.getPosition();
                                Feature feature = new Feature();
                                feature.getLine().setColor("RED");
                                feature.setType("TEXT|OSYMBOL");
                                feature.setText("YouAreHere");
                                feature.setX(pos.x);
                                feature.setY(pos.y);
                                this.MP.addFeature("YOUAREHERE", feature);
                                feature.dialog();
                                break;
                            }
                            case "GOTOLOCATION": {
                                this.goToLocationDialog();
                                break;
                            }
                            case "ABOUT": {
                                String messageText = "NeXtMidas PLOT 4.1.4";
                                if (Theme.getOption(64)) {
                                    MJPopup popup2 = MJPopup.createOk(this.MP.getPanel(), "About PLOT", -1, messageText);
                                    popup2.display(0);
                                    break;
                                }
                                new GAlert(this.MP, "ABOUT:PLOT", messageText, "OK", 1, 0, this);
                                break;
                            }
                            default: {
                                this.M.warning("Unexpected message " + msg + " data=" + msg.data);
                                break;
                            }
                        }
                        break;
                    }
                    case "ABOUT:PLOT": {
                        break;
                    }
                    case "GOTOLOCATION": {
                        this.goToLocationHandler((Table)msg.data);
                        break;
                    }
                    case "FILE": 
                    case "LAYER": {
                        switch (text = (String)msg.data) {
                            case "ADDNEW": {
                                int flags = Parser.mask(GFiles.flagsList, "PATH|EXT", 0);
                                new GFiles(this.MP, "OpenFile", null, "*.tmp|prm|shp|jpg|png", null, this.M, 0, 0, flags, this);
                                break;
                            }
                            case "REREAD": {
                                for (int n = 1; n < this.MP.layers.size(); ++n) {
                                    ((Layer)this.MP.layers.get(n)).reread();
                                }
                                break block81;
                            }
                            default: {
                                ((Layer)this.MP.layers.get((String)msg.data)).configure();
                                break;
                            }
                        }
                        break;
                    }
                    case "FEATURE": {
                        switch (text = (String)msg.data) {
                            case "LOAD": {
                                new GFiles(this.MP, "LoadFeaturesFromFile", null, "*.tbl", null, this.M, 0, 0, Parser.mask(GFiles.flagsList, "EXT", 0), this);
                                break block81;
                            }
                            case "SAVE": {
                                new GFiles(this.MP, "SaveFeaturesToFile", null, "*.tbl", null, this.M, 0, 0, 0, this);
                                break block81;
                            }
                            case "ADDNEW": {
                                Position p = this.MP.getPosition(this.MP.px, this.MP.py);
                                Feature f = new Feature();
                                f.setX(p.x);
                                f.setY(p.y);
                                this.MP.addFeature(this.getAutoFeatureName("F"), f);
                                f.configure();
                                break block81;
                            }
                            case "DELETEALL": {
                                new GMenu(this.MP, "Delete All Features?", "Yes,No", 0, 0, this);
                                break block81;
                            }
                        }
                        Feature f = (Feature)this.MP.features.get(text);
                        f.configure();
                        break;
                    }
                    case "LOADFEATURESFROMFILE": {
                        this.MP.loadFeatures((String)msg.data);
                        break;
                    }
                    case "SAVEFEATURESTOFILE": {
                        this.MP.saveFeatures((String)msg.data);
                        break;
                    }
                    case "DELETE ALL FEATURES?": {
                        if (!"YES".equals(msg.data)) break;
                        this.MP.removeAllFeatures();
                        break;
                    }
                    case "LIMITS": {
                        switch (text = (String)msg.data) {
                            case "LOAD": {
                                new GFiles(this.MP, "LoadLimitsFromFile", null, "*.tbl", null, this.M, 0, 0, Parser.mask(GFiles.flagsList, "EXT", 0), this);
                                break;
                            }
                            case "SAVE": {
                                new GFiles(this.MP, "SaveLimitsToFile", null, "*.tbl", null, this.M, 0, 0, 0, this);
                            }
                        }
                        break;
                    }
                    case "LOADLIMITSFROMFILE": {
                        this.MP.loadLimits((String)msg.data);
                        break;
                    }
                    case "SAVELIMITSTOFILE": {
                        this.MP.saveLimits((String)msg.data);
                        break;
                    }
                    case "CONTROLS": {
                        this.controls = msg.info;
                        break;
                    }
                    case "SHOW": {
                        this.MP.display(msg.info);
                        break;
                    }
                    case "SHOWN": {
                        if (this.MP.status == -2) break;
                        this.MP.status = msg.info;
                        break;
                    }
                    case "WINDOW": {
                        text = (String)msg.data;
                        if (text.equals("CLOSING") && (this.exit & 8) != 0) {
                            this.exiting = true;
                            this.MP.cancel = true;
                            break;
                        }
                        if (text.equals("TOGGLE")) {
                            this.MP.pop(-1);
                            break;
                        }
                        if (text.equals("PUSH")) {
                            this.MP.pop(0);
                            break;
                        }
                        if (!text.equals("POP")) break;
                        this.MP.pop(1);
                        break;
                    }
                    case "OPENFILE": {
                        this.openFileWithLimits(msg);
                        break;
                    }
                    case "CLOSEFILE": {
                        this.closeFile((String)msg.data);
                        break;
                    }
                    case "TIME": {
                        this.atime = Convert.o2d(msg.data);
                        this.MP.setTime(this.atime);
                        break;
                    }
                    case "TYPE": {
                        this.setType((String)msg.data);
                        this.refresh();
                        break;
                    }
                    case "PRECISION": {
                        this.MP.setPrecision(Convert.o2l(msg.data));
                        this.refresh();
                        break;
                    }
                    case "THEME": {
                        this.MP.setTheme((String)msg.data);
                        this.refresh();
                        break;
                    }
                    case "REPARENT": {
                        this.MP.reParent(msg.data);
                        this.refresh();
                        break;
                    }
                    case "EXIT": {
                        if ((this.exit & 4) == 0) break;
                        return 9;
                    }
                    case "XCUT": {
                        if (!this.thisIsMe()) {
                            this.MQ.put(msg);
                            return -1;
                        }
                        if (msg.data == null) {
                            msg.data = new Table("IX=" + this.MP.px + ",IY=" + this.MP.py);
                        }
                        Table tbl = (Table)msg.data;
                        this.doXYCut("X", tbl.getL("IX", this.MP.px), tbl.getL("IY", this.MP.py), (plottester)tbl.getO("WIN"));
                        break;
                    }
                    case "YCUT": {
                        if (!this.thisIsMe()) {
                            this.MQ.put(msg);
                            return -1;
                        }
                        if (msg.data == null) {
                            msg.data = new Table("IX=" + this.MP.px + ",IY=" + this.MP.py);
                        }
                        Table tbl = (Table)msg.data;
                        this.doXYCut("Y", tbl.getL("IX", this.MP.px), tbl.getL("IY", this.MP.py), (plottester)tbl.getO("WIN"));
                        break;
                    }
                    case "DROPDATA": {
                        this.sendMessage(msg);
                        break;
                    }
                    default: {
                        this.M.warning("Unhandled message name=" + msg.name + " in PLOT from " + msg.from);
                    }
                }
            }
        }
        return 0;
    }

    private void processMarkMessage(Message msg) {
        msg.name = "MARK";
        msg.data = this.MP.getPosition(this.MP.px, this.MP.py);
        if (this.stealNextClick != null) {
            StealsMouseClick smc = this.stealNextClick;
            this.stealNextClick = null;
            smc.mouseClicked(msg);
        } else {
            this.sendMouseMessage(msg, 1);
        }
    }

    @Override
    protected void openFileWithLimits(Message msg) {
        if (msg.info == -1) {
            if (msg.name.equals("OVERLAY")) {
                this.M.warning("Plot.processOMessage: -1 cannot be msg.info value for opening overlays.");
            } else {
                this.closeFile("*");
            }
        }
        Table quals = Convert.o2t(msg.quals);
        this.imageFlag = false;
        this.openFile(Convert.o2s(msg.data), quals);
        if (quals != null) {
            Table vlimits;
            Table olimits = quals.getTable("OUTERLIMITS");
            if (olimits != null) {
                String[] keys;
                for (String key : keys = olimits.getKeys()) {
                    this.MP.setOuterLimits(key, olimits.getD(key));
                }
            }
            if ((vlimits = quals.getTable("VIEWLIMITS")) != null) {
                String[] keys;
                for (String key : keys = vlimits.getKeys()) {
                    this.MP.setViewLimits(key, vlimits.getD(key));
                }
            }
        }
    }

    private void updatePointer() {
        if (this.pointerMsg == null) {
            return;
        }
        this.pointerCount = 0;
        Message msg = this.pointerMsg;
        msg.data = this.MP.getPosition();
        this.MP.formatReadout(msg.info);
        this.MP.updateCursor();
        if (msg.name.equals("DRAG")) {
            this.setCursorAndRefresh("Crosshair", true);
            this.sendMouseMessage(msg, 4);
        } else {
            this.setCursorAndRefresh(null, false);
            msg.name = "MARK";
            if (this.MP.px > this.MP.ix1 && this.MP.px < this.MP.ix2 && this.MP.py > this.MP.iy1 && this.MP.py < this.MP.iy2) {
                this.sendMouseMessage(msg, 2);
            }
        }
    }

    private void handlePercentZoomMessage(Message msg) {
        float percent = 0.5f;
        boolean setInQuals = false;
        Table t = null;
        if (msg.quals != null && (t = Convert.o2t(msg.quals)).containsKey("PERCENT")) {
            percent = t.getF("PERCENT", percent);
            setInQuals = true;
        }
        if (!setInQuals) {
            percent = Convert.o2f(msg.data, this);
            if (t == null) {
                t = new Table();
            }
            t.put("PERCENT", percent);
            msg.quals = t;
        }
        if (percent > 0.0f || percent == -1.0f) {
            if (msg.name.equals("ZOOMIN")) {
                this.MP.zoomIn(percent);
            } else {
                this.MP.zoomOut(percent);
            }
        } else if (msg.name.equals("ZOOMIN")) {
            this.MP.zoomIn();
        } else {
            this.MP.zoomOut();
        }
        DragBox db = this.MP.getZoomBounds();
        this.addTimeValuesFromPlot(db);
        msg.data = db;
        this.sendMessage(msg);
    }

    private void addTimeValuesFromPlot(DragBox db) {
        double tmin = Math.min(this.MP.getTMin(), this.MP.getTMax());
        double tmax = Math.max(this.MP.getTMin(), this.MP.getTMax());
        db.setTMin(tmin);
        db.setT1(this.MP.getT1());
        db.setTMax(tmax);
        db.setT2(this.MP.getT2());
    }

    private void updateMtagResults() {
        if (this.mtag != null) {
            String[] keys = this.mtag.getKeys();
            Position p = this.MP.getPosition(this.MP.px, this.MP.py);
            for (String key : keys) {
                String resLabel = this.mtag.getS(key);
                if (key.equalsIgnoreCase("X")) {
                    this.MR.put(resLabel, this.MP.isMapView() ? p.lon : p.x);
                }
                if (key.equalsIgnoreCase("Y")) {
                    this.MR.put(resLabel, this.MP.isMapView() ? p.lat : p.y);
                }
                if (key.equalsIgnoreCase("Z")) {
                    this.MR.put(resLabel, this.MP.isMapView() ? p.alt : p.z);
                }
                if (!key.equalsIgnoreCase("X+Y")) continue;
                this.MR.put(resLabel, p.x + p.y);
            }
        }
    }

    @Override
    protected void sendMessage(Message msg) {
        if (msg.name.startsWith("ZOOM") || msg.name.startsWith("UNZOOM") || msg.name.startsWith("PAN")) {
            Table quals = Convert.o2t(msg.getQuals());
            if (!this.mimic.isEmpty() && (quals == null || StringUtil.isEmpty(quals.getS("MIMIC_ORIGIN")))) {
                if (quals == null) {
                    quals = new Table();
                    msg.setQuals(quals);
                }
                Table quals2 = quals.copy();
                quals2.put("MIMIC_ORIGIN", (Object)this.id);
                for (Map.Entry<String, MessageHandler> e : this.mimic.entrySet()) {
                    if (e.getValue() == null) {
                        e.setValue(this.M.registry.getMessageHandler(e.getKey(), -1));
                    }
                    Message mmsg = new Message(msg.name, msg.info, msg.data, null, this, quals2);
                    e.getValue().processMessage(mmsg);
                }
            }
            if (this.rmif != null) {
                this.modifyRmifProperty();
            }
        }
        super.sendMessage(msg);
    }

    public void doXYCut(String key, int ix, int iy, plottester plotprim) {
        String plotCmd;
        String outFile;
        String cutPlotID;
        DataFile tmpFile;
        if (ix < this.MP.ix1 || ix > this.MP.ix2 || iy < this.MP.iy1 || iy > this.MP.iy2) {
            this.M.warning("Mouse position out of bounds. Unable to create " + key + "Cut.");
            return;
        }
        char cutType = key.toUpperCase().charAt(0);
        double x = this.MP.getrx(ix, iy);
        double y = this.MP.getry(ix, iy);
        boolean xcut = cutType == 'X';
        boolean ycut = cutType == 'Y';
        Layer lay = this.getLayer();
        String qualString = "";
        boolean zoom = false;
        double boundsMin = xcut ? this.MP.getXMin() : this.MP.getYMin();
        double boundsMax = xcut ? this.MP.getXMax() : this.MP.getYMax();
        try {
            tmpFile = (DataFile)lay.getFile();
            Table quals = tmpFile.getQualifiers();
            if (quals != null) {
                qualString = quals.toString();
            }
            if (tmpFile.isPipe()) {
                this.M.warning(cutType + "Cut not supported for piped files. File:[" + tmpFile.getTag() + "]");
                return;
            }
        }
        catch (Exception e) {
            this.M.warning("Missing or invalid file type for " + cutType + "Cut. File must be a DataFile (Midas Blue File)");
            return;
        }
        Table userBounds = this.MP.viewLimits;
        if (xcut && (userBounds.containsKey("X1") || userBounds.containsKey("X2")) || ycut && (userBounds.containsKey("Y1") || userBounds.containsKey("Y2"))) {
            zoom = true;
        }
        String string = cutPlotID = this.getID().isEmpty() ? cutType + "CUT_" + tmpFile.getTag() : cutType + "CUT_" + this.getID();
        if (xcut) {
            double startIndex = tmpFile.getIndex(y, 1, 2);
            outFile = tmpFile.filename + "(" + startIndex + ":" + (startIndex + 1.0) + ")" + qualString;
            String readoutMaskStr = Parser.mask2s("Show,onStatus,onAxis,onTitle,X,dX,1/X,iX,Y,dY,dY/dX,iY,Z,dZ,dZ/dX,iZ,T,dT,1/T,1/dT,dRange,ExtPrec,Index,DMS,Units,View,DateString,Scientific,Azimuth,AlwaysDeltas,dRangeUnits>", this.MP.getReadout() | 4);
            plotCmd = "PLOT/NICE=0/ID=" + cutPlotID + "/BG " + outFile + " CM=" + this.MP.getMode() + " READOUT=" + readoutMaskStr;
        } else if (ycut) {
            double fstart = tmpFile.getIndex(x, 5, 2);
            outFile = "ram:ycut_{type=1000,XStart=" + lay.getYStart() + ",XDelta=" + lay.getYDelta() + ",XUnits=" + this.MP.getYUnits() + ",YUnits=NONE}";
            String thinCmd = "thin " + tmpFile.filename + qualString + " " + outFile + " fstart=" + fstart + " fend=" + (fstart + 1.0);
            Shell.runCommand(this.M, thinCmd);
            plotCmd = "PLOT/NICE=0/ID=" + cutPlotID + "/BG/READOUT=\"+OnAxis\" " + outFile;
        } else {
            this.M.warning("Invalid CUT type of [" + key + "]Cut. Cut must be 'X' or 'Y'");
            return;
        }
        Command cmd = this.M.registry.getCommand(cutPlotID, 1);
        if (plotprim == null && cmd != null && cmd instanceof plottester) {
            plotprim = (plottester)cmd;
        }
        if (plotprim != null) {
            plotprim.closeFile("*");
            plotprim.openFile(outFile);
            if (zoom) {
                plotprim.zoomTo = new Table("{X1=" + boundsMin + ",X2=" + boundsMax + "}");
            }
        } else {
            plotCmd = plotCmd + " Y1=" + this.MP.orz1 + " Y2=" + this.MP.orz2;
            if (zoom) {
                plotCmd = plotCmd + " ZOOMTO={X1=" + boundsMin + ",X2=" + boundsMax + "}";
            }
            Shell.runCommand(this.M, plotCmd);
        }
    }

    private void goToLocationDialog() {
        int TOGGLE_MASK = 328720;
        double xDef = 0.0;
        double xMin = -1.0E37;
        double xMax = 1.0E37;
        String xName = "X";
        double yDef = 0.0;
        double yMin = -1.0E37;
        double yMax = 1.0E37;
        String yName = "Y";
        double rDef = 1.0;
        double rMin = 0.0;
        double rMax = 1.0E37;
        boolean yFirst = false;
        if (this.MP.getView().equals("LatLon") || this.MP.getView().equals("Mercator") || this.MP.getView().equals("Geodetic")) {
            rDef = 15.0;
            xMin = -180.0;
            xMax = 180.0;
            xName = "LON";
            yMin = -90.0;
            yMax = 90.0;
            yName = "LAT";
            yFirst = true;
        }
        GDialog gd = new GDialog(null, "GoToLocation", 200, 75, "Submit,Cancel,Apply", "Apply", 0, this);
        gd.addTo(this.MP);
        GValue xValue = new GValue(null, "XVAL", xDef, xMin, xMax, 1.0, 16, (MessageHandler)this);
        GValue yValue = new GValue(null, "YVAL", yDef, yMin, yMax, 1.0, 16, (MessageHandler)this);
        xValue.setTitle(xName);
        yValue.setTitle(yName);
        if (yFirst) {
            gd.addWidget(yValue);
            gd.addWidget(xValue);
        } else {
            gd.addWidget(xValue);
            gd.addWidget(yValue);
        }
        gd.addWidget(new GValue(null, "Radius", rDef, rMin, rMax, 0.1, 16, (MessageHandler)this));
        gd.addWidget(new GMenu(null, "Flags", "MarkLocation,Zoom", 1, 328720, this));
        gd.resize(1);
    }

    private void goToLocationHandler(Table tbl) {
        double xPos = this.getDVal(tbl, "XVAL");
        double yPos = this.getDVal(tbl, "YVAL");
        double rad = this.getDVal(tbl, "RADIUS");
        String flags = tbl.getS("FLAGS");
        boolean mark = Parser.find(flags, "MarkLocation", -1) >= 0;
        boolean zoom = Parser.find(flags, "Zoom", -1) >= 0;
        Feature feature = (Feature)this.MP.getFeatures().get("GOTO_LOCATION");
        if (mark) {
            if (feature == null) {
                feature = new Feature();
                feature.getLine().setColor("RED");
                feature.setType("HLINE|VLINE");
                this.MP.addFeature("GOTO_LOCATION", feature);
            }
            feature.setEnable(feature.getEnable() | 1);
            feature.setX(xPos);
            feature.setY(yPos);
        } else if (feature != null) {
            this.MP.removeFeature("GOTO_LOCATION");
        }
        if (zoom) {
            if (rad > 0.0) {
                if (this.MP.view == 13) {
                    this.MP.setView(11);
                }
                if (this.MP.zoom(new double[]{xPos - rad, xPos + rad, yPos - rad, yPos + rad}, 0)) {
                    this.MP.refresh();
                }
            } else {
                this.M.warning("PLOT: Got GOTOLOCATION message with invalid radius, RADIUS=" + rad);
            }
        }
    }

    @Override
    public String getMimic() {
        return StringUtil.join(this.mimic.keySet().toArray(), "|");
    }

    @Override
    public void setMimic(String regIDs) {
        this.setMimic(regIDs, false);
    }

    @InternalUseOnly
    private void setMimic(String regIDs, boolean inOpen) {
        if (regIDs == null || regIDs.isEmpty()) {
            this.mimic.clear();
            return;
        }
        if (inOpen || !regIDs.startsWith("+") && !regIDs.startsWith("-")) {
            this.mimic.clear();
        }
        int wait = inOpen ? 0 : -1;
        for (String regID : StringUtil.split(regIDs)) {
            if (regID.startsWith("-")) {
                this.mimic.remove(regID.substring(1));
                continue;
            }
            if (regID.startsWith("+")) {
                regID = regID.substring(1);
            }
            this.mimic.put(regID, this.M.registry.getMessageHandler(regID, wait));
        }
    }

    @Override
    public void setRmif(String regID) {
        this.rmif = this.M.registry.get(regID, rmif.class, 0);
        if (this.compression == 0) {
            this.compression = 3;
        }
    }

    @Override
    @InternalUseOnly
    public void modifyRmifProperty() {
        if (this.rmif == null) {
            return;
        }
        for (int i = 1; i < this.MP.layers.size(); ++i) {
            Layer lay = (Layer)this.MP.layers.get(i);
            Rmif.Channel c = (Rmif.Channel)this.rmif.getChans().get(lay.name);
            if (c == null) continue;
            String modify = "{PROPERTY=" + c.rname + ",COMP=" + (this.compression - 1) + ",PLOTWIDTH=" + this.MP.ix21 + ",TRIM1=" + lay.getx1i() + ",TRIM2=" + lay.getx2i() + "}";
            this.MQ.put("MODIFY", 0, modify, c.r);
        }
    }

    @Override
    public void setRMIFCompression(String rmifCmp) {
        int newCompression = Parser.find(compressionList, rmifCmp, this.compression, 0, 2);
        if (newCompression == this.compression) {
            return;
        }
        this.modifyRmifProperty();
    }

    @Override
    public String getRMIFCompression() {
        return Parser.get(compressionList, this.compression);
    }

    private void setCompression(String cmp) {
        this.M.deprecate("This method will be removed in a future release. Use reg.plot.rmifCompression");
        this.setRMIFCompression(cmp);
    }

    @Override
    public void setPlotType(String stype) {
        int newType = stype.equalsIgnoreCase("NONE") ? 0 : Parser.find("LINE,RASTER,CONTOUR,MESH,POINT,DOT", stype, this.type, 0, 2);
        if (newType == this.type) {
            return;
        }
        this.type = newType;
        StringBuilder list3 = new StringBuilder(32);
        for (int i = 1; i < this.MP.layers.size(); ++i) {
            Layer l = (Layer)this.MP.layers.get(i);
            if (l == null || l.pf == null) continue;
            if (list3.length() != 0) {
                list3.append("|");
            }
            list3.append(l.pf.getName());
        }
        this.closeFile("*");
        this.MP.setView(0);
        this.openFile(list3.toString());
    }

    @Override
    @InternalUseOnly
    public int getPlotTypeID() {
        return this.type;
    }

    @Override
    public String getPlotType() {
        return Parser.get("LINE,RASTER,CONTOUR,MESH,POINT,DOT", this.type);
    }

    @Override
    public void setType(String stype) {
        this.setPlotType(stype);
    }

    @Override
    public String getType() {
        return this.getPlotType();
    }

    @Override
    public Layer getLayer() {
        return this.MP.getBaseLayer();
    }

    @Override
    @InternalUseOnly
    public synchronized String getAutoFeatureName(String prefix) {
        int keyExists;
        KeyVector existingFeatures = this.MP.features;
        int featureNum = existingFeatures.size();
        while ((keyExists = existingFeatures.findKey(prefix + ++featureNum)) >= 0) {
        }
        return prefix + featureNum;
    }

    @Override
    public void setXMult(int mult) {
        this.MP.setMult(mult, 'X');
    }

    @Override
    public void setYMult(int mult) {
        this.MP.setMult(mult, 'Y');
    }

    @Override
    public void setXMult(String mult) {
        this.MP.setMult(mult, 'X');
    }

    @Override
    public void setYMult(String mult) {
        this.MP.setMult(mult, 'Y');
    }

    @Override
    public void showLegend(String corner) {
        this.MP.createLegend();
        this.MP.getLegend().setCorner(corner);
    }

    @Override
    public void hideLegend() {
        this.MP.getLegend().close();
    }

    public void stealNextMouseClick(StealsMouseClick smc) {
        this.stealNextClick = smc;
    }

    @Override
    protected void sendMouseMessage(Message msg, int type) {
        if ((this.controls & type) != 0) {
            this.updateMtagResults();
            this.sendMessage(msg);
        }
        KeyVector layers = this.MP.getLayers();
        for (int i = 0; i < layers.size(); ++i) {
            ((Layer)layers.get(i)).processMouseMessage(msg, type);
        }
    }

    private void setCursorAndRefresh(String cursor, boolean refresh) {
        if (cursor == null) {
            cursor = this.MP.getUserCursor();
        }
        if (cursor == null) {
            cursor = "Default";
        }
        if (this.MP.isCursor(cursor)) {
            if (refresh) {
                this.MP.refresh(2);
            }
        } else {
            this.MP.setCursor(cursor, false);
        }
    }

    private double getDVal(Table tbl, String name) {
        Object val = tbl.get(name);
        if (val instanceof GWidget) {
            val = ((GWidget)val).getValue();
        }
        return Convert.o2d(val);
    }

    @Override
    public String getComplexMode() {
        return Parser.get("Mag,Phase,Real,Imag,RnI,RvI,10Log,20Log,X,Y,Z", this.ocm);
    }

    @Override
    public void setComplexMode(String mode) {
        if ("".equals(mode)) {
            int complexMode = 0;
            Layer lay = this.MP.getBaseLayer();
            if (lay != null) {
                complexMode = this.determineComplexMode(lay);
            }
            this.MP.setMode(complexMode);
            this.ocm = 0;
        } else {
            this.MP.setMode(mode);
            this.ocm = this.MP.mode;
        }
    }

    private int determineComplexMode(Layer layer) {
        PlotFile pf = layer.getFile();
        if (pf.getMode() == 1) {
            return 3;
        }
        if (pf.getXUnits() == 3) {
            return 1;
        }
        return layer.getDefaultComplexMode();
    }

    @Override
    public void setScaleTable(Table scaleTable) {
        this.scaleTable = scaleTable;
    }

    @Override
    public MPlot getMPlot() {
        return this.MP;
    }

    @Override
    public Args getMA() {
        return this.MA;
    }

    @Override
    public Midas getMidasFromPlot() {
        return this.getMidas();
    }

    private class PrescaleSetup {
        private static final String DEFAULT_OUTCOPY = "plot_internal_prescale_temp_out.tmp{AUX=RAM}";
        private boolean externalPrescale;
        private String inFileAfterPrescale;
        private String prescalerKeyword = "";
        private int prescalerTypeCode;
        private Keywords extHeaderKeywords;
        private boolean needWaitToOpenOutInFile;
        private prescaler plotPrescaler = null;

        private PrescaleSetup() {
        }

        private void processScaleTable() {
            if (plottester.this.scaleTable != null) {
                if (plottester.this.scaleTable.containsKey("Y1") || plottester.this.scaleTable.containsKey("YMIN") || plottester.this.scaleTable.containsKey("Z1") || plottester.this.scaleTable.containsKey("ZMIN")) {
                    plottester.this.MP.scale &= 0xFFFFFFFE;
                }
                if (plottester.this.scaleTable.containsKey("Y2") || plottester.this.scaleTable.containsKey("YMAX") || plottester.this.scaleTable.containsKey("Z2") || plottester.this.scaleTable.containsKey("ZMAX")) {
                    plottester.this.MP.scale &= 0xFFFFFFFD;
                }
                this.setLayerMinMaxScale();
            }
        }

        private void setLayerMinMaxScale() {
            if (plottester.this.scaleTable == null || plottester.this.scaleTable.isEmpty()) {
                return;
            }
            plottester.this.needScaleTable = false;
            KeyObject.setKeys(plottester.this.MP, plottester.this.scaleTable, plottester.this.args, 1);
            KeyObject.setKeys(plottester.this.MP.getBaseLayer(), plottester.this.scaleTable, plottester.this.args, 1);
        }

        private void runPrescale() {
            String prescalarOut = plottester.this.MA.getRaw("OUTCOPY");
            if (prescalarOut == null && plottester.this.M.isPiped()) {
                prescalarOut = DEFAULT_OUTCOPY;
            }
            String prescalerCmd = "prescaler IN=" + plottester.this.inFile;
            if (prescalarOut != null) {
                this.inFileAfterPrescale = prescalarOut;
                prescalerCmd = prescalerCmd + " OUT=" + prescalarOut;
                this.needWaitToOpenOutInFile = true;
            } else {
                this.inFileAfterPrescale = plottester.this.inFile;
            }
            int percent = plottester.this.MA.getL("/RANDOM", -10, 100);
            prescalerCmd = prescalerCmd + " /RANDOM=" + percent;
            if (!this.prescalerKeyword.equals("")) {
                prescalerCmd = prescalerCmd + " " + this.prescalerKeyword;
            }
            this.plotPrescaler = (prescaler)Shell.execBackgroundCommand(plottester.this.M, prescalerCmd);
            plottester.this.scaleTable = this.plotPrescaler.table;
            if (plottester.this.M.isPiped() && !this.needWaitToOpenOutInFile) {
                plottester.this.openFile(this.inFileAfterPrescale);
            }
        }

        private boolean tryLoadScaleTable() {
            boolean loaded = false;
            if (this.externalPrescale) {
                plottester.this.scaleTable = plottester.this.MA.getTable("SCALETABLE");
            }
            if (plottester.this.scaleTable != null && !plottester.this.scaleTable.isEmpty()) {
                loaded = true;
            }
            return loaded;
        }

        private boolean open() {
            String prescaleType = plottester.this.MA.getS("/PRESCALE").toLowerCase();
            plottester.this.needScaleTable = true;
            boolean runPrescaleCommand = true;
            boolean preferKeyword = prescaleType.equals("kw") || prescaleType.startsWith("key");
            boolean prescalerExternal = prescaleType.startsWith("ext");
            boolean waitingOnPrescale = false;
            if (prescalerExternal) {
                waitingOnPrescale = true;
                this.externalPrescale = true;
                runPrescaleCommand = false;
                this.inFileAfterPrescale = plottester.this.inFile;
                if (plottester.this.M.isPiped()) {
                    plottester.this.openFile(this.inFileAfterPrescale);
                    this.processScaleTable();
                } else if (plottester.this.scaleTable != null && !plottester.this.scaleTable.isEmpty()) {
                    waitingOnPrescale = false;
                    this.externalPrescale = false;
                } else {
                    waitingOnPrescale = false;
                    plottester.this.needScaleTable = false;
                }
            } else {
                if (!(preferKeyword || prescaleType.startsWith("int") || prescaleType.equals(""))) {
                    plottester.this.M.warning("Invalid prescale option " + prescaleType + ", defaulting the prescaler command to be run internally");
                }
                if (plottester.this.inFile.contains("|")) {
                    waitingOnPrescale = false;
                    runPrescaleCommand = false;
                    plottester.this.M.warning("Internal prescaler does not support multiple input files");
                } else {
                    BaseFile bf = BaseFile.getInstanceFor(plottester.this, (Object)plottester.this.inFile);
                    if (bf instanceof DataFile) {
                        DataFile df = new DataFile(plottester.this.M, (Object)plottester.this.inFile);
                        DataFileHeader dfHeader = new DataFileHeader(df);
                        if (dfHeader.isAbleToParseHeader()) {
                            this.prescalerTypeCode = dfHeader.getType() / 1000;
                            this.extHeaderKeywords = dfHeader.getExtendedHeaderKeywords();
                        }
                        if (this.prescalerTypeCode != 1 && this.prescalerTypeCode != 2) {
                            waitingOnPrescale = false;
                            runPrescaleCommand = false;
                            plottester.this.needScaleTable = false;
                            plottester.this.M.warning("Interal prescaler only works with type 1000 and 2000 files");
                        } else {
                            if (!preferKeyword && plottester.this.scaleTable != null && !plottester.this.scaleTable.isEmpty()) {
                                plottester.this.M.info("Running internal prescaler even though SCALETABLE was provided");
                            }
                            plottester.this.scaleTable = new Table();
                            if (preferKeyword) {
                                if (this.scaleTableFromKeywordFromFile()) {
                                    runPrescaleCommand = false;
                                } else {
                                    this.needWaitToOpenOutInFile = true;
                                }
                            }
                        }
                        df.close();
                    } else {
                        waitingOnPrescale = false;
                        runPrescaleCommand = false;
                        plottester.this.needScaleTable = false;
                        plottester.this.M.warning("Interal prescaler only works with type 1000/2000 file defined");
                    }
                    if (runPrescaleCommand) {
                        waitingOnPrescale = true;
                        this.runPrescale();
                    }
                }
            }
            return waitingOnPrescale;
        }

        private boolean processPrescalar() {
            if (this.tryLoadScaleTable()) {
                if (this.needWaitToOpenOutInFile || !plottester.this.M.isPiped()) {
                    plottester.this.openFile(this.inFileAfterPrescale);
                }
                this.processScaleTable();
                return true;
            }
            return false;
        }

        private boolean scaleTableFromKeywordFromFile() {
            String keywordSwitchValue = plottester.this.MA.getS("/SCALEKW");
            if (keywordSwitchValue.equals("")) {
                keywordSwitchValue = "VOLATILE_KW_PLOT_SCALE";
            }
            this.prescalerKeyword = "/SCALEKW=" + keywordSwitchValue;
            Object tempScale = this.extHeaderKeywords.get(keywordSwitchValue);
            if (tempScale != null) {
                plottester.this.scaleTable = new Table(tempScale.toString());
                return true;
            }
            return false;
        }
    }

    public static interface StealsMouseClick {
        public void mouseClicked(Message var1);
    }
}

