/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.test;

import java.io.File;
import java.util.ArrayList;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Shell;
import nxm.sys.prim.thin;

@ProvisionalUseOnly(value="This is primarily for testing and educational purposes and has only been minimally tested")
public class commutate
extends Primitive {
    DataFile hi;
    DataFile ho;
    Data dbi;
    Data dbo;
    int elements;
    int ndata;
    int frameSize;
    double isize;
    double dbpe;
    String format;
    FileName fileName;
    boolean commutate;
    String tempPrefix = "\"commutate_\"";
    String suffix = ".tmp";
    String quals = "{AUX=RAM}";
    double xs;
    double xd;
    ArrayList<thin> thinCmds = new ArrayList();
    DataFile thinnedFile;
    Data data;
    byte[] zeroBuf;
    boolean debug;
    double lastChecked;
    boolean thinComplete = false;
    boolean saveTemp;
    private static int TIME_SINCE_WRITE = 100;

    @Override
    public int open() {
        this.hi = this.MA.getDataFile("IN", "1000", "S#,C#", 0);
        this.hi.open();
        this.xs = this.hi.getXStart();
        this.xd = this.hi.getXDelta();
        this.format = this.hi.getFormat();
        this.isize = this.hi.getSize();
        this.dbpe = this.hi.dbpe;
        this.fileName = this.hi.getFileName();
        this.hi.close();
        this.elements = this.MA.getL("ELEM", this.MA.getL("ELEMENTS", 1));
        this.frameSize = (int)Math.ceil(this.isize / (double)this.elements);
        this.ho = this.MA.getDataFile("OUT", "2000", this.format, 0);
        this.ho.setSubSize(this.frameSize);
        this.ho.setXStart(this.xs);
        this.ho.setXDelta(this.xd * (double)this.frameSize);
        this.ho.setInternals();
        this.ho.open(66);
        this.tempPrefix = this.MA.getS("TEMPPREFIX", this.tempPrefix);
        this.saveTemp = this.MA.isPresent("/SAVETEMP");
        if (this.saveTemp) {
            this.quals = "";
        }
        this.debug = this.MA.isPresent("/DEBUG");
        int max0needed = (int)((double)this.frameSize * this.dbpe);
        this.zeroBuf = new byte[max0needed];
        if (this.debug) {
            System.out.println("elements:" + this.elements);
            System.out.println("frame size:" + this.frameSize);
            System.out.println("isize:" + this.isize);
            System.out.println("dbpe:" + this.dbpe);
            System.out.println("fileName:" + this.fileName);
            System.out.println("tempPrefix:" + this.tempPrefix + " quals:" + this.quals);
        }
        this.data = new Data(this.format, this.frameSize);
        this.startThinCommands();
        return 0;
    }

    @Override
    public int process() {
        if (!this.thinComplete) {
            this.thinComplete = this.filesNotModified();
            if (this.debug) {
                System.out.println("thinComplete:" + this.thinComplete);
            }
            if (!this.thinComplete) {
                return -1;
            }
        }
        for (int i = 0; i < this.elements; ++i) {
            this.writeDataFromThinnedFile(this.tempPrefix + i + this.suffix);
        }
        return 9;
    }

    @Override
    public int close() {
        this.ho.close();
        return 0;
    }

    private void startThinCommands() {
        for (int i = 0; i < this.elements; ++i) {
            String thinCmd = "thin IN=" + this.fileName + " OUT=\"" + this.tempPrefix + i + this.suffix + this.quals + "\" START=" + i + " INC=" + this.elements;
            if (this.debug) {
                System.out.println("thinCmd:" + thinCmd);
            }
            this.thinCmds.add((thin)Shell.execBackgroundCommand(this.M, thinCmd));
            this.lastChecked = System.currentTimeMillis();
        }
    }

    private boolean filesNotModified() {
        for (int i = 0; i < this.elements; ++i) {
            File processCheck = new File(this.tempPrefix + i + this.suffix);
            boolean exists = processCheck.exists();
            double thisModified = processCheck.lastModified();
            if (this.debug) {
                System.out.println("checking " + this.tempPrefix + i + this.suffix + " modified:" + thisModified + " lastChecked:" + this.lastChecked + " exists:" + exists);
            }
            if (!(thisModified + (double)TIME_SINCE_WRITE > this.lastChecked) && exists) continue;
            if (this.debug) {
                System.out.println("greater");
            }
            this.lastChecked = System.currentTimeMillis();
            return false;
        }
        return true;
    }

    private boolean readyForMerge() {
        boolean finished = true;
        for (int i = 0; i < this.elements; ++i) {
            finished &= this.thinCmds.get(i).finishing();
            if (this.debug) {
                System.out.println("checking " + this.tempPrefix + i + this.suffix);
            }
            if (!finished) break;
        }
        return finished;
    }

    private void writeDataFromThinnedFile(String fileName) {
        this.thinnedFile = new DataFile(this.M, (Object)fileName);
        this.thinnedFile.open();
        int read = this.thinnedFile.read(this.data, this.frameSize);
        if (read > 0) {
            this.ho.write(this.data.buf, 0, (int)((double)read * this.dbpe));
            if (read < this.frameSize) {
                this.ho.write(this.zeroBuf, 0, (int)((double)(this.frameSize - read) * this.dbpe));
            }
        }
        this.thinnedFile.close();
        if (this.debug) {
            System.out.println("writing data from file:" + fileName + " read:" + read);
        }
    }
}

