/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JPanel;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Command;
import nxm.sys.lib.Data;
import nxm.sys.lib.Midas;
import nxm.sys.lib.NTerminal;
import nxm.sys.lib.Native;
import nxm.sys.lib.NeXtMidas;
import nxm.sys.lib.OptionTree;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.libg.MidasDisplay;
import nxm.sys.test.junit.NMTestCase;

public class TestNeXtMidas {
    private String argAuxWriteHome = "-aux.write=HOME";
    private String argAuxReadHomeDat = "-aux.read=HOME|DAT";
    private String argPathSysUcl = "-path=DSP|SYS";
    private String cmdPlotSunset = "-cmd=plot/all Sunset.jpg";
    private String cmdMakeUCL = "make code ucl";
    private String cmdRunBeanDemo = "beandemo";
    private String cmdSetHomeDSP = "home test DSP";
    private String cmdRunDSPTest = "%test_convolve";
    private String cmdPlotWorldBG = "plot/bg/id=myplotid world";
    private String cmdList2Apenny = "list2/bg/wpos=(25,600,600,200) apenny ";
    private String cmdList2UCCSV = "list2/bg/wpos=(25,600,600,200) CSV_UPPERCASE.CSV{HEADERROWS=1}";
    private String cmdPlotApenny = "plot apenny";
    private String cmdSD360 = "sd360 inf";
    private Table argsTable = new Table("{cmd=home test dat,cmd=home test sys,cmd=\"plot sinewave\"}");
    private String cmdHomeTestSys = "-cmd=home test sys";
    private String scriptCmd = "-script=nxm.sys.test.test_plot.mm";
    private String cmdPlotSinewave = "-cmd=plot/bg sinewave";
    private String cmdSetAllSwing = "env set graphics swing|swingwidgets|swingpopups";
    private String argNewAux = "-aux.test_nxm=/tmp/bogus";
    private String cmdCheckAux = "res aux.test_nxm";
    final JFrame frame = new JFrame("NeXtMidas");
    final JPanel panel = new JPanel();
    private NeXtMidas nxm;
    private NeXtMidas nxmJava;

    public TestNeXtMidas(String testName) {
        if (testName.equalsIgnoreCase("addOptToPathFromClasspath")) {
            this.createNXM();
            this.testAddOptToPathfromClasspath();
        } else if (testName.equalsIgnoreCase("addOptToPathUsingSPI")) {
            this.createNXM();
            this.doOptToPathUsingSPI();
        } else if (testName.equalsIgnoreCase("loadNativeCodeFromJar")) {
            this.createNXM();
            this.testLoadingNativeCode();
        } else if (testName.equalsIgnoreCase("JavaApp")) {
            this.testJavaApp();
        } else {
            this.testNoDupsInHandlersTable();
            this.testOneShot();
            this.createNXM();
            this.testInstantiate();
            this.testScript();
            this.testPanel();
        }
    }

    public TestNeXtMidas() {
        this("");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            new TestNeXtMidas("");
        } else {
            new TestNeXtMidas(args[0]);
        }
    }

    @InternalUseOnly
    public void doOptToPathUsingSPI() {
        String pathName = this.nxm.addOptionTreePathUsingSPI();
        Table optTbl = OptionTree.getAllOptions(Shell.getMidasContext());
        System.out.println("Option Tree Table: " + optTbl);
        System.out.println("Option path: " + pathName);
    }

    public void testAddOptToPathfromClasspath() {
        Object[][] optExpectedPath;
        for (Object[] optPathSet : optExpectedPath = new Object[][]{{new String[]{"MYTESTOPT1", "MYTESTOPT1,DSP,SYS"}, NeXtMidas.OptionFlags.ADD}, {new String[]{"DSP,MYTESTOPT2", "MYTESTOPT1,DSP,MYTESTOPT2,SYS"}, NeXtMidas.OptionFlags.ADD_PLUS}, {new String[]{"MYTESTOPT2", "MYTESTOPT1,DSP,MYTESTOPT2,SYS"}, NeXtMidas.OptionFlags.PUT}}) {
            String[] optionSet = (String[])optPathSet[0];
            NeXtMidas.OptionFlags optflag = (NeXtMidas.OptionFlags)((Object)optPathSet[1]);
            this.nxm.addOptionTreeToPathClasspath(optionSet[0], optflag);
            this.nxm.runCommand("assert/text=\"Add Option " + optionSet[0] + " with option flag: " + (Object)((Object)optflag) + " \" \"" + optionSet[1] + "\" EQS \"" + this.nxm.getPath() + "\" ");
        }
        Table optTbl = OptionTree.getAllOptions(Shell.getMidasContext());
        this.nxm.runCommand("assert/text=\"Option added DSP \" " + optTbl.containsKey("DSP") + " ISTRUE");
        this.nxm.runCommand("assert/text=\"Option added SYS \" " + optTbl.containsKey("SYS") + " ISTRUE");
    }

    private void testLoadingNativeCode() {
        Midas M = Shell.getSharedMidasContext();
        if (Native.useIO) {
            try {
                new NTerminal(M);
            }
            catch (Exception e) {
                M.printStackTrace("Error loading native terminal, may not get accurate reulsts from test.", e);
            }
        }
        String format = "CF";
        int size = 6;
        float[] array = new float[]{42.0f, 789.0f, 234.0f, 69.0f};
        Data dat1 = new Data(format, size);
        Data fiveData = new Data(5.0f);
        dat1.setScalarAt(4, array);
        dat1.setScalarAt(12, fiveData);
        try {
            dat1.castF(true);
        }
        catch (ClassCastException cce) {
            NMTestCase.fail((String)("\n  Native code did not load properly from jar resulting in the following Exception:\n   " + cce + "/n"));
        }
    }

    private void testOneShot() {
        String[] args = new String[]{this.argAuxWriteHome, this.argAuxReadHomeDat, this.argPathSysUcl, this.cmdPlotSunset};
        NeXtMidas.main(args);
    }

    private void testInstantiate() {
        if (this.nxm == null) {
            return;
        }
        this.nxm.runCommand(this.cmdCheckAux);
        this.nxm.runCommand(this.cmdSetHomeDSP);
        this.nxm.runCommand(this.cmdRunDSPTest);
        this.nxm.runCommand("home test sys");
    }

    private void createNXM() {
        String[] args = new String[]{this.argAuxWriteHome, this.argAuxReadHomeDat, this.argPathSysUcl, this.argNewAux};
        this.nxm = new NeXtMidas(args);
    }

    private void closeNXM() {
        this.nxm = null;
    }

    private void testPanel() {
        if (this.nxm == null) {
            return;
        }
        this.panel.setLayout(new BorderLayout());
        this.frame.setContentPane(this.panel);
        this.frame.setSize(900, 900);
        MidasDisplay md1 = new MidasDisplay();
        Dimension dim = new Dimension(900, 300);
        md1.setPreferredSize(dim);
        this.panel.add((Component)md1, "North");
        MidasDisplay md2 = new MidasDisplay();
        md2.setPreferredSize(dim);
        this.panel.add((Component)md2, "South");
        MidasDisplay md3 = new MidasDisplay();
        md3.setPreferredSize(dim);
        this.panel.add((Component)md3, "Center");
        this.frame.setDefaultCloseOperation(3);
        this.frame.setVisible(true);
        Command cmd1Plot = this.nxm.runCommand(this.cmdPlotWorldBG, md1);
        Command cmd2List2 = this.nxm.runCommand(this.cmdList2Apenny, md2);
        this.nxm.runCommand("assert/text=\"runCommand returns executed Command reference: Plot\" " + (cmd1Plot != null) + " ISTRUE");
        this.nxm.runCommand("assert/text=\"runCommand returns executed Command reference: List2\" " + (cmd2List2 != null) + " ISTRUE");
        this.nxm.runCommand("assert/text=\"PLOT cmd's ID\" " + cmd1Plot.getID() + " EQS MYPLOTID");
        this.nxm.runCommand("assert/text=\"LIST2 cmd's ID\" " + cmd2List2.getID() + " EQS LIST2");
        this.nxm.runCommand(this.cmdSD360, md3);
    }

    private void testJavaApp() {
        Midas.setForceNmJavaMode("AUTO");
        this.nxmJava = new NeXtMidas();
        this.nxmJava.runCommand(this.cmdList2UCCSV);
        this.testMidasIsJava();
    }

    private void testMidasIsJava() {
        boolean globalIsJava = NeXtMidas.getGlobalInstance().getMidas().isJavaBehavior();
        boolean shellIsJava = Shell.getMidasContext().isJavaBehavior();
        this.nxmJava.runCommand("assert/text=\"Global Midas recognizes this is a Java application\" " + globalIsJava + " ISTRUE");
        this.nxmJava.runCommand("assert/text=\"Shell Midas recognizes this is a Java application\" " + shellIsJava + " ISTRUE");
    }

    private void testScript() {
        if (this.nxm == null) {
            return;
        }
        this.nxm.parseOptions(this.argsTable);
        this.nxm.parseOption(this.scriptCmd);
        this.nxm.runShell();
    }

    private void testNoDupsInHandlersTable() {
        String[] args = new String[]{"-script=nxm.sys.test.test_dr814551-1.mm"};
        NeXtMidas.main(args);
    }
}

