/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import nxm.sys.inc.MessageHandler;
import nxm.sys.intr.Results;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.OS;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class system
extends Primitive {
    private DataFile df;
    private Data dfb;
    private int stats;
    private String func;
    private String label;
    private Table tab;
    private double pause;
    private double timeLast;
    private Parser auxes;
    private boolean list = true;
    private boolean all;
    private boolean top;
    private boolean monThreads;
    private boolean monMemory;
    public static String statsList = "Load,Mem,Swap,Page,Cpu0,Cpu1,Cpu2,Cpu3,Disk";
    public static int LOAD = 1;
    public static int MEM = 2;
    public static int SWAP = 4;
    public static int PAGE = 8;
    public static int CPU0 = 16;
    public static int CPU1 = 32;
    public static int CPU2 = 64;
    public static int CPU3 = 128;
    public static int DISK = 256;
    private MemoryMXBean memoryMXBean;
    private ThreadMXBean threadMXBean;

    @Override
    public int open() {
        this.func = this.MA.getU("FUNC");
        this.pause = this.MA.getD("/PAUSE", 1.0);
        if (this.func.equals("THREADS")) {
            this.showThreads();
            return 9;
        }
        if (this.func.startsWith("MONITOR/")) {
            if (this.func.equals("MONITOR/MEMORY")) {
                this.monMemory = true;
            } else if (this.func.equals("MONITOR/THREADS")) {
                this.monThreads = true;
            } else {
                this.M.error("Illegal MONITOR function: " + this.func);
            }
            this.df = this.MA.getDataFile("FILE", "3000", "NH", 0);
            this.df.setSize(1000.0);
            this.df.setFormat("SX");
            this.df.setXUnits(1);
            this.df.setXDelta(this.pause);
            if (this.monMemory) {
                this.df.setYUnits(30);
                this.df.addSubRec("USED", "SX");
                this.df.addSubRec("COMM", "SX");
                this.df.addSubRec("HEAP", "SX");
                this.df.addSubRec("NONH", "SX");
            } else {
                this.df.setYUnits(32);
                this.df.addSubRec("CURR", "SX");
                this.df.addSubRec("PEAK", "SX");
                this.df.addSubRec("TOTL", "SX");
            }
            this.df.open(2);
            if (this.df.isOpen) {
                this.dfb = this.df.getDataBuffer(1);
            }
            if (this.monMemory) {
                this.memoryMXBean = ManagementFactory.getMemoryMXBean();
            } else if (this.monThreads) {
                this.threadMXBean = ManagementFactory.getThreadMXBean();
            }
        } else if (this.func.equals("TOP")) {
            this.top = true;
        } else {
            this.stats = this.MA.getOptionMask("FUNC", statsList, 0);
            this.label = this.MA.getU("TABLE");
            this.tab = new Table();
            this.df = this.MA.getDataFile("FILE", "3000", "NH", 0);
            if ((this.stats & DISK) != 0) {
                Table taux = this.M.results.getTable("AUX");
                String raux = taux.getString("READ");
                raux = this.MA.getS("/AUXLIST", raux);
                this.auxes = new Parser(raux, '|');
            }
            for (int i = 0; i < 9; ++i) {
                String name;
                int mask = 1 << i;
                if ((mask & this.stats) == 0) continue;
                if (mask == DISK) {
                    this.auxes.reset();
                    while (this.auxes.more()) {
                        name = this.auxes.next();
                        this.df.addSubRec(name, "SL");
                    }
                    continue;
                }
                name = Parser.get(statsList, i + 1).toUpperCase();
                this.df.addSubRec(name, "SL");
            }
            this.df.open(66);
            if (this.df.isOpen) {
                this.dfb = this.df.getDataBuffer(1);
            }
            this.list = this.label.length() == 0 && !this.df.isOpen && this.getMessageHandler() == null;
            this.all = this.MA.getState("/ALL", true);
            this.timeLast = 0.0;
            this.setPollTime(0.1);
        }
        return 0;
    }

    @Override
    public int process() {
        double time = Time.current();
        if (time - this.timeLast < this.pause) {
            return -1;
        }
        this.timeLast = time;
        if (this.monMemory) {
            this.writeMemoryUsageInfo();
        } else if (this.monThreads) {
            this.writeThreadInfo();
        } else {
            MessageHandler msgid;
            if (this.top) {
                byte[] buf = new byte[8192];
                int bytes = OS.getStats(0, buf);
                if (bytes > 0) {
                    this.M.type(new String(buf, 0, bytes));
                }
                return 9;
            }
            int i = 0;
            if ((this.stats & DISK) != 0) {
                this.auxes.reset();
                while (this.auxes.more()) {
                    String aux = this.auxes.next();
                    String path = this.M.io.getAuxPath(aux);
                    Table stats = null;
                    try {
                        IOResource res = IOResource.getInstance(this.M, 0, path, 0, null);
                        stats = res.getStatFS();
                    }
                    catch (Exception ex) {
                        this.M.warning("Unable to get disk statistics for AUX=" + aux + " at path=" + path + " cause=" + ex.getMessage());
                    }
                    if (this.df.isOpen && stats != null) {
                        this.dfb.packL(i * 4, stats.getL("USED"));
                    }
                    this.tab.put("DISK_" + aux, (Object)stats);
                    ++i;
                }
            }
            if (this.df.isOpen) {
                this.df.write(this.dfb);
            }
            if (this.label.length() > 0) {
                this.MR.put(this.label, (Object)this.tab);
            }
            if (this.list && this.all) {
                Results.listMultiple(this.M, this.tab, "*", 0, true);
            }
            if (this.list && !this.all) {
                Table.Iterator ti = this.tab.iterator();
                while (ti.getNext()) {
                    this.M.println("Key=" + ti.key + " Value=" + ti.value);
                }
            }
            if ((msgid = this.getMessageHandler()) != null) {
                this.MQ.put("SYSTEM", 0, this.tab, msgid, this);
            }
        }
        return this.M.pipeMode == 0 ? 9 : 0;
    }

    @Override
    public int close() {
        if (this.df != null) {
            this.df.close();
            this.df = null;
        }
        return 0;
    }

    public Table getDiskStats() {
        return this.tab;
    }

    public Table getCPUStats() {
        return this.tab;
    }

    public Table getMemStats() {
        return null;
    }

    public String getTop() {
        return null;
    }

    private void showThreads() {
        ThreadGroup group2 = Thread.currentThread().getThreadGroup();
        while (group2.getParent() != null) {
            group2 = group2.getParent();
        }
        this.M.type("ALL THREADS");
        this.showThreads(group2, 0);
    }

    private void showThreads(ThreadGroup group2, int depth) {
        int j;
        StringBuilder str;
        int i;
        int EXTRA = 16;
        String TAB = "    ";
        ThreadGroup[] groups = new ThreadGroup[group2.activeGroupCount() + 16];
        Thread[] threads = new Thread[group2.activeCount() + 16];
        int numGroups = group2.enumerate(groups, false);
        int numThreads = group2.enumerate(threads, false);
        for (i = 0; i < numGroups; ++i) {
            str = new StringBuilder();
            for (j = 0; j < depth; ++j) {
                str.append("    ");
                str.append('|');
            }
            str.append("    ");
            str.append("+-- (Group: ");
            str.append(groups[i].getName());
            str.append(')');
            this.M.type(str);
            this.showThreads(groups[i], depth + 1);
        }
        for (i = 0; i < numThreads; ++i) {
            str = new StringBuilder();
            for (j = 0; j < depth; ++j) {
                str.append("    ");
                str.append('|');
            }
            str.append("    ");
            str.append("+-- ");
            str.append(threads[i].getName());
            this.M.type(str);
        }
    }

    private long[] getMemoryUsageValues(MemoryType type) {
        MemoryUsage memoryUsage;
        long[] usage = new long[4];
        switch (type) {
            case NON_HEAP_MEMORY_USAGE: {
                memoryUsage = this.memoryMXBean.getNonHeapMemoryUsage();
                break;
            }
            default: {
                memoryUsage = this.memoryMXBean.getHeapMemoryUsage();
            }
        }
        usage[0] = memoryUsage.getInit();
        usage[1] = memoryUsage.getUsed();
        usage[2] = memoryUsage.getCommitted();
        usage[3] = memoryUsage.getMax();
        return usage;
    }

    private void writeMemoryUsageInfo() {
        long[] heap = this.getMemoryUsageValues(MemoryType.HEAP_MEMORY_USAGE);
        long[] nonHeap = this.getMemoryUsageValues(MemoryType.NON_HEAP_MEMORY_USAGE);
        this.dfb.packX(0, heap[1] + nonHeap[1]);
        this.dfb.packX(8, heap[2] + nonHeap[2]);
        this.dfb.packX(16, heap[1]);
        this.dfb.packX(24, nonHeap[2]);
        this.df.write(this.dfb);
    }

    private void writeThreadInfo() {
        this.dfb.packX(0, this.threadMXBean.getThreadCount());
        this.dfb.packX(8, this.threadMXBean.getPeakThreadCount());
        this.dfb.packX(16, this.threadMXBean.getTotalStartedThreadCount());
        this.df.write(this.dfb);
    }

    private static enum MemoryType {
        HEAP_MEMORY_USAGE,
        NON_HEAP_MEMORY_USAGE;

    }
}

