/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.util.List;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Message;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class sourcefile
extends Primitive {
    public double offout;
    public double off;
    public double[] stop;
    public int pause = 0;
    public int replay;
    public double startTime;
    public DataFile hin;
    public DataFile hout;
    private Data dbi;
    private Data dbo;
    private double dur;
    private double slip;
    private double[] start;
    private int red;
    private int tl;
    private float[] fbuf;
    private byte[] inbuf;
    private boolean selfpace = true;
    private boolean reset = false;
    private double time;
    private double tdelay;
    private double tlast = 0.0;
    private int idx;
    private int pass = 0;
    private static final String replayList = "ONESHOT,WAITTOP,ONETOP,CONTINUOUS";
    private static final int R_ONESHOT = 1;
    private static final int R_WAITTOP = 2;
    private static final int R_ONETOP = 3;
    private static final int R_CONT = 4;

    @Override
    public int open() {
        this.hin = this.MA.getDataFile("IN");
        this.hin.open();
        this.selfpace = this.hin.isFile();
        this.hout = this.MA.getDataFile("OUT", this.hin, 0);
        this.hout.open();
        this.idx = 0;
        this.stop = new double[1];
        this.start = this.stop;
        this.start[this.idx] = this.off = this.MA.getD("START", 0.0);
        this.stop[this.idx] = this.MA.getD("STOP", this.hin.size);
        this.dur = this.MA.getD("DURATION", 0.0);
        this.red = this.MA.getL("REDUCTION", 1);
        this.slip = this.MA.getD("SLIP", 0.0);
        this.tl = this.MA.getL("/TL", 4096);
        this.tdelay = (double)this.tl * this.hin.getXDelta();
        this.inbuf = new byte[this.tl];
        this.dbi = this.hin.getDataBuffer(this.tl);
        this.dbo = this.hout.getDataBuffer(this.tl);
        this.startTime = this.hin.getXStart();
        this.replay = this.MA.getChoice("/REPLAY", replayList, 1);
        if (this.replay == 2 || this.replay == 3 && this.pass == 1) {
            this.setPause(1);
        }
        return 0;
    }

    public void openFile(String name) {
        if (this.verbose) {
            System.out.println("Sourcefile: Opening file " + name);
        }
        this.hin = new DataFile();
        this.hin.init(this.M, (Object)name);
        this.hin.open();
        this.selfpace = this.hin.isFile();
        this.idx = 0;
        this.stop = new double[1];
        this.start = this.stop;
        this.off = 0.0;
        this.start[this.idx] = 0.0;
        this.stop[this.idx] = this.hin.size;
        this.tdelay = (double)this.tl * this.hin.getXDelta();
        this.dbi = this.hin.getDataBuffer(this.tl);
        this.dbo = this.hout.getDataBuffer(this.tl);
        this.startTime = this.hin.getXStart();
    }

    @Override
    public int process() {
        if (this.pause == 1) {
            return -1;
        }
        int n = this.hin.read(this.dbi, this.off, this.tl);
        if (n == 0) {
            ++this.pass;
            if (this.replay == 1) {
                return 9;
            }
            return 7;
        }
        if (n < 0) {
            ++this.pass;
            if (this.replay == 1) {
                return 9;
            }
            return 7;
        }
        this.off += (double)n;
        if (this.reset || this.off > this.stop[this.idx]) {
            this.idx = this.idx < this.start.length - 1 ? ++this.idx : 0;
            if (this.reset) {
                this.idx = 0;
            }
            this.off = this.start[this.idx];
            this.reset = false;
        }
        if (this.selfpace) {
            this.time = Time.current();
            while (this.time - this.tlast < this.tdelay - 0.001) {
                Time.sleep(0.001);
                this.time = Time.current();
            }
            this.tlast = this.time;
        }
        this.dbo = this.dbi;
        int j = this.hout.write(this.dbo, n);
        this.offout = this.off * this.hin.getXDelta() + this.startTime;
        return -1;
    }

    @Override
    public int processMessage(Message msg) {
        if (msg.name.equals("OPENFILE")) {
            this.openFile((String)msg.data);
        } else if (msg.name.equals("CLOSEFILE")) {
            this.closeFile((String)msg.data);
        }
        return 0;
    }

    @Override
    public int close() {
        this.hin.close();
        this.hout.update();
        this.hout.close();
        return 0;
    }

    public void setPause(int val) {
        this.pause = val;
    }

    public void setStart(double val) {
        this.start = new double[1];
        this.idx = 0;
        this.off = (val - this.startTime) / this.hin.getXDelta();
        this.offout = this.off * this.hin.getXDelta() + this.startTime;
        this.start[this.idx] = this.off;
    }

    public void setStop(double val) {
        this.stop = new double[1];
        this.idx = 0;
        this.stop[this.idx] = val == -1.0 ? this.hin.size : (val - this.startTime) / this.hin.getXDelta();
    }

    public void setStartStops(Table t) {
        int size = t.size();
        if (size > 0) {
            this.start = new double[size];
            this.stop = new double[size];
            Table.Iterator ti = t.iterator();
            while (ti.getNext()) {
                Table tmpt = t.getTable(ti.key);
                short indx = tmpt.getI("INDX");
                if (indx < size) {
                    this.start[indx] = (tmpt.getD("START") - this.startTime) / this.hin.getXDelta();
                    this.stop[indx] = (tmpt.getD("STOP") - this.startTime) / this.hin.getXDelta();
                    continue;
                }
                this.M.warning("Error in Sourcefile - index out of bounds");
            }
            this.reset = true;
        }
    }

    public void setStarts(List<?> v) {
        if (this.verbose) {
            System.out.println("Sourcefile: TBD - STARTS: " + v.toString());
        }
    }

    public void setStops(List<?> v) {
        if (this.verbose) {
            System.out.println("Sourcefile: TBD - STOPS: " + v.toString());
        }
    }

    public void closeFile(String name) {
        this.hin.close();
    }

    @Override
    public int restart() {
        super.restart();
        return 0;
    }

    public int getReplay() {
        return this.replay;
    }

    public void setReplay(int replay) {
        this.replay = replay;
    }
}

