/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.RecordComparator;
import nxm.sys.lib.Table;

public class sort
extends Primitive {
    private DataFile inputFile;
    private DataFile outputFile;
    private Vector<Table> records;
    private Comparator<Object> sorter;
    private int recordLength;
    private int readIndex;
    private int writeIndex;
    private int recordCount;
    private int stage;
    private static final int STAGE_READ = 1;
    private static final int STAGE_SORT = 2;
    private static final int STAGE_WRITE = 3;

    @Override
    public int open() {
        this.inputFile = this.MA.getDataFile("IN");
        this.inputFile.open();
        this.outputFile = this.MA.getDataFile("OUT", this.inputFile, 2);
        this.outputFile.open();
        this.recordLength = this.inputFile.getRecLength();
        this.recordCount = (int)this.inputFile.getSize();
        this.stage = 1;
        this.records = new Vector();
        this.readIndex = 0;
        this.writeIndex = 0;
        String[] keys = this.MA.getS("KEYS").split("[|]");
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = keys[i].trim().toUpperCase();
        }
        String key = keys[0];
        if (key.startsWith("-")) {
            key = key.substring(1);
        }
        if (key.startsWith("+")) {
            key = key.substring(1);
        }
        String recName = null;
        int recnum = -1;
        for (int i = 0; i < this.inputFile.getSubSize(); ++i) {
            recName = this.inputFile.getRecName(i);
            if (!recName.equalsIgnoreCase(key)) continue;
            recnum = i;
            break;
        }
        if (recnum > -1) {
            this.sorter = new RecordComparator(keys);
        } else {
            this.M.error("SORT: Could not find record " + keys[0] + " in file " + this.inputFile.getURL());
        }
        return 0;
    }

    @Override
    public int process() {
        int status = 0;
        switch (this.stage) {
            case 1: {
                if (this.readIndex < this.recordCount) {
                    this.records.add(this.inputFile.getDataTable(this.readIndex));
                    ++this.readIndex;
                    break;
                }
                this.stage = 2;
                break;
            }
            case 2: {
                Collections.sort(this.records, this.sorter);
                this.stage = 3;
                break;
            }
            case 3: {
                if (this.writeIndex < this.records.size()) {
                    this.outputFile.setData((double)this.writeIndex, this.records.get(this.writeIndex));
                    ++this.writeIndex;
                    break;
                }
                status = 9;
                break;
            }
            default: {
                throw new RuntimeException("sort.process(): invalid stage (" + this.stage + ")");
            }
        }
        return status;
    }

    @Override
    public int close() {
        this.inputFile.close();
        this.outputFile.close();
        return 0;
    }
}

