/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Random;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Time;

public class sinkrtp
extends Primitive {
    private String rthost;
    private int port;
    private int rtport;
    private int prange;
    private byte[] rtbuf;
    private short[] outbuf;
    private DataFile hin;
    private DataFile hout;
    private Data outdata;
    private DatagramPacket rtpack;
    private DatagramSocket dsock;
    private int reopen = -1;
    private int reopen_tries = 0;
    private int seq = 43981;
    private int ts = 1193046;
    private int src;
    private int mode;
    private int chan = 3;
    private int tl;
    private int twotl;
    private double time;
    private double tdelay;
    private double tlast = 0.0;
    private static String modeList = "LEFT,RIGHT,BOTH,NONE,RESYNC";
    private boolean sockisok = false;
    private boolean selfpace = false;
    private double scale = 1.0;
    private int type;
    private short[] decodeTable;
    private byte[] inbuf;
    private Data inint;
    private short[] inshort;
    private static final String typeList = "LIN8,MULAW";
    private static final int T_LIN8 = 1;
    private static final int T_MULAW = 2;
    private static final int RTP_PT_LIN8 = 11;
    private static final int RTP_PT_LIN16 = 13;
    private static final int RTP_PT_PCMU = 0;
    private static final int RTP_VERSION = 2;
    private static final int RTP_BYE = 203;
    private static final int RTP_CC = 1;
    private static final int VER = 0;
    private static final int SEQ = 2;
    private static final int TS = 4;
    private static final int SSRC = 8;
    private static final int CHAN = 12;
    private static final int DATA = 16;
    private static final int PLEN = 2048;

    @Override
    public int open() {
        try {
            this.rthost = this.MA.getS("HOST").toLowerCase();
            this.rtport = this.MA.getL("PORT");
            this.tl = this.MA.getL("/TL", 2048);
            this.twotl = this.tl * 2;
            this.port = this.MA.getL("/PORT", 7101);
            this.prange = this.MA.getL("/PRANGE", 8);
            String tmpStr = null;
            if (this.MA.isPresent("/REOPEN")) {
                tmpStr = this.MA.getS("/REOPEN");
                this.reopen = tmpStr.equals("") ? 5 : this.MA.getL("/REOPEN", this.reopen);
            }
            Random rng = new Random();
            this.src = Math.abs(rng.nextInt());
            this.seq = this.src & 0xFFFF;
            if (this.dsock == null) {
                this.type = this.MA.getChoice("/TYPE", typeList, 1);
                this.mode = this.MA.getChoice("/MODE", modeList, 3);
            }
            InetAddress rtaddr = null;
            while (this.dsock == null) {
                try {
                    this.dsock = new DatagramSocket(this.port);
                    this.M.info("Connected to RTP Socket port");
                    rtaddr = InetAddress.getByName(this.rthost);
                }
                catch (Exception e) {
                    this.M.warning("Opening socket: " + e.getMessage());
                    if (--this.prange == 0) {
                        return 9;
                    }
                    ++this.port;
                }
            }
            this.hin = this.MA.getDataFile("IN", "1000", "S*", 0);
            if (this.hin == null) {
                this.M.info("Invalid Input File");
                return 0;
            }
            this.hin.open();
            this.tdelay = (double)this.tl * this.hin.getXDelta();
            this.selfpace = this.hin.isFile();
            this.inbuf = new byte[this.tl];
            this.inint = this.hin.getDataBuffer(this.tl, (byte)73);
            this.outbuf = new short[this.tl];
            this.decodeTable = this.build_mu_decode_table();
            this.rtbuf = new byte[16 + this.twotl];
            this.rtpack = new DatagramPacket(this.rtbuf, this.rtbuf.length, rtaddr, this.rtport);
            this.makeRTPHeader();
            if (this.MA.find("OUT")) {
                this.hout = this.MA.getDataFile("OUT", this.hin, 0);
                this.hout.setFormat("SI");
                this.hout.setType(1000);
                this.hout.open();
                this.outdata = new Data(this.hout.getFormat(), this.tl);
            }
        }
        catch (Exception e) {
            this.M.printStackTrace("Open error:", e);
        }
        return 0;
    }

    @Override
    public int process() {
        try {
            block23: {
                short adjval;
                int j;
                int i;
                int n;
                short newval = 0;
                if (this.hin == null) {
                    this.M.info("Null Input");
                    return -1;
                }
                if (this.type == 2) {
                    n = this.hin.read(this.inbuf, 0, this.tl);
                } else {
                    if (this.inint == null) {
                        this.M.warning("Null in ints");
                    }
                    n = this.hin.read(this.inint);
                }
                if (n == 0) {
                    return -1;
                }
                if (n < 0) {
                    return 9;
                }
                if (this.type == 2) {
                    i = 0;
                    j = 0;
                    while (i < n) {
                        newval = this.decodeTable[this.inbuf[i] + 128];
                        adjval = this.adjustVolume(newval, this.scale);
                        this.pack(this.rtbuf, 16 + j, adjval, 2);
                        if (this.hout != null) {
                            this.outbuf[i] = adjval;
                        }
                        ++i;
                        j += 2;
                    }
                } else {
                    this.inshort = this.inint.castI(false);
                    i = 0;
                    j = 0;
                    while (i < n) {
                        adjval = this.adjustVolume(this.inshort[i], this.scale);
                        this.pack(this.rtbuf, 16 + j, adjval, 2);
                        if (this.hout != null) {
                            this.outbuf[i] = adjval;
                        }
                        ++i;
                        j += 2;
                    }
                    this.inint.uncast(this.inshort, true);
                }
                if (this.selfpace) {
                    this.time = Time.current();
                    while (this.time - this.tlast < this.tdelay - 0.001) {
                        Time.sleep(0.001);
                        this.time = Time.current();
                    }
                    this.tlast = this.time;
                }
                if (this.mode != 4 && this.sockisok) {
                    try {
                        this.pack(this.rtbuf, 2, this.seq, 2);
                        this.pack(this.rtbuf, 4, this.ts, 4);
                        this.dsock.send(this.rtpack);
                        this.ts += this.tl;
                        ++this.seq;
                    }
                    catch (InterruptedIOException i2) {
                    }
                    catch (Exception e) {
                        this.M.warning("SinkRtp: problem in socket write: " + e.getMessage());
                        this.sockisok = false;
                        if (this.reopen <= 0 || this.reopen_tries >= this.reopen) break block23;
                        this.dsock.close();
                        try {
                            this.dsock = new DatagramSocket(this.port);
                            this.sockisok = true;
                            this.reopen_tries = 0;
                        }
                        catch (Exception ex) {
                            ++this.reopen_tries;
                        }
                    }
                }
            }
            if (this.hout != null) {
                this.outdata.fromArray(this.outbuf);
                this.hout.write(this.outdata);
            }
        }
        catch (Exception e) {
            this.M.printStackTrace("Process error:", e);
        }
        return 0;
    }

    @Override
    public int close() {
        try {
            this.rtbuf[0] = -127;
            this.rtbuf[1] = -53;
            this.pack(this.rtbuf, 2, 2, 2);
            this.pack(this.rtbuf, 4, this.src, 4);
            this.rtpack.setPort(this.rtport + 1);
            this.rtpack.setLength(8);
            this.dsock.send(this.rtpack);
        }
        catch (Exception e) {
            this.M.printStackTrace("Close error", e);
        }
        if (this.dsock != null) {
            this.dsock.close();
        }
        if (this.hin != null) {
            this.hin.close();
        }
        if (this.hout != null) {
            this.hout.close();
        }
        return 0;
    }

    private void pack(byte[] buf, int boff, int value, int bytes) {
        for (int i = bytes - 1; i >= 0; --i) {
            buf[boff + i] = (byte)(value & 0xFF);
            value >>= 8;
        }
    }

    private void makeRTPHeader() {
        this.rtbuf[0] = -127;
        this.rtbuf[1] = 13;
        this.rtpack.setLength(16 + this.twotl);
        this.pack(this.rtbuf, 8, this.src, 4);
        this.pack(this.rtbuf, 12, this.chan, 4);
        this.setMode(this.mode);
    }

    public void setType(String value) {
        this.setType(Parser.find(typeList, value, this.type, 0, 1));
    }

    private void setType(int value) {
        this.type = value;
        this.sockisok = true;
    }

    public void setMode(String value) {
        this.setMode(Parser.find(modeList, value, this.mode, 0, 1));
    }

    private void setMode(int value) {
        if (value == 5) {
            this.seq ^= 0x8000;
            return;
        }
        this.chan = value == 4 ? 0 : value;
        this.mode = value;
        this.pack(this.rtbuf, 12, this.chan, 4);
        this.sockisok = true;
    }

    public String getMode() {
        return Parser.get(modeList, this.mode);
    }

    public void setVolume(double value) {
        this.scale = Math.pow(10.0, value / 10.0);
    }

    private short adjustVolume(short val, double scale) {
        double newvol;
        if (scale == 1.0) {
            short s = val;
        }
        int adjval = (newvol = (double)val * scale) < -32768.0 ? Short.MIN_VALUE : (newvol > 32767.0 ? Short.MAX_VALUE : (int)((short)newvol));
        return (short)adjval;
    }

    private short[] build_mu_decode_table() {
        short[] convbuf = new short[256];
        for (int i = 0; i < 256; ++i) {
            int j = i - 128;
            int x = j ^ 0x7F;
            int S = 1 - 2 * ((x & 0x80) / 128);
            int L = (x & 0x70) / 16;
            int V = x & 0xF;
            convbuf[i] = (short)Math.round((double)S * (Math.pow(2.0, L) * (double)(2 * V + 33) - 33.0) * 32767.0 / 8031.0);
        }
        return convbuf;
    }
}

