/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.text.SimpleDateFormat;
import java.util.Date;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Message;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;

public class sinkfile
extends Primitive {
    private DataFile hi;
    private DataFile ho;
    private Data data;
    private double start;
    private double offset;
    private double size;
    private double end;
    private boolean rtfile;
    private String out;
    private boolean timeBased = false;
    private long nelements = 0L;
    private int ndigits = 4;
    private long seqNum = 0L;
    private String namescheme = "";
    private String fileName;
    private double nseconds;
    private double startTime;
    private String cut;
    private String cutMsg = null;
    private static final String FORM_TYPE_1 = "yyyyMMdd_HHmmss";
    private static final String FORM_TYPE_2 = "yyMMdd";
    private static final String FORM_TYPE_3 = "HHmmss";

    @Override
    public int open() {
        this.hi = this.MA.getDataFile("IN");
        this.hi.open();
        this.out = this.MA.getS("OUT");
        this.start = this.MA.getD("START");
        this.size = this.MA.getD("DURATION");
        this.cut = this.MA.getS("/CUT", null);
        this.end = this.start + this.size;
        if (this.cut != null) {
            this.setCutOptions(this.cut, this.MA.getTable("CUTOPTIONS"));
        } else {
            this.fileName = this.out;
        }
        this.ho = new DataFile(this.M, (Object)this.fileName, this.hi, 0);
        this.ho.open(2);
        this.ho.setXStart(this.hi.getXStart() + this.hi.getXDelta() * this.hi.getOffset());
        if (this.size > 0.0) {
            this.ho.setSize(this.end);
        }
        this.xfer = Math.max(1, (int)((double)this.bufSize / this.hi.dbpe));
        this.xfer = this.MA.getL("/TL", this.xfer);
        this.data = this.hi.getDataBuffer(this.xfer);
        this.offset = 0.0;
        this.rtfile = this.MA.getState("/RTFILE");
        if (this.nelements == 0L || this.nseconds == 0.0) {
            if (this.size > 0.0) {
                this.ho.seek(this.end);
            }
            this.ho.seek(this.start);
        }
        return 0;
    }

    private void setCutOptions(String cutVal, Table options) {
        if (options != null) {
            this.ndigits = Math.max(1, Math.min(16, options.getL("DIGITS")));
            this.namescheme = options.getS("NAMESCHEME");
            if (this.namescheme != null) {
                this.timeBased = !this.namescheme.equalsIgnoreCase("");
            }
            this.seqNum = options.getL("STARTNUM", 0);
            this.cutMsg = options.getS("NEWFILEMSG");
        } else {
            this.ndigits = 4;
            this.namescheme = "";
            this.timeBased = false;
            this.cutMsg = null;
        }
        if (cutVal.equalsIgnoreCase("ELEMENTS") || cutVal.equalsIgnoreCase("TIME")) {
            if (cutVal.equalsIgnoreCase("TIME")) {
                if (this.hi.getUnits() != 1 || this.hi.getUnits() != 1) {
                    this.M.warning("Input file is not time-based. Assuming Time Delta of 1.0");
                } else {
                    this.size /= this.hi.getDelta();
                }
            }
            this.setNelements((long)this.size);
            if (this.size > 0.0) {
                this.hi.seek(0.0);
                this.end = this.size;
            }
        } else if (cutVal.equalsIgnoreCase("CLOCK_TIME") && this.size > 1.0) {
            this.setNseconds(this.size);
            this.size = 0.0;
            this.hi.seek(0.0);
            double t = System.currentTimeMillis();
            this.setStartTime(t);
        }
        this.fileName = this.getFileName(this.seqNum++);
    }

    @Override
    public int process() {
        if (this.nelements != 0L) {
            return this.processCutByElements();
        }
        if (this.nseconds != 0.0) {
            return this.processCutByClockTime();
        }
        int n = this.hi.read(this.data);
        if (n < 0) {
            return 9;
        }
        if (n == 0) {
            return -1;
        }
        this.ho.write(this.data, n);
        this.offset += (double)n;
        if (this.rtfile) {
            this.ho.setInByte(this.offset * this.ho.dbpe);
            this.ho.writeHeader();
        }
        if (this.size > 0.0 && this.ho.seek() >= this.end) {
            this.ho.seek(this.start);
        }
        return 0;
    }

    @Override
    public int close() {
        this.hi.close();
        this.ho.close();
        return 0;
    }

    @Override
    public int processMessage(Message msg) {
        if (msg.name.equals("CUT")) {
            if (msg.data != null) {
                this.out = (String)msg.data;
            }
            if (this.cutMsg == null) {
                this.cutMsg = "";
            }
        } else {
            return super.processMessage(msg);
        }
        this.cutNewFile();
        return 0;
    }

    private int processCutByElements() {
        if (this.offset + (double)this.xfer < this.ho.getSize()) {
            int n = this.hi.read(this.data);
            if (n < 0) {
                return 9;
            }
            if (n == 0) {
                return -1;
            }
            this.ho.write(this.data, n);
            this.offset += (double)n;
        } else {
            int elementsLeft = (int)(this.ho.getSize() - this.offset);
            this.data = this.hi.getDataBuffer(elementsLeft);
            int n = this.hi.read(this.data);
            if (n < 0) {
                return 9;
            }
            if (n == 0) {
                return -1;
            }
            this.ho.write(this.data, n);
            if (this.hi.seek() < this.hi.getSize() - 1.0) {
                this.cutNewFile();
            }
        }
        return 0;
    }

    private int processCutByClockTime() {
        long currentTime = System.currentTimeMillis();
        long lapsedTime = (long)(((double)currentTime - this.startTime) / 1000.0);
        if ((double)lapsedTime < this.nseconds) {
            int n = this.hi.read(this.data);
            if (n < 0) {
                return 9;
            }
            if (n == 0) {
                return -1;
            }
            this.ho.write(this.data, n);
            this.offset += (double)n;
        } else {
            this.setStartTime(System.currentTimeMillis());
            this.cutNewFile();
        }
        return 0;
    }

    public String getFileName() {
        return this.getFileName(this.seqNum);
    }

    private String getFileName(long count) {
        String timeFormat = "";
        String format = "%0" + this.getNdigits() + "d";
        if (this.timeBased) {
            SimpleDateFormat sdf = new SimpleDateFormat(this.retrieveFormat(this.namescheme));
            timeFormat = "_" + sdf.format(new Date());
        }
        String fileNum = String.format(format, count);
        String fileName = this.out + fileNum + timeFormat;
        return fileName;
    }

    public void cutNewFile() {
        String oldName = this.ho.getName().getBasename();
        this.ho.close();
        this.offset = 0.0;
        String fileName = this.getFileName(this.seqNum++);
        this.ho = new DataFile(this.M, (Object)fileName, this.hi, 0);
        this.ho.setXStart(this.hi.getXStart() + this.hi.getXDelta() * this.hi.getOffset());
        if (this.size > 0.0) {
            this.ho.setSize(this.size);
            this.ho.seek(0.0);
        }
        this.ho.open(2);
        if (this.cutMsg != null) {
            if (this.cutMsg.equals("")) {
                this.M.info("SINKFILE: Closed current file: " + oldName + ". Spawning new file: " + fileName);
            } else {
                this.M.info(this.cutMsg);
            }
        }
    }

    private void setNelements(long nelements) {
        this.nelements = nelements;
    }

    private void setNseconds(double nseconds) {
        this.nseconds = nseconds;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    private int getNdigits() {
        if (this.ndigits < 0) {
            return 4;
        }
        return this.ndigits;
    }

    public void setNdigits(int ndigits) {
        this.ndigits = ndigits > 8 ? 8 : ndigits;
    }

    private String retrieveFormat(String namescheme) {
        if (namescheme.equalsIgnoreCase("STD")) {
            return FORM_TYPE_1;
        }
        if (namescheme.equalsIgnoreCase("YMD")) {
            return FORM_TYPE_2;
        }
        if (namescheme.equalsIgnoreCase("HMS")) {
            return FORM_TYPE_3;
        }
        return FORM_TYPE_1;
    }
}

