/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import nxm.sys.inc.Filter;
import nxm.sys.inc.Installation;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.Widget;
import nxm.sys.lib.Args;
import nxm.sys.lib.Command;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.Macro;
import nxm.sys.lib.Message;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Theme;
import nxm.sys.lib.Time;
import nxm.sys.lib.Util;
import nxm.sys.libg.GAlert;
import nxm.sys.libg.GLabel;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPanel;
import nxm.sys.libg.GPanelSetup;
import nxm.sys.libg.GPrimitive;
import nxm.sys.libg.GPrompt;
import nxm.sys.libg.GQuery;
import nxm.sys.libg.GText;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MPanel;
import nxm.sys.libg.MWindow;
import nxm.sys.libg.MidasControls;
import nxm.sys.libg.MidasDisplay;
import nxm.sys.libg.PushPopPanel;
import nxm.sys.libg.WidgetPanel;
import nxm.sys.libg.WidgetWrapper;
import nxm.sys.net.Rmif;
import nxm.sys.prim.rmif;

public class panel
extends GPrimitive
implements WidgetPanel,
Filter {
    private static final int sbw = 4;
    private static final int bw = 3;
    private final int maxLine = 69;
    private final int maxPane = 65;
    private final int maxWidget = 256;
    private int exit = -1;
    private int filterMode = 0;
    private int nline = 0;
    private int npane = 0;
    private int nwidget = 0;
    private int iwz0 = 0;
    private int iwz1 = 0;
    private int iwz2 = 0;
    private int dlh = 50;
    private int cfgx;
    private int cfgy;
    private int configure;
    private int options;
    private int eventFilter;
    private int dragline;
    private int pushPopIconSymbol;
    private int pushPopIconActions;
    private int customIconSymbol;
    private int customIconActions;
    private Line[] line = new Line[69];
    private Pane[] pane = new Pane[65];
    private GWidget[] widget = new GWidget[256];
    private String cfgfile;
    private String regname;
    private String titlebar;
    private double lastPollTime;
    private int nTimers = 0;
    private double[] timer = null;
    private double[] timerinit = null;
    private Table cpos = new Table();
    private boolean inline;
    private boolean inlinx;
    private boolean init = true;
    private boolean needLayout;
    private boolean headless;
    private int gnx;
    private int gny;
    private Object wmsgid;
    private GLabel curGLabel;
    private GLabel lastCollapsableGLabel;
    private GLabel lastOpenedGLabel;
    private MBox[] bbox = new MBox[5];
    private boolean logger;
    private boolean addNewLoggerPane;
    private int nleft;
    private int yleft;
    private int hbar = 0;
    private int xbar;
    private int ytop;
    private int ybott;
    private int iScroll;
    private int oScroll;
    private int vScroll;
    private int cursorDir;
    private int needCompress;
    private int prevCompress;
    private int curCompress;
    private int maxCompress = 10;
    private String userCursor = null;
    private Table xmCanvasTbl = null;
    private String altTitle;
    private String currentTitle;
    private int mobile;
    private int mpad = 640;
    private Robot robot;
    private boolean tsetup = false;
    private Table setupTable = null;
    private boolean parentResult = false;
    private boolean localResult = false;
    private boolean holdLayout = false;
    private boolean hideWidget = false;
    private boolean menuBarEnabled = false;
    private boolean fixByOffset = false;
    private int widthLabelInMenuBar = 0;
    private Table panes = new Table();
    private Table cntrls;
    private static final int EXIT_RETURN = 1;
    private static final int EXIT_MENU = 2;
    private static final int EXIT_MESSAGE = 4;
    private static final int EXIT_WINDOW = 8;
    private static final int EXIT_ALL = 15;
    private static final String exitList = "RETURN,MENU,MESSAGE,WINDOW";
    private static final int ROTATETABS = 1;
    private static final int PUSHPOPICON = 2;
    private static final int COMPRESS = 4;
    private static final int COLLAPSE = 8;
    private static final int LOCKSETUP = 16;
    private static final int LOCKCONTROLS = 32;
    private static final int MINIDRAGZONE = 64;
    private static final int ADVPUSHPOP = 128;
    private static final int HIDECONTROLS = 256;
    private int optionsDefault = 134;
    private int optionsDefaultMnM = 48;
    public static String optionsList = "RotateTabs,PushPopX,CompressControls,CollapseControls,LockSetup,LockControls,MiniDragZone,AdvPushPopX,HideControls";
    @InternalUseOnly(value="Since NeXtMidas 3.5.4, this has always been meant for internal use only")
    public static final int PUSHPOP_ICON_SYMBOL_SHADEDX = 1;
    @InternalUseOnly(value="Since NeXtMidas 3.5.4, this has always been meant for internal use only")
    public static final int PUSHPOP_ICON_SYMBOL_PUSHPOP = 2;
    @InternalUseOnly(value="Since NeXtMidas 3.5.4, this has always been meant for internal use only")
    public static final String pushpopIconSymbolList = "ShadedX,PushPop";
    private static final int PUSHPOP_ICON_ACTION_PUSHPOP = 1;
    private static final int PUSHPOP_ICON_ACTION_MESSAGE = 2;
    public static String pushPopIconActionList = "PushPop,Message";
    public static final int CUSTOM_ICON_SYMBOL_NONE = 1;
    public static final int CUSTOM_ICON_SYMBOL_SHADEDX = 2;
    public static final int CUSTOM_ICON_SYMBOL_MIDASSYMBOL = 3;
    private static final int CUSTOM_ICON_ACTION_CLOSE = 1;
    private static final int CUSTOM_ICON_ACTION_MESSAGE = 2;
    private int customIconSymbolDefault = 1;
    private int customIconActionDefault = 0;
    private String customIconSymbolName = "NONE";
    public static final String customIconSymbolList = "None,ShadedX,Symbol";
    public static String customIconActionList = "Close,Message";
    private static final int BUTTON_SELECTED_NONE = 0;
    private static final int BUTTON_SELECTED_PUSHPOP = -1;
    private static final int BUTTON_SELECTED_CUSTOM = -2;
    private static final int BUTTON_SELECTED_OOR = -3;
    private static final int TABS_ROTATE = 1;
    private static final String tabOptionsList = "ROTATE";
    private int tabOptions = 1;
    public static final String bordersList = "Left,Right,Top,Bottom,TopLeft,TopRight,BottomLeft,BottomRight";
    private static final int BORD_LEFT = 1;
    private static final int BORD_RIGHT = 2;
    private static final int BORD_TOP = 4;
    private static final int BORD_BOTTOM = 8;
    private static final int BORD_TOPLEFT = 16;
    private static final int BORD_TOPRIGHT = 32;
    private static final int BORD_BOTTOMLEFT = 64;
    private static final int BORD_BOTTOMRIGHT = 128;
    private static final int BORDERS_DEFAULT = 15;
    private int borders = 15;
    private static final int MENUBAR_BORDERS_DEFAULT = 14;
    private static final int VLINE = 1;
    private static final int HLINE = 2;
    private static final int VLINEX = -1;
    private static final int HLINEX = -2;
    private static final int SETUP = 1;
    private static final int TSETUP = 2;
    private MidasControls ctlPane = null;
    private Container container = null;
    private Table subPanels;
    private String subPanelName;
    private boolean shareTheme;
    private nxm.sys.libg.Theme theme;
    public static String eventFilterList = "NoMouse,NoKeyBoard,NoIconify,NoMove,NoRefresh,NoPushPop,NoMiddleMouse";
    private int lbu = 0;
    private int lbm = 0;
    private int ldp = -1;
    String iconDir = "";

    @Override
    public int open() {
        Table t;
        String panelClass = this.MA.getCS("/JSETUP", null, "");
        this.titlebar = "Panel";
        this.cfgfile = this.MA.getS("FILE");
        this.tsetup = this.MA.find("/TSETUP");
        if (this.tsetup) {
            this.setupTable = this.configTSetup();
        }
        if (this.MA.find("/SETUP")) {
            this.setConfigFileName(1);
        }
        this.setTimers(this.MA.getL("/NTIMERS", 3));
        this.regname = this.MA.getU("/PANES", "WIN");
        String rname = this.MA.getU("/WMSGID");
        if (rname.length() > 0) {
            this.wmsgid = this.M.registry.getCommand(rname, 5);
        }
        this.cntrls = this.M.macro == null ? new Table() : this.M.macro.getControls();
        if (this.MA.find("/CONTROLS")) {
            this.MR.put(this.MA.getS("/CONTROLS", "GC"), (Object)this.cntrls);
        }
        this.exit = this.M.pipeMode == 1 ? 8 : 15;
        this.exit = this.MA.getOptionMask("/EXIT", exitList, this.exit);
        if (this.MA.find("/TABS")) {
            this.M.deprecate("The /TABS= list is now in the /OPTIONS= list");
        }
        this.tabOptions = this.MA.getOptionMask("/TABS", tabOptionsList, this.tabOptions);
        if ((this.tabOptions & 1) == 0) {
            this.optionsDefault &= 0xFFFFFFFE;
        }
        this.headless = this.MA.getState("/HEADLESS", Shell.isHeadless());
        this.fixByOffset = this.MA.getState("/FIXBYOFF");
        if (!this.headless && Shell.isHeadless()) {
            this.M.error("PANEL: Can not set '/HEADLESS=" + this.MA.getS("/HEADLESS") + "' on a headless system.");
        }
        this.inline = this.MA.getState("/INLINE", true);
        this.inlinx = this.MA.getState("/INLINX", false);
        this.logger = this.MA.getState("/LOGGER");
        String themeName = this.MR.getS("ENV.THEME");
        Object themeObj = this.MA.getO("/THEME", themeName);
        this.shareTheme = this.MA.getState("/SHARETHEME");
        nxm.sys.libg.Theme theme = this.theme = this.shareTheme ? (nxm.sys.libg.Theme)Theme.global() : (nxm.sys.libg.Theme)Theme.global().copy();
        if (themeObj != null && themeObj instanceof nxm.sys.libg.Theme) {
            this.theme = (nxm.sys.libg.Theme)themeObj;
        }
        boolean mnm = themeObj != null && themeObj.toString().equals("MNM");
        this.options = this.MA.getOptionMask("/OPTIONS", optionsList, mnm ? this.optionsDefaultMnM : this.optionsDefault);
        this.MW = new GPanelSetup(this.titlebar, this);
        this.hideWidget = this.MA.getState("/HIDEWIDGET", false);
        this.menuBarEnabled = this.MA.getState("/MENUBAR", false);
        this.pushPopIconSymbol = Installation.ApplyBugFix.PANEL_REVERT_TO_SHADEDX_PUSHPOP_ICON ? 1 : this.MA.getChoice("/PUSHPOPICONSYMBOL", pushpopIconSymbolList, 2);
        this.pushPopIconActions = this.MA.getOptionMask("/PUSHPOPICONACTION", pushPopIconActionList, 1);
        String customIconString = this.MA.getCS("/CUSTOMICONSYMBOL", "None", "ShadedX");
        this.customIconSymbol = Parser.find(customIconSymbolList, customIconString, 1, 0);
        if (this.customIconSymbol == -1) {
            this.customIconSymbol = 3;
            this.customIconSymbolName = customIconString;
        }
        this.customIconActions = this.customIconSymbol == 1 ? this.customIconActionDefault : (this.customIconSymbol == 2 ? this.MA.getOptionMask("/CUSTOMICONACTION", customIconActionList, 1) : this.MA.getOptionMask("/CUSTOMICONACTION", customIconActionList, this.customIconActionDefault));
        this.panes.put("PANE0", (Object)this.MW);
        if (panelClass == null) {
            if (!this.headless) {
                this.MW.open();
            }
            this.useDefaultSetup();
            this.addNewLoggerPane = this.logger;
            if (mnm) {
                nxm.sys.libg.Theme.setOptions("+MOBILE");
                this.mobile = -1;
                this.load("nxm.sys.mcr.mnm.mmp");
                this.mobile = 1;
                try {
                    this.robot = new Robot();
                }
                catch (Exception e) {
                    this.M.printStackTrace("Unable to instantiate Robot class for event generation ", e);
                }
            }
            if (this.setupTable != null) {
                try {
                    this.setSetupTable(this.setupTable);
                }
                catch (Exception e) {
                    this.M.printStackTrace("Error loading setup from table " + this.setupTable, e);
                    this.useDefaultSetup();
                }
            } else if (this.cfgfile.length() > 0 && !this.tsetup) {
                try {
                    this.load(this.cfgfile);
                }
                catch (Exception e) {
                    this.M.printStackTrace("Error loading setup from mmp file " + this.cfgfile, e);
                    this.useDefaultSetup();
                }
            }
            this.addNewLoggerPane = this.logger && this.addNewLoggerPane;
        } else {
            int i;
            int width = 150;
            this.loadPanelClass(panelClass);
            if (this.ctlPane != null) {
                width = this.ctlPane.getWidth();
                if (!this.headless) {
                    this.MW.open();
                }
            }
            for (i = 0; i <= 4; ++i) {
                this.bbox[i] = new MBox();
            }
            this.nline = 4;
            for (i = 0; i <= 4; ++i) {
                this.line[i] = new Line();
            }
            this.setLine(0, 2, 0, 0.0f, 0.0f, 0, 0);
            this.setLine(1, 1, width, 0.0f, 1.0f, 0, 0);
            this.pane[0] = new Pane(this, "PANE0");
        }
        if (this.addNewLoggerPane && this.logger) {
            this.addPane(-1, "LOGGER", "Message Logger", "LOGGER", 12, 1, 2, 4, 0, 0);
        }
        if ((t = this.MA.getTable("/GRID")) != null) {
            this.autoGrid(t);
        }
        if (this.headless) {
            this.init = false;
        } else {
            if (this.container == null) {
                this.MW.addTo(this);
            } else if (this.container instanceof Frame) {
                if (this.ctlPane != null) {
                    this.MW.addTo(this);
                }
            } else {
                this.MW.addTo(this);
                if (this.MW.parent instanceof Container) {
                    Container _parent = (Container)this.MW.parent;
                    _parent.remove(this.container);
                    _parent.setLayout(new BorderLayout());
                    _parent.add((Component)this.container, "Center");
                    if (_parent instanceof Window) {
                        ((Window)_parent).pack();
                    }
                }
            }
            this.MW.setTheme(themeObj, this.inline);
            this.theme = this.MW.theme;
            this.resize();
            this.refresh();
        }
        this.M.registry.put(this.regname, this.panes);
        if (this.logger) {
            Shell.runCommand(this.M, "MSGLOG/ID=LOGGER/BANNER=PANE/WRAP=" + mnm);
        }
        return 0;
    }

    @Override
    public int process() {
        try {
            int i;
            if (this.xmCanvasTbl != null) {
                String[] keys = this.xmCanvasTbl.getKeys();
                for (int i2 = 0; i2 < keys.length; ++i2) {
                    KeyObject.setKey(this.xmCanvasTbl.get(keys[i2]), "XS", keys[i2].substring(2));
                }
                this.xmCanvasTbl = null;
            }
            if (this.init && this.M.pipeMode != 1) {
                if (this.curGLabel != null) {
                    this.maxCompress = this.curGLabel.pos.h / 4;
                }
                this.curGLabel = null;
                this.updateLastWidget();
                this.init = false;
                if (this.menuBarEnabled) {
                    this.setBorders(this.borders & 0xFFFFFFFE);
                }
            }
            if (this.init) {
                return -1;
            }
            double time = Time.current();
            for (i = 0; i < this.nTimers; ++i) {
                double nthTimer = this.timer[i];
                if (nthTimer == 0.0 || !(time - this.timerinit[i] > Math.abs(nthTimer))) continue;
                this.MQ.put("TIMER", i, time, "MAIN", this);
                if (nthTimer > 0.0) {
                    this.timerinit[i] = time;
                    continue;
                }
                this.timer[i] = 0.0;
            }
            for (i = 1; i <= this.nwidget; ++i) {
                GWidget gWidget = this.widget[i];
                if (gWidget == null) continue;
                gWidget.poll();
            }
            if (this.needLayout) {
                this.layout();
            }
            if (this.needCompress != 0 || this.prevCompress != 0) {
                this.curCompress += this.needCompress;
                this.layout();
            } else if (this.is(8) && this.lastOpenedGLabel != null) {
                this.lastOpenedGLabel.setActive(3);
                this.lastOpenedGLabel = null;
            }
            if (time - this.lastPollTime > 0.3) {
                this.lastPollTime = time;
                this.refreshTitle();
            }
        }
        catch (Exception e) {
            this.M.printStackTrace(Thread.currentThread().toString(), e);
        }
        return -1;
    }

    @Override
    public int close() {
        int to = 10;
        Table.Iterator ti = this.panes.iterator();
        while (ti.getNext()) {
            while (to > 0 && this.M.registry.get(ti.key) != null) {
                --to;
                Time.sleep(0.1);
            }
        }
        if (this.mobile != 0) {
            nxm.sys.libg.Theme.setOptions("-MOBILE");
        }
        if (this.MW != null) {
            this.MW.theme.setInline(false);
            this.MW.close();
        }
        this.M.registry.remove(this.regname);
        if (this.container != null) {
            this.container.setVisible(false);
            if (Shell.needRemoveNotifyToAvoidJVMHang()) {
                this.container.removeNotify();
            }
        }
        return 0;
    }

    private void useDefaultSetup() {
        int i;
        for (i = 0; i <= 4; ++i) {
            this.bbox[i] = new MBox();
        }
        this.nline = 4;
        for (i = 0; i <= 4; ++i) {
            this.line[i] = new Line();
        }
        this.setLine(0, 2, 0, 0.0f, 0.0f, 0, 0);
        this.setLine(1, 1, 150, 0.0f, 0.5f, 0, 0);
        this.setLine(2, 1, 50, 1.0f, 0.5f, 0, 0);
        this.setLine(3, 2, 50, 0.5f, 0.0f, 1, 2);
        this.setLine(4, 2, 50, 0.5f, 1.0f, 1, 2);
        this.pane[0] = new Pane(this, "PANE0");
    }

    @Override
    public Container getGraphicsContainer() {
        return this.container != null ? this.container : super.getGraphicsContainer();
    }

    @Override
    public void checkout() {
        for (int i = 0; i < this.widget.length; ++i) {
            GWidget gWidget = this.widget[i];
            if (gWidget == null) continue;
            gWidget.close();
        }
        super.checkout();
    }

    private boolean is(int mask) {
        return (this.options & mask) != 0;
    }

    public void refresh() {
        if (this.MQ != null) {
            this.MQ.remove("REFRESH");
        }
        if (this.MW != null && this.MW.panel != null) {
            this.MW.panel.repaint();
        }
    }

    public void refreshAll() {
        if (!this.isHideWidgets()) {
            int i;
            for (i = 0; i < this.widget.length; ++i) {
                GWidget gWidget = this.widget[i];
                if (gWidget != null && gWidget.panel != null) {
                    gWidget.panel.repaint();
                }
                if (!(gWidget instanceof GText)) continue;
                ((GText)gWidget).getMJTextArea().setAttributesGW((GText)gWidget);
            }
            for (i = 0; i < this.pane.length; ++i) {
                if (this.pane[i] == null || this.pane[i].panel == null) continue;
                this.pane[i].panel.repaint();
            }
        }
        this.refresh();
    }

    @InternalUseOnly(value="Only GPanelSetup should use this")
    public void paintComponent(GPanelSetup gp, Graphics g) {
        int i;
        if (this.headless) {
            return;
        }
        this.MW.setGraphics(g);
        boolean paneRefresh = false;
        for (i = 1; i <= this.npane; ++i) {
            Pane p = this.pane[i];
            if (p == null || !p.pos.equals(g.getClipBounds())) continue;
            p.paint(gp, g);
            paneRefresh = true;
        }
        if (paneRefresh) {
            return;
        }
        this.MW.clear(g);
        for (i = 1; i <= this.nline; ++i) {
            Line l = this.line[i];
            if (i <= 4 && l.fp == 0 && (this.borders & 1 << i - 1) != 0) continue;
            gp.shadowbox(g, l.x1, l.y1, l.x2 - l.x1, l.y2 - l.y1, 0);
            int xm = (l.x1 + l.x2) / 2;
            int ym = (l.y1 + l.y2) / 2;
            g.setColor(this.MW.theme.cwts);
            if (i == 1 || i == 2) {
                g.drawLine(l.x1 + 3, l.y1 + 4, l.x2 - 3, l.y1 + 8);
                g.drawLine(l.x2 - 3, l.y1 + 8, l.x1 + 3, l.y1 + 12);
                g.drawLine(l.x1 + 3, l.y1 + 12, l.x2 - 3, l.y1 + 16);
            } else if (i == 3 || i == 4) {
                g.drawLine(l.x1 + 4, l.y1 + 3, l.x1 + 8, l.y2 - 3);
                g.drawLine(l.x1 + 8, l.y2 - 3, l.x1 + 12, l.y1 + 3);
                g.drawLine(l.x1 + 12, l.y1 + 3, l.x1 + 16, l.y2 - 3);
            } else if (this.is(64) && !this.is(16)) {
                if (l.dir == 2) {
                    g.drawLine(xm - 4, ym, xm + 4, ym);
                }
                if (l.dir == 1) {
                    g.drawLine(xm, ym - 4, xm, ym + 4);
                }
            }
            if (this.configure <= 0) continue;
            gp.shadowbox(g, l.x1, l.y1, l.x2 - l.x1, l.y2 - l.y1, 3);
        }
        for (i = 1; i <= this.npane; ++i) {
            if (this.pane[i] == null) continue;
            this.pane[i].paint(gp, g);
        }
        this.paintScroll(g);
    }

    private void paintScroll(Graphics g) {
        Line l = this.line[1];
        if (l != null) {
            this.vScroll = Math.max(10, Math.min(200, l.y2 - l.y1 - 32));
            int xm = (l.x1 + l.x2) / 2;
            int ym = l.y2 - 8 - this.vScroll;
            MWindow.drawVSlider(xm, ym, 0, this.vScroll, (double)this.iScroll / (double)this.nwidget, 0, g, this.MW.theme);
        }
    }

    private void resize() {
        int i;
        if (this.headless || this.isHideWidgets()) {
            return;
        }
        this.ytop = this.menuBarEnabled && (this.borders & 1) == 0 ? this.hbar : 0;
        for (i = 1; i <= 4; ++i) {
            this.fixLine(i);
        }
        for (i = 1; i <= this.nline; ++i) {
            this.fixLine(i);
        }
        for (i = 1; i <= this.npane; ++i) {
            this.fixPane(i);
        }
        this.setBorderBoxes();
        this.layout();
        if (this.MW != null) {
            this.MW.panel.revalidate();
        }
    }

    public void setHoldLayout(boolean hold) {
        this.holdLayout = hold;
    }

    public boolean getHoldLayout() {
        return this.holdLayout;
    }

    private void layout() {
        if (this.init || this.holdLayout) {
            return;
        }
        if (this.isHideWidgets()) {
            return;
        }
        Graphics g = this.MW.panel.getGraphics();
        if (g == null) {
            return;
        }
        this.yleft = 0;
        this.nleft = 0;
        this.ybott = this.bbox[1].y + this.bbox[1].h;
        this.xbar = this.line[1].x2;
        if (!this.is(4)) {
            this.curCompress = 0;
        }
        this.iwz2 = 0;
        this.iwz1 = 0;
        this.iwz0 = 0;
        if (this.headless) {
            return;
        }
        int needCompressO = this.needCompress;
        int prevCompressO = this.prevCompress;
        this.lastOpenedGLabel = null;
        this.lastCollapsableGLabel = null;
        for (int i = 1; i <= this.nwidget; ++i) {
            this.fixWidget(i, 1);
        }
        this.needLayout = false;
        this.prevCompress = needCompressO;
        this.needCompress = 0;
        if (needCompressO == 0 && prevCompressO != 0) {
            return;
        }
        if (this.yleft > this.ybott && this.curCompress < this.maxCompress) {
            this.needCompress = 1;
        }
        if (this.curCompress > 0 && this.ybott - this.yleft > this.nleft && this.prevCompress <= 0) {
            this.needCompress = -1;
        }
        if (this.is(8) && this.needCompress > 0 && this.lastCollapsableGLabel != null) {
            this.lastCollapsableGLabel.setActive(-3);
            this.needCompress = 0;
        }
        if (!this.is(4)) {
            this.needCompress = 0;
        }
        if (this.yleft > this.ybott && this.iScroll < 0) {
            this.iScroll = 0;
        }
        if (this.yleft < this.ybott && this.iScroll == 0) {
            this.iScroll = -1;
        }
        if (this.iScroll != this.oScroll) {
            this.paintScroll(g);
            this.oScroll = this.iScroll;
        }
    }

    @Override
    public int processMessage(Message msg) {
        String text;
        if (msg.name.equals("KEYPRESS")) {
            text = msg.getS();
            if (text.equalsIgnoreCase("M")) {
                msg.name = "MENU";
            }
            if (text.equalsIgnoreCase("Enter") && (this.exit & 1) != 0) {
                msg.name = "EXIT";
            }
        }
        if (msg.name.equals("BUTTON") && msg.info == 2) {
            if (this.cfgClick(this.MW.px, this.MW.py)) {
                return 1;
            }
            msg.name = "MENU";
        }
        if (msg.name.equals("PAINT")) {
            this.paintComponent((GPanelSetup)this.MW, (Graphics)msg.data);
        } else if (msg.name.equals("RESIZE")) {
            this.resize();
        } else if (msg.name.equals("POINTER")) {
            int cdir;
            int i = this.selLine(this.MW.px, this.MW.py);
            int n = cdir = i > 0 && msg.info != -9 ? this.line[i].dir : 0;
            if (cdir != this.cursorDir) {
                this.setResizeCursor(cdir);
            }
            this.cursorDir = cdir;
            this.hovPane(this.MW.px, this.MW.py);
        } else if (msg.name.equals("DRAG")) {
            MBox box = (MBox)msg.data;
            if (this.dragline == 0) {
                this.dragline = this.selLine(box.x, box.y);
            }
            if (this.dragline > 0) {
                this.movLine(this.dragline, box.x + box.w, box.y + box.h);
            }
            if (this.dragline == -1) {
                this.movScroll(box.y + box.h);
            }
        } else if (msg.name.equals("DRAGBOX")) {
            MBox box = (MBox)msg.data;
            if (msg.info == 1 && this.dragline > 0) {
                this.movLine(this.dragline, box.x + box.w, box.y + box.h);
            }
            this.dragline = 0;
        } else if (msg.name.equals("BUTTON")) {
            int i = this.selLine(this.MW.px, this.MW.py);
            if (i == 0) {
                int[] paneButton = this.selPane(this.MW.px, this.MW.py);
                if (paneButton[0] != 0) {
                    boolean isCtrl = false;
                    if (msg.data instanceof MouseEvent) {
                        MouseEvent me = (MouseEvent)msg.data;
                        isCtrl = (me.getModifiersEx() & 0x80) != 0;
                    }
                    this.hitPane(paneButton[0], isCtrl, paneButton[1]);
                }
            } else if (i == -1) {
                this.movScroll(this.MW.py);
            } else if (i <= 2 && this.MW.py > this.line[i].y1 && this.MW.py < this.line[i].y1 + 20 || i > 2 && i <= 4 && this.MW.px > this.line[i].x1 && this.MW.px < this.line[i].x1 + 20) {
                this.setToggleBorders(1 << i - 1);
            }
        } else if (msg.name.equals("SHOW")) {
            this.MW.display(msg.info);
        } else if (msg.name.equals("SHOWN")) {
            if (this.MW.status != -2) {
                this.MW.status = msg.info;
            }
            this.sendMessage(msg);
        } else if (msg.name.equals("REFRESH")) {
            this.refresh();
        } else if (msg.name.equals("RESIZE")) {
            this.resize();
        } else if (msg.name.equals("MENU")) {
            new GMenu(this.MW, "Panel", "Configure,Controls,Borders,Options,Theme,Query,Macro,Debug,Exit", 0, 0, this);
        } else if (msg.name.equals("PANEL")) {
            text = msg.getS();
            if (text.equals("CONFIGURE")) {
                text = this.configure > 0 ? "NoModify" : "Modify";
                new GMenu(this.MW, "Panel.cfg", "Setup,Clear,Load,SaveResult,Save," + text, 0, 0, this);
            } else if (text.equals("CONTROLS")) {
                new GMenu(this.MW, "Controls", "Display,Events", 0, 0, this);
            } else if (text.equals("BORDERS")) {
                new GMenu(this.MW, "Borders", bordersList, this.borders, 1024, this);
            } else if (text.equals("OPTIONS")) {
                new GMenu(this.MW, "Options", optionsList, this.options, 1024, this);
            } else if (text.equals("THEME")) {
                new GMenu(this.MW, "Theme", "DeskTop,Default,WoB,GoB,BoW,MnM,Browser,Gear1,Gear2,Gear3,Gear4,Nak", 0, 0, this);
            } else if (text.equals("QUERY")) {
                new GQuery(this.MW, "Query Results", this.MR, 0, (MessageHandler)this);
            } else if (text.equals("MACRO")) {
                new GMenu(this.MW, "Macro", "Run,Pause,End,Registry,Results,Pipes,Commands,Remotes", 0, 0, this);
            } else if (text.equals("DEBUG")) {
                new GMenu(this.MW, "Debug", "Results,PipeMon,MsgMon,Terminal", 0, 0, this);
            } else if (text.equals("EXIT")) {
                msg.name = "EXIT";
                if ((this.exit & 2) != 0) {
                    this.MQ.put(msg);
                }
            }
        } else if (msg.name.equals("MACRO")) {
            text = msg.getS();
            if (this.M.macro != null) {
                if (text.equals("RUN")) {
                    this.M.macro.setPipeMode(4);
                } else if (text.equals("PAUSE")) {
                    this.M.macro.setPipeMode(3);
                } else if (text.equals("END")) {
                    this.M.macro.setPipeMode(5);
                } else if (text.equals("REGISTRY")) {
                    new GQuery(this.MW, "Query Registry", this.M.registry.table, 0, (MessageHandler)this);
                } else if (text.equals("RESULTS")) {
                    new GQuery(this.MW, "Query Results", this.MR, 0, (MessageHandler)this);
                } else if (text.equals("PIPES")) {
                    Table t = Convert.o2t(this.MR.get("RAM"));
                    new GMenu(this.MW, "Pipe", t.getKeyList(), 0, 2, this);
                } else if (text.equals("COMMANDS")) {
                    Table t = Convert.o2t(this.MR.get("REG"));
                    this.filterMode = 1;
                    new GMenu(this.MW, "Command", t.getKeyList(this), 0, 2, this);
                } else if (text.equals("REMOTES")) {
                    Table t = Convert.o2t(this.MR.get("REG"));
                    this.filterMode = 2;
                    new GMenu(this.MW, "Remote", t.getKeyList(this), 0, 2, this);
                }
            }
        } else if (msg.name.equals("DEBUG")) {
            text = msg.getS();
            if (text.equals("RESULTS")) {
                new GQuery(this.MW, "Query Results", this.MR, 0, (MessageHandler)this);
            } else if (text.equals("PIPEMON")) {
                Shell.runCommand(this.M, "GCONTROL,PIPEMON");
            } else if (text.equals("MSGMON")) {
                Shell.runCommand(this.M, "GCONTROL,MSGMON");
            } else if (text.equals("TERMINAL")) {
                Shell.runCommand(this.M, "SHELLGUI/ATTACH/BG/DISPLAY=FRONT");
            }
        } else if (msg.name.equals("PIPE")) {
            text = msg.getS();
            new GQuery(this.MW, "Query " + text, this.M.pipes.get(text), 8, (MessageHandler)this);
        } else if (msg.name.equals("COMMAND") || msg.name.equals("REMOTE")) {
            text = msg.getS();
            new GQuery(this.MW, "Query " + text, this.M.registry.get(text), 0, (MessageHandler)this);
        } else if (msg.name.equals("PANEL.CFG")) {
            text = msg.getS();
            if (text.equals("MODIFY")) {
                if (this.is(16)) {
                    new GAlert(this.MW, "Setup", "Setup is locked, can not modify.", "OK", 1, 0, this, 4);
                } else {
                    this.configure = 1;
                    this.refresh();
                }
            } else if (text.equals("NOMODIFY")) {
                this.configure = 0;
                this.refresh();
            } else if (text.equals("CLEAR")) {
                for (int i = this.npane; i > 0; --i) {
                    this.delPane(i);
                }
                this.npane = 0;
                this.nline = 4;
                this.refresh();
            } else if (text.equals("SETUP")) {
                int nChars = this.getPromptNumChars(80);
                if (this.M.macro != null) {
                    new GPrompt(this.MW, "LoadSetup", "", nChars, 0, this);
                } else {
                    new GAlert(this.MW, "Setup", "No macro available for setup", "OK", 1, 0, this);
                }
            } else if (text.equals("LOAD")) {
                int nChars = this.getPromptNumChars(this.cfgfile.length());
                new GPrompt(this.MW, "LoadFile", this.cfgfile, nChars, 0, this);
            } else if (text.equals("SAVERESULT")) {
                if (this.cfgfile.contains(".mmp") || this.cfgfile.contains(".tbl")) {
                    this.cfgfile = "setupTable";
                }
                int nChars = Math.max(this.getPromptNumChars(this.cfgfile.length()), 25);
                new GPrompt(this.MW, "SaveTableResult", this.cfgfile, nChars, 0, this);
            } else if (text.equals("SAVE")) {
                if (this.tsetup) {
                    if (!this.cfgfile.endsWith(".tbl")) {
                        this.setConfigFileName(2);
                    }
                } else {
                    this.setConfigFileName(1);
                }
                int nChars = Math.max(this.getPromptNumChars(this.cfgfile.length()), 25);
                new GPrompt(this.MW, "SaveFile", this.cfgfile, nChars, 0, this);
            }
        } else if (msg.name.equals("CFG.ADD")) {
            text = msg.getS();
            if (text.equals("HLINE")) {
                this.addLine(2, this.cfgx, this.cfgy);
            } else if (text.equals("VLINE")) {
                this.addLine(1, this.cfgx, this.cfgy);
            } else if (text.equals("HLINEX")) {
                this.addLine(-2, this.cfgx, this.cfgy);
            } else if (text.equals("VLINEX")) {
                this.addLine(-1, this.cfgx, this.cfgy);
            } else if (text.equals("PANE")) {
                this.addPane(0, this.cfgx, this.cfgy);
            }
            this.configure = 1;
        } else if (msg.name.equals("THEME")) {
            int i;
            String themeName = msg.getS();
            this.MW.setTheme(themeName, this.inline);
            this.theme = this.MW.theme;
            for (i = 1; i <= this.nwidget; ++i) {
                if (this.widget[i].hasLocalTheme()) continue;
                this.widget[i].setTheme(this.MW.theme);
            }
            for (i = 1; i <= this.npane; ++i) {
                this.pane[i].setTheme(this.MW.theme);
            }
            this.resize();
            this.refreshAll();
        } else if (msg.name.equals("CONTROLS")) {
            text = msg.getS();
            if (text.equals("DISPLAY")) {
                this.borders ^= 1;
                this.resize();
                this.refresh();
            } else if (text.equals("EVENTS")) {
                new GMenu(this.MW, "Events", "NoMouse,NoKeyBoard,NoIconify,NoMove,NoRefresh,NoPushPop,NoMiddleMouse", this.eventFilter, 1024, this);
            }
        } else if (msg.name.equals("EVENTS")) {
            this.eventFilter = msg.info;
            for (int i = 1; i <= this.nwidget; ++i) {
                this.widget[i].setEventFilter(this.eventFilter);
            }
        } else if (msg.name.equals("BORDERS")) {
            this.setBorders(msg.info);
        } else if (msg.name.equals("OPTIONS")) {
            this.options = msg.info;
            this.refresh();
        } else if (msg.name.equals("LOADSETUP")) {
            String cfgfile = this.M.macro.getFileName() + "p" + msg.getS();
            this.load(cfgfile);
            this.resize();
            this.refresh();
        } else if (msg.name.equals("LOADSETUPTABLE")) {
            this.setSetupTable(Convert.o2t(msg.data));
            this.resize();
            this.refresh();
        } else if (msg.name.equals("LOADFILE")) {
            this.load(msg.getS());
            this.resize();
            this.refresh();
        } else if (msg.name.equals("SAVEFILE")) {
            this.save(msg.getS());
        } else if (msg.name.equals("SAVETABLERESULT")) {
            this.saveResult(msg.getS());
        } else if (msg.name.equals("SAVETABLEFILE")) {
            this.saveSetupTable(msg.getS());
        } else if (msg.name.equals("WINDOW")) {
            if (this.MW.status != 1 && "DEICONIFIED".equals(msg.data)) {
                this.MW.display(1);
            } else if (this.MW.status != -1 && "ICON".equals(msg.data)) {
                this.MW.display(-1);
            }
            if (this.wmsgid == null) {
                if ((this.exit & 8) != 0 && "CLOSING".equals(msg.data) && this.M.macro != null) {
                    this.M.macro.setPipeMode(5);
                }
            } else {
                this.sendWMessage(msg);
            }
        } else if (msg.name.equals("EXIT")) {
            if ((this.exit & 4) != 0) {
                return 9;
            }
        } else if (msg.name.equals("CURSOR")) {
            this.setCursor(msg.data.toString());
        }
        return 0;
    }

    private int getPromptNumChars(int desiredNumChars) {
        int panelWidth = this.MW.panel.getWidth();
        int charWidth = this.MW.fm.charWidth('W');
        int maxChars = Math.max(10, panelWidth / charWidth - 17);
        int numChars = Math.min(desiredNumChars, maxChars);
        return numChars;
    }

    private boolean cfgClick(int x, int y) {
        if (this.configure != 1) {
            return false;
        }
        int i = this.selLine(x, y);
        if (i > 4) {
            Line l = this.line[i];
            new GMenu(this.MW, "Cfg.Line", "Cancel,Extend,Shrink,Fix,UnFix,Delete", 1, 0, l);
            return true;
        }
        int[] paneButton = this.selPane(x, y);
        i = paneButton[0];
        int buttonSelected = paneButton[1];
        if (buttonSelected == 0 && i > 0) {
            Pane p = this.pane[i];
            this.cfgx = x;
            this.cfgy = y;
            new GMenu(this.MW, "Cfg.Pane", "Cancel,TitleText,TitleColor,TitleSize,Attach,Delete,AddTab", 1, 0, p);
            return true;
        }
        if (x < this.line[1].x2) {
            return false;
        }
        this.cfgx = x;
        this.cfgy = y;
        new GMenu(this.MW, "Cfg.Add", "Cancel,Vline,HLine,VLineX,HLineX,Pane", 1, 0, this);
        return true;
    }

    public void setEventFilter(String mask) {
        int ef = 0;
        ef = mask.equals("ENABLE") ? 0 : (mask.equals("DISABLE") ? -1 : Parser.mask(eventFilterList, mask, this.eventFilter));
        for (int i = 1; i <= this.nwidget; ++i) {
            this.widget[i].setEventFilter(ef);
        }
        this.eventFilter = ef;
    }

    public String getEventFilter() {
        return Parser.mask2s(eventFilterList, this.eventFilter);
    }

    public void setOptions(String mask) {
        this.options = Parser.mask(optionsList, mask, this.options);
        this.resize();
        this.refresh();
    }

    private void sendWMessage(Message msg) {
        if (this.wmsgid instanceof MessageHandler) {
            if (this.wmsgid == msg.from) {
                return;
            }
            msg.to = this.wmsgid;
            msg.from = this;
            ((MessageHandler)this.wmsgid).processMessage(msg);
        }
    }

    private int getix(int il) {
        Line l = this.line[il];
        float x = l.rx;
        int i1 = this.line[1].x2 - 3;
        int i2 = this.line[2].x1 + 3;
        int wx1 = 0;
        int wx2 = this.MW.pos.w;
        if (il > 4) {
            if (l.i1 == 0 && (this.borders & 0x10) != 0) {
                i1 = wx1;
            }
            if (l.i1 == 0 && (this.borders & 0x20) != 0) {
                i2 = wx2;
            }
            if (l.i2 == 0 && (this.borders & 0x40) != 0) {
                i1 = wx1;
            }
            if (l.i2 == 0 && (this.borders & 0x80) != 0) {
                i2 = wx2;
            }
        }
        return (int)(x * (float)(i2 - i1)) + i1;
    }

    private int getiy(int il) {
        Line l = this.line[il];
        float y = l.ry;
        int i1 = this.line[3].y2 - 3;
        int i2 = this.line[4].y1 + 3;
        int wy1 = this.ytop;
        int wy2 = this.MW.pos.h;
        if (il > 4) {
            if (l.i1 == 0 && (this.borders & 0x10) == 0) {
                i1 = wy1;
            }
            if (l.i1 == 0 && (this.borders & 0x40) == 0) {
                i2 = wy2;
            }
            if (l.i2 == 0 && (this.borders & 0x20) == 0) {
                i1 = wy1;
            }
            if (l.i2 == 0 && (this.borders & 0x80) == 0) {
                i2 = wy2;
            }
        }
        return (int)(y * (float)(i2 - i1)) + i1;
    }

    private float getrx(int x, int y) {
        int i1 = this.line[1].x2 - 3;
        int i2 = this.line[2].x1 + 3;
        int wx1 = 0;
        int wx2 = this.MW.pos.w;
        if ((this.borders & 0x10) != 0 && y < this.line[3].y1) {
            i1 = wx1;
        }
        if ((this.borders & 0x20) != 0 && y < this.line[3].y1) {
            i2 = wx2;
        }
        if ((this.borders & 0x40) != 0 && y > this.line[4].y2) {
            i1 = wx1;
        }
        if ((this.borders & 0x80) != 0 && y > this.line[4].y2) {
            i2 = wx2;
        }
        return (float)(x - i1) / (float)Math.max(1, i2 - i1);
    }

    private float getry(int x, int y) {
        int i1 = this.line[3].y2 - 3;
        int i2 = this.line[4].y1 + 3;
        int wy1 = this.ytop;
        int wy2 = this.MW.pos.h;
        if ((this.borders & 0x10) == 0 && x < this.line[1].x1) {
            i1 = wy1;
        }
        if ((this.borders & 0x40) == 0 && x < this.line[1].x1) {
            i2 = wy2;
        }
        if ((this.borders & 0x20) == 0 && x > this.line[2].x2) {
            i1 = wy1;
        }
        if ((this.borders & 0x80) == 0 && x > this.line[2].x2) {
            i2 = wy2;
        }
        return (float)(y - i1) / (float)Math.max(1, i2 - i1);
    }

    private void addLine(int dir, int x, int y) {
        int ii2;
        int ii1;
        int i;
        int i2;
        int i1;
        float ry;
        float rx;
        Line l;
        boolean extend;
        int n = this.nline + 1;
        boolean bl = extend = dir < 0;
        if (extend) {
            dir = -dir;
        }
        this.line[n] = l = new Line();
        l.dir = dir;
        l.rx = rx = this.getrx(x, y);
        l.ry = ry = this.getry(x, y);
        if (dir == 1) {
            if (rx < 0.0f || rx > 1.0f) {
                new GAlert(this.MW, "AddLine", "Must be inside the vertical fixable walls", "OK", 1, 0, this);
                return;
            }
            l.x1 = x - 3;
            l.x2 = x + 3;
            if (extend) {
                i1 = 3;
                i2 = 4;
            } else if (ry < 0.0f) {
                i1 = 0;
                i2 = 3;
            } else if (ry > 1.0f) {
                i1 = 4;
                i2 = 0;
            } else {
                i1 = 3;
                i2 = 4;
                for (i = 5; i <= this.nline; ++i) {
                    ii1 = this.line[i].i1;
                    ii2 = this.line[i].i2;
                    if (this.line[i].dir == 2 && this.line[ii1].rx < rx && this.line[ii2].rx > rx && this.line[i].ry < ry && this.line[i].ry > this.line[i1].ry) {
                        i1 = i;
                    }
                    if (this.line[i].dir != 2 || !(this.line[ii1].rx < rx) || !(this.line[ii2].rx > rx) || !(this.line[i].ry > ry) || !(this.line[i].ry < this.line[i2].ry)) continue;
                    i2 = i;
                }
            }
            l.i1 = i1;
            l.i2 = i2;
        }
        if (dir == 2) {
            if (ry < 0.0f || ry > 1.0f) {
                new GAlert(this.MW, "AddLine", "Must be inside the horizontal fixable walls", "OK", 1, 0, this);
                return;
            }
            l.y1 = y - 3;
            l.y2 = y + 3;
            if (extend) {
                i1 = 1;
                i2 = 2;
            } else if (rx < 0.0f) {
                i1 = 0;
                i2 = 1;
            } else if (rx > 1.0f) {
                i1 = 2;
                i2 = 0;
            } else {
                i1 = 1;
                i2 = 2;
                for (i = 5; i <= this.nline; ++i) {
                    ii1 = this.line[i].i1;
                    ii2 = this.line[i].i2;
                    if (this.line[i].dir == 1 && this.line[ii1].ry < ry && this.line[ii2].ry > ry && this.line[i].rx < rx && this.line[i].rx > this.line[i1].rx) {
                        i1 = i;
                    }
                    if (this.line[i].dir != 1 || !(this.line[ii1].ry < ry) || !(this.line[ii2].ry > ry) || !(this.line[i].rx > rx) || !(this.line[i].rx < this.line[i2].rx)) continue;
                    i2 = i;
                }
            }
            l.i1 = i1;
            l.i2 = i2;
        }
        this.fixLine(n);
        this.nline = n;
        this.refresh();
    }

    private void addPane(int ip, int x, int y) {
        Pane p = new Pane(this);
        if (ip == 0) {
            for (ip = 1; ip <= this.npane && this.pane[ip] != null; ++ip) {
            }
        }
        this.pane[ip] = p;
        p.iy2 = 0;
        p.iy1 = 0;
        p.ix2 = 0;
        p.ix1 = 0;
        for (int i = 1; i <= this.nline; ++i) {
            if (this.line[i].dir == 1) {
                if (this.line[i].y1 >= y || this.line[i].y2 <= y) continue;
                if (this.line[i].x2 < x && (p.ix1 == 0 || this.line[i].x2 > this.line[p.ix1].x2)) {
                    p.ix1 = i;
                }
                if (this.line[i].x1 <= x || p.ix2 != 0 && this.line[i].x1 >= this.line[p.ix2].x1) continue;
                p.ix2 = i;
                continue;
            }
            if (this.line[i].x1 >= x || this.line[i].x2 <= x) continue;
            if (this.line[i].y2 < y && (p.iy1 == 0 || this.line[i].y2 > this.line[p.iy1].y2)) {
                p.iy1 = i;
            }
            if (this.line[i].y1 <= y || p.iy2 != 0 && this.line[i].y1 >= this.line[p.iy2].y1) continue;
            p.iy2 = i;
        }
        p.name = "PANE" + ip;
        p.title = "Pane " + ip;
        p.ts = 12;
        this.fixPane(ip);
        this.panes.put(p.name, (Object)p);
        this.npane = Math.max(ip, this.npane);
        this.refresh();
    }

    private void delPane(Pane p) {
        for (int i = 1; i <= this.npane; ++i) {
            if (p != this.pane[i]) continue;
            this.delPane(i);
        }
    }

    private void delPane(int i) {
        if (i == 0) {
            return;
        }
        Pane p = this.pane[i];
        if (p == null) {
            return;
        }
        JRootPane rootPane = null;
        if (this.MW.panel instanceof JPanel && p.panel != null && (rootPane = ((JPanel)this.MW.panel).getRootPane()) != null && rootPane.getLayeredPane() != null && p.panel != null) {
            rootPane.getLayeredPane().remove(p.panel);
        }
        if (p.panel != null) {
            this.MW.panel.remove(p.panel);
        }
        --this.npane;
        while (i <= this.npane) {
            this.pane[i] = this.pane[i + 1];
            ++i;
        }
        this.pane[this.npane + 1] = null;
        this.getPanes().remove(p.name);
        this.refresh();
    }

    private void fixPane(int i) {
        int y2;
        Pane p = this.pane[i];
        if (p == null) {
            return;
        }
        int wx1 = 0;
        int wx2 = this.MW.pos.w;
        int wy1 = this.ytop;
        int wy2 = this.MW.pos.h;
        int x1 = p.ix1 == 0 ? wx1 : this.line[p.ix1].x2;
        int x2 = p.ix2 == 0 ? wx2 : this.line[p.ix2].x1;
        int y1 = p.iy1 == 0 ? wy1 : this.line[p.iy1].y2;
        int n = y2 = p.iy2 == 0 ? wy2 : this.line[p.iy2].y1;
        if (p.ix2 == 1) {
            x1 = wx1;
            if (p.iy1 == 3) {
                int n2 = y1 = (this.borders & 0x10) != 0 ? this.line[3].y2 : wy1;
            }
            if (p.iy2 == 4) {
                y2 = (this.borders & 0x40) != 0 ? this.line[4].y1 : wy2;
            }
        } else if (p.ix1 == 2) {
            x2 = wx2;
            if (p.iy1 == 3) {
                int n3 = y1 = (this.borders & 0x20) != 0 ? this.line[3].y2 : wy1;
            }
            if (p.iy2 == 4) {
                y2 = (this.borders & 0x80) != 0 ? this.line[4].y1 : wy2;
            }
        } else if (p.iy2 == 3) {
            y1 = wy1;
            if (p.ix1 == 1) {
                int n4 = x1 = (this.borders & 0x10) == 0 ? this.line[1].x2 : wx1;
            }
            if (p.ix2 == 2) {
                x2 = (this.borders & 0x20) == 0 ? this.line[2].x1 : wx2;
            }
        } else if (p.iy1 == 4) {
            y2 = wy2;
            if (p.ix1 == 1) {
                int n5 = x1 = (this.borders & 0x40) == 0 ? this.line[1].x2 : wx1;
            }
            if (p.ix2 == 2) {
                x2 = (this.borders & 0x80) == 0 ? this.line[2].x1 : wx2;
            }
        }
        p.x = x1;
        p.y = y1 + 3 * p.ts / 2;
        p.w = x2 - p.x;
        p.h = y2 - p.y;
        if (i > 0 && this.mobile != 0) {
            p.w = this.mpad;
            p.h = this.mpad;
        }
        p.hidden = false;
        if (p.ix2 == 1) {
            boolean bl = p.hidden = (this.borders & 1) == 0;
        }
        if (p.ix1 == 2) {
            boolean bl = p.hidden = (this.borders & 2) == 0;
        }
        if (p.iy2 == 3) {
            boolean bl = p.hidden = (this.borders & 4) == 0;
        }
        if (p.iy1 == 4) {
            p.hidden = (this.borders & 8) == 0;
        }
        for (int ip = 1; ip < i; ++ip) {
            Pane pp = this.pane[ip];
            if (pp == null || pp.ix1 != p.ix1 || pp.iy1 != p.iy1 || p.getTabManager() != null) continue;
            if (pp.getTabManager() == null) {
                pp.setTabManager(new TabManager());
            }
            p.setTabManager(pp.getTabManager());
        }
        if (p.panel == null) {
            return;
        }
        if (p.mw != null && p.mw.pushParent != null) {
            return;
        }
        boolean vis = !p.hidden && (p.getTabManager() == null || p.getTabManager().isVisibleTab(p));
        p.panel.setVisible(vis);
        if (vis) {
            p.panel.setBounds(p.x, p.y, p.w, p.h);
        }
    }

    private void hitPane(int i, boolean isCtrl, int buttonSelected) {
        if (buttonSelected != 0 && i != 0) {
            Pane p = this.pane[i];
            if (p != null && p.panel != null) {
                p.panel.setVisible(true);
            }
            if (buttonSelected == -1) {
                if ((this.pushPopIconActions & 1) != 0 && p != null && p.mw != null && p.mw.status != -3) {
                    p.mw.pop(-1, isCtrl && (this.options & 0x80) != 0);
                }
                if ((this.pushPopIconActions & 2) != 0) {
                    Table paneData = new Table();
                    paneData.put("EMBEDDED_COMMAND_ID", (Object)p.mw.getEmbeddedCommandID());
                    paneData.put("PANE", (Object)p);
                    Message msg = new Message("PUSHPOPCLICKED", i, paneData, null, this);
                    this.sendMessage(msg);
                }
            } else if (buttonSelected > 0) {
                String icon = p.iconKeys[buttonSelected - 1];
                Table iconData = new Table("{PANE=" + p.name + ",ICON=" + icon + ",X=" + p.x + ",Y=" + p.y + "}");
                Message msg = new Message("ICONCLICKED", 1, iconData, null, this);
                this.sendMessage(msg);
            } else {
                if ((this.customIconActions & 1) != 0) {
                    Message msg = new Message("EXIT", i, "EXIT", p.mw.getEmbeddedCommandID(), this);
                    this.MQ.put(msg);
                    this.delPane(p);
                    int iconData = this.deleteAppropriateLine(p);
                }
                if ((this.customIconActions & 2) != 0) {
                    Table paneData = new Table();
                    paneData.put("EMBEDDED_COMMAND_ID", (Object)p.mw.getEmbeddedCommandID());
                    paneData.put("PANE", (Object)p);
                    Message msg = new Message("CUSTOMICONCLICKED", i, paneData, null, this);
                    this.sendMessage(msg);
                }
            }
        } else {
            Pane p = this.pane[i];
            if (p.getTabManager() != null) {
                p.makeVisibleTab();
            } else {
                this.resize();
                this.refresh();
            }
        }
    }

    private int deleteAppropriateLine(Pane p) {
        int formerPaneIY2;
        int formerPaneIX1 = p.ix1;
        int formerPaneIX2 = p.ix2;
        int formerPaneIY1 = p.iy1;
        int lineToDelete = formerPaneIY2 = p.iy2;
        int substituteLine = -1;
        boolean delSuccessful = false;
        if (formerPaneIY2 > 4 && (substituteLine = this.lineBelow(formerPaneIY2)) > 0) {
            delSuccessful = this.delLine(lineToDelete);
        }
        if (!(substituteLine >= 0 && delSuccessful || formerPaneIY1 <= 4 || (substituteLine = this.lineAbove(lineToDelete = formerPaneIY1)) <= 0)) {
            delSuccessful = this.delLine(lineToDelete);
        }
        if (!(substituteLine >= 0 && delSuccessful || formerPaneIX2 <= 4 || (substituteLine = this.lineToRight(lineToDelete = formerPaneIX2)) <= 0)) {
            delSuccessful = this.delLine(lineToDelete);
        }
        if (!(substituteLine >= 0 && delSuccessful || formerPaneIX1 <= 4 || (substituteLine = this.lineToLeft(lineToDelete = formerPaneIX1)) <= 0)) {
            this.delLine(lineToDelete);
        }
        if (substituteLine < 0 || !delSuccessful) {
            lineToDelete = -1;
        }
        return lineToDelete;
    }

    private boolean doAllPanesReferenceLineOnSameSide(int[][] paneReferences) {
        boolean sameSide = true;
        if (paneReferences.length > 1) {
            int side = paneReferences[0][1];
            for (int i = 1; i < paneReferences.length; ++i) {
                if (paneReferences[i][1] == side) continue;
                return false;
            }
        }
        return sameSide;
    }

    private void updateTabs() {
        this.resize();
        this.refresh();
    }

    private void movScroll(int y) {
        int y2 = this.line[1].y2 - 8;
        int y1 = y2 - this.vScroll;
        double f = (double)(y - y1) / (double)(y2 - y1);
        int i = (int)(f * (double)this.nwidget);
        if (this.setScroll(i)) {
            this.layout();
        }
    }

    private boolean setScroll(int i) {
        if (i == this.iScroll) {
            return false;
        }
        this.iScroll = i;
        return true;
    }

    private void setLine(int i, int dir, int fp, float rx, float ry, int i1, int i2) {
        this.line[i].dir = dir;
        this.line[i].fp = fp;
        this.line[i].rx = rx;
        this.line[i].ry = ry;
        this.line[i].i1 = i1;
        this.line[i].i2 = i2;
        if (dir == 1) {
            this.line[i].y1 = this.ytop;
            this.line[i].y2 = this.MW != null ? this.MW.pos.h : 0;
            this.line[i].x1 = this.line[i].x2 = this.getix(i);
        } else {
            this.line[i].x1 = 0;
            this.line[i].x2 = this.MW != null ? this.MW.pos.w : 0;
            this.line[i].y1 = this.line[i].y2 = this.getiy(i);
        }
    }

    private void delLine(Line l) {
        for (int i = 1; i <= this.nline; ++i) {
            boolean lineDeleted;
            if (l != this.line[i] || (lineDeleted = this.delLine(i))) continue;
            this.M.warning("Line can not be deleted because it is inbetween two active Panes");
        }
    }

    private boolean delLine(int i) {
        int j;
        int replacementLine;
        int[][] panesThatRef = this.findPaneReferencesToLine(i);
        if (panesThatRef.length == 1) {
            replacementLine = this.replacePaneLine(i, this.pane[panesThatRef[0][0]], panesThatRef[0][1]);
        } else if (panesThatRef.length > 1) {
            if (this.doAllPanesReferenceLineOnSameSide(panesThatRef)) {
                replacementLine = this.replacePaneLine(i, this.pane[panesThatRef[0][0]], panesThatRef[0][1]);
                for (j = 1; j < panesThatRef.length; ++j) {
                    this.replacePaneLine(i, this.pane[panesThatRef[j][0]], panesThatRef[j][1]);
                }
                for (j = 1; j <= this.nline; ++j) {
                    this.replaceLineReference(i, replacementLine, j);
                }
            } else {
                return false;
            }
        }
        for (j = 1; j <= this.npane; ++j) {
            if (this.pane[j].ix1 >= i) {
                --this.pane[j].ix1;
            }
            if (this.pane[j].ix2 >= i) {
                --this.pane[j].ix2;
            }
            if (this.pane[j].iy1 >= i) {
                --this.pane[j].iy1;
            }
            if (this.pane[j].iy2 < i) continue;
            --this.pane[j].iy2;
        }
        for (j = 5; j <= this.nline; ++j) {
            if (this.line[j].i1 >= i) {
                --this.line[j].i1;
            }
            if (this.line[j].i2 < i) continue;
            --this.line[j].i2;
        }
        for (j = i; j < this.nline; ++j) {
            this.line[j] = this.line[j + 1];
        }
        --this.nline;
        this.resize();
        this.refresh();
        return true;
    }

    private int[][] findPaneReferencesToLine(int i) {
        int p;
        int[][] paneRefs = new int[this.npane][2];
        int numRefs = 0;
        if (this.line[i].dir == 2) {
            for (p = 0; p <= this.npane; ++p) {
                if (this.pane[p].iy1 == i) {
                    paneRefs[numRefs][0] = p;
                    paneRefs[numRefs++][1] = 4;
                    continue;
                }
                if (this.pane[p].iy2 != i) continue;
                paneRefs[numRefs][0] = p;
                paneRefs[numRefs++][1] = 8;
            }
        } else if (this.line[i].dir == 1) {
            for (p = 0; p <= this.npane; ++p) {
                if (this.pane[p].ix1 == i) {
                    paneRefs[numRefs][0] = p;
                    paneRefs[numRefs++][1] = 1;
                    continue;
                }
                if (this.pane[p].ix2 != i) continue;
                paneRefs[numRefs][0] = p;
                paneRefs[numRefs++][1] = 2;
            }
        }
        int[][] actualPaneRefs = new int[numRefs][];
        System.arraycopy(paneRefs, 0, actualPaneRefs, 0, numRefs);
        return actualPaneRefs;
    }

    private int replacePaneLine(int i, Pane paneWithReference, int howBordersPane) {
        int replacementLine = -1;
        if (howBordersPane == 4) {
            int lineClosestAbove = this.lineAbove(i);
            if (lineClosestAbove >= 0) {
                paneWithReference.iy1 = replacementLine = lineClosestAbove;
            }
        } else if (howBordersPane == 8) {
            int lineClosestBelow = this.lineBelow(i);
            if (replacementLine < 0) {
                paneWithReference.iy2 = replacementLine = lineClosestBelow;
            }
        } else if (howBordersPane == 1) {
            int lineClosestOnLeft = this.lineToLeft(i);
            if (lineClosestOnLeft >= 0) {
                paneWithReference.ix1 = replacementLine = lineClosestOnLeft;
            }
        } else if (howBordersPane == 2) {
            int lineClosestOnRight = this.lineToRight(i);
            if (replacementLine < 0 && lineClosestOnRight >= 0) {
                paneWithReference.ix2 = replacementLine = lineClosestOnRight;
            }
        }
        return replacementLine;
    }

    private int replaceLineReference(int lineBeingReplaced, int replacementLine, int lineThatMayNeedReferencesChanged) {
        int indexReplaced = -1;
        if (this.line[lineThatMayNeedReferencesChanged].i1 == lineBeingReplaced) {
            this.line[lineThatMayNeedReferencesChanged].i1 = replacementLine;
            indexReplaced = 1;
        } else if (this.line[lineThatMayNeedReferencesChanged].i2 == lineBeingReplaced) {
            this.line[lineThatMayNeedReferencesChanged].i2 = replacementLine;
            indexReplaced = 2;
        }
        return indexReplaced;
    }

    private int lineAbove(int indexHorizontalLine) {
        if (indexHorizontalLine > this.nline || this.line[indexHorizontalLine].dir != 2) {
            return -2;
        }
        int lineX1 = this.line[indexHorizontalLine].x1;
        int lineX2 = this.line[indexHorizontalLine].x2;
        int lineY = this.line[indexHorizontalLine].y1;
        int[][] linesAbove = new int[this.nline][2];
        int nLinesAbove = 0;
        for (int j = 0; j <= this.nline; ++j) {
            if (this.line[j].dir != 2 || this.line[j].y1 >= lineY || this.line[j].x1 > lineX1 || this.line[j].x2 < lineX2) continue;
            linesAbove[nLinesAbove][0] = j;
            linesAbove[nLinesAbove][1] = this.line[j].y1;
            ++nLinesAbove;
        }
        if (nLinesAbove == 0) {
            return -1;
        }
        int closestAbove = 0;
        for (int c = 1; c < nLinesAbove; ++c) {
            if (linesAbove[c][1] <= linesAbove[closestAbove][1]) continue;
            closestAbove = c;
        }
        return linesAbove[closestAbove][0];
    }

    private int lineBelow(int indexHorizontalLine) {
        if (indexHorizontalLine > this.nline || this.line[indexHorizontalLine].dir != 2) {
            return -2;
        }
        int lineX1 = this.line[indexHorizontalLine].x1;
        int lineX2 = this.line[indexHorizontalLine].x2;
        int lineY = this.line[indexHorizontalLine].y1;
        int[][] linesBelow = new int[this.nline][2];
        int nLinesBelow = 0;
        for (int j = 0; j <= this.nline; ++j) {
            if (this.line[j].dir != 2 || this.line[j].y1 <= lineY || this.line[j].x1 > lineX1 || this.line[j].x2 < lineX2) continue;
            linesBelow[nLinesBelow][0] = j;
            linesBelow[nLinesBelow][1] = this.line[j].y1;
            ++nLinesBelow;
        }
        if (nLinesBelow == 0) {
            return -1;
        }
        int closestAbove = 0;
        for (int c = 1; c < nLinesBelow; ++c) {
            if (linesBelow[c][1] >= linesBelow[closestAbove][1]) continue;
            closestAbove = c;
        }
        return linesBelow[closestAbove][0];
    }

    private int lineToLeft(int indexVerticalLine) {
        if (indexVerticalLine > this.nline || this.line[indexVerticalLine].dir != 1) {
            return -2;
        }
        int lineY1 = this.line[indexVerticalLine].y1;
        int lineY2 = this.line[indexVerticalLine].y2;
        int lineX = this.line[indexVerticalLine].x1;
        int[][] linesOnLeft = new int[this.nline][2];
        int nLinesOnLeft = 0;
        for (int j = 0; j <= this.nline; ++j) {
            if (this.line[j].dir != 1 || this.line[j].x1 >= lineX || this.line[j].y1 > lineY1 || this.line[j].y2 < lineY2) continue;
            linesOnLeft[nLinesOnLeft][0] = j;
            linesOnLeft[nLinesOnLeft][1] = this.line[j].x1;
            ++nLinesOnLeft;
        }
        if (nLinesOnLeft == 0) {
            return -1;
        }
        int closestOnLeft = 0;
        for (int c = 1; c < nLinesOnLeft; ++c) {
            if (linesOnLeft[c][1] <= linesOnLeft[closestOnLeft][1]) continue;
            closestOnLeft = c;
        }
        return linesOnLeft[closestOnLeft][0];
    }

    private int lineToRight(int indexVerticalLine) {
        if (indexVerticalLine > this.nline || this.line[indexVerticalLine].dir != 1) {
            return -2;
        }
        int lineY1 = this.line[indexVerticalLine].y1;
        int lineY2 = this.line[indexVerticalLine].y2;
        int lineX = this.line[indexVerticalLine].x1;
        int[][] linesOnRight = new int[this.nline][2];
        int nLinesToRight = 0;
        for (int j = 0; j <= this.nline; ++j) {
            if (this.line[j].dir != 1 || this.line[j].x1 <= lineX || this.line[j].y1 > lineY1 || this.line[j].y2 < lineY2) continue;
            linesOnRight[nLinesToRight][0] = j;
            linesOnRight[nLinesToRight][1] = this.line[j].x1;
            ++nLinesToRight;
        }
        if (nLinesToRight == 0) {
            return -1;
        }
        int closestOnRight = 0;
        for (int c = 1; c < nLinesToRight; ++c) {
            if (linesOnRight[c][1] >= linesOnRight[closestOnRight][1]) continue;
            closestOnRight = c;
        }
        return linesOnRight[closestOnRight][0];
    }

    private void fixLine(int i) {
        Line l = this.line[i];
        int wx1 = 0;
        int wx2 = this.MW.pos.w;
        int wy1 = this.ytop;
        int wy2 = this.MW.pos.h;
        if (i <= 4) {
            int i2;
            int i1;
            if ((this.borders & 1 << i - 1) == 0) {
                i1 = 0;
                i2 = 10;
            } else if (l.fp == 0) {
                i2 = 0;
                i1 = 0;
            } else {
                i1 = l.fp - 4 - 3;
                i2 = l.fp + 3;
            }
            if (i == 1) {
                if (this.is(256)) {
                    i2 = 0;
                    i1 = 0;
                }
                l.x1 = i1;
                l.x2 = i2;
                l.y1 = (this.borders & 0x10) != 0 ? this.line[3].y2 : 0;
                l.y2 = (this.borders & 0x40) != 0 ? this.line[4].y1 : this.MW.pos.h;
            }
            if (i == 2) {
                l.x1 = this.MW.pos.w - i2;
                l.x2 = this.MW.pos.w - i1;
                l.y1 = (this.borders & 0x20) != 0 ? this.line[3].y2 : this.ytop;
                l.y2 = (this.borders & 0x80) != 0 ? this.line[4].y1 : this.MW.pos.h;
            }
            if (i == 3) {
                l.y1 = this.ytop + i1;
                l.y2 = this.ytop + i2;
                l.x1 = (this.borders & 0x10) != 0 ? 0 : this.line[1].x2;
                l.x2 = (this.borders & 0x20) != 0 ? this.MW.pos.w : this.line[2].x1;
            }
            if (i == 4) {
                l.y1 = this.MW.pos.h - i2;
                l.y2 = this.MW.pos.h - i1;
                l.x1 = (this.borders & 0x40) != 0 ? 0 : this.line[1].x2;
                l.x2 = (this.borders & 0x80) != 0 ? this.MW.pos.w : this.line[2].x1;
            }
        } else if (l.dir == 2) {
            l.x1 = l.i1 == 0 ? wx1 : this.getix(l.i1) + 3;
            l.x2 = l.i2 == 0 ? wx2 : this.getix(l.i2) - 3;
            l.y1 = this.getiy(i) - 3;
            l.y2 = this.getiy(i) + 3;
            if (l.i1 == 2) {
                l.x1 += 3;
            }
            if (l.i2 == 1) {
                l.x2 -= 3;
            }
        } else if (l.dir == 1) {
            l.y1 = l.i1 == 0 ? wy1 : this.getiy(l.i1) + 3;
            l.y2 = l.i2 == 0 ? wy2 : this.getiy(l.i2) - 3;
            l.x1 = this.getix(i) - 3;
            l.x2 = this.getix(i) + 3;
            if (l.i1 == 4) {
                l.y1 += 3;
            }
            if (l.i2 == 3) {
                l.y2 -= 3;
            }
        }
    }

    private void movLine(int i, int x, int y) {
        if (this.is(16)) {
            return;
        }
        Line l = this.line[i];
        x = Math.max(0, Math.min(this.MW.pos.w, x));
        y = Math.max(0, Math.min(this.MW.pos.h, y));
        if (i == 1) {
            l.fp = Math.min(this.MW.pos.w - 1, x);
        } else if (i == 2) {
            l.fp = Math.max(1, this.MW.pos.w - x);
        } else if (i == 3) {
            l.fp = Math.min(this.MW.pos.h - 1, y);
        } else if (i == 4) {
            l.fp = Math.max(1, this.MW.pos.h - y);
        } else if (l.dir == 2) {
            l.ry = this.getry(x, y);
            if (l.fp != 0) {
                l.fp = y;
            }
        } else if (l.dir == 1) {
            l.rx = this.getrx(x, y);
            if (l.fp != 0) {
                l.fp = x;
            }
        }
        if (i >= 1 && i <= 4) {
            this.borders |= 1 << i - 1;
        }
        if (i == 1 && this.curCompress != 0) {
            this.options &= 0xFFFFFFFB;
            this.resize();
            this.refresh();
            this.resize();
            this.refresh();
            this.options |= 4;
        }
        if (this.menuBarEnabled && i == 1 && x <= 0) {
            this.setBorders(this.borders & 0xFFFFFFFE);
        }
        this.resize();
        this.refresh();
    }

    private int selLine(int x, int y) {
        for (int i = 1; i <= this.nline; ++i) {
            Line l = this.line[i];
            if (l == null || x < l.x1 || x > l.x2 || y < l.y1 || y > l.y2) continue;
            if (i == 1 && y > l.y2 - 16 - this.vScroll) {
                return -1;
            }
            if (this.configure <= 0 && i > 4 && this.is(16) || this.configure <= 0 && this.is(64) && ((i == 1 || i == 2) && y > l.y1 + 16 || (i == 3 || i == 4) && x > l.x1 + 16 || i > 4 && l.dir == 2 && Math.abs(x - (l.x1 + l.x2) / 2) > 8 || i > 4 && l.dir == 1 && Math.abs(y - (l.y1 + l.y2) / 2) > 8)) continue;
            return i;
        }
        return 0;
    }

    private int[] selPane(int x, int y) {
        int[] paneButton = new int[]{0, -3};
        for (int i = 1; i <= this.npane; ++i) {
            int hit;
            Pane p = this.pane[i];
            if (p == null || (hit = p.clickHit(x, y)) == -3) continue;
            paneButton[0] = i;
            paneButton[1] = hit;
            break;
        }
        return paneButton;
    }

    private void hovPane(int x, int y) {
        Pane p;
        for (int i = 1; i <= this.npane && ((p = this.pane[i]) == null || p.hoverHit(x, y) < 0); ++i) {
        }
    }

    private void fixWidget(int i, int mode) {
        boolean bar;
        GWidget gw = this.widget[i];
        GLabel gwg = gw.pGroup;
        boolean isLabel = gw instanceof GLabel;
        boolean show = gw.isShow() && (gwg == null || gwg.isShow());
        boolean bl = bar = this.menuBarEnabled && (this.borders & 1) == 0;
        if (this.headless) {
            gw.display(-1);
            return;
        }
        if (gw.rMoved && !this.is(32)) {
            if (!isLabel || !bar) {
                this.setPos2RXY(gw);
            }
            if (!isLabel && gwg != null && !(gwg.rx > 0.0)) {
                if (gw.rx > 0.0) {
                    gw.pDetach = true;
                    gw.setFlag(32, this.inlinx);
                } else if (gw.rx < 0.0) {
                    gw.pDetach = false;
                    gw.setFlag(32, true);
                }
            }
            gw.rMoved = false;
        }
        if (gwg != null) {
            if (isLabel) {
                show &= gwg.getActive() != -1;
            } else if (!gw.pDetach) {
                show &= gwg.getActive() > 0;
                gw.rx = gwg.rx;
            }
        }
        if (gw.rx < 0.0 && !bar && gw.pos.w != this.line[1].x1) {
            gw.setCompression(0);
            gw.setBounds(0, gw.pos.y, this.line[1].x1, gw.pos.h);
        }
        if (i <= this.iScroll && gw.rx < 0.0) {
            show = false;
        }
        if (bar && !isLabel && show && gwg != null && gwg.getStatus() < 0 && gw.rx < 0.0) {
            show = false;
        }
        if (!show && mode > 0) {
            gw.display(-1);
            return;
        }
        if (gw.rx < 0.0) {
            show = (this.borders & 1) != 0 || bar;
        } else if (gw.rx > 1.0) {
            show = (this.borders & 2) != 0;
        } else if (gw.ry < 0.0) {
            show = (this.borders & 4) != 0;
        } else if (gw.ry > 1.0) {
            boolean bl2 = show = (this.borders & 8) != 0;
        }
        if (!show && mode > 0) {
            gw.display(-1);
            return;
        }
        if (gwg != null && gwg != gw && (gwg.rx > 0.0 && gwg.rx < 1.0 || bar) && !gw.pDetach) {
            int x = this.widget[this.iwz0].pos.x;
            int y = this.widget[this.iwz0].pos.y + this.widget[this.iwz0].pos.h;
            int w = this.widget[this.iwz0].pos.w;
            int h = gw.pos.h;
            gw.fixWidth(w);
            gw.setBounds(x, y, w, h);
            this.iwz0 = i;
        } else if (isLabel && bar) {
            gw.pos.w = Math.max(this.widthLabelInMenuBar, gw.pos.w);
            gw.pos.x = this.xbar;
            gw.pos.y = 0;
            this.xbar += gw.pos.w;
            gw.setBounds(gw.pos);
            this.iwz0 = i;
            show = true;
        } else if (gw.rx < 0.0) {
            int x = 0;
            int y = this.bbox[1].y;
            int w = this.line[1].x1;
            gw.fixWidth(w);
            gw.eventFilter = this.needCompress != 0 ? (gw.eventFilter |= 0x10) : (gw.eventFilter &= 0xFFFFFFEF);
            gw.setCompression(this.curCompress);
            int h = gw.pos.h;
            if (this.iwz1 > 0) {
                y = this.widget[this.iwz1].pos.y + this.widget[this.iwz1].pos.h;
            }
            gw.setBounds(x, y, w, h);
            if ((this.borders & 0x40) != 0) {
                show = y + h < this.ybott;
            } else {
                boolean bl3 = show = y + 5 < this.ybott;
            }
            if (show && this.needCompress == 0 && this.prevCompress != 0) {
                gw.refresh();
            }
            this.yleft = y + h;
            ++this.nleft;
            this.iwz1 = i;
            if (isLabel && gwg.getActive() == 1) {
                this.lastOpenedGLabel = gwg;
            }
            if (isLabel && gwg.getActive() == 3) {
                this.lastCollapsableGLabel = gwg;
            }
        } else if (gw.rx > 1.0) {
            int x = this.line[2].x2;
            int y = this.bbox[2].y;
            int w = this.MW.pos.w - this.line[2].x2;
            int h = gw.pos.h;
            if (this.iwz2 > 0) {
                y = this.widget[this.iwz2].pos.y + this.widget[this.iwz2].pos.h;
            }
            gw.fixWidth(w);
            gw.setBounds(x, y, w, h);
            show = y + h < this.bbox[2].y + this.bbox[2].h;
            this.iwz2 = i;
        } else {
            this.setRXY2Pos(gw);
            gw.setBounds(gw.pos);
            if (isLabel) {
                this.iwz0 = i;
            }
        }
        if (mode >= 0) {
            if (show) {
                gw.display(1);
            } else {
                gw.display(-1);
            }
        }
    }

    private void setBorderBoxes() {
        int bx1 = this.line[1].x2;
        int bx2 = this.line[2].x1;
        int by1 = this.line[3].y2;
        int by2 = this.line[4].y1;
        this.bbox[0].setBounds(bx1, by1, bx2 - bx1, by2 - by1);
        bx1 = 0;
        bx2 = this.line[1].x2;
        by1 = this.ytop;
        if ((this.borders & 0x10) != 0) {
            by1 = this.line[3].y2;
        }
        by2 = this.MW.pos.h;
        if ((this.borders & 0x40) != 0) {
            by2 = this.line[4].y1;
        }
        this.bbox[1].setBounds(bx1, by1, bx2 - bx1, by2 - by1);
        bx1 = this.line[2].x1;
        bx2 = this.MW.pos.w;
        by1 = this.ytop;
        if ((this.borders & 0x20) != 0) {
            by1 = this.line[3].y2;
        }
        by2 = this.MW.pos.h;
        if ((this.borders & 0x80) != 0) {
            by2 = this.line[4].y1;
        }
        this.bbox[2].setBounds(bx1, by1, bx2 - bx1, by2 - by1);
        bx1 = 0;
        if ((this.borders & 0x10) == 0) {
            bx1 = this.line[1].x2;
        }
        bx2 = this.MW.pos.w;
        if ((this.borders & 0x20) == 0) {
            bx2 = this.line[2].x1;
        }
        by1 = this.ytop;
        by2 = this.line[3].y2;
        this.bbox[3].setBounds(bx1, by1, bx2 - bx1, by2 - by1);
        bx1 = 0;
        if ((this.borders & 0x40) == 0) {
            bx1 = this.line[1].x2;
        }
        bx2 = this.MW.pos.w;
        if ((this.borders & 0x80) == 0) {
            bx2 = this.line[2].x1;
        }
        by1 = this.line[4].y1;
        by2 = this.MW.pos.h;
        this.bbox[4].setBounds(bx1, by1, bx2 - bx1, by2 - by1);
    }

    private void setPos2RXY(GWidget gw) {
        int i;
        int x = gw.pos.x + gw.pos.w / 2;
        int y = gw.pos.y + gw.pos.h / 2;
        for (i = 0; i < 5 && !this.bbox[i].within(x, y); ++i) {
        }
        if (i == 5) {
            i = 0;
        }
        gw.rx = (double)(x - this.bbox[i].x) / (double)this.bbox[i].w;
        gw.ry = (double)(y - this.bbox[i].y) / (double)this.bbox[i].h;
        gw.pane = null;
        if (i == 0) {
            for (int j = 1; j <= this.npane; ++j) {
                Pane p = this.pane[j];
                if (!p.pos.within(x, y)) continue;
                gw.pane = p;
                int w = this.fixByOffset ? 10000 : p.pos.w;
                int h = this.fixByOffset ? 10000 : p.pos.h;
                gw.rx = (double)(x - p.pos.x) / (double)w;
                gw.ry = (double)(y - p.pos.y) / (double)h;
                break;
            }
        }
        if (i == 1) {
            gw.rx -= 1.0;
        }
        if (i == 2) {
            gw.rx += 1.0;
        }
        if (i == 3) {
            gw.ry -= 1.0;
        }
        if (i == 4) {
            gw.ry += 1.0;
        }
    }

    private void setRXY2Pos(GWidget gw) {
        int i = 0;
        double rx = gw.rx;
        double ry = gw.ry;
        if (rx < 0.0) {
            i = 1;
            rx += 1.0;
        } else if (rx > 1.0) {
            i = 2;
            rx -= 1.0;
        } else if (ry < 0.0) {
            i = 3;
            ry += 1.0;
        } else if (ry > 1.0) {
            i = 4;
            ry -= 1.0;
        }
        MBox pos = gw.pane != null ? ((Pane)gw.pane).pos : this.bbox[i];
        int w = pos.w;
        int h = pos.h;
        if (i == 0 && this.fixByOffset) {
            h = 10000;
            w = 10000;
        }
        gw.pos.x = (int)(rx * (double)w) + pos.x - gw.pos.w / 2;
        gw.pos.y = (int)(ry * (double)h) + pos.y - gw.pos.h / 2;
    }

    private Table configTSetup() {
        String setupTableFileName;
        Table setupTable = this.MA.getTable("/TSETUP", null, 32);
        if (this.M.results.getTable(this.MA.getS("/TSETUP")) != null) {
            this.localResult = true;
        }
        if (setupTable == null) {
            try {
                setupTable = this.M.results.getPrevious().getTable(this.MA.getS("/TSETUP"));
                if (setupTable != null) {
                    this.parentResult = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((setupTableFileName = this.MA.getS("/TSETUP", null)) == null || setupTableFileName.equals("")) {
            this.setConfigFileName(2);
        } else {
            this.cfgfile = setupTableFileName.toLowerCase();
            if (this.M.macro != null) {
                this.titlebar = this.M.macro.name;
            }
        }
        if (setupTable == null) {
            setupTable = Convert.o2t(this.cfgfile, this.M);
        }
        return setupTable;
    }

    private void setConfigFileName(int setupType) {
        if (this.M.macro != null) {
            this.cfgfile = this.M.macro.getFileName();
            this.titlebar = this.M.macro.name;
        } else {
            Args targs = Shell.parseCommand(this.M, this.cfgfile);
            String option = targs.option.toLowerCase();
            this.cfgfile = Macro.getFileName(this.M, this.cfgfile, option);
        }
        if (setupType == 2) {
            this.cfgfile = this.cfgfile.substring(0, this.cfgfile.lastIndexOf(46)) + ".tbl";
        }
        if (setupType == 1) {
            this.cfgfile = this.cfgfile + "p" + this.MA.getS("/SETUP").toLowerCase();
        }
    }

    private void save(String fname) {
        boolean bordersNotDefault;
        boolean menubarMode;
        String text;
        String base = fname.toLowerCase();
        if (base.endsWith(".tbl")) {
            this.saveSetupTable(fname);
            return;
        }
        TextFile tf = new TextFile(this.M, (Object)fname);
        if (!tf.open(34)) {
            this.M.info("Could not open setup file: " + tf.getURL());
            return;
        }
        if (this.MW != null) {
            text = "{TYPE=POS,X=" + this.MW.pos.x + ",Y=" + this.MW.pos.y + ",W=" + this.MW.pos.w + ",H=" + this.MW.pos.h + "}";
            tf.writeln(text);
        }
        boolean bl = menubarMode = this.menuBarEnabled && (this.borders & 1) == 0;
        boolean bl2 = menubarMode ? this.borders != 14 : (bordersNotDefault = this.borders != 15);
        if (bordersNotDefault) {
            text = "{TYPE=BORDERS,MASK=" + Convert.l2x(this.borders) + "}";
            tf.writeln(text);
        }
        for (int il = 1; il <= this.nline; ++il) {
            Line l = this.line[il];
            text = "{TYPE=LINE,INDEX=" + il + ",DIR=" + l.dir + ",X=" + l.rx + ",Y=" + l.ry + ",I1=" + l.i1 + ",I2=" + l.i2 + ",FP=" + l.fp + "}";
            tf.writeln(text);
        }
        for (int ip = 1; ip <= this.npane; ++ip) {
            Pane p = this.pane[ip];
            if (p == null) continue;
            text = "{TYPE=PANE,INDEX=" + ip + ",NAME=" + p.name + ",TITLE=" + p.title + ",TH=" + p.ts + ",IX1=" + p.ix1 + ",IX2=" + p.ix2 + ",IY1=" + p.iy1 + ",IY2=" + p.iy2 + "}";
            tf.writeln(text);
        }
        for (int iw = 1; iw <= this.nwidget; ++iw) {
            GWidget w = this.widget[iw];
            if (w == null || w.pos.x == 0 || w.pGroup != null && w.pGroup != w && !w.pDetach || menubarMode && w instanceof GLabel) continue;
            text = "{TYPE=CPOS,NAME=" + w.label + ",X=" + w.pos.x + ",Y=" + w.pos.y + ",W=" + w.pos.w + ",H=" + w.pos.h + "}";
            tf.writeln(text);
        }
        this.M.info("Saved file to: " + tf.getURL());
        tf.close();
    }

    private void load(String fname) {
        String text;
        TextFile tf = new TextFile(this.M, (Object)fname);
        tf.open(33);
        if (!tf.isOpen) {
            this.M.info("Could not open setup file: " + tf.getURL());
            return;
        }
        while ((text = tf.readProper()) != null) {
            Table t = new Table(text);
            this.loadSetupLine(t);
        }
        tf.close();
        this.widthLabelInMenuBar = this.line[1].fp - 4 - 3;
        if (this.logger && this.line[4].fp == 0) {
            this.line[4].fp = this.dlh;
        }
    }

    private void loadSetupLine(Table t) {
        String type = t.getS("TYPE");
        String name = t.getS("NAME");
        if (name != null && name.equals("LOGGER")) {
            this.addNewLoggerPane = false;
        }
        int i = t.getL("INDEX", 0);
        if (this.mobile > 0) {
            if (type.equals("PANE")) {
                this.addPane(i, t.getS("NAME"), t.getS("TITLE"), t.getS("ID"), 10, 1, 2, 3, 4, 0);
            }
        } else if (type.equals("PANE")) {
            this.addPane(i, t.getS("NAME"), t.getS("TITLE"), t.getS("ID"), t.getL("TH"), t.getL("IX1"), t.getL("IX2"), t.getL("IY1"), t.getL("IY2"), t.getL("FLAG", 0));
        } else if (type.equals("GRID")) {
            this.autoGrid(t);
        } else if (type.equals("LINE")) {
            this.addLine(i, t.getL("DIR"), t.getF("X"), t.getF("Y"), t.getL("I1"), t.getL("I2"), t.getL("FP"), t.getL("FLAG", 0));
        } else if (type.equals("POS")) {
            int xpos = t.getL("X");
            int ypos = t.getL("Y");
            int width = t.getL("W");
            int height = t.getL("H");
            if (!this.headless) {
                Rectangle screenBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
                int maxX = screenBounds.x + screenBounds.width;
                int maxY = screenBounds.y + screenBounds.height;
                if (width > maxX) {
                    width = maxX;
                }
                if (height > maxY) {
                    height = maxY;
                }
                if (xpos + width > maxX) {
                    xpos = maxX - width;
                }
                if (ypos + height > maxY) {
                    ypos = maxY - height;
                }
                this.MW.setBounds(xpos, ypos, width, height);
            }
        } else if (type.equals("CPOS")) {
            MBox pos = new MBox(t.getL("X"), t.getL("Y"), t.getL("W"), t.getL("H"));
            this.cpos.put(name, (Object)pos);
        } else if (type.equals("BORDERS")) {
            this.borders = t.getL("MASK");
        } else {
            this.M.warning("Unknown table type " + type + " in setup file");
        }
    }

    public void setSetupTable(Table t) {
        Table.Iterator iter = t.iterator();
        while (iter.hasNext()) {
            this.loadSetupLine(t.getTable(iter.next().toString(), true));
        }
        this.widthLabelInMenuBar = this.line[1].fp - 4 - 3;
        if (this.logger && this.line[4].fp == 0) {
            this.line[4].fp = this.dlh;
        }
    }

    public Table getSetupTable() {
        boolean bordersNotDefault;
        boolean menubarMode;
        Table tbl = new Table();
        if (this.MW != null) {
            tbl.put("POS", (Object)("{TYPE=POS,X=" + this.MW.pos.x + ",Y=" + this.MW.pos.y + ",W=" + this.MW.pos.w + ",H=" + this.MW.pos.h + "}"));
        }
        boolean bl = menubarMode = this.menuBarEnabled && (this.borders & 1) == 0;
        boolean bl2 = menubarMode ? this.borders != 14 : (bordersNotDefault = this.borders != 15);
        if (bordersNotDefault) {
            tbl.put("BORDERS", (Object)("{TYPE=BORDERS,MASK=" + Convert.l2x(this.borders) + "}"));
        }
        for (int il = 1; il <= this.nline; ++il) {
            Line l = this.line[il];
            tbl.put("LINE_" + il, (Object)("{TYPE=LINE,INDEX=" + il + ",DIR=" + l.dir + ",X=" + l.rx + ",Y=" + l.ry + ",I1=" + l.i1 + ",I2=" + l.i2 + ",FP=" + l.fp + "}"));
        }
        for (int ip = 0; ip <= this.npane; ++ip) {
            Pane p = this.pane[ip];
            if (p == null) continue;
            tbl.put("PANE_" + ip, (Object)("{TYPE=PANE,INDEX=" + ip + ",NAME=" + p.name + ",TITLE=" + p.title + ",TH=" + p.ts + ",IX1=" + p.ix1 + ",IX2=" + p.ix2 + ",IY1=" + p.iy1 + ",IY2=" + p.iy2 + "}"));
        }
        for (int iw = 1; iw <= this.nwidget; ++iw) {
            GWidget w = this.widget[iw];
            if (w == null || w.pos.x == 0 || w.pGroup != null || w.pGroup != w || !w.pDetach || menubarMode && w instanceof GLabel) continue;
            tbl.put("WIDGET_" + iw, (Object)("{TYPE=CPOS,NAME=" + w.label + ",X=" + w.pos.x + ",Y=" + w.pos.y + ",W=" + w.pos.w + ",H=" + w.pos.h + "}"));
        }
        return tbl;
    }

    public void saveResult(String resName) {
        String loc = "";
        if (this.parentResult || !this.parentResult && !this.localResult) {
            this.M.results.getPrevious().put(resName.toUpperCase(), (Object)this.getSetupTable());
            loc = "parent";
        }
        if (this.localResult) {
            this.M.results.put(resName.toUpperCase(), (Object)this.getSetupTable());
            loc = "local";
        }
        this.M.info("Saved result " + resName + " to " + loc + " results table.");
    }

    public void saveSetupTable(String fname) {
        TextFile tf = new TextFile(this.M, (Object)fname);
        tf.open(8194);
        Table.toTextFile(tf, this.getSetupTable(), "");
        tf.close();
        this.M.info("Saved setup table to: " + tf.getURL());
    }

    private void autoGrid(Table t) {
        int iy;
        int ix;
        Data dpx2;
        int nx = t.getL("NX", 4);
        int ny = t.getL("NY", 4);
        int nx2 = t.getL("NX2", nx);
        String name = t.getS("NAME", "GP");
        String title = t.getS("TITLE", "Pane");
        int ts = t.getL("TH", 10);
        String fill = t.getS("FILL", "LRTB");
        Data dpx = t.getData("PX");
        if (dpx != null) {
            dpx = Data.fromString(dpx.toString().replace("|", ","), 'D', this.M);
        }
        if ((dpx2 = t.getData("PX2")) != null) {
            dpx2 = Data.fromString(dpx2.toString().replace("|", ","), 'D', this.M);
        }
        float[] px = new float[nx];
        px[0] = 0.0f;
        float[] px2 = new float[nx2];
        px2[0] = 0.0f;
        for (ix = 0; ix < nx; ++ix) {
            px[ix] = (float)ix / (float)nx;
        }
        for (ix = 0; ix < nx2; ++ix) {
            px2[ix] = (float)ix / (float)nx2;
        }
        if (dpx != null) {
            for (ix = 1; ix < nx; ++ix) {
                px[ix] = px[ix - 1] + (float)dpx.getD(ix - 1);
            }
        }
        if (dpx2 != null) {
            for (ix = 1; ix < nx2; ++ix) {
                px2[ix] = px2[ix - 1] + (float)dpx2.getD(ix - 1);
            }
        }
        this.nline = 4;
        if (nx2 == nx) {
            for (ix = 1; ix < nx; ++ix) {
                this.addLine(-1, 1, px[ix], 0.5f, 3, 4, 0, 0);
            }
            for (iy = 1; iy < ny; ++iy) {
                this.addLine(-1, 2, 0.5f, (float)iy / (float)ny, 1, 2, 0, 0);
            }
        } else {
            for (iy = 1; iy < ny; ++iy) {
                this.addLine(-1, 2, 0.5f, (float)iy / (float)ny, 1, 2, 0, 0);
            }
            for (ix = 1; ix < nx; ++ix) {
                this.addLine(-1, 1, px[ix], 0.5f, 3, 3 + ny, 0, 0);
            }
            for (ix = 1; ix < nx2; ++ix) {
                this.addLine(-1, 1, px2[ix], 0.5f, 3 + ny, 4, 0, 0);
            }
        }
        int ip = 0;
        if (this.mobile == 0) {
            if (nx2 != nx) {
                for (int iy2 = 1; iy2 <= ny; ++iy2) {
                    int iy1 = 3;
                    if (iy2 > 1) {
                        iy1 = 4 + iy2 - 1;
                    }
                    int iy22 = 4;
                    if (iy2 < ny) {
                        iy22 = 4 + iy2;
                    }
                    int nxx = iy2 == ny ? nx2 : nx;
                    for (int ix2 = 1; ix2 <= nxx; ++ix2) {
                        int ix1 = 1;
                        if (ix2 > 1) {
                            ix1 = 4 + ny - 1 + ix2 - 1 + (iy2 == ny ? nx - 1 : 0);
                        }
                        int ix22 = 2;
                        if (ix2 < nxx) {
                            ix22 = 4 + ny - 1 + ix2 + (iy2 == ny ? nx - 1 : 0);
                        }
                        this.addPane(++ip, name + ip, title + ip, this.id + ip, ts, ix1, ix22, iy1, iy22, 0);
                    }
                }
            } else if (fill.equals("TBLR")) {
                for (int ix3 = 1; ix3 <= nx; ++ix3) {
                    int ix1 = 1;
                    if (ix3 > 1) {
                        ix1 = 4 + ix3 - 1;
                    }
                    int ix2 = 2;
                    if (ix3 < nx) {
                        ix2 = 4 + ix3;
                    }
                    for (int iy3 = 1; iy3 <= ny; ++iy3) {
                        int iy1 = 3;
                        if (iy3 > 1) {
                            iy1 = 4 + nx - 1 + iy3 - 1;
                        }
                        int iy2 = 4;
                        if (iy3 < ny) {
                            iy2 = 4 + nx - 1 + iy3;
                        }
                        this.addPane(++ip, name + ip, title + ip, this.id + ip, ts, ix1, ix2, iy1, iy2, 0);
                    }
                }
            } else if (fill.equals("LRTB")) {
                for (int iy4 = 1; iy4 <= ny; ++iy4) {
                    int iy1 = 3;
                    if (iy4 > 1) {
                        iy1 = 4 + nx - 1 + iy4 - 1;
                    }
                    int iy2 = 4;
                    if (iy4 < ny) {
                        iy2 = 4 + nx - 1 + iy4;
                    }
                    for (int ix4 = 1; ix4 <= nx; ++ix4) {
                        int ix1 = 1;
                        if (ix4 > 1) {
                            ix1 = 4 + ix4 - 1;
                        }
                        int ix2 = 2;
                        if (ix4 < nx) {
                            ix2 = 4 + ix4;
                        }
                        this.addPane(++ip, name + ip, title + ip, this.id + ip, ts, ix1, ix2, iy1, iy2, 0);
                    }
                }
            }
        }
        this.gnx = nx;
        this.gny = ny;
    }

    private void updateLastWidget() {
        for (int i = 1; i <= this.nwidget; ++i) {
            GWidget gw = this.widget[i];
            if (gw == null || gw.pGroup == null || i != this.nwidget && !(this.widget[i + 1] instanceof GLabel)) continue;
            gw.pGroup.lastWidget = gw;
            gw.refresh();
        }
    }

    @Override
    public Object addWidget(GWidget gw) {
        if (gw == null) {
            return null;
        }
        if (this.isHideWidgets()) {
            return null;
        }
        if (!this.cntrls.containsKey(gw.label)) {
            this.cntrls.put(gw.label, (Object)gw);
        }
        if (gw instanceof GLabel) {
            this.curGLabel = (GLabel)gw;
        }
        GLabel gwg = this.curGLabel;
        int i = ++this.nwidget;
        if (gw.group != null) {
            for (i = 1; !(i >= this.nwidget || this.widget[i].group != null && this.widget[i].group.equals(gw.group)); ++i) {
            }
            gwg = (GLabel)this.widget[i];
            while (i < this.nwidget && this.widget[i].group.equals(gw.group)) {
                ++i;
            }
            for (int j = this.nwidget; j > i; --j) {
                this.widget[j] = this.widget[j - 1];
            }
        }
        if (gwg != null) {
            gw.pGroup = gwg;
            gw.setGroup(gwg.label);
        }
        this.widget[i] = gw;
        if (!this.widget[i].hasLocalTheme()) {
            gw.setTheme(this.theme);
        }
        gw.setFlag(32, this.inline);
        gw.setWidgetPanel(this);
        MBox pos = (MBox)this.cpos.get(gw.label);
        if (pos != null) {
            gw.pos.setBounds(pos);
            this.setPos2RXY(gw);
            if (gwg != null && gwg.rx < 0.0) {
                gw.pDetach = true;
            }
        } else {
            gw.rx = gwg != null && gw != gwg ? gwg.rx : -1.0;
        }
        gw.MW = this.MW;
        gw.parent = gw.MW;
        if (this.headless) {
            return gw;
        }
        gw.resize(1);
        this.fixWidget(i, -1);
        this.MW.addOn(gw.panel);
        if (gw instanceof GPanel) {
            this.panes.put(gw.label, (Object)gw);
        }
        if (gw instanceof GLabel && this.hbar == 0) {
            this.hbar = gw.pos.h;
        }
        return gw;
    }

    @Override
    public void layoutWidget(GWidget gw) {
        this.needLayout = true;
    }

    @Override
    public boolean accept(Object entry) {
        boolean rmif2 = entry instanceof rmif;
        boolean remote = entry instanceof Rmif.Remote;
        boolean command = entry instanceof Command;
        if (this.filterMode == 1 && command) {
            return true;
        }
        if (this.filterMode == 2 && rmif2) {
            return true;
        }
        return this.filterMode == 2 && remote;
    }

    public double getTimer(int i) {
        if (i < 0 || i >= this.nTimers) {
            throw new MidasException("Invalid timer index = " + i);
        }
        return this.timer[i];
    }

    public void setTimers(int in_nTimers) {
        if (in_nTimers < 0) {
            this.M.error("Invalid number of timers = " + in_nTimers);
        } else {
            this.nTimers = in_nTimers;
            if (this.nTimers == 0) {
                this.timer = null;
                this.timerinit = null;
            } else {
                this.timer = new double[this.nTimers];
                this.timerinit = new double[this.nTimers];
            }
        }
    }

    public void setCursor(String name, double sec) {
        if (this.MW != null) {
            this.MW.setCursor(name, sec);
            if (this.userCursor != null) {
                this.userCursor = this.getCursor();
            }
        } else {
            this.M.warning("PANEL: Can not set cursor, MW is null");
        }
    }

    public void setAltTitle(String title) {
        this.altTitle = title;
    }

    private void refreshTitle() {
        if (this.altTitle == null && this.currentTitle == null) {
            return;
        }
        if (this.altTitle != null && this.currentTitle != null && this.altTitle.equals(this.currentTitle)) {
            return;
        }
        this.currentTitle = this.altTitle;
        ((Frame)this.MW.parent).setTitle(this.currentTitle);
    }

    public void setCursor(String name) {
        if (this.MW != null) {
            this.MW.setCursor(name);
            if (this.userCursor != null) {
                this.userCursor = this.getCursor();
            }
        } else {
            this.M.warning("PANEL: Can not set cursor, MW is null");
        }
    }

    private void setResizeCursor(int dir) {
        if (dir > 0) {
            if (this.userCursor == null) {
                this.userCursor = this.getCursor();
            }
            this.MW.setCursor(dir == 1 ? "WResize" : "SResize");
        } else if (this.userCursor != null) {
            this.MW.setCursor(this.userCursor);
            this.userCursor = null;
        }
    }

    public String getCursor() {
        return this.MW != null ? this.MW.getCursor() : "Default";
    }

    public void setTimer(int i, double value) {
        if (i < 0) {
            this.M.error("Invalid timer index = " + i);
        } else {
            this.timer[i] = value;
            this.timerinit[i] = Time.current();
        }
    }

    public void addWindow(MWindow mw) {
        int n = ++this.npane;
        mw.MW = this.MW;
        if (this.pane[n] == null) {
            this.addPane(n, "" + n, "" + n, "" + n, 10, 1, 2, 3, 4, 0);
        }
        this.pane[n].add(mw);
    }

    private void prepBar() {
        for (int i = 0; i < this.nwidget; ++i) {
            GLabel gwg;
            if (!(this.widget[i] instanceof GLabel) || (gwg = (GLabel)this.widget[i]).getActive() != 1) continue;
            gwg.setActive(0);
        }
    }

    public void setBorders(String str) {
        this.setBorders(Parser.mask(bordersList, str, this.borders));
    }

    public String getBordersString() {
        return Parser.mask2s(bordersList, this.borders);
    }

    public double getBorders() {
        return this.borders;
    }

    public void setBorders(int value) {
        if (this.menuBarEnabled && (value & 1) == 0 && (this.borders & 1) != 0) {
            this.prepBar();
        }
        this.borders = value;
        this.resize();
        this.refresh();
    }

    public void setToggleBorders(int value) {
        this.setBorders(this.borders ^ value);
    }

    public Table getControls() {
        return this.cntrls;
    }

    public Table getPanes() {
        return this.panes;
    }

    public Pane[] getPanesArray() {
        Pane[] pa = new Pane[this.npane + 1];
        for (int i = 0; i <= this.npane; ++i) {
            pa[i] = this.pane[i];
        }
        return pa;
    }

    public ByteArrayOutputStream handleMobileRequest(String name) {
        int iarg = name.indexOf(63);
        if (iarg > 0) {
            Container c;
            Table t = new Table("{" + name.substring(iarg + 1) + "}");
            String type = t.getS("TYPE");
            int x = t.getL("X");
            int y = t.getL("Y");
            int ip = t.getL("IP");
            Container container = c = ip == 0 ? this.MW.panel : this.pane[ip].panel;
            while (c != null) {
                x += c.getLocation().x;
                y += c.getLocation().y;
                c = c.getParent();
            }
            if (type.equals("MOVE")) {
                this.robot.mouseMove(x, y);
            } else if (type.equals("PRESS")) {
                int bm;
                this.robot.mouseMove(x, y);
                int bu = t.getL("B");
                int ab = Math.abs(bu);
                int n = ab == 3 ? 4096 : (bm = ab == 2 ? 2048 : 1024);
                if (bm != this.lbm && this.lbu > 0) {
                    this.robot.mouseRelease(this.lbm);
                }
                if (bu > 0 || this.lbu <= 0) {
                    this.robot.mousePress(bm);
                }
                if (bu < 0) {
                    this.robot.mouseRelease(bm);
                }
                this.lbu = bu;
                this.lbm = bm;
            } else if (type.equals("KEY")) {
                if (this.ldp != ip) {
                    this.robot.mouseMove(x, y);
                    this.robot.mousePress(4096);
                    this.robot.mouseRelease(4096);
                    this.ldp = ip;
                }
                String keys = t.getS("K");
                while (keys.length() > 0) {
                    int ch;
                    int key = ch = keys.charAt(0);
                    if (ch >= 97 && ch <= 122) {
                        key -= 32;
                    }
                    this.robot.keyPress(key);
                    this.robot.keyRelease(key);
                    keys = keys.substring(1);
                }
                int key = 10;
                this.robot.keyPress(key);
                this.robot.keyRelease(key);
            }
            name = name.substring(0, iarg);
        }
        if (name.startsWith("DisplayPane")) {
            int ip = name.charAt(11) - 48;
            Container p = ip == 0 ? this.MW.panel : this.pane[ip].panel;
            Rectangle rect = p.getBounds();
            int x = p.getX();
            int y = p.getY();
            int w = p.getWidth();
            int h = p.getHeight();
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BufferedImage image = new BufferedImage(w, h, 1);
                Graphics gc = image.getGraphics();
                p.paint(gc);
                for (int i = 0; i < this.MW.panel.getComponentCount(); ++i) {
                    Component o = this.MW.panel.getComponent(i);
                    if (!(o instanceof MPanel)) continue;
                    MPanel mp = (MPanel)o;
                    Rectangle r = mp.getBounds();
                    if (!(mp.MW instanceof GWidget) || !rect.contains(r.getX(), r.getY())) continue;
                    gc.translate((int)r.getX() - x, (int)r.getY() - y);
                    mp.paint(gc);
                }
                ImageIO.write((RenderedImage)image, "png", baos);
                return baos;
            }
            catch (Exception e) {
                this.M.printStackTrace("Unable to export image: ", e);
            }
        }
        return null;
    }

    public void addPane(int i, String name, String title, String id, int ts, int ix1, int ix2, int iy1, int iy2, int flags) {
        Pane p;
        if (i < 0) {
            i = this.npane + 1;
        }
        if ((p = this.pane[i]) == null) {
            p = this.pane[i] = new Pane(this);
        }
        p.name = name;
        p.title = title;
        if (this.mobile != 0 && ix1 != 0 && ix2 != 0 && iy1 != 0 && iy2 != 0) {
            p.tag = "" + i;
        }
        p.ts = ts;
        p.ix1 = ix1;
        p.ix2 = ix2;
        p.iy1 = iy1;
        p.iy2 = iy2;
        p.flags = flags;
        this.panes.put(p.name, (Object)p);
        this.npane = Math.max(this.npane, i);
    }

    public void addLine(int i, int dir, float rx, float ry, int i1, int i2, int fp, int flags) {
        Line l;
        if (i < 0) {
            i = this.nline + 1;
        }
        if ((l = this.line[i]) == null) {
            l = new Line();
        }
        l.dir = dir;
        l.rx = rx;
        l.ry = ry;
        l.i1 = i1;
        l.i2 = i2;
        l.fp = fp;
        l.flags = flags;
        this.line[i] = l;
        this.nline = Math.max(this.nline, i);
    }

    public void setIconDir(String s) {
        if (!s.endsWith("/")) {
            s = s + '/';
        }
        this.iconDir = s;
    }

    private Icon getIcon(String fname, int size) {
        try {
            ImageIcon ii = new ImageIcon(this.iconDir + fname);
            Image img = ii.getImage().getScaledInstance(size, size, 4);
            ImageIcon icon = new ImageIcon(img);
            return icon;
        }
        catch (Exception e) {
            throw new MidasException("Symbol: Unable to read '" + fname + "'", e);
        }
    }

    private void loadPanelClass(String className) {
        if (className.trim().length() == 0 && this.M.macro != null) {
            className = this.M.macro.name.toLowerCase();
        }
        String defPkg = "";
        if (this.M.macro != null) {
            defPkg = "nxm." + this.M.macro.option.toLowerCase() + ".mcr.";
        }
        String nameLC = className.toLowerCase();
        String nameTC = className.substring(0, 1).toUpperCase() + nameLC.substring(1);
        String[] names = new String[]{defPkg + className, defPkg + nameLC, defPkg + nameTC, className, nameLC, nameTC};
        Class<?> configClass = null;
        for (int i = 0; i < names.length && configClass == null; ++i) {
            try {
                configClass = Class.forName(names[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (configClass == null) {
            this.M.warning("Unable to load panel class '" + className + "': Class not found.");
        } else {
            try {
                final Macro mh = this.M.macro;
                Object config = configClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                final Message closeMsg = new Message("WINDOW", 0, "CLOSING", config, this);
                WindowAdapter listener = new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        mh.processMessage(closeMsg);
                    }
                };
                this.loadDisplays(configClass.getDeclaredFields(), config, true);
                if (config instanceof Frame) {
                    Frame frame = (Frame)config;
                    this.container = frame;
                    frame.addWindowListener(listener);
                    frame.setVisible(true);
                    this.MW.parent = frame;
                } else if (config instanceof Container) {
                    this.container = (Container)config;
                    this.container.setVisible(true);
                    this.MW.panel = this.container;
                } else {
                    this.M.warning("Class loaded with /JSETUP is a " + Util.getClassName(config) + ", expected a AWT/Swing container");
                    if (config instanceof Component) {
                        ((Component)config).setVisible(true);
                    }
                }
            }
            catch (Exception e) {
                this.M.printStackTrace("Unable to load panel class '" + className + "'", e);
            }
        }
    }

    private void loadDisplays(Field[] fields, Object config, boolean noPublic) throws Exception {
        Object value;
        AccessibleObject.setAccessible(fields, true);
        Macro mh = this.M.macro;
        Object to = null;
        panel from = this;
        HashMap<Object, String> controls = new HashMap<Object, String>();
        HashMap<String, Object> groups = new HashMap<String, Object>();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName().toUpperCase();
            value = fields[i].get(config);
            if (name.equals("PANE0")) {
                if (value instanceof MidasControls) {
                    this.ctlPane = (MidasControls)value;
                    this.ctlPane.setMWindow(this.MW);
                    continue;
                }
                this.M.error("PANE0 must be an instance of MidasControls.");
                continue;
            }
            if (value instanceof PushPopPanel) {
                PushPopPanel ppp = (PushPopPanel)value;
                this.getPanes().put(name, (Object)ppp.getMidasDisplay());
                continue;
            }
            if (value instanceof MidasDisplay) {
                ((MidasDisplay)value).setMWindow(this.MW);
                this.getPanes().put(name, value);
                continue;
            }
            if (value != null && value.getClass().getName().equals("nxm.sys.libxm.XmDisplay")) {
                if (this.xmCanvasTbl == null) {
                    this.xmCanvasTbl = new Table();
                }
                if (name.toUpperCase().startsWith("XS") && StringUtil.isInteger(name.substring(2))) {
                    this.xmCanvasTbl.put(name, value);
                    continue;
                }
                this.M.error("Illegal name for an XmCanvas, given '" + name + "'. Must use name in the form xsN where N is the value of /XS=. For example use the name xs3 for /XS=3.");
                continue;
            }
            if (value instanceof ButtonGroup) {
                groups.put(name, value);
                continue;
            }
            if (value instanceof JPanel) {
                JPanel jpanel = (JPanel)value;
                MouseAdapter mouseListener = new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        if (evt.getButton() == 2) {
                            panel.this.processMessage("BUTTON", 2, evt);
                        }
                    }
                };
                jpanel.addMouseListener(mouseListener);
                continue;
            }
            if (value instanceof Widget) {
                controls.put(value, name);
                continue;
            }
            if (!(value instanceof Component)) continue;
            controls.put(value, name);
        }
        for (Map.Entry e : groups.entrySet()) {
            String name = (String)e.getKey();
            Object value2 = e.getValue();
            if (!(value2 instanceof ButtonGroup)) continue;
            Enumeration<AbstractButton> buttons = ((ButtonGroup)value2).getElements();
            while (buttons.hasMoreElements()) {
                AbstractButton button = buttons.nextElement();
                String btnName = (String)controls.remove(button);
                this.cntrls.put(name, (Object)new WidgetWrapper(button, (MessageHandler)mh, name, (Object)btnName, to, (Object)from));
            }
        }
        for (Map.Entry e : controls.entrySet()) {
            value = e.getKey();
            String name = (String)e.getValue();
            WidgetWrapper w = value instanceof Widget ? new WidgetWrapper((Widget)value, (MessageHandler)mh, name, null, to, (Object)from) : new WidgetWrapper((Component)value, (MessageHandler)mh, name, null, to, (Object)from);
            this.cntrls.put(name, (Object)w);
        }
    }

    public MidasControls getMidasControls() {
        return this.ctlPane;
    }

    private boolean isHideWidgets() {
        return this.container != null && this.ctlPane == null && this.hideWidget;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public class TabManager {
        private List<Object> panes = new LinkedList<Object>();
        private int visiblePane = 0;

        private TabManager() {
        }

        public synchronized void addTab(Pane pane) {
            this.panes.add(pane);
        }

        public synchronized void setVisibleTab(int index) {
            if (panel.this.is(1)) {
                Object pane = this.panes.get(index);
                this.panes.remove(index);
                this.panes.add(0, pane);
                this.visiblePane = 0;
            } else {
                this.visiblePane = index;
            }
        }

        public synchronized void setVisibleTab(Pane pane) {
            this.setVisibleTab(this.getTabIndex(pane));
        }

        public synchronized void setNonVisibleTab(Pane pane) {
            if (this.isVisibleTab(pane)) {
                if (panel.this.is(1)) {
                    this.setVisibleTab(1);
                } else {
                    int paneIndex = this.getTabIndex(pane) + 1;
                    if (paneIndex < this.getTabCount()) {
                        this.setVisibleTab(paneIndex);
                    } else {
                        this.setVisibleTab(0);
                    }
                }
            }
        }

        public synchronized Pane getVisibleTab() {
            return (Pane)this.panes.get(this.visiblePane);
        }

        public synchronized boolean isVisibleTab(Pane pane) {
            return pane == this.getVisibleTab();
        }

        public synchronized int getTabIndex(Pane pane) {
            return this.panes.indexOf(pane);
        }

        public synchronized int getTabCount() {
            return this.panes.size();
        }
    }

    public class Pane
    implements MessageHandler {
        private final panel pan;
        public String name;
        public String title;
        public String tag;
        public MWindow MW;
        public MWindow mw;
        public Container panel;
        public int ix1 = 1;
        public int ix2 = 2;
        public int iy1 = 3;
        public int iy2 = 4;
        public int x;
        public int y;
        public int w;
        public int h;
        public int ts = 0;
        public int flags = 0;
        public boolean hidden = false;
        public TabManager tabManager = null;
        public MBox pos = new MBox();
        private String[] iconKeys;
        private Icon[] icons;
        private int[] iconOffs;
        private int nicons = 0;
        private int iconCur = 0;

        @Deprecated
        public Pane(MWindow MW) {
            this.MW = MW;
            this.pan = null;
        }

        Pane(panel p, String title) {
            this(p);
            this.title = title;
        }

        Pane(panel p) {
            this.pan = p;
            this.MW = p.MW;
        }

        public void setIconBar(String s) {
            int ioff;
            Parser p = new Parser(s);
            this.nicons = p.elements();
            this.iconKeys = new String[this.nicons];
            this.iconOffs = new int[this.nicons + 1];
            this.icons = s.indexOf(59) > 0 ? new Icon[this.nicons] : null;
            int tw = this.MW.fm != null ? this.MW.fm.charWidth('0') : 8;
            this.iconOffs[0] = ioff = this.ts;
            for (int i = 0; i < this.nicons; ++i) {
                String key = p.get(i + 1);
                int ic = key.indexOf(59);
                if (ic > 0) {
                    this.icons[i] = panel.this.getIcon(key.substring(ic + 1), this.ts);
                    key = key.substring(0, ic);
                    ioff += 6 * this.ts / 4;
                } else {
                    ioff += key.length() * tw + this.ts;
                }
                this.iconKeys[i] = key;
                this.iconOffs[i + 1] = ioff;
            }
            this.iconCur = 0;
            this.refresh();
        }

        private void setTabManager(TabManager mgr) {
            this.tabManager = mgr;
            mgr.addTab(this);
        }

        private TabManager getTabManager() {
            return this.tabManager;
        }

        public boolean isInTab() {
            return this.getTabManager() != null;
        }

        public boolean isVisibleTab() {
            return this.isInTab() && this.getTabManager().isVisibleTab(this);
        }

        public void makeVisibleTab() {
            if (this.isInTab() && !this.isVisibleTab()) {
                this.getTabManager().setVisibleTab(this);
                panel.this.updateTabs();
            }
        }

        public void makeNonVisibleTab() {
            Shell.warning("Pane.makeNonVisibleTab() does not work for all pane types.");
            if (this.isInTab() && this.isVisibleTab()) {
                this.getTabManager().setNonVisibleTab(this);
                panel.this.updateTabs();
            }
        }

        public void setTitle(String value) {
            this.title = value;
            this.refresh();
        }

        public void setTS(int value) {
            if (panel.this.mobile == 0) {
                this.ts = value;
            }
            this.refresh();
        }

        public void setTheme(String value) {
            if (this.mw != null) {
                this.mw.setTheme(value);
            }
        }

        public void setTheme(Object value) {
            if (this.mw != null) {
                this.mw.setTheme(value);
            }
        }

        public void add(MWindow mw) {
            this.mw = mw;
            this.add(mw.panel);
        }

        public void add(Container panel2) {
            this.panel = panel2;
            if (panel2 != null) {
                panel2.setBounds(this.x, this.y, this.w, this.h);
                this.MW.addOn(panel2, -1);
                panel2.setVisible(!this.hidden);
            }
        }

        public void remove(Component panel2) {
            if (this.MW != null && this.MW.panel != null) {
                this.MW.panel.remove(panel2);
            }
            this.pan.refresh();
        }

        public void refresh() {
            this.MW.refresh(this.pos);
        }

        @Deprecated
        public void paint() {
            int xi = this.x;
            int wi = this.w;
            int yi = this.y;
            int hi = this.h;
            int tsp = 3 * this.ts / 2;
            if (tsp > 0) {
                yi -= tsp;
                hi += tsp;
            }
            this.pos.setBounds(xi, yi, wi, hi);
            if (this.tabManager != null) {
                xi += this.tabManager.getTabIndex(this) * (wi /= this.tabManager.getTabCount());
            }
            if (this.ts > 0 && !this.hidden) {
                int modeForPushPop;
                int color = this.tabManager == null || this.tabManager.isVisibleTab(this) ? 8 : 16;
                int n = modeForPushPop = panel.this.pushPopIconSymbol == 1 ? -7 : -9;
                if (panel.this.customIconSymbol == 1) {
                    this.MW.shadowbox(xi, yi, wi, tsp, panel.this.is(2) ? modeForPushPop : -5);
                } else {
                    this.MW.shadowboxCustomIcon(xi, yi, wi, tsp, panel.this.is(2) ? modeForPushPop : -5, panel.this.customIconSymbol, panel.this.customIconSymbolName);
                }
                this.MW.drawString(this.tag != null ? this.tag : this.title, xi + wi / 2, this.y - 4, this.ts, 1 | color);
            }
            if (this.panel == null) {
                this.MW.g.drawRect(xi + 2, this.y + 2, wi - 4, this.h - 4);
                this.MW.drawString(this.name, xi + wi / 2, this.y + this.h / 2, 12, 0);
            }
        }

        public void paint(GPanelSetup gp, Graphics g) {
            int xi = this.x;
            int wi = this.w;
            int yi = this.y;
            int hi = this.h;
            int tsp = 3 * this.ts / 2;
            if (tsp > 0) {
                yi -= tsp;
                hi += tsp;
            }
            this.pos.setBounds(xi, yi, wi, hi);
            if (this.tabManager != null) {
                xi += this.tabManager.getTabIndex(this) * (wi /= this.tabManager.getTabCount());
            }
            if (this.ts > 0 && !this.hidden) {
                int modeForPushPop;
                int color = this.tabManager == null || this.tabManager.isVisibleTab(this) ? 8 : 16;
                int n = modeForPushPop = panel.this.pushPopIconSymbol == 1 ? -7 : -9;
                if (panel.this.customIconSymbol == 1) {
                    gp.shadowbox(g, xi, yi, wi, tsp, panel.this.is(2) ? modeForPushPop : -5);
                } else {
                    gp.shadowboxCustomIcon(g, xi, yi, wi, tsp, panel.this.is(2) ? modeForPushPop : -5, panel.this.customIconSymbol, panel.this.customIconSymbolName);
                }
                for (int i = 0; i < this.nicons; ++i) {
                    int xip = xi + this.iconOffs[i];
                    int yip = yi + this.ts / 3;
                    if (this.icons != null && this.icons[i] != null) {
                        this.icons[i].paintIcon(this.panel, g, xip, yip);
                        continue;
                    }
                    gp.drawString(g, this.iconKeys[i], xip, yip + this.ts, this.ts, this.iconCur == i + 1 ? 8 : 0);
                }
                gp.drawString(g, this.tag != null ? this.tag : this.title, xi + wi / 2, this.y - 4, this.ts, 1 | color);
            }
            if (this.panel == null) {
                g.drawRect(xi + 2, this.y + 2, wi - 4, this.h - 4);
                gp.drawString(g, this.name, xi + wi / 2, this.y + this.h / 2, 12, 0);
            }
        }

        private int clickHit(int xp, int yp) {
            int xi = this.pos.x;
            int wi = this.pos.w;
            int tsp = 3 * this.ts / 2;
            int iconW = 10;
            int rightPadding = 5;
            if (this.tabManager != null) {
                xi += this.tabManager.getTabIndex(this) * (wi /= this.tabManager.getTabCount());
            }
            int leftXOfPushPopIcon = xi + wi - iconW - rightPadding;
            if (xp < xi || xp > xi + wi || yp < this.y - tsp || yp > this.y + this.h) {
                return -3;
            }
            if (panel.this.is(2) && xp > leftXOfPushPopIcon) {
                return -1;
            }
            if (panel.this.customIconSymbol != 1 && xp > leftXOfPushPopIcon - iconW && xp <= leftXOfPushPopIcon) {
                return -2;
            }
            if (this.nicons > 0 && this.hoverHit(xp, yp) > 0) {
                return this.iconCur;
            }
            return 0;
        }

        private int hoverHit(int xp, int yp) {
            int icon;
            if (this.ts == 0) {
                return -1;
            }
            int te = this.ts / 4;
            int tsp = 3 * this.ts / 2;
            int xi = this.pos.x;
            int xw = this.pos.w;
            int yi = this.pos.y;
            int iconLast = this.iconCur;
            if (xp < xi || xp > xi + xw) {
                return -1;
            }
            if (yp < yi || yp > yi + tsp) {
                return -1;
            }
            if (this.nicons <= 0 || xp > xi + this.iconOffs[this.nicons]) {
                return 0;
            }
            for (icon = this.nicons; icon > 0 && xp < xi + this.iconOffs[icon - 1]; --icon) {
            }
            if (yp < yi + te || yp > yi + tsp - te) {
                icon = 0;
            }
            this.iconCur = icon;
            if (icon != iconLast) {
                this.refresh();
            }
            return icon;
        }

        public void setDisplay(String str) {
            if (str.equals("FRONT")) {
                panel.this.hitPane(this.myIndex(), false, 0);
            } else if (str.equals("POP")) {
                this.panel.setVisible(true);
                this.mw.pop(1);
            } else if (str.equals("PUSH")) {
                this.mw.pop(0);
            }
        }

        private int myIndex() {
            for (int i = 1; i <= panel.this.npane; ++i) {
                if (panel.this.pane[i] != this) continue;
                return i;
            }
            return 0;
        }

        @Override
        public int processMessage(Message msg) {
            if (msg.name.equals("CFG.PANE")) {
                String text = msg.getS();
                if (text.equals("TITLETEXT")) {
                    new GPrompt(this.MW, "TitleText", this.title, this.title.length(), 0, this);
                } else if (text.equals("TITLESIZE")) {
                    new GMenu(this.MW, "TitleSize", "0,8,10,12,14,16,20,24", 0, 0, this);
                } else if (text.equals("TITLECOLOR")) {
                    new GPrompt(this.MW, "TitleColor", "ForeGround", 0, (MessageHandler)this);
                } else if (text.equals("ATTACH")) {
                    new GMenu(this.MW, "Attach", panel.this.M.registry.table.getKeyList(), 0, 0, this);
                } else if (text.equals("ADDTAB")) {
                    panel.this.addPane(0, panel.this.cfgx, panel.this.cfgy);
                } else if (text.equals("DELETE")) {
                    panel.this.delPane(this);
                } else {
                    panel.this.M.warning("Unrecognized message " + msg.name + " text " + text);
                }
                panel.this.configure = 1;
            } else if (msg.name.equals("TITLETEXT")) {
                this.setTitle(msg.getS());
            } else if (msg.name.equals("TITLESIZE")) {
                this.setTS(Convert.o2l(msg.data));
                panel.this.resize();
            } else if (msg.name.equals("TITLECOLOR")) {
                panel.this.M.warning("Setting color is TBD");
            } else if (msg.name.equals("ATTACH")) {
                this.attach(msg.getS());
            } else if (msg.name.equals("SUBPANELS")) {
                this.attachSubPanel(msg.getS());
            }
            return 0;
        }

        private void attach(String name) {
            Object entry = panel.this.M.registry.get(name);
            if (entry instanceof Macro) {
                this.getSubPanels((Macro)entry, name);
            } else {
                this.attach(entry, name);
            }
        }

        @InternalUseOnly
        public void attach(Object entry, String name) {
            if (GPrimitive.isInstance(entry)) {
                this.mw = GPrimitive.getMWindowViaReflection(entry);
                if (this.mw == null) {
                    return;
                }
                this.mw.pushParent = this;
                this.mw.pop(0);
                this.name = name;
            } else {
                panel.this.M.info("Attach Object must be an instanceof GPrimitive: " + name);
            }
        }

        public void attachSubPanel(String name) {
            this.attach(panel.this.subPanels.get(name), panel.this.subPanelName);
        }

        private void getSubPanels(Macro m, String name) {
            panel p = (panel)m.M.registry.get("PANEL");
            if (p != null) {
                this.attach(p, name);
            } else {
                panel.this.subPanels = new Table();
                panel.this.subPanelName = name;
                Table t = m.M.registry.table;
                String[] s = t.getKeys();
                Object tmp = null;
                for (int i = 0; i < s.length; ++i) {
                    tmp = t.getO(s[i]);
                    if (!(tmp instanceof panel)) continue;
                    panel.this.subPanels.put(s[i], tmp);
                }
                if (panel.this.subPanels.getSize() > 0) {
                    if (panel.this.subPanels.getSize() == 1) {
                        String id = panel.this.subPanels.getKeys()[0];
                        this.attach(panel.this.subPanels.getO(id), panel.this.subPanelName);
                        if (panel.this.subPanels.getO(id) instanceof panel) {
                            panel myPanel = (panel)panel.this.subPanels.getO(id);
                            for (Pane myPane : myPanel.getPanesArray()) {
                                if (myPane == null || myPane.mw == null) continue;
                                myPane.mw.addTo(myPane);
                            }
                        }
                    } else {
                        new GMenu(this.MW, "SubPanels", panel.this.subPanels.getKeyList(), 0, 0, this);
                    }
                }
            }
        }

        public String toString() {
            return "Pane " + this.name + " x=" + this.x + " y=" + this.y + " w=" + this.w + " h=" + this.h;
        }
    }

    public class Line
    implements MessageHandler {
        float rx;
        float ry;
        int i1;
        int i2;
        int x1;
        int x2;
        int y1;
        int y2;
        int w;
        int dir;
        int fp = 0;
        int flags = 0;

        @Override
        public int processMessage(Message msg) {
            if (msg.name.equals("CFG.LINE")) {
                String text = msg.getS();
                if (text.equals("DELETE")) {
                    panel.this.delLine(this);
                } else if (text.equals("FIX")) {
                    this.fp = this.dir == 1 ? (this.x1 + this.x2) / 2 : (this.y1 + this.y2) / 2;
                } else if (text.equals("UNFIX")) {
                    this.fp = 0;
                }
            }
            return 1;
        }

        public String toString() {
            return "Line rx:" + this.rx + " ry:" + this.ry + " i1:" + this.i1 + " i2:" + this.i2 + " x1:" + this.x1 + " x2:" + this.x2 + " y1:" + this.y1 + " y2:" + this.y2 + " w:" + this.w + " dir:" + this.dir + " fp:" + this.fp + " flags:" + this.flags;
        }
    }
}

