/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.awt.Container;
import java.awt.Point;
import java.util.Date;
import java.util.Vector;
import javax.swing.SwingUtilities;
import nxm.sys.inc.Chainable;
import nxm.sys.inc.ListFile;
import nxm.sys.inc.ListInterface;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.CsvFile;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Registry;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPrimitive;
import nxm.sys.libg.GPrompt;
import nxm.sys.libg.GraphicsUtil;
import nxm.sys.libg.LargeJTable;
import nxm.sys.libg.MJList;
import nxm.sys.libg.MJListConfig;
import nxm.sys.libg.MJPopup;
import nxm.sys.libg.MWindow;
import nxm.sys.prim.convert;

public class list2
extends GPrimitive
implements Chainable {
    public static final String pointerMessageList = "Click,Motion,Drag";
    public static final int ONCLICK = 1;
    public static final int ONMOTION = 2;
    public static final int ONDRAG = 4;
    public static final String exitList = "RETURN,MENU,MESSAGE,WINDOW,AUTO";
    public static final int EXIT_RETURN = 1;
    public static final int EXIT_MENU = 2;
    public static final int EXIT_MESSAGE = 4;
    public static final int EXIT_WINDOW = 8;
    public static final int EXIT_ALL = 15;
    public static final int EXIT_AUTO = 16;
    public static final String buttonActionList = "None,Menu,Message,ClearSelection";
    private static final int BTN_NONE = 1;
    private static final int BTN_MENU = 2;
    private static final int BTN_MESSAGE = 3;
    private static final int BTN_CLEAR = 4;
    private static final int DEF_SORT_LIMIT = 8192;
    private static final int DEF_BASE_INDEX = 1;
    private MJList mjlist;
    private ListInterface listIF;
    private Table template = null;
    private boolean done = false;
    private boolean useRamFile = false;
    private FileName fileName = null;
    private FileName ramFileName = null;
    private int controls = 1;
    private double pollInterval = 0.0;
    private double lastPoll = 0.0;
    private boolean tryOpen = false;
    private boolean autoSelect = true;
    private boolean unsafe = false;
    private boolean prevAndCurr = false;
    private int lmbButton = 1;
    private int mmbButton = 2;
    private int rmbButton = 4;
    private int exit = -1;
    private boolean isTable = false;
    private String wtitle = null;
    private int maxRamFileSize = 0;
    private LegacyInterface gsInterface = null;
    private Table clickActionTable = new Table("{CELL=SELECT,ROW=SELECT,COL=SORT}");

    @Override
    public int open() {
        BaseFile templ;
        Table tableFile;
        this.autoSelect = this.MA.getState("AUTOSELECT", this.autoSelect);
        this.clickActionTable = this.MA.getTable("CLICKACTION", this.clickActionTable);
        this.unsafe = this.MA.getState("/UNSAFE", this.unsafe);
        this.prevAndCurr = this.MA.getState("/PREVANDCURR", true);
        BaseFile baseFile = null;
        Table table = tableFile = this.MA.find("FILE") ? this.MA.getTable("FILE", null, 32) : null;
        if (tableFile == null) {
            baseFile = this.MA.find("FILE") ? this.MA.getFile("FILE") : null;
        } else {
            this.isTable = true;
        }
        int maxSortSize = this.MA.getL("/SORTLIMIT", 8192);
        int baseIndex = this.MA.getL("/BASE", 1);
        if (this.template == null) {
            this.template = this.MA.getTable("TEMPLATE", null, 32);
        }
        this.exit = this.M.pipeMode == 1 ? 0 : 15;
        this.exit = this.MA.getOptionMask("/EXIT", exitList, this.exit);
        this.setButtonAction(this.MA.getTable("BUTTONACTION"));
        if (this.MA.find("/POLL")) {
            this.M.warning("LIST2: Use of /POLL with LIST2 is deprecated unless you are intending to adjust processing interval. For LIST2 file data polling, use /POLLDATA.");
            this.setPollInterval(this.MA.getD("/POLL", this.pollInterval));
        }
        if (this.MA.find("/POLLDATA")) {
            this.setPollInterval(this.MA.getD("/POLLDATA"));
        }
        this.useRamFile = !this.MA.getState("/MOD", this.pollInterval != 0.0);
        this.useRamFile = this.MA.getState("/USERAMFILE", this.useRamFile);
        if (this.MA.isPresent("/USERAMFILEMAXSIZE")) {
            this.setRamFileMaxSize(this.MA.getL("/USERAMFILEMAXSIZE"));
        } else {
            this.setRamFileMaxSize(0x1000000);
        }
        if (this.MA.find("/COPY")) {
            this.M.deprecate("LIST2: Use /MOD switch instead of /COPY");
            this.useRamFile = this.MA.getState("/COPY", this.useRamFile);
        }
        if (this.unsafe) {
            this.M.deprecate("LIST2: Use of /UNSAFE=TRUE is deprecated in LIST2.");
            this.M.warning("LIST2: Running in /UNSAFE mode. Calls to the underlying library are NOT thread-safe.");
        }
        if (this.useRamFile && this.pollInterval != 0.0) {
            this.M.error("LIST2: Poll time of " + this.pollInterval + " conflicts with /MOD=FALSE");
        }
        this.setControls(this.MA.getS("CNT"));
        if (this.template == null && this.MA.isPresent("TEMPLATE") && (templ = this.MA.getFile("TEMPLATE")) instanceof DataFile) {
            this.M.deprecate("LIST2: Use of X-Midas style templates is deprecated, use CONVERT to convert existing X-Midas templates to the current format.");
            this.template = convert.convertTemplate2Table((DataFile)templ);
        }
        if (this.MA.getState("/LEGACY")) {
            this.M.deprecate("LIST2: The /LEGACY interface to LIST2 is deprecated.");
            this.gsInterface = new LegacyInterface();
            boolean bl = this.useRamFile = !this.MA.getZ("/MOD");
        }
        if (this.template != null && baseFile == null) {
            baseFile = this.setFileFromTemplate(this.template);
        }
        if (this.template == null && baseFile == null && this.isTable) {
            baseFile = this.setFileFromTemplate(this.getDefaultTemplate());
        }
        this.MW = new MWindow("LIST2", this);
        this.MW.open();
        this.MW.setSize(800, 500);
        this.MW.addTo(this);
        this.init(this.MW, baseFile, this.template, baseIndex, maxSortSize, this.autoSelect);
        this.wtitle = this.MA.getS("/WTITLE", null);
        this.MW.setTitle(this.getTitle());
        if (this.isTable) {
            this.addRowsFromTable(tableFile);
        }
        return 0;
    }

    @Override
    public int process() {
        int status = -1;
        if (this.done) {
            status = 9;
        } else if (this.tryOpen) {
            if (!this.doOpenFile(this.fileName, false)) {
                Time.sleep(0.5);
            }
            status = 0;
        } else {
            double numRead = 0.0;
            if (this.pollInterval > 0.0) {
                if (Time.current() >= this.pollInterval + this.lastPoll) {
                    numRead = this.pollImmediately(true);
                }
            } else {
                numRead = this.pollImmediately(false);
            }
            status = numRead <= 0.0 ? -1 : 0;
        }
        return status;
    }

    @Override
    public int close() {
        if (this.MW != null) {
            this.MW.close();
        }
        this.done = true;
        this.deleteRamFile();
        return 0;
    }

    private BaseFile setFileFromTemplate(Table templ) {
        if (templ == null) {
            templ = this.template;
        }
        StringBuffer str = new StringBuffer();
        String[] keys = templ.getKeys();
        DataFile df = new DataFile(this.M, (Object)this.getRamFileName());
        df.setType(3000);
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = keys[i].toUpperCase().trim();
            if (keys[i].startsWith("_") && keys[i].endsWith("_")) continue;
            df.addSubRec(keys[i], "XA");
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(keys[i]).append("/XA");
        }
        df.open(2);
        if (this.isTable) {
            this.M.info("LIST2: Creating ramFile based on given Table.");
        } else {
            this.M.info("LIST2: No input file found, creating Type 3000 RamFile to match template (" + str + ").");
        }
        return df;
    }

    public boolean isTable() {
        return this.isTable;
    }

    private Table getDefaultTemplate() {
        Table tbl = new Table();
        Table globalTbl = new Table();
        globalTbl.put("TYPE", (Object)"LIST2");
        globalTbl.put("AUTOHIDE", (Object)"TRUE");
        globalTbl.put("AUTOORDER", (Object)"TRUE");
        tbl.put("_GLOBAL_", (Object)globalTbl);
        return tbl;
    }

    private void addRowsFromTable(Table tbl) {
        Table.Iterator ti = tbl.iterator();
        while (ti.getNext()) {
            Object obj = ti.value;
            if (!(obj instanceof Table)) continue;
            this.addRow(Convert.o2t(obj));
        }
    }

    @Deprecated
    public void initLegacy(Midas midas, BaseFile baseFile, Table template) {
        this.gsInterface = new LegacyInterface();
        this.useRamFile = true;
        this.init(midas, baseFile, template);
    }

    public void init(Midas midas, BaseFile baseFile, Table template) {
        this.M = midas;
        this.init(null, baseFile, template, 1, 8192, true);
        this.mjlist.addMouseKeyListeners(new MWindow("LIST2", this));
    }

    private void init(final MWindow mw, final BaseFile baseFile, final Table template, final int baseIndex, final int maxSortSize, final boolean autoSelect) {
        try {
            if (!Shell.isHeadless()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        list2.this.init0(mw, baseFile, template, baseIndex, maxSortSize, autoSelect);
                    }
                });
            }
        }
        catch (Exception e) {
            Shell.printStackTrace(e);
        }
    }

    private void init0(MWindow mw, BaseFile baseFile, Table template, int baseIndex, int maxSortSize, boolean autoSelect) {
        this.mjlist = new MJList(this.M, mw, maxSortSize, baseIndex);
        this.listIF = this.mjlist.getThreadSafeInstance();
        if (baseFile != null) {
            this.openFile(baseFile);
        }
        if (template != null) {
            this.mjlist.setTemplate(template);
        }
        Table settings = new Table();
        settings.setKey("AUTOSELECT", autoSelect);
        settings.setKey("PREVANDCURR", this.prevAndCurr);
        if (this.gsInterface == null) {
            this.mjlist.setTableSelectionModel(new MJList.NMTableSelectionModel(this.mjlist, this, settings));
        } else {
            settings.setKey("LEGACY", "true");
            this.mjlist.setTableSelectionModel(new MJList.NMTableSelectionModel(this.mjlist, this, settings));
        }
        this.mjlist.setMessageHandler(this);
        this.mjlist.setCellSelectionAllowed(autoSelect);
        this.mjlist.setCellClickAction(this.clickActionTable.getS("CELL"));
        this.mjlist.setRowClickAction(this.clickActionTable.getS("ROW"));
        this.mjlist.setColClickAction(this.clickActionTable.getS("COL"));
        this.mjlist.setEditable(this.MA.getState("/EDITABLE", true));
        this.mjlist.setDragAndDropEnabled(this.MA.getState("/DRAGDROP"));
    }

    public FileName getFileName() {
        return this.fileName;
    }

    public FileName getTempFile() {
        return this.useRamFile ? this.ramFileName : null;
    }

    public void setPollInterval(double seconds) {
        this.pollInterval = Math.max(0.0, seconds);
    }

    public double getPollInterval() {
        return this.pollInterval;
    }

    public Table getButtonAction() {
        Table tbl = new Table();
        tbl.put("LMB", (Object)Parser.get(buttonActionList, this.lmbButton));
        tbl.put("MMB", (Object)Parser.get(buttonActionList, this.mmbButton));
        tbl.put("RMB", (Object)Parser.get(buttonActionList, this.rmbButton));
        return tbl;
    }

    public void setButtonAction(Table tbl) {
        if (tbl != null) {
            this.lmbButton = this.findButtonAction(tbl.getS("LMB"), this.lmbButton, 1);
            this.mmbButton = this.findButtonAction(tbl.getS("MMB"), this.mmbButton, 2);
            this.rmbButton = this.findButtonAction(tbl.getS("RMB"), this.rmbButton, 4);
        }
    }

    private int findButtonAction(String val, int current, int def) {
        int action = current;
        if (val != null) {
            if (val.equalsIgnoreCase("DEFAULT")) {
                action = def;
            } else {
                action = Parser.find(buttonActionList, val, def);
                if (action < 0) {
                    throw new MidasException("LIST2: Invalid buttonAction '" + val + "', valid options are '" + buttonActionList + "'.");
                }
            }
        }
        return action;
    }

    public void setTemplate(Object template) {
        if (this.getList() != null) {
            this.getList().setTemplate(Convert.o2t(template, this));
        }
    }

    public void updateTemplate(Object template) {
        if (this.getList() != null) {
            this.getList().updateTemplate(Convert.o2t(template, this));
        }
    }

    public void setControls(String cnt) {
        this.setControlsMask(Parser.mask(pointerMessageList, cnt, this.controls));
    }

    public String getControls() {
        return Parser.mask2s(pointerMessageList, this.getControlsMask());
    }

    public void setControlsMask(int cnt) {
        this.controls = cnt;
    }

    public int getControlsMask() {
        return this.controls;
    }

    public void refresh() {
        if (this.MW != null) {
            this.MW.refresh();
        }
    }

    public double pollImmediately() {
        return this.pollImmediately(true);
    }

    private synchronized double pollImmediately(boolean poll) {
        double numRead = 0.0;
        if (this.getList() != null) {
            numRead = this.getList().pollData(poll);
            this.lastPoll = Time.current();
        }
        return numRead;
    }

    public void openFile(String fileName) {
        this.doOpenFile(fileName, true);
    }

    public void openFile(FileName fileName) {
        this.doOpenFile(fileName, true);
    }

    public void openFile(BaseFile baseFile) {
        this.doOpenFile(baseFile, true);
    }

    public void openFile(ListFile listFile) {
        this.doOpenFile(listFile, true);
    }

    private boolean doOpenFile(Object file, boolean warn) {
        ListFile listFile = this.lmbButton(file);
        boolean readOnly = this.pollInterval > 0.0 || !this.useRamFile;
        boolean exists = true;
        boolean opened = false;
        boolean ramSafe = true;
        this.fileName = listFile == null ? null : listFile.getName();
        this.tryOpen = false;
        if (listFile instanceof BaseFile && (exists = ((BaseFile)((Object)listFile)).exists())) {
            listFile.open(1);
            boolean bl = ramSafe = ((BaseFile)((Object)listFile)).io.getLength() <= (long)this.maxRamFileSize;
            if (!ramSafe && this.maxRamFileSize > 0) {
                this.M.info("File name=[" + listFile.getName() + "] size=[" + ((BaseFile)((Object)listFile)).io.getLength() + "] exceeds /MaxRAMFileSize=" + this.maxRamFileSize + ". Accessing file directly.");
            }
            if (listFile instanceof DataFile && ((DataFile)listFile).getDetached() != 0) {
                ramSafe = false;
            }
        }
        if (!exists) {
            if (warn) {
                this.M.warning("LIST2: Could not find file " + this.fileName);
            }
            this.getList().setListFile(null, true);
            this.tryOpen = true;
        } else {
            if (this.ramFileName == null || !this.ramFileName.equals(this.fileName)) {
                this.deleteRamFile();
                if ((listFile == null || this.useRamFile && !readOnly) && ramSafe) {
                    listFile = this.createRamFile(listFile);
                }
            }
            this.getList().setListFile(listFile, readOnly);
            opened = true;
        }
        return opened;
    }

    public void setRamFileMaxSize(int size) {
        this.maxRamFileSize = size;
    }

    public int getRamFileMaxSize() {
        return this.maxRamFileSize;
    }

    public void setUseRamFile(boolean val) {
        this.useRamFile = val;
    }

    public boolean getUseRamFile() {
        return this.useRamFile;
    }

    private ListFile lmbButton(Object file) {
        ListFile listFile = null;
        if (file == null) {
            listFile = null;
        } else if (file instanceof ListFile) {
            listFile = (ListFile)file;
        } else {
            if (file instanceof BaseFile) {
                throw new MidasException("LIST2 only supports ListFiles, given " + file);
            }
            if (file instanceof String && file.toString().trim().length() == 0) {
                listFile = null;
            } else {
                FileName fileName = FileName.toFileName(file);
                listFile = this.lmbButton(BaseFile.getInstanceFor(this.M, (Object)fileName));
            }
        }
        return listFile;
    }

    private void closeFile() {
        this.openFile((ListFile)null);
    }

    private void deleteRamFile() {
        if (this.ramFileName != null) {
            BaseFile bf = new BaseFile(this.M, (Object)this.ramFileName);
            bf.erase(true);
            this.ramFileName = null;
        }
    }

    public ListInterface getList() {
        return this.listIF;
    }

    @Deprecated
    public MJList getTabularDisplay() {
        this.M.deprecate("LIST2: Since NeXtMidas 2.5.0: Use getTabularDisplay() is deprecated since it returns a handle to MJList that is NOT thread-safe. Use getList() to get a thread-safe instance.");
        return this.mjlist;
    }

    @Deprecated
    public Object getGridSheet() {
        if (this.gsInterface == null) {
            this.M.warning("LIST2: Use of LIST2.GS.<NAME> is not supported, use LIST2.<NAME>.");
        }
        return this.gsInterface;
    }

    private FileName getRamFileName() {
        if (this.ramFileName == null) {
            this.ramFileName = new FileName(this.M.pipes.getUniqueKey("list2_temp_00") + "{AUX=RAM}");
        }
        return this.ramFileName;
    }

    private ListFile createRamFile(ListFile file) {
        this.deleteRamFile();
        FileName fileName = this.getRamFileName();
        String fileGroup = null;
        Table quals = null;
        Table ramQuals = fileName.getQualifierTable();
        FileName name = null;
        if (file instanceof BaseFile) {
            quals = ((BaseFile)((Object)file)).getQualifiers();
            name = ((BaseFile)((Object)file)).getName();
        } else {
            FileName fileName2 = name = file == null ? null : file.getName();
        }
        if (file != null) {
            Table handlers = Registry.handlers.getTable("FILE");
            String className = file.getClass().getName();
            String[] exts = handlers.getKeys();
            for (int i = 0; i < exts.length && fileGroup == null; ++i) {
                String clazz = handlers.getS(exts[i]);
                if (!clazz.equals(className)) continue;
                fileGroup = exts[i];
            }
        }
        if (file != null && name != null) {
            FileUtil.copyBaseFile(this.M, name, fileName);
        } else {
            BaseFile ramFile = new BaseFile(this.M, (Object)fileName);
            ramFile.open(2);
            ramFile.close();
        }
        if (quals != null) {
            ramQuals.merge(quals);
        }
        ramQuals.put("AUX", (Object)"RAM");
        ramQuals.put("FG", (Object)fileGroup);
        if (file == null) {
            return null;
        }
        return (ListFile)((Object)BaseFile.getInstanceFor(this.M, (Object)fileName));
    }

    @Override
    public Object getPrevLink() {
        return null;
    }

    @Override
    public Object getNextLink() {
        if (this.gsInterface != null) {
            return this.gsInterface;
        }
        if (this.unsafe) {
            return this.mjlist;
        }
        return this.getList();
    }

    @Override
    public int processMessage(Message msg) {
        String text;
        int status = 0;
        if (msg.name.equals("KEYPRESS") && (text = (String)msg.data).equalsIgnoreCase("Enter")) {
            if ((this.exit & 1) != 0) {
                this.done = true;
            }
            return -1;
        }
        if (msg.name.equals("WINDOW")) {
            if (msg.data.equals("CLOSING")) {
                if ((this.exit & 8) != 0) {
                    this.done = true;
                }
            } else if (msg.data.equals("TOGGLE")) {
                this.MW.pop(-1);
            } else if (msg.data.equals("PUSH")) {
                this.MW.pop(0);
            } else if (msg.data.equals("POP")) {
                this.MW.pop(1);
            }
        } else if (msg.name.equals("EXIT")) {
            if ((this.exit & 4) != 0) {
                this.done = true;
            }
        } else if (msg.name.equals("OPENFILE")) {
            if (msg.data != null && !msg.data.equals("")) {
                this.fileName = new FileName((String)msg.data);
            } else {
                this.M.info("LIST2: Got OPENFILE Message with no FileName. Re-opening current file: " + this.fileName);
            }
            this.openFileOnEDT();
        } else if (msg.name.equals("OPENTEMPLATE")) {
            this.openFileOnEDT();
            this.getList().setTemplate(Convert.o2t(msg.data, this));
        } else if (msg.name.equals("POP")) {
            if ("CLOSING".equals(msg.data)) {
                this.MW.pop(0);
            } else {
                this.MW.pop(msg.info);
            }
            this.mjlist.setSize(this.MW.pos.w, this.MW.pos.h);
        } else if (msg.name.equals("BUTTON")) {
            switch (msg.info) {
                case 1: {
                    this.doButtonAction("LMB", this.lmbButton);
                    break;
                }
                case 2: {
                    this.doButtonAction("MMB", this.mmbButton);
                    break;
                }
                case 3: {
                    this.doButtonAction("RMB", this.rmbButton);
                    break;
                }
                default: {
                    this.sendMouseMessage(msg, 1);
                    break;
                }
            }
        } else if (msg.name.equals("SELECT") || msg.name.equals("SELECTROW") || msg.name.equals("DESELECT")) {
            this.sendMessage(msg);
        } else if (msg.name.equals("POINTER")) {
            this.sendMouseMessage(msg, 2);
        } else if (msg.name.equals("MENU")) {
            this.processMenuMessage(msg);
        } else if (msg.name.equals("REFRESH")) {
            this.refresh();
        } else if (msg.name.equals("DROPDATA")) {
            this.sendMessage(msg);
        } else if (this.gsInterface != null) {
            status = this.gsInterface.processMessage(msg);
        }
        return status;
    }

    private void openFileOnEDT() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    list2.this.openFile(list2.this.fileName);
                }
            });
        }
        catch (Exception e) {
            Shell.printStackTrace(e);
        }
    }

    private void doButtonAction(String name, int action) {
        switch (action) {
            case 1: {
                break;
            }
            case 2: {
                this.mjlist.setMenuVisible(!this.mjlist.isMenuVisible());
                break;
            }
            case 3: {
                Point pos = new Point(this.MW.px, this.MW.py);
                int rap = this.mjlist.rowAtPoint(pos);
                int cap = this.mjlist.columnAtPoint(pos);
                long row = rap < 0 ? (long)rap : this.mjlist.getMacroRowIndex(this.mjlist.getRealRowIndex(this.mjlist.getModelRowIndex(rap)));
                long col = cap < 0 ? (long)cap : this.mjlist.getMacroRowIndex(this.mjlist.getRealColIndex(this.mjlist.getModelColIndex(cap)));
                Table tbl = new Table();
                tbl.put("ROW", row);
                tbl.put("COL", col);
                this.sendMessage(new Message(name, 0, tbl));
                break;
            }
            case 4: {
                if (!this.autoSelect) break;
                this.mjlist.getTableSelectionModel().clearSelection(true);
                break;
            }
            default: {
                throw new MidasException("Illegal buttonAction=" + action);
            }
        }
    }

    private void unhandledMessage(Message msg) {
        this.M.warning("LIST2: Unhandled message name=" + msg.getName() + " info=" + msg.getInfo() + " data=" + msg.getData() + " from=" + msg.getFrom());
    }

    private void processMenuMessage(Message msg) {
        int PLAIN_MSG = -1;
        int WARN_MSG = 2;
        String act = msg.getData().toString();
        Container parent = this.mjlist.getParent();
        if (act.startsWith("FILE.")) {
            if (act.equals("FILE.LOAD")) {
                String fname = MJPopup.showFile(parent, this.getTitle() + ": Load File", -1, "Load file...", this.getFileName());
                if (fname != null) {
                    this.openFile(fname);
                    this.getList().setTemplate(null);
                }
            } else if (act.equals("FILE.REREAD")) {
                this.openFile(this.fileName);
            } else if (act.equals("FILE.SAVE_COPY")) {
                String fname = MJPopup.showFile(parent, this.getTitle() + ": Save File", -1, "Save file copy as...", "myfile.csv");
                if (fname != null) {
                    FileName srcFile = this.getTempFile() == null ? this.getFileName() : this.getTempFile();
                    FileName destFile = FileName.toFileName(fname);
                    Object[] allCols = this.getList().getColumnNames();
                    String allColsStr = StringUtil.join(allCols, ",");
                    Object[] cols = MJPopup.showMaskArray(parent, this.getTitle() + ": Save File", -1, "Include Columns (click 'Cancel' to use file quals)", allCols, allColsStr);
                    ListFile listfile = this.getList().getListFile();
                    listfile.update();
                    FileUtil.copyListFile(this.M, srcFile, destFile, cols);
                }
            } else if (act.equals("FILE.EXIT")) {
                if ((this.exit & 2) != 0) {
                    this.done = true;
                }
            } else {
                this.unhandledMessage(msg);
            }
        } else if (act.startsWith("EDIT.")) {
            if (act.equals("EDIT.COPY")) {
                Table defs = this.getList().getListFile().getRecordDefs();
                Table data = this.getList().getAllSelectedRows();
                String csv = CsvFile.tableToCsv(defs, data);
                GraphicsUtil.toSystemClipboard(csv);
                GraphicsUtil.toSystemSelection(csv);
            } else if (act.equals("EDIT.PASTE")) {
                Table[] rows;
                String name = "Paste Values";
                String text = "Paste values into row";
                Long line = this.getLineNumber(name, text, null);
                if (line != null && (rows = this.getClipRows(name)) != null) {
                    for (int i = 0; i < rows.length; ++i) {
                        this.getList().setRow(line + (long)i, rows[i]);
                    }
                }
            } else if (act.equals("EDIT.INSERT_VAL")) {
                Table[] rows;
                String name = "Insert Values";
                String text = "Insert row with values at (-1 to add to end)";
                Long line = this.getLineNumber(name, text, null);
                if (line != null && (rows = this.getClipRows(name)) != null) {
                    this.getList().addRows(line, rows);
                }
            } else if (act.equals("EDIT.INSERT_ROW")) {
                String name = "Insert Row";
                String text = "Insert blank row at (-1 to add to end)";
                Long line = this.getLineNumber(name, text, null);
                if (line != null) {
                    this.getList().addRow(line, new Table());
                }
            } else if (act.equals("EDIT.DELETE")) {
                Long line = this.getLineNumber("Delete Row", "Delete row at", null);
                if (line != null) {
                    this.getList().removeRow(line);
                }
            } else if (act.equals("EDIT.PREF")) {
                this.M.warning("LIST2: processMenuMessage: " + act + " not implemented yet");
            } else {
                this.unhandledMessage(msg);
            }
        } else if (act.startsWith("TEMP.")) {
            if (act.equals("TEMP.EDIT")) {
                MJListConfig config = new MJListConfig(this.M, this, this.mjlist);
                Object[] choices = new String[]{"DISMISS"};
                MJPopup popup2 = MJPopup.createButtons(parent, this.getTitle() + ": Edit Template", -1, config, choices);
                popup2.display(this.MW, 0, MJPopup.POSITION_CENTER);
            } else if (act.equals("TEMP.COPY")) {
                String templ = this.getList().getTemplate().toString();
                GraphicsUtil.toSystemClipboard(templ);
                GraphicsUtil.toSystemSelection(templ);
            } else if (act.equals("TEMP.DEF")) {
                this.getList().setTemplate(null);
            } else if (act.equals("TEMP.PASTE")) {
                String clip = GraphicsUtil.fromSystemClipboard();
                if (clip != null) {
                    this.getList().setTemplate(Convert.o2t(clip));
                }
            } else if (act.equals("TEMP.LOAD")) {
                String fname = MJPopup.showFile(parent, this.getTitle() + ": Load Template", -1, "Load template...", "mytemplate.tbl", "*.tbl", null, null);
                if (fname != null) {
                    this.getList().setTemplate(Convert.o2t(fname, this.M));
                }
            } else if (act.equals("TEMP.SAVE_COPY")) {
                String fname = MJPopup.showFile(parent, this.getTitle() + ": Save Template", -1, "Save template as...", "mytemplate.tbl", "*.tbl", null, null);
                if (fname != null) {
                    Table templ = this.getList().getTemplate();
                    FileName fn = FileName.toFileName(fname);
                    TextFile tf = new TextFile(this.M, (Object)fn);
                    templ.toTextFile(tf);
                }
            } else {
                this.M.warning("Unknown menu action " + act);
            }
        } else if (act.startsWith("NAVI.")) {
            if (act.equals("NAVI.GOTO")) {
                Long line = this.getLineNumber("Go To Row", "Go To Row", Long.toString(this.getList().getRowOffset()));
                if (line != null) {
                    this.getList().showCell(line, 0L);
                }
            } else {
                this.unhandledMessage(msg);
            }
        } else if (act.startsWith("HELP.")) {
            if (act.equals("HELP.ABOUT")) {
                MJPopup.showOk(parent, this.getTitle() + ": About", -1, "LIST2\nNeXtMidas 4.1.4");
            } else if (act.equals("HELP.KEYS")) {
                this.M.warning("LIST2: processMenuMessage: " + act + " not implemented yet");
            } else {
                this.unhandledMessage(msg);
            }
        } else {
            this.unhandledMessage(msg);
        }
    }

    private Table[] getClipRows(String name) {
        String clip = GraphicsUtil.fromSystemClipboard();
        Table defs = this.getList().getListFile().getRecordDefs();
        Table[] rows = CsvFile.csvToTables(defs, clip, 1);
        if (rows == null || rows.length == 0) {
            this.M.warning("list2.getClipRows warning: " + this.getTitle() + ": No CSV data available on clipboard.");
            MJPopup.showOk(this.mjlist.getParent(), this.getTitle() + ": " + name, 2, "No CSV data available on clipboard.");
            rows = null;
        } else if (rows.length != 1) {
            String status = MJPopup.showYesNo(this.mjlist.getParent(), this.getTitle() + ": " + name, 2, "" + rows.length + " rows found on clipboard, continue?");
            this.M.warning("list2.getClipRows rows > 1 warning:" + this.getTitle() + ": " + rows.length + "  rows found on clipboard, continue? " + status);
            if (status == null || StringUtil.isFalse(status)) {
                rows = null;
            }
        }
        return rows;
    }

    private Long getLineNumber(String title, String msg, String def) {
        if (def == null) {
            long row = this.mjlist.getTableSelectionModel().getFirstRowSelected();
            def = row < 0L ? "" : Long.toString(this.mjlist.getMacroRowIndex(row));
        }
        String val = MJPopup.showText(this.mjlist.getParent(), this.getTitle() + ": " + title, -1, msg, def);
        Long line = null;
        if (val != null && val.length() > 0) {
            if (StringUtil.isInteger(val)) {
                line = Convert.s2xl(val);
            } else {
                MJPopup.showOk(this.mjlist.getParent(), this.getTitle() + ": " + title, 2, "ERROR: '" + val + "' is not a valid line number.");
            }
        }
        return line;
    }

    private String getTitle() {
        return (this.wtitle != null ? this.wtitle : this.getID()) + ": " + this.fileName;
    }

    public void addRow(Table data) {
        if (this.mjlist != null && this.mjlist.getListFile() != null && this.mjlist.getListFile().getRecordDefCount() == 0) {
            Table template = this.MA.getTable("TEMPLATE");
            Table values = new Table();
            String type = "STRING";
            if (template == null) {
                template = new Table();
            }
            for (String key : data.getKeys()) {
                Object val = data.get(key);
                type = val instanceof Number ? "NUMBER" : (val instanceof Date ? "DATE" : (val instanceof Enum ? "ENUM" : (val instanceof Boolean ? "TOGGLE" : "STRING")));
                values.setKey("TYPE", type);
                template.setKey(key, values);
            }
            this.template = template;
            BaseFile bf = this.setFileFromTemplate(template);
            ListFile lf = this.lmbButton(bf);
            this.mjlist.setTemplate(template);
            this.mjlist.setListFile(lf);
        }
        this.getList().addRow(data);
    }

    public LargeJTable.LargeTableSelectionModel getTableSelectionModel() {
        if (this.mjlist != null) {
            return this.mjlist.getTableSelectionModel();
        }
        return null;
    }

    public void configure() {
        this.mjlist.setMenuVisible(true);
    }

    private void sendMouseMessage(Message msg, int type) {
        if ((this.controls & type) != 0) {
            switch (type) {
                case 1: {
                    msg.name = "MARK";
                    msg.data = null;
                    break;
                }
                case 2: {
                    msg.data = null;
                }
            }
            this.sendMessage(msg);
        }
    }

    public final class LegacyInterface
    implements Chainable,
    MessageHandler {
        private int exit = -1;
        private int settings = 0;
        private int outtype = 3;
        private int hilite = 1;
        private int curmode = 0;
        private int poll = 0;
        private int multiSelMsgMode = 0;
        private MessageHandler msgid;

        @Override
        public Object getNextLink() {
            if (list2.this.unsafe) {
                return list2.this.mjlist;
            }
            return list2.this.getList();
        }

        @Override
        public Object getPrevLink() {
            return null;
        }

        private LegacyInterface() {
            this.exit = list2.this.M.pipeMode == 1 ? 0 : -1;
            this.exit = list2.this.MA.getOptionMask("/EXIT", "RETURN,MENU,MESSAGE", this.exit);
        }

        @Override
        public int processMessage(Message msg) {
            String text;
            int status = 0;
            if (msg.name.equals("KEYPRESS")) {
                text = (String)msg.data;
                if (text.equalsIgnoreCase("M")) {
                    msg.name = "MENU";
                }
                if (text.equalsIgnoreCase("Enter") && (this.exit & 1) != 0) {
                    msg.name = "EXIT";
                }
            }
            if (msg.name.equals("BUTTON") && msg.info == 2) {
                msg.name = "MENU";
            }
            if (msg.name.equals("BUTTON") && msg.info == 3) {
                list2.this.mjlist.getTableSelectionModel().clearSelection(true);
            }
            if (msg.name.equals("MENU")) {
                new GMenu(list2.this.MW, "List", "Files...,Template...,Settings...,Control...,Window...,Options...,Other...,Exit", 0, 0, this);
            } else if (msg.name.equals("DROPDATA")) {
                this.sendMessage(msg);
            } else if (msg.name.equals("LIST")) {
                text = (String)msg.data;
                if (text.equals("FILES...")) {
                    new GMenu(list2.this.MW, "Files", "Open,Close,Reread", 0, 0, this);
                } else if (text.equals("TEMPLATE...")) {
                    new GMenu(list2.this.MW, "Template", "Open,Default", 0, 0, this);
                } else if (text.equals("CONTROL...")) {
                    new GMenu(list2.this.MW, "Controls", "Off,Click,Continuous,Assign...", list2.this.controls + 1, 0, this);
                } else if (text.equals("WINDOW...")) {
                    new GMenu(list2.this.MW, "Window", "Toggle,Push,Pop", 0, 0, this);
                } else if (text.equals("OTHER...")) {
                    new GMenu(list2.this.MW, "Other", "Theme", 0, 0, this);
                } else if (text.equals("OPTIONS...")) {
                    new GMenu(list2.this.MW, "Options", "Add Column,Cursor Granularity...,Highlight...,OutputType...", 0, 0, this);
                } else if (text.equals("SETTINGS...")) {
                    new GMenu(list2.this.MW, "Settings", "Grid,Column Labels,Row Labels", this.settings, 1024, this);
                } else if (text.equals("EXIT")) {
                    msg.name = "EXIT";
                    if ((this.exit & 2) != 0) {
                        list2.this.MQ.put(msg);
                    }
                }
            } else if (msg.name.equals("FILES")) {
                text = (String)msg.data;
                if (text.equals("OPEN")) {
                    new GPrompt(list2.this.MW, "OpenFile", "", 0, (MessageHandler)this);
                } else if (text.equals("CLOSE")) {
                    list2.this.closeFile();
                } else if (text.equals("REREAD")) {
                    list2.this.M.warning("LIST2: REREAD not supported.");
                }
            } else if (msg.name.equals("TEMPLATE")) {
                text = (String)msg.data;
                if (text.equals("OPEN")) {
                    new GPrompt(list2.this.MW, "OPENTEMPLATE", "", 0, (MessageHandler)this);
                } else if (text.equals("DEFAULT")) {
                    list2.this.M.warning("LIST2: Can not open old style template.");
                }
            } else if (msg.name.equals("SETTINGS")) {
                list2.this.M.warning("LIST2: Can not set 'SETTINGS' at this time.");
            } else if (msg.name.equals("SETROW")) {
                this.setOutputType(this.outtype);
                list2.this.getList().setRow(msg.info, Convert.o2t(msg.data));
                list2.this.MQ.put(msg, msg.from, (Object)this);
            } else if (msg.name.equals("GETROW")) {
                msg.data = this.getRow(msg.info);
                list2.this.MQ.put(msg, msg.from, (Object)this);
            } else if (msg.name.equals("GETROWVECTOR")) {
                msg.data = this.getRowVector(msg.info);
                list2.this.MQ.put(msg, msg.from, (Object)this);
            } else if (msg.name.equals("GETROWTABLE")) {
                msg.data = this.getRowTable(msg.info);
                list2.this.MQ.put(msg, msg.from, (Object)this);
            } else if (msg.name.equals("GETCOL")) {
                msg.data = this.getColumn(msg.info);
                list2.this.MQ.put(msg, msg.from, (Object)this);
            } else if (msg.name.equals("GETCOLUMNVECTOR")) {
                msg.data = this.getColumnVector(msg.info);
                list2.this.MQ.put(msg, msg.from, (Object)this);
            } else if (msg.name.equals("GETCOLUMNTABLE")) {
                msg.data = this.getColumnTable(msg.info);
                list2.this.MQ.put(msg, msg.from, (Object)this);
            } else if (msg.name.equals("CONTROLS")) {
                if (msg.info != 4) {
                    list2.this.controls = msg.info - 1;
                }
            } else if (msg.name.equals("WINDOW")) {
                list2.this.M.warning("LIST2: PUSH/POP messages should be processed by normal LIST2 methods.");
            } else if (msg.name.equals("OTHER")) {
                text = (String)msg.data;
                if (text.equals("THEME")) {
                    new GMenu(list2.this.MW, "THEME", "DeskTop,Default,WoB,GoB,BoW,MnM,Browser,Gear1,Gear2,Gear3,Gear4,Nak", 0, 0, this);
                }
            } else if (msg.name.equals("OPTIONS")) {
                text = (String)msg.data;
                if (text.equals("ADD COLUMN")) {
                    new GPrompt(list2.this.MW, "AddColumn", "", 0, (MessageHandler)this);
                } else if (text.equals("CURSOR GRANULARITY...")) {
                    new GMenu(list2.this.MW, "Cursor", "Cell,Row,Column", this.curmode, 0, this);
                } else if (text.equals("HIGHLIGHT...")) {
                    new GMenu(list2.this.MW, "HIGHLIGHT", "Background,Foreground,Color", this.hilite, 0, this);
                } else if (text.equals("OUTPUTTYPE...")) {
                    new GMenu(list2.this.MW, "OUTPUTTYPE", "Auto,Vector,Table", this.outtype, 0, this);
                }
            } else {
                DataFile df;
                if (list2.this.MW == null || list2.this.MW.status == 0 || !list2.this.thisIsMe()) {
                    if (msg.name.equals("POINTER")) {
                        list2.this.MQ.remove(msg.name);
                    }
                    if (msg.name.equals("REFRESH") || msg.name.equals("RESIZE") || msg.name.startsWith("PAN")) {
                        list2.this.MQ.remove(msg.name);
                    }
                    list2.this.MQ.put(msg);
                    return -1;
                }
                if (msg.name.equals("SELECT")) {
                    this.sendMessage(msg);
                } else if (msg.name.equals("SELECTROW")) {
                    list2.this.M.warning("LIST2: Can not select row at this time.");
                } else if (msg.name.equals("DESELECT")) {
                    this.sendMessage(msg);
                } else if (msg.name.equals("POINTER")) {
                    if (list2.this.controls == 2) {
                        msg.data = null;
                        this.sendMessage(msg);
                    }
                } else if (msg.name.equals("BUTTON") && msg.info == -1) {
                    if (list2.this.controls == 1) {
                        msg.name = "MARK";
                        msg.data = null;
                        this.sendMessage(msg);
                    }
                } else if (msg.name.equals("REFRESH")) {
                    list2.this.MW.refresh();
                } else if (msg.name.equals("RESIZE")) {
                    list2.this.MW.resize(0);
                } else if (msg.name.equals("OPENFILE")) {
                    list2.this.openFile((String)msg.data);
                } else if (msg.name.equals("OPENTEMPLATE")) {
                    df = (DataFile)BaseFile.getInstanceFor(list2.this.M, (Object)msg.data.toString());
                    list2.this.getList().setTemplate(convert.convertTemplate2Table(df));
                } else if (msg.name.equals("APPLYTEMPLATE")) {
                    df = (DataFile)BaseFile.getInstanceFor(list2.this.M, (Object)msg.data.toString());
                    list2.this.getList().updateTemplate(convert.convertTemplate2Table(df));
                } else if (msg.name.equals("CLOSEFILE")) {
                    list2.this.closeFile();
                } else if (msg.name.equals("THEME")) {
                    list2.this.M.warning("LIST2: Theme must be set using LOOKANDFEEL command.");
                } else if (msg.name.equals("ADDCOLUMN")) {
                    list2.this.M.warning("LIST2: Can not add column at this time.");
                } else if (msg.name.equals("OUTPUTTYPE")) {
                    this.setOutputType(msg.info);
                } else if (msg.name.equals("HIGHLIGHT")) {
                    if (msg.info == 3) {
                        new GMenu(list2.this.MW, "Color", "THEME,Black,Blue,Cyan,Gray,Green,Magenta,Orange,Pink,Red,White,Yellow", 0, 0, this);
                    } else {
                        this.hilite = msg.info;
                        list2.this.M.warning("LIST2: Must use templates to set color.");
                    }
                } else if (msg.name.equals("CURSOR")) {
                    this.setCursorMode(msg.info);
                } else if (msg.name.equals("COLOR")) {
                    list2.this.M.warning("LIST2: Must use templates to set color.");
                } else if (msg.name.equals("EXIT")) {
                    list2.this.M.warning("LIST2: EXIT messages should be processed by normal LIST2 methods.");
                    status = 9;
                } else if (msg.name.equals("POP")) {
                    list2.this.M.warning("LIST2: POP messages should be processed by normal LIST2 methods.");
                }
            }
            return status;
        }

        public void sendMessage(Message msg) {
            if (this.msgid == msg.from) {
                return;
            }
            msg.to = this.msgid;
            msg.from = this;
            this.msgid.processMessage(msg);
        }

        public Object getRow(int index, int type) {
            return type == 3 ? this.getRowTable(index) : this.getRowVector(index);
        }

        public Vector<Object> getRowVector(int index) {
            Table tbl = this.getRowTable(index);
            Vector<Object> vect = new Vector<Object>();
            ListFile file = list2.this.getList().getListFile();
            for (int i = 0; i < file.getRecordDefCount(); ++i) {
                vect.add(tbl.get(file.getRecordDef(i).getS("NAME")));
            }
            return vect;
        }

        public Table getRowTable(int index) {
            return list2.this.getList().getRow(index);
        }

        public Object getRow(int index) {
            return this.getRow(index, this.outtype);
        }

        public void setOutputType(int type) {
            if (type == 1) {
                list2.this.M.warning("LIST2: Setting of OUTPUTTYPE=T_ONTYPE not supported, using T_TABLE");
                type = 3;
            }
            this.outtype = type;
        }

        public Object getColumn(int col, int type) {
            return type == 3 ? this.getColumnTable(col) : this.getColumnVector(col);
        }

        public Object getColumn(String name, int type) {
            return type == 3 ? this.getColumnTable(name) : this.getColumnVector(name);
        }

        public Object getColumn(int colIdx) {
            return this.getColumn(colIdx, this.outtype);
        }

        public Object getColumn(String subrName) {
            return this.getColumn(subrName, this.outtype);
        }

        public Object getColumnTable(int colIdx) {
            String name = list2.this.getList().getListFile().getRecordDef(colIdx - 1).getS("NAME");
            return this.getColumnTable(name);
        }

        public Vector<Object> getColumnVector(int colIdx) {
            String name = list2.this.getList().getListFile().getRecordDef(colIdx - 1).getS("NAME");
            return this.getColumnVector(name);
        }

        public Table getColumnTable(String subrName) {
            Vector<Object> vect = this.getColumnVector(subrName);
            Table tbl = new Table();
            for (int i = 0; i < vect.size(); ++i) {
                tbl.setKey(Integer.toString(i), vect.get(i));
            }
            return tbl;
        }

        public Vector<Object> getColumnVector(String subrName) {
            Vector<Object> vect = new Vector<Object>();
            ListFile file = list2.this.getList().getListFile();
            for (double offset = 0.0; offset < file.getNumberOfRows(); offset += 1.0) {
                vect.add(file.getDataTable(offset).getKey(subrName));
            }
            return vect;
        }

        public void setCursorMode(int value) {
            this.curmode = value;
            list2.this.mjlist.getTableSelectionModel().clearSelection(true);
        }

        public int getPollInterval() {
            return this.poll;
        }

        public void setPollInterval(int pollInterval) {
            this.poll = pollInterval;
        }

        public Table getSelRowsTable() {
            return list2.this.getList().getAllSelectedRows();
        }

        public Table getSelectedRowData() {
            return this.getSelRowsTable();
        }

        public void deselectAll() {
            list2.this.mjlist.getTableSelectionModel().clearSelection(true);
        }

        public int getMultiSelMsgMode() {
            return this.multiSelMsgMode;
        }

        public void setMultiSelMsgMode(String ms_mode) {
            if (ms_mode.equals("FULL")) {
                this.setMultiSelMsgMode(1);
            } else {
                this.setMultiSelMsgMode(0);
            }
        }

        public void setMultiSelMsgMode(int ms_mode) {
            if (ms_mode == 2) {
                list2.this.M.warning("LIST2: Multi select mode MULTISEL_LIST is TBD. Setting mode OFF.");
                this.multiSelMsgMode = 0;
            } else {
                this.multiSelMsgMode = ms_mode;
            }
        }

        public void selectMRow(long row) {
            list2.this.getList().selectRow(row, false);
        }

        public void selectRowByColValue(String column, String value, boolean ignoreCase) {
            list2.this.getList().selectRow(column, value, ignoreCase);
        }

        public void sortA(String subrToSort) {
            this.sort(subrToSort, false);
        }

        public void sortD(String subrToSort) {
            this.sort(subrToSort, true);
        }

        public void sort(String subrToSort, boolean sortDesc) {
            subrToSort = sortDesc ? "-" + subrToSort : "+" + subrToSort;
            list2.this.getList().setSort(subrToSort);
        }

        public void clear() {
            this.clear(true);
        }

        public void clear(boolean refresh) {
            list2.this.getList().removeAllRows();
        }

        public void clear(int tmp) {
            this.clear();
        }
    }
}

