/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.awt.Button;
import java.awt.Color;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JOptionPane;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Message;
import nxm.sys.lib.Table;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPrimitive;
import nxm.sys.libg.GPrompt;
import nxm.sys.libg.GridSheet;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MPanel;
import nxm.sys.libg.MWindow;

public class list
extends GPrimitive
implements Keyable,
GridSheet.GridSheetReference {
    private int controls = 1;
    private int scale = 0;
    private int mode = 0;
    private int view = 0;
    private int type = 0;
    private int realtime = 0;
    private int hilite = 1;
    private int exit = -1;
    private int poll = 0;
    private int outtype = 1;
    private int settings = 0;
    private int curmode = 0;
    private int colrIdx = 1;
    private long polltime = System.currentTimeMillis();
    private DataFile hcb;
    private Data data;
    private double size;
    private double[] mrkd = new double[3];
    private Data mrkData = new Data(this.mrkd);
    private boolean rescale = false;
    private String currentFilename;
    private String templateFilename;
    private String currColumn;
    private int currRow;
    private int currColSize;
    private boolean warnNonScalar = true;
    private boolean drawHidden = false;
    static final int EXIT_RETURN = 1;
    static final int EXIT_MENU = 2;
    static final int EXIT_MESSAGE = 4;
    static final int EXIT_ALL = 15;
    static final String exitList = "RETURN,MENU,MESSAGE";
    static final int ONCLICK = 1;
    static final int ONMOTION = 2;
    static final int T_ONTYPE = 1;
    static final int T_VECTOR = 2;
    static final int T_TABLE = 3;
    static final int T_CELL = 1;
    static final int T_ROW = 2;
    static final int T_COL = 3;
    static final int GRID = 1;
    static final int COLLABELS = 2;
    static final int ROWLABELS = 4;
    static final String colorChoices = "THEME,Black,Blue,Cyan,Gray,Green,Magenta,Orange,Pink,Red,White,Yellow";
    @Deprecated
    public GridSheet gs;
    private static String[] keys = new String[]{"NUMROWS", "NUMCOLS", "COLVECSIZE", "CURROW", "CURCOL", "SCELL", "CELL", "COLUMNVECTOR"};

    @Override
    public int open() {
        this.hilite = this.MA.getSelectionIndex("HILITE", "BACK,FORE", 1);
        this.controls = this.MA.getSelectionIndex("CNT=", "CLICK,CONT", 1);
        this.outtype = this.MA.getSelectionIndex("/OUTTYPE", "AUTO,VECTOR,TABLE", 1);
        this.poll = this.MA.getI("/POLL", (short)0);
        if (this.outtype == -1) {
            this.outtype = 1;
        }
        this.curmode = this.MA.getSelectionIndex("CURSOR", "CELL,ROW,COL", 1);
        if (this.curmode == -1) {
            this.curmode = 1;
        }
        this.realtime = this.MA.getL("/RT", 0);
        this.exit = this.M.pipeMode == 1 ? 0 : -1;
        try {
            this.exit = this.MA.getL("/EXIT", this.exit);
            if (this.MA.isPresent("/EXIT")) {
                this.M.deprecate("Since NeXtMidas 2.5.0, the use of numbers for /EXIT.  Use RETURN,MENU,MESSAGE");
            }
        }
        catch (Exception e) {
            this.exit = this.MA.getOptionMask("/EXIT", exitList, this.exit);
        }
        this.drawHidden = this.MA.getState("/DRAWHIDDEN", this.drawHidden);
        this.MW = new ListWindow("List", this);
        this.MW.open();
        this.MW.setSize(800, 500);
        this.MW.addTo(this);
        this.gs = new GridSheet();
        this.gs.setDragAndDrop(this.MA.getS("/DRAGDROP", "false", "true"));
        this.gs.addTo(this.MW);
        this.gs.setTheme();
        this.gs.setCursorMode(this.curmode);
        this.gs.setFgHilite(this.hilite == 2);
        this.gs.setWayneMode(this.MA.getState("/WAYNE", false));
        int refreshMode = this.MA.getSelectionIndex("/REFRESH", "Legacy,Timer".toUpperCase(), 1);
        this.gs.setRefreshMode(refreshMode);
        String colr = this.MA.getSelection("HCOLOR", colorChoices.toUpperCase(), "THEME");
        if (colr.equals("THEME")) {
            this.gs.setHighlight(this.MW.theme.cwfh);
        } else {
            this.gs.setHighlight(colr);
        }
        this.gs.setAutoSelect(this.MA.getState("AUTOSELECT", true));
        this.gs.setMultiSelMsgMode(this.MA.getS("MULTI", "OFF"));
        this.setScrollEnd(this.MA.getState("/SCROLLEND", false));
        this.currentFilename = this.MA.getCS("FILE");
        this.openFile(this.currentFilename);
        this.templateFilename = this.MA.getCS("TEMPLATE");
        this.openTemplateFile(0, this.templateFilename);
        this.settings = 0;
        if (this.MA.getState("/GRID", this.gs.getGrid())) {
            this.gs.setGrid(true);
            this.settings |= 1;
        } else {
            this.gs.setGrid(false);
        }
        if (this.MA.getState("/COLLABELS", this.gs.getColLabelsVisible())) {
            this.gs.setColLabels(true);
            this.settings |= 2;
        } else {
            this.gs.setColLabels(false);
        }
        if (this.MA.getState("/ROWLABELS", this.gs.getRowLabelsVisible())) {
            this.gs.setRowLabels(true);
            this.settings |= 4;
        } else {
            this.gs.setRowLabels(false);
        }
        this.refresh(1);
        return 0;
    }

    private boolean isVisible() {
        boolean visible = true;
        if (this.MW.panel != null) {
            Frame frame = JOptionPane.getFrameForComponent(this.MW.panel);
            if (!this.MW.panel.isShowing()) {
                visible = false;
            } else if (frame != null && frame.getExtendedState() == 1) {
                visible = false;
            }
        } else {
            visible = false;
        }
        return visible;
    }

    @Override
    public int process() {
        int nels;
        if (!(this.MW.status != -2 || this.drawHidden && this.gs.isVisible())) {
            return -1;
        }
        boolean doPoll = false;
        if (this.poll > 0) {
            doPoll = this.checkPollTime();
        }
        int stat = 0;
        stat = this.isVisible() || this.drawHidden && this.gs.isVisible() ? ((nels = this.getData(doPoll)) > 0 ? 0 : -1) : -1;
        return stat;
    }

    @Override
    public int close() {
        if (this.hcb != null) {
            this.hcb.close();
        }
        this.gs.close();
        this.MW.close();
        return 0;
    }

    private boolean checkPollTime() {
        boolean retval = false;
        if (System.currentTimeMillis() - this.polltime > (long)(this.poll * 1000)) {
            this.polltime = System.currentTimeMillis();
            retval = true;
        }
        return retval;
    }

    private void openFile(String name) {
        this.openFile(name, true);
    }

    private void openFile(String name, boolean doRefresh) {
        String[] s = new String[]{};
        int tmpType = 0;
        if (this.hcb != null) {
            this.hcb.close();
        }
        this.hcb = new DataFile();
        this.hcb.init(this.M, (Object)name);
        if (!this.hcb.open(64)) {
            return;
        }
        boolean rt = this.realtime > 0 || this.hcb.io.isStream();
        this.size = this.hcb.size;
        this.data = this.hcb.getDataBuffer((int)this.size);
        this.gs.clear(doRefresh);
        if (this.warnNonScalar && !this.hcb.getFormat().equals("NH") && !Data.isString(this.hcb.getFormatType()) && this.hcb.getFormatMode() != 83 && this.hcb.getFormatMode() != 49) {
            this.warnNonScalar = false;
            this.M.warning("LIST: LIST does not support files with non-scalar numbers, please use LIST2.");
        }
        tmpType = this.outtype;
        switch (this.hcb.typeClass) {
            case 1: {
                s = new String[]{"F1"};
                if (this.outtype != 1) break;
                tmpType = 2;
                break;
            }
            case 2: {
                int frameSize = this.hcb.getSubSize();
                s = new String[frameSize];
                for (int ii = 0; ii < frameSize; ++ii) {
                    s[ii] = "F" + (ii + 1);
                }
                if (this.outtype != 1) break;
                tmpType = 2;
                break;
            }
            case 3: 
            case 6: {
                int numSubs = this.hcb.getSubSize();
                s = new String[numSubs];
                for (int ii = 0; ii < numSubs; ++ii) {
                    s[ii] = this.hcb.getRecName(ii);
                }
                if (this.outtype != 1) break;
                tmpType = 3;
                break;
            }
            case 4: {
                this.M.warning("File type not supported yet: " + this.hcb.getType());
                if (this.outtype != 1) break;
                tmpType = 3;
                break;
            }
            case 5: {
                int numSubs = this.hcb.getSubSize();
                s = new String[numSubs];
                for (int ii = 0; ii < numSubs; ++ii) {
                    s[ii] = this.hcb.getCompName(ii);
                }
                if (this.outtype != 1) break;
                tmpType = 3;
                break;
            }
            default: {
                this.M.warning("File type not supported yet: " + this.hcb.getType());
                this.hcb.close();
                if (this.outtype != 1) break;
                tmpType = 2;
            }
        }
        if (s.length > 0) {
            this.gs.setColLabels(s);
        }
        this.gs.setOutputType(tmpType);
    }

    private void openTemplateFile(int n, String name) {
        DataFile templatehcb = new DataFile();
        templatehcb.init(this.M, (Object)name);
        if (!templatehcb.open(64)) {
            return;
        }
        this.gs.setTemplate(templatehcb.keywords);
        this.gs.applyTemplate();
        templatehcb.close();
        this.settings = 0;
        if (this.gs.getGrid()) {
            this.settings |= 1;
        }
        if (this.gs.getRowLabelsVisible()) {
            this.settings |= 4;
        }
        if (this.gs.getColLabelsVisible()) {
            this.settings |= 2;
        }
    }

    private void closeFile() {
        this.hcb.close();
        this.gs.clear();
        this.refresh();
    }

    private int getData(boolean doPoll) {
        int nelem = 0;
        if (doPoll) {
            this.openFile(this.currentFilename, false);
        }
        if (this.hcb != null && this.hcb.isOpen && this.hcb.avail() >= 1.0) {
            nelem = this.hcb.read(this.data);
            if (nelem <= 0) {
                return nelem;
            }
            switch (this.hcb.typeClass) {
                case 1: {
                    this.gs.addRows(this.data.toVector(), 1);
                    break;
                }
                case 2: {
                    this.gs.addRows(this.data.toVector(), this.hcb.getSubSize());
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    Vector<Vector<Object>> rows = new Vector<Vector<Object>>();
                    int j = 0;
                    int ioff = 0;
                    while ((double)j < this.size) {
                        Vector<Object> newRow = new Vector<Object>();
                        int subsize = this.hcb.getSubSize();
                        for (int i = 0; i < subsize; ++i) {
                            Data subdata = this.hcb.typeClass == 5 ? this.data.getAtomAt(ioff, this.hcb.getCompFormat(i)) : this.data.getAtomAt(ioff, this.hcb.getRecFormat(i));
                            if (subdata.toVector().size() == 1) {
                                newRow.addElement(subdata.toVector().elementAt(0));
                            } else {
                                newRow.addElement(subdata.toString());
                            }
                            ioff += subdata.bpe;
                        }
                        rows.addElement(newRow);
                        ++j;
                    }
                    this.gs.addRows(rows);
                    break;
                }
                default: {
                    this.M.info("Unknown file type");
                }
            }
        }
        return nelem;
    }

    private void refresh() {
        this.refresh(0);
    }

    private void refresh(int flag) {
        if (this.gs == null) {
            return;
        }
        if (flag == 1) {
            this.gs.refresh(true);
        } else {
            this.gs.refresh();
        }
    }

    private void resize() {
        this.gs.setSize(this.MW.panel.getSize());
    }

    @Override
    public int processMessage(Message msg) {
        String text;
        if (msg.name.equals("KEYPRESS")) {
            text = (String)msg.data;
            if (text.equalsIgnoreCase("M")) {
                msg.name = "MENU";
            }
            if (text.equalsIgnoreCase("Enter") && (this.exit & 1) != 0) {
                msg.name = "EXIT";
            }
        }
        if (msg.name.equals("BUTTON") && msg.info == 2) {
            msg.name = "MENU";
        }
        if (msg.name.equals("BUTTON") && msg.info == 3) {
            this.gs.deselectAll(true);
        }
        if (msg.name.equals("MENU")) {
            new GMenu(this.MW, "List", "Files...,Template...,Settings...,Control...,Window...,Options...,Other...,Exit", 0, 0, this);
        } else if (msg.name.equals("LIST")) {
            text = (String)msg.data;
            if (text.equals("FILES...")) {
                new GMenu(this.MW, "Files", "Open,Close,Reread", 0, 0, this);
            } else if (text.equals("TEMPLATE...")) {
                new GMenu(this.MW, "Template", "Open,Default", 0, 0, this);
            } else if (text.equals("CONTROL...")) {
                new GMenu(this.MW, "Controls", "Off,Click,Continuous,Assign...", this.controls + 1, 0, this);
            } else if (text.equals("WINDOW...")) {
                new GMenu(this.MW, "Window", "Toggle,Push,Pop", 0, 0, this);
            } else if (text.equals("OTHER...")) {
                new GMenu(this.MW, "Other", "Theme", 0, 0, this);
            } else if (text.equals("OPTIONS...")) {
                new GMenu(this.MW, "Options", "Add Column,Cursor Granularity...,Highlight...,OutputType...", 0, 0, this);
            } else if (text.equals("SETTINGS...")) {
                new GMenu(this.MW, "Settings", "Grid,Column Labels,Row Labels", this.settings, 1024, this);
            } else if (text.equals("EXIT")) {
                msg.name = "EXIT";
                if ((this.exit & 2) != 0) {
                    this.MQ.put(msg);
                }
            }
        } else if (msg.name.equals("FILES")) {
            text = (String)msg.data;
            if (text.equals("OPEN")) {
                new GPrompt(this.MW, "OpenFile", "", 0, (MessageHandler)this);
            } else if (text.equals("CLOSE")) {
                this.closeFile();
            } else if (text.equals("REREAD") && this.hcb != null) {
                this.openFile(this.currentFilename);
                this.openTemplateFile(0, this.templateFilename);
            }
        } else if (msg.name.equals("TEMPLATE")) {
            text = (String)msg.data;
            if (text.equals("OPEN")) {
                new GPrompt(this.MW, "OPENTEMPLATE", "", 0, (MessageHandler)this);
            } else if (text.equals("DEFAULT")) {
                this.openFile(this.currentFilename);
            }
        } else if (msg.name.equals("SETTINGS")) {
            this.settings = msg.info;
            if (!this.gs.getGrid() && (this.settings & 1) != 0) {
                this.gs.setGrid(true);
            }
            if (this.gs.getGrid() && (this.settings & 1) == 0) {
                this.gs.setGrid(false);
            }
            if (!this.gs.getColLabelsVisible() && (this.settings & 2) != 0) {
                this.gs.setColLabels(true);
            }
            if (this.gs.getColLabelsVisible() && (this.settings & 2) == 0) {
                this.gs.setColLabels(false);
            }
            if (!this.gs.getRowLabelsVisible() && (this.settings & 4) != 0) {
                this.gs.setRowLabels(true);
            }
            if (this.gs.getRowLabelsVisible() && (this.settings & 4) == 0) {
                this.gs.setRowLabels(false);
            }
        } else if (msg.name.equals("SETROW")) {
            this.gs.setOutputType(this.outtype);
            this.gs.setRow(msg.info, Convert.o2t(msg.data));
            this.MQ.put(msg, msg.from, (Object)this);
        } else if (msg.name.equals("GETROW")) {
            msg.data = this.gs.getRow(msg.info);
            this.MQ.put(msg, msg.from, (Object)this);
        } else if (msg.name.equals("GETROWVECTOR")) {
            msg.data = this.gs.getRowVector(msg.info);
            this.MQ.put(msg, msg.from, (Object)this);
        } else if (msg.name.equals("GETROWTABLE")) {
            msg.data = this.gs.getRowTable(msg.info);
            this.MQ.put(msg, msg.from, (Object)this);
        } else if (msg.name.equals("GETCOL")) {
            msg.data = this.gs.getColumn(msg.info);
            this.MQ.put(msg, msg.from, (Object)this);
        } else if (msg.name.equals("GETCOLUMNVECTOR")) {
            msg.data = this.gs.getColumnVector(msg.info);
            this.MQ.put(msg, msg.from, (Object)this);
        } else if (msg.name.equals("GETCOLUMNTABLE")) {
            msg.data = this.gs.getColumnTable(msg.info);
            this.MQ.put(msg, msg.from, (Object)this);
        } else if (msg.name.equals("CONTROLS")) {
            if (msg.info != 4) {
                this.controls = msg.info - 1;
            }
        } else if (msg.name.equals("WINDOW")) {
            text = (String)msg.data;
            if (text.equals("CLOSING")) {
                if (!this.thisIsMe()) {
                    this.MQ.put(msg);
                    return -1;
                }
                return 9;
            }
            if (text.equals("TOGGLE")) {
                this.MW.pop(-1);
            } else if (text.equals("PUSH")) {
                this.MW.pop(0);
            } else if (text.equals("POP")) {
                this.MW.pop(1);
            }
            if (!text.equals("CLOSED")) {
                this.refresh();
            }
        } else if (msg.name.equals("OTHER")) {
            text = (String)msg.data;
            if (text.equals("THEME")) {
                new GMenu(this.MW, "THEME", "DeskTop,Default,WoB,GoB,BoW,MnM,Browser,Gear1,Gear2,Gear3,Gear4,Nak", 0, 0, this);
            }
        } else if (msg.name.equals("OPTIONS")) {
            text = (String)msg.data;
            if (text.equals("ADD COLUMN")) {
                new GPrompt(this.MW, "AddColumn", "", 0, (MessageHandler)this);
            } else if (text.equals("CURSOR GRANULARITY...")) {
                new GMenu(this.MW, "Cursor", "Cell,Row,Column", this.curmode, 0, this);
            } else if (text.equals("HIGHLIGHT...")) {
                new GMenu(this.MW, "HIGHLIGHT", "Background,Foreground,Color", this.hilite, 0, this);
            } else if (text.equals("OUTPUTTYPE...")) {
                new GMenu(this.MW, "OUTPUTTYPE", "Auto,Vector,Table", this.outtype, 0, this);
            }
        } else {
            if (this.MW == null || this.MW.status == 0 || !this.thisIsMe()) {
                if (msg.name.equals("POINTER")) {
                    this.MQ.remove(msg.name);
                }
                if (msg.name.equals("REFRESH") || msg.name.equals("RESIZE") || msg.name.startsWith("PAN")) {
                    this.MQ.remove(msg.name);
                }
                this.MQ.put(msg);
                return -1;
            }
            if (msg.name.equals("SELECT")) {
                this.sendMessage(msg);
            } else if (msg.name.equals("SELECTROW")) {
                this.gs.selectRow(Convert.o2l(msg.data));
                this.sendMessage(msg);
            } else if (msg.name.equals("DESELECT")) {
                this.sendMessage(msg);
            } else if (msg.name.equals("POINTER")) {
                if (this.controls == 2) {
                    msg.data = null;
                    this.sendMessage(msg);
                }
            } else if (msg.name.equals("DROPDATA")) {
                this.sendMessage(msg);
            } else if (msg.name.equals("BUTTON") && msg.info == -1) {
                if (this.controls == 1) {
                    msg.name = "MARK";
                    msg.data = null;
                    this.sendMessage(msg);
                }
            } else if (msg.name.equals("REFRESH")) {
                this.refresh(1);
            } else if (msg.name.equals("RESIZE")) {
                this.resize();
            } else if (msg.name.equals("OPENFILE")) {
                this.currentFilename = (String)msg.data;
                this.openFile(this.currentFilename);
            } else if (msg.name.equals("OPEN TEMPLATE") || msg.name.equals("OPENTEMPLATE")) {
                if (msg.name.equals("OPEN TEMPLATE")) {
                    this.M.deprecate("OPEN TEMPLATE deprecated, use OPENTEMPLATE");
                }
                this.openFile(this.currentFilename);
                this.openTemplateFile(msg.info, (String)msg.data);
            } else if (msg.name.equals("APPLYTEMPLATE")) {
                this.openTemplateFile(msg.info, (String)msg.data);
            } else if (msg.name.equals("CLOSEFILE")) {
                this.closeFile();
            } else if (msg.name.equals("THEME")) {
                this.MW.setTheme((String)msg.data);
                this.gs.setTheme();
                this.refresh();
            } else if (msg.name.equals("ADDCOLUMN")) {
                text = (String)msg.data;
                if (text.length() > 0) {
                    this.gs.addColumns(text);
                }
            } else if (msg.name.equals("OUTPUTTYPE")) {
                this.outtype = msg.info;
                if (this.outtype == 1) {
                    switch (this.hcb.typeClass) {
                        case 1: 
                        case 2: {
                            this.gs.setOutputType(2);
                            break;
                        }
                        default: {
                            this.gs.setOutputType(3);
                            break;
                        }
                    }
                } else {
                    this.gs.setOutputType(this.outtype);
                }
            } else if (msg.name.equals("HIGHLIGHT")) {
                if (msg.info == 3) {
                    new GMenu(this.MW, "Color", colorChoices, this.colrIdx, 0, this);
                } else {
                    this.hilite = msg.info;
                    this.gs.setFgHilite(this.hilite == 2);
                }
            } else if (msg.name.equals("CURSOR")) {
                this.curmode = msg.info;
                this.gs.setCursorMode(this.curmode);
            } else if (msg.name.equals("COLOR")) {
                this.colrIdx = msg.info;
                if (this.colrIdx == 1) {
                    this.gs.setHighlight(this.MW.theme.cwfh.darker());
                } else {
                    this.gs.setHighlight((String)msg.data);
                }
            } else if (msg.name.equals("EXIT")) {
                if ((this.exit & 4) != 0) {
                    return 9;
                }
            } else if (msg.name.equals("POP")) {
                this.MW.pop(-1);
                this.refresh(1);
            }
        }
        return 0;
    }

    @Override
    public void sendMessage(Message msg) {
        super.sendMessage(msg);
    }

    @Override
    public Object setKey(String name, Object value) {
        if (name.equals("ADDROW")) {
            this.gs.setOutputType(this.outtype);
            this.gs.addRow(Convert.o2t(value));
        } else if (name.equals("ADDROWS")) {
            this.gs.setOutputType(this.outtype);
            Table inTable = Convert.o2t(value);
            String[] keys = inTable.getKeys();
            for (int z = 0; z < keys.length; ++z) {
                Table tt = inTable.getTable(keys[z]);
                if (tt == null) continue;
                try {
                    this.gs.addRow(tt);
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("Exception " + ex);
                    System.out.println("Adding " + tt);
                }
            }
        } else if (name.equals("SETROW")) {
            this.gs.setOutputType(this.outtype);
            this.gs.setRow(-1, Convert.o2t(value));
        } else if (name.equals("ROWBYVALUE")) {
            this.currRow = this.gs.getRowByValue(Convert.o2t(value));
        } else if (name.equals("CURRROW")) {
            this.currRow = Convert.o2l(value);
        } else if (name.equals("CURRCOL")) {
            this.currColumn = Convert.o2s(value);
        } else if (name.equals("REMOVEROW")) {
            this.gs.removeRow(Convert.o2l(value));
        } else if (name.equals("REMOVECURRROW")) {
            this.gs.removeRow(this.currRow);
        } else if (name.equals("SELECTROW")) {
            this.gs.selectRow(Convert.o2l(value));
        } else if (name.equals("SELECTMROW")) {
            this.gs.selectRow(Convert.o2l(value), false);
        } else if (name.equals("SELECTCELLS")) {
            this.gs.selectCells(Convert.o2t(value));
        } else if (name.equals("SORTA")) {
            this.gs.sort(Convert.o2s(value), false);
        } else if (name.equals("SORTD")) {
            this.gs.sort(Convert.o2s(value), true);
        } else if (name.equals("SHOWCOL")) {
            this.gs.setColVisible(Convert.o2s(value), true);
        } else if (name.equals("HIDECOL")) {
            this.gs.setColVisible(Convert.o2s(value), false);
        } else if (name.equals("SHOWALL")) {
            this.gs.setColVisible("ALLCOLUMNS", true);
        } else if (name.equals("HIDEALL")) {
            this.gs.setColVisible("ALLCOLUMNS", false);
        } else if (name.equals("SETCELL")) {
            this.gs.setCell(Convert.o2t(value));
        } else if (name.equals("COLRASTER")) {
            this.gs.changeColumnRender(Convert.o2s(value), 3);
            this.gs.setColWidth(Convert.o2s(value));
        } else if (name.equals("COLSTRING")) {
            this.gs.changeColumnRender(Convert.o2s(value), 1);
            this.gs.setColWidth(Convert.o2s(value));
        } else if (name.equals("COLTOG")) {
            this.gs.changeColumnRender(Convert.o2s(value), 5);
            this.gs.setColWidth(Convert.o2s(value));
        } else if (name.equals("COLPANEL")) {
            Vector<Object> v = this.gs.changeColumnRender(Convert.o2s(value), 2);
            if (v != null) {
                int maxWidth = 0;
                for (int i = 0; i < v.size(); ++i) {
                    MPanel mp = (MPanel)v.elementAt(i);
                    Button test = new Button("ON");
                    test.setForeground(Color.green);
                    test.setBackground(Color.black);
                    test.setSize(50, this.gs.getRowHeight());
                    maxWidth = Math.max(maxWidth, 50);
                    mp.add(test);
                }
                this.gs.setColWidth(Convert.o2s(value), maxWidth);
            }
        } else if (name.equals("RASTERDATA")) {
            byte[] buf = new byte[60];
            for (int i = 0; i < 60; ++i) {
                buf[i] = (byte)(Math.random() * 12.0);
            }
            this.gs.setRasterData(Convert.o2t(value), buf);
        } else if (name.equals("SETCELLCOLORS")) {
            Table t = Convert.o2t(value);
            Color fgColor = t.get("FG") == null ? null : MColor.getColor(Convert.o2s(t.get("FG")));
            Color bgColor = t.get("BG") == null ? null : MColor.getColor(Convert.o2s(t.get("BG")));
            this.gs.setCellColors(Convert.o2l(t.get("COLUMN")), Convert.o2l(t.get("ROW")), fgColor, bgColor);
        } else if (name.equals("SETROWCOLORS")) {
            Table t = Convert.o2t(value);
            Color fgColor = null;
            Color bgColor = null;
            if (t.get("FG") != null) {
                fgColor = MColor.getColor(Convert.o2s(t.get("FG")));
            }
            if (t.get("BG") != null) {
                bgColor = MColor.getColor(Convert.o2s(t.get("BG")));
            }
            this.gs.setRowColors(Convert.o2l(t.get("ROW")), fgColor, bgColor);
        } else if (name.equals("SETCOLCOLORS")) {
            Table t = Convert.o2t(value);
            Color fgColor = null;
            Color bgColor = null;
            if (t.get("FG") != null) {
                fgColor = MColor.getColor(Convert.o2s(t.get("FG")));
            }
            if (t.get("BG") != null) {
                bgColor = MColor.getColor(Convert.o2s(t.get("BG")));
            }
            this.gs.setColColors(Convert.o2l(t.get("COLUMN")), fgColor, bgColor);
        } else {
            return null;
        }
        return value;
    }

    @Override
    public String[] getKeys() {
        return keys;
    }

    @Override
    public Object getKey(String name) {
        if (name.equals("NUMROWS")) {
            return Convert.l2o(this.gs.getRowCount());
        }
        if (name.equals("NUMCOLS")) {
            return Convert.l2o(this.gs.getColCount());
        }
        if (name.equals("COLVECSIZE")) {
            return Convert.l2o(this.currColSize);
        }
        if (name.equals("CURRROW")) {
            return Convert.l2o(this.currRow);
        }
        if (name.equals("CURRCOL")) {
            return this.currColumn;
        }
        if (name.equals("SCELL")) {
            return Convert.o2s(this.gs.getCell(this.currRow, this.currColumn));
        }
        if (name.equals("CELL")) {
            return this.gs.getCell(this.currRow, this.currColumn);
        }
        if (name.equals("COLUMNVECTOR") && this.currColumn != null) {
            Object v = this.gs.getColumnVector(this.currColumn);
            this.currColSize = ((Vector)v).size();
            return v;
        }
        return null;
    }

    public int getPollInterval() {
        return this.poll;
    }

    public void setPollInterval(int pollInterval) {
        this.poll = pollInterval;
    }

    public void setScrollEnd(int i) {
        boolean scrollState = false;
        if (i == 1) {
            scrollState = true;
        }
        this.setScrollEnd(scrollState);
    }

    public void setScrollEnd(boolean scrollToEnd) {
        this.gs.scrollEndSw = scrollToEnd;
    }

    @Override
    public Object getNextLink() {
        return this.gs;
    }

    public static String getColorChoices() {
        return colorChoices;
    }

    @Override
    public GridSheet getGridSheet() {
        return this.gs;
    }

    private class ListWindow
    extends MWindow {
        public ListWindow(String name, MessageHandler mh) {
            super(name, mh, true);
        }

        @Override
        protected Table getHelpData() {
            Table data = new Table();
            data.put("NAME", (Object)list.this.getID());
            data.put("VALUE", list.this.gs.getSelectedCellData());
            data.put("ROW", list.this.gs.getSelectedRow());
            data.put("COL", list.this.gs.getSelectedColumn());
            return data;
        }
    }
}

