/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.net;

import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.util.Map;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.net.Rmif;

public class RmifSM
extends Rmif {
    public RmifSM(MessageHandler handler) {
        this(null, null, handler);
    }

    public RmifSM(Midas M, MessageHandler owner, MessageHandler handler) {
        super(M, owner, handler, true);
        this.logStateMachineInconsistencies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.packetReader != null) {
            try {
                this.packetReader.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.dsock != null && !this.dsock.isClosed()) {
            try {
                this.dsock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.closeRemote(this.wdef);
        double time = Time.current();
        Map map = this._fastRemotes;
        synchronized (map) {
            Object[] keys = this._fastRemotes.keySet().toArray();
            for (int i = 0; i != keys.length; ++i) {
                this.removeRemote((Rmif.Remote)this._fastRemotes.get(keys[i]));
            }
        }
        if (this.nchannel > 0) {
            while (Time.current() - time < this.timeCloseOut) {
                boolean ok = true;
                for (int ic = 1; ic <= this.nchannel; ++ic) {
                    if (this.getChannel(ic) == null || this.getChannel((int)ic).state == 116) continue;
                    ok = false;
                }
                if (ok) break;
                Time.sleep(0.1);
            }
        }
        this.channels.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean recvPacket() {
        try {
            Rmif.Remote remote;
            this.dpacki.setLength(this.buffi.length);
            this.dsock.receive(this.dpacki);
            int len = this.dpacki.getLength();
            int seq = this.buffi[4];
            byte func = this.buffi[0];
            byte retry = this.buffi[5];
            byte info = this.buffi[2];
            int doff = 8;
            int dlen = len - doff;
            int port = this.dpacki.getPort();
            InetAddress addr = this.dpacki.getAddress();
            boolean sendQuietClose = false;
            String fastRemoteID = this.createFastLookupKey(addr, port);
            Rmif.Remote r = (Rmif.Remote)this._fastRemotes.get(fastRemoteID);
            if (func == 109 && info == 105) {
                this.removeRemoteQuiet(r);
                String host = addr.getHostAddress();
                r = this.createClientRemote(fastRemoteID, host, port);
            }
            boolean badState = true;
            if (r != null) {
                remote = r;
                synchronized (remote) {
                    if (func == 123 || func == 106) {
                        badState = false;
                    } else if (r.isOpened()) {
                        badState = false;
                    } else if (r.isClient()) {
                        if (r.isOpening() && func == 105) {
                            badState = false;
                        } else if (func == 109 && info == 105) {
                            badState = false;
                        } else if ((r.getState() == 113 || r.getState() == 116) && func == 105) {
                            badState = false;
                        } else if (r.isClosed() && func == 106) {
                            return false;
                        }
                    } else if (r.isOpening() && (func == 110 || func == 115)) {
                        badState = false;
                    } else {
                        sendQuietClose = true;
                    }
                }
            } else if (func == 104 || func == 103) {
                sendQuietClose = true;
            }
            if (badState) {
                String message = null;
                if (sendQuietClose) {
                    this.buffi[0] = 106;
                    this.buffi[4] = -1;
                    this.buffi[2] = -106;
                    this.dpacki.setLength(8);
                    this.dsock.send(this.dpacki);
                    message = "Sent CLOSE to unsolicited server for Packet";
                } else {
                    message = "Rejecting unsolicited Packet";
                }
                this.info(message + " seq=" + seq + " retry=" + retry + " func=" + func + "(" + RmifSM.functionName(func) + ") info=" + info + "(" + RmifSM.functionName(info) + ") from " + (r != null ? r.toString() : addr.getHostAddress() + ":" + port));
                return false;
            }
            if (this.debug) {
                this.debug("recvPacket -> " + new Rmif.Packet(this.buffi, 0, len, false) + " from " + r);
            }
            this.linkBytes += (double)(len + this.packetOverhead);
            remote = r;
            synchronized (remote) {
                r.linkBytes += (double)(len + this.packetOverhead);
                double currentTime = Time.current();
                if (func == 123) {
                    Rmif.Packet pkt;
                    Rmif.Packet packet = pkt = r.sendBuf[seq];
                    synchronized (packet) {
                        double sendTime = pkt.time;
                        double latency = currentTime - sendTime;
                        if (!(sendTime <= 0.0) && !(latency > (double)MAXLAT) && retry <= 0) {
                            r.latency = r.latency == 0.0 ? latency : r.latency * 0.9 + latency * 0.1;
                        }
                        pkt.clear(0.0);
                    }
                    return false;
                }
                if (func == 124) {
                    if (info >= 0 && this.testLinkPkt < 128) {
                        this.testLinkBuf[this.testLinkPkt++] = info;
                    } else if (info == -1) {
                        this.testLinkPkt = 0;
                    } else if (info == -2) {
                        this.sendPacket((byte)124, -3, this.testLinkBuf, r, 1);
                    } else if (info == -3) {
                        this.testLinkReport(r, dlen, this.buffi, doff);
                    } else if (info == -4) {
                        this.testLinkReport(r, this.testLinkPkt, this.testLinkBuf, 0);
                    } else if (info <= -5) {
                        this.testLink(r, -this.buffi[8]);
                    }
                    return false;
                }
                Rmif.Packet pkt = null;
                if (seq >= 0) {
                    if (this.verbose || this.logfile != null) {
                        int slen = func >= 111 && func <= 118 ? 0 : dlen;
                        String text = "RECV func=" + RmifSM.functionName(func) + " seq=" + seq + " try=" + retry + " info=" + this.buffi[2] + " data=" + Convert.unpackS(this.buffi, doff, slen) + " from " + r + " at " + Time.tag();
                        if (this.verbose) {
                            this.info(text);
                        } else {
                            this.logfile.writeln(text);
                        }
                    }
                    pkt = r.recvBuf[seq];
                    int nextExpectedSeq = r.recvChk + 1 & 0x7F;
                    int maxExpectedSeq = nextExpectedSeq + r.getWindow() & 0x7F;
                    int minExpectedSeq = nextExpectedSeq - r.getWindow() & 0x7F;
                    boolean outOfRange = this.seqOutOfRange((byte)seq, nextExpectedSeq, maxExpectedSeq);
                    int estimatedPacketsLost = seq - maxExpectedSeq;
                    if (seq < maxExpectedSeq) {
                        estimatedPacketsLost += 128;
                    }
                    if (func == 105 && info == 0 || r.isOpening() && func == 115) {
                        nextExpectedSeq = seq;
                    } else if (pkt.time > 0.0 && retry == 0) {
                        int overlapCount = seq - nextExpectedSeq;
                        if (seq < nextExpectedSeq) {
                            overlapCount += 128;
                        }
                        if (overlapCount > 10) {
                            if (this.logfile != null) {
                                this.logfile.writeln("WARN: IGNORING new overlapping packet, old=" + pkt.toStringShort());
                            }
                            this.warning("IGNORING new overlapping packet seq=" + seq + " retry=" + retry + " func=" + func + "(" + RmifSM.functionName(func) + ") info=" + info + "(" + RmifSM.functionName(info) + ") from " + r.toString());
                            return false;
                        }
                    } else if (outOfRange) {
                        boolean outOfProcessedRange = this.seqOutOfRange((byte)seq, minExpectedSeq, nextExpectedSeq);
                        if (outOfProcessedRange) {
                            this.warning("Out of range seq=" + seq + " nextExpectedSeq=" + nextExpectedSeq + " minExpectedSeq=" + minExpectedSeq + " maxExpectedSeq=" + maxExpectedSeq + " retry=" + retry + " func=" + func + "(" + RmifSM.functionName(func) + ") info=" + info + "(" + RmifSM.functionName(info) + ") from " + r.toString());
                        } else {
                            this.sendReceipt(func, len);
                            if (this.verbose || this.logfile != null) {
                                int slen = func >= 111 && func <= 118 ? 0 : dlen;
                                String text = "Out of range seq=" + seq + " nextExpectedSeq=" + nextExpectedSeq + " minExpectedSeq=" + minExpectedSeq + " maxExpectedSeq=" + maxExpectedSeq + " RECEIPT func=" + RmifSM.functionName(func) + " seq=" + seq + " try=" + retry + " info=" + this.buffi[2] + " data=" + Convert.unpackS(this.buffi, doff, slen) + " from " + r + " at " + Time.tag();
                                if (this.verbose) {
                                    this.info(text);
                                } else {
                                    this.logfile.writeln(text);
                                }
                            }
                        }
                        return false;
                    }
                    this.sendReceipt(func, len);
                    if ((this.verbose || this.logfile != null) && seq >= 0) {
                        int slen = func >= 111 && func <= 118 ? 0 : dlen;
                        String text = "RECEIPT func=" + RmifSM.functionName(func) + " seq=" + seq + " try=" + retry + " info=" + this.buffi[2] + " data=" + Convert.unpackS(this.buffi, doff, slen) + " from " + r + " at " + Time.tag();
                        if (this.verbose) {
                            this.info(text);
                        } else {
                            this.logfile.writeln(text);
                        }
                    }
                    if (seq != nextExpectedSeq && retry > 0) {
                        if (pkt.time > 0.0) {
                            return false;
                        }
                        if (pkt.time < 0.0) {
                            if (outOfRange && estimatedPacketsLost > 10) {
                                return false;
                            }
                            double timeDiff = currentTime + pkt.time;
                            double rtd = r.latency == 0.0 ? r.timeRetry : r.timeRetry + r.latency;
                            double timePeriod = (double)retry * rtd;
                            if (timeDiff < timePeriod) {
                                return false;
                            }
                        }
                    }
                    if (seq != nextExpectedSeq && r.isOpened()) {
                        if (outOfRange) {
                            this.checkRecvQueue(r, estimatedPacketsLost);
                            nextExpectedSeq = r.recvChk + 1 & 0x7F;
                        }
                        for (int k = 0; k < 10 && pkt.time > 0.0 && r.recvQueue > 0; ++k) {
                            estimatedPacketsLost = seq - nextExpectedSeq;
                            if (seq < nextExpectedSeq) {
                                estimatedPacketsLost += 128;
                            }
                            this.checkRecvQueue(r, estimatedPacketsLost);
                            nextExpectedSeq = r.recvChk + 1 & 0x7F;
                        }
                        if (pkt.time > 0.0 && this.logfile != null) {
                            this.logfile.writeln("WARN: OVERWRITTING EXISTING PACKET at seq=" + seq + " old=" + pkt.toStringShort());
                        }
                        if (seq != nextExpectedSeq) {
                            pkt.initialize(this.buffi, 0, len, currentTime, true);
                            ++r.recvQueue;
                            if (r.recvQueue > 80) {
                                String warnMsg = "WARN: RDP receive queue is FULL! recvQueue=" + r.recvQueue;
                                if (this.logfile == null) {
                                    this.warning(warnMsg);
                                } else {
                                    this.logfile.writeln(warnMsg);
                                }
                            }
                            return false;
                        }
                    }
                    r.recvChk = seq;
                }
                this.procPacket(this.buffi, dlen, r);
                if (pkt != null) {
                    pkt.clear(-currentTime);
                }
                if (r.recvQueue > 0) {
                    this.checkRecvQueue(r, -1);
                }
            }
            if (this.sockrecverr > 0) {
                this.info("Total Packet recv errs: " + this.sockrecverr);
                this.sockrecverr = 0;
            }
            return true;
        }
        catch (InterruptedIOException len) {
        }
        catch (Exception e) {
            if (this.packetReader.isAborted()) {
                return false;
            }
            if ("Interrupted system call".equals(e.getMessage())) {
                return false;
            }
            if (this.sockrecverr == 0) {
                this.printStackTrace("Exception in recvPacket", e);
                this.sendLinkProblemReport(null, "Exception in recvPacket: " + e.getMessage(), null);
            }
            ++this.sockrecverr;
        }
        return false;
    }

    @Override
    boolean remoteClosedShouldNotSendPacket(Rmif.Remote r, byte func) {
        return r.state != 115 && func != 105 && func != 115 && func != 109 && func != 110;
    }

    @Override
    void procPacket(byte[] buf, int len, Rmif.Remote r) {
        byte info;
        double time = 0.0;
        byte chanNum = info = buf[2];
        byte func = buf[0];
        int seq = buf[4];
        try {
            if ((buf[1] & 0x10) != 0) {
                time = Convert.unpackD(buf, 8);
            }
            int doff = buf[7];
            len -= doff;
            doff += 8;
            double currentTime = Time.current();
            switch (func) {
                case 112: 
                case 117: {
                    Rmif.Channel chan = this.getChannel(chanNum);
                    if (chan == null || chan.df == null || r == null) {
                        this.warning("Got unSolicited DBUF " + chanNum + " " + r.addr + ":" + r.port);
                        break;
                    }
                    if (seq < 0 && chan.df.io.avail() < (long)len) {
                        this.warning("Pipe full remote " + r + " - dumping unreliable data");
                        break;
                    }
                    if (func == 117) {
                        int uclen;
                        if (time > 0.0) {
                            chan.df.setTimeAt(time);
                        }
                        if ((uclen = this.uncompress(buf, doff, len, this.uncbuf)) <= 0) break;
                        chan.df.write(this.uncbuf, 0, uclen);
                        break;
                    }
                    if (time > 0.0) {
                        chan.df.setTimeAt(time);
                    }
                    chan.df.write(buf, doff, len);
                    break;
                }
                case 111: {
                    Rmif.Channel chan = this.getChannel(chanNum);
                    if (chan == null) break;
                    DataFile df = chan.df;
                    if (df != null && df.isOpen) {
                        if (!this.reOpen) break;
                        df.flags |= 0x100;
                        df.close();
                    }
                    byte[] db = new byte[512];
                    System.arraycopy(buf, doff, db, 0, 512);
                    df = new DataFile();
                    df.init(this.ref, (Object)chan.name, db, 0);
                    if (df.getTypeCodeClass() != 1 && df.getBPE() * 4.0 > (double)df.defPipeSize) {
                        this.info("RMIF: Increase pipe size for: " + chan.name + " to: " + df.getBPE() * 4.0 + " from: " + df.defPipeSize);
                        df.defPipeSize = Math.min(2000000, (int)df.getBPE() * 4);
                    }
                    df.open(2);
                    chan.df = df;
                    break;
                }
                case 101: 
                case 102: 
                case 103: 
                case 104: {
                    Table tbl = new Table();
                    if (this.caseSensitive) {
                        tbl.setFlags(tbl.getFlagsInt() | 0x40);
                    }
                    tbl.fromBytes(buf, doff, len + doff);
                    String msgname = "BAD";
                    if (tbl.containsKey("MSGNAME")) {
                        msgname = tbl.getString("MSGNAME");
                        tbl.remove("MSGNAME");
                    } else if (func == 101) {
                        msgname = "SET";
                    } else if (func == 103) {
                        msgname = "RET";
                    } else if (func == 102) {
                        msgname = "GET";
                    } else if (func == 104) {
                        msgname = "ACK";
                    }
                    this.handle(msgname, chanNum, tbl, r);
                    break;
                }
                case 107: {
                    break;
                }
                case 108: {
                    break;
                }
                case 125: {
                    Table tbl = new Table();
                    if (this.caseSensitive) {
                        tbl.setFlags(tbl.getFlagsInt() | 0x40);
                    }
                    tbl.fromBytes(buf, doff, len + doff);
                    if (this.verbose) {
                        this.info("Got MFTP from " + r + " " + tbl);
                    }
                    this.processMftpMessage(tbl, r);
                    break;
                }
                case 109: {
                    if (this.verbose) {
                        this.info("Got a PING message from " + r + " info=" + info);
                    }
                    if (!this.checkClientRemoteState(r, func)) break;
                    r.timePong = currentTime;
                    int protocol = info != 115 ? 1 : 0;
                    this.sendPacket((byte)110, chanNum, r, protocol);
                    break;
                }
                case 110: {
                    if (this.verbose) {
                        this.info("Got PONG from " + r + " info=" + info);
                    }
                    if (!this.checkServerRemoteState(r, func)) break;
                    r.timePong = currentTime;
                    if (!r.isOpening()) break;
                    this.openRemote(r);
                    break;
                }
                case 105: {
                    if (this.verbose) {
                        this.info("Got OPEN from " + r + " chan=" + chanNum);
                    }
                    if (!this.checkClientRemoteState(r, func)) break;
                    if (chanNum <= 0) {
                        r.rep = buf[3];
                        r.state = (byte)115;
                        r.recvChk = seq;
                        r.timePong = currentTime;
                        this.sendPacket((byte)115, 0, r, 0);
                        this.handle("OPEN", chanNum, r, this.owner);
                        break;
                    }
                    if (r.isOpened()) {
                        this.serveChannel(r, chanNum, new String(buf, doff, len));
                        break;
                    }
                    this.warning("Cannot open channel on closed remote");
                    break;
                }
                case 115: {
                    if (!this.checkServerRemoteState(r, func)) break;
                    if (chanNum == 0) {
                        if (r.isOpened()) {
                            if (!this.verbose) break;
                            this.info("Channel already opened");
                            break;
                        }
                        r.state = (byte)115;
                        r.rep = buf[3];
                        for (int ic = 1; ic <= this.nchannel; ++ic) {
                            Rmif.Channel chan = this.getChannel(ic);
                            if (chan == null) {
                                if (!this.verbose) continue;
                                this.info("channel is null for " + ic + ",r=" + r);
                                continue;
                            }
                            if ((chan.flags & 1) != 0) {
                                this.openChannel(ic, r);
                                continue;
                            }
                            if (chan.r != r) {
                                this.warning("No channel open for " + ic + ". On different remote " + r);
                                continue;
                            }
                            if (chan.state == 115) {
                                if (!this.verbose) continue;
                                this.info("Channel already open" + r);
                                continue;
                            }
                            if (chan.state != 105) continue;
                            this.openChannel(ic, r);
                        }
                        this.handle("OPENED", chanNum, r, this.owner);
                        break;
                    }
                    if (!this.verbose) break;
                    this.info("Already opened channel n=" + chanNum);
                    break;
                }
                case 106: {
                    if (this.verbose) {
                        this.info("Got CLOSE from " + r + " info/chanNum=" + info);
                    }
                    if (chanNum != -106 && !this.checkClientRemoteState(r, func)) break;
                    if (chanNum <= 0) {
                        this.removeRemoteQuiet(r);
                        break;
                    }
                    for (int ip = 1; ip <= this.nproperty; ++ip) {
                        this.delMember(r, chanNum, ip);
                    }
                    this.sendPacket((byte)116, chanNum, r, 0);
                    break;
                }
                case 116: {
                    if (!this.checkServerRemoteState(r, func)) break;
                    if (chanNum == 0) {
                        r.state = (byte)116;
                        this.handle("CLOSED", chanNum, r, this.owner);
                        break;
                    }
                    if (chanNum <= 0) break;
                    this.closedChannel(chanNum, r);
                    break;
                }
                case 114: {
                    if (r == null || !r.isOpened()) {
                        this.warning("Cannot modify an unOpened remote");
                        break;
                    }
                    Table tbl = new Table();
                    if (this.caseSensitive) {
                        tbl.setFlags(tbl.getFlagsInt() | 0x40);
                    }
                    tbl.fromBytes(buf, doff, len + doff);
                    this.procModify(tbl, r);
                    break;
                }
                case 121: {
                    String string = Convert.l2s(this.nproperty);
                    if (chanNum > 0 && chanNum <= this.nproperty) {
                        string = this.getProperty((int)chanNum).name;
                    }
                    this.sendPacket((byte)122, chanNum, string.getBytes(), r, 0);
                    break;
                }
                case 122: {
                    String string = new String(buf, doff, len);
                    if (this.verbose) {
                        this.info("KeyName[" + chanNum + "]=" + string);
                    }
                    if (chanNum == 0) {
                        if (this.verbose) {
                            this.info("Getting individual keys");
                        }
                        int nkeys = Integer.parseInt(string);
                        for (int i = 1; i <= nkeys; ++i) {
                            this.sendPacket((byte)121, i, r, 0);
                        }
                        break;
                    }
                    this.handle("PROPERTY", chanNum, string, r);
                    break;
                }
            }
            if (r != null && r.state == 115) {
                r.timePong = currentTime;
            }
        }
        catch (Exception e) {
            this.printStackTrace("Exception in procPacket from remote " + r, e);
            this.sendLinkProblemReport(r, "Exception in procPacket: " + e.getMessage(), new Rmif.Packet(buf, 0, len));
        }
    }

    @Override
    public Rmif.Remote addRemote(Table targs) {
        if (this.debug) {
            this.debug("addRemote targs=" + targs);
        }
        Rmif.Remote r = new Rmif.Remote(this);
        try {
            KeyObject.setKeys(r, targs);
            r.addr = InetAddress.getByName(r.host);
            Rmif.Remote rold = this.indexRemote(r.port, r.addr);
            if (rold != null) {
                if (r.id != null && !r.id.equals(rold.id)) {
                    this.info("Overriding old remote ID " + rold.id + " with " + r.id);
                    rold.setID(r.id);
                }
                r = rold;
            }
            if (r.id != null && this.M != null) {
                this.M.registry.put(r.id, r);
            } else {
                r.id = this.id;
            }
            r.rmif = this;
            r.mh = this.owner;
            if (this.verbose) {
                this.info("Remote address: " + r.addr + " on port " + r.port + " -> " + r);
            }
            if (r.isClosed()) {
                r.state = (byte)113;
            } else if (this.verbose) {
                this.info("ReOpening unclosed remote " + r);
            }
            if (r.mh == null) {
                this.warning("addRemote() MessageHandler is null for " + r);
            }
            this._fastRemotes.put(this.createFastLookupKey(r.addr, r.port), r);
        }
        catch (Exception e) {
            this.info("Problem=" + e.getMessage() + "   with addRemote=" + targs);
            r = null;
        }
        return r;
    }

    @Override
    Rmif.Remote indexRemote(int port, InetAddress addr) {
        return (Rmif.Remote)this._fastRemotes.get(this.createFastLookupKey(addr, port));
    }

    @Override
    void openRemote(Rmif.Remote r) {
        if (this.debug | this.verbose) {
            this.info("Opening remote " + r);
        }
        if (r != null) {
            this.resetSendQueue(r);
            this.resetRecvQueue(r, -1);
            this.sendPacket((byte)105, 0, r, 0);
        } else {
            this.warning("Bad remote on openRemote");
        }
    }

    @Override
    void unOpenRemote(Rmif.Remote r, double time) {
        if (this.debug) {
            this.debug("unOpenRemote " + r + " time=" + time + " timePong=" + r.timePong + " timeLast(Ping)=" + r.timeLast);
        }
        if (r.isOpening()) {
            return;
        }
        if (r.isClient() && r.timePong == 0.0) {
            return;
        }
        this.info("Closing timed out client " + r + " time: " + time + " r.timePong " + r.timePong + " deltatime: " + (time - r.timePong) + " timeOut: " + this.timeOut);
        this.removeRemoteQuiet(r);
    }

    @Override
    public void removeRemote(Rmif.Remote r) {
        if (r == null) {
            return;
        }
        this._fastRemotes.remove(this.createFastLookupKey(r.addr, r.port));
        if (r.isOpened()) {
            this.closeRemote(r);
        }
        if (r.isOpening()) {
            this.closeRemote(r);
        }
        if (r.id != null && this.M != null) {
            this.M.registry.remove(r.id);
        }
    }

    @Override
    public void closeRemote(Rmif.Remote r) {
        if (this.debug) {
            this.debug("closeRemote r=" + r);
        }
        if (r == null) {
            return;
        }
        if (r.id != null && this.M != null) {
            this.M.registry.remove(r.id);
        }
        if (this.verbose) {
            this.info("Closing remote " + r);
        }
        for (int ic = 1; ic <= this.nchannel; ++ic) {
            Rmif.Channel c = this.getChannel(ic);
            if (c == null || c.r != r || c.state == 116) continue;
            this.closeChannel(ic);
        }
        for (int ip = 1; ip <= this.nproperty; ++ip) {
            this.delMember(r, -1, ip);
        }
        if (r.isOpened() && !r.isClient()) {
            this.sendPacket((byte)106, 0, r, 0);
        }
        this.resetRecvQueue(r, -1);
        this.resetSendQueue(r);
        r.state = (byte)116;
    }

    boolean seqOutOfRange(byte seq, int minExpectedSeq, int maxExpectedSeq) {
        boolean outOfProcessedRange = false;
        outOfProcessedRange = minExpectedSeq < maxExpectedSeq ? seq < minExpectedSeq || maxExpectedSeq < seq : maxExpectedSeq < seq && seq < minExpectedSeq;
        return outOfProcessedRange;
    }

    boolean checkClientRemoteState(Rmif.Remote r, byte func) {
        if (r == null) {
            this.error("Received func=" + func + "(" + RmifSM.functionName(func) + ") from null Remote server");
            return false;
        }
        if (!r.isClient()) {
            this.error("Recieved func=" + func + "(" + RmifSM.functionName(func) + ") from a server. " + r);
            return false;
        }
        return true;
    }

    boolean checkServerRemoteState(Rmif.Remote r, byte func) {
        if (r == null) {
            this.error("Received func=" + func + "(" + RmifSM.functionName(func) + ") from null Remote client");
            return false;
        }
        if (r.isClient()) {
            this.error("Recieved func=" + func + "(" + RmifSM.functionName(func) + ") from a client. " + r);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRemoteQuiet(Rmif.Remote r) {
        if (r == null) {
            return;
        }
        Rmif.Remote remote = r;
        synchronized (remote) {
            this._fastRemotes.remove(this.createFastLookupKey(r.addr, r.port));
            if (r.id != null && this.M != null) {
                this.M.registry.remove(r.id);
            }
            this.closeClientChannels(r);
            for (int ip = 1; ip <= this.nproperty; ++ip) {
                this.delMember(r, -1, ip);
            }
            this.resetRecvQueue(r, -1);
            this.resetSendQueue(r);
            r.state = (byte)116;
        }
    }

    void closeClientChannels(Rmif.Remote r) {
        for (int ic = 1; ic <= this.nchannel; ++ic) {
            Rmif.Channel c = this.getChannel(ic);
            if (c == null || c.r != r || c.state == 116) continue;
            c.state = (byte)116;
            c.r = null;
        }
    }

    private void logStateMachineInconsistencies() {
        StringBuilder logOfBadState = new StringBuilder();
        if (this.allOriginalMessages) {
            logOfBadState.append("Excessive Logging ON : ");
        }
        if (!this.supplimentalLogging) {
            logOfBadState.append("Supplemental Logging OFF : ");
        }
        if (logOfBadState.length() == 0) {
            return;
        }
        String badStateMessage = "RMIF/STATM settings are not those recommended for operational usage : " + logOfBadState.toString() + " Please consider adjusting the settings mentioned.";
        this.info(badStateMessage);
    }

    class PacketReader
    extends Rmif.PacketReader {
        public PacketReader(Rmif rmif2) {
            super(rmif2);
        }

        @Override
        public void run() {
            while (!this.abort) {
                this.rmif.recvPacket();
            }
        }
    }
}

