/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Foreign;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.TextFile;

@InternalUseOnly
public final class NetUtil {
    private static String[] domainNames;

    private NetUtil() {
    }

    public static String getLocalHost() throws UnknownHostException {
        return NetUtil.getFQDN(InetAddress.getLocalHost());
    }

    public static String getFQDN(String name) {
        try {
            return StringUtil.isNull(name) ? name : NetUtil.getFQDN(InetAddress.getByName(name));
        }
        catch (UnknownHostException e) {
            return name;
        }
        catch (SecurityException e) {
            return name;
        }
    }

    public static String getFQDN(InetAddress hostAddr) {
        if (hostAddr == null) {
            return null;
        }
        String hostName = hostAddr.getHostName();
        String address = hostAddr.getHostAddress();
        if (hostName.contains(".")) {
            return hostName;
        }
        for (String domainName : NetUtil.getDomainNames()) {
            try {
                String testName = hostName + "." + domainName;
                InetAddress testHost = InetAddress.getByName(testName);
                if (!address.equals(testHost.getHostAddress())) continue;
                return testName;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String canonical = hostAddr.getCanonicalHostName();
        return canonical.equals(address) ? hostName : canonical;
    }

    @InternalUseOnly
    private static synchronized String[] getDomainNames() {
        if (domainNames != null) {
            return domainNames;
        }
        if (Shell.ostype.equals("UNIX")) {
            TextFile tf = new TextFile(null, (Object)"/etc/resolv.conf");
            if (tf.open(32)) {
                String domain = null;
                String[] search = null;
                for (String line : tf.readAllLines()) {
                    int i = line.indexOf(35);
                    if (i > 0) {
                        line = line.substring(0, i);
                    }
                    if ((line = line.trim()).startsWith("domain ") || line.startsWith("domain\t")) {
                        domain = line.substring(6).trim();
                        continue;
                    }
                    if (!line.startsWith("search ") && !line.startsWith("search\t") || (search = line.substring(6).trim().split("[ \t]+")).length <= 6) continue;
                    search = Arrays.copyOf(search, 6);
                }
                tf.close();
                if (search != null) {
                    domainNames = search;
                    return search;
                }
                if (domain != null) {
                    domainNames = new String[]{domain};
                    return domainNames;
                }
            }
            try {
                InetAddress localAddr = InetAddress.getLocalHost();
                String localHost = localAddr.getCanonicalHostName();
                int index = localHost.indexOf(46);
                if (index > 0) {
                    return new String[]{localHost.substring(index + 1)};
                }
            }
            catch (Exception localAddr) {}
        } else if (Shell.ostype.equals("DOS")) {
            StringBuilder out = new StringBuilder();
            StringBuilder err = new StringBuilder();
            int status = Foreign.runInternal("ipconfig /all", out, err);
            String domain = null;
            ArrayList<String> search = new ArrayList<String>();
            if (status == 0) {
                String lastName = null;
                for (String line : out.toString().split("\r\n")) {
                    String value;
                    String name;
                    if ((line = line.trim()).isEmpty()) {
                        lastName = null;
                        continue;
                    }
                    int index = line.indexOf(58);
                    if (index < 0) {
                        name = lastName;
                        value = line;
                    } else {
                        name = line.substring(0, index).trim().toLowerCase();
                        value = line.substring(index + 1).trim();
                    }
                    if (!value.isEmpty() && name != null && !name.isEmpty()) {
                        if (name.startsWith("primary dns suffix")) {
                            domain = value;
                        } else if (name.startsWith("dns suffix search list")) {
                            String[] vals = value.split("[ \t]+");
                            search.addAll(Arrays.asList(vals));
                        }
                    }
                    lastName = name;
                }
                if (!search.isEmpty()) {
                    domainNames = search.toArray(StringUtil.EMPTY_STRING_ARRAY);
                    return domainNames;
                }
                if (domain != null) {
                    domainNames = new String[]{domain};
                    return domainNames;
                }
            }
        }
        domainNames = StringUtil.EMPTY_STRING_ARRAY;
        return StringUtil.EMPTY_STRING_ARRAY;
    }
}

