/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Pattern;
import nxm.sys.inc.AsciiMap;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.net.HFile;
import nxm.sys.net.HFiles;
import nxm.sys.net.HServer;
import nxm.sys.net.HSource;

public class HPage
implements Runnable,
AsciiMap {
    private static boolean DEBUG = false;
    private static final Pattern DISP_SEP = Pattern.compile("[ ]*;[ ]*");
    private static final String RFC1123_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    private static final String RFC850_DATE_PATTERN = "EEEE, dd-MMM-yy HH:mm:ss 'GMT'";
    private static final String ASCTIME_DATE_PATTERN = "EEE MMM d HH:mm:ss yyyy";
    private final SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
    public static final String EOLSTR = "\r\n";
    public static final byte[] EOL = "\r\n".getBytes();
    public final HServer server;
    private Table reqHeader = null;
    private Table resHeader;
    private MultipartData[] postData;
    private Socket sock;
    private BufferedOutputStream os;
    private BufferedInputStream is;
    private String method;
    private String uri;
    private String version;
    private int status = 400;
    private boolean opened = false;
    private boolean closed = false;
    private String scheme = "US-ASCII";
    private String WS_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    byte[] m = new byte[4];

    public HPage(HServer server, Socket sock) throws IOException {
        this(server, sock, "US-ASCII");
    }

    public HPage(HServer server, Socket sock, String scheme) throws IOException {
        this.resHeader = new Table();
        this.setDate(new Date());
        this.resHeader.put("Server", (Object)("NeXtMidas/4.1.4 Java/" + Shell.getJavaVersion()));
        this.setContentType("text/html");
        this.server = server;
        this.sock = sock;
        this.scheme = scheme;
        this.os = new BufferedOutputStream(sock.getOutputStream());
        this.is = new BufferedInputStream(sock.getInputStream());
    }

    @Override
    public void run() {
        try {
            this.parseRequest();
            this.handleRequest();
            this.close();
            this.sock.close();
        }
        catch (Exception e) {
            Shell.printStackTrace("HPAGE: Error processing request URI=" + this.uri, e);
            this.close();
            try {
                this.sock.close();
            }
            catch (Exception ex) {
                Shell.printStackTrace("HPAGE: Can not close socket. URI=" + this.uri, ex);
            }
        }
        if (DEBUG) {
            System.out.println("Done " + this.uri);
        }
    }

    private void parseRequest() throws IOException {
        String line = this.readline();
        if (DEBUG) {
            System.out.println("Req: " + line);
        }
        if (line == null) {
            return;
        }
        int i = line.indexOf(32);
        int j = line.lastIndexOf(32);
        if (i < 0 || j < 0 || j <= i) {
            throw new IllegalArgumentException("Improperly formatted request line : " + line + "  HOST=" + this.sock.getRemoteSocketAddress());
        }
        this.method = line.substring(0, i);
        this.uri = line.substring(i + 1, j);
        this.version = line.substring(j + 1);
        this.reqHeader = this.readHeader();
        if (this.server.parent != null && this.uri.indexOf(94) >= 0) {
            this.uri = this.server.parent.MA.evaluateCarets(this.uri);
        }
        if (this.method.equals("POST")) {
            this.postData = this.readPost(this.reqHeader);
        }
    }

    private MultipartData[] readPost(Table header) throws IOException {
        String contentType = header.getS("Content-Type", null);
        String contentLength = header.getS("Content-Length", null);
        int bytes = contentLength == null ? -1 : Convert.s2l(contentLength);
        byte[] midBoundary = null;
        byte[] endBoundary = null;
        if (contentType != null && contentType.startsWith("multipart/")) {
            int i;
            String str = contentType;
            while (str.length() > 0 && (i = str.indexOf(59)) >= 0) {
                int j = (str = str.substring(i + 1).trim()).indexOf(61);
                if (j < 0) continue;
                int k = str.indexOf(59, j);
                if (k < 0) {
                    k = str.length();
                }
                String key = str.substring(0, j).trim();
                String val = str.substring(j + 1, k).trim();
                if (!key.equalsIgnoreCase("boundary")) continue;
                String mid = "--" + val + EOLSTR;
                String end = "--" + val + "--" + EOLSTR;
                midBoundary = mid.getBytes();
                endBoundary = end.getBytes();
                break;
            }
        }
        if (midBoundary == null) {
            if (bytes < 0) {
                bytes = this.is.available();
            }
            byte[] buf = new byte[bytes];
            int off = 0;
            int len = bytes;
            while (len > 0) {
                int read = this.is.read(buf, off, len);
                if (read == 0) {
                    Time.sleep(0.1);
                    continue;
                }
                if (read < 0) {
                    throw new IOException("End of data before boundary reached.");
                }
                off += read;
                len -= read;
            }
            return new MultipartData[]{new MultipartData(header, buf)};
        }
        boolean done = this.readHeaderGap(midBoundary, endBoundary);
        ArrayList<MultipartData> parts = new ArrayList<MultipartData>();
        block2: while (!done) {
            Table head = this.readHeader();
            String ct = head.getS("Content-Type", null);
            if (ct != null && ct.startsWith("multipart/")) {
                MultipartData[] mpd = this.readPost(head);
                parts.add(new MultipartData(head, mpd));
                done = this.readHeaderGap(midBoundary, endBoundary);
                continue;
            }
            if (DEBUG) {
                System.out.println("Dat: <data>");
            }
            byte[] data = new byte[4096];
            int len = 0;
            while (true) {
                byte[] line = this.readln();
                boolean mid = Arrays.equals(line, midBoundary);
                boolean end = Arrays.equals(line, endBoundary);
                if (mid || end) {
                    parts.add(new MultipartData(head, data, 0, len - 2));
                    done = end;
                    continue block2;
                }
                if (len + line.length > data.length) {
                    int lgth = (len + line.length + 4095) / 4096 * 4096;
                    byte[] temp = new byte[lgth];
                    System.arraycopy(data, 0, temp, 0, len);
                    data = temp;
                }
                System.arraycopy(line, 0, data, len, line.length);
                len += line.length;
            }
        }
        return parts.toArray(new MultipartData[0]);
    }

    public MultipartData[] getPostData() {
        return this.postData;
    }

    public MultipartData getPostData(String name) {
        if (this.postData == null) {
            return null;
        }
        for (MultipartData mpd : this.postData) {
            String disp = mpd.getHeaderValue("Content-Disposition");
            if (disp == null || !disp.startsWith("form-data;")) continue;
            String[] params = DISP_SEP.split(disp);
            for (int i = 1; i < params.length; ++i) {
                String given;
                if (!params[i].startsWith("name=\"") || !params[i].endsWith("\"") || !name.equals(given = params[i].substring(6, params[i].length() - 1))) continue;
                return mpd;
            }
        }
        return null;
    }

    public String getMethod() {
        return this.method;
    }

    public Table getParameters() {
        String decodedURI = this.uri;
        try {
            decodedURI = URLDecoder.decode(this.uri, this.scheme);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Table tbl = HSource.getParameters(decodedURI, null);
        if (this.postData != null) {
            for (MultipartData mpd : this.postData) {
                String disp = mpd.getHeaderValue("Content-Disposition");
                String mime = mpd.getHeaderValue("Content-Type");
                byte[] data = mpd.getData();
                if (mime == null || data == null || data.length == 0 || disp != null && !disp.startsWith("form-data;") || !mime.equals("application/x-url-encoded") && !mime.equals("application/x-www-form-urlencoded")) continue;
                String params = "?" + new String(data);
                HSource.getParameters(params, tbl);
            }
        }
        return tbl;
    }

    private void handleRequest() throws IOException {
        if ("GET".equals(this.method) || "HEAD".equals(this.method) || "POST".equals(this.method)) {
            HSource ds = this.server.getSource(this.uri);
            if (DEBUG) {
                Shell.writeln("HPage.handleRequest() uri=" + this.uri + " ds=" + ds);
            }
            if (ds == null) {
                this.setStatus(404);
                this.open();
                this.writeNotFound();
            } else if (this.method.equals("HEAD") && !(ds instanceof HFiles) && !(ds instanceof HFile)) {
                this.setStatus(200);
            } else {
                this.setStatus(200);
                ds.handleRequest(this.uri, this);
            }
        } else {
            this.setStatus(501);
        }
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public static void setDebug(boolean val) {
        DEBUG = val;
    }

    public static boolean getDebug() {
        return DEBUG;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void openSocket() {
        this.open();
    }

    public void closeSocket() {
        this.close();
    }

    public void open() {
        if (!this.opened) {
            this.writeHeader();
            this.flush();
            this.opened = true;
        }
    }

    public void close() {
        if (!this.closed) {
            if (!this.opened) {
                this.open();
            }
            this.flush();
            this.closed = true;
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.os != null) {
                try {
                    this.os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void openToBody(String title) {
        this.openUpToBody(title);
        this.writeln("<body>");
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.6.0")
    public void openUpToBody(String title) {
        this.open();
        this.writeln("<html>");
        this.writeln("<head>");
        if (title != null) {
            this.writeln("<title>" + title + "</title>");
        }
        this.writeln("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        this.writeln("<meta http-equiv=\"Pragma\" content=\"no-cache\">");
        String hdir = this.server.getHomeDir();
        if (hdir != null) {
            this.writeln("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + hdir + "/style.css\">");
        }
        this.writeln("</head>");
    }

    public void closeFromBody() {
        this.writeln("</body>");
        this.writeln("</html>");
        this.close();
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.6.0")
    public void openWS(String protocol) {
        String key = this.getHeader("Sec-WebSocket-Key");
        String hash = Convert.encodeBase64(Convert.getSHA1(key + this.WS_GUID));
        this.write("HTTP/1.1 101 Switching Protocols\r\n");
        this.write("Upgrade: websocket\r\n");
        this.write("Connection: upgrade\r\n");
        this.write("Sec-WebSocket-Accept: " + hash + EOLSTR);
        this.write("Sec-WebSocket-Protocol: " + protocol + EOLSTR);
        this.write(EOL);
        this.flush();
        this.opened = true;
        this.resHeader = null;
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.6.0")
    public void closeWS() {
        this.close();
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.6.0")
    public int recvWS(byte[] b, int off, int bytes) {
        int len = 0;
        try {
            int i;
            boolean masked;
            int d = this.is.read();
            if (d < 0) {
                return -1;
            }
            int op = d & 0x7F;
            d = this.is.read();
            len = d & 0x7F;
            boolean bl = masked = (d & 0x80) != 0;
            if (len == 126) {
                len = 0;
                for (i = 0; i < 2; ++i) {
                    len = len << 8 | this.is.read();
                }
            }
            if (len == 127) {
                len = 0;
                for (i = 0; i < 8; ++i) {
                    len = len << 8 | this.is.read();
                }
            }
            if (masked) {
                for (i = 0; i < 4; ++i) {
                    this.m[i] = (byte)this.is.read();
                }
            }
            this.is.read(b, off, len);
            if (masked) {
                for (i = 0; i < len; ++i) {
                    b[i] = (byte)(b[i] ^ this.m[i % 4]);
                }
            }
            switch (op) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return len;
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.6.0")
    public int sendWS(byte[] b, int off, int bytes) {
        int i = 0;
        this.m[i++] = -126;
        if (bytes < 126) {
            this.m[i++] = (byte)bytes;
        } else {
            this.m[i++] = 126;
            this.m[i++] = (byte)(bytes >> 8 & 0xFF);
            this.m[i++] = (byte)(bytes >> 0 & 0xFF);
        }
        try {
            this.os.write(this.m, 0, i);
            this.os.write(b, off, bytes);
            this.os.flush();
        }
        catch (Exception e) {
            bytes = 0;
        }
        return bytes;
    }

    public void flush() {
        block2: {
            try {
                this.os.flush();
            }
            catch (IOException e) {
                String emsg = e.getMessage();
                if ("Connection reset".equals(emsg) || emsg.startsWith("Broken pipe") || emsg.startsWith("Connection or outbound has closed")) break block2;
                Shell.getSharedMidasContext().warning("HPAGE Error while flushing uri=" + this.uri + ": " + e);
            }
        }
    }

    public void setContentType(String type) {
        this.resHeader.put("Content-Type", (Object)type);
    }

    public void setContentLength(long bytes) {
        this.resHeader.put("Content-Length", (Object)Long.toString(bytes));
    }

    void setContentRange(long firstBytePos, long lastBytePos, long totalLength) {
        String rangeResponse;
        String instanceLength = totalLength < 0L ? "*" : Long.toString(totalLength);
        if (firstBytePos > lastBytePos) {
            rangeResponse = "*";
            this.setStatus(416);
        } else {
            rangeResponse = firstBytePos + "-" + lastBytePos;
            this.setStatus(206);
        }
        this.resHeader.put("Content-Range", (Object)("bytes " + rangeResponse + "/" + instanceLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDate(Date date) {
        String datetimestr;
        SimpleDateFormat simpleDateFormat = this.httpDateFormat;
        synchronized (simpleDateFormat) {
            datetimestr = this.httpDateFormat.format(date);
        }
        this.resHeader.put("Date", (Object)datetimestr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastModified(Date date) {
        String datetimestr;
        SimpleDateFormat simpleDateFormat = this.httpDateFormat;
        synchronized (simpleDateFormat) {
            datetimestr = this.httpDateFormat.format(date);
        }
        this.resHeader.put("Last-Modified", (Object)datetimestr);
    }

    public Table getRequestHeader() {
        return this.reqHeader;
    }

    public String getHeader(String key) {
        if (this.reqHeader == null) {
            return null;
        }
        return this.reqHeader.getS(HPage.toTitleCase(key));
    }

    @InternalUseOnly(value="Since added in NeXtMidas 3.6.0")
    public void dumpHeader() {
        this.reqHeader.dump();
    }

    public double getHeaderD(String key) {
        String value = this.getHeader(key);
        if (value == null) {
            return -1.0;
        }
        int i = value.indexOf(61);
        int j = value.indexOf(45);
        return Convert.s2d(value.substring(i + 1, j));
    }

    private static String toTitleCase(String key) {
        if (key == null || key.length() == 0) {
            return key;
        }
        char[] chars = key.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        for (int i = 1; i < chars.length; ++i) {
            chars[i] = chars[i - 1] == '-' ? Character.toUpperCase(chars[i]) : Character.toLowerCase(chars[i]);
        }
        return new String(chars);
    }

    private void writeHeader() {
        if (this.resHeader == null) {
            return;
        }
        int bytes = this.write("HTTP/1.1 " + this.status + " " + EOLSTR);
        if (bytes > 0) {
            String key;
            String[] stringArray = this.resHeader.getKeys();
            int n = stringArray.length;
            for (int i = 0; i < n && (bytes = this.write((key = stringArray[i]) + ": " + this.resHeader.getS(key) + EOLSTR)) >= 0; ++i) {
            }
        }
        if (bytes > 0) {
            this.write(EOL);
        }
        this.resHeader = null;
    }

    public int write(String line) {
        return this.write(line.getBytes(), 0, -1);
    }

    public int writeln(String line) {
        int stat = this.write(line.getBytes(), 0, -1);
        if (stat < 0) {
            return stat;
        }
        return stat + this.write(EOL, 0, EOL.length);
    }

    public void writeFile(Object ref, Object fname) {
        int toWrite;
        long len;
        BaseFile file = ref instanceof MidasReference ? new BaseFile((MidasReference)ref, fname) : new BaseFile(Convert.ref2Midas(ref), fname);
        file.open();
        byte[] buf = new byte[BaseFile.BUFFER_SIZE];
        this.setContentType(BaseFile.getMimeType(ref, fname));
        this.setContentLength(len);
        this.open();
        file.io.seek(0L);
        for (len = (long)file.getSize(); len > 0L; len -= (long)toWrite) {
            int toRead = Math.min(buf.length, (int)Math.min(Integer.MAX_VALUE, len));
            toWrite = file.read(buf, 0, toRead);
            if (toWrite < 0) {
                throw new MidasException("End of file reached " + len + " bytes before end of file was expected.");
            }
            this.write(buf, 0, toWrite);
        }
        this.close();
        file.close();
    }

    public int write(byte[] buf) {
        return this.write(buf, 0, buf.length);
    }

    public int write(byte[] buf, int off, int len) {
        if (len < 0) {
            len = buf.length;
        }
        try {
            this.os.write(buf, off, len);
            return len;
        }
        catch (IOException e) {
            if (!e.getMessage().startsWith("Connection reset") && !e.getMessage().startsWith("Broken pipe")) {
                Shell.getSharedMidasContext().printStackTrace("HPage err: " + e + " on " + this.uri, e);
            }
            return -1;
        }
    }

    private Table readHeader() throws IOException {
        String line = this.readline();
        Table head = new Table();
        while (line != null && line.length() > 0) {
            int index;
            if (DEBUG) {
                System.out.println("Hdr: " + line);
            }
            if ((index = line.indexOf(58)) > 0) {
                String key = line.substring(0, index).trim();
                String val = line.substring(index + 1).trim();
                head.put(HPage.toTitleCase(key), (Object)val);
            }
            line = this.readline();
        }
        if (line == null) {
            throw new IOException("Got EOF before end of header");
        }
        return head;
    }

    private boolean readHeaderGap(byte[] midBoundary, byte[] endBoundary) throws IOException {
        byte[] line;
        do {
            if ((line = this.readln()) == null) {
                throw new IOException("End of data before boundary reached.");
            }
            if (DEBUG) {
                System.out.println("Gap: " + new String(line));
            }
            if (!Arrays.equals(line, midBoundary)) continue;
            return false;
        } while (!Arrays.equals(line, endBoundary));
        return true;
    }

    public void write(ByteArrayOutputStream baos) {
        try {
            baos.writeTo(this.os);
        }
        catch (IOException e) {
            Shell.getSharedMidasContext().printStackTrace("HPage err: " + e + " on " + this.uri, e);
        }
    }

    public void writeNotFound() {
        if (this.method.equals("HEAD")) {
            return;
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("<html><head><title>404 Not Found</title></head>\n");
        sb.append("<body><h1>Not Found</h1>\n");
        sb.append("<p>The requested URL <code>").append(this.uri).append("</code> was not found on this server.</p>\n");
        sb.append("</body></html>");
        this.writeln(sb.toString());
    }

    private String readline() throws IOException {
        byte[] line = this.readln();
        if (line == null) {
            return null;
        }
        String str = new String(line);
        if (str.endsWith(EOLSTR)) {
            str = str.substring(0, str.length() - 2);
        }
        return str;
    }

    private byte[] readln() throws IOException {
        int b;
        byte[] buf = new byte[4096];
        int len = 0;
        while ((b = this.is.read()) >= 0) {
            if (len + 2 > buf.length) {
                byte[] temp = new byte[buf.length * 2];
                System.arraycopy(buf, 0, temp, 0, len);
                buf = temp;
            }
            if (b == 13) {
                int b2 = this.is.read();
                buf[len++] = (byte)b;
                buf[len++] = (byte)b2;
                if (b2 != 10) continue;
                break;
            }
            buf[len++] = (byte)b;
        }
        if (b < 0 && len == 0) {
            return null;
        }
        byte[] line = new byte[len];
        System.arraycopy(buf, 0, line, 0, len);
        return line;
    }

    public BufferedInputStream getInputStream() {
        return this.is;
    }

    public PrintStream getOutputStream() {
        return new PrintStream(this.os, true){

            @Override
            public void println() {
                this.print(HPage.EOLSTR);
            }
        };
    }

    public Socket getSocket() {
        return this.sock;
    }

    @Deprecated
    public boolean isHeadRequest() {
        return this.method.equals("HEAD");
    }

    @Deprecated
    public boolean isGetRequest() {
        return this.method.equals("GET");
    }

    @Deprecated
    public boolean isNotRequest() {
        return this.method.equals("OPTIONS") || this.method.equals("POST") || this.method.equals("PUT") || this.method.equals("DELETE") || this.method.equals("TRACE") || this.method.equals("CONNECT");
    }

    public static class MultipartData {
        private final Table header;
        private final byte[] data;
        private final MultipartData[] mpd;

        public MultipartData(Table header, byte[] data) {
            this(header, data, 0, data.length);
        }

        public MultipartData(Table header, byte[] data, int off, int len) {
            if (len < 0) {
                len = 0;
            }
            if (off != 0 || len != data.length) {
                byte[] temp = new byte[len];
                System.arraycopy(data, off, temp, 0, len);
                data = temp;
            }
            this.header = header;
            this.data = data;
            this.mpd = null;
        }

        MultipartData(Table header, MultipartData[] mpd) {
            this.header = header;
            this.data = null;
            this.mpd = mpd;
        }

        public String getHeaderValue(String key) {
            if (this.header == null) {
                return null;
            }
            return this.header.getS(HPage.toTitleCase(key));
        }

        public byte[] getData() {
            return this.data;
        }

        public String getDataString() {
            return new String(this.getData());
        }

        public MultipartData[] getMultipartData() {
            return this.mpd;
        }
    }
}

