/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.net;

import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import nxm.sys.lib.Convert;
import nxm.sys.lib.ICEPacket;
import nxm.sys.lib.Shell;

@Deprecated
public class DatagramData {
    private int timeOut = 200;
    private boolean verbose = false;
    private boolean packetDebug = false;
    private boolean packetDataDebug = false;
    private boolean multicast = false;
    private boolean rtp = true;
    private boolean checkhdr = false;
    private boolean sap = false;
    private boolean fill = false;
    private boolean alladdr = false;
    private boolean isOpen = false;
    private boolean socketerror = false;
    private boolean icehdrinpipe = false;
    private boolean geticedata = false;
    private String host = new String("127.0.0.1");
    private int port = 18800;
    private String osname = System.getProperty("os.name").toUpperCase();
    private boolean windows = this.osname.startsWith("WINDOWS");
    private boolean ignore_rtcp = true;
    private double wsec;
    private double fsec;
    private double tcoff;
    private double dp1;
    private double dp2;
    private float fp1;
    private float fp2;
    private float fp3;
    private float fp4;
    String ifrmt = "";
    int isize = 0;
    int ibpa = 0;
    ICEPacket lastICE = null;
    private static final int MAXPKTBUF = 32768;
    private static int pktBufferSize = 32768;
    private InetAddress addr;
    private DatagramSocket dsock;
    private MulticastSocket msock;
    private int len;
    private int offset;
    private int ci;
    private int boff;
    private int ccs;
    private int extendflag;
    private int xtype;
    private int xlen;
    private int sublen;
    private int temp;
    private int ipver;
    private int state;
    private int encrypt;
    private int compress;
    private int authlen;
    private int datapos;
    private int pos;
    private int i;
    private int lastseq = -1;
    private int llseq = -1;
    private int seq = -1;
    private int hi;
    private int lo;
    private int fillnum = 0;
    private int lasthdr = -1;
    private int llhdr = -1;
    private int timepacktype = -1;
    private int timepackpos = 0;
    private int timepacklen = 0;
    private int complen = 0;
    private int rtpfiltertype = -1;
    private int seqreset = 0;
    private IceTimeCallBack timeCB = null;
    private IceTimeFloatDataCallBack timeDCB = null;
    private SDDSTimeDataCallBack timeSCB = null;
    private RTCPCallBack rtcpCB = null;
    private int packetStart = 0;
    private int PacketPos = -1;
    public static final int COMPOUND_PACKET = 255;
    public static final int ICE1_PACKET = 1;
    public static final int ICE2_PACKET = 8;
    public static final int ICE3_PACKET = 16;
    public static final int SDDS_PACKET = 17;
    public static final int XSTREAM_PACKET = 4;
    public static final int MAC_PACKET = 18;
    private Inflater decompressor = null;
    private Cipher cipher = null;
    private Key cipherkey = null;
    private PBEKeySpec pbeKeySpec = null;
    private AlgorithmParameterSpec pbeParamSpec = null;
    private String ciphertype = "PBEWithSHA1AndDESede";
    private Mac mac = null;
    private int ITERATIONS = 1000;
    private SecretKeySpec signingkey = null;
    private String hmactype = "HmacSHA1";
    private byte[] signature = new byte[20];
    private byte[] fakesignature = "00000000000000000000".getBytes();
    private byte[] bufholder = new byte[20];
    private boolean sigpass;
    private byte[] tcbuf = new byte[8];
    private static final long ticsPerSecond = 4000000000L;
    long tics;
    long lwsec;
    long lfsec;
    private byte[] buf = new byte[pktBufferSize];
    private byte[] rtcpbuf;
    private DatagramPacket dpacki = new DatagramPacket(this.buf, this.buf.length);
    private static final byte RTPVPXCC = 0;
    private static final byte RTPMPT = 1;
    private static final byte RTPSQH = 2;
    private static final byte RTPSQL = 3;
    private static final byte RTPTS1 = 4;
    private static final byte RTPTS2 = 5;
    private static final byte RTPTS3 = 6;
    private static final byte RTPTS4 = 7;
    private static final byte RTPSSRC1 = 8;
    private static final byte RTPSSRC2 = 9;
    private static final byte RTPSSRC3 = 10;
    private static final byte RTPSSRC4 = 11;
    private static final byte RTPDATA = 12;
    private static final byte SAPVARTEC = 0;
    private static final byte SAPAUTHLEN = 1;
    private static final byte SAPMSGHASHH = 2;
    private static final byte SAPMSHHASHL = 3;
    private static final byte SAPORIG1 = 4;
    private static final byte SAPORIG2 = 5;
    private static final byte SAPORIG3 = 6;
    private static final byte SAPORIG4 = 7;
    private static final byte SAPDATA = 8;

    public DatagramData() {
    }

    public DatagramData(String phost, int pport) {
        this.host = phost;
        this.port = pport;
    }

    public void registerTimeCB(IceTimeCallBack cb) {
        this.timeCB = cb;
    }

    public void registerTimeFloatDataCB(IceTimeFloatDataCallBack cb) {
        this.timeDCB = cb;
    }

    public void registerSDDSTimeDataCB(SDDSTimeDataCallBack cb) {
        this.timeSCB = cb;
    }

    public void registerRTCPCB(RTCPCallBack cb) {
        this.rtcpCB = cb;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int pTimeOut) {
        this.timeOut = pTimeOut;
        if (this.verbose) {
            System.out.println("DatagramData: setting TimeOut " + pTimeOut);
        }
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean pVerbose) {
        this.verbose = pVerbose;
        if (this.verbose) {
            System.out.println("DatagramData: setting Verbose " + pVerbose);
        }
    }

    public boolean getPacketDebug() {
        return this.packetDebug;
    }

    public void setPacketDebug(boolean pPacketDebug) {
        this.packetDebug = pPacketDebug;
        if (this.verbose) {
            System.out.println("DatagramData: setting PacketDebug " + pPacketDebug);
        }
    }

    public boolean getPacketDataDebug() {
        return this.packetDataDebug;
    }

    public void setPacketDataDebug(boolean pPacketDataDebug) {
        this.packetDataDebug = pPacketDataDebug;
        if (this.verbose) {
            System.out.println("DatagramData: setting PacketDataDebug " + pPacketDataDebug);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String phost) {
        this.host = phost;
        if (this.verbose) {
            System.out.println("DatagramData: setting host " + phost);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int pport) {
        this.port = pport;
        if (this.verbose) {
            System.out.println("DatagramData: setting port " + pport);
        }
    }

    public boolean getRTP() {
        return this.rtp;
    }

    public void setRTP(boolean prtp) {
        this.rtp = prtp;
        if (this.verbose) {
            System.out.println("DatagramData: setting RTP " + prtp);
        }
    }

    public int getRTPFilter() {
        return this.rtpfiltertype;
    }

    public void setRTPFilter(int ptemp) {
        this.rtpfiltertype = ptemp;
        if (this.verbose) {
            System.out.println("DatagramData: setting RTP Filter to handle only " + ptemp);
        }
    }

    public boolean getRTCPIgnore() {
        return this.ignore_rtcp;
    }

    public void setRTCPIgnore(boolean pri) {
        this.ignore_rtcp = pri;
        if (this.verbose) {
            System.out.println("DatagramData: setting RTCP Ignore " + pri);
        }
    }

    public boolean getFill() {
        return this.fill;
    }

    public void setFill(boolean pfill) {
        this.fill = pfill;
        if (this.verbose) {
            System.out.println("DatagramData: setting fill " + this.fill);
        }
    }

    public boolean getSAP() {
        return this.sap;
    }

    public void setSAP(boolean psap) {
        this.sap = psap;
        if (this.sap) {
            this.host = "224.2.127.254";
            this.port = 9875;
        }
        if (this.verbose) {
            System.out.println("DatagramData: setting sap " + this.sap + ".host=" + this.host + ".port=" + this.port);
        }
    }

    public boolean getCheck() {
        return this.checkhdr;
    }

    public void setCheck(boolean pcheck) {
        this.checkhdr = pcheck;
        if (this.verbose) {
            System.out.println("DatagramData: setting check " + this.checkhdr);
        }
    }

    public boolean getIceHdrInPipe() {
        return this.icehdrinpipe;
    }

    public void setIceHdrInPipe(boolean parm) {
        this.icehdrinpipe = parm;
        if (this.verbose) {
            System.out.println("DatagramData: setting ice hdr in pipe " + this.icehdrinpipe);
        }
    }

    public void setAutoSeqResetMAX(int srm) {
        this.seqreset = srm;
        if (this.seqreset < 0) {
            this.seqreset = -this.seqreset;
        }
    }

    public int getAutoSeqResetMAX() {
        return this.seqreset;
    }

    public boolean getIceData() {
        return this.geticedata;
    }

    public void setIceData(boolean parm) {
        this.geticedata = parm;
        if (this.verbose) {
            System.out.println("DatagramData: setting icedata available " + this.geticedata);
        }
    }

    public static int getPktBufferSize() {
        return pktBufferSize;
    }

    public static void setPktBufferSize(int pktBufferSize) {
        DatagramData.pktBufferSize = pktBufferSize;
    }

    public boolean getDecompress() {
        return this.decompressor != null;
    }

    public void setDecompress(boolean pdecompress) {
        this.decompressor = pdecompress ? new Inflater() : null;
        if (this.verbose) {
            System.out.println("DatagramData: setting decompress " + pdecompress + "," + this.decompressor);
        }
    }

    public boolean getMac() {
        return this.mac != null;
    }

    public void setMac(int dpmac, String key) {
        if (dpmac == 1) {
            this.setMac(false, key);
        } else {
            this.setMac(true, key);
        }
    }

    public void setMac(boolean pmac, String key) {
        if (this.verbose) {
            System.out.println("DatagramData: setting mac " + pmac);
        }
        if (!pmac) {
            this.mac = null;
            return;
        }
        try {
            this.mac = Mac.getInstance(this.hmactype);
            this.signingkey = new SecretKeySpec(key.getBytes(), this.hmactype);
            this.mac.init(this.signingkey);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mac = null;
        }
    }

    public boolean getEncrypt() {
        return this.cipher != null;
    }

    public void setEncrypt(int dpcipher, String key, String salt) {
        if (dpcipher == 1) {
            this.setEncrypt(false, key, salt);
        } else {
            this.setEncrypt(true, key, salt);
        }
    }

    public void setEncrypt(boolean pcipher, String key, String salt) {
        if (this.verbose) {
            System.out.println("DatagramData: setting cipher " + pcipher);
        }
        if (!pcipher) {
            this.cipher = null;
            return;
        }
        try {
            if (this.verbose) {
                System.out.println("DatagramData: setEncrypt with " + key + " and " + salt);
            }
            this.pbeParamSpec = new PBEParameterSpec(salt.getBytes(), this.ITERATIONS);
            this.pbeKeySpec = new PBEKeySpec(key.toCharArray());
            this.cipherkey = SecretKeyFactory.getInstance(this.ciphertype).generateSecret(this.pbeKeySpec);
            this.cipher = Cipher.getInstance(this.cipherkey.getAlgorithm());
            this.cipher.init(2, this.cipherkey, this.pbeParamSpec);
            if (this.verbose) {
                System.out.println("DatagramData: Done setEncrypt");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.cipher = null;
        }
    }

    public int getFillNum() {
        return this.fillnum;
    }

    public int getLastHdrSeq() {
        return this.llhdr;
    }

    public int getCurHdrSeq() {
        return this.lasthdr;
    }

    public int getSeq() {
        return this.seq;
    }

    public int getLastSeq() {
        return this.llseq;
    }

    public void setLastSeq(int pseq) {
        this.lastseq = pseq;
    }

    public double getICETime() {
        return this.wsec + this.fsec;
    }

    public double getWSEC() {
        return this.wsec;
    }

    public double getFSEC() {
        return this.fsec;
    }

    public double getICETimeTCOFF(double xdelta) {
        return this.wsec + this.fsec - this.tcoff * xdelta;
    }

    public double getDU1() {
        if (this.lastICE == null) {
            return 0.0;
        }
        return this.lastICE.getUserDataD(0);
    }

    public double getDU2() {
        if (this.lastICE == null) {
            return 0.0;
        }
        return this.lastICE.getUserDataD(1);
    }

    public double getFU1() {
        if (this.lastICE == null) {
            return 0.0;
        }
        return this.lastICE.getUserDataF(0);
    }

    public double getFU2() {
        if (this.lastICE == null) {
            return 0.0;
        }
        return this.lastICE.getUserDataF(1);
    }

    public double getFU3() {
        if (this.lastICE == null) {
            return 0.0;
        }
        return this.lastICE.getUserDataF(2);
    }

    public double getFU4() {
        if (this.lastICE == null) {
            return 0.0;
        }
        return this.lastICE.getUserDataF(3);
    }

    public boolean isIceHdrPacket() {
        return this.seq == this.lasthdr;
    }

    public ICEPacket getICE() {
        return this.lastICE;
    }

    public String getFormat() {
        return this.ifrmt;
    }

    public int getSize() {
        return this.isize;
    }

    public int getBPA() {
        return this.ibpa;
    }

    public int getBytes() {
        return this.ibpa * this.isize;
    }

    public void setAllHosts(boolean palladdr) {
        this.alladdr = palladdr;
        if (this.verbose) {
            System.out.println("DatagramData: setting ALL hosts " + this.alladdr + ".port=" + this.port);
        }
    }

    public boolean getAllHosts() {
        return this.alladdr;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public int getType() {
        return this.buf[1] & 0x7F;
    }

    public boolean open(String phost, int pport) {
        this.host = phost;
        this.port = pport;
        return this.open();
    }

    public boolean open() {
        this.isOpen = false;
        this.socketerror = false;
        this.lastseq = -1;
        this.llseq = -1;
        this.seq = -1;
        this.lasthdr = -1;
        this.llhdr = -1;
        this.fillnum = 0;
        if (this.host == null && !this.alladdr) {
            System.err.println("DatagramData: No Host to open");
            return this.isOpen;
        }
        try {
            if (this.alladdr) {
                this.multicast = false;
            } else {
                this.addr = InetAddress.getByName(this.host);
                this.multicast = this.addr.isMulticastAddress();
            }
            if (this.verbose) {
                System.out.println("DatagramData: HOST:" + this.host + ". PORT:" + this.port);
                if (this.multicast) {
                    System.out.println("DatagramData: Multicast");
                }
            }
            try {
                if (this.multicast) {
                    this.msock = this.windows ? new MulticastSocket(this.port) : new MulticastSocket(new InetSocketAddress(this.host, this.port));
                    this.msock.joinGroup(this.addr);
                    this.dsock = this.msock;
                } else {
                    this.dsock = this.alladdr ? new DatagramSocket(this.port) : new DatagramSocket(this.port, this.addr);
                }
                this.dsock.setSoTimeout(this.timeOut);
                if (this.verbose) {
                    System.out.println("DatagramData: Connected to Socket. Host:" + this.host + ". Port:" + this.port);
                }
            }
            catch (Exception e) {
                System.err.println("DatagramData: Open Error: " + e + ". For IP=" + this.host + ". Port=" + this.port);
                if (e instanceof BindException && "Cannot assign requested address".equals(e.getMessage())) {
                    System.err.println("DatagramData: On RHEL4+ (system with dual IPv4 and IPv6 stacks), try defining\n              java.net.preferIPv4Stack=true system property to use IPv4 stack.");
                }
                e.printStackTrace();
                return this.isOpen;
            }
        }
        catch (Exception e) {
            System.err.println("DatagramData: Problem with stream address:" + this.host + ":" + this.port + " ->" + e);
            e.printStackTrace();
            return this.isOpen;
        }
        if (this.verbose) {
            System.out.println("DatagramData: Done HOST:" + this.host + ". PORT:" + this.port);
        }
        this.isOpen = true;
        return true;
    }

    public void leave() {
        if (this.verbose) {
            System.out.println("DatagramData: Leave Group");
        }
        try {
            if (this.multicast) {
                this.msock.leaveGroup(this.addr);
            }
            if (this.dsock != null) {
                this.dsock.close();
            }
            this.isOpen = false;
            this.socketerror = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.verbose) {
            System.out.println("DatagramData: Done Leave Group");
        }
    }

    public void close() {
        if (this.verbose) {
            System.out.println("DatagramData: Closing");
        }
        this.isOpen = false;
        this.socketerror = false;
        try {
            if (this.multicast) {
                this.msock.leaveGroup(this.addr);
            }
            if (this.dsock != null) {
                this.dsock.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int read(byte[] tbuf) {
        return this.read(tbuf, 0);
    }

    public int read(byte[] tbuf, int poffset) {
        this.len = 0;
        this.offset = 0;
        try {
            if (this.dpacki == null || this.dsock == null) {
                if (!this.socketerror) {
                    System.err.println("DatagramData: Null Socket or buffer for host " + this.host);
                    this.socketerror = true;
                }
                return -1;
            }
            this.dpacki.setLength(this.buf.length);
            try {
                this.dsock.receive(this.dpacki);
            }
            catch (SocketTimeoutException ste) {
                if (this.packetDebug) {
                    System.out.println("SocketTimeOutException" + ste);
                }
                return 0;
            }
            this.len = this.dpacki.getLength();
            if (this.rtp) {
                if (this.packetDebug) {
                    this.i = 0;
                    while (this.i < this.len) {
                        System.out.println("BUF[" + this.i + "]=" + this.buf[this.i]);
                        ++this.i;
                    }
                }
                if (this.buf[1] >= 194 && this.buf[1] <= 210) {
                    if (this.ignore_rtcp) {
                        return 0;
                    }
                    if (this.rtcpCB != null) {
                        if (this.buf[1] == 200 || this.buf[1] == 201) {
                            this.parseRTCP(this.buf, 0, this.len);
                        }
                        return 0;
                    }
                }
                if (this.rtpfiltertype >= 0 && (this.buf[1] & 0x7F) != this.rtpfiltertype) {
                    return 0;
                }
                if (this.fill) {
                    this.hi = this.buf[2];
                    if (this.hi < 0) {
                        this.hi += 256;
                    }
                    this.lo = this.buf[3];
                    if (this.lo < 0) {
                        this.lo += 256;
                    }
                    this.seq = this.hi * 256 + this.lo;
                    this.fillnum = 0;
                    if (this.lastseq > -1) {
                        if (this.lastseq - this.seq > Short.MAX_VALUE) {
                            this.fillnum = 65536 - this.lastseq + this.seq - 1;
                            if (this.verbose) {
                                System.out.println("Rollover condition " + this.lastseq + " to " + this.seq + " for host " + this.host + ". determined fill num of " + this.fillnum);
                            }
                        } else {
                            if (this.lastseq >= this.seq) {
                                if (this.verbose) {
                                    System.out.println("Skip Out of order or duplicate packet " + this.lastseq + " to " + this.seq + " for host " + this.host);
                                }
                                if (this.seqreset > 0 && this.lastseq >= this.seq - this.seqreset) {
                                    this.lastseq = this.seq;
                                }
                                return 0;
                            }
                            if (this.lastseq + 1 != this.seq) {
                                this.fillnum = this.seq - this.lastseq - 1;
                                if (this.verbose) {
                                    System.out.println("Missed packets from " + this.lastseq + " to " + this.seq + " for host " + this.host + " so fill " + this.fillnum);
                                }
                            }
                        }
                    }
                    this.llseq = this.lastseq;
                    this.lastseq = this.seq;
                }
                this.ccs = this.buf[0] & 0xF;
                this.extendflag = this.buf[0] & 0x10;
                this.datapos = 12 + this.ccs * 4;
                this.PacketPos = -1;
                if (this.extendflag > 0) {
                    this.xtype = DatagramData.unpackINet(this.buf, this.datapos);
                    this.xlen = DatagramData.unpackINet(this.buf, this.datapos + 2);
                    this.packetStart = this.datapos + 4;
                    this.datapos += 4 + (this.xlen << 2);
                    if (this.xtype == 255) {
                        this.timepacktype = 0;
                        this.timepacklen = 0;
                        this.timepackpos = -1;
                        while (this.packetStart < this.datapos) {
                            this.xtype = DatagramData.unpackINet(this.buf, this.packetStart);
                            this.sublen = DatagramData.unpackINet(this.buf, this.packetStart + 2) * 4;
                            if (this.xtype == 17 || this.xtype == 16) {
                                this.timepacktype = this.xtype;
                                this.timepacklen = this.sublen;
                                this.timepackpos = this.packetStart + 4;
                            } else if (this.xtype == 18 && this.mac != null) {
                                if (this.verbose) {
                                    System.out.println("Checking packet signature " + this.bufholder.length);
                                }
                                if (this.sublen > this.bufholder.length) {
                                    this.sublen = this.bufholder.length;
                                }
                                System.arraycopy(this.buf, this.packetStart + 4, this.bufholder, 0, this.sublen);
                                System.arraycopy(this.fakesignature, 0, this.buf, this.packetStart + 4, this.sublen);
                                this.mac.update(this.buf, 0, this.len);
                                this.signature = this.mac.doFinal();
                                this.sigpass = true;
                                this.i = 0;
                                while (this.i < this.sublen) {
                                    if (this.signature[this.i] != this.bufholder[this.i]) {
                                        this.sigpass = false;
                                        break;
                                    }
                                    ++this.i;
                                }
                                if (!this.sigpass) {
                                    if (this.verbose) {
                                        System.err.println("DatagramData: Packet did not pass signature check");
                                    }
                                    return 0;
                                }
                            }
                            this.packetStart = this.packetStart + 4 + this.sublen;
                        }
                        if (this.timepackpos >= 0) {
                            this.packetStart = this.timepackpos;
                            this.xtype = this.timepacktype;
                            this.sublen = this.timepacklen;
                        }
                    }
                    if (this.xtype == 16 || this.xtype == 8 || this.xtype == 1) {
                        this.llhdr = this.lasthdr;
                        if (this.fill) {
                            this.lasthdr = this.seq;
                        } else {
                            this.hi = this.buf[2];
                            if (this.hi < 0) {
                                this.hi += 256;
                            }
                            this.lo = this.buf[3];
                            if (this.lo < 0) {
                                this.lo += 256;
                            }
                            this.lasthdr = this.hi * 256 + this.lo;
                        }
                        if (ICEPacket.hasSync(this.buf, this.packetStart)) {
                            this.PacketPos = this.packetStart;
                            byte rep = this.buf[this.PacketPos + 18];
                            if (this.timeCB != null || this.timeDCB != null || this.geticedata) {
                                this.wsec = Convert.unpackD(this.buf, this.PacketPos + 32, rep);
                                this.fsec = Convert.unpackD(this.buf, this.PacketPos + 40, rep);
                                this.ibpa = this.buf[this.PacketPos + 19];
                                this.tcoff = Convert.unpackD(this.buf, this.PacketPos + 24, rep);
                                if (this.verbose) {
                                    Shell.info("DGData: Time set " + this.wsec + "," + this.fsec + "," + this.tcoff);
                                }
                                this.lastICE = new ICEPacket(this.buf, this.PacketPos);
                                this.isize = this.lastICE.getSize();
                                this.ifrmt = this.lastICE.getFormat();
                                if (this.timeCB != null) {
                                    this.dp1 = Convert.unpackD(this.buf, this.PacketPos + 48, rep);
                                    this.dp2 = Convert.unpackD(this.buf, this.PacketPos + 56, rep);
                                    try {
                                        this.timeCB.dgramTime(this.wsec + this.fsec, this.dp2, this.dp1);
                                    }
                                    catch (Exception ex) {
                                        System.err.println("DatagramData: Error while making ICE time call back to '" + this.timeCB + "'.");
                                    }
                                } else if (this.timeDCB != null) {
                                    this.fp1 = Convert.unpackF(this.buf, this.PacketPos + 48, rep);
                                    this.fp2 = Convert.unpackF(this.buf, this.PacketPos + 52, rep);
                                    this.fp3 = Convert.unpackF(this.buf, this.PacketPos + 56, rep);
                                    this.fp4 = Convert.unpackF(this.buf, this.PacketPos + 60, rep);
                                    try {
                                        this.timeDCB.dgramTimeFloatData(this.wsec + this.fsec, this.fp1, this.fp2, this.fp3, this.fp4);
                                    }
                                    catch (Exception ex) {
                                        System.err.println("DatagramData: Error while making ICE time call back to '" + this.timeDCB + "'.");
                                    }
                                }
                            }
                        }
                    } else if (this.xtype == 17) {
                        this.llhdr = this.lasthdr;
                        if (this.fill) {
                            this.lasthdr = this.seq;
                        } else {
                            this.hi = this.buf[2];
                            if (this.hi < 0) {
                                this.hi += 256;
                            }
                            this.lo = this.buf[3];
                            if (this.lo < 0) {
                                this.lo += 256;
                            }
                            this.lasthdr = this.hi * 256 + this.lo;
                        }
                        this.PacketPos = this.packetStart;
                        if (this.timeSCB != null && (this.buf[this.PacketPos + 12] & 0xC0) != 0) {
                            System.arraycopy(this.buf, this.PacketPos + 16, this.tcbuf, 0, 8);
                            Convert.swap8(this.tcbuf, 0, 1);
                            this.tics = Convert.unpackX(this.tcbuf, 0);
                            this.lwsec = this.tics / 4000000000L;
                            this.lfsec = this.tics - this.lwsec * 4000000000L;
                            this.timeSCB.dgramTime((double)this.lwsec + (double)this.lfsec * 2.5E-10);
                        }
                    } else if (this.xtype != 4) {
                        if (this.xtype == 18) {
                            if (this.mac != null) {
                                if (this.verbose) {
                                    System.out.println("Checking packet signature");
                                }
                                this.sublen = this.xlen * 4;
                                if (this.sublen > this.bufholder.length) {
                                    this.sublen = this.bufholder.length;
                                }
                                System.arraycopy(this.buf, this.packetStart, this.bufholder, 0, this.sublen);
                                System.arraycopy(this.fakesignature, 0, this.buf, this.packetStart, this.sublen);
                                this.mac.update(this.buf, 0, this.len);
                                this.signature = this.mac.doFinal();
                                this.sigpass = true;
                                this.i = 0;
                                while (this.i < this.sublen) {
                                    if (this.signature[this.i] != this.bufholder[this.i]) {
                                        this.sigpass = false;
                                        break;
                                    }
                                    ++this.i;
                                }
                                if (!this.sigpass) {
                                    if (this.verbose) {
                                        System.err.println("DatagramData: Packet did not pass signature check");
                                    }
                                    return 0;
                                }
                            }
                        } else {
                            System.err.println("DatagramData: Unknown packet xtype (" + this.xtype + "), expected COMPOUND, ICE1(1), ICE2(8), ICE3(16), SDDS(17), or MAC(18) packet.");
                        }
                    }
                } else {
                    this.xtype = 0;
                    this.xlen = 0;
                }
                if (this.packetDebug) {
                    System.out.println("DatagramData: **RTP Version=" + ((this.buf[0] & 0xC0) >> 6));
                    System.out.println("DatagramData: Len=" + this.len);
                    System.out.println("DatagramData: Padding=" + (this.buf[0] & 0x20));
                    System.out.println("DatagramData: CCRCs=" + this.ccs);
                    System.out.println("DatagramData: Extended Header=" + (this.extendflag >> 4));
                    if (this.xlen > 0) {
                        System.out.println("DatagramData: Header Type=" + this.xtype);
                        System.out.println("DatagramData: Header Len (4 byte words)=" + this.xlen);
                        if (this.PacketPos > 0) {
                            System.out.println("DatagramData: ICE/SDDS Header starting at " + this.PacketPos);
                            this.lastICE = new ICEPacket(this.buf, this.PacketPos);
                            System.out.println("TC=" + this.lastICE.getTC());
                            System.out.println("BPA=" + this.lastICE.getBPA());
                            System.out.println("Format=" + this.lastICE.getFormat());
                            System.out.println("Size=" + this.lastICE.getSize());
                            System.out.println("Count=" + this.lastICE.getCount());
                            System.out.println("Data1=" + this.lastICE.getUserDataD(0));
                            System.out.println("Data2=" + this.lastICE.getUserDataD(1));
                        }
                    }
                    System.out.println("DatagramData: Marked=" + (this.buf[1] & 0x80));
                    System.out.println("DatagramData: Payload=" + (this.buf[1] & 0x7F));
                    this.temp = 0;
                    this.temp = this.buf[2] < 0 ? (this.buf[2] + 256) * 256 : this.buf[2] * 256;
                    this.temp = this.buf[3] < 0 ? (this.temp += this.buf[3] + 256) : (this.temp += this.buf[3]);
                    System.out.println("DatagramData: Sequence=" + this.temp);
                    this.temp = 0;
                    this.temp = this.buf[4] < 0 ? (this.buf[4] + 256) * 0x1000000 : this.buf[4] * 0x1000000;
                    this.temp = this.buf[5] < 0 ? (this.temp += (this.buf[5] + 256) * 65536) : (this.temp += this.buf[5] * 65536);
                    this.temp = this.buf[6] < 0 ? (this.temp += (this.buf[6] + 256) * 256) : (this.temp += this.buf[6] * 256);
                    this.temp = this.buf[7] < 0 ? (this.temp += this.buf[7] + 256) : (this.temp += this.buf[7]);
                    System.out.println("DatagramData: Timestamp=" + this.temp);
                    this.temp = this.buf[8] < 0 ? (this.buf[8] + 256) * 0x1000000 : this.buf[8] * 0x1000000;
                    this.temp = this.buf[9] < 0 ? (this.temp += (this.buf[9] + 256) * 65536) : (this.temp += this.buf[9] * 65536);
                    this.temp = this.buf[10] < 0 ? (this.temp += (this.buf[10] + 256) * 256) : (this.temp += this.buf[10] * 256);
                    this.temp = this.buf[11] < 0 ? (this.temp += this.buf[11] + 256) : (this.temp += this.buf[11]);
                    System.out.println("DatagramData: SSRC=" + Integer.toHexString(this.temp));
                    this.boff = 12;
                    this.ci = 0;
                    while (this.ci < this.ccs) {
                        System.out.println("DatagramData: CCRC Num=" + (this.ci + 1));
                        System.out.println("DatagramData: CSRC=" + this.buf[this.boff] + "." + this.buf[this.boff + 1] + "." + this.buf[this.boff + 2] + "." + this.buf[this.boff + 3]);
                        this.boff += 4;
                        ++this.ci;
                    }
                }
                this.offset = this.datapos + poffset;
                if (this.offset > this.len) {
                    this.offset = this.len;
                }
                this.len = this.len > this.datapos ? (this.len -= this.offset) : 0;
            } else if (this.sap) {
                this.ipver = this.buf[0] & 0x10;
                this.state = this.buf[0] & 4;
                this.encrypt = this.buf[0] & 2;
                this.compress = this.buf[0] & 1;
                this.authlen = this.buf[1];
                this.datapos = 8;
                this.datapos = this.ipver > 0 ? (this.datapos += this.authlen * 4 + 12) : (this.datapos += this.authlen * 4);
                if (this.packetDebug) {
                    System.out.println("DatagramData: **SAP Version=" + ((this.buf[0] & 0xE0) >> 5));
                    System.out.println("DatagramData: IP Version=" + (this.ipver >> 4));
                    System.out.println("DatagramData: Start/Stop=" + (this.state >> 2));
                    System.out.println("DatagramData: Encryption=" + (this.encrypt >> 1));
                    System.out.println("DatagramData: Compressed=" + this.compress);
                    System.out.println("DatagramData: Authentication Length=" + this.authlen);
                    this.temp = 0;
                    this.temp = this.buf[2] < 0 ? (this.buf[2] + 256) * 256 : this.buf[2] * 256;
                    this.temp = this.buf[3] < 0 ? (this.temp += this.buf[3] + 256) : (this.temp += this.buf[3]);
                    System.out.println("DatagramData: Msg ID hash=" + this.temp);
                    if (this.ipver > 0) {
                        System.out.println("DatagramData: IP6.1=" + this.buf[4] + "-" + this.buf[5] + "-" + this.buf[6] + "-" + this.buf[7]);
                        System.out.println("DatagramData: IP6.2=" + this.buf[8] + "-" + this.buf[10] + "-" + this.buf[12] + "-" + this.buf[14]);
                        System.out.println("DatagramData: IP6.3=" + this.buf[12] + "-" + this.buf[14] + "-" + this.buf[16] + "-" + this.buf[18]);
                        System.out.println("DatagramData: IP6.4=" + this.buf[16] + "-" + this.buf[18] + "-" + this.buf[20] + "-" + this.buf[22]);
                    } else {
                        System.out.println("DatagramData: IP4=" + this.buf[4] + "-" + this.buf[5] + "-" + this.buf[6] + "-" + this.buf[7]);
                    }
                    if (this.authlen > 0) {
                        this.pos = 0;
                        this.i = 0;
                        while (this.i < this.authlen) {
                            System.out.println("DatagramData: Authdata " + this.i + "=" + this.buf[8 + this.pos] + "-" + this.buf[8 + this.pos + 1] + "-" + this.buf[8 + this.pos + 2] + "-" + this.buf[8 + this.pos + 3]);
                            this.pos += 4;
                            ++this.i;
                        }
                    }
                    byte[] xbuf = new byte[this.len - poffset];
                    System.arraycopy(this.buf, this.datapos, xbuf, 0, this.len - this.datapos - poffset);
                    String sdp = new String(xbuf);
                    System.out.println("DatagramData: SAP Data=" + sdp);
                }
                this.offset = this.datapos + poffset;
                if (this.datapos > 7) {
                    this.buf[this.datapos - 7] = 83;
                    this.buf[this.datapos - 6] = 84;
                    this.buf[this.datapos - 5] = 79;
                    this.buf[this.datapos - 4] = 80;
                    this.buf[this.datapos - 3] = 61;
                    this.buf[this.datapos - 2] = this.state > 0 ? 49 : 48;
                    this.buf[this.datapos - 1] = 10;
                    this.datapos -= 7;
                }
                this.len = this.len > this.datapos ? (this.len -= this.offset) : 0;
            } else {
                this.offset = poffset;
                if (this.packetDebug) {
                    String tmp = new String(this.buf, 0, this.len);
                    System.out.println("received from:" + this.dpacki.getAddress() + " " + this.len + " bytes ");
                    System.out.println("DatagramData: Data=" + tmp);
                }
                this.len -= this.offset;
            }
            if (tbuf != null && this.len > 0) {
                if (this.icehdrinpipe && this.PacketPos > -1) {
                    System.arraycopy(this.buf, this.PacketPos, tbuf, 0, 64);
                    if (this.cipher != null) {
                        if (this.verbose) {
                            System.out.println("Do Decrypt " + this.offset + "," + this.len + "," + 64);
                        }
                        this.len = this.cipher.doFinal(this.buf, this.offset, this.len, tbuf, 64);
                        if (this.verbose) {
                            System.out.println("Done Decrypt");
                        }
                    }
                    if (this.decompressor == null) {
                        if (this.cipher == null) {
                            System.arraycopy(this.buf, this.offset, tbuf, 64, this.len);
                        }
                    } else {
                        this.decompressor.setInput(this.buf, this.offset, this.len);
                        try {
                            this.len = this.complen = this.decompressor.inflate(tbuf, 64, this.len);
                        }
                        catch (DataFormatException dfe) {
                            if (this.verbose) {
                                System.out.println("No Decompress, just pass");
                            }
                            System.arraycopy(this.buf, this.offset, tbuf, 64, this.len);
                        }
                        this.decompressor.reset();
                        if (this.packetDataDebug) {
                            String tmp = new String(this.buf, this.offset, this.len);
                            System.out.println("DatagramData: Data=" + tmp);
                        }
                    }
                    return this.len + 64;
                }
                if (this.decompressor == null) {
                    if (this.cipher == null) {
                        System.arraycopy(this.buf, this.offset, tbuf, 0, this.len);
                    }
                } else {
                    this.decompressor.setInput(this.buf, this.offset, this.len);
                    try {
                        this.len = this.complen = this.decompressor.inflate(tbuf);
                    }
                    catch (DataFormatException dfe) {
                        if (this.verbose) {
                            System.out.println("No Decompress, just pass");
                        }
                        System.arraycopy(this.buf, this.offset, tbuf, 0, this.len);
                    }
                    this.decompressor.reset();
                }
            }
            if (this.packetDataDebug) {
                if (this.cipher != null) {
                    byte[] dcbuf = new byte[pktBufferSize];
                    System.out.println("Do Decrypt " + this.offset + "," + this.len);
                    System.arraycopy(this.buf, this.offset, dcbuf, 0, this.len);
                    this.len = this.cipher.doFinal(dcbuf, 0, this.len, this.buf, this.offset);
                    System.out.println("Done Decrypt");
                }
                if (this.decompressor == null) {
                    String tmp = new String(this.buf, this.offset, this.len);
                    System.out.println("DatagramData: Nobuffer=" + tmp);
                } else {
                    byte[] dcbuf = new byte[pktBufferSize];
                    this.decompressor.setInput(this.buf, this.offset, this.len);
                    try {
                        this.len = this.complen = this.decompressor.inflate(dcbuf);
                    }
                    catch (DataFormatException dfe) {
                        System.out.println("No Decompress, just pass");
                        System.arraycopy(this.buf, this.offset, dcbuf, 0, this.len);
                    }
                    this.decompressor.reset();
                    String tmp = new String(dcbuf);
                    System.out.println("DatagramData: Data=" + tmp);
                }
            }
            return this.len;
        }
        catch (Exception e) {
            if (e instanceof InterruptedIOException) {
                if (this.verbose) {
                    System.out.println("DatagramData: Interrupted:" + e);
                }
            } else if (e instanceof SocketException) {
                if (this.verbose) {
                    System.out.println("DatagramData: Socket Closed:" + e);
                }
            } else {
                System.err.println("DatagramData: Exception: " + e);
                System.err.println("DatagramData: values: len=" + this.len + "offset=" + this.offset);
                e.printStackTrace();
            }
            return this.len;
        }
    }

    public void parseRTCP(byte[] buf, int poffset, int len) {
        this.xlen = 0;
        this.pos = poffset;
        if (this.pos + 4 > len) {
            return;
        }
        do {
            this.hi = buf[this.pos + 2];
            if (this.hi < 0) {
                this.hi += 256;
            }
            this.lo = buf[this.pos + 3];
            if (this.lo < 0) {
                this.lo += 256;
            }
            this.xlen = this.hi * 256 + this.lo;
            ++this.xlen;
            this.xlen *= 4;
            if (this.xlen > len - this.pos) {
                this.xlen = len - this.pos;
            }
            this.xtype = buf[this.pos + 1];
            if (this.xtype != 203) {
                this.rtcpbuf = new byte[this.xlen];
                System.arraycopy(buf, 0, this.rtcpbuf, 0, this.xlen);
            }
            if (this.xtype == 200) {
                this.rtcpCB.RTCP_SR(this.rtcpbuf);
            } else if (this.xtype == 201) {
                this.rtcpCB.RTCP_RR(this.rtcpbuf);
            } else if (this.xtype == 202) {
                this.rtcpCB.RTCP_SDES(this.rtcpbuf);
            } else if (this.xtype == 203) {
                this.ccs = buf[this.pos + 0] & 0x1F;
                if (this.ccs * 4 + 4 < this.xlen) {
                    int npos = this.pos + this.ccs * 4 + 4;
                    byte rlen = buf[npos];
                    try {
                        this.rtcpCB.RTCP_BYE(new String(buf, npos, (int)rlen, "US-ASCII"));
                    }
                    catch (Exception exception) {}
                } else {
                    this.rtcpCB.RTCP_BYE("DONE");
                }
            } else if (this.xtype == 204) {
                this.rtcpCB.RTCP_APP("APP", this.rtcpbuf);
            } else {
                this.rtcpCB.RTCP_Other(buf[1], this.rtcpbuf);
            }
            this.pos += this.xlen;
        } while (this.pos + 4 <= len);
    }

    public byte[] read(int poffset) {
        this.temp = this.read(null, poffset);
        if (this.temp < 1) {
            return null;
        }
        byte[] tbuf = new byte[this.temp];
        System.arraycopy(this.buf, this.offset, tbuf, 0, this.temp);
        return tbuf;
    }

    public byte[] read() {
        this.temp = this.read(null, 0);
        if (this.temp < 1) {
            return null;
        }
        byte[] tbuf = new byte[this.temp];
        System.arraycopy(this.buf, this.offset, tbuf, 0, this.temp);
        return tbuf;
    }

    public static int unpackINet(byte[] buf, int off) {
        int xtype = buf[off] < 0 ? buf[off] + 256 << 8 : buf[off] << 8;
        xtype = buf[off + 1] < 0 ? (xtype += buf[off + 1] + 256) : (xtype += buf[off + 1]);
        return xtype;
    }

    public static interface RTCPCallBack {
        public void RTCP_SR(byte[] var1);

        public void RTCP_RR(byte[] var1);

        public void RTCP_SDES(byte[] var1);

        public void RTCP_BYE(String var1);

        public void RTCP_APP(String var1, byte[] var2);

        public void RTCP_Other(byte var1, byte[] var2);
    }

    public static interface SDDSTimeDataCallBack {
        public void dgramTime(double var1);
    }

    public static interface IceTimeFloatDataCallBack {
        public void dgramTimeFloatData(double var1, float var3, float var4, float var5, float var6);
    }

    public static interface IceTimeCallBack {
        public void dgramTime(double var1, double var3, double var5);
    }
}

