/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libm;

import nxm.sys.inc.Constants;

public class Waveform
implements Constants {
    private static final double A = 6.7081293E7;
    private static final double B = 1.4181771E7;
    private static final double T26 = 6.7108864E7;
    private static final double BI = 0.21132485568523407;
    private static int seed = 123456789;

    @Deprecated
    public Waveform() {
    }

    public static void setSeed(int value) {
        if (value > 0) {
            seed = value;
        }
    }

    public static float[] whitenoise(double sdev, int n) {
        float[] fbuf = new float[n];
        Waveform.whitenoise(fbuf, sdev, n, 1);
        return fbuf;
    }

    public static void whitenoise(float[] fbuf, double sdev, int n, int spa) {
        float fdev = (float)sdev;
        double sis = (double)seed / 6.7108864E7;
        int end = n * spa;
        int i = 0;
        while (true) {
            sis = sis * 6.7081293E7 + 0.21132485568523407;
            sis -= (double)((int)sis);
            float v1 = (float)sis;
            v1 = v1 + v1 - 1.0f;
            sis = sis * 6.7081293E7 + 0.21132485568523407;
            sis -= (double)((int)sis);
            float v2 = (float)sis;
            float sum = v1 * v1 + (v2 = v2 + v2 - 1.0f) * v2;
            if ((double)sum >= 1.0) continue;
            sum = fdev * (float)Math.sqrt(-2.0 * Math.log(sum) / (double)sum);
            fbuf[i++] = v1 * sum;
            if (i == end) break;
            fbuf[i++] = v2 * sum;
            if (i == end) break;
        }
        seed = (int)(sis * 6.7108864E7);
    }

    public static void whitenoise(double[] dbuf, double sdev, int n, int spa) {
        double sis = (double)seed / 6.7108864E7;
        int end = n * spa;
        int i = 0;
        while (true) {
            double v2;
            double sum;
            sis = sis * 6.7081293E7 + 0.21132485568523407;
            sis -= (double)((int)sis);
            double v1 = sis + sis - 1.0;
            sis = sis * 6.7081293E7 + 0.21132485568523407;
            if ((sum = v1 * v1 + (v2 = (sis -= (double)((int)sis)) + sis - 1.0) * v2) >= 1.0) continue;
            sum = sdev * Math.sqrt(-2.0 * Math.log(sum) / sum);
            dbuf[i++] = v1 * sum;
            if (i == end) break;
            dbuf[i++] = v2 * sum;
            if (i == end) break;
        }
        seed = (int)(sis * 6.7108864E7);
    }

    public static void sincos(float[] fbuf, double amp, double p, double dp, int n, int spa) {
        block5: {
            block7: {
                block6: {
                    float dxi;
                    float dxr;
                    float cxi;
                    float cxr;
                    block4: {
                        cxr = (float)(amp * Math.cos(p * (Math.PI * 2)));
                        cxi = (float)(amp * Math.sin(p * (Math.PI * 2)));
                        dxr = (float)Math.cos(dp * (Math.PI * 2));
                        dxi = (float)Math.sin(dp * (Math.PI * 2));
                        if (spa != 2) break block4;
                        int i = 0;
                        while (i < n * 2) {
                            fbuf[i++] = cxr;
                            fbuf[i++] = cxi;
                            float axr = cxr * dxr - cxi * dxi;
                            float axi = cxr * dxi + cxi * dxr;
                            cxr = axr;
                            cxi = axi;
                        }
                        break block5;
                    }
                    if (spa != 1) break block6;
                    int i = 0;
                    while (i < n) {
                        fbuf[i++] = cxi;
                        float axr = cxr * dxr - cxi * dxi;
                        float axi = cxr * dxi + cxi * dxr;
                        cxr = axr;
                        cxi = axi;
                    }
                    break block5;
                }
                if (spa != -1) break block7;
                int i = 0;
                while (i < n) {
                    fbuf[i++] = (float)(amp * Math.sin(p * (Math.PI * 2)));
                    p += dp;
                }
                break block5;
            }
            if (spa != -2) break block5;
            int i = 0;
            while (i < n * 2) {
                fbuf[i++] = (float)(amp * Math.cos(p * (Math.PI * 2)));
                fbuf[i++] = (float)(amp * Math.sin(p * (Math.PI * 2)));
                p += dp;
            }
        }
    }

    public static void sincos(double[] dbuf, double amp, double p, double dp, int n, int spa) {
        block6: {
            block8: {
                block7: {
                    double dxi;
                    double dxr;
                    double cxi;
                    double cxr;
                    block5: {
                        cxr = 0.0;
                        cxi = 0.0;
                        dxr = 0.0;
                        dxi = 0.0;
                        if (spa > 0) {
                            cxr = amp * Math.cos(p * (Math.PI * 2));
                            cxi = amp * Math.sin(p * (Math.PI * 2));
                            dxr = Math.cos(dp * (Math.PI * 2));
                            dxi = Math.sin(dp * (Math.PI * 2));
                        }
                        if (spa != 2) break block5;
                        int i = 0;
                        while (i < n * 2) {
                            dbuf[i++] = cxr;
                            dbuf[i++] = cxi;
                            double axr = cxr * dxr - cxi * dxi;
                            double axi = cxr * dxi + cxi * dxr;
                            cxr = axr;
                            cxi = axi;
                        }
                        break block6;
                    }
                    if (spa != 1) break block7;
                    int i = 0;
                    while (i < n) {
                        dbuf[i++] = cxi;
                        double axr = cxr * dxr - cxi * dxi;
                        double axi = cxr * dxi + cxi * dxr;
                        cxr = axr;
                        cxi = axi;
                    }
                    break block6;
                }
                if (spa != -1) break block8;
                int i = 0;
                while (i < n) {
                    dbuf[i++] = amp * Math.sin(p * (Math.PI * 2));
                    p += dp;
                }
                break block6;
            }
            if (spa != -2) break block6;
            int i = 0;
            while (i < n * 2) {
                dbuf[i++] = amp * Math.cos(p * (Math.PI * 2));
                dbuf[i++] = amp * Math.sin(p * (Math.PI * 2));
                p += dp;
            }
        }
    }

    public static void square(float[] fbuf, double amp, double p, double dp, int n, int spa) {
        float famp = (float)amp;
        float famp2 = -famp;
        int i = 0;
        while (i < n * spa) {
            float value = famp2;
            if (p >= 1.0) {
                p -= 1.0;
            } else if (p >= 0.5) {
                value = famp;
            }
            fbuf[i++] = value;
            if (spa == 2) {
                fbuf[i++] = value;
            }
            p += dp;
        }
    }

    public static void square(double[] dbuf, double amp, double p, double dp, int n, int spa) {
        double amp2 = -amp;
        int i = 0;
        while (i < n * spa) {
            double value = amp2;
            if (p >= 1.0) {
                p -= 1.0;
            } else if (p >= 0.5) {
                value = amp;
            }
            dbuf[i++] = value;
            if (spa == 2) {
                dbuf[i++] = value;
            }
            p += dp;
        }
    }

    public static void triangle(float[] fbuf, double amp, double p, double dp, int n, int spa) {
        float famp = (float)amp;
        float famp2 = 4.0f * famp;
        double fp = p - 0.5;
        int i = 0;
        while (i < n * spa) {
            if (fp >= 0.5) {
                fp -= 1.0;
            }
            float value = fp > 0.0 ? (float)((double)famp - fp * (double)famp2) : (float)((double)famp + fp * (double)famp2);
            fbuf[i++] = value;
            if (spa == 2) {
                fbuf[i++] = value;
            }
            fp += dp;
        }
    }

    public static void triangle(double[] dbuf, double amp, double p, double dp, int n, int spa) {
        double amp2 = 4.0 * amp;
        double fp = p - 0.5;
        double fdp = dp;
        int i = 0;
        while (i < n * spa) {
            if (fp >= 0.5) {
                fp -= 1.0;
            }
            double value = fp > 0.0 ? amp - fp * amp2 : amp + fp * amp2;
            dbuf[i++] = value;
            if (spa == 2) {
                dbuf[i++] = value;
            }
            fp += fdp;
        }
    }

    public static void sawtooth(float[] fbuf, double amp, double p, double dp, int n, int spa) {
        float famp = (float)amp;
        float famp2 = 2.0f * famp;
        double fp = p - 0.5;
        int i = 0;
        while (i < n * spa) {
            if (fp >= 0.5) {
                fp -= 1.0;
            }
            float value = (float)fp * famp2;
            fbuf[i++] = value;
            if (spa == 2) {
                fbuf[i++] = value;
            }
            fp += dp;
        }
    }

    public static void sawtooth(double[] dbuf, double amp, double p, double dp, int n, int spa) {
        double amp2 = 2.0 * amp;
        double fp = p - 0.5;
        int i = 0;
        while (i < n * spa) {
            if (fp >= 0.5) {
                fp -= 1.0;
            }
            double value = fp * amp2;
            dbuf[i++] = value;
            if (spa == 2) {
                dbuf[i++] = value;
            }
            fp += dp;
        }
    }

    public static void pulse(float[] fbuf, double amp, double p, double dp, int n, int spa) {
        float famp = (float)amp;
        int i = 0;
        while (i < n * spa) {
            float value;
            if (p >= 1.0) {
                value = famp;
                p -= 1.0;
            } else {
                value = 0.0f;
            }
            fbuf[i++] = value;
            if (spa == 2) {
                fbuf[i++] = value;
            }
            p += dp;
        }
    }

    public static void pulse(double[] dbuf, double amp, double p, double dp, int n, int spa) {
        int i = 0;
        while (i < n * spa) {
            double value;
            if (p >= 1.0) {
                value = amp;
                p -= 1.0;
            } else {
                value = 0.0;
            }
            dbuf[i++] = value;
            if (spa == 2) {
                dbuf[i++] = value;
            }
            p += dp;
        }
    }

    public static void constant(float[] fbuf, double amp, int n, int spa) {
        float famp = (float)amp;
        int i = 0;
        while (i < n * spa) {
            fbuf[i++] = famp;
        }
    }

    public static void constant(double[] dbuf, double amp, int n, int spa) {
        int i = 0;
        while (i < n * spa) {
            dbuf[i++] = amp;
        }
    }

    public static int lrs(float[] fbuf, double amp, int n, int spa, int lrs) {
        float factor = (float)(amp / 2.0 / 1.073741824E9);
        for (int i = 0; i < n * spa; ++i) {
            float data = factor * (float)lrs;
            int bit0 = ~(lrs ^ lrs >> 1 ^ lrs >> 5 ^ lrs >> 25) & 1;
            lrs <<= 1;
            lrs |= bit0;
            if (spa == 2) {
                fbuf[i++] = data;
            }
            fbuf[i] = data;
        }
        return lrs;
    }

    public static int lrs(double[] dbuf, double amp, int n, int spa, int lrs) {
        double factor = amp / 2.0 / 1.073741824E9;
        for (int i = 0; i < n * spa; ++i) {
            double data = factor * (double)lrs;
            int bit0 = ~(lrs ^ lrs >> 1 ^ lrs >> 5 ^ lrs >> 25) & 1;
            lrs <<= 1;
            lrs |= bit0;
            if (spa == 2) {
                dbuf[i++] = data;
            }
            dbuf[i] = data;
        }
        return lrs;
    }

    public static int ramp(float[] fbuf, double amp, int n, int spa, int data) {
        for (int i = 0; i < n * spa; ++i) {
            if (spa == 2) {
                fbuf[i++] = data;
            }
            fbuf[i] = data;
            if (!((double)(++data) >= amp)) continue;
            data = (int)(-amp);
        }
        return data;
    }

    public static int ramp(double[] dbuf, double amp, int n, int spa, int data) {
        for (int i = 0; i < n * spa; ++i) {
            if (spa == 2) {
                dbuf[i++] = data;
            }
            dbuf[i] = data;
            if (!((double)(++data) >= amp)) continue;
            data = (int)(-amp);
        }
        return data;
    }
}

