/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libm;

public class Tolerance {
    private static double defaultTolerance = 1.0E-6;
    private static double SMALLEST_ALLOWED = 1.0E-35;

    @Deprecated
    public Tolerance() {
    }

    public static void setTolerance(double tolr) {
        defaultTolerance = Math.abs(tolr);
    }

    public static double getTolerance() {
        return defaultTolerance;
    }

    public static boolean equalsWithTolerance(double d1, double d2) {
        return Tolerance.equalsWithTolerance(d1, d2, defaultTolerance);
    }

    public static boolean equalsWithTolerance(double d1, double d2, double tolr) {
        if (tolr == 0.0) {
            return d1 == d2;
        }
        if (tolr < 0.0) {
            tolr = defaultTolerance;
        }
        return Tolerance.eqt(d1, d2, tolr);
    }

    private static boolean eqt(double d1, double d2, double tolr) {
        if (d1 == d2) {
            return true;
        }
        if (Math.abs(d1) < SMALLEST_ALLOWED && Math.abs(d2) < SMALLEST_ALLOWED) {
            return true;
        }
        double error = Math.abs(d1 - d2) / ((Math.abs(d1) + Math.abs(d2)) / 2.0);
        return error < tolr;
    }

    public static boolean equalsWithTolerance(Object array1, int off1, Object array2, int off2, int length, double tolr) {
        if (tolr < 0.0) {
            tolr = defaultTolerance;
        }
        int i = off1;
        int j = off2;
        int ii = i + length;
        if (array1 instanceof double[]) {
            double[] a1 = (double[])array1;
            double[] a2 = (double[])array2;
            if (tolr == 0.0) {
                while (i < ii) {
                    if (a1[i] != a2[j]) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            } else {
                while (i < ii) {
                    if (!Tolerance.eqt(a1[i], a2[j], tolr)) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            }
        } else if (array1 instanceof float[]) {
            float[] a1 = (float[])array1;
            float[] a2 = (float[])array2;
            if (tolr == 0.0) {
                while (i < ii) {
                    if (a1[i] != a2[j]) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            } else {
                while (i < ii) {
                    if (!Tolerance.eqt(a1[i], a2[j], tolr)) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            }
        } else if (array1 instanceof long[]) {
            long[] a1 = (long[])array1;
            long[] a2 = (long[])array2;
            if (tolr < 1.0) {
                while (i < ii) {
                    if (a1[i] != a2[j]) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            } else {
                while (i < ii) {
                    if (!Tolerance.eqt(a1[i], a2[j], tolr)) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            }
        } else if (array1 instanceof int[]) {
            int[] a1 = (int[])array1;
            int[] a2 = (int[])array2;
            if (tolr < 1.0) {
                while (i < ii) {
                    if (a1[i] != a2[j]) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            } else {
                while (i < ii) {
                    if (!Tolerance.eqt(a1[i], a2[j], tolr)) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            }
        } else if (array1 instanceof short[]) {
            short[] a1 = (short[])array1;
            short[] a2 = (short[])array2;
            if (tolr < 1.0) {
                while (i < ii) {
                    if (a1[i] != a2[j]) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            } else {
                while (i < ii) {
                    if (!Tolerance.eqt(a1[i], a2[j], tolr)) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            }
        } else if (array1 instanceof byte[]) {
            byte[] a1 = (byte[])array1;
            byte[] a2 = (byte[])array2;
            if (tolr < 1.0) {
                while (i < ii) {
                    if (a1[i] != a2[j]) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            } else {
                while (i < ii) {
                    if (!Tolerance.eqt(a1[i], a2[j], tolr)) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            }
        } else if (array1 instanceof Number[]) {
            Number[] a1 = (Number[])array1;
            Number[] a2 = (Number[])array2;
            if (tolr == 0.0) {
                while (i < ii) {
                    if (a1[i].equals(a2[j])) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            } else {
                while (i < ii) {
                    if (!Tolerance.eqt(a1[i].doubleValue(), a2[j].doubleValue(), tolr)) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            }
        } else {
            throw new IllegalArgumentException("Illegal type " + array1.getClass());
        }
        return true;
    }

    public static boolean equalsWithAbsTol(double d1, double d2) {
        if (d1 == d2) {
            return true;
        }
        return Math.abs(d1 - d2) <= defaultTolerance;
    }

    public static boolean equalsWithAbsTol(double d1, double d2, double delta) {
        if (d1 == d2) {
            return true;
        }
        if (delta < 0.0) {
            delta = defaultTolerance;
        }
        return Math.abs(d1 - d2) <= delta;
    }

    public static boolean equals(double d1, double d2) {
        if (d1 == d2) {
            return true;
        }
        double d1_ulp = Math.ulp(d1);
        return d2 >= d1 - d1_ulp && d2 <= d1 + d1_ulp;
    }

    public static boolean equals(float f1, float f2) {
        if (f1 == f2) {
            return true;
        }
        double f1_ulp = Math.ulp(f1);
        return (double)f2 >= (double)f1 - f1_ulp && (double)f2 <= (double)f1 + f1_ulp;
    }

    public static boolean equalsWithAbsTolerance(Object array1, int off1, Object array2, int off2, int length, double delta) {
        if (delta < 0.0) {
            delta = defaultTolerance;
        }
        int i = off1;
        int j = off2;
        int ii = i + length;
        if (array1 instanceof double[]) {
            double[] a1 = (double[])array1;
            double[] a2 = (double[])array2;
            if (delta == 0.0) {
                while (i < ii) {
                    if (a1[i] != a2[j]) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            } else {
                while (i < ii) {
                    if (!Tolerance.equalsWithAbsTol(a1[i], a2[j], delta)) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            }
        } else if (array1 instanceof float[]) {
            float[] a1 = (float[])array1;
            float[] a2 = (float[])array2;
            if (delta == 0.0) {
                while (i < ii) {
                    if (a1[i] != a2[j]) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            } else {
                while (i < ii) {
                    if (!Tolerance.equalsWithAbsTol(a1[i], a2[j], delta)) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            }
        } else if (array1 instanceof long[]) {
            long[] a1 = (long[])array1;
            long[] a2 = (long[])array2;
            if (delta < 1.0) {
                while (i < ii) {
                    if (a1[i] != a2[j]) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            } else {
                while (i < ii) {
                    if (!Tolerance.equalsWithAbsTol(a1[i], a2[j], delta)) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            }
        } else if (array1 instanceof int[]) {
            int[] a1 = (int[])array1;
            int[] a2 = (int[])array2;
            if (delta < 1.0) {
                while (i < ii) {
                    if (a1[i] != a2[j]) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            } else {
                while (i < ii) {
                    if (!Tolerance.equalsWithAbsTol(a1[i], a2[j], delta)) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            }
        } else if (array1 instanceof short[]) {
            short[] a1 = (short[])array1;
            short[] a2 = (short[])array2;
            if (delta < 1.0) {
                while (i < ii) {
                    if (a1[i] != a2[j]) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            } else {
                while (i < ii) {
                    if (!Tolerance.equalsWithAbsTol(a1[i], a2[j], delta)) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            }
        } else if (array1 instanceof byte[]) {
            byte[] a1 = (byte[])array1;
            byte[] a2 = (byte[])array2;
            if (delta < 1.0) {
                while (i < ii) {
                    if (a1[i] != a2[j]) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            } else {
                while (i < ii) {
                    if (!Tolerance.equalsWithAbsTol(a1[i], a2[j], delta)) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            }
        } else if (array1 instanceof Number[]) {
            Number[] a1 = (Number[])array1;
            Number[] a2 = (Number[])array2;
            if (delta == 0.0) {
                while (i < ii) {
                    if (a1[i].equals(a2[j])) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            } else {
                while (i < ii) {
                    if (!Tolerance.eqt(a1[i].doubleValue(), a2[j].doubleValue(), delta)) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
            }
        } else {
            throw new IllegalArgumentException("Illegal type " + array1.getClass());
        }
        return true;
    }
}

