/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libm;

import nxm.sys.libm.Operator;

public class Random
extends Operator {
    private static final double A = 6.7081293E7;
    private static final double B = 1.4181771E7;
    private static final double T26 = 6.7108864E7;
    private static final double BI = 0.21132485568523407;
    private static int seed = 123456789;

    public Random() {
    }

    public Random(int flags) {
        super(flags);
    }

    public Random(double scale) {
        super(scale);
    }

    public Random(int flags, double scale) {
        super(flags, scale);
    }

    @Override
    public int getInputs() {
        return 0;
    }

    @Override
    public int getOutputs() {
        return 1;
    }

    @Override
    public int validate(char type, int n, int mode) {
        switch (mode) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    @Override
    public int process(double[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 1: {
                Random.get(v[0], n, scale);
                break;
            }
            case 2: {
                Random.get(v[0], n * 2, scale);
                break;
            }
            case 3: {
                Random.get(v[0], n * 3, scale);
                break;
            }
            default: {
                return -1;
            }
        }
        return n;
    }

    @Override
    public int process(double[][] v, int n, int mode) {
        switch (mode) {
            case 1: {
                Random.get(v[0], n, this.scale);
                break;
            }
            case 2: {
                Random.get(v[0], n * 2, this.scale);
                break;
            }
            case 3: {
                Random.get(v[0], n * 3, this.scale);
                break;
            }
            default: {
                return -1;
            }
        }
        return n;
    }

    public static void get(double[] a, int size, double scale) {
        double sis = (double)seed / 6.7108864E7;
        int i = 0;
        while (i < size) {
            sis = sis * 6.7081293E7 + 0.21132485568523407;
            sis -= (double)((int)sis);
            a[i++] = sis * scale;
        }
        seed = (int)(sis * 6.7108864E7);
    }

    @Override
    public int process(float[][] v, int n, int mode, double scale) {
        switch (mode) {
            case 1: {
                Random.get(v[0], n, scale);
                break;
            }
            case 2: {
                Random.get(v[0], n * 2, scale);
                break;
            }
            case 3: {
                Random.get(v[0], n * 3, scale);
                break;
            }
            default: {
                return -1;
            }
        }
        return n;
    }

    @Override
    public int process(float[][] v, int n, int mode) {
        switch (mode) {
            case 1: {
                Random.get(v[0], n, this.scale);
                break;
            }
            case 2: {
                Random.get(v[0], n * 2, this.scale);
                break;
            }
            case 3: {
                Random.get(v[0], n * 3, this.scale);
                break;
            }
            default: {
                return -1;
            }
        }
        return n;
    }

    public static void get(float[] a, int size, double scale) {
        double sis = (double)seed / 6.7108864E7;
        int i = 0;
        while (i < size) {
            sis = sis * 6.7081293E7 + 0.21132485568523407;
            sis -= (double)((int)sis);
            a[i++] = (float)(sis * scale);
        }
        seed = (int)(sis * 6.7108864E7);
    }

    public static int getSeed() {
        return seed;
    }

    public static void setSeed(int newSeed) {
        if ((double)newSeed >= 6.7108864E7) {
            throw new IllegalArgumentException("new seed [" + newSeed + "] must be less than 2^26");
        }
        seed = newSeed;
    }
}

