/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libm;

public class MMath {
    private static final int LOG_BITS = 14;
    private static final int LOG_SHIFT = 10;
    private static final float[] LOG_TABLE = MMath.bldLogTable();
    private static final float LOG2_E = MMath.fastLog2((float)Math.E);

    @Deprecated
    public MMath() {
    }

    public static int power2GE(int arg) {
        int value;
        if (arg <= 1) {
            value = 1;
        } else if (arg < 32768) {
            for (value = 2; value < arg; value += value) {
            }
        } else if (arg < 0x40000000) {
            for (value = 32768; value < arg; value += value) {
            }
        } else {
            value = 0;
        }
        return value;
    }

    public static double power2GE(double arg) {
        double value;
        if (arg <= 1.0) {
            value = 1.0;
        } else if (arg < 32768.0) {
            for (value = 2.0; value < arg; value += value) {
            }
        } else {
            for (value = 32768.0; value < arg; value += value) {
            }
        }
        return value;
    }

    public static int leastSquaresFit(double[] b, int order, double[] data, int ndata, int n1, int n2) {
        int ncoef = order + 1;
        double dx = 1.0 / (double)ndata;
        double[] xstor = new double[ncoef * 2];
        double[] a = new double[ncoef * ncoef];
        for (int i = 0; i < ncoef; ++i) {
            b[i] = 0.0;
        }
        for (int j = n1; j < n2; ++j) {
            double xx = 1.0;
            double x = (double)j * dx;
            int i = 0;
            while (i < 2 * ncoef) {
                xstor[i] = xx;
                ++i;
                xx *= x;
            }
            for (i = 0; i < ncoef; ++i) {
                int n = i;
                b[n] = b[n] + data[j] * xstor[i];
                for (int l = 0; l < ncoef; ++l) {
                    int n3 = i * ncoef + l;
                    a[n3] = a[n3] + xstor[i + l];
                }
            }
        }
        return MMath.solveByGaussianElimination(a, b, ncoef, 0.0);
    }

    public static int leastSquaresEval(double[] b, int order, double[] data, int ndata) {
        double dx = 1.0 / (double)ndata;
        for (int j = 0; j < ndata; ++j) {
            double x;
            double xx = x = (double)j * dx;
            double value = b[0];
            int i = 1;
            while (i <= order) {
                value += xx * b[i];
                ++i;
                xx *= x;
            }
            data[j] = value;
        }
        return 0;
    }

    public static void deNormalizeCoef(double[] b, int order, double xstart, double xdelta, int ndata) {
        int ncoef = order + 1;
        double xdd = 1.0;
        int[] pt = MMath.getPascalsTriangle(ncoef);
        double xd = 1.0 / (xdelta * (double)ndata);
        double xs = -xstart * xd;
        int i = 0;
        while (i < ncoef) {
            double d = 0.0;
            for (int j = order; j > i; --j) {
                d = (d + (double)pt[j + i * ncoef] * b[j]) * xs;
            }
            b[i] = (d + b[i]) * xdd;
            ++i;
            xdd *= xd;
        }
    }

    public static int[] getPascalsTriangle(int ncoef) {
        int[] pt = new int[ncoef * ncoef];
        for (int i = 0; i < ncoef; ++i) {
            pt[i] = 1;
            for (int j = 1; j < i; ++j) {
                pt[i + j * ncoef] = pt[i - 1 + j * ncoef] + pt[i - 1 + (j - 1) * ncoef];
            }
            pt[i + i * ncoef] = 1;
        }
        return pt;
    }

    public static int solveByGaussianElimination(double[] a, double[] b, int ncoef, double tolr) {
        int i;
        int j;
        int imax = 0;
        if (ncoef < 1) {
            return 0;
        }
        for (j = 0; j < ncoef; ++j) {
            double temp;
            double bigA = 0.0;
            for (i = j; i < ncoef; ++i) {
                double aij = a[i + j * ncoef];
                if (!(Math.abs(aij) > Math.abs(bigA))) continue;
                bigA = aij;
                imax = i;
            }
            if (Math.abs(bigA) < tolr) {
                return 1;
            }
            for (i = j; i < ncoef; ++i) {
                int ji = j + i * ncoef;
                int imaxi = imax + i * ncoef;
                temp = a[imaxi];
                a[imaxi] = a[ji];
                a[ji] = temp / bigA;
            }
            temp = b[imax];
            b[imax] = b[j];
            b[j] = temp / bigA;
            i = j + 1;
            while (i < ncoef) {
                temp = a[i + j * ncoef];
                int pos1 = i + (j + 1) * ncoef;
                int pos2 = j + (j + 1) * ncoef;
                for (int k = j + 1; k < ncoef; ++k) {
                    int n = pos1;
                    a[n] = a[n] - temp * a[pos2];
                    pos1 += ncoef;
                    pos2 += ncoef;
                }
                int n = i++;
                b[n] = b[n] - temp * b[j];
            }
        }
        for (i = ncoef - 2; i >= 0; --i) {
            for (j = ncoef - 1; j > i; --j) {
                int n = i;
                b[n] = b[n] - a[i + j * ncoef] * b[j];
            }
        }
        return 0;
    }

    public static double ModuloFloor(double a, double b) {
        return a * b < 0.0 ? a % b + b : a % b;
    }

    public static double ModuloEuclid(double a, double b) {
        return a < 0.0 ? a % b + Math.abs(b) : a % b;
    }

    private static final float[] bldLogTable() {
        float[] logs = new float[16384];
        double log2 = Math.log(2.0);
        for (int i = 1; i < logs.length; ++i) {
            int bits = i << 10 | 0x40000000;
            float val = Float.intBitsToFloat(bits);
            logs[i] = (float)(Math.log(val) / log2 - 1.0);
        }
        return logs;
    }

    public static final float fastLog(float x) {
        return MMath.fastLog2(x) / LOG2_E;
    }

    public static final float fastLog2(float x) {
        if (x <= 0.0f || Float.isNaN(x)) {
            return Float.NaN;
        }
        int val = Float.floatToRawIntBits(x);
        int man = val & 0x7FFFFF;
        int exp = (val >> 23 & 0xFF) - 127;
        return (float)exp + LOG_TABLE[man >>> 10];
    }
}

