/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import nxm.sys.libg.DPix;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.Pix;
import nxm.sys.libg.View;

public class ViewPolar
extends View {
    private float[] tsin;
    private float[] tcos;
    private float[] dtsin;
    private float[] dtcos;
    private static final int ndeg = 725;

    public ViewPolar(MPlot MP) {
        super(MP);
        this.prepTables();
    }

    private void prepTables() {
        int i;
        this.tsin = new float[725];
        this.tcos = new float[725];
        this.dtsin = new float[725];
        this.dtcos = new float[725];
        for (i = 0; i < 725; ++i) {
            this.tsin[i] = (float)Math.sin(Math.PI / 180 * (double)i);
            this.tcos[i] = (float)Math.cos(Math.PI / 180 * (double)i);
        }
        for (i = 0; i < 724; ++i) {
            this.dtsin[i] = this.tsin[i + 1] - this.tsin[i];
            this.dtcos[i] = this.tcos[i + 1] - this.tcos[i];
        }
    }

    @Override
    public int rwc2pix(float[] buf, int off, int dim, int npts, Pix pix, double xstart, double xdelta) {
        int j = off;
        int n = pix.setSize(npts);
        int xoff = off / dim;
        int[] pax = pix.x;
        int[] pay = pix.y;
        double mxx = this.MP.mxx;
        double myy = this.MP.myy;
        double mxb = this.MP.mxb;
        double myb = this.MP.myb;
        double x = xstart + (double)xoff * xdelta;
        int i = 0;
        while (i < n) {
            double theta = x * (Math.PI / 180);
            x += xdelta;
            pax[i] = (int)((double)buf[j] * Math.cos(theta) * mxx + mxb);
            pay[i] = (int)((double)buf[j] * Math.sin(theta) * myy + myb);
            ++i;
            j += dim;
        }
        return n;
    }

    @Override
    public int rwc2pix(double[] buf, int off, int dim, int npts, Pix pix, double xstart, double xdelta) {
        int j = off;
        int n = pix.setSize(npts);
        int xoff = off / dim;
        int[] pax = pix.x;
        int[] pay = pix.y;
        double mxx = this.MP.mxx;
        double myy = this.MP.myy;
        double mxb = this.MP.mxb;
        double myb = this.MP.myb;
        double x = xstart + (double)xoff * xdelta;
        int i = 0;
        while (i < n) {
            double theta = x * (Math.PI / 180);
            x += xdelta;
            pax[i] = (int)(buf[j] * Math.cos(theta) * mxx + mxb);
            pay[i] = (int)(buf[j] * Math.sin(theta) * myy + myb);
            ++i;
            j += dim;
        }
        return n;
    }

    @Override
    public int rwc2pix(float[] buf, int off, int dim, int npts, Pix pix) {
        int j = off;
        int n = pix.setSize(npts);
        int[] pax = pix.x;
        int[] pay = pix.y;
        double mxx = this.MP.mxx;
        double myy = this.MP.myy;
        double mxb = this.MP.mxb;
        double myb = this.MP.myb;
        int i = 0;
        while (i < n) {
            float atheta = buf[j] + 360.0f;
            int itheta = (int)atheta;
            float ptheta = atheta - (float)itheta;
            float ct = this.tcos[itheta] + ptheta * this.dtcos[itheta];
            float st = this.tsin[itheta] + ptheta * this.dtsin[itheta];
            float r = buf[j + 1];
            pax[i] = (int)((double)(r * ct) * mxx + mxb);
            pay[i] = (int)((double)(r * st) * myy + myb);
            ++i;
            j += dim;
        }
        return n;
    }

    @Override
    public int rwc2pix(double[] buf, int off, int dim, int npts, Pix pix) {
        int j = off;
        int n = pix.setSize(npts);
        int[] pax = pix.x;
        int[] pay = pix.y;
        double mxx = this.MP.mxx;
        double myy = this.MP.myy;
        double mxb = this.MP.mxb;
        double myb = this.MP.myb;
        int i = 0;
        while (i < n) {
            double atheta = buf[j] + 360.0;
            int itheta = (int)atheta;
            double ptheta = atheta - (double)itheta;
            double ct = (double)this.tcos[itheta] + ptheta * (double)this.dtcos[itheta];
            double st = (double)this.tsin[itheta] + ptheta * (double)this.dtsin[itheta];
            double r = buf[j + 1];
            pax[i] = (int)(r * ct * mxx + mxb);
            pay[i] = (int)(r * st * myy + myb);
            ++i;
            j += dim;
        }
        return n;
    }

    @Override
    int rwc2pix(double[] buf, int off, int dim, int npts, Pix pix, boolean isFill) {
        return this.rwc2pix(buf, off, dim, npts, pix);
    }

    @Override
    public int rwc2dpix(double[] buf, int off, int dim, int npts, DPix pix) {
        int j = off;
        int n = pix.setSize(npts);
        double[] pax = pix.x;
        double[] pay = pix.y;
        double mxx = this.MP.mxx;
        double myy = this.MP.myy;
        double mxb = this.MP.mxb;
        double myb = this.MP.myb;
        int i = 0;
        while (i < n) {
            double atheta = buf[j] + 360.0;
            int itheta = (int)atheta;
            double ptheta = atheta - (double)itheta;
            double ct = (double)this.tcos[itheta] + ptheta * (double)this.dtcos[itheta];
            double st = (double)this.tsin[itheta] + ptheta * (double)this.dtsin[itheta];
            double r = buf[j + 1];
            pax[i] = r * ct * mxx + mxb;
            pay[i] = r * st * myy + myb;
            ++i;
            j += dim;
        }
        return n;
    }
}

