/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import nxm.sys.lib.Midas;
import nxm.sys.lib.TMatrix;
import nxm.sys.libg.DPix;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.MPoint;
import nxm.sys.libg.Pix;
import nxm.sys.libg.View;

public class View3D
extends View {
    public double azim = 0.0;
    public double elev = 0.0;
    public double roll = 0.0;
    public double pdis = 2.5;
    double xscale;
    double xcenter;
    double yscale;
    double ycenter;
    double zscale;
    double zcenter;
    private TMatrix tm = new TMatrix();
    private TMatrix tmi = new TMatrix();

    public View3D(MPlot MP) {
        super(MP);
        this.setup();
    }

    @Override
    public boolean setObserver(double[] arg) {
        if (arg != null) {
            this.tm.identity();
            if (arg.length > 3 && arg[3] != 0.0) {
                this.pdis = arg[3];
            }
            if (arg.length > 2) {
                this.tm.rotate(arg[2], 3);
                this.roll = arg[2];
            }
            if (arg.length > 1) {
                this.tm.rotate(arg[1], 2);
                this.elev = arg[1];
            }
            if (arg.length > 0) {
                this.tm.rotate(arg[0], 1);
                this.azim = arg[0];
            }
        }
        this.setup();
        return true;
    }

    @Override
    public boolean getObserver(double[] arg) {
        arg[0] = this.azim;
        arg[1] = this.elev;
        arg[2] = this.roll;
        if (arg.length > 3) {
            arg[3] = this.pdis;
        }
        return true;
    }

    @Override
    public boolean rotate(double[] arg) {
        this.tm.rotate(arg[0], 1);
        this.tm.rotate(arg[1], 2);
        this.tm.rotate(arg[2], 3);
        this.azim = Math.asin(this.tm.a21) * 57.29577951308232;
        this.elev = Math.asin(this.tm.a31) * 57.29577951308232;
        this.roll = Math.asin(this.tm.a32) * 57.29577951308232;
        return true;
    }

    @Override
    public void setup() {
        this.tm.invert(this.tmi);
        this.zscale = 1.0;
        this.yscale = 1.0;
        this.xscale = 1.0;
        if (this.MP.orx2 != this.MP.orx1) {
            this.xscale = 2.0 / (this.MP.orx2 - this.MP.orx1);
        }
        this.xcenter = (this.MP.orx1 + this.MP.orx2) / 2.0;
        if (this.MP.ory2 != this.MP.ory1) {
            this.yscale = 2.0 / (this.MP.ory2 - this.MP.ory1);
        }
        this.ycenter = (this.MP.ory1 + this.MP.ory2) / 2.0;
        if (this.MP.orz2 != this.MP.orz1) {
            this.zscale = 2.0 / (this.MP.orz2 - this.MP.orz1);
        }
        this.zcenter = (this.MP.orz1 + this.MP.orz2) / 2.0;
    }

    @Override
    public int rwc2pix(double[] rwc, MPoint pix) {
        int vis = this.rwc2pix(rwc, 0, 3, 1, this.MP.tpix);
        pix.x = this.MP.tpix.x[0];
        pix.y = this.MP.tpix.y[0];
        return vis;
    }

    @Override
    public int pix2rwc(MPoint pix, double[] rwc) {
        return 1;
    }

    @Override
    public int rwc2pix(float[] buf, int off, int dim, int npts, Pix pix, double xstart, double xdelta) {
        int j = off;
        int n = pix.setSize(npts);
        int xoff = off / dim;
        float[] buf2 = new float[n * 2];
        int bufOffset = 0;
        for (int i = 0; i < n; ++i) {
            double x = xstart + (double)(xoff + i) * xdelta;
            buf2[bufOffset++] = (float)x;
            buf2[bufOffset++] = (float)Math.IEEEremainder(buf[j], 360.0);
            j += dim;
        }
        return this.rwc2pix(buf2, 0, 2, n, pix);
    }

    @Override
    public int rwc2pix(double[] buf, int off, int dim, int npts, Pix pix, double xstart, double xdelta) {
        int j = off;
        int n = pix.setSize(npts);
        int xoff = off / dim;
        double[] buf2 = new double[n * 2];
        int bufOffset = 0;
        for (int i = 0; i < n; ++i) {
            double x = xstart + (double)(xoff + i) * xdelta;
            buf2[bufOffset++] = x;
            buf2[bufOffset++] = Math.IEEEremainder(buf[j], 360.0);
            j += dim;
        }
        return this.rwc2pix(buf2, 0, 2, n, pix);
    }

    @Override
    public int rwc2pix(float[] buf, int off, int dim, int npts, Pix pix) {
        int i;
        int j = off;
        int n = pix.setSize(npts);
        int[] pax = pix.x;
        int[] pay = pix.y;
        float[] paz = pix.z;
        float mxx = (float)this.MP.mxx;
        float myy = (float)this.MP.myy;
        float mxb = (float)this.MP.mxb;
        float myb = (float)this.MP.myb;
        float a11 = (float)this.tmi.a11;
        float a21 = (float)this.tmi.a21;
        float a31 = (float)this.tmi.a31;
        float a12 = (float)this.tmi.a12;
        float a22 = (float)this.tmi.a22;
        float a32 = (float)this.tmi.a32;
        float a13 = (float)this.tmi.a13;
        float a23 = (float)this.tmi.a23;
        float a33 = (float)this.tmi.a33;
        float xs = (float)this.xscale;
        float xc = (float)this.xcenter;
        float ys = (float)this.yscale;
        float yc = (float)this.ycenter;
        float zs = (float)this.zscale;
        float zc = (float)this.zcenter;
        float zobs = (float)this.pdis;
        if ((pix.flags & 8) != 0) {
            zc = 0.0f;
            yc = 0.0f;
            xc = 0.0f;
            zs = 1.0f;
            ys = 1.0f;
            xs = 1.0f;
        }
        if (dim == 2) {
            for (i = 0; i < n; ++i) {
                float x = (buf[j++] - xc) * xs;
                float y = (buf[j++] - yc) * ys;
                float xx = x * a11 + y * a21;
                float yy = x * a12 + y * a22;
                float zz = x * a13 + y * a23;
                float ff = zobs / (zobs - zz);
                pax[i] = (int)(xx * ff * mxx + mxb);
                pay[i] = (int)(yy * ff * myy + myb);
                paz[i] = zz;
            }
        } else {
            for (i = 0; i < n; ++i) {
                float x = (buf[j++] - xc) * xs;
                float y = (buf[j++] - yc) * ys;
                float z = (buf[j++] - zc) * zs;
                float xx = x * a11 + y * a21 + z * a31;
                float yy = x * a12 + y * a22 + z * a32;
                float zz = x * a13 + y * a23 + z * a33;
                float ff = zobs / (zobs - zz);
                pax[i] = (int)(xx * ff * mxx + mxb);
                pay[i] = (int)(yy * ff * myy + myb);
                paz[i] = zz;
            }
        }
        pix.n = i;
        return n;
    }

    @Override
    public int rwc2pix(double[] buf, int off, int dim, int npts, Pix pix) {
        int i;
        if (off + dim * npts > buf.length) {
            Midas.log("Data is incompatible with View 3D", 1);
            return 0;
        }
        int j = off;
        int n = pix.setSize(npts);
        int[] pax = pix.x;
        int[] pay = pix.y;
        float[] paz = pix.z;
        double mxx = this.MP.mxx;
        double myy = this.MP.myy;
        double mxb = this.MP.mxb;
        double myb = this.MP.myb;
        double a11 = this.tmi.a11;
        double a21 = this.tmi.a21;
        double a31 = this.tmi.a31;
        double a12 = this.tmi.a12;
        double a22 = this.tmi.a22;
        double a32 = this.tmi.a32;
        double a13 = this.tmi.a13;
        double a23 = this.tmi.a23;
        double a33 = this.tmi.a33;
        double xs = this.xscale;
        double xc = this.xcenter;
        double ys = this.yscale;
        double yc = this.ycenter;
        double zs = this.zscale;
        double zc = this.zcenter;
        double zobs = this.pdis;
        if ((pix.flags & 8) != 0) {
            zc = 0.0;
            yc = 0.0;
            xc = 0.0;
            zs = 1.0;
            ys = 1.0;
            xs = 1.0;
        }
        if (dim == 2) {
            for (i = 0; i < n; ++i) {
                double x = (buf[j++] - xc) * xs;
                double y = (buf[j++] - yc) * ys;
                double xx = x * a11 + y * a21;
                double yy = x * a12 + y * a22;
                double zz = x * a13 + y * a23;
                double ff = zobs / (zobs - zz);
                pax[i] = (int)(xx * ff * mxx + mxb);
                pay[i] = (int)(yy * ff * myy + myb);
                paz[i] = (float)zz;
            }
        } else {
            for (i = 0; i < n; ++i) {
                double x = (buf[j++] - xc) * xs;
                double y = (buf[j++] - yc) * ys;
                double z = (buf[j++] - zc) * zs;
                double xx = x * a11 + y * a21 + z * a31;
                double yy = x * a12 + y * a22 + z * a32;
                double zz = x * a13 + y * a23 + z * a33;
                double ff = zobs / (zobs - zz);
                pax[i] = (int)(xx * ff * mxx + mxb);
                pay[i] = (int)(yy * ff * myy + myb);
                paz[i] = (float)zz;
            }
        }
        pix.n = i;
        return n;
    }

    public double getScale() {
        return this.xscale;
    }

    boolean needAltXYGrid() {
        return Math.toDegrees(Math.asin(this.tm.a33)) < 0.0;
    }

    boolean needAltYZGrid() {
        return Math.toDegrees(Math.asin(this.tm.a22)) < 0.0 && this.elev < 0.0;
    }

    boolean needAltXZGrid() {
        return this.roll < 0.0;
    }

    @Override
    int rwc2dpix(double[] buf, DPix pix) {
        return this.rwc2dpix(buf, 0, 3, 1, pix);
    }

    @Override
    public int rwc2dpix(double[] buf, int off, int dim, int npts, DPix pix) {
        int i;
        int j = off;
        int n = pix.setSize(npts);
        double[] pax = pix.x;
        double[] pay = pix.y;
        double[] paz = pix.z;
        double mxx = this.MP.mxx;
        double myy = this.MP.myy;
        double mxb = this.MP.mxb;
        double myb = this.MP.myb;
        double a11 = this.tmi.a11;
        double a21 = this.tmi.a21;
        double a31 = this.tmi.a31;
        double a12 = this.tmi.a12;
        double a22 = this.tmi.a22;
        double a32 = this.tmi.a32;
        double a13 = this.tmi.a13;
        double a23 = this.tmi.a23;
        double a33 = this.tmi.a33;
        double xs = this.xscale;
        double xc = this.xcenter;
        double ys = this.yscale;
        double yc = this.ycenter;
        double zs = this.zscale;
        double zc = this.zcenter;
        double zobs = this.pdis;
        if ((pix.flags & 8) != 0) {
            zc = 0.0;
            yc = 0.0;
            xc = 0.0;
            zs = 1.0;
            ys = 1.0;
            xs = 1.0;
        }
        if (dim == 2) {
            for (i = 0; i < n; ++i) {
                double x = (buf[j++] - xc) * xs;
                double y = (buf[j++] - yc) * ys;
                double xx = x * a11 + y * a21;
                double yy = x * a12 + y * a22;
                double zz = x * a13 + y * a23;
                double ff = zobs / (zobs - zz);
                pax[i] = xx * ff * mxx + mxb;
                pay[i] = yy * ff * myy + myb;
                paz[i] = zz;
            }
        } else {
            for (i = 0; i < n; ++i) {
                double x = (buf[j++] - xc) * xs;
                double y = (buf[j++] - yc) * ys;
                double z = (buf[j++] - zc) * zs;
                double xx = x * a11 + y * a21 + z * a31;
                double yy = x * a12 + y * a22 + z * a32;
                double zz = x * a13 + y * a23 + z * a33;
                double ff = zobs / (zobs - zz);
                pax[i] = xx * ff * mxx + mxb;
                pay[i] = yy * ff * myy + myb;
                paz[i] = zz;
            }
        }
        pix.n = i;
        return n;
    }

    @Override
    int rwc2pix(double[] rwc, MPoint pix, boolean rangeAdjust) {
        Midas.log("rwc2pix with range adjustment designed for latloncontinuous is NOT designed for View3D", 1);
        return this.rwc2pix(rwc, pix);
    }

    @Override
    int rwc2pix(double[] buf, int off, int dim, int npts, Pix pix, boolean isSpecializedFill) {
        return this.rwc2pix(buf, off, dim, npts, pix);
    }

    @Override
    int rwc2pixClip(float[] buf, int off, int dim, int npts, Pix pix, boolean mer) {
        Midas.log("rwc2pixClip is NOT designed for View3D", 1);
        return this.rwc2pix(buf, off, dim, npts, pix);
    }

    @Override
    int rwc2pixClip(double[] buf, int off, int dim, int npts, MPlot MP, Pix pix) {
        Midas.log("rwc2pixClip is NOT designed for View3D", 1);
        return this.rwc2pix(buf, off, dim, npts, pix);
    }

    @Override
    int rwc2pixClip(double[] buf, int off, int dim, int npts, Pix pix, boolean mer) {
        Midas.log("rwc2pixClip is NOT designed for View3D", 1);
        return this.rwc2pix(buf, off, dim, npts, pix);
    }

    @Override
    int rwc2pixClipAdjustForFill(double[] buf, int off, int dim, int npts, Pix pix, boolean mer) {
        Midas.log("rwc2pixClipAdjustForFill is NOT designed for View3D", 1);
        return this.rwc2pix(buf, off, dim, npts, pix);
    }

    @Override
    int rwc2dpixClip(double[] buf, int off, int dim, int npts, MPlot MP, DPix pix) {
        Midas.log("rwc2dpixClip is NOT designed for View3D", 1);
        return this.rwc2dpix(buf, off, dim, npts, pix);
    }

    @Override
    int rwc2dpixClip(double[] buf, int off, int dim, int npts, DPix pix, boolean mer) {
        Midas.log("rwc2dpixClip is NOT designed for View3D", 1);
        return this.rwc2dpix(buf, off, dim, npts, pix);
    }
}

