/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Args;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataFileHeader;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.libg.MPlot;
import nxm.sys.prim.prescaler;

@InternalUseOnly
public class PrescaleSupport {
    private String inFile;
    private Midas M;
    private MPlot MP;
    private Args MA;
    private boolean debug = false;
    private boolean needScaleTable;
    private Table scaleTable;
    private static final String DEFAULT_OUTCOPY = "plot_internal_prescale_temp_out.tmp{AUX=RAM}";
    private final String KEY_FOR_KEYWORD_NAME = "/SCALEKW".substring(1);
    private boolean externalPrescale;
    private String inFileAfterPrescale;
    private String prescalerKeywordSwitch = "";
    private Keywords extHeaderKeywords;
    private boolean needWaitToOpenOutInFile;
    private prescaler plotPrescaler = null;
    private int percent = 100;
    private String prescalarOut = null;
    private boolean prescalerExternal;
    private boolean preferKeyword;
    private String prescaleKeywordName = "";
    private boolean runPrescaleCommand;
    private String prescaleType;
    private String scaletableResultName;
    private Table quals = null;
    private Table prescaleSetupTable = null;
    private boolean prescale1000All = false;
    private static final int DEFAULT_MAX_SIZE_ALL_PRESCALE = 256000;
    private int maxSizeFullPrescale = 256000;
    BaseFile bf = null;
    DataFileHeader dfHeader = null;
    boolean singleInputFile;

    public boolean initPrescale(Midas M, MPlot MP, Args MA, String inFile) {
        boolean prescaleDirectlySpecified;
        this.M = M;
        this.MP = MP;
        this.MA = MA;
        this.inFile = inFile;
        boolean bl = this.singleInputFile = inFile != null && !inFile.contains("|");
        if (MA.find("SCALETABLE")) {
            this.setScaleTable(MA.getTable("SCALETABLE"));
        }
        boolean qualifierBasedPrescale = false;
        if (this.singleInputFile) {
            this.bf = BaseFile.getInstanceFor(M, (Object)inFile);
            this.prescaleSetupTable = this.getPrescaleTableFromQuals();
            qualifierBasedPrescale = this.prescaleSetupTable != null && !this.prescaleSetupTable.isEmpty();
        }
        boolean bl2 = prescaleDirectlySpecified = qualifierBasedPrescale || MA.find("/PRESCALE");
        if (!prescaleDirectlySpecified && this.singleInputFile && this.bf instanceof DataFile && !inFile.startsWith("_")) {
            this.prescale1000All = this.is1000PlotAll();
            if (this.prescale1000All) {
                this.percent = -this.maxSizeFullPrescale;
            }
        }
        return prescaleDirectlySpecified || this.prescale1000All;
    }

    public boolean open() {
        if (this.bf == null) {
            this.bf = BaseFile.getInstanceFor(this.M, (Object)this.inFile);
        }
        this.needScaleTable = true;
        this.runPrescaleCommand = true;
        if (this.prescaleSetupTable == null || this.prescaleSetupTable.isEmpty()) {
            this.commandLineStatusUpdate();
        } else {
            this.tableBasedStatusUpdate(this.prescaleSetupTable);
        }
        boolean waitingOnPrescale = false;
        if (this.prescalerExternal) {
            waitingOnPrescale = this.externalPrescalingSetup();
        } else {
            if (!this.singleInputFile) {
                this.M.warning("Multiple input files not allowed on any prescaling type except EXTERNAL, defaulting to regular plot scaling");
                this.runPrescaleCommand = false;
                this.needScaleTable = false;
                return false;
            }
            boolean validFileType = this.processFileHeaderAndKeywords(this.preferKeyword);
            if (!validFileType) {
                this.runPrescaleCommand = false;
                this.needScaleTable = false;
                return false;
            }
            if (!(this.preferKeyword || this.prescaleType.startsWith("int") || this.prescaleType.startsWith("rand") || this.prescaleType.equals(""))) {
                this.M.warning("Invalid prescale option " + this.prescaleType + ", defaulting the prescaler command to be run internally");
            }
            if (this.runPrescaleCommand) {
                waitingOnPrescale = true;
                this.runPrescale();
            }
        }
        if (this.debug) {
            this.M.info(this.toString() + "\n\n");
        }
        return waitingOnPrescale;
    }

    private Table getPrescaleTableFromQuals() {
        Table prescaleSetupTable = null;
        Object prescaleValue = this.bf.getQualifier("PRESCALE");
        if (prescaleValue != null) {
            if (prescaleValue.toString().contains("{")) {
                prescaleSetupTable = new Table(prescaleValue.toString());
            } else if (prescaleValue instanceof String) {
                prescaleSetupTable = new Table("{TYPE=" + prescaleValue + "}");
            }
        }
        return prescaleSetupTable;
    }

    private boolean is1000PlotAll() {
        if (!this.MA.getState("/ALL") || this.MP.scale > 3) {
            return false;
        }
        if (this.dfHeader == null) {
            this.dfHeader = new DataFileHeader((DataFile)this.bf);
        }
        return this.dfHeader.isAbleToParseHeader() && this.dfHeader.getType() == 1000;
    }

    private void commandLineStatusUpdate() {
        String string = this.prescaleType = this.MA.find("/PRESCALE") ? this.MA.getS("/PRESCALE", "INTERNAL") : "";
        if (this.prescaleType.startsWith("{")) {
            Table prescaleTable = new Table(this.prescaleType);
            this.tableBasedStatusUpdate(prescaleTable);
        } else {
            this.prescalarOut = this.MA.getRaw("OUTCOPY");
            this.prescaleKeywordName = this.MA.getS("/SCALEKW", this.prescaleKeywordName);
            this.setTypeRelatedFields(this.prescaleType);
        }
    }

    private void tableBasedStatusUpdate(Table prescaleSetupTable) {
        this.prescaleType = prescaleSetupTable.getS("TYPE", "INTERNAL");
        this.prescaleType = this.prescaleType.toLowerCase();
        if (prescaleSetupTable.containsKey("SCALETABLE")) {
            Table tempTable = prescaleSetupTable.getTable("SCALETABLE");
            if (tempTable == null) {
                this.scaletableResultName = prescaleSetupTable.getS("SCALETABLE");
                this.scaleTable = this.M.getResults().getTable(this.scaletableResultName, this.scaleTable);
            } else {
                this.scaleTable = tempTable;
            }
        }
        this.needScaleTable = this.scaleTable == null || this.scaleTable.isEmpty();
        this.prescalarOut = prescaleSetupTable.getString("OUTCOPY");
        this.setTypeRelatedFields(this.prescaleType);
        this.percent = prescaleSetupTable.getL("RANDOM", this.percent);
        this.prescaleKeywordName = prescaleSetupTable.getS(this.KEY_FOR_KEYWORD_NAME, this.prescaleKeywordName);
    }

    private boolean externalPrescalingSetup() {
        boolean waitingOnPrescale = true;
        this.externalPrescale = true;
        this.runPrescaleCommand = false;
        this.inFileAfterPrescale = this.inFile;
        if (!this.M.isPiped()) {
            if (this.scaleTable != null && !this.scaleTable.isEmpty()) {
                waitingOnPrescale = false;
                this.externalPrescale = false;
            } else {
                this.M.warning("Not running prescaler=ext due to no scale table and not in a pipe/pipe section");
                waitingOnPrescale = false;
                this.needScaleTable = false;
            }
        }
        return waitingOnPrescale;
    }

    @InternalUseOnly
    public void processScaleTable() {
        if (this.scaleTable != null) {
            if (this.scaleTable.containsKey("Y1") || this.scaleTable.containsKey("YMIN") || this.scaleTable.containsKey("Z1") || this.scaleTable.containsKey("ZMIN")) {
                this.MP.scale &= 0xFFFFFFFE;
            }
            if (this.scaleTable.containsKey("Y2") || this.scaleTable.containsKey("YMAX") || this.scaleTable.containsKey("Z2") || this.scaleTable.containsKey("ZMAX")) {
                this.MP.scale &= 0xFFFFFFFD;
            }
            this.setLayerMinMaxScale();
        }
    }

    private void setLayerMinMaxScale() {
        if (this.scaleTable == null || this.scaleTable.isEmpty()) {
            return;
        }
        this.needScaleTable = false;
        KeyObject.setKeys(this.MP, this.scaleTable, this.MA, 1);
        KeyObject.setKeys(this.MP.getBaseLayer(), this.scaleTable, this.MA, 1);
    }

    private void runPrescale() {
        if (this.prescalarOut == null && this.inFile.startsWith("_")) {
            this.prescalarOut = DEFAULT_OUTCOPY;
        }
        String prescalerCmd = "prescaler IN=" + this.inFile;
        if (this.prescalarOut != null) {
            this.inFileAfterPrescale = this.prescalarOut;
            prescalerCmd = prescalerCmd + " OUT=" + this.prescalarOut;
            this.needWaitToOpenOutInFile = true;
        } else {
            this.inFileAfterPrescale = this.inFile;
        }
        if (this.percent <= 20) {
            prescalerCmd = prescalerCmd + " /RANDOM=" + this.percent;
        }
        if (!this.prescalerKeywordSwitch.equals("")) {
            prescalerCmd = prescalerCmd + " " + this.prescalerKeywordSwitch;
        }
        this.plotPrescaler = (prescaler)Shell.execBackgroundCommand(this.M, prescalerCmd);
        this.scaleTable = this.plotPrescaler.table;
    }

    public boolean tryLoadScaleTable() {
        boolean loaded = false;
        if (this.externalPrescale) {
            this.scaleTable = this.scaletableResultName == null ? this.MA.getTable("SCALETABLE") : this.M.getResults().getTable(this.scaletableResultName, this.scaleTable);
        }
        if (this.scaleTable != null && !this.scaleTable.isEmpty()) {
            loaded = true;
        }
        return loaded;
    }

    private void setTypeRelatedFields(String type) {
        this.prescaleType = this.prescaleType.toLowerCase();
        if (this.prescaleType.equals("kw") || this.prescaleType.startsWith("key")) {
            this.preferKeyword = true;
        } else if (this.prescaleType.startsWith("ext")) {
            this.prescalerExternal = true;
        } else if (this.prescaleType.startsWith("rand")) {
            this.percent = -10;
        }
    }

    private boolean processFileHeaderAndKeywords(boolean needKeywords) {
        if (!(this.bf instanceof DataFile)) {
            this.M.warning("PLOT PRESCALE option requires the file be a DataFile, defaulting to regular scaling :" + this.bf);
            return false;
        }
        boolean validFile = false;
        boolean is1000or2000 = false;
        DataFile df = (DataFile)this.bf;
        if (this.dfHeader == null) {
            this.dfHeader = new DataFileHeader(df);
        }
        if (this.dfHeader.isAbleToParseHeader()) {
            int dfType = this.dfHeader.getType();
            validFile = dfType >= 1000 && dfType < 3000;
            is1000or2000 = validFile;
            if (!is1000or2000 && !needKeywords) {
                this.M.warning("PLOT INTERNAL PRESCALE option requires the file a 1000 or 2000 file, defaulting to regular scaling :" + df);
                return false;
            }
            this.scaleTable = new Table();
            if (needKeywords) {
                this.extHeaderKeywords = this.dfHeader.getExtendedHeaderKeywords();
                if (this.scaleTableFromKeywordFromFile()) {
                    this.runPrescaleCommand = false;
                    validFile = true;
                } else if (is1000or2000) {
                    this.needWaitToOpenOutInFile = true;
                } else {
                    this.M.warning("No precale keyword was found in file and file is not 1000 or 2000, defaulting to regular scaling :" + df);
                    return false;
                }
            }
        }
        return validFile;
    }

    public boolean getNeedWaitToOpenOutInFile() {
        return this.needWaitToOpenOutInFile;
    }

    public String getInFileAfterPrescale() {
        return this.inFileAfterPrescale;
    }

    public Table getFileQualifiers() {
        return this.quals;
    }

    public void setMaxSizeFullPrescale(int maxSize) {
        this.maxSizeFullPrescale = maxSize;
    }

    private boolean scaleTableFromKeywordFromFile() {
        if (this.prescaleKeywordName.equals("")) {
            this.prescaleKeywordName = "VOLATILE_KW_PLOT_SCALE";
        }
        this.prescalerKeywordSwitch = "/SCALEKW=" + this.prescaleKeywordName;
        Object tempScale = this.extHeaderKeywords.get(this.prescaleKeywordName);
        if (tempScale != null) {
            this.scaleTable = new Table(tempScale.toString());
            return true;
        }
        return false;
    }

    public String toString() {
        String preScaleState = "PRESCALE type=" + this.prescaleType.toUpperCase() + ", inFile:" + this.inFile + ", plot data coming from:" + this.inFileAfterPrescale + ", waiting to open in/out file:" + this.needWaitToOpenOutInFile;
        if (this.prescalerExternal) {
            preScaleState = preScaleState + "\n      Selected external prescaling ... are conditions met to proceed:" + this.externalPrescale + " scaleTable=" + this.scaleTable;
        }
        if (this.preferKeyword) {
            int startOfKeyword = this.prescalerKeywordSwitch.indexOf(61) + 1;
            preScaleState = preScaleState + (this.runPrescaleCommand ? "\n      Unsuccessful in " : "\n      Successful in ");
            preScaleState = preScaleState + "basing scaling on keyword:" + this.prescalerKeywordSwitch.substring(startOfKeyword) + "\nextheader keywords:\n" + this.extHeaderKeywords;
        }
        if (this.runPrescaleCommand) {
            if (!this.preferKeyword) {
                preScaleState = preScaleState + "\n";
            }
            preScaleState = preScaleState + "      Launching prescale cmd, processing " + this.percent + " percent of file, in/out file:" + this.prescalarOut + ", with prescaler instance:\n        " + this.plotPrescaler;
        }
        return preScaleState;
    }

    public void setQualifiers(Table qualifiers) {
        this.quals = qualifiers;
    }

    public void setScaleTable(Table scaleTable) {
        this.scaleTable = scaleTable;
    }

    public boolean needsScaleTable() {
        return this.needScaleTable;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

