/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import nxm.sys.inc.Commandable;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Args;
import nxm.sys.lib.Command;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasThread;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libg.MidasDisplay;

public class MidasBean
implements MessageHandler,
Runnable,
Commandable {
    private static final double SLEEP_INTERVAL = 0.1;
    private Command cmd;
    private int state;
    private MidasDisplay panel;
    private String id;
    private Midas midas;
    private String command;
    private double cmdOpenTimeout;
    private double cmdCloseTimeout;
    private Thread thread;

    public MidasBean(Midas midas, String command, MidasDisplay panel2, String id) {
        this.midas = midas;
        this.command = command;
        this.state = 0;
        this.panel = panel2;
        this.id = id == null ? null : id.toUpperCase();
        Args args = Args.parseCommand(midas, command);
        int cmdLgth = args.getName().length();
        if (panel2 != null && id == null) {
            midas.warning("MidasBean: Creating a graphical MidasBean but given a null ID.");
        } else if (id != null) {
            if (args.isPresent("/ID")) {
                if (!args.getS("/ID").equalsIgnoreCase(id)) {
                    midas.warning("MidasBean: ID of command '" + command + "' does not match '" + id + "'.");
                }
            } else {
                this.command = this.command.substring(0, cmdLgth) + "/ID=" + this.id + this.command.substring(cmdLgth);
            }
        }
        if (!args.isPresent("/BG")) {
            this.command = this.command.substring(0, cmdLgth) + "/BG" + this.command.substring(cmdLgth);
        }
        this.cmdOpenTimeout = args.getD("/CMDOPENTIMEOUT", -1.0);
        this.cmdCloseTimeout = args.getD("/CMDCLOSETIMEOUT", 1.0);
    }

    public static MidasBean createBean(Midas midas, String command) {
        return MidasBean.createBean(midas, command, null, null);
    }

    public static MidasBean createBean(Midas midas, String command, MidasDisplay panel2, String id) {
        MidasBean bean = new MidasBean(midas, command, panel2, id);
        bean.start();
        int numLoops = Integer.MAX_VALUE;
        if (bean.cmdOpenTimeout >= 0.0) {
            numLoops = (int)(bean.cmdOpenTimeout / 0.1);
        }
        while (bean.getState() == 0 && numLoops-- > 0) {
            Time.sleep(0.1);
        }
        return bean;
    }

    public synchronized MidasDisplay getPanel() {
        return this.panel;
    }

    public final synchronized int getState() {
        return this.state;
    }

    @Override
    public int open() {
        Table win = (Table)this.midas.registry.get("WIN");
        if (win == null) {
            win = new Table();
            this.midas.registry.put("WIN", win);
        }
        win.put(this.id, (Object)this.panel);
        this.cmd = Shell.runCommand(this.midas, this.command);
        if (this.cmd != null && this.thread != null) {
            String currentName = this.thread.getName();
            this.thread.setName(currentName + "-" + this.cmd.getName());
        }
        this.state = 2;
        return 0;
    }

    @Override
    public int process() {
        if (this.cmd != null && this.cmd.state != 4) {
            return -1;
        }
        return 9;
    }

    synchronized void closeCommand() {
        if (this.cmd != null && this.cmd.MQ != null) {
            Object winPanel4Cmd;
            Object objInRegistry;
            this.cmd.setState("FINISH");
            int numLoops = this.cmdCloseTimeout < 0.0 ? Integer.MAX_VALUE : (int)(this.cmdCloseTimeout / 0.1);
            for (int ii = 0; ii < numLoops && this.cmd.state != 4; ++ii) {
                Time.sleep(0.1);
            }
            if (this.cmd.state != 4) {
                this.midas.warning("Command still not DONE, so closing directly: " + this.cmd);
                this.cmd.close();
            }
            if ((objInRegistry = this.midas.registry.get(this.cmd.id)) != null) {
                this.midas.warning("Command is still in registry, removing: " + this.cmd.id);
                this.midas.registry.remove(this.cmd.id);
            }
            if ((winPanel4Cmd = this.midas.registry.get("WIN." + this.id)) != null && winPanel4Cmd == this.panel) {
                this.midas.registry.remove("WIN." + this.id);
            }
        }
        this.cmd = null;
    }

    @Override
    public int close() {
        this.closeCommand();
        return 0;
    }

    @Override
    public final void run() {
        int status = 0;
        status = this.open();
        this.state = 2;
        while (status != 9) {
            if (status == -1) {
                Time.sleep(0.1);
            }
            status = this.process();
        }
        this.state = 3;
        status = this.close();
        this.state = 4;
    }

    public final MidasBean start() {
        String threadName = "MidasBean-" + (this.id == null ? Integer.valueOf(MidasThread.nextThreadNum()) : this.id);
        this.thread = new MidasThread(this.midas, (Runnable)this, threadName);
        this.thread.start();
        return this;
    }

    public final synchronized Command getCommand() {
        return this.cmd;
    }

    public synchronized MessageHandler getMessageHandler() {
        return this.getCommand();
    }

    @Override
    public int processMessage(Message msg) {
        if (this.getMessageHandler() != null) {
            return this.getMessageHandler().processMessage(msg);
        }
        return 0;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "MidasBean: " + this.cmd + " ID=" + this.id;
    }
}

