/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Command;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Registry;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.libg.ExportImage;
import nxm.sys.libg.GDialog;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPanel;
import nxm.sys.libg.GPrimitive;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.GraphicsUtil;
import nxm.sys.libg.HelpKeyListener;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MFrame;
import nxm.sys.libg.MJFrame;
import nxm.sys.libg.MJPanel;
import nxm.sys.libg.MJText;
import nxm.sys.libg.MPanel;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.MidasDisplay;
import nxm.sys.libg.MidasFrame;
import nxm.sys.libg.Symbol;
import nxm.sys.libg.Theme;
import nxm.sys.prim.panel;

public class MWindow
implements MessageHandler,
Keyable,
MouseListener,
MouseMotionListener,
KeyListener,
ComponentListener,
FocusListener {
    private static final boolean DEBUG = false;
    protected static final int MINIMUM_PANEL_HEIGHT = 1;
    protected static final int MINIMUM_PANEL_WIDTH = 1;
    public static final String cursorList = "Custom,Default,Crosshair,Text,Wait,SWResize,SEResize,NWResize,NEResize,NResize,SResize,WResize,EResize,Hand,Move";
    private Timer cursorTimer = null;
    public static final String themeList = "DeskTop,Default,WoB,GoB,BoW,MnM,Browser,Gear1,Gear2,Gear3,Gear4,Nak";
    public static final int LEFT_MOUSE_BUTTON = 1;
    public static final int MIDDLE_MOUSE_BUTTON = 2;
    public static final int RIGHT_MOUSE_BUTTON = 3;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int BOLD = 4;
    public static final int HILIT = 8;
    public static final int LOLIT = 16;
    public static final int MAXIM = 2;
    public static final int FRONT = 1;
    public static final int BACK = 0;
    public static final int ICON = -1;
    public static final int INIT = -2;
    public static final int EXIT = -3;
    public static final String stateList = "Exit,Init,Icon,Back,Front,Maximized";
    public static final int NOMOUSE = 1;
    public static final int NOKEY = 2;
    public static final int NOICON = 4;
    public static final int NOMOVE = 8;
    public static final int NOREFRESH = 16;
    public static final int NOPUSHPOP = 32;
    public static final int NOMIDDLEMOUSE = 64;
    public static final String eventFilterList = "NoMouse,NoKeyBoard,NoIconify,NoMove,NoRefresh,NoPushPop,NoMiddleMouse";
    @InternalUseOnly
    public static final int ADD_AWT_TO_SWING = 1;
    @InternalUseOnly
    public static final int OVERRIDING_EXISTING_PLOT_OPTIONS = 2;
    @InternalUseOnly
    public static final String warningsList = "AddAWTToSwing,OverridingExistingPlotOptions";
    boolean isMidasDisplayWithSwingPopups = false;
    @InternalUseOnly
    public int eventFilter;
    @InternalUseOnly(value="since 3.5.2")
    public String name;
    private String userDisplay = null;
    @InternalUseOnly(value="since 3.5.2")
    public Object parent;
    @InternalUseOnly(value="since 3.5.2")
    public Object pushParent;
    @InternalUseOnly(value="since 3.5.2")
    public MWindow MW;
    protected String title;
    @InternalUseOnly(value="since 3.5.2")
    public MessageHandler mh;
    private String embeddedCommandID;
    @InternalUseOnly(value="since 3.5.2")
    public Container panel;
    @Deprecated
    public Graphics g;
    @InternalUseOnly(value="since 3.5.2")
    public Font font;
    @InternalUseOnly(value="since 3.5.2")
    public FontMetrics fm;
    @InternalUseOnly(value="since 3.5.2")
    public boolean headless;
    private volatile boolean isPoppedOut = false;
    @InternalUseOnly(value="since 3.5.2")
    public boolean useSwing = Theme.getOption(4) || Theme.getOption(16);
    protected boolean isPopup;
    private Rectangle popBounds = null;
    private GraphicsDevice popDev = null;
    private boolean enableAdvancedPopOut = true;
    @InternalUseOnly(value="since 3.5.2")
    public static final MBox DEFAULT_WINDOW_POSITION = new MBox(100, 100, 700, 500);
    @InternalUseOnly(value="since 3.5.2")
    public MBox pos = new MBox(DEFAULT_WINDOW_POSITION);
    @InternalUseOnly(value="since 3.5.2")
    public int px;
    @InternalUseOnly(value="since 3.5.2")
    public int py;
    @InternalUseOnly(value="since 3.5.2")
    public int pz;
    @InternalUseOnly(value="since 3.5.2")
    public boolean pactive;
    @InternalUseOnly(value="since 3.5.2")
    public boolean hasFocus;
    protected MBox box = new MBox(-1, -1, 0, 0);
    protected MBox rbox = new MBox(0, 0, 0, 0);
    protected int dragging = 0;
    @InternalUseOnly(value="since 3.5.2")
    public Theme theme = (Theme)Theme.global();
    @InternalUseOnly(value="since 3.5.2")
    public int status;
    @InternalUseOnly(value="since 3.5.2")
    public int button;
    @InternalUseOnly(value="since 3.5.2")
    public int modifiers;
    @InternalUseOnly(value="since 3.5.2")
    public int keycode;
    @InternalUseOnly(value="since 3.5.2")
    public long dtime;
    @InternalUseOnly(value="since 3.5.2")
    public long htime;
    @InternalUseOnly(value="since 3.5.2")
    public HelpKeyListener hkl;
    @Deprecated
    Rectangle clip;
    private Cursor cursor = null;
    protected boolean isScrolling;
    protected Color crossHairsColor;
    private Point press;
    private boolean shareTheme;
    private boolean noAltTitle;
    static final int SCROLL_KNOB_SIZE = 16;
    static int warningsMask = 0;
    public static final int SB_DEF = 0;
    public static final int SB_HILIT = 1;
    public static final int SB_CHKBOX = 2;
    public static final int SB_ALERT = 3;
    public static final int SB_ADJUST = 4;
    public static final int SB_UNHILIT = -1;
    public static final int SB_FLAT = -2;
    public static final int SB_REV = -3;
    public static final int SB_LINE = -4;
    public static final int SB_SHADE = -5;
    public static final int SB_FLAT_SHADE = -6;
    public static final int SB_SHADEX = -7;
    public static final int SB_HAIRLINE = -8;
    public static final int SB_SHADE_PUSHPOP = -9;
    public static final int SB_SEPERATOR = 0;
    public static final int SLIDER_ACTIVE = 1;
    public static final int SLIDER_NOTRACK = 2;
    public static final int SLIDER_INSET = 4;
    private static String[] keys = new String[]{"POS", "PARENT", "THEME", "TITLE"};

    public MWindow() {
        this(null, null, null);
    }

    public MWindow(String name, MessageHandler mh) {
        this(name, mh, null);
    }

    public MWindow(String name, MessageHandler mh, Object parent) {
        this.crossHairsColor = this.theme.cbg;
        this.press = null;
        this.shareTheme = false;
        this.noAltTitle = false;
        this.isPopup = parent instanceof MWindow;
        if (this.isPopup) {
            this.theme = ((MWindow)parent).theme;
        }
        this.useSwing = Theme.getOption(4);
        if (this instanceof GWidget) {
            this.useSwing &= Theme.getOption(this.isPopup ? 128 : 64);
        }
        if (Theme.getOption(16)) {
            this.useSwing = true;
        }
        this.status = -2;
        this.hkl = new HelpKeyListener(this);
        if (Theme.isHeadless()) {
            boolean userSpecHeadless;
            this.headless = true;
            boolean headlessSwitch = false;
            if (mh instanceof Command) {
                this.embeddedCommandID = ((Command)mh).getID();
                headlessSwitch = ((Command)mh).args.getState("/HEADLESS");
            }
            boolean bl = userSpecHeadless = headlessSwitch || Theme.getOption(1);
            if (!userSpecHeadless && Theme.getHeadlessInitStatus() != 0) {
                String warningText = "/HEADLESS not set on a headless system. Error Code: " + Theme.getHeadlessInitStatus();
                HeadlessException headlessEx = new HeadlessException(warningText);
                throw headlessEx;
            }
            MJPanel mpanel = new MJPanel();
            mpanel.setMWindow(this);
            this.panel = mpanel;
        } else if (this.useSwing) {
            MJPanel mpanel = new MJPanel();
            mpanel.setMWindow(this);
            this.panel = mpanel;
        } else {
            MPanel mpanel = new MPanel();
            mpanel.setMWindow(this);
            this.panel = mpanel;
        }
        this.title = name;
        this.name = name;
        this.mh = mh;
    }

    public void open() {
        if (this.headless || Shell.isHeadless()) {
            return;
        }
        this.font = new Font("Monospaced", 0, 12);
        this.fm = this.panel.getFontMetrics(this.font);
    }

    public void setHeadless(boolean value) {
        this.headless = value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHandler(MessageHandler mh) {
        this.mh = mh;
    }

    public boolean setToolTipText(String text) {
        if (this.panel instanceof JPanel) {
            ((JComponent)this.panel).setToolTipText(text);
            return true;
        }
        return false;
    }

    public String getToolTipText() {
        if (this.panel instanceof JPanel) {
            return ((JPanel)this.panel).getToolTipText();
        }
        return null;
    }

    public void setBounds(MBox mb) {
        if (mb != null) {
            this.setBounds(mb.x, mb.y, mb.w, mb.h);
        } else {
            Shell.warning("Cannot set bounds from a null MBox");
        }
    }

    public void setSize(int w, int h) {
        this.pos.w = w;
        this.pos.h = h;
        if (this.MW != null && this.panel != null) {
            this.panel.setSize(w, h);
        }
        if (this.parent instanceof Frame) {
            ((Frame)this.parent).setSize(w, h);
        }
    }

    public void setLocation(int x, int y) {
        this.pos.x = x;
        this.pos.y = y;
        if (this.MW != null && this.panel != null) {
            this.panel.setLocation(x, y);
        }
        if (this.parent instanceof Frame) {
            ((Frame)this.parent).setLocation(x, y);
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        if (this.parent instanceof GDialog) {
            this.setBoundsLater(x, y, w, h);
        } else {
            this.setBoundsWait(x, y, w, h);
        }
    }

    private void setBoundsWait(int x, int y, int w, int h) {
        this.pos.x = x;
        this.pos.y = y;
        this.pos.w = w;
        this.pos.h = h;
        if (this.MW != null) {
            GraphicsUtil.invokeAndWait(() -> {
                if (this.panel != null) {
                    this.panel.setBounds(x, y, w, h);
                }
                if (this.parent instanceof Frame) {
                    ((Component)this.parent).setBounds(x, y, w, h);
                }
            });
        } else if (this.parent instanceof Frame) {
            GraphicsUtil.invokeAndWait(() -> ((Component)this.parent).setBounds(x, y, w, h));
        }
    }

    private void setBoundsLater(int x, int y, int w, int h) {
        this.pos.x = x;
        this.pos.y = y;
        this.pos.w = w;
        this.pos.h = h;
        if (this.MW != null) {
            GraphicsUtil.invokeLater(() -> {
                if (this.panel != null) {
                    this.panel.setBounds(x, y, w, h);
                }
                if (this.parent instanceof Frame) {
                    ((Component)this.parent).setBounds(x, y, w, h);
                }
            });
        } else if (this.parent instanceof Frame) {
            GraphicsUtil.invokeLater(() -> ((Component)this.parent).setBounds(x, y, w, h));
        }
    }

    public void setTheme(String themeName, boolean inline) {
        this.theme.setInline(inline);
        this.setTheme(themeName);
    }

    public void setTheme(Object themeObj, boolean inline) {
        this.theme.setInline(inline);
        if (themeObj instanceof Theme) {
            this.setTheme((Theme)themeObj);
        } else if (themeObj instanceof Table) {
            this.setTheme((Table)themeObj);
        } else if (themeObj instanceof String) {
            this.setTheme((String)themeObj);
        }
    }

    public void setTheme(String themeName) {
        if (themeName == null || themeName.length() == 0) {
            return;
        }
        this.theme.setByName(themeName);
        if (themeName.startsWith("MNM")) {
            Theme.setOptions("+MOBILE");
        }
        this.resetTheme(this.theme);
    }

    public void setTheme(Object obj) {
        if (obj instanceof String) {
            this.setTheme((String)obj);
        }
        if (!(obj instanceof Table)) {
            return;
        }
        Table themeTable = (Table)obj;
        if (themeTable == null || themeTable.getSize() == 0) {
            return;
        }
        this.theme.createTheme(themeTable);
        this.resetTheme(this.theme);
    }

    private void resetTheme(Theme theme) {
        this.setTheme(theme);
        if (this.status >= 1) {
            this.panel.repaint();
        }
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
        if (!this.headless && this.panel != null) {
            this.panel.setBackground(theme.cbg);
            this.panel.setForeground(theme.cfg);
        }
    }

    public void setEventFilter(String mask) {
        int ef = 0;
        ef = mask.equals("ENABLE") ? 0 : (mask.equals("DISABLE") ? -1 : Parser.mask(eventFilterList, mask, this.eventFilter));
        this.setEventFilter(ef);
    }

    public void setEventFilter(int mask) {
        this.eventFilter = mask;
    }

    public void setup() {
    }

    public void addOn(Component comp) {
        this.addOn(comp, 0);
    }

    public void moveDisplay(String disp) {
        this.userDisplay = disp;
        Shell.info("Moving display to " + this.userDisplay);
    }

    public void addOn(Component comp, int index) {
        MWindow.addOn(this.panel, comp, index);
    }

    public static void addOn(Container cont, Component comp) {
        MWindow.addOn(cont, comp, 0);
    }

    public static void addOn(Container parent, Component child, int index) {
        JLayeredPane jlp = Theme.getOption(16) ? null : MWindow.findLayeredPane(parent, child);
        GraphicsUtil.invokeAndWait(() -> MWindow.addComp(parent, child, index, jlp));
        MWindow.pullGAlertToFront(child.getParent());
    }

    private static void addComp(Container parent, Component child, int index, JLayeredPane jlp) {
        if (jlp != null) {
            if (jlp.isOptimizedDrawingEnabled() && child instanceof MJPanel) {
                MWindow mwlocal = ((MJPanel)child).getMWindow();
                MJPanel ch2 = new MJPanel();
                ch2.setBounds(child.getBounds());
                ch2.MW = mwlocal;
                jlp.add(ch2);
                jlp.add(child, (Object)index);
                jlp.moveToFront(child);
                jlp.remove(ch2);
            } else {
                jlp.add(child, (Object)index);
                jlp.moveToFront(child);
            }
        } else {
            if ((warningsMask & 1) != 0 && !Theme.getOption(8) && child instanceof MPanel && parent instanceof MJPanel) {
                String message = "MWindow - Putting AWT component on top of Swing component may cause graphical lock-up or slugglishness\n\tparent=" + parent.getClass() + "\n\tchild=" + child.getClass();
                Shell.getMidasContext().warning(message);
            }
            parent.add(child, index);
        }
        child.validate();
        child.repaint();
    }

    private static JLayeredPane findLayeredPane(Container parent, Component child) {
        boolean findLayeredPane;
        if (parent instanceof JLayeredPane) {
            return (JLayeredPane)parent;
        }
        if (!Theme.getOption(128) && !Theme.getOption(16)) {
            return null;
        }
        if (parent instanceof MJPanel && ((MJPanel)parent).MW.isPoppedOut) {
            return null;
        }
        boolean bl = findLayeredPane = parent instanceof JPanel && !(parent.getParent() instanceof JLayeredPane) && !(parent.getParent() instanceof MidasDisplay) && ((JPanel)parent).getRootPane() != null;
        if (parent instanceof MidasDisplay && findLayeredPane && child instanceof JPanel) {
            return ((JPanel)parent).getRootPane().getLayeredPane();
        }
        if (findLayeredPane) {
            return ((JPanel)parent).getRootPane().getLayeredPane();
        }
        return null;
    }

    public static String getMWName(Component comp) {
        String name = "";
        if (comp instanceof MJPanel) {
            name = ((MJPanel)comp).MW.name;
        } else if (comp instanceof MPanel) {
            name = ((MPanel)comp).MW.name;
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    public String getEmbeddedCommandID() {
        return this.embeddedCommandID;
    }

    public static void pullGAlertToFront(Container cont) {
        for (int index = 0; index < cont.getComponentCount(); ++index) {
            String name;
            Component comp = cont.getComponent(index);
            if (!(comp instanceof MPanel) && !(comp instanceof MJPanel) || !(name = MWindow.getMWName(comp)).equalsIgnoreCase("GALERT")) continue;
            cont.add(comp, 0);
        }
    }

    public void addTo(Object entry) {
        this.addTo(entry, null);
    }

    public void addTo(Object entry, GraphicsDevice dev) {
        String window;
        boolean hasTitle = false;
        String display2 = null;
        int initState = 1;
        if (entry instanceof Command) {
            Data wpos;
            Command cmd = (Command)entry;
            this.embeddedCommandID = cmd.getID();
            int wfs = cmd.args.getL("/WFS");
            if (wfs > 0) {
                this.setFontSize(wfs);
            }
            if ((wpos = cmd.args.getData("/WPOS")) != null) {
                int[] wp = new int[4];
                wpos.toArray(wp);
                if (wpos.spa >= 4) {
                    this.setBounds(wp[0], wp[1], wp[2], wp[3]);
                } else if (wpos.spa >= 2) {
                    this.setLocation(wp[0], wp[1]);
                }
                this.resize(1);
            }
            if (!(this instanceof GWidget)) {
                this.title = cmd.args.getS("/WTITLE", this.name);
            }
            this.noAltTitle = cmd.args.getState("/NOALTTITLE", this.noAltTitle);
            display2 = cmd.args.getCS("/WDISP", display2);
            if (cmd.args.getState("/NOPUSHPOP")) {
                this.eventFilter |= 0x20;
            }
            if (cmd.args.isPresent("/EVENTFILTER")) {
                this.eventFilter = cmd.args.getOptionMask("/EVENTFILTER", eventFilterList, this.eventFilter);
            }
            this.userDisplay = display2;
            String win = cmd.args.getS("/WIN");
            if (win.length() == 0) {
                win = cmd.args.getS("/WIN." + cmd.id);
            }
            if ((entry = cmd.M.registry.get("WIN." + cmd.id)) == null && cmd.M.macro != null && cmd instanceof panel) {
                String tmpWin;
                entry = ((panel)cmd).getMidasControls();
                Registry parentRegistry = cmd.M.getParent().registry;
                if (entry == null) {
                    entry = parentRegistry.get("WIN." + cmd.M.macro.id);
                }
                if (entry == null && win.length() > 0 && win.indexOf(46) > 0) {
                    tmpWin = win.substring(0, win.indexOf(46));
                    entry = parentRegistry.get(tmpWin + "." + cmd.M.macro.id);
                }
                if (entry == null && win.indexOf(46) < 0 && parentRegistry.get("WIN") != null && !(tmpWin = "WIN." + win).equals("WIN.NEW")) {
                    entry = parentRegistry.get(tmpWin);
                }
            }
            if (win.length() > 0 && entry == null) {
                if (win.indexOf(46) < 0 && cmd.M.registry.get("WIN") != null) {
                    win = "WIN." + win;
                }
                if (!win.equals("WIN.NEW")) {
                    entry = cmd.M.registry.get(win, 5);
                }
            }
            if (!(entry instanceof panel) && GPrimitive.isInstance(entry)) {
                entry = GPrimitive.getMWindowViaReflection((Object)entry).MW;
            }
            String themeName = cmd.MR.getS("ENV.THEME");
            Object themeObj = cmd.args.getO("/THEME", themeName);
            if (!cmd.args.getState("/SHARETHEME", this.shareTheme)) {
                this.theme = (Theme)this.theme.copy();
            }
            this.setTheme(themeObj);
            hasTitle = cmd.args.find("/WTITLE");
            if (cmd.args.getState("/ICON")) {
                initState = -1;
            }
            initState = cmd.args.getSelectionIndex("/DISPLAY", stateList, initState, -4);
        } else if (entry instanceof String && (entry = new Registry().get(window = (String)entry, 5)) == null) {
            Shell.warning("Timeout looking for window: " + window);
        }
        this.parent = entry;
        this.addListeners();
        Container panelOrig = this.panel;
        if (this.parent instanceof GPanel) {
            this.MW = (MWindow)this.parent;
            ((GPanel)this.parent).addWindow(this);
        } else if (this.parent instanceof panel) {
            ((panel)this.parent).addWindow(this);
        } else if (this.parent instanceof MWindow) {
            this.MW = (MWindow)this.parent;
            while (this.MW.MW != null && this.MW.MW != this.MW && !this.MW.isPopped() && !Theme.getOption(16)) {
                this.MW.MW.px = this.MW.px + this.MW.pos.x;
                this.MW.MW.py = this.MW.py + this.MW.pos.y;
                this.MW = this.MW.MW;
            }
            if (this instanceof GWidget) {
                this.place(this.pos, this.MW.pos, this.MW.px, this.MW.py);
            }
            this.resize(1);
            if (this instanceof GWidget) {
                MWindow.addOn(this.MW.panel, this.panel, 0);
            } else {
                MWindow.addOn(this.MW.panel, this.panel, -1);
            }
        } else if (this.parent instanceof MFrame) {
            MFrame mframe = (MFrame)this.parent;
            if (this instanceof GWidget) {
                MWindow.addOn(mframe, this.panel);
            } else {
                mframe.setMWindow(this);
                this.panel = mframe;
            }
        } else if (this.parent instanceof MJFrame) {
            MJFrame mframe = (MJFrame)this.parent;
            if (this instanceof GWidget) {
                MWindow.addOn(mframe, this.panel);
            } else {
                mframe.setMWindow(this);
                this.panel = mframe;
            }
        } else if (this.parent instanceof panel.Pane) {
            panel.Pane pane = (panel.Pane)this.parent;
            if (hasTitle) {
                pane.setTitle(this.title);
            }
            this.MW = pane.MW;
            pane.add(this);
        } else if (this.parent instanceof MidasDisplay) {
            this.crossHairsColor = Color.white;
            MidasDisplay md = (MidasDisplay)this.parent;
            md.add(this);
        } else if (this.parent instanceof MPanel) {
            MPanel mpanel = (MPanel)this.parent;
            if (this instanceof GWidget) {
                MWindow.addOn(mpanel, this.panel);
            } else {
                mpanel.setMWindow(this);
                this.panel = mpanel;
            }
        } else if (this.parent instanceof MJPanel) {
            MJPanel mpanel = (MJPanel)this.parent;
            if (this instanceof GWidget) {
                MWindow.addOn(mpanel, this.panel);
            } else {
                mpanel.setMWindow(this);
                this.panel = mpanel;
            }
        } else if (!Shell.isHeadless()) {
            Frame frame;
            Frame mframe;
            if (this.parent != null) {
                Shell.warning("Could not use window: " + this.parent + ", " + this.parent.getClass() + ".  Creating new frame");
            }
            if (this.userDisplay != null) {
                display2 = this.userDisplay;
            }
            if (this.useSwing) {
                mframe = dev == null ? new MJFrame(this.name, this.pos, display2) : new MJFrame(this.name, this.pos, dev.getDefaultConfiguration());
                ((MJFrame)mframe).setMWindow(this);
                frame = mframe;
                this.parent = frame;
            } else {
                mframe = new MFrame(this.name, this.pos, display2);
                ((MFrame)mframe).setMWindow(this);
                frame = mframe;
                this.parent = frame;
            }
            frame.setUndecorated(this instanceof GWidget);
            frame.setVisible(true);
            frame.setTitle(this.title);
            if (frame instanceof JFrame) {
                ((JFrame)frame).getContentPane().add(this.panel);
            } else {
                frame.add((Component)this.panel, "Center");
            }
        }
        if (this.panel != panelOrig) {
            this.addListeners();
        }
        if (this.panel != null) {
            this.panel.setFont(this.font);
            if (this.parent instanceof MidasDisplay) {
                Dimension d = this.panel.getSize();
                if (d.width > 10 && d.height > 10) {
                    this.pos.x = this.panel.getLocation().x;
                    this.pos.y = this.panel.getLocation().y;
                    this.pos.w = d.width;
                    this.pos.h = d.height;
                }
            }
        }
        if (!(this.parent instanceof Frame)) {
            initState = 1;
        }
        this.display(initState);
    }

    public void setDoubleBuffered(boolean value) {
        if (this.panel instanceof JPanel) {
            RepaintManager.currentManager(this.panel).setDoubleBufferingEnabled(value);
        } else {
            Shell.warning("Cannot set double buffering on a non-SWING panel");
        }
    }

    public boolean isDoubleBuffered() {
        if (this.panel instanceof JPanel) {
            return RepaintManager.currentManager(this.panel).isDoubleBufferingEnabled();
        }
        return false;
    }

    protected void addListeners() {
        this.removeListeners();
        if (this.panel != null) {
            this.panel.addMouseListener(this);
            this.panel.addMouseMotionListener(this);
            this.panel.addComponentListener(this);
            this.panel.addFocusListener(this);
            this.panel.addKeyListener(this);
            if (this.parent instanceof Frame) {
                this.panel.addKeyListener(this.hkl);
            }
        }
    }

    protected void removeListeners() {
        if (this.panel != null) {
            this.panel.removeMouseListener(this);
            this.panel.removeMouseMotionListener(this);
            this.panel.removeComponentListener(this);
            this.panel.removeFocusListener(this);
            this.panel.removeKeyListener(this);
            if (this.parent instanceof Frame) {
                this.panel.removeKeyListener(this.hkl);
            }
        }
    }

    protected void removeHelpKeyListeners() {
        if (this.panel != null) {
            Component[] comps;
            for (Component comp : comps = this.panel.getComponents()) {
                comp.removeKeyListener(this.hkl);
            }
        }
    }

    public boolean setDisplay(String str) {
        if (str.startsWith("DEIC")) {
            str = "FRON";
        } else if (str.length() > 4) {
            str = str.substring(0, 4);
        }
        int mode = Parser.find(stateList, str, -9, -4);
        if (mode == -9) {
            return false;
        }
        this.display(mode);
        return true;
    }

    public String getDisplay() {
        return this.getDisplay(this.status);
    }

    private String getDisplay(int status) {
        return Parser.get(stateList, status, -4);
    }

    public void display(int mode) {
        if (MidasFrame.isMidasFrame(this.parent)) {
            MidasFrame.midasFrameDisplayViaReflection(this.parent, mode);
        } else if (this.parent instanceof panel.Pane) {
            panel.Pane pane = (panel.Pane)this.parent;
            if (pane.isInTab()) {
                switch (mode) {
                    case 1: 
                    case 2: {
                        pane.makeVisibleTab();
                        break;
                    }
                    case -3: 
                    case -2: 
                    case -1: 
                    case 0: {
                        Shell.warning("MWindow: Can not set display mode to: " + this.getDisplay(mode) + " for " + this + " on " + pane);
                        break;
                    }
                    default: {
                        throw new RuntimeException("MWindow: Unknown display mode (" + mode + ").");
                    }
                }
            }
        } else if (mode == this.status) {
            return;
        }
        if (this.panel != null) {
            this.panel.setVisible(mode >= 0);
        }
        if (this.status != -2) {
            this.status = mode;
        }
        if (this.status == 2) {
            this.status = 1;
        }
    }

    @Deprecated
    public void print() {
        this.panel.print(this.g);
    }

    private void closeWindow() {
        this.status = -3;
        this.removeLayeredPaneComp();
        this.removeListeners();
        this.removeHelpKeyListeners();
        if (this.MW != null && this.MW.panel != null) {
            this.MW.panel.remove(this.panel);
            if (this instanceof GWidget) {
                this.MW.panel.repaint(this.pos.x, this.pos.y, this.pos.w, this.pos.h);
            }
        }
        if (this.parent != null) {
            if (this.parent instanceof Container) {
                ((Container)this.parent).remove(this.panel);
            }
            if (this.parent instanceof panel.Pane) {
                ((panel.Pane)this.parent).remove(this.panel);
            }
            if (this.parent instanceof MFrame) {
                ((MFrame)this.parent).dispose();
            }
            if (this.parent instanceof MJFrame) {
                ((MJFrame)this.parent).dispose();
            }
        }
    }

    public void close() {
        if (!Shell.isHeadless()) {
            GraphicsUtil.invokeAndWait(() -> this.close0());
        }
    }

    private void close0() {
        this.closeWindow();
        if (this.panel instanceof MPanel) {
            this.panel.removeAll();
            ((MPanel)this.panel).MW = null;
        }
        if (this.panel instanceof MJPanel) {
            this.panel.removeAll();
            ((MJPanel)this.panel).MW = null;
        }
        this.MW = null;
        this.fm = null;
        this.font = null;
        this.mh = null;
        this.panel = null;
        this.parent = null;
        this.pushParent = null;
    }

    private void removeLayeredPaneComp() {
        if (this.panel != null && this.panel.getParent() != null) {
            if (this.panel.getParent() instanceof JLayeredPane) {
                JLayeredPane jlp = (JLayeredPane)this.panel.getParent();
                if (this.panel != null) {
                    try {
                        jlp.remove(this.panel);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                jlp.repaint(this.pos.x, this.pos.y, this.pos.w, this.pos.h);
            }
        } else if (this.parent instanceof MWindow && ((MWindow)this.parent).panel != null) {
            ((MWindow)this.parent).refresh(this.pos);
        }
    }

    public int process(String name, int info) {
        return this.process(name, info, null);
    }

    public int process(String name, int info, Object data) {
        return this.process(name, info, data, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int process(String name, int info, Object data, MouseEvent e) {
        if (this.status == -2 || this.status == 0) {
            if (this.isPanelVisible()) {
                if (this.parent instanceof Frame) {
                    this.getFocus();
                }
                this.status = 1;
            } else {
                this.status = 0;
            }
        } else if (this.status == -2 && "PAINT".equals(name)) {
            if (this.parent instanceof Frame) {
                this.getFocus();
            }
            this.status = 1;
        } else if (this.pushParent != null && "WINDOW".equals(name) && "CLOSING".equals(data)) {
            if ((this.eventFilter & 0x20) != 0) return 1;
            name = "POP";
            info = -1;
        } else if ("WINDOW".equals(name)) {
            if (this.status != 1 && "DEICONIFIED".equals(data)) {
                this.display(1);
            } else if (this.status != -1 && "ICON".equals(data)) {
                this.display(-1);
            }
        }
        int stat = this instanceof MPlot ? this.preprocess(name, info, data, e) : this.preprocess(name, info, data);
        if (stat > 0) return stat;
        if (this.mh == null) return stat;
        Message msg = new Message(name, info, data, this.mh, this);
        return this.mh.processMessage(msg);
    }

    public int preprocess(String name, int info, Object data) {
        return -1;
    }

    public int preprocess(String name, int info, Object data, MouseEvent e) {
        return this.preprocess(name, info, data);
    }

    @Override
    public int processMessage(Message msg) {
        switch (msg.name) {
            case "POP": {
                Table devt = null;
                if (msg.quals != null && msg.quals instanceof Table) {
                    devt = (Table)msg.quals;
                }
                if (devt != null && devt.containsKey("DISP")) {
                    int winNo = Math.max(0, devt.getL("DISP"));
                    if (devt.containsKey("BOUNDS")) {
                        Table b = devt.getTable("BOUNDS");
                        this.setPopBounds(b.getL("X"), b.getL("Y"), b.getL("W"), b.getL("H"));
                    }
                    this.setPopWindow(winNo);
                    this.pop(msg.info, this.popDev);
                } else {
                    this.pop(msg.info);
                }
                return 1;
            }
            case "POPMENU": {
                String devstring = (String)msg.data;
                int winNo = Math.max(0, Integer.parseInt(devstring.substring(devstring.length() - 1)));
                this.setPopWindow(winNo);
                this.pop(msg.info, this.popDev);
                return 1;
            }
            case "DISPLAY": {
                if (msg.data == null) {
                    this.display(msg.info);
                } else {
                    this.setDisplay((String)msg.data);
                }
                return 1;
            }
        }
        return -1;
    }

    public void setEnableAdvancedPopOut(boolean val) {
        this.enableAdvancedPopOut = val;
    }

    public boolean getEnableAdvancedPopOut() {
        return this.enableAdvancedPopOut;
    }

    public boolean isPopped() {
        return this.pushParent != null;
    }

    public boolean pop(int mode) {
        return this.pop(mode, false);
    }

    public boolean pop(int mode, boolean showPopMenu) {
        if (!this.isPopped() && showPopMenu && this.enableAdvancedPopOut) {
            String swins = "";
            String prepend = "";
            int numScrs = GraphicsUtil.getNumScreens(false);
            int xx = 0;
            while (xx < numScrs) {
                if (xx > 0) {
                    prepend = ",";
                }
                swins = swins + prepend + "Win_" + ++xx;
            }
            new GMenu(this, "POPMENU", swins, 0, 0, this);
            return true;
        }
        if (!this.isPopped() && this.popDev != null) {
            return this.pop(mode, this.popDev);
        }
        return this.pop(mode, null);
    }

    public boolean pop(int mode, GraphicsDevice dev) {
        if (mode == -1) {
            int n = mode = this.pushParent == null ? 1 : 0;
        }
        if (this.pushParent == null && mode == 0) {
            return false;
        }
        if (this.pushParent != null && mode == 1) {
            return false;
        }
        GraphicsUtil.invokeAndWait(() -> {
            this.pushParent = this.reParent(this.pushParent, dev, true);
        });
        return true;
    }

    public boolean reParent(Object parent) {
        this.reParent(parent, null, false);
        return true;
    }

    private Object reParent(Object newParent, GraphicsDevice dev, boolean pushPop) {
        GPanel gpan;
        Component root;
        Component cp;
        Object curParent = this.parent;
        this.isPoppedOut = newParent == null;
        Component pp = newParent instanceof Component ? (Component)newParent : null;
        Component component = cp = curParent instanceof Component ? (Component)curParent : null;
        if (this.isPoppedOut) {
            if (pushPop && this.popBounds != null) {
                this.pos.setBounds(this.popBounds);
            } else {
                this.pos.setBounds(100, 100, 700, 500);
            }
        } else if (pushPop && cp != null && (root = SwingUtilities.getRoot(cp)) instanceof JFrame) {
            JFrame jf = (JFrame)root;
            Point loc = cp.getLocation();
            Dimension dim = jf.getContentPane().getSize();
            Insets ins = jf.getInsets();
            this.popBounds = new Rectangle(loc.x + ins.left, loc.y + ins.top, dim.width, dim.height);
        }
        GPanel gPanel = curParent instanceof GPanel ? (GPanel)curParent : (gpan = newParent instanceof GPanel ? (GPanel)newParent : null);
        if (gpan != null) {
            gpan.updateSize(this.isPoppedOut);
        }
        this.closeWindow();
        this.addTo(newParent, dev);
        if (this.useSwing) {
            if (this.panel != null) {
                this.panel.revalidate();
            }
            if (pp != null) {
                pp.revalidate();
            }
            if (cp != null) {
                cp.revalidate();
            }
            if (this.MW != null && this.MW.panel != null) {
                this.MW.panel.revalidate();
            }
            if (this.panel != null) {
                this.panel.repaint();
            }
            if (pp != null) {
                pp.repaint();
            }
            if (cp != null) {
                cp.repaint();
            }
            if (this.MW != null && this.MW.panel != null) {
                this.MW.panel.repaint();
            }
        }
        return this.isPoppedOut ? curParent : null;
    }

    public void setPopWindow(int winNo) {
        this.popDev = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[winNo - 1];
    }

    public int getPopWindow() {
        GraphicsDevice[] devs = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        for (int xx = 0; xx < devs.length; ++xx) {
            if (devs[xx] != this.popDev) continue;
            return xx + 1;
        }
        return -1;
    }

    public GraphicsDevice getPopDevice() {
        return this.popDev;
    }

    public void setPopBounds(Rectangle r) {
        if (r.getWidth() == 0.0) {
            r.width = 500;
        }
        if (r.getHeight() == 0.0) {
            r.height = 500;
        }
        this.popBounds = r;
    }

    public void setPopBounds(int x, int y, int width, int height) {
        this.setPopBounds(new Rectangle(x, y, width, height));
    }

    public Rectangle getPopBounds() {
        return this.popBounds;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
        this.process("FOCUS", 1);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
        this.process("FOCUS", -1);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.px = e.getX();
        this.py = e.getY();
        this.process("POINTER", 9);
        this.pactive = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.px = e.getX();
        this.py = e.getY();
        this.process("POINTER", -9);
        this.pactive = false;
    }

    private Point convertPointToScreen(int x, int y, Component c) {
        Point p = new Point(x, y);
        SwingUtilities.convertPointToScreen(p, c);
        return p;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if ((this.eventFilter & 1) != 0) {
            return;
        }
        this.dtime = System.currentTimeMillis();
        this.px = e.getX();
        this.py = e.getY();
        this.press = this.convertPointToScreen(this.px, this.py, this.panel);
        if (this.dragging == 0) {
            this.box.setBounds(this.px, this.py, 0, 0);
        }
        if (this.useSwing && !this.hasFocus) {
            this.getFocus();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if ((this.eventFilter & 1) != 0) {
            return;
        }
        if (this.dragging != 0) {
            this.px = e.getX();
            this.py = e.getY();
            Point abs = this.convertPointToScreen(this.px, this.py, this.panel);
            if (this.press.distance(abs) > 5.0 && !this.isScrolling) {
                this.box.w = this.px - this.box.x;
                this.box.h = this.py - this.box.y;
                if (this instanceof MPlot) {
                    this.process("DRAGBOX", this.dragging, new MBox(this.box), e);
                } else {
                    this.process("DRAGBOX", this.dragging, new MBox(this.box));
                }
                this.dragging = 0;
            } else {
                this.stopScroll();
                this.dragging = 0;
                this.mouseClicked(e);
            }
        }
        this.box.setBounds(-1, -1, 0, 0);
    }

    protected void stopScroll() {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if ((this.eventFilter & 1) != 0) {
            return;
        }
        if (this.dragging == 0) {
            this.px = e.getX();
            this.py = e.getY();
            this.button = this.event2button(e);
            this.htime = System.currentTimeMillis() - this.dtime;
            if (this.htime > 250L && this.button == 3 && !Theme.getOption(16)) {
                this.button = 2;
            }
            if (this.button == 2 && (this.eventFilter & 0x40) != 0) {
                return;
            }
            if (this.htime > 500L && this.button == 1) {
                this.process("HOVER", this.button, e);
            } else {
                this.process("BUTTON", this.button, e);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.px = e.getX();
        this.py = e.getY();
        if (this.MW != null && this.MW != this) {
            this.MW.px = this.pos.x + this.px;
            this.MW.py = this.pos.y + this.py;
        }
        this.process("POINTER", 0);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if ((this.eventFilter & 1) != 0) {
            return;
        }
        if (this.box.x == -1 || this.box.y == -1) {
            return;
        }
        this.px = e.getX();
        this.py = e.getY();
        this.box.w = this.px - this.box.x;
        this.box.h = this.py - this.box.y;
        if (this.dragging == 0) {
            this.dragging = this.event2button(e);
        }
        if (this.dragging != 0 && Point.distance(this.px, this.py, this.box.x, this.box.y) > 5.0) {
            if (this instanceof MPlot) {
                this.process("DRAG", this.dragging, this.box, e);
            } else {
                this.process("DRAG", this.dragging, this.box);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if ((this.eventFilter & 2) != 0) {
            return;
        }
        this.keycode = e.getKeyCode();
        this.modifiers = e.getModifiersEx();
        if (this.keycode == 112) {
            this.helpKeyPressed();
        } else if ((this.modifiers & 0x80) != 0) {
            if (this.keycode == 80 && (this.eventFilter & 0x20) == 0) {
                this.process("POP", -1, null);
            }
        } else {
            this.process("KEYPRESS", this.keycode, KeyEvent.getKeyText(this.keycode));
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if ((this.eventFilter & 2) != 0) {
            return;
        }
        this.keycode = e.getKeyCode();
        this.modifiers = e.getModifiersEx();
        if ((this.modifiers & 0x80) == 0) {
            this.process("KEYRELEASE", this.keycode, KeyEvent.getKeyText(this.keycode));
        }
        this.keycode = 0;
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (this.MW == null) {
            return;
        }
        this.pos.x = this.panel.getLocation().x;
        this.pos.y = this.panel.getLocation().y;
        this.process("MOVED", 0, this.pos);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Dimension d = this.panel.getSize();
        this.pos.w = d.width;
        this.pos.h = d.height;
        this.process("RESIZE", 0);
        this.panel.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (this.status != -2) {
            this.status = 1;
        }
        if (this.panel != null) {
            this.panel.repaint();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public boolean hasFocus() {
        return this.panel.hasFocus();
    }

    public boolean getFocus() {
        boolean gotFocus = this.panel.hasFocus();
        if (!gotFocus) {
            this.panel.requestFocus();
        }
        return gotFocus;
    }

    private int event2button(AWTEvent e) {
        MouseEvent me = (MouseEvent)e;
        int btn = me.getButton();
        int modifiers = me.getModifiersEx();
        if (btn == 0) {
            btn = (modifiers & 0x400) != 0 ? 1 : ((modifiers & 0x800) != 0 ? 2 : ((modifiers & 0x1000) != 0 ? 3 : 1));
        } else if (this.button > 3) {
            this.button = 1;
        }
        if (me.isShiftDown()) {
            btn += 100;
        }
        return btn;
    }

    @Deprecated
    public void rubberbox(int mode) {
        this.rubberbox(this.panel.getGraphics(), mode);
    }

    void rubberbox(Graphics g, int mode) {
        int h;
        int y;
        int w;
        int x;
        if (mode == 0) {
            this.rubberbox(g, -1);
        }
        if (mode >= 0) {
            this.rbox.setBounds(this.box);
        }
        if (this.rbox.w >= 0) {
            x = this.rbox.x;
            w = this.rbox.w;
        } else {
            x = this.rbox.x + this.rbox.w;
            w = -this.rbox.w;
        }
        if (this.rbox.h >= 0) {
            y = this.rbox.y;
            h = this.rbox.h;
        } else {
            y = this.rbox.y + this.rbox.h;
            h = -this.rbox.h;
        }
        if (mode < 0) {
            this.rbox.setBounds(0, 0, 0, 0);
        }
        if (g != null) {
            g.setXORMode(this.panel.getBackground());
            g.drawRect(x, y, w, h);
            g.setXORMode(this.panel.getForeground());
            g.drawRect(x + 1, y + 1, w - 2, h - 2);
            g.setPaintMode();
            g.dispose();
        }
    }

    @Deprecated
    public void shadowbox(int x, int y, int w, int h, int mode) {
        this.shadowbox(this.g, x, y, w, h, mode);
    }

    @InternalUseOnly(value="For use by panel only)")
    public void shadowbox(Graphics g, int x, int y, int w, int h, int mode) {
        if (g == null) {
            return;
        }
        if (mode == -2 || mode == -6) {
            g.setColor(this.theme.cwbg);
            g.fillRect(x, y, w, h);
            g.setColor(this.theme.cfg);
            if (!(this instanceof GWidget)) {
                return;
            }
            GWidget gw = (GWidget)this;
            if (mode != -6 && (gw.pGroup == null || gw.pDetach || !gw.is(32))) {
                return;
            }
            g.setColor(this.theme.cwbs);
            g.drawLine(x + 1, y, x + 1, y + h);
            g.drawLine(x + w - 2, y, x + w - 2, y + h);
            g.setColor(this.theme.cwms);
            g.drawLine(x + 2, y, x + 2, y + h);
            g.drawLine(x + w - 3, y, x + w - 3, y + h);
            if (mode == -6 || this == gw.pGroup.lastWidget) {
                g.drawLine(x + 2, y + h - 1, x + w - 3, y + h - 1);
            }
            g.setColor(this.theme.cfg);
            return;
        }
        if (mode == -5 || mode == -7 || mode == -9) {
            g.setColor(this.theme.cwbg);
            g.drawLine(x, y, x, y + h);
            g.drawLine(x + w - 1, y, x + w - 1, y + h);
            g.setColor(this.theme.cwms);
            g.drawLine(x + 2, y, x + w - 3, y);
            int ah = Math.abs(h);
            int j1 = (int)((double)ah * 0.15);
            for (int i = 1; i < ah; ++i) {
                if (i < j1) {
                    g.setColor(MColor.getColorMix(this.theme.cwbg, this.theme.cwbs, (double)i / (double)j1));
                } else {
                    g.setColor(MColor.getColorMix(this.theme.cwbs, this.theme.cwms, (double)(i - j1) / (double)(ah - j1 - 1)));
                }
                int ay = h > 0 ? y + i : y - i;
                g.drawLine(x + 1, ay, x + w - 2, ay);
            }
            g.setColor(this.theme.cwbs);
            g.drawLine(x + 1, y + j1, x + 1, y + h);
            g.drawLine(x + w - 2, y + j1, x + w - 2, y + h);
            if (mode == -7) {
                int s = 3;
                int xs = x + w - 10;
                int ys = y + h / 2;
                g.setColor(this.theme.cwts);
                g.drawLine(xs - s, ys - s, xs + s, ys + s);
                g.drawLine(xs - s, ys + s, xs + s, ys - s);
                g.setColor(this.theme.cwbs);
                g.drawLine(++xs - s, ys - s, xs + s, ys + s);
                g.drawLine(xs - s, ys + s, xs + s, ys - s);
            }
            if (mode == -9) {
                this.drawPushPopIcon(g, x, y, w, h);
            }
            g.setColor(this.theme.cfg);
            return;
        }
        Color cfill = this.theme.cwbg;
        if (mode == 2) {
            cfill = this.theme.cwfh;
        } else if (mode == 4) {
            cfill = MColor.getColorMix(this.theme.cwfh, this.theme.cwbg, 0.7);
        }
        Color cwork = mode == -3 ? this.theme.cwbs : (mode == -4 || mode == -8 ? this.theme.cfg : (mode >= 0 ? this.theme.cwts : cfill));
        if (mode == 0 || mode == 2 || mode == 4) {
            g.setColor(cfill);
            g.fillRect(x, y, w, h);
        }
        if (mode != 4) {
            g.setColor(cwork);
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x, y, x, y + h - 1);
        }
        if (mode != -8) {
            g.setColor(MColor.getColorMix(cfill, cwork, 0.7));
            g.drawLine(x + 1, y + 1, x + w - 2, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 2);
        }
        cwork = mode == -3 ? this.theme.cwts : (mode == -4 || mode == -8 ? this.theme.cfg : (mode == 3 ? Color.yellow : (mode == 4 ? this.theme.cwfh : (mode >= 0 ? this.theme.cwbs : cfill))));
        if (mode != 4) {
            g.setColor(cwork);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        }
        if (mode != -8) {
            g.setColor(MColor.getColorMix(cfill, cwork, 0.7));
            g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
            g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
        }
        g.setColor(this.theme.cfg);
    }

    @Deprecated
    @InternalUseOnly(value="For use by panel only")
    public void shadowboxCustomIcon(int x, int y, int w, int h, int mode, int customIconShape, String iconSymbolName) {
        this.shadowboxCustomIcon(this.g, x, y, w, h, mode, customIconShape, iconSymbolName);
    }

    @InternalUseOnly(value="For use by panel only")
    public void shadowboxCustomIcon(Graphics g, int x, int y, int w, int h, int mode, int customIconShape, String iconSymbolName) {
        this.shadowbox(g, x, y, w, h, mode);
        switch (customIconShape) {
            case 1: {
                return;
            }
            case 2: {
                this.drawShadedXIcon(g, x - 10, y, w, h);
                return;
            }
        }
        this.drawSymbolAsIcon(g, x - 10, y, w, h, iconSymbolName);
    }

    private void drawSymbolAsIcon(Graphics g, int x, int y, int w, int h, String symbolName) {
        int xs = x + w - 10;
        int ys = y + h / 2;
        g.setColor(this.theme.cwbs);
        g.drawRect(xs - 3, ys - 5, 8, 11);
        g.fillRect(xs - 3, ys - 5, 8, 11);
        g.setColor(this.theme.cwts);
        Symbol iconSymbol = Symbol.getSymbol(symbolName, 7);
        iconSymbol.draw(xs + 1, ys + 1, g);
    }

    @Deprecated
    public void shadowarrow(int x, int y, int w, char mode) {
        this.shadowarrow(this.g, x, y, w, mode);
    }

    public void shadowarrow(Graphics g, int x, int y, int w, char mode) {
        if (g == null) {
            return;
        }
        int r = 1;
        int s = r + 1;
        if (mode == ' ') {
            g.setColor(this.theme.cwbg);
            g.fillRect(x - w - 4, y - w - 4, w + w + 8, w + w + 8);
        }
        if (mode == 'B') {
            g.setColor(this.theme.cwbg);
            g.fillRect(x - w - 4, y - w - 4, w + w + 8, w + w + 8);
            g.setColor(this.theme.cwbs);
            g.drawLine(x, y + w, x - w, y);
            g.drawLine(x, y - w, x - w, y);
            g.drawLine(x, y + w, x + w, y);
            g.drawLine(x, y - w, x + w, y);
            g.setColor(this.theme.cwts);
            g.drawLine(--x, y + w, x - w, y);
            g.drawLine(x, y - w, x - w, y);
            g.drawLine(x, y + w, x + w, y);
            g.drawLine(x, y - w, x + w, y);
        } else if (mode == 'U') {
            g.setColor(this.theme.cwbs);
            g.drawLine(x - w, y, x, y - w);
            g.drawLine(x + w, y, x, y - w);
            g.setColor(this.theme.cwts);
            g.drawLine(--x - w, y, x, y - w);
            g.drawLine(x + w, y, x, y - w);
        } else if (mode == 'D') {
            g.setColor(this.theme.cwbs);
            g.drawLine(x - w, y, x, y + w);
            g.drawLine(x + w, y, x, y + w);
            g.setColor(this.theme.cwts);
            g.drawLine(--x - w, y, x, y + w);
            g.drawLine(x + w, y, x, y + w);
        } else if (mode == 'L') {
            g.setColor(this.theme.cwbs);
            g.drawLine(x, y + w, x - w, y);
            g.drawLine(x, y - w, x - w, y);
            g.setColor(this.theme.cwts);
            g.drawLine(--x, y + w, x - w, y);
            g.drawLine(x, y - w, x - w, y);
        } else if (mode == 'R') {
            g.setColor(this.theme.cwbs);
            g.drawLine(x, y + w, x + w, y);
            g.drawLine(x, y - w, x + w, y);
            g.setColor(this.theme.cwts);
            g.drawLine(--x, y + w, x + w, y);
            g.drawLine(x, y - w, x + w, y);
        } else if (mode == 'b') {
            g.setColor(this.theme.cwbg);
            g.fillRect(x - w - s, y - w - s, w + w + s + s + 1, w + w + s + s + 1);
            g.setColor(this.theme.cwfh);
            g.fillRect(x - r, y - r, r + r, r + r);
            g.setColor(this.theme.cwbh);
            g.drawRect(x - r, y - r, r + r, r + r);
        } else if (mode == 'u') {
            this.fill3(x, (y -= s) - w, x + w, y, x - w, y, g);
        } else if (mode == 'd') {
            this.fill3(x, (y += s) + w, x + w, y, x - w, y, g);
        } else if (mode == 'l') {
            this.fill3((x -= s) - w, y, x, y + w, x, y - w, g);
        } else if (mode == 'r') {
            this.fill3((x += s) + w, y, x, y + w, x, y - w, g);
        } else if (mode == 'm') {
            g.setColor(this.theme.cwbh);
            g.drawLine(x - w, y - w, x + w, y - w);
            g.setColor(this.theme.cwfh);
            g.drawLine(x - w, y - w + 1, x + w, y - w + 1);
            this.fill3(x, (y += s) + w, x + w, y, x - w, y, g);
        }
        g.setColor(this.theme.cfg);
    }

    private void drawShadedXIcon(Graphics g, int x, int y, int w, int h) {
        int s = 3;
        int xs = x + w - 10;
        int ys = y + h / 2;
        g.setColor(this.theme.cwts);
        g.drawLine(xs - s, ys - s, xs + s, ys + s);
        g.drawLine(xs - s, ys + s, xs + s, ys - s);
        g.setColor(this.theme.cwbs);
        g.drawLine(++xs - s, ys - s, xs + s, ys + s);
        g.drawLine(xs - s, ys + s, xs + s, ys - s);
    }

    private void drawPushPopIcon(Graphics g, int x, int y, int w, int h) {
        if (g == null) {
            return;
        }
        this.drawNESWArrows(g, x, y, w, h, true);
    }

    private void drawNESWArrows(Graphics g, int x, int y, int w, int h, boolean shadeOnly) {
        int s = 3;
        int xs = x + w - 10;
        int ys = y + h / 2;
        g.setColor(this.theme.cwbs);
        if (!shadeOnly) {
            g.drawRect(xs - 3, ys - 5, 8, 12);
            g.fillRect(xs - 3, ys - 5, 8, 12);
        } else {
            g.drawLine(xs - 1, ys - 1, xs + 1, ys - s);
            g.drawLine(xs, ys, xs + 2, ys - 2);
            g.drawLine(xs, ys + 3, xs + 2, ys + 1);
            g.drawLine(xs + 1, ys + s + 1, xs + s, ys + 2);
            g.drawLine(xs + 1, ys - s - 2, xs + s + 1, ys - s - 2);
            g.drawLine(xs + s + 1, ys - s - 1, xs + s + 1, ys - s + 1);
            g.drawLine(xs - 2, ys + s + 3, xs + 1, ys + s + 3);
            g.drawLine(xs - 2, ys + s, xs - 2, ys + s + 2);
        }
        g.setColor(this.theme.cwts);
        g.drawLine(xs - 1, ys, xs + s, ys - s - 1);
        g.drawLine(xs + s - 2, ys - s - 1, xs + s, ys - s - 1);
        g.drawLine(xs + s, ys - s - 1, xs + s, ys - s + 1);
        g.drawLine(xs - 1, ys + s + 2, xs + s, ys + 1);
        g.drawLine(xs - 1, ys + s + 2, xs + 1, ys + s + 2);
        g.drawLine(xs - 1, ys + s + 2, xs - 1, ys + s);
    }

    private void drawBoxWithArrow(Graphics g, int x, int y, int w, int h, boolean shadeOnly) {
        int s = 3;
        int xs = x + w - 10;
        int ys = y + h / 2;
        if (!shadeOnly) {
            g.setColor(this.theme.cwbs);
            g.drawRect(xs - 3, ys - 3, 9, 9);
            g.fillRect(xs - 3, ys - 3, 9, 9);
        }
        if (shadeOnly) {
            g.setColor(this.theme.cwbs);
            g.drawLine(xs + s - 1, ys, xs + 3, ys + 2 - s);
            g.drawLine(xs + s, ys + 1, xs + 4, ys + 3 - s);
            g.drawLine(xs + 3, ys + 2 - s, xs + 1, ys + 2 - s);
            g.drawLine(xs + 1, ys + 2 - s, xs + 1, ys - s);
            g.drawLine(xs + 1, ys - s, xs + 6, ys - s);
            g.drawLine(xs + 6, ys - s, xs + 6, ys - s + 5);
            g.drawLine(xs + 5, ys - s + 5, xs + 4, ys - s + 5);
            g.drawLine(xs + 4, ys - s + 5, xs + 4, ys - s + 3);
            g.drawLine(xs + s - 2, ys, xs + s - 6, ys);
            g.drawLine(xs + s - 6, ys + 1, xs + s - 6, ys + 6);
            g.drawLine(xs + s - 5, ys + 6, xs + s, ys + 6);
            g.drawLine(xs + s, ys + 5, xs + s, ys + 1);
        }
        g.setColor(this.theme.cwts);
        g.drawLine(xs + s - 1, ys + 1, xs + 5, ys + 1 - s);
        g.drawLine(xs + 5, ys + 1 - s, xs + 5, ys + 1);
        g.drawLine(xs + 5, ys + 1 - s, xs + s - 1, ys + 1 - s);
        g.drawRect(xs + s - 5, ys + 1, 4, 4);
    }

    private void drawCorners(Graphics g, int x, int y, int w, int h, boolean shadeOnly) {
        int s = 3;
        int xs = x + w - 10 + 2;
        int ys = y + h / 2 - 2;
        int lts = s - 1;
        if (!shadeOnly) {
            g.setColor(this.theme.cwbs);
            g.drawRect(xs - 5, ys - 3, 10, 10);
            g.fillRect(xs - 5, ys - 3, 10, 10);
        }
        if (shadeOnly) {
            g.setColor(this.theme.cwbs);
            g.drawLine(xs - 4, ys - 3, xs - 1, ys - 3);
            g.drawLine(xs - 3, ys - 1, xs - 2, ys - 1);
            g.drawLine(xs - 5, ys - 3, xs - 5, ys + 1);
            g.drawLine(xs - 3, ys - 1, xs - 3, ys + 1);
            g.drawLine(xs - 1, ys - 1, xs - 1, ys - 3);
            g.drawLine(xs - 4, ys + 1, xs - 3, ys + 1);
            g.drawLine(xs + 4, ys - 3, xs + 1, ys - 3);
            g.drawLine(xs + 3, ys - 1, xs + 1, ys - 1);
            g.drawLine(xs + 5, ys - 3, xs + 5, ys + 1);
            g.drawLine(xs + 3, ys - 1, xs + 3, ys + 1);
            g.drawLine(xs + 1, ys - 3, xs + 1, ys - 1);
            g.drawLine(xs + 4, ys + 1, xs + 5, ys + 1);
            g.drawLine(xs - 5, ys + 7, xs - 1, ys + 7);
            g.drawLine(xs - 3, ys + 5, xs - 2, ys + 5);
            g.drawLine(xs - 5, ys + 6, xs - 5, ys + 3);
            g.drawLine(xs - 3, ys + 5, xs - 3, ys + 3);
            g.drawLine(xs - 1, ys + 7, xs - 1, ys + 5);
            g.drawLine(xs - 4, ys + 3, xs - 4, ys + 3);
            g.drawLine(xs + 5, ys + 7, xs + 1, ys + 7);
            g.drawLine(xs + 3, ys + 5, xs + 1, ys + 5);
            g.drawLine(xs + 5, ys + 6, xs + 5, ys + 3);
            g.drawLine(xs + 3, ys + 5, xs + 3, ys + 3);
            g.drawLine(xs + 1, ys + 6, xs + 1, ys + 6);
            g.drawLine(xs + 4, ys + 3, xs + 4, ys + 3);
        }
        g.setColor(this.theme.cwts);
        g.drawLine(xs - 4, ys - 2, xs - 2, ys - 2);
        g.drawLine(xs - 4, ys - 2, xs - 4, ys);
        g.drawLine(xs + 4, ys - 2, xs + 2, ys - 2);
        g.drawLine(xs + 4, ys - 2, xs + 4, ys);
        g.drawLine(xs - 4, ys + 6, xs - 2, ys + 6);
        g.drawLine(xs - 4, ys + 6, xs - 4, ys + 4);
        g.drawLine(xs + 4, ys + 6, xs + 2, ys + 6);
        g.drawLine(xs + 4, ys + 6, xs + 4, ys + 4);
    }

    private void fill3(int x1, int y1, int x2, int y2, int x3, int y3, Graphics g) {
        int[] xp = new int[]{x1, x2, x3, x1};
        int[] yp = new int[]{y1, y2, y3, y1};
        g.setColor(this.theme.cwfh);
        g.fillPolygon(xp, yp, 4);
        g.setColor(this.theme.cwbh);
        g.drawPolygon(xp, yp, 4);
    }

    @Deprecated
    public void sliderbox(int x, int y, int w, int h, double f, int flags) {
        this.sliderbox(this.g, x, y, w, h, f, flags);
    }

    public void sliderbox(Graphics g, int x, int y, int w, int h, double f, int flags) {
        if (h < w) {
            MWindow.drawHSlider(x, y, w, h, f, flags, g, this.theme);
        }
        if (w < h) {
            MWindow.drawVSlider(x, y, w, h, f, flags, g, this.theme);
        }
    }

    public static void drawHSlider(int x, int y, int w, int h, double f, int flags, Graphics g, Theme theme) {
        int n = w;
        int sw = 16;
        int swh = sw / 2;
        g.setColor(theme.cwbg);
        g.drawLine(x, y - 2, x + w, y - 2);
        g.drawLine(x, y + 2, x + w, y + 2);
        if ((flags & 2) == 0) {
            for (int i = 0; i < n; ++i) {
                g.setColor(MColor.getColorMix(theme.cwbs, Color.black, (double)i / (double)n));
                g.drawLine(x + i, y - 1, x + i, y - 1);
                g.setColor(MColor.getColorMix(theme.cwts, theme.cwbs, (double)Math.abs(i - n + i) / (double)n));
                g.drawLine(x + i, y + 0, x + i, y + 0);
                g.setColor(MColor.getColorMix(theme.cwms, theme.cwbs, (double)i / (double)n));
                g.drawLine(x + i, y + 1, x + i, y + 1);
            }
        }
        int aw = n - sw;
        x += swh + Math.max(0, Math.min(aw, (int)(f * (double)aw)));
        for (int i = 0; i < swh; ++i) {
            if ((flags & 1) != 0) {
                g.setColor(theme.cwfg);
            }
            g.setColor(MColor.getColorMix(theme.cwfh, theme.cwfg, (double)i / (double)swh));
            g.drawLine(x + i, y - 0, x + i, y - 0);
            g.drawLine(x - i, y - 0, x - i, y - 0);
            g.setColor(MColor.getColorMix(theme.cwts, theme.cwms, (double)i / (double)swh));
            g.drawLine(x + i, y - 1, x + i, y - 1);
            g.drawLine(x - i, y - 1, x - i, y - 1);
            g.drawLine(x + i, y + 1, x + i, y + 1);
            g.drawLine(x - i, y + 1, x - i, y + 1);
            g.setColor(MColor.getColorMix(theme.cwts, theme.cwms, (double)i / (double)swh));
            g.drawLine(x + i, y - 2, x + i, y - 2);
            g.drawLine(x - i, y - 2, x - i, y - 2);
            g.drawLine(x + i, y + 2, x + i, y + 2);
            g.drawLine(x - i, y + 2, x - i, y + 2);
        }
        g.setColor(theme.cwbs);
        g.drawLine(x - swh, y + 2, x - swh, y - 2);
        g.drawLine(x + swh, y + 2, x + swh, y - 2);
    }

    public static void drawVSlider(int x, int y, int w, int h, double f, int flags, Graphics g, Theme theme) {
        if ((flags & 4) != 0) {
            int xi = x - w / 2;
            int wi = w - 1;
            g.setColor(theme.cwms);
            g.fillRect(xi, y, wi, h);
            g.setColor(theme.cwts);
            g.drawLine(xi, y, xi, y + h - 1);
            g.setColor(theme.cwbs);
            g.drawLine(xi + wi, y, xi + wi, y + h - 1);
            g.setColor(theme.cwbs);
            g.drawLine(x - 3, y += 4, x - 3, y + (h -= 8) - 1);
            g.setColor(theme.cwts);
            g.drawLine(x + 3, y, x + 3, y + h - 1);
        }
        g.setColor(theme.cwbg);
        g.fillRect(x - 2, y, 5, h);
        int n = h;
        int sw = 16;
        int swh = sw / 2;
        if ((flags & 2) == 0) {
            for (int i = 0; i < n; ++i) {
                g.setColor(MColor.getColorMix(theme.cwbs, Color.black, (double)i / (double)n));
                g.drawLine(x - 1, y + i, x - 1, y + i);
                g.setColor(MColor.getColorMix(theme.cwts, theme.cwbs, (double)Math.abs(i - n + i) / (double)n));
                g.drawLine(x + 0, y + i, x + 0, y + i);
                g.setColor(MColor.getColorMix(theme.cwms, theme.cwbs, (double)i / (double)n));
                g.drawLine(x + 1, y + i, x + 1, y + i);
            }
        }
        int aw = n - sw;
        y += swh + Math.max(0, Math.min(aw, (int)(f * (double)aw)));
        for (int i = 0; i < swh; ++i) {
            if ((flags & 1) != 0) {
                g.setColor(theme.cwfg);
            } else {
                g.setColor(MColor.getColorMix(theme.cwfh, theme.cwfg, (double)i / (double)swh));
            }
            g.drawLine(x - 0, y + i, x - 0, y + i);
            g.drawLine(x - 0, y - i, x - 0, y - i);
            g.setColor(MColor.getColorMix(theme.cwts, theme.cwms, (double)i / (double)swh));
            g.drawLine(x - 1, y + i, x - 1, y + i);
            g.drawLine(x - 1, y - i, x - 1, y - i);
            g.drawLine(x + 1, y + i, x + 1, y + i);
            g.drawLine(x + 1, y - i, x + 1, y - i);
            g.setColor(MColor.getColorMix(theme.cwts, theme.cwms, (double)i / (double)swh));
            g.drawLine(x - 2, y + i, x - 2, y + i);
            g.drawLine(x - 2, y - i, x - 2, y - i);
            g.drawLine(x + 2, y + i, x + 2, y + i);
            g.drawLine(x + 2, y - i, x + 2, y - i);
        }
        g.setColor(theme.cwbs);
        g.drawLine(x - 2, y - swh, x + 2, y - swh);
        g.drawLine(x - 2, y + swh, x + 2, y + swh);
    }

    @Deprecated
    public void drawString(String text, int x, int y, int size, int flags) {
        this.drawString(this.g, text, x, y, size, flags);
    }

    public void drawString(Graphics g, String text, int x, int y, int size, int flags) {
        if (text == null) {
            return;
        }
        int style = -1;
        if ((flags & 4) != 0) {
            style = 1;
        }
        Font f = this.newFont(this.font, "", style, size);
        if ((flags & 1) != 0) {
            this.fm = this.panel.getFontMetrics(f);
            x -= this.fm.stringWidth(text) / 2;
        }
        if ((flags & 8) != 0) {
            g.setColor(this.theme.cwfh);
        }
        if ((flags & 0x10) != 0) {
            g.setColor(this.theme.cwfh.darker());
        }
        if (f != this.font) {
            g.setFont(f);
        }
        g.drawString(text, x, y);
        if (f != this.font) {
            g.setFont(this.font);
        }
        if ((flags & 0x18) != 0) {
            g.setColor(this.theme.cfg);
        }
    }

    @Deprecated
    public void clear() {
        this.clear(this.g);
    }

    public void clear(Graphics g) {
        if (g == null) {
            return;
        }
        Color c = g.getColor();
        g.setColor(this.theme.cbg);
        g.fillRect(0, 0, this.pos.w, this.pos.h);
        g.setColor(c);
    }

    public void setAltTitle(String text) {
        if (this.getNoAltTitle()) {
            return;
        }
        Container p = this.panel;
        while (p instanceof Component) {
            MWindow mw = null;
            if (MidasFrame.isMidasFrame(p)) {
                mw = MidasFrame.getMidasFrameMWindowViaReflection(p);
            }
            if (mw != null && p instanceof Frame) {
                if (mw.getNoAltTitle()) {
                    return;
                }
                if (text == null) {
                    text = mw.title;
                }
                if (mw.mh instanceof panel) {
                    ((panel)mw.mh).setAltTitle(text);
                } else {
                    ((Frame)p).setTitle(text);
                }
                return;
            }
            p = p.getParent();
        }
    }

    public boolean getNoAltTitle() {
        return this.noAltTitle;
    }

    public void setNoAltTitle(boolean val) {
        if (this.noAltTitle == val) {
            return;
        }
        this.noAltTitle = val;
        this.setTitle(this.title);
    }

    public void setStatusBar(String text) {
        Container p = this.panel;
        while (p instanceof Component) {
            p = p.getParent();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.parent instanceof Frame) {
            ((Frame)this.parent).setTitle(title);
        } else if (this.status == 1) {
            this.panel.repaint();
        }
    }

    public void setFontSize(int size) {
        if (size < 1) {
            return;
        }
        this.font = this.newFont(this.font, "", -1, size);
        this.setup();
    }

    public Font newFont(Font f1, String name, int style, int size) {
        if (this.headless) {
            return f1;
        }
        if (f1 != null) {
            if (name == null || name.equals("")) {
                name = f1.getName();
            }
            if (style == -1) {
                style = f1.getStyle();
            }
            if (size == -1) {
                size = f1.getSize();
            }
        }
        Font f2 = new Font(name, style, size);
        return f2;
    }

    @Deprecated
    public Rectangle getClipBounds() {
        return this.clip;
    }

    @Deprecated
    public void setClipBounds(Rectangle clip) {
        this.clip = clip;
    }

    public void refresh() {
        if (this.status == 1 && this.panel != null) {
            this.panel.repaint();
        }
    }

    public void refresh(MBox box) {
        if (this.status == 1 && this.panel != null) {
            if (box != null) {
                this.panel.repaint(box.x, box.y, box.w, box.h);
            } else {
                this.panel.repaint();
            }
        }
    }

    public void resize(int mode) {
    }

    @ProvisionalUseOnly(value="Treat this as protected and should only be called by subclass paintComponent methods")
    public void paintComponent(Graphics g) {
        if (g == null) {
            return;
        }
        g.setFont(this.font);
        this.setGraphics(g);
    }

    public void setGraphics(Graphics g) {
        this.g = g;
        g.setFont(this.font);
        this.clip = g.getClipBounds();
    }

    @Deprecated
    public void paint() {
    }

    public void place(MBox a, MBox b, int x, int y) {
        a.x = x - a.w / 2;
        a.y = y - a.h / 2;
        this.place(a, b);
    }

    public void place(MBox a, MBox b) {
        a.x = Math.max(0, Math.min(a.x, b.w - a.w));
        a.y = Math.max(0, Math.min(a.y, b.h - a.h));
    }

    @Override
    public String[] getKeys() {
        return keys;
    }

    @Override
    public Object setKey(String key, Object value) {
        if (key.equals("POS")) {
            this.setBounds((MBox)value);
        } else if (key.equals("PARENT")) {
            this.addTo(value);
        } else if (key.equals("THEME")) {
            this.setTheme(value);
        } else if (key.equals("TITLE")) {
            this.setTitle((String)value);
        } else if (key.equals("REFRESH")) {
            this.process("REFRESH", 0);
        } else {
            return null;
        }
        return value;
    }

    @Override
    public Object getKey(String key) {
        if (key.equals("POS")) {
            return this.pos;
        }
        if (key.equals("PARENT")) {
            return this.parent;
        }
        if (key.equals("THEME")) {
            return this.theme;
        }
        if (key.equals("TITLE")) {
            return this.title;
        }
        return null;
    }

    public int getStatus() {
        return this.status;
    }

    public Container getPanel() {
        return this.panel;
    }

    public boolean isPanelVisible() {
        return this.panel != null && this.panel.isVisible() && this.panel.isShowing();
    }

    public void setCursor(String name, double sec) {
        final String oldCursor = this.getCursor();
        this.setCursor(name);
        this.cursorTimer = new Timer((int)(1000.0 * sec), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MWindow.this.setCursor(oldCursor);
            }
        });
        this.cursorTimer.start();
    }

    public void setCursor(String name) {
        Cursor cursor;
        int type;
        if (this.isCursor(name)) {
            return;
        }
        if (this.cursorTimer != null) {
            this.cursorTimer.stop();
            this.cursorTimer = null;
        }
        if ((type = Parser.find(cursorList, name, 0, -2)) == -1) {
            Shell.getSharedMidasContext().warning("MWindow: Can not set cursor to " + name + ", using DEFAULT.");
            type = 0;
        }
        if (!(cursor = Cursor.getPredefinedCursor(type)).equals(this.cursor)) {
            this.cursor = cursor;
            if (this.panel != null) {
                if (EventQueue.isDispatchThread()) {
                    this.panel.setCursor(cursor);
                } else {
                    GraphicsUtil.invokeLater(() -> {
                        if (this.panel != null) {
                            this.panel.setCursor(cursor);
                        }
                    });
                }
            }
        }
    }

    public boolean isCursor(String name) {
        int type = Parser.find(cursorList, name, 0, -2);
        if (type == -1) {
            Shell.getSharedMidasContext().warning("MWindow: Can not set cursor to " + name + ", using DEFAULT.");
            type = 0;
        }
        Cursor cursor = Cursor.getPredefinedCursor(type);
        return cursor.equals(this.cursor);
    }

    public String getCursor() {
        Container container = this.panel;
        if (container == null) {
            return "Default";
        }
        return Parser.get(cursorList, container.getCursor().getType(), -2);
    }

    protected void helpKeyPressed() {
        MWindow mw = this;
        while (!mw.pactive && mw.MW != null && mw.MW != mw) {
            mw = mw.MW;
        }
        Midas M = Convert.ref2Midas(mw.mh);
        if (!mw.pactive) {
            mw = this.findActiveChild(mw.panel);
        }
        if (mw != null && M != null && M.macro != null) {
            Table data = mw.getHelpData();
            M.macro.processMessage(new Message("HELP", 0, data));
        } else {
            Shell.warning("No handler for Help key on " + mw);
        }
    }

    protected Table getHelpData() {
        Table data = new Table();
        String name = this.name;
        if (this.mh instanceof Command) {
            name = ((Command)this.mh).getID();
        }
        data.put("NAME", (Object)name);
        return data;
    }

    private MWindow findActiveChild(Container cont) {
        Component c;
        int i;
        Component[] comps;
        MWindow mw = null;
        Component activeComp = null;
        if (cont instanceof MJPanel) {
            comps = ((MJPanel)cont).getRootPane().getLayeredPane().getComponents();
            for (i = 0; i < comps.length; ++i) {
                c = comps[i];
                if (c.getMousePosition() == null) continue;
                activeComp = c;
            }
        }
        if (mw == null) {
            comps = cont.getComponents();
            for (i = 0; i < comps.length; ++i) {
                c = comps[i];
                if (c.getMousePosition() == null) continue;
                activeComp = c;
            }
        }
        if (activeComp != null) {
            if (activeComp instanceof MJPanel) {
                mw = ((MJPanel)activeComp).MW;
            } else if (activeComp instanceof MPanel) {
                mw = ((MPanel)activeComp).MW;
            } else if (activeComp instanceof MJText) {
                mw = ((MJText)activeComp).MW;
            } else if (activeComp instanceof Container) {
                mw = this.findActiveChild((Container)activeComp);
            }
        }
        return mw;
    }

    public ExportImage exportImage() {
        if (this.panel == null) {
            throw new MidasException("MWindow: Can not export image, panel is null.");
        }
        return ExportImage.export(this.panel);
    }

    @InternalUseOnly
    public static boolean setWarningsMask(String warnings) {
        return MWindow.setWarningsMask(Parser.mask(warningsList, warnings, warningsMask));
    }

    @InternalUseOnly
    public static boolean setWarningsMask(int mask) {
        if (warningsMask == mask) {
            return false;
        }
        warningsMask = mask;
        return true;
    }

    @InternalUseOnly
    public static String getWarningsMask() {
        return Parser.mask2s(warningsList, warningsMask);
    }
}

