/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import nxm.sys.inc.Chainable;
import nxm.sys.inc.Constants;
import nxm.sys.inc.DataTypes;
import nxm.sys.inc.Drawable;
import nxm.sys.inc.IDable;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.PlotFile;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Format;
import nxm.sys.lib.GeodeticUtil;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.MFormat;
import nxm.sys.lib.Message;
import nxm.sys.lib.MessageQueue;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Position;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;
import nxm.sys.lib.Transform;
import nxm.sys.lib.TuneAdjust;
import nxm.sys.lib.XmlFile;
import nxm.sys.libg.DPix;
import nxm.sys.libg.DragBox;
import nxm.sys.libg.Feature;
import nxm.sys.libg.FeatureGroup;
import nxm.sys.libg.FeatureGroupMap;
import nxm.sys.libg.GDialog;
import nxm.sys.libg.GLegend;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GValue;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.GeometricUtil;
import nxm.sys.libg.GraphicsUtil;
import nxm.sys.libg.Layer;
import nxm.sys.libg.Layer2D;
import nxm.sys.libg.LayerDrawable;
import nxm.sys.libg.LayerGrid;
import nxm.sys.libg.Line;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MJPanel;
import nxm.sys.libg.MPoint;
import nxm.sys.libg.MWindow;
import nxm.sys.libg.MidasDisplay;
import nxm.sys.libg.Pix;
import nxm.sys.libg.PlotCanvas;
import nxm.sys.libg.ResizeBox;
import nxm.sys.libg.Symbol;
import nxm.sys.libg.Theme;
import nxm.sys.libg.View;
import nxm.sys.libg.View3D;
import nxm.sys.libg.ViewGeo;
import nxm.sys.libg.ViewMercader;
import nxm.sys.libg.ViewPolar;
import nxm.sys.libm.Tolerance;

public class MPlot
extends MWindow
implements MessageHandler,
DataTypes,
Constants,
Chainable,
ImageObserver,
MouseWheelListener {
    @InternalUseOnly(value="since 3.3.1")
    public int view = 0;
    private int axis = 0;
    @InternalUseOnly(value="since 3.3.1")
    public int mode = 0;
    @InternalUseOnly(value="since 3.3.1")
    public int scale = 0;
    private int readout = 0;
    private int readoutExt = 0;
    private int READOUT_OPTION_MAIN = 1;
    private int READOUT_OPTION_EXT = 2;
    private double readoutExtTime = 0.0;
    @Deprecated
    public int options = 0;
    @Deprecated
    public int viewLast;
    @InternalUseOnly(value="since 3.3.1")
    public int modeLast;
    @InternalUseOnly(value="since 3.3.1")
    public int tw;
    @InternalUseOnly(value="since 3.3.1")
    public int th;
    private int ta;
    public int ix1;
    public int ix2;
    public int ix21;
    public int iy1;
    public int iy2;
    public int iy21;
    public int iz1;
    public int iz2;
    private int iz21;
    private int ndx;
    private int ndy;
    private int ndz;
    private double rx;
    public double rx1;
    public double rx2;
    private double ry;
    public double ry1;
    public double ry2;
    private double rz;
    public double rz1;
    public double rz2;
    public double mxx;
    public double myy;
    public double mxb;
    public double myb;
    private double mzz;
    private double mzb;
    private double brx;
    private double bry;
    private double brxd;
    private double bryd;
    public double orx1;
    public double orx2;
    public double ory1;
    public double ory2;
    public double orz1;
    public double orz2;
    @Deprecated
    public double frx1;
    @Deprecated
    public double frx2;
    @Deprecated
    public double fry1;
    @Deprecated
    public double fry2;
    @Deprecated
    public double frz1;
    @Deprecated
    public double frz2;
    private double minRange = 50.0;
    private double maxRange = 100.0;
    private double time;
    public static int DATE_FORMAT_SIMPLEDATEFORMAT = 97;
    public static int DATE_FORMAT_AUTO = 98;
    public static int DATE_FORMAT_DEFAULT = 99;
    private int dateFormat = DATE_FORMAT_DEFAULT;
    private MFormat dateMFormat;
    @InternalUseOnly
    public Graphics gc;
    private static final float DEF_ZOOM_PERCENTAGE = 0.5f;
    private float zoomAdjust = 0.1f;
    private float zoomMult = 5.0f;
    private boolean dblClickZoom = false;
    private boolean mouseWheelZoom = false;
    private float zoomPercent = 0.5f;
    private boolean zoomKeep = false;
    private Table keyMap;
    private int clickCount = 0;
    private boolean zoomed = false;
    public volatile int popupCount = 0;
    @InternalUseOnly
    public Table outerLimits;
    @InternalUseOnly
    public Table viewLimits;
    private boolean axisIndex = false;
    private boolean allowDragAndDrop = false;
    private StringDropTarget stringDropTarget = null;
    private int maxcmp = 128;
    private double[] bvp = new double[3];
    private double[] nvp = new double[3];
    private DecimalFormat nf = new DecimalFormat("###0.###");
    private Format xnf = new Format("###0.###");
    private Format ynf = new Format("###0.###");
    private int userView = 0;
    private int xMult = 0;
    private int yMult = 0;
    private int precision = 3;
    private Position mp = new Position();
    private Position mt = new Position();
    private Position mm;
    private double xOff = 0.0;
    private double yOff = 0.0;
    private double[] edata;
    private double[] cdata;
    private Transform et;
    private Transform ctp;
    private Transform ctq;
    private int ediv = 60;
    private int crossX;
    private int crossY;
    private int scroll;
    private int isx;
    private int isxd;
    private int isxy;
    private int isy;
    private int isyd;
    private int isyx;
    private boolean isLowHScroll = false;
    private boolean isHighHScroll = false;
    private boolean isLowVScroll = false;
    private boolean isHighVScroll = false;
    private Line lastLine;
    private Color lastColor;
    private LayerGrid layerGrid;
    private Layer baseLayer;
    private GLegend legend;
    private String userCursor = null;
    private boolean showDeltas;
    private boolean cutsOnPipedLayer2D = false;
    float[][] archivedFrames = null;
    int archivedFramesWriteIdx = 0;
    int scaleAvg = 8;
    static final int MAX_NOAVERAGE_AUTOL = 256;
    private double[] rstk = new double[105];
    private Image[] images = new Image[16];
    private Image dbimage;
    private Image dbimageBackup;
    private boolean useDBImageBackup = true;
    private static boolean neverUseDBImageBackup = false;
    @InternalUseOnly(value="since 3.5.1")
    public KeyVector layers;
    @InternalUseOnly(value="since 3.5.1")
    public KeyVector features;
    @InternalUseOnly(value="since 3.5.1")
    public View viewer;
    @InternalUseOnly(value="since 3.5.1")
    public View view2D;
    @InternalUseOnly(value="since 3.5.1")
    public View3D view3D;
    @InternalUseOnly(value="since 3.5.1")
    public ViewGeo viewGeo;
    @InternalUseOnly(value="since 3.5.1")
    public ViewPolar viewPolar;
    @InternalUseOnly(value="since 3.5.1")
    public ViewMercader viewMerc;
    @InternalUseOnly(value="since 3.5.1")
    public boolean xvy;
    @InternalUseOnly(value="since 3.5.1")
    public boolean is2D;
    @InternalUseOnly(value="since 3.5.1")
    public boolean cancel;
    private boolean needRefresh;
    private boolean refreshing;
    public static final String holdRefreshList = "Features,Layers,Canvas";
    public static final int HOLD_FEATURE_REFRESHES = 1;
    public static final int HOLD_LAYER_REFRESHES = 2;
    public static final int HOLD_CANVAS_REFRESHES = 4;
    int holdRefresh = 0;
    static boolean mapRefreshShouldClear = true;
    public Pix pix = new Pix(4096, 0);
    public Pix tpix = new Pix(4, 1);
    private boolean isSwing = Theme.getOption(4);
    private int zmode = 0;
    private boolean resizing;
    private int xUnitsID = 0;
    private int yUnitsID = 0;
    private int zUnitsID = 0;
    private boolean unitsInit = false;
    private MBox oarbox = new MBox();
    private boolean useBS;
    private boolean useNBS;
    private boolean useDB;
    private int refreshMode;
    private String plotInfo;
    private static final String READOUT_FORMAT_3PLACES = "###0.###";
    private static final String READOUT_FORMAT_6PLACES = "###0.######";
    private static final String READOUT_FORMAT_DEFAULT = "###0.###";
    private final double DEF_MIN_BOUNDS = 0.0;
    private final double DEF_MAX_BOUNDS = 1.0;
    public static final int CH_UNDRAW = -1;
    public static final int CH_DRAW = 1;
    public static final int CH_REDRAW = 0;
    private boolean drawnCH = false;
    private boolean needsDrawCH = false;
    private double axisBuffer = 1.0E-12;
    @InternalUseOnly(value="since 3.3.1")
    public int initValues = 0;
    public static final int I_AXIS = 1;
    public static final int I_VIEW = 2;
    public static final int I_MODE = 4;
    public static final int I_SCALE = 8;
    public static final int I_TIME = 16;
    public static final int I_READOUT = 32;
    public static final String optionsList = "BStore,Axes,Mark,Contrast,CrossHairs,XCut,YCut,ZCut,StillZoom,BlockZoom,Pager,All,Auto2D,DBuffer,NearInt,DragZoom";
    public static final int O_BSTORE = 1;
    public static final int O_AXES = 2;
    public static final int O_MARK = 4;
    public static final int O_CONTRAST = 8;
    public static final int O_CROSS = 16;
    public static final int O_XCUT = 32;
    public static final int O_YCUT = 64;
    public static final int O_ZCUT = 128;
    public static final int O_STILL = 256;
    public static final int O_BLOCK = 512;
    public static final int O_PAGER = 1024;
    public static final int O_ALL = 2048;
    public static final int O_AUTO2D = 4096;
    public static final int O_DBUFFER = 8192;
    public static final int O_NEARINT = 16384;
    public static final int O_DRAGZOOM = 32768;
    public static final int O_DEFAULT = 0;
    public static final String viewList = "YX,iYX,YiX,iYiX,XY,iXY,XiY,iXiY,XYZ,Polar,LatLon,Mercator,Geodetic,LatLonContinuous,3DGraph";
    public static final int V_YX = 1;
    public static final int V_IYX = 2;
    public static final int V_YIX = 3;
    public static final int V_IYIX = 4;
    public static final int V_XY = 5;
    public static final int V_IXY = 6;
    public static final int V_XIY = 7;
    public static final int V_IXIY = 8;
    public static final int V_XYZ = 9;
    public static final int V_POLAR = 10;
    public static final int V_LATLON = 11;
    public static final int V_MERCATOR = 12;
    public static final int V_GEODETIC = 13;
    public static final int V_LATLONCONTINUOUS = 14;
    public static final int V_3DGRAPH = 15;
    public static final String modeList = "Mag,Phase,Real,Imag,RnI,RvI,10Log,20Log,X,Y,Z";
    public static final int M_MAG = 1;
    public static final int M_PHASE = 2;
    public static final int M_REAL = 3;
    public static final int M_IMAG = 4;
    public static final int M_RNI = 5;
    public static final int M_RVI = 6;
    public static final int M_10LOG = 7;
    public static final int M_20LOG = 8;
    public static final int M_VX = 9;
    public static final int M_VY = 10;
    public static final int M_VZ = 11;
    public static final String drangeunitsList = "M,KM,NMI";
    @Deprecated
    public static final String dRangeUnitsList = "M,KM,NMI";
    public static final int U_METERS = 1;
    public static final int U_KILOMETERS = 2;
    public static final int U_NAUTICAL_MILES = 3;
    public static final int DEF_DRANGE_UNITS = 1;
    @Deprecated
    public int dRangeUnits = 1;
    public static final String readoutList = "Show,onStatus,onAxis,onTitle,X,dX,1/X,iX,Y,dY,dY/dX,iY,Z,dZ,dZ/dX,iZ,T,dT,1/T,1/dT,dRange,ExtPrec,Index,DMS,Units,View,DateString,Scientific,Azimuth,AlwaysDeltas,dRangeUnits>";
    public static final String readoutListExt = "Show,Features,Points,WMS_level,RF";
    public static final String shortReadoutListExt = "Show,Features";
    public static final int R_SHOW = 1;
    public static final int R_ONSTATUS = 2;
    public static final int R_ONAXIS = 4;
    public static final int R_ONTITLE = 8;
    public static final int R_X = 16;
    public static final int R_DX = 32;
    public static final int R_XINV = 64;
    public static final int R_IX = 128;
    public static final int R_Y = 256;
    public static final int R_DY = 512;
    public static final int R_DYDX = 1024;
    public static final int R_IY = 2048;
    public static final int R_Z = 4096;
    public static final int R_DZ = 8192;
    public static final int R_DZDX = 16384;
    public static final int R_IZ = 32768;
    public static final int R_T = 65536;
    public static final int R_DT = 131072;
    public static final int R_TINV = 262144;
    public static final int R_FREQ = 524288;
    public static final int R_DR = 0x100000;
    public static final int R_EP = 0x200000;
    public static final int R_INDEX = 0x400000;
    public static final int R_DMS = 0x800000;
    public static final int R_UNITS = 0x1000000;
    public static final int R_VIEW = 0x2000000;
    public static final int R_DATESTRING = 0x4000000;
    public static final int R_SCIENTIFIC = 0x8000000;
    public static final int R_AZIMUTH = 0x10000000;
    public static final int R_ALWAYSDELTAS = 0x20000000;
    public static final int R_EXT_SHOW = 1;
    public static final int R_EXT_FEATURE = 2;
    public static final int R_EXT_POINT = 4;
    public static final int R_EXT_WMS_LEVEL = 8;
    public static final int R_EXT_RASTER_RF = 16;
    public static final int R_DEFAULT = 235930427;
    public static final String scaleList = "AutoMin,AutoMax,MinRange,MaxRange,MinZRange,MaxZRange,NoAverage,ExpandOnly";
    public static final int S_MIN = 1;
    public static final int S_MAX = 2;
    public static final int S_MINRANGE = 4;
    public static final int S_MAXRANGE = 8;
    public static final int S_MINZRANGE = 16;
    public static final int S_MAXZRANGE = 32;
    public static final int S_NOAVERAGE = 64;
    public static final int S_EXPANDONLY = 128;
    public static final int S_AUTO = 3;
    public static final int S_RANGE = 12;
    public static final int S_DEFAULT = 3;
    public static final String enableList = "Global,Labels,BStore,Thin,Base,Zoom,FastBase,FastZoom";
    public static final int EN_GLOBAL = 1;
    public static final int EN_LABELS = 2;
    public static final int EN_BSTORE = 4;
    public static final int EN_THIN = 8;
    public static final int EN_BASE = 16;
    public static final int EN_ZOOM = 32;
    public static final int EN_FASTBASE = 64;
    public static final int EN_FASTZOOM = 128;
    public static final int EN_DEFAULT = 255;
    public static final String axisList = "Show,Grid,Hscroll,Vscroll,Laxis,Ltics,Lnumbers,Llabels,Raxis,Rtics,Rnumbers,Rlabels,Taxis,Ttics,Tnumbers,Tlabels,Baxis,Btics,Bnumbers,Blabels,Oaxis,Otics,Onumbers,Olabels,gridFront,RotateVals,AutoRotate";
    public static final int G_SHOW = 1;
    public static final int G_GRID = 2;
    public static final int H_SBAR = 4;
    public static final int V_SBAR = 8;
    public static final int L_AXIS = 16;
    public static final int L_TICS = 32;
    public static final int L_NUMS = 64;
    public static final int L_LABS = 128;
    public static final int R_AXIS = 256;
    public static final int R_TICS = 512;
    public static final int R_NUMS = 1024;
    public static final int R_LABS = 2048;
    public static final int T_AXIS = 4096;
    public static final int T_TICS = 8192;
    public static final int T_NUMS = 16384;
    public static final int T_LABS = 32768;
    public static final int B_AXIS = 65536;
    public static final int B_TICS = 131072;
    public static final int B_NUMS = 262144;
    public static final int B_LABS = 524288;
    public static final int O_AXIS = 0x100000;
    public static final int O_TICS = 0x200000;
    public static final int O_NUMS = 0x400000;
    public static final int O_LABS = 0x800000;
    public static final int G_GRIDFRONT = 0x1000000;
    public static final int O_ROTATEVALS = 0x2000000;
    public static final int O_AUTOROTATE = 0x4000000;
    public static final String buttonActionList = "NONE,MENU,MARK_MESSAGE,UNZOOM";
    private static final int BTN_NONE = 1;
    private static final int BTN_MENU = 2;
    private static final int BTN_MARK_MESSAGE = 3;
    private static final int BTN_UNZOOM = 4;
    private static final int LMB_DEFAULT = 3;
    private static final int MMB_DEFAULT = 2;
    private static final int RMB_DEFAULT = 4;
    private int lmbButton = 3;
    private int mmbButton = 2;
    private int rmbButton = 4;
    public static final String axisMenu = "Default,Unlabeled,Numbered,Frame,TFrame,BFrame,TRFrame,BRFrame,TLFrame,BLFrame,~Grid,~Show,Modify,~Gridfront,~RotateVals,~AutoRotate";
    public static final int ALL_AXIS = 69904;
    public static final int V_TICS = 1634;
    public static final int H_TICS = 417794;
    private static final int A_DEFAULT = 505789;
    private static final int A_UNLABELED = 472893;
    private static final int A_FRAMED = 209725;
    private static final int A_NUMBERED = 279631;
    private static final int A_TFRAME = 226109;
    private static final int A_BFRAME = 471869;
    private static final int A_BRFRAME = 472893;
    private static final int A_TRFRAME = 227133;
    private static final int A_BLFRAME = 471933;
    private static final int A_TLFRAME = 226173;
    private String customXAxisLabel = null;
    private String customYAxisLabel = null;
    private String customZAxisLabel = null;
    static final int DO_CHECK = 0;
    static final int DO_DRAW = 1;
    static final int DO_BS = 2;
    static final int DO_NBS = 4;
    static final int DO_FORCE_DRAW = 8;
    private static final int PANX = 1;
    private static final int PANY = 2;
    private static final int PANXY = 3;
    private static final int SCROLLX = 4;
    private static final int SCROLLY = 5;
    private static final int PAN3D = 6;
    private static final int PANGEO = 7;
    private static final int ZOOM = 8;
    private static final int ZOOMIO = 9;
    private static final int PAN3DGRAPH = 10;
    private int level;
    private int lastLevel;
    public static final int X_ZOOM = 1;
    public static final int Y_ZOOM = 2;
    private static final int XY_ZOOM = 3;
    private static final double VERT_ROTATION = -1.5707963267948966;
    private static final int CHAR_WIDTH = 6;
    private static final int CHAR_HEIGHT = 10;
    private static final int LEVPARAM = 7;
    private static final int MAXLEV = 15;
    private static final int MAXPIX = 4096;
    static final int MSG_CONSUMED = 1;
    private PlotCanvas canvas;
    private boolean useMousePosition = false;
    static int LONGITUDE_DEFAULT_MIN = -180;
    static int LONGITUDE_DEFAULT_MAX = 180;
    static int LONGITUDE_CONTINUOUS_MIN = -180;
    static int LONGITUDE_CONTINUOUS_MAX = 540;
    public static int LONGITUDE_RANGE = 360;
    static int LATITUDE_DEFAULT_MIN = -90;
    static int LATITUDE_DEFAULT_MAX = 90;
    public static int LATITUDE_RANGE = 180;
    private boolean extendedRange = false;
    private FeatureGroupMap featureGroups;
    Feature elasticFeature = null;
    private boolean elasticFeatureSelected = false;
    private ResizeBox.Handle elasticHandle = ResizeBox.Handle.NONE;
    private Point currentMMBClickedLocation;
    @InternalUseOnly
    public static double FEATURE_SELECT_TOLERANCE = 0.05;
    private static final int doubleClickInterval;
    private LayerDrawable layerDrawable = null;
    private int numVisibleFeatures = 0;
    private double wmsLevel = -1.0;
    static final double HIGH_ZOOM_MXX;
    static final double HIGH_ZOOM_GEO_MXX = 8.947848529166667E8;
    static final double HIGH_ZOOM_GEO_MIN_SEMIS = 100000.0;
    private double llc_orx1 = LONGITUDE_DEFAULT_MAX;
    private double llc_orx2 = LONGITUDE_DEFAULT_MIN;
    private static boolean maxMapOnDragBox;
    private boolean dragboxAdjustment = false;
    private int wmsLayerCnt;
    private boolean baseIsLayer2DorImage;

    public MPlot(String name, MessageHandler mh) {
        super(name, mh);
    }

    @Override
    public void open() {
        super.open();
        this.addMouseWheelListener();
        if (this.fm != null) {
            this.tw = this.fm.charWidth('0');
            this.th = this.fm.getHeight();
            this.ta = this.fm.getAscent();
        }
        this.lastLevel = 0;
        this.level = 0;
        this.view = 0;
        this.ndz = 5;
        this.ndy = 5;
        this.ndx = 5;
        this.frz1 = 0.0;
        this.fry1 = 0.0;
        this.frx1 = 0.0;
        this.orz1 = 0.0;
        this.ory1 = 0.0;
        this.orx1 = 0.0;
        this.rz1 = 0.0;
        this.ry1 = 0.0;
        this.rx1 = 0.0;
        this.frz2 = 1.0;
        this.fry2 = 1.0;
        this.frx2 = 1.0;
        this.orz2 = 1.0;
        this.ory2 = 1.0;
        this.orx2 = 1.0;
        this.rz2 = 1.0;
        this.ry2 = 1.0;
        this.rx2 = 1.0;
        this.outerLimits = new Table();
        this.viewLimits = new Table();
        this.layers = new KeyVector(16);
        this.features = new KeyVector(16);
        this.featureGroups = new FeatureGroupMap();
        this.layerGrid = new LayerGrid();
        this.addLayer("GRID", this.layerGrid);
        this.viewer = this.view2D = new View(this);
        this.setView(0);
        this.setMode(0);
        this.setAxis(505789);
        this.setTime(0.0);
        this.setScale(3);
        int smartDefault = Theme.getOption(32) ? 8192 : 0;
        this.setOptions(smartDefault);
        this.setReadout(235930427, this.READOUT_OPTION_MAIN);
        this.setup();
        this.initValues = 0;
    }

    @Override
    public void close() {
        if (this.legend != null) {
            this.legend.close();
        }
        this.legend = null;
        super.close();
    }

    public Layer getBaseLayer() {
        if (this.baseLayer != null) {
            return this.baseLayer;
        }
        return (Layer)this.getLayers().get(1);
    }

    @InternalUseOnly
    public void setBaseLayer(Layer lay) {
        if (this.baseLayer != null && this.baseLayer.equals(lay)) {
            return;
        }
        this.baseIsLayer2DorImage = "Layer2D".equals(lay.getClassName()) || "LayerImage".equals(lay.getClassName());
        this.baseLayer = lay;
    }

    boolean isActingBaseLayer(Layer lay) {
        Layer layer1;
        if (lay == null || lay.name == null) {
            return false;
        }
        if (this.baseLayer != null) {
            return lay.name.equals(this.baseLayer.name);
        }
        KeyVector layers = this.getLayers();
        Layer layer = layer1 = layers != null ? (Layer)layers.get(1) : null;
        if (layer1 == null) {
            return false;
        }
        return lay.name.equals(layer1.name);
    }

    public KeyVector getLayers() {
        return this.layers;
    }

    public KeyVector getFeatures() {
        return this.features;
    }

    public Feature getSelectedFeature() {
        if (this.currentMMBClickedLocation == null) {
            return null;
        }
        MPoint pix1 = new MPoint(this.currentMMBClickedLocation.x, this.currentMMBClickedLocation.y);
        int[] pixLoc = new int[]{pix1.x, pix1.y};
        Feature closest = null;
        double closestDist = Double.MAX_VALUE;
        double maxDist = this.distanceBetween2DPoints(new int[]{this.ix1, this.iy1}, new int[]{this.ix2, this.iy2}) * FEATURE_SELECT_TOLERANCE;
        for (int i = 0; i < this.features.size(); ++i) {
            Feature currFeature = (Feature)this.features.get(i);
            double distance = this.distanceBetween2DPoints(pixLoc, currFeature.getPixelXY());
            if (!(distance < closestDist)) continue;
            closest = currFeature;
            closestDist = distance;
        }
        boolean within = closest != null ? closest.isAtPix(pix1, -1, -1) : false;
        return closestDist < maxDist || within ? closest : null;
    }

    private double distanceBetween2DPoints(int[] p1, int[] p2) {
        int xdelta = p1[0] - p2[0];
        int ydelta = p1[1] - p2[1];
        return Math.sqrt(xdelta * xdelta + ydelta * ydelta);
    }

    public boolean isSwing() {
        return this.isSwing;
    }

    public boolean isAxisIndex() {
        return this.axisIndex;
    }

    public void setAxisIndex(boolean val) {
        this.axisIndex = val;
    }

    public boolean setView(int arg) {
        return this.setView(arg, true, false);
    }

    public boolean setView(int arg, boolean doReset) {
        return this.setView(arg, doReset, false);
    }

    public boolean setView(int arg, boolean doReset, boolean forceReset) {
        this.initValues |= 2;
        if (!(arg != this.view || doReset && this.userView != this.view || forceReset)) {
            return false;
        }
        this.view = arg;
        if (doReset) {
            this.userView = this.view;
            this.unzoom(0, true);
            this.reset(-1);
        }
        if (this.view == 13) {
            if (this.viewGeo == null) {
                this.viewGeo = new ViewGeo(this);
            }
            this.viewer = this.viewGeo;
        } else if (this.view == 10) {
            if (this.viewPolar == null) {
                this.viewPolar = new ViewPolar(this);
            }
            this.viewer = this.viewPolar;
        } else if (this.view == 9 || this.view == 15) {
            if (this.view3D == null) {
                this.view3D = new View3D(this);
            }
            this.viewer = this.view3D;
            if (this.view == 15) {
                this.view3D.rotate(new double[]{60.0, 180.0, 110.0});
            }
        } else if (this.view == 12) {
            this.viewMerc = new ViewMercader(this);
            this.viewer = this.viewMerc;
        } else {
            this.viewer = this.view2D;
        }
        this.is2D = this.viewer == this.view2D || this.viewer == this.viewMerc;
        this.xvy = this.view >= 5 && this.view <= 8;
        this.setup();
        for (int i = 0; i < this.layers.size(); ++i) {
            ((Layer)this.layers.get(i)).update();
        }
        this.findRange();
        if (doReset) {
            this.useRange();
            this.setXYZUnits(-1, -1, this.zUnitsID, false);
        }
        if (this.view != 14) {
            this.extendedRange = false;
        }
        this.setup();
        this.refresh();
        this.viewLast = this.view;
        return true;
    }

    public boolean setView(String arg) {
        int v = Parser.find(viewList, arg, 0, 0, 2);
        return this.setView(v);
    }

    public boolean setMode(int arg) {
        return this.setMode(arg, true);
    }

    public boolean setMode(int arg, boolean rescale) {
        this.initValues |= 4;
        this.mode = arg;
        if (this.mode == this.modeLast) {
            return false;
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            ((Layer)this.layers.get(i)).update();
        }
        if (rescale) {
            this.rescale(true);
        }
        this.modeLast = this.mode;
        return true;
    }

    public boolean setMode(String arg) {
        int m = Parser.find(modeList, arg, 0, 0, 2);
        return this.setMode(m, true);
    }

    public void rescale(boolean doReset) {
        this.findRange();
        if (doReset) {
            this.useRange();
            this.reset(-1);
        }
        this.refresh();
    }

    public double getTime() {
        return this.time;
    }

    public boolean setTime(double arg) {
        this.initValues |= 0x10;
        if (arg == this.time) {
            return false;
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            ((Layer)this.layers.get(i)).setTime(arg);
        }
        this.time = arg;
        this.refresh();
        return true;
    }

    public void setDateFormat(int arg) {
        this.dateFormat = arg;
    }

    public void setDateFormat(String arg) {
        if ("AUTO".equals(arg.toUpperCase())) {
            this.dateFormat = DATE_FORMAT_AUTO;
        } else if ("DEFAULT".equals(arg.toUpperCase())) {
            this.dateFormat = DATE_FORMAT_DEFAULT;
        } else {
            this.dateFormat = Parser.find("Std,Acq,Epoch,Norad,TCR,Vax,Filename,HMS,YMD,ISO8601,Full_Std,AcqDate,AcqTime", arg, 0);
            if (this.dateFormat < 0) {
                this.dateFormat = DATE_FORMAT_SIMPLEDATEFORMAT;
                this.dateMFormat = MFormat.getDateFormatFor(arg);
            }
        }
    }

    public int getDateFormat() {
        return this.dateFormat;
    }

    private MFormat getDateFormat(boolean deriveFormat, int defaultFormat, int dp) {
        String tmax;
        String tmin;
        MFormat returnFormat = deriveFormat ? (this.dateFormat == DATE_FORMAT_AUTO ? ((tmin = Time.toString(this.getTMin(), 9)).equals(tmax = Time.toString(this.getTMax(), 9)) ? MFormat.getDateFormatFor(Parser.get("Std,Acq,Epoch,Norad,TCR,Vax,Filename,HMS,YMD,ISO8601,Full_Std,AcqDate,AcqTime", 8), dp) : MFormat.getDateFormatFor(Parser.get("Std,Acq,Epoch,Norad,TCR,Vax,Filename,HMS,YMD,ISO8601,Full_Std,AcqDate,AcqTime", 1), dp)) : (this.dateFormat == DATE_FORMAT_DEFAULT ? MFormat.getDateFormatFor(Parser.get("Std,Acq,Epoch,Norad,TCR,Vax,Filename,HMS,YMD,ISO8601,Full_Std,AcqDate,AcqTime", defaultFormat), dp) : (this.dateFormat == DATE_FORMAT_SIMPLEDATEFORMAT ? this.dateMFormat : MFormat.getDateFormatFor(Parser.get("Std,Acq,Epoch,Norad,TCR,Vax,Filename,HMS,YMD,ISO8601,Full_Std,AcqDate,AcqTime", this.dateFormat), dp)))) : MFormat.getDateFormatFor(Parser.get("Std,Acq,Epoch,Norad,TCR,Vax,Filename,HMS,YMD,ISO8601,Full_Std,AcqDate,AcqTime", defaultFormat), dp);
        return returnFormat;
    }

    public int getAxis() {
        return this.axis;
    }

    public boolean setAxis(int arg) {
        this.initValues |= 1;
        if (arg == this.axis) {
            return false;
        }
        this.axis = arg;
        this.setup();
        this.refresh();
        return true;
    }

    public boolean setAxis(String arg) {
        if (arg.equals("MODIFY")) {
            this.configure("AXIS.CFG");
            return false;
        }
        int flag = 0;
        int i = arg.indexOf(124);
        if (arg.startsWith("DEF")) {
            flag = 505789;
        } else if (arg.startsWith("UNL")) {
            flag = 472893;
        } else if (arg.startsWith("NUM")) {
            flag = 279631;
        } else if (arg.startsWith("FRA")) {
            flag = 209725;
        } else if (arg.startsWith("TF")) {
            flag = 226109;
        } else if (arg.startsWith("BF")) {
            flag = 471869;
        } else if (arg.startsWith("TRF")) {
            flag = 227133;
        } else if (arg.startsWith("BRF")) {
            flag = 472893;
        } else if (arg.startsWith("TLF")) {
            flag = 226173;
        } else if (arg.startsWith("BLF")) {
            flag = 471933;
        }
        if (flag == 0) {
            flag = Parser.mask(axisList, arg, this.axis);
        } else if (i > 0) {
            flag = Parser.mask(axisList, "+" + arg.substring(i), flag);
        }
        return this.setAxis(flag);
    }

    public int getReadout() {
        return this.readout;
    }

    public String getReadoutStr() {
        return Parser.mask2s(readoutList, this.readout);
    }

    public boolean setReadout(int arg) {
        return this.setReadout(arg, this.READOUT_OPTION_MAIN);
    }

    private boolean setReadout(int arg, int readoutOption) {
        boolean anyChanges;
        int readout = 0;
        if (readoutOption == this.READOUT_OPTION_MAIN) {
            readout = this.readout;
        } else if (readoutOption == this.READOUT_OPTION_EXT) {
            readout = this.readoutExt;
        }
        this.initValues |= 0x20;
        int axisFlag = readout & 4;
        if (arg == readout) {
            anyChanges = false;
        } else {
            if ((readout & 0x8000000) != 0 && (arg & 0x8000000) == 0 && (this.axis & 0x4000000) == 0) {
                this.setAxis("+autorotate");
            }
            if ((readout & 0x200000) == 0x200000) {
                if ((arg & 0x200000) != 0x200000) {
                    this.setPrecision(3);
                }
            } else if ((arg & 0x200000) == 0x200000) {
                this.setPrecision(6);
            }
            readout = arg;
            anyChanges = true;
            if (readoutOption == this.READOUT_OPTION_MAIN) {
                this.readout = readout;
            } else if (readoutOption == this.READOUT_OPTION_EXT) {
                this.readoutExt = readout;
            }
        }
        if ((readout & 4) != axisFlag && this.status != -2) {
            this.hardRefresh();
        }
        this.formatReadout(0);
        return anyChanges;
    }

    public boolean setReadout(String arg) {
        return this.setReadout(Parser.mask(readoutList, arg, this.readout), this.READOUT_OPTION_MAIN);
    }

    public boolean setReadoutExt(String arg) {
        return this.setReadout(Parser.mask(readoutListExt, arg, this.readoutExt), this.READOUT_OPTION_EXT);
    }

    public int getReadoutExt() {
        return this.readoutExt;
    }

    public boolean setReadoutFormat(String formatString) {
        boolean ok = true;
        if (formatString.equalsIgnoreCase("default")) {
            this.setPrecision(3);
        } else {
            try {
                this.nf = new DecimalFormat(formatString);
            }
            catch (IllegalArgumentException e) {
                ok = false;
            }
        }
        return ok;
    }

    public int getDRangeUnitsInt() {
        return this.dRangeUnits;
    }

    public String getDRangeUnits() {
        return Parser.get("M,KM,NMI", this.dRangeUnits);
    }

    public boolean setDRangeUnits(int units) {
        boolean ok = false;
        if (units > 0) {
            this.dRangeUnits = units;
            ok = true;
        }
        return ok;
    }

    public boolean setDRangeUnits(String units) {
        int iUnits = Parser.find("M,KM,NMI", units, 0, 0, 2);
        return this.setDRangeUnits(iUnits);
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean setPrecision(int prec) {
        if (this.precision == prec) {
            return false;
        }
        this.precision = prec;
        this.readout = prec == 6 ? (this.readout |= 0x200000) : (this.readout &= 0xFFDFFFFF);
        if (prec <= 0) {
            this.nf = new DecimalFormat("###0");
        } else {
            String tmp = "###0.";
            while (prec-- > 0) {
                tmp = tmp + "#";
            }
            this.nf = new DecimalFormat(tmp);
        }
        return true;
    }

    public boolean setScale(int arg) {
        this.initValues |= 8;
        if (arg == this.scale) {
            return false;
        }
        this.scale = arg;
        this.setup();
        this.refresh();
        return true;
    }

    public boolean setScale(String arg) {
        int flag = arg.length() == 0 ? this.scale : (arg.equals("FIX") ? 0 : (arg.equals("FULL") ? 3 : (arg.equals("AUTO") ? 3 : (arg.equals("RANGE") ? 12 : Parser.mask(scaleList, arg, this.scale)))));
        return this.setScale(flag);
    }

    public boolean setRange(double arg) {
        if ((this.scale & 0x28) == 0) {
            this.scale |= 8;
        }
        return this.setMaxRange(arg);
    }

    public double getMaxRange() {
        return this.maxRange;
    }

    public boolean setMaxRange(double arg) {
        if (Tolerance.equals(arg, this.maxRange)) {
            return false;
        }
        this.maxRange = arg;
        return true;
    }

    public double getMinRange() {
        return this.minRange;
    }

    public boolean setMinRange(double arg) {
        if (Tolerance.equals(arg, this.minRange)) {
            return false;
        }
        this.minRange = arg;
        return true;
    }

    public boolean autoScale(int mask, boolean eval) {
        double a1 = 0.0;
        double a2 = 0.0;
        boolean zaxis = false;
        boolean rescale = false;
        for (int n = 1; n < this.layers.size(); ++n) {
            Layer lay = (Layer)this.layers.get(n);
            if (lay == null || (this.scale & lay.scaleable) == 0 || (mask & 1 << n) == 0) continue;
            if (eval) {
                lay.findRange();
            }
            if (n == 1) {
                a1 = lay.a1;
                a2 = lay.a2;
            } else {
                a1 = Math.min(a1, lay.a1);
                a2 = Math.max(a2, lay.a2);
            }
            zaxis |= lay.zaxis;
        }
        if ((this.scale & 0xC) == 12) {
            if (a2 - a1 > this.maxRange) {
                a1 = a2 - this.maxRange;
            }
            if (a2 - a1 < this.minRange) {
                a1 = a2 - this.minRange;
            }
        } else if ((this.scale & 0xC) == 8) {
            a1 = a2 - this.maxRange;
        } else if ((this.scale & 0xC) == 4) {
            a2 = a1 + this.minRange;
        }
        if (zaxis) {
            double r = 0.05 * (this.orz2 - this.orz1);
            if ((this.scale & 0xE) != 0) {
                if ((this.scale & 0x40) != 0) {
                    this.rz2 = this.orz2 = a2;
                    rescale = true;
                } else if (a2 > this.orz2) {
                    this.rz2 = this.orz2 = a2 + r;
                    rescale = true;
                } else if (a2 < this.orz2 - r * 2.0) {
                    this.rz2 = this.orz2 = a2 + r;
                    rescale = true;
                } else if (!Tolerance.equalsWithTolerance(this.rz2, this.orz2)) {
                    this.rz2 = this.orz2;
                    rescale = true;
                }
            }
            if ((this.scale & 0xD) != 0) {
                if ((this.scale & 0x40) != 0) {
                    this.rz1 = this.orz1 = a1;
                    rescale = true;
                } else if (a1 < this.orz1) {
                    this.rz1 = this.orz1 = a1 - r;
                    rescale = true;
                } else if (a1 > this.orz1 + r * 2.0) {
                    this.rz1 = this.orz1 = a1 - r;
                    rescale = true;
                } else if (!Tolerance.equalsWithTolerance(this.rz2, this.orz2)) {
                    this.rz1 = this.orz1;
                    rescale = true;
                }
            }
            if (this.rz1 == this.rz2) {
                double zUlp = Math.ceil(Math.ulp((float)this.rz1));
                this.rz1 -= zUlp;
                this.rz2 += zUlp;
            }
        } else {
            boolean xmargin = this.rx2 > this.orx2 + 0.01;
            double r = 0.05 * (this.ory2 - this.ory1);
            if ((this.scale & 0xE) != 0) {
                if (a2 > this.ory2) {
                    this.ry2 = this.ory2 = a2 + r;
                    rescale = true;
                } else if (a2 < this.ory2 - r * 2.0) {
                    this.ry2 = this.ory2 = a2 + r;
                    rescale = true;
                } else if (this.ry2 > this.ory2 + 1.0E-5 && xmargin) {
                    this.ry2 = this.ory2;
                    rescale = true;
                }
            }
            if ((this.scale & 0xD) != 0) {
                if (a1 < this.ory1) {
                    this.ry1 = this.ory1 = a1 - r;
                    rescale = true;
                } else if (a1 > this.ory1 + r * 2.0) {
                    this.ry1 = this.ory1 = a1 - r;
                    rescale = true;
                } else if (this.ry1 < this.ory1 - 1.0E-5 && xmargin) {
                    this.ry1 = this.ory1;
                    rescale = true;
                }
            }
            if (this.ry1 == this.ry2) {
                double yUlp = Math.ceil(Math.ulp((float)this.ry1));
                this.ry1 -= yUlp;
                this.ry2 += yUlp;
            }
        }
        boolean bl = rescale = rescale && !zaxis && this.level == 0;
        if (rescale || this.view == 15) {
            this.setup();
        }
        return rescale;
    }

    public boolean setOptions(int arg) {
        if (arg == this.options) {
            return false;
        }
        if (this.checkForCut(arg)) {
            return true;
        }
        if ((arg & 1) != 0) {
            for (int i = 1; i < this.layers.size(); ++i) {
                Layer lay = (Layer)this.layers.get(i);
                if (!lay.realtime || !lay.isEnabled(-1)) continue;
                Shell.warning("Backing Store not recommended for Realtime (piped) data due to potential Graphics artifacts! lay = " + lay + " enable = " + lay.getEnableString());
            }
        }
        this.options = arg;
        if ((this.options & 0x2000) == 0 && !Theme.getOption(8)) {
            Shell.warning("Turning off image double buffering when running with regular Swing graphics may cause graphical lock-up or sluggishness - options are now set to: " + this.getOptions() + " for " + this.title);
        }
        this.setup();
        return true;
    }

    private String getOptions() {
        return Parser.mask2s(optionsList, this.options);
    }

    private void validateOptions(String arg) {
        String[] arr;
        for (String value : arr = arg.split("\\|")) {
            if (value.length() < 1 || value.substring(0, 1).matches("(\\+|\\-|\\~).*")) continue;
            if ((Parser.mask(optionsList, arg, this.options) & this.options) == this.options) break;
            Shell.warning("MPlot.setOptions: Setting options without +|-|~, overriding previous option of " + this.getOptions() + " with " + arg);
            break;
        }
    }

    public boolean setOptions(String arg) {
        if ((warningsMask & 2) != 0) {
            this.validateOptions(arg);
        }
        return this.setOptions(Parser.mask(optionsList, arg, this.options));
    }

    public boolean getOption(int mask) {
        return (this.options & mask) != 0;
    }

    private boolean checkForCut(int arg) {
        boolean isYCut;
        boolean isXCut = (arg & 0x20) != 0;
        boolean bl = isYCut = (arg & 0x40) != 0;
        if (isXCut || isYCut) {
            Message msg = null;
            Table data = new Table("{IX=" + this.px + ", IY=" + this.py + "}");
            if (isXCut) {
                msg = new Message("XCUT", 0, data);
            } else if (isYCut) {
                msg = new Message("YCUT", 0, data);
            }
            if (msg != null) {
                this.mh.processMessage(msg);
                return true;
            }
        }
        return false;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (this.level == 0) {
            this.useRange();
        }
        this.setup();
    }

    private String translateLimitsKey(String key) {
        String res = key.toUpperCase();
        if (res.equals("X1") || res.equals("X2") || res.equals("Y1") || res.equals("Y2") || res.equals("Z1") || res.equals("Z2")) {
            return res;
        }
        res = res.endsWith("MIN") ? res.charAt(0) + "1" : (res.endsWith("MAX") ? res.charAt(0) + "2" : key);
        return res;
    }

    public void setOuterLimits(String key, double value) {
        key = this.translateLimitsKey(key);
        this.setUserLimits(key, value, true);
    }

    public void setOuterLimits(Table tbl) {
        for (String key : tbl.getKeys()) {
            key = this.translateLimitsKey(key);
            this.setOuterLimits(key, tbl.getD(key));
        }
    }

    public Table getOuterLimits() {
        return this.outerLimits;
    }

    public Table getOuterBounds() {
        Table outerBounds = new Table();
        outerBounds.put("X1", this.orx1);
        outerBounds.put("X2", this.orx2);
        outerBounds.put("Y1", this.ory1);
        outerBounds.put("Y2", this.ory2);
        return outerBounds;
    }

    public double getOuterLimits(String key) {
        return this.outerLimits.getD(key);
    }

    public void setViewLimits(String key, double value) {
        key = this.translateLimitsKey(key);
        this.setUserLimits(key, value, false);
    }

    public void setViewLimits(Table tbl) {
        for (String key : tbl.getKeys()) {
            key = this.translateLimitsKey(key);
            this.setViewLimits(key, tbl.getD(key));
        }
    }

    public Table getViewLimits() {
        return this.viewLimits;
    }

    public double getViewLimits(String key) {
        return this.viewLimits.getD(key);
    }

    public void setUserLimits(String key, double value, boolean outer) {
        if ((key = this.translateLimitsKey(key)).equals("X1") || key.equals("Y1")) {
            value -= this.axisBuffer;
        } else if (key.equals("X2") || key.equals("Y2")) {
            value += this.axisBuffer;
        }
        if (key.equals("X1") || key.equals("X2") || key.equals("Y1") || key.equals("Y2") || key.equals("Z1") || key.equals("Z2")) {
            if (outer) {
                this.outerLimits.put(key, value);
            } else {
                this.viewLimits.put(key, value);
            }
        } else {
            Shell.warning("Invalid bounds identifier [" + key + "]. Must be in X1, X2, Y1, Y2, Z1, Z2, XMIN, XMAX, YMIN, YMAX, ZMIN, or ZMAX.");
        }
    }

    public void removeLimit(String key, boolean outer) {
        if ((key = this.translateLimitsKey(key)).equals("X1") || key.equals("X2") || key.equals("Y1") || key.equals("Y2") || key.equals("Z1") || key.equals("Z2")) {
            if (outer) {
                this.outerLimits.remove(key);
            } else {
                this.viewLimits.remove(key);
            }
        } else {
            Shell.warning("Invalid bounds identifier [" + key + "]. Must be in X1, X2, Y1, Y2, Z1, Z2, XMIN, XMAX, YMIN, YMAX, ZMIN, or ZMAX.");
        }
    }

    public void loadLimits(String filename) {
        FileName fnFilename = new FileName(filename, FileName.FNCase.KeepCase);
        TextFile tf = new TextFile(fnFilename);
        Table t = new Table();
        t.fromTextFile(tf);
        this.loadLimits(t);
    }

    public void loadLimits(Table table) {
        if (table == null) {
            return;
        }
        Object outerBoundsTbl = table.get("OUTERBOUNDS");
        Object viewLimitsTbl = table.get("VIEWLIMITS");
        if (outerBoundsTbl instanceof Table) {
            this.setOuterLimits((Table)outerBoundsTbl);
            this.applyUserBounds("OUTER");
        }
        if (viewLimitsTbl instanceof Table) {
            this.setViewLimits((Table)viewLimitsTbl);
            this.applyUserBounds("VIEW");
        }
    }

    public void saveLimits(String filename) {
        if (filename.indexOf(46) < 0) {
            filename = filename + ".tbl";
        }
        Table lt = new Table();
        lt.put("OUTERBOUNDS", (Object)this.getOuterBounds());
        lt.put("VIEWLIMITS", (Object)this.viewLimits);
        FileName fnFilename = new FileName(filename, FileName.FNCase.KeepCase);
        TextFile tf = new TextFile(fnFilename);
        lt.toTextFile(tf);
        Shell.info("Saved OUTERBOUNDS and VIEWLIMITS to: " + tf.getURL());
    }

    public double getOuterXMin() {
        return this.orx1;
    }

    public double getOuterXMax() {
        return this.orx2;
    }

    public void setAxisBuffer(double value) {
        this.axisBuffer = value;
    }

    public double getAxisBuffer() {
        return this.axisBuffer;
    }

    public void setXMin(double r1) {
        this.setXBounds(r1, r1 + this.rx2 - this.rx1, true, false);
    }

    public void setX1(double r1) {
        this.setXMin(r1);
    }

    public void setXMax(double r2) {
        this.setXBounds(this.rx1, r2);
    }

    public void setX2(double r2) {
        this.setXMax(r2);
    }

    public void setXBounds(double r1, double r2) {
        this.setXBounds(r1, r2, true, true);
    }

    private void setXBounds(double r1, double r2, boolean applyX1, boolean applyX2) {
        if (r1 == this.rx1 && this.rx1 != 0.0 && r2 == this.rx2 && this.rx2 != 1.0) {
            return;
        }
        double tmprx1 = Math.min(r1, r2);
        double tmprx2 = Math.max(r1, r2);
        if (tmprx1 == 0.0 || !Tolerance.equals(tmprx1, this.rx1)) {
            this.rx1 = tmprx1;
            if (applyX1) {
                this.setUserLimits("X1", this.rx1, false);
            }
        }
        if (tmprx2 == 1.0 || !Tolerance.equals(tmprx2, this.rx2)) {
            this.rx2 = tmprx2;
            if (applyX2) {
                this.setUserLimits("X2", this.rx2, false);
            }
        }
        this.checkBounds("RX", true);
        this.setup();
        this.refresh();
    }

    public double[] getXBounds() {
        double[] xview = new double[]{this.rx1, this.rx2};
        return xview;
    }

    @Deprecated
    public void setX(double r1, double r2) {
        this.setXBounds(r1, r2);
    }

    public double getXMin() {
        return this.rx1;
    }

    public double getX1() {
        return this.getXMin();
    }

    public double getXMax() {
        return this.rx2;
    }

    public double getX2() {
        return this.getXMax();
    }

    public void setY1(double r1) {
        this.setYMin(r1);
    }

    public void setYMin(double r1) {
        this.setYBounds(r1, r1 + this.ry2 - this.ry1, true, false);
    }

    public void setY2(double r2) {
        this.setYMax(r2);
    }

    public void setYMax(double r2) {
        this.setYBounds(this.ry1, r2);
    }

    @Deprecated
    public void setY(double r1, double r2) {
        this.setYBounds(r1, r2);
    }

    public void setYBounds(double r1, double r2) {
        this.setYBounds(r1, r2, true, true);
    }

    private void setYBounds(double r1, double r2, boolean applyY1, boolean applyY2) {
        if (r1 == this.ry1 && this.ry1 != 0.0 && r2 == this.ry2 && this.ry2 != 1.0) {
            return;
        }
        double tmpry1 = Math.min(r1, r2);
        double tmpry2 = Math.max(r1, r2);
        if (tmpry1 == 0.0 || !Tolerance.equals(tmpry1, this.ry1)) {
            this.ry1 = tmpry1;
            if (applyY1) {
                this.setUserLimits("Y1", this.ry1, false);
            }
        }
        if (tmpry2 == 1.0 || !Tolerance.equals(tmpry2, this.ry2)) {
            this.ry2 = tmpry2;
            if (applyY2) {
                this.setUserLimits("Y2", this.ry2, false);
            }
        }
        this.checkBounds("RY", true);
        this.setup();
        this.refresh();
    }

    public double[] getYBounds() {
        double[] yview = new double[]{this.ry1, this.ry2};
        return yview;
    }

    public double getY1() {
        return this.getYMin();
    }

    public double getYMin() {
        return this.ry1;
    }

    public double getY2() {
        return this.getYMax();
    }

    public double getYMax() {
        return this.ry2;
    }

    public double getT1() {
        return this.getTMin();
    }

    public double getTMin() {
        double t = this.ry1;
        Layer lay = this.getBaseLayer();
        if (lay != null) {
            t = lay.getTime(this.ix1, this.iy1);
        }
        return t;
    }

    public double getT2() {
        return this.getTMax();
    }

    public double getTMax() {
        double t = this.ry2;
        Layer lay = this.getBaseLayer();
        if (lay != null) {
            t = lay.getTime(this.ix2, this.iy2);
        }
        return t;
    }

    public void setXYBounds(double x1, double x2, double y1, double y2) {
        this.setXYBounds(x1, x2, y1, y2, true);
    }

    public void setXYBounds(double x1, double x2, double y1, double y2, boolean refresh) {
        double tmprx1 = Math.min(x1, x2);
        double tmprx2 = Math.max(x1, x2);
        double tmpry1 = Math.min(y1, y2);
        double tmpry2 = Math.max(y1, y2);
        double tmprx1ForBounds = tmprx1;
        double tmprx2ForBounds = tmprx2;
        double tmpry1ForBounds = tmpry1;
        double tmpry2ForBounds = tmpry2;
        if (this.view == 14) {
            tmprx1ForBounds = Math.max(tmprx1ForBounds, this.orx1);
            tmprx2ForBounds = Math.min(tmprx2ForBounds, this.orx2);
            tmpry1ForBounds = Math.max(tmpry1ForBounds, this.ory1);
            tmpry2ForBounds = Math.min(tmpry2ForBounds, this.ory2);
        }
        if (tmprx1 == 0.0 || !Tolerance.equals(this.rx1, tmprx1)) {
            this.rx1 = tmprx1;
            this.setUserLimits("X1", tmprx1ForBounds, false);
        }
        if (tmprx2 == 1.0 || !Tolerance.equals(this.rx2, tmprx2)) {
            this.rx2 = tmprx2;
            this.setUserLimits("X2", tmprx2ForBounds, false);
        }
        if (tmpry1 == 0.0 || !Tolerance.equals(this.ry1, tmpry1)) {
            this.ry1 = tmpry1;
            this.setUserLimits("Y1", tmpry1ForBounds, false);
        }
        if (tmpry2 == 1.0 || !Tolerance.equals(this.ry2, tmpry2)) {
            this.ry2 = tmpry2;
            this.setUserLimits("Y2", tmpry2ForBounds, false);
        }
        this.checkBounds("RX", true);
        this.checkBounds("RY", true);
        if (refresh) {
            this.setup();
            this.refresh();
        }
    }

    public void setXY(double x1, double x2, double y1, double y2) {
        this.setXYBounds(x1, x2, y1, y2, true);
    }

    public void setXY(double x1, double x2, double y1, double y2, boolean refresh) {
        this.setXYBounds(x1, x2, y1, y2, refresh);
    }

    public double[] getXY() {
        return this.getXYBounds();
    }

    public double[] getXYBounds() {
        double[] nbox = new double[]{this.rx1, this.rx2, this.ry1, this.ry2};
        return nbox;
    }

    public double[] getXYGrid(double gx1, double gx2, double gy1, double gy2) {
        double ax1 = this.rx1;
        double ax2 = this.rx2;
        double ay1 = this.ry1;
        double ay2 = this.ry2;
        if (this.view == 11 || this.view == 12) {
            ax1 = Math.max(ax1, -180.0);
            ax2 = Math.min(ax2, 180.0);
            ay1 = Math.max(ay1, -90.0);
            ay2 = Math.min(ay2, 90.0);
        } else if (this.view == 14) {
            ax1 = Math.max(ax1, this.orx1);
            ax2 = Math.min(ax2, this.orx2);
            ay1 = Math.max(ay1, -90.0);
            ay2 = Math.min(ay2, 90.0);
        } else if (this.view == 13) {
            Position p = this.getPosition(this.ix1, this.iy1);
            ax1 = ax2 = p.lon;
            ay1 = ay2 = p.lat;
            p = this.getPosition(this.ix2, this.iy1);
            ax1 = Math.min(ax1, p.lon);
            ax2 = Math.max(ax2, p.lon);
            ay1 = Math.min(ay1, p.lat);
            ay2 = Math.max(ay2, p.lat);
            p = this.getPosition(this.ix2, this.iy2);
            ax1 = Math.min(ax1, p.lon);
            ax2 = Math.max(ax2, p.lon);
            ay1 = Math.min(ay1, p.lat);
            ay2 = Math.max(ay2, p.lat);
            p = this.getPosition(this.ix1, this.iy2);
            ax1 = Math.min(ax1, p.lon);
            ax2 = Math.max(ax2, p.lon);
            ay1 = Math.min(ay1, p.lat);
            ay2 = Math.max(ay2, p.lat);
            int ixh = (this.ix1 + this.ix2) / 2;
            int iyh = (this.iy1 + this.iy2) / 2;
            p = this.getPosition(ixh, this.iy1);
            ax1 = Math.min(ax1, p.lon);
            ax2 = Math.max(ax2, p.lon);
            ay1 = Math.min(ay1, p.lat);
            ay2 = Math.max(ay2, p.lat);
            p = this.getPosition(ixh, this.iy2);
            ax1 = Math.min(ax1, p.lon);
            ax2 = Math.max(ax2, p.lon);
            ay1 = Math.min(ay1, p.lat);
            ay2 = Math.max(ay2, p.lat);
            p = this.getPosition(this.ix1, iyh);
            ax1 = Math.min(ax1, p.lon);
            ax2 = Math.max(ax2, p.lon);
            ay1 = Math.min(ay1, p.lat);
            ay2 = Math.max(ay2, p.lat);
            p = this.getPosition(this.ix2, iyh);
            ax1 = Math.min(ax1, p.lon);
            ax2 = Math.max(ax2, p.lon);
            ay1 = Math.min(ay1, p.lat);
            ay2 = Math.max(ay2, p.lat);
            if (ax2 - ax1 > 180.0) {
                ax1 = -180.0;
                ax2 = 180.0;
                if (this.viewGeo.lat > 0.0) {
                    ay2 = 90.0;
                } else {
                    ay1 = -90.0;
                }
            }
        }
        double[] gridBox = new double[]{Math.max(gx1, ax1), Math.min(gx2, ax2), Math.max(gy1, ay1), Math.min(gy2, ay2)};
        return gridBox;
    }

    public void setZ1(double r1) {
        this.setZMin(r1);
    }

    public void setZMin(double r1) {
        this.setZBounds(r1, r1 + this.rz2 - this.rz1, true, false);
    }

    public void setZ2(double r2) {
        this.setZMax(r2);
    }

    public void setZMax(double r2) {
        this.setZBounds(this.rz1, r2, false, true);
    }

    public void setZBounds(double r1, double r2) {
        this.setZBounds(r1, r2, true, true);
    }

    private void setZBounds(double r1, double r2, boolean applyZ1, boolean applyZ2) {
        double tmprz1 = Math.min(r1, r2);
        double tmprz2 = Math.max(r1, r2);
        if (tmprz1 == 0.0 || !Tolerance.equals(this.rz1, tmprz1)) {
            this.rz1 = tmprz1;
            this.setUserLimits("Z1", this.rz1, false);
        }
        if (tmprz2 == 1.0 || !Tolerance.equals(this.rz2, tmprz2)) {
            this.rz2 = tmprz2;
            this.setUserLimits("Z2", this.rz2, false);
        }
        for (int i = 1; i < this.layers.size(); ++i) {
            Layer l = (Layer)this.layers.get(i);
            if (applyZ1) {
                l.setUseMPlotZMin(true);
            }
            if (!applyZ2) continue;
            l.setUseMPlotZMax(true);
        }
        this.setup();
        this.refresh();
    }

    public double[] getZBounds() {
        double[] zview = new double[]{this.rz1, this.rz2};
        return zview;
    }

    @Deprecated
    public void setZ(double r1, double r2) {
        this.setZBounds(r1, r2);
    }

    public double getZ1() {
        return this.getZMin();
    }

    public double getZMin() {
        return this.rz1;
    }

    public double getZ2() {
        return this.getZMax();
    }

    public double getZMax() {
        return this.rz2;
    }

    public void setTimeAlign(boolean val) {
        for (int i = 2; i < this.getLayers().getSize(); ++i) {
            Layer lay = (Layer)this.getLayers().get(i);
            if (lay == null) continue;
            lay.setTimeAlign(val);
        }
    }

    public boolean isTimeAlign() {
        if (this.getLayers().getSize() < 3) {
            return false;
        }
        for (int i = 2; i < this.getLayers().getSize(); ++i) {
            Layer lay = (Layer)this.getLayers().get(i);
            if (!lay.isTimeAlign()) continue;
            return true;
        }
        return false;
    }

    public void setDiv(int x, int y, int z) {
        this.setAxisDiv(x, y, z);
    }

    public void setAxisDiv(int x, int y, int z) {
        this.ndx = x;
        this.ndy = y;
        this.ndz = z;
    }

    public void setFS(int frame) {
        this.setFrameSize(frame);
    }

    public void setFrameSize(int frame) {
        Layer lay = this.getBaseLayer();
        if (lay == null) {
            return;
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            lay = (Layer)this.layers.get(i);
            lay.setFrame(frame);
        }
        this.refresh();
    }

    public void setRXD(double freq) {
        this.setRXDelta(freq);
    }

    public void setRXDelta(double freq) {
        Layer lay = this.getBaseLayer();
        if (lay == null) {
            return;
        }
        int frame = lay.frame & 0xFFFFFFFE;
        this.setXDelta(freq / 2.0 / (double)frame);
    }

    public void setXStart(double value) {
        if (this.layers == null) {
            Shell.warning("No Layer plotted. Cannot set XStart.");
            return;
        }
        Layer lay = this.getBaseLayer();
        if (lay == null) {
            return;
        }
        this.unzoom(0);
        this.setXBounds(value, value + Math.abs(this.rx2 - this.rx1), true, false);
        for (int i = 0; i < this.layers.size(); ++i) {
            lay = (Layer)this.layers.get(i);
            lay.setXAxis(value, lay.xdelta);
        }
        this.refresh();
    }

    public double getXStart() {
        if (this.layers == null || this.getBaseLayer() == null) {
            Shell.warning("MPlot: No Layer plotted. Cannot get XStart value. Returning NaN");
            return Double.NaN;
        }
        return this.getBaseLayer().getXStart();
    }

    public double getXStart(int layer) {
        return ((Layer)this.layers.get(layer)).getXStart();
    }

    public void setYStart(double value) {
        Layer lay = this.getBaseLayer();
        if (lay == null) {
            return;
        }
        this.unzoom(0);
        this.setYBounds(value, value + Math.abs(this.ry2 - this.ry1), true, false);
        for (int i = 0; i < this.layers.size(); ++i) {
            lay = (Layer)this.layers.get(i);
            lay.setYAxis(value, lay.ydelta);
        }
        this.refresh();
    }

    public double getYStart() {
        return this.getBaseLayer().getYStart();
    }

    public double getYStart(int layer) {
        return ((Layer)this.layers.get(layer)).getYStart();
    }

    public void setZStart(double value) {
        Layer lay = this.getBaseLayer();
        if (lay == null) {
            return;
        }
        this.unzoom(0);
        this.setZMin(value);
        for (int i = 0; i < this.layers.size(); ++i) {
            lay = (Layer)this.layers.get(i);
            lay.setYAxis(value, lay.zdelta);
        }
        this.needRefresh = true;
    }

    public double getZStart() {
        return this.getBaseLayer().getZStart();
    }

    public double getZStart(int layer) {
        return ((Layer)this.layers.get(layer)).getZStart();
    }

    public void setXDelta(double delta) {
        Layer lay = this.getBaseLayer();
        if (lay == null) {
            return;
        }
        this.unzoom(0);
        int frame = lay.frame & 0xFFFFFFFE;
        double xd = delta;
        double xs = lay.xstart;
        if (xs < 0.0) {
            xs = -xd * (double)frame / 2.0;
        }
        this.orx1 = this.rx1 = xs;
        this.orx2 = this.rx2 = this.rx1 + xd * (double)lay.frame;
        this.setup();
        for (int i = 0; i < this.layers.size(); ++i) {
            ((Layer)this.layers.get(i)).setXAxis(xs, xd);
        }
        this.refresh();
    }

    public double getXDelta() {
        return this.getBaseLayer().getXDelta();
    }

    public double getXDelta(int layer) {
        return ((Layer)this.layers.get(layer)).getXDelta();
    }

    public final DragBox getZoomBounds() {
        return this.getZoomBounds(this.level);
    }

    public DragBox getZoomBounds(int zoomLevel) {
        DragBox boxObj = null;
        if (zoomLevel == this.level) {
            boxObj = new DragBox(this.rx1, this.rx2, this.ry1, this.ry2);
        } else if (zoomLevel >= 0 && zoomLevel > this.level) {
            int i = this.level * 7;
            boxObj = new DragBox(this.rstk[i + 0], this.rstk[i + 1], this.rstk[i + 2], this.rstk[i + 3]);
        }
        return boxObj;
    }

    public int getZoomLevel() {
        return this.level;
    }

    public void resize() {
        this.reset(-1);
        this.resizing = true;
        this.setup();
        this.resizing = false;
        this.refresh();
        if (this.MW != null) {
            this.MW.panel.revalidate();
        } else {
            this.panel.revalidate();
        }
    }

    @Override
    public void setup() {
        this.viewer.setup();
        this.ix1 = 0;
        this.ix2 = this.pos.w;
        this.iy1 = 0;
        this.iy2 = this.pos.h;
        this.oarbox.setBounds(0, this.pos.h - this.th, this.pos.w, this.th);
        if ((this.axis & 1) != 0) {
            if ((this.axis & 0xD0) != 0) {
                this.ix1 += 6;
            }
            if ((this.axis & 0xD00) != 0) {
                this.ix2 -= 6;
            }
            if ((this.axis & 0xD000) != 0) {
                this.iy1 += 6;
            }
            if ((this.axis & 0xD0000) != 0) {
                this.iy2 -= 6;
            }
            if ((this.axis & 0x40) != 0) {
                this.ix1 += this.tw * 4;
            }
            if ((this.axis & 0x80) != 0) {
                this.ix1 += this.th + 4;
            }
            if ((this.axis & 0x400) != 0) {
                this.ix2 -= this.tw * 4;
            }
            if ((this.axis & 0x800) != 0) {
                this.ix2 -= this.th;
            }
            if ((this.axis & 0x4000) != 0) {
                this.iy1 += this.th;
            }
            if ((this.axis & 0x8000) != 0) {
                this.iy1 += this.th;
            }
            if ((this.axis & 0x40000) != 0) {
                this.iy2 -= this.th;
            }
            if ((this.axis & 0x80000) != 0) {
                this.iy2 -= this.th;
            }
            if ((this.readout & 4) != 0) {
                this.iy2 -= this.th;
            }
        }
        this.ix21 = this.ix2 - this.ix1;
        this.iy21 = this.iy2 - this.iy1;
        this.setAspect();
        if (this.xvy) {
            this.myy = (double)(this.ix2 - this.ix1) / (this.ry2 - this.ry1);
            this.myb = (double)this.ix1 - this.ry1 * this.myy;
            if (this.view == 7 || this.view == 8) {
                this.myy = -this.myy;
                this.myb = (double)this.ix2 - this.ry1 * this.myy;
            }
            this.mxx = (double)(this.iy1 - this.iy2) / (this.rx2 - this.rx1);
            this.mxb = (double)this.iy2 - this.rx1 * this.mxx;
            if (this.view == 6 || this.view == 8) {
                this.mxx = -this.mxx;
                this.mxb = (double)this.iy1 - this.rx1 * this.mxx;
            }
        } else {
            double p = 0.12;
            if (this.view == 14) {
                if ((this.rx1 < (double)LONGITUDE_DEFAULT_MIN - p || this.rx2 > (double)LONGITUDE_DEFAULT_MAX + p) && this.view == 14) {
                    this.extendedRange = true;
                }
                if (this.rx1 < this.orx1 - p || this.rx2 > this.orx2 + p) {
                    if (this.rx2 - this.rx1 < (double)LONGITUDE_RANGE - p) {
                        if (this.rx1 < (double)LONGITUDE_CONTINUOUS_MIN - p) {
                            this.rx1 = this.orx1 = this.rx1 + (double)LONGITUDE_RANGE;
                            this.rx2 += (double)LONGITUDE_RANGE;
                            this.orx2 = this.rx1 + (double)LONGITUDE_RANGE;
                        } else if (this.rx2 > (double)LONGITUDE_CONTINUOUS_MAX + p) {
                            this.rx2 = this.orx2 = this.rx2 - (double)LONGITUDE_RANGE;
                            this.rx1 -= (double)LONGITUDE_RANGE;
                            this.orx1 = this.rx2 - (double)LONGITUDE_RANGE;
                        } else if (this.rx1 < this.orx1 - p) {
                            this.orx1 = this.rx1;
                            this.orx2 = this.orx1 + (double)LONGITUDE_RANGE;
                        } else if (this.rx2 > this.orx2 + p) {
                            this.orx2 = this.rx2;
                            this.orx1 = this.orx2 - (double)LONGITUDE_RANGE;
                        }
                    } else if (this.orx2 - this.orx1 < this.rx2 - this.rx1 - p) {
                        double midX = (this.rx2 + this.rx1) / 2.0;
                        if (midX < 0.0) {
                            midX += (double)LONGITUDE_RANGE;
                            this.rx1 += (double)LONGITUDE_RANGE;
                            this.rx2 += (double)LONGITUDE_RANGE;
                        } else if (midX > (double)(LONGITUDE_CONTINUOUS_MAX - LONGITUDE_DEFAULT_MAX)) {
                            midX -= (double)LONGITUDE_RANGE;
                            this.rx1 -= (double)LONGITUDE_RANGE;
                            this.rx2 -= (double)LONGITUDE_RANGE;
                        }
                        this.orx1 = midX + (double)LONGITUDE_DEFAULT_MIN;
                        this.orx2 = midX + (double)LONGITUDE_DEFAULT_MAX;
                    }
                }
            }
            this.mxx = (double)(this.ix2 - this.ix1) / (this.rx2 - this.rx1);
            this.mxb = (double)this.ix1 - this.rx1 * this.mxx;
            if (this.view == 3 || this.view == 4) {
                this.mxx = -this.mxx;
                this.mxb = (double)this.ix2 - this.rx1 * this.mxx;
            }
            this.myy = (double)(this.iy1 - this.iy2) / (this.ry2 - this.ry1);
            this.myb = (double)this.iy2 - this.ry1 * this.myy;
            if (this.view == 2 || this.view == 4) {
                this.myy = -this.myy;
                this.myb = (double)this.iy1 - this.ry1 * this.myy;
            }
        }
        this.mzz = (double)(this.iz2 - this.iz1) / (this.rz2 - this.rz1);
        this.mzb = (double)this.iz1 - this.rz1 * this.mzz;
        this.formatReadout(0);
        double sxm = ((this.rx1 + this.rx2) * 0.5 - this.frx1) / (this.frx2 - this.frx1);
        double sxd = (this.rx2 - this.rx1) * 0.5 / (this.frx2 - this.frx1);
        double sym = ((this.ry1 + this.ry2) * 0.5 - this.fry1) / (this.fry2 - this.fry1);
        double syd = (this.ry2 - this.ry1) * 0.5 / (this.fry2 - this.fry1);
        if (this.xvy) {
            this.isxd = (int)(syd * (double)this.ix21);
            this.isyd = (int)(sxd * (double)this.iy21);
            this.isx = this.view == 7 || this.view == 8 ? this.ix2 - (int)(sym * (double)this.ix21) : this.ix1 + (int)(sym * (double)this.ix21);
            this.isy = this.view == 6 || this.view == 8 ? this.iy1 + (int)(sxm * (double)this.iy21) : this.iy2 - (int)(sxm * (double)this.iy21);
        } else {
            this.isxd = (int)(sxd * (double)this.ix21);
            this.isyd = (int)(syd * (double)this.iy21);
            this.isx = this.view == 3 || this.view == 4 ? this.ix2 - (int)(sxm * (double)this.ix21) : this.ix1 + (int)(sxm * (double)this.ix21);
            this.isy = this.view == 2 || this.view == 4 ? this.iy1 + (int)(sym * (double)this.iy21) : this.iy2 - (int)(sym * (double)this.iy21);
        }
        this.isxd = Math.max(this.isxd, 10);
        this.isyd = Math.max(this.isyd, 10);
        this.scroll = 0;
        Layer lay = this.getBaseLayer();
        if (lay != null && lay.isPaged(1) && (this.orx1 != this.frx1 || this.orx2 != this.frx2)) {
            this.scroll |= this.xvy ? 2 : 1;
        }
        if (lay != null && lay.isPaged(2) && (this.ory1 != this.fry1 || this.ory2 != this.fry2)) {
            this.scroll |= this.xvy ? 1 : 2;
        }
        if (this.level > 0 || this.zoomed) {
            this.scroll = 3;
        }
        this.reset(this.level);
        if (this.canvas != null) {
            this.canvas.needUpdate();
        }
    }

    public void setAspect() {
        double xx;
        double yy;
        double ratio;
        if ((this.options & 0x4000) != 0) {
            double pdelta;
            Layer lay = this.getBaseLayer();
            if (lay == null) {
                return;
            }
            double rdelta = Math.abs(lay.xdelta);
            ratio = rdelta / (pdelta = Math.abs((this.rx2 - this.rx1) / (double)(this.ix2 - this.ix1)));
            pdelta = ratio >= 1.0 ? rdelta / Math.floor(rdelta / pdelta) : rdelta * Math.floor(pdelta / rdelta + 1.0);
            this.rx2 = this.rx1 + (double)(this.ix2 - this.ix1) * pdelta * (double)(this.rx2 > this.rx1 ? 1 : -1);
            rdelta = Math.abs(lay.ydelta);
            pdelta = Math.abs((this.ry2 - this.ry1) / (double)(this.iy2 - this.iy1));
            ratio = rdelta / pdelta;
            pdelta = ratio >= 1.0 ? rdelta / Math.floor(rdelta / pdelta) : rdelta * Math.floor(pdelta / rdelta);
            this.ry2 = this.ry1 + (double)(this.iy2 - this.iy1) * pdelta * (double)(this.ry2 > this.ry1 ? 1 : -1);
        }
        if (this.view < 9) {
            return;
        }
        double lat_ry1 = this.ry1;
        double lat_ry2 = this.ry2;
        if (this.view == 12) {
            this.ry1 = ViewMercader.lat2mer(this.ry1);
            this.ry2 = ViewMercader.lat2mer(this.ry2);
        }
        if (Double.isNaN(ratio = -(yy = (double)(this.iy1 - this.iy2) / (this.ry2 - this.ry1)) / (xx = (double)(this.ix2 - this.ix1) / (this.rx2 - this.rx1)))) {
            ratio = 1.0;
        }
        ratio = Math.max(-1.7976931348623157E308, ratio);
        if ((ratio = Math.min(Double.MAX_VALUE, ratio)) == 0.0) {
            ratio = Double.MIN_VALUE;
        }
        if (!this.resizing) {
            if (ratio > 1.01) {
                double d1 = (this.ry1 + this.ry2) / 2.0;
                double d2 = (this.ry2 - this.ry1) / 2.0;
                this.ry1 = d1 - d2 * ratio;
                this.ry2 = d1 + d2 * ratio;
            } else if (ratio < 0.99) {
                double d1 = (this.rx1 + this.rx2) / 2.0;
                double d2 = (this.rx2 - this.rx1) / 2.0;
                this.rx1 = d1 - d2 / ratio;
                this.rx2 = d1 + d2 / ratio;
            }
        } else {
            double margin;
            double d2;
            double d1;
            boolean bothAxesVisible;
            double outrMap_rx1 = this.outerLimits.containsKey("X1") ? this.outerLimits.getD("X1") : this.frx1;
            double outrMap_rx2 = this.outerLimits.containsKey("X2") ? this.outerLimits.getD("X2") : this.frx2;
            double outrMap_ry1 = this.outerLimits.containsKey("Y1") ? this.outerLimits.getD("Y1") : this.fry1;
            double outrMap_ry2 = this.outerLimits.containsKey("Y2") ? this.outerLimits.getD("Y2") : this.fry2;
            double vMap_rx1 = this.viewLimits.containsKey("X1") ? this.viewLimits.getD("X1") : outrMap_rx1;
            double vMap_rx2 = this.viewLimits.containsKey("X2") ? this.viewLimits.getD("X2") : outrMap_rx2;
            double vMap_ry1 = this.viewLimits.containsKey("Y1") ? this.viewLimits.getD("Y1") : outrMap_ry1;
            double vMap_ry2 = this.viewLimits.containsKey("Y2") ? this.viewLimits.getD("Y2") : outrMap_ry2;
            double xFullRange = vMap_rx2 - vMap_rx1;
            double yFullRange = vMap_ry2 - vMap_ry1;
            boolean visibleXAxis = this.ix2 > this.ix1;
            boolean xAxisPositive = this.rx2 > this.rx1 && visibleXAxis;
            double xPercentFilled = xAxisPositive ? xFullRange / (this.rx2 - this.rx1) : 1.0;
            boolean visibleYAxis = this.iy2 > this.iy1;
            boolean yAxisPositive = lat_ry2 > lat_ry1 && visibleYAxis;
            double yPercentFilled = yAxisPositive ? yFullRange / (lat_ry2 - lat_ry1) : 1.0;
            boolean bl = bothAxesVisible = visibleXAxis && visibleYAxis;
            if (yPercentFilled > 0.99) {
                yPercentFilled = 1.0;
            }
            if (xPercentFilled > 0.99) {
                xPercentFilled = 1.0;
            }
            boolean yOversized = yPercentFilled < 1.0;
            boolean xOversized = xPercentFilled < 1.0;
            double ratio_y_portion = 1.0;
            double ratio_x_portion = 1.0;
            if (Math.abs(ratio) > 1.001 && bothAxesVisible) {
                if (ratio < 1.0 / xPercentFilled) {
                    ratio_x_portion = ratio;
                    ratio_y_portion = 1.0;
                } else if (ratio >= 1.0 / xPercentFilled && xPercentFilled > 0.0) {
                    ratio_x_portion = 1.0 / xPercentFilled;
                    ratio_y_portion = ratio / xPercentFilled;
                }
            } else if (Math.abs(ratio) < 0.999 && bothAxesVisible) {
                if (ratio > yPercentFilled) {
                    ratio_y_portion = ratio;
                    ratio_x_portion = 1.0;
                } else if (ratio < yPercentFilled) {
                    ratio_y_portion = yPercentFilled;
                    ratio_x_portion = ratio / yPercentFilled;
                }
            } else if (!bothAxesVisible || ratio < 0.0) {
                ratio_x_portion = ratio;
            }
            if (ratio_y_portion > 1.01 || yOversized && ratio_y_portion < 0.99) {
                d1 = (this.ry1 + this.ry2) / 2.0;
                d2 = (this.ry2 - this.ry1) / 2.0;
                if (d2 == 0.0) {
                    d2 = Double.MIN_VALUE;
                }
                this.ry1 = d1 - d2 * ratio_y_portion;
                this.ry2 = d1 + d2 * ratio_y_portion;
                this.ry1 = Math.max(-8.988465674311579E307, this.ry1);
                this.ry1 = Math.min(8.988465674311579E307, this.ry1);
                this.ry2 = Math.min(8.988465674311579E307, this.ry2);
                this.ry2 = Math.max(-8.988465674311579E307, this.ry2);
                if (this.ry1 <= this.ory1 && this.ry2 >= this.ory2) {
                    margin = (this.ory1 - this.ry1 + (this.ry2 - this.ory2)) / 2.0;
                    this.ry1 = this.ory1 - margin;
                    this.ry2 = this.ory2 + margin;
                }
            }
            if (ratio_x_portion < 0.99 || xOversized && ratio_x_portion > 1.01) {
                d1 = (this.rx1 + this.rx2) / 2.0;
                d2 = (this.rx2 - this.rx1) / 2.0;
                if (d2 == 0.0) {
                    d2 = Double.MIN_VALUE;
                }
                this.rx1 = d1 - d2 / ratio_x_portion;
                this.rx2 = d1 + d2 / ratio_x_portion;
                this.rx1 = Math.max(-8.988465674311579E307, this.rx1);
                this.rx1 = Math.min(8.988465674311579E307, this.rx1);
                this.rx2 = Math.min(8.988465674311579E307, this.rx2);
                this.rx2 = Math.max(-8.988465674311579E307, this.rx2);
                if (this.rx1 <= this.orx1 && this.rx2 >= this.orx2) {
                    margin = (this.orx1 - this.rx1 + (this.rx2 - this.orx2)) / 2.0;
                    this.rx1 = this.orx1 - margin;
                    this.rx2 = this.orx2 + margin;
                }
            }
        }
        if (maxMapOnDragBox && this.isLatLonView() && this.dragboxAdjustment) {
            this.shiftMoreLatLonMap();
        }
        this.dragboxAdjustment = false;
        if (this.view == 12) {
            this.ry1 = ViewMercader.mer2lat(this.ry1);
            this.ry2 = ViewMercader.mer2lat(this.ry2);
        }
    }

    public void configure() {
        new GMenu(this, "MPlot.cfg", "View,Scale,CxMode,Axis,Readout,ReadoutExt,Options", 0, 0, this);
    }

    public void configure(String menuname) {
        if (menuname.equals("VIEW")) {
            new GMenu(this, "View", viewList, this.view, 0, this);
        } else if (menuname.equals("SCALE")) {
            int gf = 144;
            GDialog gd = new GDialog(null, "ScaleDialog", 340, 120, "Apply,Submit,Cancel", "Apply", 0, this);
            gd.needsResize = false;
            new GMenu(gd, "Flags   ", scaleList, this.scale, gf | 0x400 | 0x2000 | 0x40000, this);
            new GValue((Object)gd, "XMin", this.orx1, -1.0E37, 1.0E37, 1.0, gf | 0x40000000, (MessageHandler)this);
            new GValue((Object)gd, "XMax", this.orx2, -1.0E37, 1.0E37, 1.0, gf, (MessageHandler)this);
            new GValue((Object)gd, "YMin", this.ory1, -1.0E37, 1.0E37, 1.0, gf | 0x40000000, (MessageHandler)this);
            new GValue((Object)gd, "YMax", this.ory2, -1.0E37, 1.0E37, 1.0, gf, (MessageHandler)this);
            new GValue((Object)gd, "ZMin", this.orz1, -1.0E37, 1.0E37, 1.0, gf | 0x40000000, (MessageHandler)this);
            new GValue((Object)gd, "ZMax", this.orz2, -1.0E37, 1.0E37, 1.0, gf, (MessageHandler)this);
            new GValue((Object)gd, "ViewXMin", this.rx1, -1.0E37, 1.0E37, 1.0, gf | 0x40000000, (MessageHandler)this);
            new GValue((Object)gd, "ViewXMax", this.rx2, -1.0E37, 1.0E37, 1.0, gf, (MessageHandler)this);
            new GValue((Object)gd, "ViewYMin", this.ry1, -1.0E37, 1.0E37, 1.0, gf | 0x40000000, (MessageHandler)this);
            new GValue((Object)gd, "ViewYMax", this.ry2, -1.0E37, 1.0E37, 1.0, gf, (MessageHandler)this);
            new GValue((Object)gd, "ViewZMin", this.rz1, -1.0E37, 1.0E37, 1.0, gf | 0x40000000, (MessageHandler)this);
            new GValue((Object)gd, "ViewZMax", this.rz2, -1.0E37, 1.0E37, 1.0, gf, (MessageHandler)this);
            new GValue((Object)gd, "MinRange", this.minRange, 0.0, 100000.0, 1.0, gf | 0x40000000, (MessageHandler)this);
            new GValue((Object)gd, "MaxRange", this.maxRange, 0.0, 100000.0, 1.0, gf, (MessageHandler)this);
            new GValue((Object)gd, "ScaleAvg", this.scaleAvg, 0, 100, 1, gf, (MessageHandler)this);
            new GMenu(gd, "Force Rescale", "TRUE, FALSE", 2, gf | 0x100 | 0x2000 | 0x40000, this);
            ++this.popupCount;
            gd.needsResize = true;
            gd.addTo(this);
        } else if (menuname.equals("MODE")) {
            new GMenu(this, "Mode", modeList, this.mode, 0, this);
        } else if (menuname.equals("AXIS")) {
            new GMenu(this, "Axis", axisMenu, 0, 0, this);
        } else if (menuname.equals("AXIS.CFG")) {
            new GMenu(this, "Axis.cfg", axisList, this.axis, 1024, this);
        } else if (menuname.equals("READOUT")) {
            new GMenu(this, "Readout", readoutList, this.readout, 1024, this);
        } else if (menuname.equals("READOUTEXT")) {
            String currentList = shortReadoutListExt;
            if (this.layerDrawable != null || this.wmsLayerCnt > 0) {
                currentList = currentList + ",Points";
            }
            if (this.wmsLayerCnt > 0) {
                currentList = currentList + ",WMS_level";
            }
            new GMenu(this, "ReadoutExt", currentList, this.readoutExt, 1024, this);
        } else if (menuname.equals("OPTIONS")) {
            new GMenu(this, "Options", optionsList, this.options, 1024, this);
        } else if (menuname.equals("LEGEND")) {
            this.createLegend();
        } else if (menuname.equals("LAYERS")) {
            this.createLegend();
        }
    }

    public GWidget createLegend() {
        if (this.legend != null && this.legend.getStatus() != -3) {
            this.legend.close();
        }
        this.legend = new GLegend(this, "Legend", this, 0, (MessageHandler)this);
        return this.legend;
    }

    public GLegend getLegend() {
        return this.legend;
    }

    @Override
    @Deprecated
    public int process(String name, int info, Object data) {
        if (this.status == -2 || this.status == 0) {
            if (this.isPanelVisible()) {
                if (this.parent instanceof Frame) {
                    this.getFocus();
                }
                this.status = 1;
            } else {
                this.status = 0;
            }
        }
        return super.process(name, info, data);
    }

    @Override
    public int preprocess(String name, int info, Object data) {
        return this.preprocess(name, info, data, null);
    }

    @Override
    public int preprocess(String name, int info, Object data, MouseEvent e) {
        Object origData = data;
        block6 : switch (name) {
            case "BUTTON": {
                this.zmode = 0;
                switch (info) {
                    case 1: {
                        name = Parser.get(buttonActionList, this.lmbButton);
                        if (this.elasticFeature != null && "MARK_MESSAGE".contentEquals(name)) {
                            this.elasticFeatureSelected = this.elasticFeature.isAtPosition(this.getPosition(), 0, 0);
                            this.needRefresh = true;
                        }
                        if ((this.scroll & 1) != 0 && (this.py > this.iy2 || this.py < this.iy1)) {
                            name = this.xvy ? "PANY" : "PANX";
                            data = this.pan2rwc((this.ix2 + this.ix1) / 2 - this.px, 0);
                        }
                        if ((this.scroll & 2) != 0 && (this.px < this.ix1 || this.px > this.ix2)) {
                            name = this.xvy ? "PANX" : "PANY";
                            data = this.pan2rwc(0, (this.iy2 + this.iy1) / 2 - this.py);
                        }
                        if (this.px <= this.ix1 || this.px >= this.ix2 || this.py <= this.iy1 || this.py >= this.iy2) break;
                        this.mm = this.mm != null && !this.showDeltas ? null : this.getPosition().cloneOf();
                        this.formatReadout(0);
                        break;
                    }
                    case 2: {
                        name = Parser.get(buttonActionList, this.mmbButton);
                        if (!(data instanceof MouseEvent)) break;
                        this.setCurrentMMBClickedLocation(((MouseEvent)data).getPoint());
                        break;
                    }
                    case 3: {
                        if (this.dblClickZoom) break;
                        name = Parser.get(buttonActionList, this.rmbButton);
                    }
                }
                if (!name.equals("NONE")) break;
                return 1;
            }
            case "POINTER": {
                if (!this.elasticFeatureSelected) break;
                this.elasticHandle = ResizeBox.getHandle(this.elasticFeature, this.px, this.py);
                String cursor = ResizeBox.cursorFromHandle(this.elasticHandle);
                this.setCursor(cursor);
                break;
            }
            case "DRAGBOX": {
                if (this.dragging == -3 && this.view == 14) {
                    name = "NOOP";
                }
                this.box.reform();
                data = this.box2rwc(this.box);
                this.dragging = 0;
                this.zmode = 0;
                if (this.elasticHandle != ResizeBox.Handle.NONE) {
                    this.elasticHandle = ResizeBox.Handle.NONE;
                    data = this.elasticFeature.toTable();
                    name = "RESIZEBOX";
                    info = 0;
                } else if (this.view == 13) {
                    double[] rwc1 = new double[3];
                    double[] rwc2 = new double[3];
                    MPoint pix1 = new MPoint(this.box.x, this.box.y);
                    MPoint pix2 = new MPoint(this.box.x + this.box.w, this.box.y + this.box.h);
                    this.viewGeo.pix2rwc(pix1, rwc1);
                    this.viewGeo.pix2rwc(pix2, rwc2);
                    DragBox boxObj = new DragBox(rwc1[0], rwc2[0], rwc2[1], rwc1[1], (double[])data);
                    data = boxObj;
                } else {
                    DragBox boxObj = new DragBox((double[])data);
                    double top = this.getPosition((int)this.box.x, (int)this.box.y).t;
                    double bot = this.getPosition((int)(this.box.x + this.box.w), (int)(this.box.y + this.box.h)).t;
                    boxObj.setT1(top);
                    boxObj.setT2(bot);
                    boxObj.setTMin(bot < top ? bot : top);
                    boxObj.setTMax(top > bot ? top : bot);
                    data = boxObj;
                }
                if (info != 1) break;
                name = "ZOOM";
                break;
            }
            case "DRAG": {
                int isConsumed;
                int buttNum = info % 100;
                if (this.elasticFeatureSelected && buttNum == 1 && this.elasticHandle != ResizeBox.Handle.NONE && (isConsumed = ResizeBox.processDrag(this.elasticFeature, this.elasticHandle)) == 1) {
                    return 1;
                }
                if (this.zmode == 0 && info > 0) {
                    boolean dragWhenUnzoomed;
                    boolean bl = dragWhenUnzoomed = buttNum == 2 && this.view == 14;
                    if (buttNum == 2) {
                        this.zmode = 3;
                    } else if (buttNum != 2 && (this.scroll & 1) != 0 && Math.abs(this.box.y - this.isxy) < 8 && (this.isHighHScroll || this.box.x > this.isx - this.isxd) && (this.isLowHScroll || this.box.x < this.isx + this.isxd)) {
                        this.zmode = 4;
                    } else if (buttNum != 2 && (this.scroll & 2) != 0 && Math.abs(this.box.x - this.isyx) < 8 && (this.isHighVScroll || this.box.y > this.isy - this.isyd) && (this.isLowVScroll || this.box.y < this.isy + this.isyd)) {
                        this.zmode = 5;
                    } else if (buttNum == 3 && (this.options & 0x8000) != 0 && (double)this.box.x / (double)this.pos.w > 0.8) {
                        this.zmode = 9;
                    } else if (buttNum == 3 && this.view == 13) {
                        this.zmode = 7;
                    } else if (buttNum == 3 && this.is3DView()) {
                        this.zmode = 6;
                    }
                    if (this.scroll == 0 && this.view != 13 && !this.is3DView() && !dragWhenUnzoomed) {
                        this.zmode = 0;
                    }
                    if (this.zmode == 0) {
                        this.zmode = -info;
                    }
                    if (this.zmode != 0) {
                        this.dragging = -this.zmode;
                        this.brx = (this.rx1 + this.rx2) / 2.0;
                        this.bry = (this.ry1 + this.ry2) / 2.0;
                        this.brxd = (this.rx2 - this.rx1) / 2.0;
                        this.bryd = (this.ry2 - this.ry1) / 2.0;
                        this.viewer.getObserver(this.bvp);
                    }
                }
                switch (this.zmode) {
                    case 3: {
                        name = "PANXY";
                        data = this.panb2rwc(this.box.w, this.box.h);
                        break block6;
                    }
                    case 4: {
                        this.isScrolling = true;
                        name = "PANXY";
                        data = this.scroll2rwc(this.box.w, 0);
                        break block6;
                    }
                    case 5: {
                        this.isScrolling = true;
                        name = "PANXY";
                        data = this.scroll2rwc(0, this.box.h);
                        break block6;
                    }
                    case 9: {
                        name = "PANXY";
                        double factor = (double)this.box.h / (double)Math.abs(this.iy2 - this.iy1);
                        data = this.panz2rwc(-4.0 * factor);
                        break block6;
                    }
                    case 7: {
                        name = "PANOBS";
                        data = this.nvp;
                        double factor = 180.0 / (double)this.pos.h;
                        this.nvp[0] = this.bvp[0] - (double)this.box.w * factor;
                        this.nvp[1] = this.bvp[1] + (double)this.box.h * factor;
                        this.nvp[2] = this.bvp[2];
                        break block6;
                    }
                    case 6: {
                        name = "PANOBS";
                        data = null;
                        double factor = 1.0 / (double)Math.min(this.ix21, this.iy21);
                        double x = 2.0 * (double)(this.px - this.ix1) / (double)this.ix21 - 1.0;
                        double y = 2.0 * (double)(this.py - this.iy1) / (double)this.iy21 - 1.0;
                        double z = Math.max(0.0, 1.0 - Math.sqrt(x * x + y * y));
                        this.nvp[1] = z * 180.0 * (double)(this.box.x - this.px) * factor;
                        this.nvp[2] = z * 180.0 * (double)(this.py - this.box.y) * factor;
                        this.nvp[0] = (z - 1.0) * 180.0 * ((double)(this.box.x - this.px) * y + (double)(this.py - this.box.y) * x) * factor;
                        this.box.x = this.px;
                        this.box.y = this.py;
                        this.view3D.rotate(this.nvp);
                    }
                }
            }
        }
        if (this.mh != null && !name.equals("NOOP")) {
            Table quals = new Table();
            quals.put("ORIG_MSG_DATA", origData);
            if (e != null && origData != null && origData instanceof MBox) {
                quals.put("MODIFIERS", e.getModifiersEx());
            }
            this.mh.processMessage(new Message(name, info, data, this.mh, this, quals));
        }
        return 1;
    }

    @InternalUseOnly(value="Prototype in progress")
    public void setElasticFeature(Feature feature) {
        if (feature != null && this.features.findKey(feature.getName()) == -1) {
            this.addFeature(feature);
        }
        this.elasticFeature = feature;
        this.elasticFeatureSelected = false;
        this.elasticHandle = ResizeBox.Handle.NONE;
        this.needRefresh = true;
    }

    @InternalUseOnly(value="Prototype in progress")
    public void clearElasticFeature() {
        this.elasticFeature = null;
        this.elasticFeatureSelected = false;
        this.elasticHandle = ResizeBox.Handle.NONE;
        this.needRefresh = true;
    }

    @Override
    protected void stopScroll() {
        this.isScrolling = false;
        this.dragging = 0;
        this.zmode = 0;
    }

    @Override
    public int processMessage(Message msg) {
        return this.processMessage(msg, null, null);
    }

    public int processMessage(Message msg, Object msgid, Object parent) {
        switch (msg.name) {
            case "MPLOT.CFG": {
                this.configure(Convert.o2s(msg.data));
                return 1;
            }
            case "VIEW": {
                this.setView(Convert.o2s(msg.data));
                return 1;
            }
            case "AXIS": {
                this.setAxis(Convert.o2s(msg.data));
                return 1;
            }
            case "AXIS.CFG": {
                this.setAxis(msg.info);
                return 1;
            }
            case "MODE": {
                this.setMode(Convert.o2s(msg.data));
                return 1;
            }
            case "SCALE": {
                this.setScale(Convert.o2s(msg.data));
                return 1;
            }
            case "SCALEDIALOG": {
                this.applyScaleValues(Convert.o2t(msg.data));
                return 1;
            }
            case "DRANGEUNITS": {
                this.setDRangeUnits((String)msg.data);
                return 1;
            }
            case "OPTIONS": {
                if (this.setOptions(msg.info)) {
                    this.refresh();
                }
                return 1;
            }
            case "READOUTEXT": {
                if (this.setReadout(msg.info, this.READOUT_OPTION_EXT)) {
                    this.refresh();
                }
                return 1;
            }
            case "READOUT": {
                if ("DRANGEUNITS>".equals(msg.data)) {
                    new GMenu(this, "dRangeUnits", "M,KM,NMI", this.dRangeUnits, 0, this);
                } else if (this.setReadout(msg.info, this.READOUT_OPTION_MAIN)) {
                    this.refresh();
                }
                return 1;
            }
            case "LEGEND.ALT": {
                Layer lay = (Layer)this.layers.get(Convert.o2s(msg.data));
                if (lay != null) {
                    lay.configure();
                }
                return 1;
            }
            case "LEGEND": {
                Layer lay = (Layer)this.layers.get(Convert.o2s(msg.data));
                if (lay != null) {
                    if ((lay.enable & 4) != 0) {
                        this.reset(-1);
                    }
                    lay.enable ^= 1;
                    this.refresh();
                }
                return 1;
            }
        }
        return super.processMessage(msg);
    }

    private void applyScaleValues(Table t) {
        boolean doFindRange = false;
        boolean doUseRange = false;
        int tmpScale = ((GMenu)t.get("FLAGS")).getItemIndex();
        if (tmpScale != this.scale) {
            this.scale = tmpScale;
            doFindRange = true;
            doUseRange = true;
        }
        double tmporx1 = Convert.o2d(((GValue)t.get("XMIN")).getValue());
        double tmporx2 = Convert.o2d(((GValue)t.get("XMAX")).getValue());
        double tmpory1 = Convert.o2d(((GValue)t.get("YMIN")).getValue());
        double tmpory2 = Convert.o2d(((GValue)t.get("YMAX")).getValue());
        double tmporz1 = Convert.o2d(((GValue)t.get("ZMIN")).getValue());
        double tmporz2 = Convert.o2d(((GValue)t.get("ZMAX")).getValue());
        double tmprx1 = Convert.o2d(((GValue)t.get("VIEWXMIN")).getValue());
        double tmprx2 = Convert.o2d(((GValue)t.get("VIEWXMAX")).getValue());
        double tmpry1 = Convert.o2d(((GValue)t.get("VIEWYMIN")).getValue());
        double tmpry2 = Convert.o2d(((GValue)t.get("VIEWYMAX")).getValue());
        double tmprz1 = Convert.o2d(((GValue)t.get("VIEWZMIN")).getValue());
        double tmprz2 = Convert.o2d(((GValue)t.get("VIEWZMAX")).getValue());
        if (tmporx1 != this.orx1) {
            this.orx1 = tmporx1;
            this.setUserLimits("X1", this.orx1, true);
            doFindRange = false;
            doUseRange = true;
        }
        if (tmporx2 != this.orx2) {
            this.orx2 = tmporx2;
            this.setUserLimits("X2", this.orx2, true);
            doFindRange = false;
            doUseRange = true;
        }
        if (tmpory1 != this.ory1) {
            this.ory1 = tmpory1;
            this.setUserLimits("Y1", this.ory1, true);
            doFindRange = false;
            doUseRange = true;
        }
        if (tmpory2 != this.ory2) {
            this.ory2 = tmpory2;
            this.setUserLimits("Y2", this.ory2, true);
            doFindRange = false;
            doUseRange = true;
        }
        if (tmporz1 != this.orz1) {
            this.orz1 = tmporz1;
            this.setUserLimits("Z1", this.orz1, true);
            doFindRange = false;
            doUseRange = true;
        }
        if (tmporz2 != this.orz2) {
            this.orz2 = tmporz2;
            this.setUserLimits("Z2", this.orz2, true);
            doFindRange = false;
            doUseRange = true;
        }
        if (tmprx1 != this.rx1) {
            this.rx1 = tmprx1;
            this.setUserLimits("X1", this.rx1, false);
            doUseRange = false;
        }
        if (tmprx2 != this.rx2) {
            this.rx2 = tmprx2;
            this.setUserLimits("X2", this.rx2, false);
            doUseRange = false;
        }
        if (tmpry1 != this.ry1) {
            this.ry1 = tmpry1;
            this.setUserLimits("Y1", this.ry1, false);
            doUseRange = false;
        }
        if (tmpry2 != this.ry2) {
            this.ry2 = tmpry2;
            this.setUserLimits("Y2", this.ry2, false);
            doUseRange = false;
        }
        if (tmprz1 != this.rz1) {
            this.rz1 = tmprz1;
            this.setUserLimits("Z1", this.rz1, false);
            doUseRange = false;
        }
        if (tmprz2 != this.rz2) {
            this.rz2 = tmprz2;
            this.setUserLimits("Z2", this.rz2, false);
            doUseRange = false;
        }
        this.minRange = Convert.o2d(((GValue)t.get("MINRANGE")).getValue());
        this.maxRange = Convert.o2d(((GValue)t.get("MAXRANGE")).getValue());
        this.scaleAvg = Convert.o2l(((GValue)t.get("SCALEAVG")).getValue());
        boolean forceRescale = Convert.o2s(((GMenu)t.get("FORCE RESCALE")).getValue()).equals("TRUE");
        if (forceRescale || doFindRange) {
            this.findRange();
        }
        if (forceRescale || doUseRange) {
            this.useRange();
        }
        this.setup();
        this.refresh();
    }

    @Override
    public void refresh() {
        this.cancel = true;
        this.needRefresh = true;
    }

    public boolean setHoldRefresh(String arg) {
        return this.setHoldRefresh(Parser.mask(holdRefreshList, arg, this.holdRefresh));
    }

    public boolean setHoldRefresh(int arg) {
        if (arg != this.holdRefresh) {
            this.holdRefresh = arg;
            return true;
        }
        return false;
    }

    public String getHoldRefresh() {
        String res = Parser.mask2s(holdRefreshList, this.holdRefresh);
        if (res.equals("|")) {
            res = "NONE";
        }
        return res;
    }

    public Table getButtonAction() {
        Table tbl = new Table();
        tbl.put("LMB", (Object)Parser.get(buttonActionList, this.lmbButton));
        tbl.put("MMB", (Object)Parser.get(buttonActionList, this.mmbButton));
        tbl.put("RMB", (Object)Parser.get(buttonActionList, this.rmbButton));
        return tbl;
    }

    public void setButtonAction(Table tbl) {
        if (tbl != null) {
            this.lmbButton = this.findButtonAction(tbl.getS("LMB"), this.lmbButton, 3);
            this.mmbButton = this.findButtonAction(tbl.getS("MMB"), this.mmbButton, 2);
            this.rmbButton = this.findButtonAction(tbl.getS("RMB"), this.rmbButton, 4);
        }
    }

    private int findButtonAction(String val, int current, int def) {
        int action = current;
        if (val != null) {
            if (val.equalsIgnoreCase("DEFAULT")) {
                action = def;
            } else {
                action = Parser.find(buttonActionList, val, def);
                if (action < 0) {
                    throw new MidasException("MPlot: Invalid buttonAction '" + val + "', valid options are '" + buttonActionList + "'.");
                }
            }
        }
        return action;
    }

    public boolean pantw(Object rtw, int mode) {
        return this.panTimeWindow(rtw, mode);
    }

    public boolean panTimeWindow(Object rtw, int mode) {
        double t1 = Convert.o2d(rtw, 0, 0.0);
        double t2 = Convert.o2d(rtw, 1, 1.0);
        Layer ly = this.getBaseLayer();
        if (ly != null && ly.pf instanceof DataFile) {
            DataFile df = (DataFile)ly.pf;
            if (t1 == 0.0 || t2 == 0.0) {
                t1 = df.getStart();
                t2 = t1 + df.getDelta() * df.getSize();
            } else {
                t1 = df.getStart() + df.getDelta() * df.getIndexAt(t1);
                if (t2 > 0.0) {
                    t2 = t1 + t2;
                } else {
                    t1 += t2;
                    t2 = t1 - t2;
                }
            }
            if (df.typeClass == 2) {
                this.setYBounds(t1, t2);
            } else {
                this.setXBounds(t1, t2);
            }
            return true;
        }
        return false;
    }

    public boolean panxy(Object rxy, int mode) {
        double x1 = Convert.o2d(rxy, 0, this.rx1);
        double x2 = Convert.o2d(rxy, 1, this.rx2);
        double y1 = Convert.o2d(rxy, 2, this.ry1);
        double y2 = Convert.o2d(rxy, 3, this.ry2);
        if (this.baseIsLayer2DorImage || this.isMapView()) {
            if (this.baseIsLayer2DorImage) {
                x1 = Math.max(Math.min(this.orx1, this.frx1), x1);
                x2 = Math.min(Math.max(this.orx2, this.frx2), x2);
                y1 = Math.max(Math.min(this.ory1, this.fry1), y1);
                y2 = Math.min(Math.max(this.ory2, this.fry2), y2);
            } else if (!this.isLatLonView()) {
                double range_multiple_allowed;
                switch (this.view) {
                    case 13: {
                        range_multiple_allowed = 2.7;
                        break;
                    }
                    case 12: {
                        range_multiple_allowed = 2.0;
                        break;
                    }
                    case 10: {
                        range_multiple_allowed = 2.0;
                        break;
                    }
                    case 9: {
                        range_multiple_allowed = 2.5;
                        break;
                    }
                    case 15: {
                        range_multiple_allowed = 1.0;
                        break;
                    }
                    default: {
                        range_multiple_allowed = 1.0;
                    }
                }
                if (x1 < Math.min(this.frx1 * range_multiple_allowed, this.rx1) || x2 > Math.min(x2, Math.max(this.frx2 * range_multiple_allowed, this.rx2))) {
                    x1 = this.rx1;
                    x2 = this.rx2;
                }
                if (y1 < Math.min(this.fry1 * range_multiple_allowed, this.ry1) || y2 > Math.min(y2, Math.max(this.fry2 * range_multiple_allowed, this.ry2))) {
                    y1 = this.ry1;
                    y2 = this.ry2;
                }
            } else {
                if (this.view == 11 && (x1 < Math.min(this.orx1, this.rx1) || x2 > Math.min(x2, Math.max(this.orx2, this.rx2)))) {
                    x1 = this.rx1;
                    x2 = this.rx2;
                }
                if (y1 < Math.min(this.ory1, this.ry1) || y2 > Math.min(y2, Math.max(this.ory2, this.ry2))) {
                    y1 = this.ry1;
                    y2 = this.ry2;
                }
                if (this.view == 14 || x2 - x1 > (double)LONGITUDE_RANGE && y2 - y1 > (double)LATITUDE_RANGE) {
                    double[] convertedValues = this.adjustBorders(x1, x2, y1, y2);
                    x1 = convertedValues[0];
                    x2 = convertedValues[1];
                    y1 = convertedValues[2];
                    y2 = convertedValues[3];
                }
            }
        }
        if (mode == 1) {
            this.setXBounds(x1, x2);
        } else if (mode == 2) {
            this.setYBounds(y1, y2);
        } else {
            this.setXYBounds(x1, x2, y1, y2);
        }
        return true;
    }

    @InternalUseOnly
    public boolean panxy_orig(Object rxy, int mode) {
        double x1 = Convert.o2d(rxy, 0, this.rx1);
        double x2 = Convert.o2d(rxy, 1, this.rx2);
        double y1 = Convert.o2d(rxy, 2, this.ry1);
        double y2 = Convert.o2d(rxy, 3, this.ry2);
        if (this.isStandardView()) {
            if (!this.isLatLonView()) {
                if (this.isStandardXYView()) {
                    if (x1 < Math.min(this.frx1, this.rx1) || x2 > Math.min(x2, Math.max(this.frx2, this.rx2))) {
                        x1 = this.rx1;
                        x2 = this.rx2;
                    }
                    if (y1 < Math.min(this.fry1, this.ry1) || y2 > Math.min(y2, Math.max(this.fry2, this.ry2))) {
                        y1 = this.ry1;
                        y2 = this.ry2;
                    }
                } else {
                    double range_multiple_allowed;
                    switch (this.view) {
                        case 13: {
                            range_multiple_allowed = 2.7;
                            break;
                        }
                        case 12: {
                            range_multiple_allowed = 2.0;
                            break;
                        }
                        case 10: {
                            range_multiple_allowed = 2.0;
                            break;
                        }
                        case 9: {
                            range_multiple_allowed = 2.5;
                            break;
                        }
                        case 15: {
                            range_multiple_allowed = 2.0;
                            break;
                        }
                        default: {
                            range_multiple_allowed = 1.0;
                        }
                    }
                    if (x1 < this.frx1 * range_multiple_allowed) {
                        return false;
                    }
                    if (x2 > this.frx2 * range_multiple_allowed) {
                        return false;
                    }
                    if (y1 < this.fry1 * range_multiple_allowed) {
                        return false;
                    }
                    if (y2 > this.fry2 * range_multiple_allowed) {
                        return false;
                    }
                }
            } else {
                if (this.view == 11 && (x1 < Math.min(this.orx1, this.rx1) || x2 > Math.min(x2, Math.max(this.orx2, this.rx2)))) {
                    x1 = this.rx1;
                    x2 = this.rx2;
                }
                if (y1 < Math.min(this.ory1, this.ry1) || y2 > Math.min(y2, Math.max(this.ory2, this.ry2))) {
                    y1 = this.ry1;
                    y2 = this.ry2;
                }
                if (this.view == 14 || x2 - x1 > (double)LONGITUDE_RANGE && y2 - y1 > (double)LATITUDE_RANGE) {
                    double[] convertedValues = this.adjustBorders(x1, x2, y1, y2);
                    x1 = convertedValues[0];
                    x2 = convertedValues[1];
                    y1 = convertedValues[2];
                    y2 = convertedValues[3];
                }
            }
        }
        if (mode == 1) {
            this.setXBounds(x1, x2);
        } else if (mode == 2) {
            this.setYBounds(y1, y2);
        } else {
            this.setXYBounds(x1, x2, y1, y2);
        }
        return true;
    }

    public boolean panx(Object rx) {
        double x1 = Convert.o2d(rx, 0, this.rx1);
        double x2 = Convert.o2d(rx, 1, this.rx2);
        this.setXBounds(x1, x2);
        return true;
    }

    public boolean pany(Object ry) {
        double y1 = Convert.o2d(ry, 0, this.ry1);
        double y2 = Convert.o2d(ry, 1, this.ry2);
        this.setYBounds(y1, y2);
        return true;
    }

    public boolean panobs(Object arg) {
        this.reset(-1);
        return this.viewer.setObserver(Convert.o2da(arg));
    }

    private double[] box2rwc(MBox box) {
        double[] nbox = new double[]{this.getrx(box.x, box.y), this.getrx(box.x + box.w, box.y + box.h), this.getry(box.x, box.y), this.getry(box.x + box.w, box.y + box.h)};
        return nbox;
    }

    private double[] panb2rwc(int dx, int dy) {
        double dry;
        double drx;
        double[] nbox = new double[4];
        if (this.xvy) {
            drx = -((double)dy) / this.mxx;
            dry = -((double)dx) / this.myy;
        } else {
            drx = -((double)dx) / this.mxx;
            dry = -((double)dy) / this.myy;
        }
        nbox[0] = this.brx + drx - this.brxd;
        nbox[1] = this.brx + drx + this.brxd;
        nbox[2] = this.bry + dry - this.bryd;
        nbox[3] = this.bry + dry + this.bryd;
        return nbox;
    }

    private double[] scroll2rwc(int dx, int dy) {
        double dry;
        double drx;
        double[] nbox = new double[4];
        double fx = (this.rx2 - this.rx1) / (this.frx2 - this.frx1);
        double fy = (this.ry2 - this.ry1) / (this.fry2 - this.fry1);
        if (this.xvy) {
            drx = (double)dy / (this.mxx * fx);
            dry = (double)dx / (this.myy * fy);
        } else {
            drx = (double)dx / (this.mxx * fx);
            dry = (double)dy / (this.myy * fy);
        }
        nbox[0] = this.brx + drx - this.brxd;
        nbox[1] = this.brx + drx + this.brxd;
        nbox[2] = this.bry + dry - this.bryd;
        nbox[3] = this.bry + dry + this.bryd;
        if (this.baseIsLayer2DorImage || this.isMapView()) {
            double minX = Math.min(this.frx1, this.orx1);
            double maxX = Math.max(this.frx2, this.orx2);
            double minY = Math.min(this.fry1, this.ory1);
            double maxY = Math.max(this.fry2, this.ory2);
            if (nbox[0] < minX) {
                nbox[0] = minX;
                nbox[1] = minX + (this.rx2 - this.rx1);
            } else if (nbox[1] > maxX) {
                nbox[1] = maxX;
                nbox[0] = maxX - (this.rx2 - this.rx1);
            }
            if (nbox[2] < minY) {
                nbox[2] = minY;
                nbox[3] = minY + (this.ry2 - this.ry1);
            } else if (nbox[3] > maxY) {
                nbox[3] = maxY;
                nbox[2] = maxY - (this.ry2 - this.ry1);
            }
        }
        return nbox;
    }

    private double[] pan2rwc(int dx, int dy) {
        double dry;
        double drx;
        double[] nbox = new double[4];
        if (this.xvy) {
            drx = -((double)dy) / this.mxx;
            dry = -((double)dx) / this.myy;
        } else {
            drx = -((double)dx) / this.mxx;
            dry = -((double)dy) / this.myy;
        }
        nbox[0] = this.rx1 + drx;
        nbox[1] = this.rx2 + drx;
        nbox[2] = this.ry1 + dry;
        nbox[3] = this.ry2 + dry;
        return nbox;
    }

    private double[] panz2rwc(double factor) {
        double[] nbox = new double[4];
        factor = factor > 0.0 ? 1.0 + factor : 1.0 / (1.0 - factor);
        nbox[0] = this.brx - this.brxd * factor;
        nbox[1] = this.brx + this.brxd * factor;
        nbox[2] = this.bry - this.bryd * factor;
        nbox[3] = this.bry + this.bryd * factor;
        return nbox;
    }

    private double getrdx() {
        return this.getrx(this.px, this.py) - this.getrx(this.box.x, this.box.y);
    }

    private double getrx() {
        return this.getrx(this.px, this.py);
    }

    public double getrx(int ix, int iy) {
        int i;
        int n = i = this.xvy ? iy : ix;
        if (this.mxx == 0.0) {
            return 0.0;
        }
        return ((double)i - this.mxb) / this.mxx;
    }

    private double getrdy() {
        return this.getry(this.px, this.py) - this.getry(this.box.x, this.box.y);
    }

    private double getry() {
        return this.getry(this.px, this.py);
    }

    public double getry(int ix, int iy) {
        int i;
        int n = i = this.xvy ? ix : iy;
        if (this.myy == 0.0) {
            return 0.0;
        }
        if (this.view == 12) {
            return this.viewMerc.iy2ry(iy);
        }
        return ((double)i - this.myb) / this.myy;
    }

    private double[] getrxyz(int px, int py) {
        double[] buf = new double[]{this.getrx(px, py), this.getry(px, py), 0.0, 0.0};
        Layer lay = this.getBaseLayer();
        if (lay != null) {
            buf[3] = lay.getTime(px, py);
        }
        return buf;
    }

    public boolean isInRange(int x, int y) {
        return x > this.ix1 && x < this.ix2 && y > this.iy1 && y < this.iy2;
    }

    private void addMouseWheelListener() {
        if (this.panel != null) {
            this.panel.addMouseWheelListener(this);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if ((this.eventFilter & 1) != 0 || !this.mouseWheelZoom) {
            return;
        }
        float percent = this.getZoomPercentage();
        Message msg = new Message("ZOOMIN", 0, (Object)Float.valueOf(percent), new Table("{PERCENT=" + percent + "}"));
        if (e.getWheelRotation() > 0) {
            msg.name = "ZOOMOUT";
        }
        this.mh.processMessage(msg);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if ((this.eventFilter & 1) != 0) {
            return;
        }
        super.mouseClicked(e);
        this.clickCount = e.getClickCount();
        if (this.dblClickZoom && this.clickCount == 1) {
            Timer zoomTimer = new Timer(doubleClickInterval, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MPlot.this.checkClickCount(MPlot.this.button);
                }
            });
            zoomTimer.setRepeats(false);
            zoomTimer.start();
        }
    }

    private void checkClickCount(int button) {
        if (this.clickCount == 1 && button == 3) {
            if (this.mh != null) {
                this.mh.processMessage(new Message("UNZOOM", button, null, this.mh, this));
            }
        } else if (this.clickCount == 2 && this.dblClickZoom) {
            String msgName;
            if (button == 1) {
                this.zoomInAtMouse();
                msgName = "DBLCLICKZOOM";
            } else if (button == 3) {
                this.zoomOutAtMouse();
                msgName = "DBLCLICKUNZOOM";
            } else {
                return;
            }
            Table data = new Table("XMIN=" + this.rx1 + ", XMAX=" + this.rx2 + ", YMIN=" + this.ry1 + ", YMAX=" + this.ry2);
            if (this.mh != null) {
                this.mh.processMessage(new Message(msgName, 0, data));
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        if ((this.eventFilter & 2) != 0) {
            return;
        }
        String dir = null;
        float mult = 1.0f;
        Message msg = null;
        String text = KeyEvent.getKeyText(this.keycode).toUpperCase();
        if (text.equals(this.keyMap.getS("LEFT"))) {
            dir = "LEFT";
        } else if (text.equals(this.keyMap.getS("RIGHT"))) {
            dir = "RIGHT";
        } else if (text.equals(this.keyMap.getS("UP"))) {
            dir = "UP";
        } else if (text.equals(this.keyMap.getS("DOWN"))) {
            dir = "DOWN";
        } else if (text.equals(this.keyMap.getS("PAGEUP"))) {
            dir = "UP";
            mult = this.zoomMult;
        } else if (text.equals(this.keyMap.getS("PAGEDOWN"))) {
            dir = "DOWN";
            mult = this.zoomMult;
        } else if (text.equals(this.keyMap.getS("HOME"))) {
            dir = "LEFT";
            mult = this.zoomMult;
        } else if (text.equals(this.keyMap.getS("END"))) {
            dir = "RIGHT";
            mult = this.zoomMult;
        }
        if (dir != null) {
            this.adjustZoom(dir, this.zoomAdjust * mult);
            return;
        }
        if (text.equals(this.keyMap.getS("IN")) || text.equals(this.keyMap.getS("ADD")) || text.equals(this.keyMap.getS("PLUS"))) {
            msg = new Message("ZOOMIN", 0, (Object)Float.valueOf(this.getZoomPercentage()), new Table("{PERCENT=" + this.getZoomPercentage() + "}"));
        } else if (text.equals(this.keyMap.getS("OUT")) || text.equals(this.keyMap.getS("MINUS")) || text.equals(this.keyMap.getS("SUBTR"))) {
            msg = new Message("ZOOMOUT", 0, (Object)Float.valueOf(this.getZoomPercentage()), new Table("{PERCENT=" + this.getZoomPercentage() + "}"));
        } else if (text.equals(this.keyMap.getS("XCUT"))) {
            Table data = new Table("{IX=" + this.px + ", IY=" + this.py + "}");
            msg = new Message("XCUT", 0, data);
        } else if (text.equals(this.keyMap.getS("YCUT"))) {
            Table data = new Table("{IX=" + this.px + ", IY=" + this.py + "}");
            msg = new Message("YCUT", 0, data);
        } else if (text.equals("X")) {
            Table data = new Table("{IX=" + this.px + ", IY=" + this.py + "}");
            msg = new Message("XCUT", 0, data);
        } else if (text.equals("Y")) {
            Table data = new Table("{IX=" + this.px + ", IY=" + this.py + "}");
            msg = new Message("YCUT", 0, data);
        }
        if (msg != null) {
            this.mh.processMessage(msg);
        }
    }

    public void setKeyMapTable(Table tab) {
        this.keyMap = new Table();
        if (tab == null) {
            tab = new Table();
        }
        this.keyMap.put("LEFT", (Object)tab.getS("LEFT", KeyEvent.getKeyText(37)).toUpperCase());
        this.keyMap.put("RIGHT", (Object)tab.getS("RIGHT", KeyEvent.getKeyText(39)).toUpperCase());
        this.keyMap.put("UP", (Object)tab.getS("UP", KeyEvent.getKeyText(38)).toUpperCase());
        this.keyMap.put("DOWN", (Object)tab.getS("DOWN", KeyEvent.getKeyText(40)).toUpperCase());
        this.keyMap.put("IN", (Object)tab.getS("IN", KeyEvent.getKeyText(107)).toUpperCase());
        this.keyMap.put("PLUS", (Object)tab.getS("PLUS", KeyEvent.getKeyText(61)).toUpperCase());
        this.keyMap.put("ADD", (Object)tab.getS("ADD", KeyEvent.getKeyText(107)).toUpperCase());
        this.keyMap.put("OUT", (Object)tab.getS("OUT", KeyEvent.getKeyText(109)).toUpperCase());
        this.keyMap.put("MINUS", (Object)tab.getS("MINUS", KeyEvent.getKeyText(45)).toUpperCase());
        this.keyMap.put("SUBTR", (Object)tab.getS("SUBTR", KeyEvent.getKeyText(109)).toUpperCase());
        this.keyMap.put("PAGEUP", (Object)tab.getS("PAGEUP", KeyEvent.getKeyText(33)).toUpperCase());
        this.keyMap.put("HOME", (Object)tab.getS("HOME", KeyEvent.getKeyText(36)).toUpperCase());
        this.keyMap.put("END", (Object)tab.getS("END", KeyEvent.getKeyText(35)).toUpperCase());
        this.keyMap.put("PAGEDOWN", (Object)tab.getS("PAGEDOWN", KeyEvent.getKeyText(34)).toUpperCase());
        String xcut = tab.getS("XCUT");
        String ycut = tab.getS("YCUT");
        if (xcut != null) {
            this.keyMap.put("XCUT", (Object)xcut.toUpperCase());
        }
        if (ycut != null) {
            this.keyMap.put("YCUT", (Object)ycut.toUpperCase());
        }
    }

    public boolean zoomInAtMouse() {
        Position p = this.getPosition(this.px, this.py);
        return this.zoomInOutAtPoint(p.x, p.y, this.zoomAdjust);
    }

    public boolean zoomInAtPoint(double x, double y, float percent) {
        percent = this.checkZoomPercent(percent);
        return this.zoomInOutAtPoint(x, y, percent);
    }

    public boolean zoomOutAtMouse() {
        Position p = this.getPosition(this.px, this.py);
        return this.zoomInOutAtPoint(p.x, p.y, 1.0f / this.zoomAdjust);
    }

    public boolean zoomOutAtPoint(double x, double y, float percent) {
        percent = this.checkZoomPercent(percent);
        return this.zoomInOutAtPoint(x, y, 1.0f / percent);
    }

    private boolean zoomInOutAtPoint(double x, double y, float percent) {
        double oldXDelta = this.rx2 - this.rx1;
        double oldYDelta = this.ry2 - this.ry1;
        double newXDelta = oldXDelta * (double)percent;
        double newYDelta = oldYDelta * (double)percent;
        this.rx1 = x - newXDelta / 2.0;
        this.rx2 = x + newXDelta / 2.0;
        this.ry1 = y - newYDelta / 2.0;
        this.ry2 = y + newYDelta / 2.0;
        if (this.rx1 < this.orx1) {
            this.rx1 = this.orx1;
        }
        if (this.rx2 > this.orx2) {
            this.rx2 = this.orx2;
        }
        if (this.ry1 < this.ory1) {
            this.ry1 = this.ory1;
        }
        if (this.ry2 > this.ory2) {
            this.ry2 = this.ory2;
        }
        this.setup();
        this.refresh();
        return true;
    }

    public void setMouseWheelZoom(boolean val) {
        this.mouseWheelZoom = val;
    }

    public boolean getMouseWheelZoom() {
        return this.mouseWheelZoom;
    }

    public void setDblClickZoom(boolean val) {
        this.dblClickZoom = val;
    }

    public boolean getDblClickZoom() {
        return this.dblClickZoom;
    }

    public void setZoomAdjust(float value) {
        this.zoomAdjust = value;
    }

    public float getZoomAdjust() {
        return this.zoomAdjust;
    }

    public float getZoomPercentage() {
        return this.zoomPercent;
    }

    public void setZoomPercentage(float percent) {
        if (percent > 0.0f && percent <= 1.0f) {
            this.zoomPercent = percent;
        }
    }

    public void setZoomMult(float mult) {
        this.zoomMult = mult;
    }

    public float getZoomMult() {
        return this.zoomMult;
    }

    @InternalUseOnly
    public void setZoomKeep(boolean keep) {
        this.zoomKeep = keep;
    }

    @InternalUseOnly
    public boolean getZoomKeep() {
        return this.zoomKeep;
    }

    public boolean adjustZoom(String dir) {
        return this.adjustZoom(dir, this.zoomAdjust);
    }

    public boolean adjustZoom(String dir, float percent) {
        if (Tolerance.equals(this.rx1, this.orx1) && Tolerance.equals(this.rx2, this.orx2) && Tolerance.equals(this.ry1, this.ory1) && Tolerance.equals(this.ry2, this.ory2)) {
            return false;
        }
        percent = this.checkZoomPercent(percent);
        double rx1Temp = this.rx1;
        double rx2Temp = this.rx2;
        double ry1Temp = this.ry1;
        double ry2Temp = this.ry2;
        double rxDelta = this.rx2 - this.rx1;
        double ryDelta = this.ry2 - this.ry1;
        double amtX = rxDelta * (double)percent;
        double amtY = ryDelta * (double)percent;
        double[] obj = new double[4];
        if (dir.equals("UP")) {
            ry1Temp += amtY;
            ry2Temp += amtY;
        } else if (dir.equals("DOWN")) {
            ry1Temp -= amtY;
            ry2Temp -= amtY;
        } else if (dir.equals("LEFT")) {
            rx1Temp -= amtX;
            rx2Temp -= amtX;
        } else if (dir.equals("RIGHT")) {
            rx1Temp += amtX;
            rx2Temp += amtX;
        }
        obj[0] = rx1Temp;
        obj[1] = rx2Temp;
        obj[2] = ry1Temp;
        obj[3] = ry2Temp;
        Message msg = new Message("PANXY", 2, obj);
        this.mh.processMessage(msg);
        return true;
    }

    private double[] adjustBorders(double rx1Temp, double rx2Temp, double ry1Temp, double ry2Temp) {
        if (!this.isLatLonView()) {
            return new double[]{rx1Temp, rx2Temp, ry1Temp, ry2Temp};
        }
        double rxDelta = this.rx2 - this.rx1;
        double ryDelta = this.ry2 - this.ry1;
        double orxDelta = this.orx2 - this.orx1;
        double oryDelta = this.ory2 - this.ory1;
        double margin = this.orx1 - this.rx1;
        if (this.view != 14) {
            if (rx1Temp < this.orx1) {
                rx1Temp = this.orx1;
                rx2Temp = rx1Temp + Math.min(orxDelta, rxDelta);
            }
            if (rx2Temp > this.orx2) {
                rx2Temp = this.orx2;
                rx1Temp = rx2Temp - Math.min(orxDelta, rxDelta);
            }
            if (ry1Temp < this.ory1) {
                ry1Temp = this.ory1;
                ry2Temp = ry1Temp + Math.min(oryDelta, ryDelta);
            }
            if (ry2Temp > this.ory2) {
                ry2Temp = this.ory2;
                ry1Temp = ry2Temp - Math.min(oryDelta, ryDelta);
            }
        } else {
            if (rx2Temp - rx1Temp > rxDelta + 1.0E-4) {
                if (rx2Temp > (double)LONGITUDE_CONTINUOUS_MAX) {
                    rx2Temp -= (double)LONGITUDE_RANGE;
                    rx1Temp -= (double)LONGITUDE_RANGE;
                } else if (rx1Temp < (double)LONGITUDE_CONTINUOUS_MIN) {
                    rx1Temp += (double)LONGITUDE_RANGE;
                    rx2Temp += (double)LONGITUDE_RANGE;
                } else {
                    rx2Temp = rx1Temp + (double)LONGITUDE_RANGE;
                }
                this.orx1 = rx1Temp;
                this.orx2 = rx1Temp + (double)LONGITUDE_RANGE;
                this.rstk[0] = this.rx1;
                this.rstk[1] = this.rx2;
            } else if (rx1Temp < this.orx1 - margin) {
                this.orx1 = rx1Temp + margin;
                while (this.orx1 < (double)LONGITUDE_CONTINUOUS_MIN) {
                    this.orx1 += (double)LONGITUDE_RANGE;
                }
                rx1Temp = this.orx1 - margin;
                rx2Temp = rx1Temp + rxDelta;
                this.orx2 = this.orx1 + (double)LONGITUDE_RANGE;
                this.rstk[0] = rx1Temp;
                this.rstk[1] = rx2Temp;
            } else if (rx2Temp > this.orx2 + margin) {
                this.orx2 = rx2Temp - margin;
                while (this.orx2 > (double)LONGITUDE_CONTINUOUS_MAX) {
                    this.orx2 -= (double)LONGITUDE_RANGE;
                }
                rx2Temp = this.orx2 + margin;
                rx1Temp = rx2Temp - rxDelta;
                this.orx1 = this.orx2 - (double)LONGITUDE_RANGE;
                rx2Temp = this.orx2 + margin;
                this.rstk[0] = rx1Temp = rx2Temp - rxDelta;
                this.rstk[1] = rx2Temp;
            }
            if (ry1Temp < this.ory1) {
                ry1Temp = this.ory1;
                ry2Temp = ry1Temp + Math.min(oryDelta, ryDelta);
            }
            if (ry2Temp > this.ory2) {
                ry2Temp = this.ory2;
                ry1Temp = ry2Temp - Math.min(oryDelta, ryDelta);
            }
            this.setOuterLimits(this.getOuterBounds());
            this.setViewLimits(this.getViewLimits());
        }
        return new double[]{rx1Temp, rx2Temp, ry1Temp, ry2Temp};
    }

    public boolean zoomIn() {
        return this.zoomIn(this.getZoomPercentage());
    }

    public boolean zoomIn(float percent) {
        percent = this.checkZoomPercent(percent);
        percent = 1.0f - percent;
        return this.zoomInOut(percent);
    }

    public boolean zoomOut() {
        return this.zoomOut(this.getZoomPercentage());
    }

    public boolean zoomOut(float percent) {
        double p = 1.0E-5;
        if (this.rx1 < this.orx1 + p && this.rx1 > this.orx1 - p && this.rx2 < this.orx2 + p && this.rx2 > this.orx2 - p && this.ry1 < this.ory1 + p && this.ry1 > this.ory1 - p && this.ry2 < this.ory2 + p && this.ry2 > this.ory2 - p) {
            return false;
        }
        if (percent == -1.0f) {
            return this.zoomInOut(percent);
        }
        percent = this.checkZoomPercent(percent);
        percent = 1.0f / (1.0f - percent);
        return this.zoomInOut(percent);
    }

    private boolean zoomInOut(float percent) {
        boolean ok = true;
        if (percent == -1.0f) {
            this.rx1 = this.rstk[0];
            this.rx2 = this.rstk[1];
            this.ry1 = this.rstk[2];
            this.ry2 = this.rstk[3];
            this.rz1 = this.rstk[4];
            this.rz2 = this.rstk[5];
            this.setViewLimits("X1", this.rx1);
            this.setViewLimits("X2", this.rx2);
            this.setViewLimits("Y1", this.ry1);
            this.setViewLimits("Y2", this.ry2);
            this.setViewLimits("Z1", this.rz1);
            this.setViewLimits("Z2", this.rz2);
            this.zoomed = false;
            this.setup();
            this.refresh();
            this.reset(-1);
            this.lastLevel = 0;
            this.level = 0;
            return true;
        }
        double oldXDelta = Math.abs(this.rx2 - this.rx1);
        double oldYDelta = Math.abs(this.ry2 - this.ry1);
        double centerX = this.rx1 + oldXDelta / 2.0;
        double centerY = this.ry1 + oldYDelta / 2.0;
        double newXDelta = oldXDelta * (double)percent;
        double newYDelta = oldYDelta * (double)percent;
        boolean centeringOnMouse = false;
        double rx1New = this.rx1;
        double rx2New = this.rx2;
        double ry1New = this.ry1;
        double ry2New = this.ry2;
        if (this.useMousePosition) {
            int mousePixelX = (int)MouseInfo.getPointerInfo().getLocation().getX() - this.panel.getLocationOnScreen().x;
            int mousePixelY = (int)MouseInfo.getPointerInfo().getLocation().getY() - this.panel.getLocationOnScreen().y;
            Position mousePos = this.getPosition(mousePixelX, mousePixelY);
            boolean bl = centeringOnMouse = mousePos.x > Math.max(this.orx1, this.rx1) && mousePos.x < Math.min(this.orx2, this.rx2) && mousePos.y > Math.max(this.ory1, this.ry1) && mousePos.y < Math.min(this.ory2, this.ry2);
            if (centeringOnMouse) {
                boolean onTop;
                boolean onLeft = mousePos.x - this.rx1 < this.rx2 - mousePos.x;
                boolean bl2 = onTop = mousePos.y - this.ry1 < this.ry2 - mousePos.y;
                if (onLeft) {
                    rx1New = mousePos.x - (double)percent * (mousePos.x - this.rx1);
                    rx2New = rx1New + newXDelta;
                } else {
                    rx2New = mousePos.x + (double)percent * (this.rx2 - mousePos.x);
                    rx1New = rx2New - newXDelta;
                }
                if (onTop) {
                    ry1New = mousePos.y - (double)percent * (mousePos.y - this.ry1);
                    ry2New = ry1New + newYDelta;
                } else {
                    ry2New = mousePos.y + (double)percent * (this.ry2 - mousePos.y);
                    ry1New = ry2New - newYDelta;
                }
            }
        }
        if (!centeringOnMouse) {
            rx1New = centerX - newXDelta / 2.0;
            rx2New = centerX + newXDelta / 2.0;
            ry1New = centerY - newYDelta / 2.0;
            ry2New = centerY + newYDelta / 2.0;
        }
        if (ry1New - ry2New == 0.0 || rx1New - rx2New == 0.0) {
            return true;
        }
        this.rx1 = rx1New;
        this.rx2 = rx2New;
        this.ry1 = ry1New;
        this.ry2 = ry2New;
        if (this.rstk[0] < this.rstk[1]) {
            if (this.rx1 < this.rstk[0]) {
                this.rx1 = this.rstk[0];
                ok = false;
            }
            if (this.rx2 > this.rstk[1]) {
                this.rx2 = this.rstk[1];
                ok = false;
            }
        } else {
            if (this.rx1 > this.rstk[0]) {
                this.rx1 = this.rstk[0];
                ok = false;
            }
            if (this.rx2 < this.rstk[1]) {
                this.rx2 = this.rstk[1];
                ok = false;
            }
        }
        if (this.rstk[2] < this.rstk[3]) {
            if (this.ry1 < this.rstk[2]) {
                this.ry1 = this.rstk[2];
            }
            if (this.ry2 > this.rstk[3]) {
                this.ry2 = this.rstk[3];
            }
        } else {
            if (this.ry1 > this.rstk[2]) {
                this.ry1 = this.rstk[2];
            }
            if (this.ry2 < this.rstk[3]) {
                this.ry2 = this.rstk[3];
            }
        }
        this.setViewLimits("X1", this.rx1);
        this.setViewLimits("X2", this.rx2);
        this.setViewLimits("Y1", this.ry1);
        this.setViewLimits("Y2", this.ry2);
        this.zoomed = ok;
        this.setup();
        this.refresh();
        return ok;
    }

    private float checkZoomPercent(float percent) {
        if (percent <= 0.0f || percent >= 1.0f) {
            Shell.warning("Invalid percentage: " + percent + ". ZOOM IN/OUT percentages must be greater than 0 and less than 1. Setting to default: " + 0.5f);
            percent = 0.5f;
        }
        return percent;
    }

    public boolean zoom(Object rxy, int mode) {
        return this.zoom(rxy, mode, true);
    }

    public boolean zoom(Object rxy, int mode, boolean history) {
        if (this.level >= 15) {
            return false;
        }
        double x1 = this.rx1;
        double x2 = this.rx2;
        double y1 = this.ry1;
        double y2 = this.ry2;
        double lon1 = -180.0;
        double lon2 = 180.0;
        double lat1 = -90.0;
        double lat2 = 90.0;
        if (mode == 0) {
            mode = 3;
        }
        boolean xZoom = (mode & 1) != 0;
        boolean yZoom = (mode & 2) != 0;
        boolean cutOffZoomToVisibleArea = false;
        if (rxy instanceof DragBox) {
            this.dragboxAdjustment = true;
            DragBox dragbox = (DragBox)rxy;
            cutOffZoomToVisibleArea = true;
            if (this.view == 13) {
                x1 = dragbox.getGeoXMin();
                x2 = dragbox.getGeoXMax();
                y1 = dragbox.getGeoYMin();
                y2 = dragbox.getGeoYMax();
                lon1 = dragbox.getXMin();
                lon2 = dragbox.getXMax();
                lat1 = dragbox.getYMin();
                lat2 = dragbox.getYMax();
            } else {
                x1 = dragbox.getXMin();
                x2 = dragbox.getXMax();
                y1 = dragbox.getYMin();
                y2 = dragbox.getYMax();
            }
        } else if (rxy instanceof Data || rxy instanceof double[]) {
            x1 = Convert.o2d(rxy, 0, this.rx1);
            x2 = Convert.o2d(rxy, 1, this.rx2);
            y1 = Convert.o2d(rxy, 2, this.ry1);
            y2 = Convert.o2d(rxy, 3, this.ry2);
            if (this.view == 13) {
                lon1 = Convert.o2d(rxy, 4, -180.0);
                lon2 = Convert.o2d(rxy, 5, 180.0);
                lat1 = Convert.o2d(rxy, 7, -90.0);
                lat2 = Convert.o2d(rxy, 6, 90.0);
            }
        } else {
            Table tab = Convert.o2t(rxy);
            if (tab != null) {
                x1 = tab.getD("XMIN", tab.getD("X1", this.rx1));
                x2 = tab.getD("XMAX", tab.getD("X2", this.rx2));
                y1 = tab.getD("YMIN", tab.getD("Y1", this.ry1));
                y2 = tab.getD("YMAX", tab.getD("Y2", this.ry2));
            }
        }
        int oldView = this.view;
        if (this.view == 13 && (this.options & 0x1000) != 0) {
            double LIMIT = 15.0;
            double LON_LIMIT = 180.0 - LIMIT - 2.5;
            double LAT_LIMIT = 90.0 - LIMIT - 2.5;
            if (Math.abs(lon1 - lon2) <= LIMIT && Math.abs(lat1 - lat2) <= LIMIT && !(Math.abs(lon1) > LON_LIMIT) && !(Math.abs(lon2) > LON_LIMIT) && !(Math.abs(lat1) > LAT_LIMIT) && !(Math.abs(lat2) > LAT_LIMIT)) {
                this.setView(12, false);
                x1 = lon1;
                x2 = lon2;
                y1 = lat1;
                y2 = lat2;
            }
        }
        if (this.isLatLonView() && cutOffZoomToVisibleArea) {
            double zoomBoundXMin = Math.max(Math.min(this.rx1, this.rx2), Math.min(this.orx1, this.orx2));
            double zoomBoundXMax = Math.min(Math.max(this.rx1, this.rx2), Math.max(this.orx1, this.orx2));
            double zoomBoundYMin = Math.max(Math.min(this.ry1, this.ry2), Math.min(this.ory1, this.ory2));
            double zoomBoundYMax = Math.min(Math.max(this.ry1, this.ry2), Math.max(this.ory1, this.ory2));
            if (xZoom && (x2 < zoomBoundXMin || x1 > zoomBoundXMax) || yZoom && (y2 < zoomBoundYMin || y1 > zoomBoundYMax)) {
                return false;
            }
            if (this.level == 0 && this.view == 14) {
                this.llc_orx1 = this.orx1;
                this.llc_orx2 = this.orx2;
            }
            x1 = Math.max(x1, Math.max(this.rx1, this.orx1));
            x2 = Math.min(x2, Math.min(this.rx2, this.orx2));
            y1 = Math.max(y1, Math.max(this.ry1, this.ory1));
            y2 = Math.min(y2, Math.min(this.ry2, this.ory2));
        }
        if (history) {
            this.lastLevel = this.level;
            int i = this.level * 7;
            if (this.level > 0 || !this.zoomed) {
                this.rstk[i + 0] = this.rx1;
                this.rstk[i + 1] = this.rx2;
                this.rstk[i + 2] = this.ry1;
                this.rstk[i + 3] = this.ry2;
                this.rstk[i + 4] = this.rz1;
                this.rstk[i + 5] = this.rz2;
            }
            this.rstk[i + 6] = oldView;
            ++this.level;
            this.lastLevel = this.level;
        }
        if (xZoom) {
            this.rx1 = Math.min(x1, x2);
            this.rx2 = Math.max(x1, x2);
            this.setUserLimits("X1", this.rx1, false);
            this.setUserLimits("X2", this.rx2, false);
        }
        if (yZoom) {
            this.ry1 = Math.min(y1, y2);
            this.ry2 = Math.max(y1, y2);
            this.setUserLimits("Y1", this.ry1, false);
            this.setUserLimits("Y2", this.ry2, false);
        }
        this.setup();
        return true;
    }

    private void shiftMoreLatLonMap() {
        double margin;
        boolean yRangeNotFull;
        double xRange = this.rx2 - this.rx1;
        double yRange = this.ry2 - this.ry1;
        double xOuterRange = this.orx2 - this.orx1;
        double yOuterRange = this.ory2 - this.ory1;
        boolean xRangeNotFull = xRange < xOuterRange;
        boolean bl = yRangeNotFull = yRange < yOuterRange;
        if (this.view == 11) {
            if (xRangeNotFull) {
                if (this.rx2 > this.orx2) {
                    this.rx1 = this.orx2 - xRange;
                    this.rx2 = this.orx2;
                } else if (this.rx1 < this.orx1) {
                    this.rx1 = this.orx1;
                    this.rx2 = this.orx1 + xRange;
                }
            } else {
                margin = (xRange - xOuterRange) / 2.0;
                this.rx1 = this.orx1 - margin;
                this.rx2 = this.orx2 + margin;
            }
        }
        if (this.view == 11 || this.view == 14) {
            if (yRangeNotFull) {
                if (this.ry2 > this.ory2) {
                    this.ry1 = this.ory2 - yRange;
                    this.ry2 = this.ory2;
                } else if (this.ry1 < this.ory1) {
                    this.ry1 = this.ory1;
                    this.ry2 = this.ory1 + xRange;
                }
            } else {
                margin = (yRange - yOuterRange) / 2.0;
                this.ry1 = this.ory1 - margin;
                this.ry2 = this.ory2 + margin;
            }
        }
    }

    public boolean unzoom() {
        return this.unzoom(this.level - 1);
    }

    public boolean unzoom(int newlevel) {
        return this.unzoom(newlevel, false);
    }

    private boolean unzoom(int newlevel, boolean doReset) {
        if (this.level <= 0 || this.level <= newlevel) {
            return false;
        }
        this.lastLevel = this.level;
        this.level = newlevel;
        int i = this.level * 7;
        this.rx1 = this.rstk[i + 0];
        this.rx2 = this.rstk[i + 1];
        this.ry1 = this.rstk[i + 2];
        this.ry2 = this.rstk[i + 3];
        this.rz1 = this.rstk[i + 4];
        this.rz2 = this.rstk[i + 5];
        if (this.view == 14) {
            if (this.level <= 0) {
                this.rx1 = this.orx1 = this.llc_orx1;
                this.rx2 = this.orx2 = this.llc_orx2;
                this.ry1 = this.ory1;
                this.ry2 = this.ory2;
            }
            this.reset(-1);
        }
        this.viewLimits.clear();
        this.setup();
        if (!doReset && !this.setView((int)this.rstk[i + 6], false)) {
            this.refresh();
        }
        this.lastLevel = this.level;
        return true;
    }

    public void addLayer(String name, Layer layer) {
        layer.setName(name.toUpperCase());
        this.addLayer(layer);
    }

    public void addLayer(Layer layer) {
        String parentName;
        layer.setMPlot(this);
        if (this.layerDrawable == null && layer instanceof LayerDrawable) {
            this.layerDrawable = (LayerDrawable)layer;
        }
        if ((parentName = layer.getGroup()) == null || parentName.isEmpty()) {
            this.addToLayersArray(layer);
        } else {
            LayerDrawable parent = (LayerDrawable)this.layers.get(parentName);
            if (parent != null) {
                parent.addDrawable(layer);
                if (this.baseLayer == null) {
                    layer.makeBaseLayer();
                }
            } else {
                this.addToLayersArray(layer);
            }
        }
        if (!this.zoomKeep) {
            this.reset(-1);
        }
        if (!this.unitsInit && layer.isBaseLayer()) {
            this.setXYZUnits(layer.getXUnits(), layer.getYUnits(), layer.getZUnits(), true);
            this.unitsInit = true;
        }
    }

    private void addToLayersArray(Layer lay) {
        this.layers.put(lay.name, lay);
        if (lay.getClassName().equals("LayerWMS")) {
            ++this.wmsLayerCnt;
        }
        if ((this.baseLayer == null || this.baseLayer != null && this.baseLayer.name.equals(lay.name)) && this.layers.size() >= 2) {
            lay.makeBaseLayer();
        }
    }

    public void removeLayer(String name) {
        if (name == null) {
            return;
        }
        if ((name = name.toUpperCase()).equals("GRID")) {
            return;
        }
        Layer lay = (Layer)this.layers.get(name);
        if (lay.isBaseLayer()) {
            this.nullArchivedFrames();
        }
        if (lay != null) {
            if ("LayerWMS".equals(lay.getClassName())) {
                --this.wmsLayerCnt;
            }
            lay.close();
        }
        if (lay.isBaseLayer()) {
            this.baseLayer = null;
        }
        this.layers.remove(name);
        if (!this.zoomKeep) {
            this.reset(-1);
        }
    }

    public void addFeature(String name, Feature feature) {
        feature.setName(name.toUpperCase());
        this.addFeature(feature);
    }

    public void addFeature(Feature feature) {
        Layer lay = this.getBaseLayer();
        PlotFile pf = null;
        if (lay != null) {
            pf = lay.pf;
        }
        if (lay != null && lay.typeClass == 1 && feature.isType(2) && pf != null && this.getOption(2048) && (double)lay.frame < lay.pf.getSize()) {
            double elems = lay.pf.getSize();
            int frames = lay.frame;
            Shell.warning("FrameSize=" + frames + " and No. of Elements=" + elems + ". When using '/ALL' switch, Data Features on Layer 1D plots do not display if frame size is less than number of elements in file. Use '/FS=' to increase frame size greater than " + elems + ", if possible.");
        }
        feature.setPlot(this);
        Layer featLayer = feature.getLayer();
        if (featLayer instanceof LayerDrawable) {
            ((LayerDrawable)featLayer).addDrawable(feature);
        } else {
            this.features.put(feature.getName().toUpperCase(), feature);
        }
        this.needRefresh = true;
    }

    public void addFeatureToGroup(Feature feature) {
        String groupName = feature.getGroup();
        if (groupName == null) {
            Shell.warning("Feature need group name to added to FeatureGroup " + feature);
        } else if (this.featureGroups.get(feature.getGroup()) != null) {
            this.featureGroups.addFeatureToGroup(feature, (FeatureGroup)this.featureGroups.get(feature.getGroup()));
        } else {
            this.featureGroups.addFeatureToGroup(feature, new FeatureGroup(feature));
        }
    }

    @InternalUseOnly
    public void moveFeatureToGroup(String oldGroup, Feature feature) {
        this.featureGroups.moveFeatureToGroup(oldGroup, feature);
    }

    @InternalUseOnly
    public void moveAllFeatures(String oldGroup, String newGroup) {
        this.featureGroups.moveAllFeatures(oldGroup, newGroup);
    }

    @InternalUseOnly
    public Map<String, FeatureGroup> getFeatureGroups() {
        return this.featureGroups;
    }

    public void addFeature(Table tfeats) {
        Table.Iterator ti = tfeats.iterator();
        for (int i = 0; i < ti.size; ++i) {
            this.addFeature((Feature)ti.values[i]);
        }
    }

    public void removeFeature(String name) {
        FeatureGroup fg;
        Feature feature = (Feature)this.features.get(name = name.toUpperCase());
        if (feature == null) {
            return;
        }
        if (feature.getGroup() != null && !feature.getGroup().isEmpty() && (fg = (FeatureGroup)this.featureGroups.get(feature.getGroup())) != null) {
            fg.removeFeature(feature);
        }
        this.features.remove(name);
        this.refresh();
    }

    public void removeAllFeatures() {
        this.features.clear();
        this.featureGroups.clear();
        this.refresh();
    }

    public void loadFeatures(String filename) {
        FileName fnFilename = new FileName(filename, FileName.FNCase.KeepCase);
        TextFile tf = new TextFile(fnFilename);
        Table t = new Table();
        t.fromTextFile(tf);
        this.loadFeatures(t);
    }

    public void loadFeatures(Table table) {
        Table.Iterator ti = table.iterator();
        for (int i = 0; i < ti.size; ++i) {
            Table ft = Convert.o2t(ti.values[i]);
            Feature f = new Feature(ft);
            this.addFeature(f);
        }
    }

    public void saveFeatures(String filename) {
        if (filename.indexOf(46) < 0) {
            filename = filename + ".tbl";
        }
        Table ft = new Table();
        for (int i = 0; i < this.features.size(); ++i) {
            Feature f = (Feature)this.features.get(i);
            ft.put(f.getName(), (Object)f.toTable());
        }
        FileName fnFilename = new FileName(filename, FileName.FNCase.KeepCase);
        TextFile tf = new TextFile(fnFilename);
        ft.toTextFile(tf);
        Shell.info("Saved FEATURES to: " + tf.getURL());
    }

    public void reset(int n) {
        boolean unzooming;
        boolean bl = unzooming = this.level < this.lastLevel;
        if (n < 0) {
            for (int i = 0; i < this.images.length; ++i) {
                this.images[i] = null;
            }
        } else if (unzooming) {
            for (int i = this.lastLevel; i > this.level; --i) {
                this.images[i] = null;
            }
        } else {
            this.images[n] = null;
        }
        this.dbimage = null;
        if (!unzooming || n < 0 || this.images[n] != null) {
            // empty if block
        }
    }

    public void resetForRefresh() {
        if ((this.options & 1) == 0) {
            for (int i = 1; i < this.layers.size(); ++i) {
                ((Layer)this.layers.get(i)).reset();
            }
        }
    }

    boolean doDraw(Drawable d, int drawmode, int flags) {
        boolean inbs;
        if (d == null) {
            return false;
        }
        int en = d.getEnable();
        if ((en & 1) == 0) {
            if ((flags & 1) != 0) {
                d.clearNeedRefresh();
            }
            return false;
        }
        boolean doit = true;
        boolean bl = inbs = (this.options & 1) != 0 && (en & 4) != 0;
        if ((flags & 2) != 0) {
            doit = inbs;
        }
        if ((flags & 4) != 0) {
            boolean bl2 = doit = !inbs;
        }
        if ((flags & 1) != 0 && (doit || (flags & 8) != 0)) {
            this.lastColor = null;
            this.lastLine = null;
            if (drawmode == 0) {
                d.reset();
            }
            d.draw(drawmode);
        }
        return doit;
    }

    public void findRange() {
        int istart = 1;
        if (this.view == 13) {
            istart = 0;
        }
        for (int i = istart; i < this.layers.size(); ++i) {
            Layer layer = (Layer)this.layers.get(i);
            if (!this.doDraw(layer, 0, 0)) continue;
            layer.rescale();
            if (i == istart) {
                this.orx1 = layer.x1;
                this.orx2 = layer.x2;
                this.ory1 = layer.y1;
                this.ory2 = layer.y2;
                this.orz1 = layer.z1;
                this.orz2 = layer.z2;
            } else {
                if (layer.x1 < this.orx1) {
                    this.orx1 = layer.x1;
                }
                if (layer.x2 > this.orx2) {
                    this.orx2 = layer.x2;
                }
                if (layer.y1 < this.ory1) {
                    this.ory1 = layer.y1;
                }
                if (layer.y2 > this.ory2) {
                    this.ory2 = layer.y2;
                }
                if (layer.z1 < this.orz1) {
                    this.orz1 = layer.z1;
                }
                if (layer.z2 > this.orz2) {
                    this.orz2 = layer.z2;
                }
            }
            layer.findFullRange();
            if (i == istart) {
                this.frx1 = layer.fx1;
                this.frx2 = layer.fx2;
                this.fry1 = layer.fy1;
                this.fry2 = layer.fy2;
                this.frz1 = layer.fz1;
                this.frz2 = layer.fz2;
            } else {
                if (layer.fx1 < this.frx1) {
                    this.frx1 = layer.fx1;
                }
                if (layer.fx2 > this.frx2) {
                    this.frx2 = layer.fx2;
                }
                if (layer.fy1 < this.fry1) {
                    this.fry1 = layer.fy1;
                }
                if (layer.fy2 > this.fry2) {
                    this.fry2 = layer.fy2;
                }
                if (layer.fz1 < this.frz1) {
                    this.frz1 = layer.fz1;
                }
                if (layer.fz2 > this.frz2) {
                    this.frz2 = layer.fz2;
                }
            }
            if ((this.options & 0x800) == 0) continue;
            this.orx1 = this.frx1;
            this.orx2 = this.frx2;
            this.ory1 = this.fry1;
            this.ory2 = this.fry2;
            this.orz1 = this.frz1;
            this.orz2 = this.frz2;
        }
        if (this.view == 10) {
            double r = Math.max(Math.abs(this.ory1), Math.abs(this.ory2));
            this.orx1 = -r;
            this.orx2 = r;
            this.ory1 = -r;
            this.ory2 = r;
        }
    }

    public void useRange() {
        if (this.view == 13) {
            this.rx1 = -1.2;
            this.rx2 = 1.2;
            this.ry1 = -1.2;
            this.ry2 = 1.2;
            this.frx1 = this.rx1;
            this.frx2 = this.rx2;
            this.fry1 = this.ry1;
            this.fry2 = this.ry2;
        } else if (this.is3DView()) {
            double rangeMax = this.view == 15 ? 2.5 : 1.2;
            this.ry1 = this.rz1 = -rangeMax;
            this.rx1 = this.rz1;
            this.ry2 = this.rz2 = rangeMax;
            this.rx2 = this.rz2;
            if (this.orz1 <= 0.0 && this.orz2 >= 0.0) {
                double z = Math.max(this.orz2, -this.orz1);
                this.orz1 = -z;
                this.orz2 = z;
            }
            this.frx1 = this.rx1;
            this.frx2 = this.rx2;
            this.fry1 = this.ry1;
            this.fry2 = this.ry2;
            this.frz1 = this.rz1;
            this.frz2 = this.rz2;
        } else {
            this.rx1 = this.orx1;
            this.rx2 = this.orx2;
            if (this.rx1 == this.rx2) {
                double xUlp = Math.ceil(Math.ulp((float)this.rx1));
                this.rx1 -= xUlp;
                this.rx2 += xUlp;
            }
            this.ry1 = this.ory1;
            this.ry2 = this.ory2;
            if (this.ry1 == this.ry2) {
                double yUlp = Math.ceil(Math.ulp((float)this.ry1));
                this.ry1 -= yUlp;
                this.ry2 += yUlp;
            }
            this.rz1 = this.orz1;
            this.rz2 = this.orz2;
            if (this.rz1 == this.rz2) {
                double zUlp = Math.ceil(Math.ulp((float)this.rz1));
                this.rz1 -= zUlp;
                this.rz2 += zUlp;
            }
            if ((this.scale & 0xC) == 12) {
                if (this.ry2 - this.ry1 > this.maxRange) {
                    this.ry1 = this.ry2 - this.maxRange;
                }
                if (this.ry2 - this.ry1 < this.minRange) {
                    this.ry1 = this.ry2 - this.minRange;
                }
            } else if ((this.scale & 0xC) == 8) {
                this.ry1 = this.ry2 - this.maxRange;
            } else if ((this.scale & 0xC) == 4) {
                this.ry2 = this.ry1 + this.minRange;
            }
            if ((this.scale & 0x20) != 0) {
                this.rz1 = this.rz2 - this.maxRange;
            }
            if ((this.scale & 0x10) != 0) {
                this.rz2 = this.rz1 + this.minRange;
            }
        }
        this.rx1 -= this.axisBuffer;
        this.rx2 += this.axisBuffer;
        if (this.view == 14) {
            if (this.orx1 < (double)LONGITUDE_CONTINUOUS_MIN) {
                double invalidShift = (double)LONGITUDE_CONTINUOUS_MIN - this.rx1;
                this.rx1 = this.orx1 = (double)LONGITUDE_CONTINUOUS_MIN;
                this.rx2 = this.orx2 = Math.max(this.rx2 + invalidShift, (double)LONGITUDE_DEFAULT_MAX);
            }
            if (this.orx2 - this.orx1 > (double)LONGITUDE_RANGE) {
                this.rx1 = this.orx1 = this.orx2 - (double)LONGITUDE_RANGE;
            }
        }
        this.ry1 -= this.axisBuffer;
        this.ry2 += this.axisBuffer;
        this.rstk[0] = this.rx1;
        this.rstk[1] = this.rx2;
        this.rstk[2] = this.ry1;
        this.rstk[3] = this.ry2;
        this.rstk[4] = this.rz1;
        this.rstk[5] = this.rz2;
        this.setup();
    }

    public void applyUserBounds(String type) {
        double tmp;
        type = type.toUpperCase();
        boolean changedView = false;
        boolean changedOuter = false;
        if (type == null || type.equals("ALL") || type.equals("OUTER")) {
            if (this.outerLimits.containsKey("X1") && (tmp = this.outerLimits.getD("X1")) != this.orx1) {
                this.orx1 = tmp;
                changedOuter = true;
                if (this.view == 14) {
                    this.rstk[0] = this.llc_orx1 = this.orx1;
                }
            }
            if (this.outerLimits.containsKey("X2") && (tmp = this.outerLimits.getD("X2")) != this.orx2) {
                this.orx2 = tmp;
                changedOuter = true;
                if (this.view == 14) {
                    this.rstk[1] = this.orx2;
                    this.rstk[1] = this.llc_orx2 = this.orx2;
                }
            }
            if (this.outerLimits.containsKey("Y1") && (tmp = this.outerLimits.getD("Y1")) != this.ory1) {
                this.ory1 = tmp;
                changedOuter = true;
            }
            if (this.outerLimits.containsKey("Y2") && (tmp = this.outerLimits.getD("Y2")) != this.ory2) {
                this.ory2 = tmp;
                changedOuter = true;
            }
            if (this.outerLimits.containsKey("Z1") && (tmp = this.outerLimits.getD("Z1")) != this.orz1) {
                this.orz1 = tmp;
                changedOuter = true;
            }
            if (this.outerLimits.containsKey("Z2") && (tmp = this.outerLimits.getD("Z2")) != this.orz2) {
                this.orz2 = tmp;
                changedOuter = true;
            }
        }
        if (type == null || type.equals("ALL") || type.startsWith("VIEW")) {
            if (this.viewLimits.containsKey("X1") && (tmp = this.viewLimits.getD("X1")) != this.rx1) {
                this.rx1 = tmp;
                changedView = true;
            }
            if (this.viewLimits.containsKey("X2") && (tmp = this.viewLimits.getD("X2")) != this.rx2) {
                this.rx2 = tmp;
                changedView = true;
            }
            if (this.viewLimits.containsKey("Y1") && (tmp = this.viewLimits.getD("Y1")) != this.ry1) {
                this.ry1 = tmp;
                changedView = true;
            }
            if (this.viewLimits.containsKey("Y2") && (tmp = this.viewLimits.getD("Y2")) != this.ry2) {
                this.ry2 = tmp;
                changedView = true;
            }
            if (this.viewLimits.containsKey("Z1") && (tmp = this.viewLimits.getD("Z1")) != this.rz1) {
                this.rz1 = tmp;
                changedView = true;
            }
            if (this.viewLimits.containsKey("Z2") && (tmp = this.viewLimits.getD("Z2")) != this.rz2) {
                this.rz2 = tmp;
                changedView = true;
            }
        }
        if (changedView || changedOuter) {
            this.checkBounds(changedView, changedOuter);
            if (this.viewLimits != null && !this.viewLimits.isEmpty()) {
                this.checkNeedTreatAsZoom();
            }
            this.setup();
            this.refresh();
        }
    }

    private void checkBounds(boolean warnView, boolean warnOuter) {
        this.checkBounds("RX", warnView);
        this.checkBounds("RY", warnView);
        this.checkBounds("ORX", warnOuter);
        this.checkBounds("ORY", warnOuter);
    }

    private void checkBounds(String dim, boolean warn) {
        double offset = 0.01;
        if (dim.equals("RX") && this.rx1 == this.rx2) {
            if (warn) {
                Shell.warning("View X Min and X Max both set to [" + this.rx1 + "]. Adding 1% of X value to Min and Max.");
            }
            this.rx1 -= Math.max(1.0E-12, this.rx1 * offset);
            this.rx2 += Math.max(1.0E-12, this.rx2 * offset);
        }
        if (dim.equals("RY") && this.ry1 == this.ry2) {
            if (warn) {
                Shell.warning("View Y Min and Y Max both set to [" + this.ry1 + "]. Adding 1% of Y value to Min and Max.");
            }
            this.ry1 -= Math.max(1.0E-12, this.ry1 * offset);
            this.ry2 += Math.max(1.0E-12, this.ry2 * offset);
        }
        if (dim.equals("ORX") && this.orx1 == this.orx2) {
            if (warn) {
                Shell.warning("X Min and X Max both set to [" + this.orx1 + "]. Adding 1% of X value to Min and Max.");
            }
            this.orx1 -= Math.max(1.0E-12, this.orx1 * offset);
            this.orx2 += Math.max(1.0E-12, this.orx2 * offset);
        }
        if (dim.equals("ORY") && this.ory1 == this.ory2) {
            if (warn) {
                Shell.warning("Y Min and Y Max both set to [" + this.ory1 + "]. Adding 1% of Y value to Min and Max.");
            }
            this.ory1 -= Math.max(1.0E-12, this.ory1 * offset);
            this.ory2 += Math.max(1.0E-12, this.ory2 * offset);
        }
    }

    private void checkNeedTreatAsZoom() {
        if (this.level == 0 && this.viewBoundsLTOuterBounds()) {
            this.rstk[0] = this.orx1;
            this.rstk[1] = this.orx2;
            this.rstk[2] = this.ory1;
            this.rstk[3] = this.ory2;
            this.rstk[4] = this.orz1;
            this.rstk[5] = this.orz2;
            this.rstk[6] = this.view;
            ++this.level;
            this.lastLevel = this.level;
        }
    }

    private boolean viewBoundsLTOuterBounds() {
        boolean viewLimitsSmaller;
        double precision = 1.0E-4;
        double xDiff = Math.abs(this.orx2 - this.orx1) - Math.abs(this.rx2 - this.rx1);
        double yDiff = Math.abs(this.ory2 - this.ory1) - Math.abs(this.ry2 - this.ry1);
        double zDiff = Math.abs(this.orz2 - this.orz1) - Math.abs(this.rz2 - this.rz1);
        boolean xlimitsSame = Tolerance.equals(xDiff, 0.0);
        boolean ylimitsSame = Tolerance.equals(yDiff, 0.0);
        boolean zlimitsSame = Tolerance.equals(zDiff, 0.0);
        boolean bl = viewLimitsSmaller = (xlimitsSame || xDiff > precision) && (ylimitsSame || yDiff > precision);
        if (this.view == 13 || this.is3DView()) {
            viewLimitsSmaller &= zlimitsSame || zDiff > precision;
        }
        return viewLimitsSmaller;
    }

    private boolean equalsDataBox(Rectangle r) {
        return r != null && r.width == this.ix21 && r.height == this.iy21 && r.x == this.ix1 && r.y == this.iy1;
    }

    @Deprecated
    public synchronized void paint(Graphics g) {
        this.paintComponent(g);
    }

    private Container findMidasDisplayParent() {
        Container container;
        for (container = this.panel; container != null && !(container instanceof MidasDisplay); container = container.getParent()) {
        }
        return container;
    }

    @Override
    @ProvisionalUseOnly(value="Treat this as protected and should only be called by subclass paintComponent methods")
    public synchronized void paintComponent(Graphics g) {
        boolean fresh;
        super.paintComponent(g);
        this.setGraphics(g);
        boolean isRealtime = Theme.getOption(8);
        if (isRealtime && this.dragging > 0) {
            this.rubberbox(g.create(), 1);
        }
        Rectangle clip = g.getClipBounds();
        if (this.oarbox.toRectangle().contains(clip)) {
            this.setAxisReadout(g, this.plotInfo);
            this.setExtendedReadout(g);
            this.readoutExtTime = Time.current();
            return;
        }
        boolean bl = fresh = !this.equalsDataBox(clip) || !this.useDB && this.dragging > 0;
        if (this.refreshing && !fresh) {
            return;
        }
        boolean fullSwing = SwingUtilities.isEventDispatchThread() && !Theme.getOption(8) && this.useDB;
        int drawmode = fresh || fullSwing ? 0 : this.refreshMode;
        boolean clear = drawmode != 2;
        int flags = 1 | (this.useBS ? 4 : 0);
        if ((this.options & 0x10) != 0) {
            this.drawCrossHairs(-1);
        }
        if (fresh) {
            g.setColor(this.theme.cbg);
            g.fillRect(0, 0, this.pos.w, this.pos.h);
            this.drawAxis(g);
            if ((this.options & 8) == 0) {
                clear = false;
            }
        }
        Shape origClip = g.getClip();
        if (this.needRefresh()) {
            g.setClip(this.ix1, this.iy1, this.ix21, this.iy21);
        } else {
            g.clipRect(this.ix1, this.iy1, this.ix21, this.iy21);
        }
        Image image = this.images[this.level];
        if (this.useDB && this.dbimage != null) {
            image = this.dbimage;
        }
        if (!neverUseDBImageBackup && this.useDBImageBackup && image == null && this.useDB) {
            image = this.dbimageBackup;
        }
        if ((this.useBS || this.useDB) && image != null && clip != null) {
            g.drawImage(image, clip.x, clip.y, clip.x + clip.width, clip.y + clip.height, clip.x, clip.y, clip.x + clip.width, clip.y + clip.height, this.panel);
            clear = false;
        }
        if ((this.axis & 0x1000000) == 0 && (this.axis & 2) != 0) {
            this.drawAxisGrid(g.create());
        }
        if (!this.useDB) {
            this.drawDataArea(g, drawmode, clear, flags);
        }
        if ((this.options & 0x10) != 0) {
            this.needsDrawCH = true;
        }
        if (fresh && this.legend != null && this.legend.getStatus() != -3) {
            this.legend.update();
        }
        if (this.canvas != null) {
            this.canvas.paintComponent(g);
        }
        if ((this.axis & 0x1000000) != 0 && (this.axis & 2) != 0) {
            Graphics gtemp = g.create();
            this.drawAxisGrid(gtemp);
            gtemp.setPaintMode();
            gtemp.dispose();
        }
        if (this.dragging > 0) {
            this.rubberbox(g.create(), 1);
        }
        g.setClip(origClip);
        if ((this.readout & 4) != 0 && clip.contains(this.oarbox.toRectangle()) && !this.oarbox.toRectangle().contains(clip)) {
            this.setAxisReadout(g, this.plotInfo);
            this.setExtendedReadout(g);
            this.readoutExtTime = Time.current();
        }
    }

    private void setExtendedReadout(Graphics g) {
        if (this.onAxisExtendedReadout()) {
            String rightAxisinfo = this.formRightAxisInfo();
            this.setAxisRightReadout(g, rightAxisinfo);
        }
    }

    private boolean onAxisExtendedReadout() {
        return (this.readoutExt & 1) != 0 && (this.readout & 4) != 0 || (this.readout & 8) == 0 && (this.readout & 2) == 0;
    }

    private String formRightAxisInfo() {
        String spacer;
        String rightAxisinfo = "";
        if ((this.readoutExt & 2) != 0) {
            rightAxisinfo = rightAxisinfo + "#MP_Features:" + this.numVisibleFeatures;
        }
        if ((this.readoutExt & 4) != 0 && this.layerDrawable != null) {
            int visiblePoints;
            spacer = "";
            if (!rightAxisinfo.equals("")) {
                spacer = spacer + "  ";
            }
            if ((visiblePoints = this.layerDrawable.getNumVisiblePoints()) >= 0) {
                rightAxisinfo = rightAxisinfo + spacer + "#Points:" + visiblePoints;
            }
        }
        if ((this.readoutExt & 8) != 0 && this.wmsLevel >= 0.0) {
            spacer = "";
            if (!rightAxisinfo.equals("")) {
                spacer = spacer + "  ";
            }
            rightAxisinfo = rightAxisinfo + spacer + "WMS_level:" + String.format("%1.3e", this.wmsLevel);
        }
        return rightAxisinfo;
    }

    boolean isDisplayingWMSLevel() {
        return (this.readoutExt & 8) != 0;
    }

    void setWMSLevel(double wmsLevel) {
        if (wmsLevel == 0.0 && this.wmsLevel != -1.0) {
            return;
        }
        this.wmsLevel = wmsLevel;
    }

    public void refresh(int drawmode) {
        Graphics grt;
        if (!this.isPanelVisible()) {
            return;
        }
        if (this.needRefresh) {
            drawmode = 0;
        }
        boolean alwaysClearBecauseMap = mapRefreshShouldClear && this.isMapView();
        boolean clear = drawmode != 2 || alwaysClearBecauseMap;
        boolean fresh = drawmode != 1 && clear;
        this.cancel = false;
        this.needRefresh = false;
        this.useBS = (this.options & 1) != 0;
        this.useDB = (this.options & 0x2000) != 0;
        Image image = this.images[this.level];
        int w = this.pos.w;
        int h = this.pos.h;
        if (w < 1) {
            w = 1;
        }
        if (h < 1) {
            h = 1;
        }
        if (this.useBS && (image == null || !clear)) {
            this.refreshing = true;
            if (image == null) {
                image = this.images[this.level] = this.panel.createImage(w, h);
            }
            if (image != null) {
                Graphics gbs = image.getGraphics();
                gbs.setClip(this.ix1, this.iy1, this.ix21, this.iy21);
                this.drawDataArea(gbs, drawmode, clear, 3);
            }
            this.refreshing = false;
        }
        if (this.useBS) {
            clear = false;
        }
        this.refreshMode = drawmode;
        if (this.useDB) {
            if (this.dbimage == null) {
                this.dbimage = this.panel.createImage(w, h);
            }
            if (this.dbimage != null) {
                grt = this.dbimage.getGraphics();
                grt.setClip(this.ix1, this.iy1, this.ix21, this.iy21);
                if (this.useBS && image != null) {
                    grt.drawImage(image, 0, 0, this.panel);
                }
                int flags = 1 | (this.useBS ? 4 : 0);
                this.drawDataArea(grt, drawmode, clear, flags);
                this.dbimageBackup = this.dbimage;
            }
        }
        if (!fresh && !this.useDB && Theme.getOption(8)) {
            grt = this.panel.getGraphics();
            if (grt == null) {
                return;
            }
            grt.setClip(this.ix1, this.iy1, this.ix21, this.iy21);
            if (this.panel.isVisible() && this.panel.getParent().isVisible()) {
                this.paint(grt);
            }
        } else if (!fresh && !this.useDB && this.panel instanceof JComponent) {
            if (EventQueue.isDispatchThread()) {
                ((JComponent)this.panel).paintImmediately(this.ix1, this.iy1, this.ix21, this.iy21);
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ((JComponent)MPlot.this.panel).paintImmediately(MPlot.this.ix1, MPlot.this.iy1, MPlot.this.ix21, MPlot.this.iy21);
                        }
                    });
                }
                catch (Exception e) {
                    Shell.printStackTrace("Error in MPlot.refresh(..)", e);
                }
            }
        } else if (fresh) {
            this.panel.repaint();
        } else {
            this.panel.repaint(this.ix1, this.iy1, this.ix21, this.iy21);
        }
    }

    private synchronized void drawDataArea(Graphics g, int drawmode, boolean clear, int flags) {
        this.gc = g;
        Color currentColor = g.getColor();
        if (clear) {
            this.gc.setColor((this.options & 8) != 0 ? Color.black : this.theme.cbg);
            this.gc.fillRect(this.ix1, this.iy1, this.ix21, this.iy21);
        }
        this.gc.setColor(this.lastColor);
        int l1 = this.layerGrid.ndata > 0 ? 0 : 1;
        this.layerGrid.clearNeedRefresh();
        if ((this.holdRefresh & 2) == 0) {
            for (int i = l1; i < this.layers.size(); ++i) {
                this.doDraw((Layer)this.layers.get(i), drawmode, flags);
            }
        }
        int tempNumVisibleFeatures = 0;
        for (int i = 0; i < this.features.size(); ++i) {
            Feature thisFeature = (Feature)this.features.get(i);
            this.doDraw(thisFeature, drawmode, flags);
            if (!thisFeature.isVisible()) continue;
            ++tempNumVisibleFeatures;
        }
        if (this.elasticFeatureSelected && this.elasticFeature != null) {
            if (this.elasticFeature.isVisible()) {
                ResizeBox.drawSelectedBox(this.elasticFeature);
                if (!this.baseLayer.realtime) {
                    this.needRefresh = true;
                }
            } else {
                this.elasticFeatureSelected = false;
                this.elasticHandle = ResizeBox.Handle.NONE;
            }
        }
        this.numVisibleFeatures = tempNumVisibleFeatures;
        this.gc = null;
        g.setColor(currentColor);
    }

    public synchronized void drawOverlay(int drawmode, Drawable dc) {
        dc.draw(drawmode);
    }

    private void drawAxisGrid(Graphics g) {
        int gridAxis = 3;
        this.drawAxis(g, gridAxis);
    }

    public void drawCrossHairs(int mode) {
        ArrayList<Component> gwidgets = new ArrayList<Component>();
        for (Component comp : this.panel.getParent().getComponents()) {
            if (!(comp instanceof MJPanel) || !(((MJPanel)comp).MW instanceof GWidget) || !comp.getBounds().intersects(this.panel.getBounds()) || !comp.isShowing()) continue;
            gwidgets.add(comp);
        }
        if (this.popupCount > 0) {
            for (Component comp : gwidgets) {
                try {
                    if (MouseInfo.getPointerInfo().getLocation().x < comp.getLocationOnScreen().x || MouseInfo.getPointerInfo().getLocation().x > comp.getLocationOnScreen().x + comp.getWidth() || MouseInfo.getPointerInfo().getLocation().y < comp.getLocationOnScreen().y || MouseInfo.getPointerInfo().getLocation().y > comp.getLocationOnScreen().y + comp.getHeight()) continue;
                    return;
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                }
            }
        }
        Graphics _g = this.panel.getGraphics();
        _g.setXORMode(this.crossHairsColor);
        if (this.drawnCH && mode <= 0 && this.crossX > this.ix1 && this.crossX < this.ix2 && this.crossY > this.iy1 && this.crossY < this.iy2) {
            _g.drawLine(this.ix1, this.crossY, this.ix2 - 1, this.crossY);
            _g.drawLine(this.crossX, this.iy1, this.crossX, this.iy2 - 1);
            this.drawnCH = false;
        }
        if (!this.drawnCH) {
            this.crossX = this.px;
            this.crossY = this.py;
        }
        if (!this.drawnCH && mode >= 0 && this.crossX > this.ix1 && this.crossX < this.ix2 && this.crossY > this.iy1 && this.crossY < this.iy2) {
            _g.drawLine(this.ix1, this.crossY, this.ix2 - 1, this.crossY);
            _g.drawLine(this.crossX, this.iy1, this.crossX, this.iy2 - 1);
            this.drawnCH = true;
            this.needsDrawCH = false;
        }
        _g.setPaintMode();
        _g.dispose();
        for (Component comp : gwidgets) {
            comp.repaint();
        }
    }

    public void setCrossHairsColor(String col) {
        this.setCrossHairsColor(MColor.getColor(col));
    }

    public void setCrossHairsColor(Color c) {
        this.crossHairsColor = c;
    }

    public boolean needCrossHairRefresh() {
        return this.needsDrawCH;
    }

    public void updateCursor() {
        if ((this.options & 0x10) != 0) {
            this.drawCrossHairs(0);
        }
    }

    @Override
    public void setCursor(String cursor) {
        this.setCursor(cursor, true);
    }

    public void setCursor(String cursor, boolean sticky) {
        if (sticky) {
            this.userCursor = cursor;
        }
        super.setCursor(cursor);
    }

    public String getUserCursor() {
        return this.userCursor;
    }

    public void setColor(Color color) {
        if (this.gc == null) {
            return;
        }
        this.gc.setColor(color);
        this.lastColor = color;
    }

    @Override
    public boolean isPanelVisible() {
        return super.isPanelVisible() && this.panel.getHeight() >= 1 && this.panel.getWidth() >= 1;
    }

    public boolean needRefresh() {
        return this.isPanelVisible() && (this.needRefresh || this.needLayerRefresh() || this.needFeatureRefresh());
    }

    public boolean needLayerRefresh() {
        if ((this.holdRefresh & 2) != 0) {
            return false;
        }
        return this.needRefresh(this.layers);
    }

    public boolean needFeatureRefresh() {
        if ((this.holdRefresh & 1) != 0) {
            return false;
        }
        return this.needRefresh(this.features);
    }

    private boolean needRefresh(KeyVector kv) {
        boolean nr = this.needRefresh;
        for (int i = 0; i < kv.size(); ++i) {
            Drawable d = (Drawable)kv.get(i);
            if (d == null || !d.getNeedRefresh()) continue;
            if ((d.getEnable() & 4) != 0) {
                this.reset(-1);
            }
            nr = true;
        }
        return nr;
    }

    public void addCanvas() {
        if (this.canvas == null) {
            this.canvas = new PlotCanvas(this);
        }
    }

    public void removeCanvas() {
        this.canvas = null;
    }

    public PlotCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    @Deprecated
    public void clear() {
        this.clear(this.g);
    }

    @Override
    public void clear(Graphics g) {
        if (g != null) {
            g.clearRect(0, 0, this.pos.w, this.pos.h);
        }
    }

    public void clearData() {
        for (int i = 0; i < this.layers.size(); ++i) {
            ((Layer)this.layers.get(i)).clear();
        }
        this.refresh(0);
    }

    public void setShowDeltas(boolean val) {
        this.showDeltas = val;
    }

    public boolean isShowDeltas() {
        return this.showDeltas;
    }

    public boolean getShowDeltas() {
        return this.isShowDeltas();
    }

    @ProvisionalUseOnly(value="minimally tested")
    public void setXOff(double xoff) {
        boolean redraw = xoff != this.xOff;
        this.xOff = xoff;
        if (redraw) {
            this.panel.repaint();
        }
    }

    @ProvisionalUseOnly(value="not tested")
    public void setYOff(double yoff) {
        this.yOff = yoff;
    }

    public String formatReadout(int mode) {
        boolean deltas;
        String xUnits = "";
        String yUnits = "";
        if ((this.readout & 0x1000000) != 0) {
            xUnits = this.getXUnitsString();
            yUnits = this.getYUnitsString();
        }
        String plotName = "Plot ";
        String layerInfo = "";
        String _plotInfo = "";
        Position mb = this.mt;
        if ((this.readout & 1) == 0 || mode == 0 && !this.pactive) {
            this.plotInfo = "";
            return "";
        }
        if (this.mh instanceof IDable) {
            plotName = plotName + ((IDable)((Object)this.mh)).getID() + " ";
        }
        boolean bl = deltas = mode != 0 && mode != 9;
        if (deltas) {
            this.getPosition(this.box.x, this.box.y, mb);
        } else if (this.mm != null) {
            mb = this.mm;
            deltas = true;
        }
        int dms = (this.readout & 0x800000) != 0 ? -1 : 0;
        int rng = 0;
        if (this.dRangeUnits == 3) {
            rng = -2;
        } else if (this.dRangeUnits == 2) {
            rng = -6;
        } else if (this.dRangeUnits == 1) {
            rng = -7;
        }
        int xfmt = this.useDateString(this.xUnitsID, this.mp.x + this.xOff) ? -3 : this.xUnitsID;
        int yfmt = this.useDateString(this.yUnitsID, this.mp.y + this.yOff) ? -3 : this.yUnitsID;
        int dfmt = 0;
        this.setShowDeltas((this.readout & 0x20000000) != 0);
        if (this.isMapView()) {
            double normalizedLon = this.mp.lon;
            if (this.view == 14 && this.hasExtendedRange() && this.mp.lon > (double)LONGITUDE_DEFAULT_MAX) {
                normalizedLon -= (double)LONGITUDE_RANGE;
            }
            if ((this.readout & 0x100) != 0) {
                _plotInfo = _plotInfo + " Lat=" + this.formNumber(this.mp.lat, 0, dms);
            }
            if ((this.readout & 0x10) != 0) {
                _plotInfo = _plotInfo + " Lon=" + this.formNumber(normalizedLon, 0, dms);
            }
            if ((this.readout & 0x10000) != 0) {
                _plotInfo = _plotInfo + " t=" + this.formTime(this.time);
            }
            if (deltas) {
                if ((this.readout & 0x200) != 0) {
                    _plotInfo = _plotInfo + " dLat=" + this.formNumber(this.mp.lat - mb.lat, 0, dms);
                }
                if ((this.readout & 0x20) != 0) {
                    _plotInfo = _plotInfo + " dLon=" + this.formNumber(this.mp.lon - mb.lon, 0, dms);
                }
                if ((this.readout & 0x100000) != 0) {
                    double r = Transform.greatArc(this.mp, mb);
                    int rexp = this.getTicExp(r, r);
                    _plotInfo = _plotInfo + " dRange=" + this.formNumber(r, rexp, rng);
                }
                if ((this.readout & 0x10000000) != 0) {
                    double azimuth = GeodeticUtil.computeCourse(mb, this.mp);
                    int azExp = this.getTicExp(azimuth, azimuth);
                    _plotInfo = _plotInfo + " Azi=" + this.formNumber(azimuth, azExp, -1);
                }
            }
        } else if ((this.readout & 0x400000) != 0) {
            if ((this.readout & 0x10) != 0) {
                _plotInfo = _plotInfo + " ix=" + this.getXIndex(this.mp.x);
            }
            if ((this.readout & 0x100) != 0) {
                _plotInfo = _plotInfo + " iy=" + this.getYIndex(this.mp.y);
            }
            if (deltas) {
                if ((this.readout & 0x20) != 0) {
                    _plotInfo = _plotInfo + " idx=" + (this.getXIndex(this.mp.x) - this.getXIndex(mb.x));
                }
                if ((this.readout & 0x200) != 0) {
                    _plotInfo = _plotInfo + " idy=" + (this.getYIndex(this.mp.y) - this.getYIndex(mb.y));
                }
            }
        } else if (this.view != 15) {
            Double rf;
            TuneAdjust tuneAdjustments;
            int xexp = this.getTicExp(this.rx1 + this.xOff, this.rx2 + this.xOff);
            int yexp = this.getTicExp(this.ry1 + this.yOff, this.ry2 + this.yOff);
            String xName = "x";
            if (this.baseLayer instanceof Layer2D && (tuneAdjustments = ((Layer2D)this.baseLayer).getTuneAdjustments()) != null && (rf = tuneAdjustments.getRF(this.mp.y, this.mp.x)) != null) {
                _plotInfo = _plotInfo + " rf=" + this.formNumber(rf, xexp, xfmt, this.xMult) + " " + xUnits;
                xName = "if";
            }
            if ((this.readout & 0x10) != 0) {
                _plotInfo = _plotInfo + " " + xName + "=" + this.formNumber(this.mp.x + this.xOff, xexp, xfmt, this.xMult) + " " + xUnits;
            }
            if ((this.readout & 0x100) != 0) {
                _plotInfo = _plotInfo + " y=" + this.formNumber(this.mp.y + this.yOff, yexp, yfmt, this.yMult) + " " + yUnits;
            }
            if ((this.readout & 0x10000) != 0) {
                _plotInfo = _plotInfo + " t=" + this.formTime(this.mp.t);
            }
            if ((this.readout & 0x80) != 0) {
                _plotInfo = _plotInfo + " ix=" + this.getXIndex(this.mp.x);
            }
            if ((this.readout & 0x800) != 0) {
                _plotInfo = _plotInfo + " iy=" + this.getYIndex(this.mp.y);
            }
            if (this.mode == 6 && (this.readout & 0x100000) != 0) {
                double rp = Math.sqrt(this.mp.x * this.mp.x + this.mp.y * this.mp.y);
                double rb = Math.sqrt(mb.x * mb.x + mb.y * mb.y);
                _plotInfo = _plotInfo + " r=" + this.formNumber(rp, xexp, xfmt, this.xMult) + " " + xUnits;
                if (deltas) {
                    _plotInfo = _plotInfo + " dr=" + this.formNumber(rp - rb, xexp, xfmt, this.xMult) + " " + xUnits;
                }
            }
            if (deltas) {
                xexp = this.getTicExp(this.mp.x - mb.x, mb.x - this.mp.x);
                yexp = this.getTicExp(this.mp.y - mb.y, mb.y - this.mp.y);
                if ((this.readout & 0x20) != 0) {
                    _plotInfo = _plotInfo + " dx=" + this.formNumber(this.mp.x - mb.x, xexp, xfmt, this.xMult) + " " + xUnits;
                }
                if ((this.readout & 0x200) != 0) {
                    _plotInfo = _plotInfo + " dy=" + this.formNumber(this.mp.y - mb.y, yexp, yfmt, this.yMult) + " " + yUnits;
                }
                if ((this.readout & 0x400) != 0) {
                    _plotInfo = _plotInfo + " dy/dx=" + this.formNumber((this.mp.y - mb.y) / (this.mp.x - mb.x), yexp, dfmt, this.yMult) + " " + yUnits;
                }
                if ((this.readout & 0x20000) != 0) {
                    _plotInfo = _plotInfo + " dt=" + this.formTime(this.mp.t - mb.t);
                }
                if ((this.readout & 0x2000) != 0) {
                    _plotInfo = _plotInfo + " dz=" + this.formNumber(this.mp.z - mb.z, 0, dfmt);
                }
            }
        }
        if ((this.readout & 0x2000000) != 0 && !deltas) {
            _plotInfo = _plotInfo + " View=" + this.getView();
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            String tmpx = ((Layer)this.layers.get(i)).getReadOut(this.mp);
            if (tmpx == null) continue;
            layerInfo = layerInfo + " / " + tmpx;
        }
        if (_plotInfo.length() > 0) {
            _plotInfo = _plotInfo.substring(1);
            _plotInfo = "(" + _plotInfo + ")" + layerInfo;
        } else {
            _plotInfo = layerInfo;
        }
        String readoutString = plotName + _plotInfo;
        if (mode == -9) {
            _plotInfo = null;
            readoutString = null;
        }
        if ((this.readout & 8) != 0) {
            this.setAltTitle(readoutString + "   " + this.formRightAxisInfo());
        }
        if ((this.readout & 2) != 0) {
            this.setStatusBar(readoutString + "   " + this.formRightAxisInfo());
        }
        if ((this.readout & 4) != 0) {
            this.refresh(this.oarbox);
        }
        this.plotInfo = _plotInfo;
        return readoutString;
    }

    public void updateReadoutExtIfStale() {
        if (this.onAxisExtendedReadout() && Time.current() - this.readoutExtTime > 0.1) {
            this.refresh(this.oarbox);
        }
    }

    private String formTime(double t) {
        if (t == 0.0) {
            return "0";
        }
        return this.formTime(t, 1, this.precision);
    }

    private long getXIndex(double x) {
        Layer lay = this.getBaseLayer();
        if (lay == null) {
            return 0L;
        }
        if (lay.isPaged) {
            double delta = lay.pf.getXDelta();
            if (delta == 0.0) {
                delta = 1.0;
            }
            return (long)((x - lay.pf.getXStart()) / delta + 0.5);
        }
        double delta = lay.xdelta;
        if (delta == 0.0) {
            delta = 1.0;
        }
        return (long)((x - lay.xstart) / delta + 0.5);
    }

    private long getYIndex(double y) {
        Layer lay = this.getBaseLayer();
        if (lay == null) {
            return 0L;
        }
        double delta = lay.ydelta;
        if (delta == 0.0) {
            delta = 1.0;
        }
        return (long)((y - lay.ystart) / delta + 0.5);
    }

    public String formNumber(double t, int texp, int units) {
        return this.formNumber(t, texp, units, 0);
    }

    public String formNumber(double t, int texp, int units, int mult) {
        String tmp;
        if (units == -1) {
            return Convert.deg2dms(t, "00.00");
        }
        if (units == -3) {
            if (Math.abs(t) > 100.0) {
                return this.formTime(t, 1, this.precision);
            }
            units = 1;
        }
        if (units == -4) {
            if (Math.abs(t) > 100.0) {
                return this.formTime(t, 8, -1);
            }
            units = 1;
        }
        if (units == -5) {
            if (Math.abs(t) > 100.0) {
                return this.formTime(t, 9, -1);
            }
            units = 1;
        }
        if (units == -2) {
            t *= 5.399568034557236E-4;
            texp = 0;
        }
        if (units == -6) {
            t /= 1000.0;
            texp = 0;
        }
        if ((this.readout & 0x8000000) == 0x8000000) {
            double tmul = Math.pow(10.0, -texp);
            tmp = this.nf.format(t * tmul);
            if (texp - mult != 0) {
                tmp = tmp + "E" + (texp - mult);
            }
        } else {
            double tmul = Math.pow(10.0, -mult);
            tmp = this.nf.format(t * tmul);
        }
        if (units != 0) {
            if (units == -6) {
                tmp = tmp + "km";
            } else if (units == -7) {
                tmp = tmp + "m";
            } else if (units == -2) {
                tmp = tmp + "nmi";
            }
        }
        return tmp;
    }

    private String formTime(double t, int defaultFormat, int dp) {
        int ip;
        String tmpstr;
        boolean neg;
        MFormat mformat = this.getDateFormat(true, defaultFormat, dp);
        boolean bl = neg = t < 0.0;
        if (neg) {
            t = -t;
        }
        try {
            Time timeObj = new Time(t);
            StringBuffer sb = mformat.format(timeObj, new StringBuffer(), null);
            tmpstr = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            Shell.warning("MPlot.formTime: error formtting time.  Using default." + e.getMessage());
            tmpstr = Time.format(t, defaultFormat, dp);
        }
        if (tmpstr.startsWith("00:00:00::")) {
            tmpstr = tmpstr.substring(10);
        }
        if ((ip = tmpstr.indexOf(".000")) > 0) {
            tmpstr = tmpstr.substring(0, ip);
        }
        if (neg) {
            tmpstr = "-" + tmpstr;
        }
        return tmpstr;
    }

    private void setAxisReadout(Graphics g, String plotInfo) {
        g.setColor(this.theme.cbg);
        g.fillRect(this.oarbox.x, this.oarbox.y, this.oarbox.w, this.oarbox.h);
        g.setColor(this.theme.cfg);
        if (plotInfo == null) {
            return;
        }
        g.drawString(plotInfo, this.tw, this.oarbox.y + this.oarbox.h - this.ta / 3);
    }

    private void setAxisRightReadout(Graphics g, String rightAxisInfo) {
        g.setColor(this.theme.cbg);
        g.setColor(this.theme.cfg);
        int plotInfoLen = this.plotInfo == null ? 0 : this.plotInfo.length();
        int readoutEnd = this.oarbox.x + plotInfoLen * this.tw;
        int xLoc = this.oarbox.w - this.tw * rightAxisInfo.length();
        if (xLoc < readoutEnd) {
            xLoc = readoutEnd + this.tw;
        }
        g.drawString(rightAxisInfo, xLoc, this.oarbox.y + this.oarbox.h - this.ta / 3);
    }

    @Deprecated
    public void drawAxis() {
        this.drawAxis(this.g, this.axis);
    }

    public void drawAxis(Graphics g) {
        this.drawAxis(g, this.axis);
    }

    /*
     * Unable to fully structure code
     */
    private int drawAxis(Graphics g, int axis) {
        if (g == null) {
            return 0;
        }
        if ((axis & 1) == 0) {
            return 0;
        }
        ticSize = 3;
        lblMarg = 5;
        ixl = this.ix1 - 4;
        ixr = this.ix2 + 2;
        iyt = this.iy1 - 4;
        iyb = this.iy2 + 2;
        v0 = rvi = this.mode == 6;
        v1 = rvi != false ? this.getYUnits() : (hUnits = this.xvy != false ? this.getYUnits() : this.getXUnits());
        vUnits = rvi != false ? this.getYUnits() : (this.xvy != false ? this.getXUnits() : this.getYUnits());
        hDateTxt = "";
        vDateTxt = "";
        _g = g;
        gridc = new Color(0x505050);
        _g.setColor(this.theme.cfg);
        if ((axis & 16) != 0) {
            _g.drawLine(ixl, iyt, ixl, iyb);
        }
        if ((axis & 256) != 0) {
            _g.drawLine(ixr, iyt, ixr, iyb);
        }
        if ((axis & 4096) != 0) {
            _g.drawLine(ixl, iyt, ixr, iyt);
        }
        if ((axis & 65536) != 0) {
            _g.drawLine(ixl, iyb, ixr, iyb);
        }
        if (this.view == 0) {
            return 0;
        }
        if ((axis & 417794) != 0) {
            if (this.xvy) {
                dtic = this.getTicDelta(this.ry1, this.ry2, this.ndy);
                tic1 = this.getTicStart(this.ry1, this.ry2, dtic);
                texp = this.getTicExp(this.ry1, this.ry2);
                tic2 = this.ry2;
                rtol_btot_l = this.myy < 0.0;
            } else {
                dtic = this.getTicDelta(this.rx1, this.rx2, this.ndx);
                tic1 = this.getTicStart(this.rx1 + this.xOff, this.rx2 + this.xOff, dtic) - this.xOff;
                texp = this.getTicExp(this.rx1 + this.xOff, this.rx2 + this.xOff);
                tic2 = this.rx2;
                rtol_btot_l = this.mxx < 0.0;
            }
            hDateStr = this.useDateString(hUnits, tic1);
            lastLeft = ixl;
            lastRight = ixr;
            if ((this.readout & 0x8000000) == 0x8000000) {
                myexp = texp - this.xMult;
                tmul = Math.pow(10.0, -texp);
            } else {
                myexp = 0;
                tmul = Math.pow(10.0, -this.xMult);
            }
            tmpstr = dtmp < 1.0 || Math.abs(dtmp - 2.5) < 0.1 ? "#0." : "#0";
            for (dtmp = tmul * dtic; dtmp < 1.0 || Math.abs(dtmp - 2.5) < 0.1; dtmp *= 10.0) {
                tmpstr = tmpstr + "#";
            }
            hticnf = new DecimalFormat(tmpstr);
            if (dtic != 0.0 && tic1 + dtic != tic1) {
                isLatLonContinuousView = this.view == 14;
                for (tic = tic1; tic <= tic2; tic += dtic) {
                    v2 = x = this.xvy != false ? this.getiy(tic) : this.getix(tic);
                    if ((axis & 8192) != 0) {
                        _g.drawLine(x, iyt, x, iyt - 3);
                    }
                    if ((axis & 131072) != 0) {
                        _g.drawLine(x, iyb, x, iyb + 3);
                    }
                    if ((axis & 2) != 0) {
                        _g.setColor(gridc);
                        _g.drawLine(x, this.iy1, x, this.iy2);
                        _g.setColor(this.theme.cfg);
                    }
                    if ((axis & 278528) == 0) continue;
                    if (hDateStr) {
                        tmpstr = this.formNumber(tic + this.xOff, 0, -4);
                    } else if (isLatLonContinuousView) {
                        displayTic = tic * tmul;
                        tmpstr = hticnf.format(displayTic);
                        if (this.orx2 > (double)MPlot.LONGITUDE_DEFAULT_MAX && displayTic > (double)MPlot.LONGITUDE_DEFAULT_MAX) {
                            tmpstr = hticnf.format(displayTic -= (double)MPlot.LONGITUDE_RANGE) + "(" + tmpstr + ")";
                        }
                    } else {
                        tmpstr = hticnf.format((tic + this.xOff) * tmul);
                    }
                    tsl = this.tw * tmpstr.length();
                    x1 = x - tsl / 2;
                    if (x1 < lastLeft) {
                        v3 = !rtol_btot_l ? tic <= tic1 : (isLeftmostLabel = tic + dtic > tic2);
                        if (!isLeftmostLabel) continue;
                        x1 = lastLeft;
                    }
                    if (x1 + tsl > lastRight) {
                        v4 = !rtol_btot_l ? tic + dtic > tic2 : (isRightmostLabel = tic <= tic1);
                        if (!isRightmostLabel) continue;
                        if (isLatLonContinuousView && (startExtendedPortion = tmpstr.indexOf(40)) >= 0) {
                            tmpstr = tmpstr.substring(0, startExtendedPortion);
                            tsl = this.tw * tmpstr.length();
                        }
                        x1 = lastRight - tsl;
                        if (rtol_btot_l && myexp != 0) {
                            x1 -= 4 * this.tw;
                        }
                    }
                    if (rtol_btot_l) {
                        lastRight = x1 - this.tw / 2;
                    } else {
                        lastLeft = x1 + this.tw / 2 + tsl;
                    }
                    if ((axis & 16384) != 0) {
                        _g.drawString(tmpstr, x1, iyt - 5);
                    }
                    if ((axis & 262144) != 0) {
                        _g.drawString(tmpstr, x1, iyb + this.ta + 5);
                    }
                    if (tic != tic1) continue;
                    x2 = x1 + tsl + this.tw;
                    prefix = "";
                    if (hDateStr) {
                        hDateTxt = tic > 86400.0 ? " [" + this.formNumber(tic, 0, -5) + "]" : "";
                    } else if (myexp != 0) {
                        prefix = "E" + myexp;
                        if (!rtol_btot_l) {
                            lastLeft += this.tw * 3;
                        }
                    }
                    if ((axis & 16384) != 0) {
                        _g.drawString(prefix, x2, iyt - 5);
                    }
                    if ((axis & 262144) == 0) continue;
                    _g.drawString(prefix, x2, iyb + this.ta + 5);
                }
            }
        }
        if ((axis & 1634) != 0) {
            if (this.xvy) {
                dtic = this.getTicDelta(this.rx1, this.rx2, this.ndx);
                tic1 = this.getTicStart(this.rx1, this.rx2, dtic);
                texp = this.getTicExp(this.rx1, this.rx2);
                tic2 = this.rx2;
                rtol_btot_l = this.mxx < 0.0;
                ticDeltaY = Math.abs(this.getix(tic1) - this.getix(tic1 + dtic));
            } else {
                dtic = this.getTicDelta(this.ry1, this.ry2, this.ndy);
                tic1 = this.getTicStart(this.ry1, this.ry2, dtic);
                texp = this.getTicExp(this.ry1, this.ry2);
                tic2 = this.ry2;
                rtol_btot_l = this.myy < 0.0;
                ticDeltaY = Math.abs(this.getiy(tic1) - this.getiy(tic1 + dtic));
            }
            vDateStr = this.useDateString(vUnits, tic1);
            lastTop = iyt;
            lastBtm = iyb;
            tlast = 10000;
            if ((this.readout & 0x8000000) == 0x8000000) {
                myexp = texp - this.yMult;
                tmul = Math.pow(10.0, -texp);
            } else {
                myexp = 0;
                tmul = Math.pow(10.0, -this.yMult);
            }
            tmpstr = dtmp < 1.0 || Math.abs(dtmp - 2.5) < 0.1 ? "#0." : "#0";
            for (dtmp = tmul * dtic; dtmp < 1.0 || Math.abs(dtmp - 2.5) < 0.1; dtmp *= 10.0) {
                tmpstr = tmpstr + "#";
            }
            vticnf = new DecimalFormat(tmpstr);
            ** if (dtic == 0.0 || tic1 + dtic == tic1) goto lbl264
            for (tic = tic1; tic <= tic2; tic += dtic) {
                v5 = y = this.xvy != false ? this.getix(tic) : this.getiy(tic);
                if ((axis & 32) != 0) {
                    _g.drawLine(ixl, y, ixl - 3, y);
                }
                if ((axis & 512) != 0) {
                    _g.drawLine(ixr, y, ixr + 3, y);
                }
                if ((axis & 2) != 0) {
                    _g.setColor(gridc);
                    _g.drawLine(this.ix1, y, this.ix2, y);
                    _g.setColor(this.theme.cfg);
                }
                if ((axis & 1088) == 0) continue;
                v6 = rtol_btot_l ? tic + dtic >= tic2 : (isTopmostLabel = tic <= tic1);
                v7 = rtol_btot_l ? tic <= tic1 : (isBtmmostLabel = tic + dtic >= tic2);
                if (vDateStr) {
                    tmpstr = this.formNumber(tic, 0, -4);
                    tsl = this.tw * tmpstr.length();
                    y1 = y - tsl / 2;
                    v8 = vDateTxt = tic > 86400.0 ? " [" + this.formNumber(tic, 0, -5) + "]" : "";
                    if (y1 < lastTop || y1 + tsl > lastBtm) continue;
                    if (rtol_btot_l) {
                        lastBtm = y1 - this.tw / 2;
                    } else {
                        lastTop = y1 + this.tw / 2 + tsl;
                    }
                    if ((axis & 64) != 0) {
                        MPlot.drawVerticalText(_g, tmpstr, ixl - 4 * this.tw, y1);
                    }
                    if ((axis & 1024) == 0) continue;
                    MPlot.drawVerticalText(_g, tmpstr, ixr + 3 + this.tw, y1);
                    continue;
                }
                threeCharFromLastLabel = Math.abs(y - tlast) < this.ta * 3;
                y1 = y2 = y - 2;
                tmpstr = vticnf.format(tic * tmul);
                ip = tmpstr.indexOf(".000000");
                if (ip > 0) {
                    tmpstr = tmpstr.substring(0, ip);
                }
                if ((axis & 0x2000000) != 0) {
                    if (myexp != 0 && Double.parseDouble(tmpstr) != 0.0) {
                        tmpstr = tmpstr + "E" + myexp;
                    }
                    if ((y1 = y - (tsl = this.tw * tmpstr.length()) / 2) < lastTop) {
                        if (!isTopmostLabel || lastTop + tsl >= lastBtm) continue;
                        y1 = lastTop;
                    }
                    if (y1 + tsl > lastBtm) {
                        if (!isBtmmostLabel || lastBtm - tsl <= lastTop) continue;
                        y1 = lastBtm - tsl;
                    }
                    if (rtol_btot_l) {
                        lastBtm = y1 - this.tw / 2;
                    } else {
                        lastTop = y1 + this.tw / 2 + tsl;
                    }
                    if ((axis & 64) != 0) {
                        MPlot.drawVerticalText(_g, tmpstr, ixl - 3 * this.tw, y1);
                    }
                    if ((axis & 1024) == 0) continue;
                    MPlot.drawVerticalText(_g, tmpstr, ixr + 3 + this.tw, y1);
                    continue;
                }
                if (threeCharFromLastLabel && !isTopmostLabel && !isBtmmostLabel) continue;
                v9 = rtol_btot_l ? tic + 2.0 * dtic >= tic2 && !isTopmostLabel : (isNextToTopLabel = tic - dtic <= tic1 && isTopmostLabel == false);
                v10 = rtol_btot_l ? tic - dtic <= tic1 && !isBtmmostLabel : (isNextToBtmLabel = tic + 2.0 * dtic >= tic2 && isBtmmostLabel == false);
                if (ticDeltaY < (double)(this.ta * 3) && (isNextToTopLabel || isNextToBtmLabel)) continue;
                tl = tmpstr.length();
                if (tic == tic1 && tl > 4 && (axis & 0x4000000) != 0) {
                    return this.drawAxis(g, axis | 0x2000000);
                }
                v11 = spaceForTopTick = (axis & 417794) == 0 ? 0 : 3;
                if ((axis & 16384) == 0 && y1 - this.ta < lastTop + 3) {
                    y1 = y2 = lastTop - spaceForTopTick + this.ta;
                }
                if (tl > 4 && (ip = tmpstr.indexOf(46)) > 0) {
                    y2 = y + this.ta;
                    tmpstrp = tmpstr.substring(ip, Math.min(ip + 4, tl));
                    while (tmpstrp.length() < 4) {
                        tmpstrp = tmpstrp + '0';
                    }
                    if ((axis & 64) != 0) {
                        _g.drawString(tmpstrp, ixl - 4 * this.tw - 2, y2);
                    }
                    if ((axis & 1024) != 0) {
                        _g.drawString(tmpstrp, ixr + 3, y2);
                    }
                    if (tl > ip + 4) {
                        y2 = y + this.ta + this.ta;
                        tmpstrp = tmpstr.substring(ip + 4, Math.min(ip + 7, tl));
                        while (tmpstrp.length() < 3) {
                            tmpstrp = tmpstrp + '0';
                        }
                        if ((axis & 64) != 0) {
                            _g.drawString(tmpstrp, ixl - 3 * this.tw - 2, y2);
                        }
                        if ((axis & 1024) != 0) {
                            _g.drawString(tmpstrp, ixr + this.tw + 3, y2);
                        }
                        tmpstr = tmpstr.substring(0, ip + 4);
                    }
                    tmpstr = tmpstr.substring(0, ip);
                    tl = tmpstr.length();
                }
                if (tl > 4) {
                    curFont = _g.getFont();
                    newSize = (float)curFont.getSize() - 2.0f;
                    f = curFont.deriveFont(newSize);
                    _g.setFont(f);
                    if ((axis & 64) != 0) {
                        _g.drawString(tmpstr, ixl - 4 * this.tw - 2, y1);
                    }
                    if ((axis & 1024) != 0) {
                        _g.drawString(tmpstr, ixr + 2, y1);
                    }
                    _g.setFont(curFont);
                } else if (tl < 4) {
                    if ((axis & 64) != 0) {
                        _g.drawString(tmpstr, ixl - 3 * this.tw - 2, y1);
                    }
                    if ((axis & 1024) != 0) {
                        _g.drawString(tmpstr, ixr + this.tw + 3, y1);
                    }
                } else {
                    if ((axis & 64) != 0) {
                        _g.drawString(tmpstr, ixl - 4 * this.tw - 2, y1);
                    }
                    if ((axis & 1024) != 0) {
                        _g.drawString(tmpstr, ixr + 3, y1);
                    }
                }
                if (tic + dtic > tic2) {
                    prefix = "";
                    if (myexp != 0) {
                        prefix = "E" + myexp;
                    }
                    if ((axis & 64) != 0) {
                        _g.drawString(prefix, ixl - 4 * this.tw, y2 + this.th);
                    }
                    if ((axis & 1024) != 0) {
                        _g.drawString(prefix, ixr + 3 + this.tw, y2 + this.th);
                    }
                }
                tlast = y;
lbl-1000:
                // 2 sources

                {
                    continue;
                }
            }
        }
lbl264:
        // 4 sources

        this.isyx = -100;
        this.isxy = -100;
        if ((this.scroll & 1) > 0 && (axis & 4) != 0) {
            if ((axis & 262144) != 0) {
                this.isxy = iyb;
            } else if ((axis & 16384) != 0) {
                this.isxy = iyt;
            } else if ((axis & 65536) != 0) {
                this.isxy = iyb;
            } else if ((axis & 4096) != 0) {
                this.isxy = iyt;
            }
            x1 = Math.max(this.ix1, this.isx - this.isxd);
            x2 = Math.min(this.ix2, this.isx + this.isxd);
            if (this.isxy > 0) {
                this.isLowHScroll = x2 <= this.ix1;
                this.isHighHScroll = x1 >= this.ix2;
                rectX = this.isHighHScroll != false ? x2 - 7 : x1 - 1;
                rectWidth = Math.max(x2 - x1, 8);
                lineX1 = Math.min(x1, x2 - 2);
                lineX2 = Math.min(x2 - 2, x1 + 2);
                _g.drawRect(rectX, this.isxy - 2, rectWidth, 4);
                _g.setColor(this.theme.cwfh);
                _g.drawLine(lineX1, this.isxy, lineX2, this.isxy);
                _g.setColor(this.theme.cfg);
            }
        }
        if ((this.scroll & 2) > 0 && (axis & 8) != 0) {
            if ((axis & 1024) != 0) {
                this.isyx = ixr;
            } else if ((axis & 64) != 0) {
                this.isyx = ixl;
            } else if ((axis & 256) != 0) {
                this.isyx = ixr;
            } else if ((axis & 16) != 0) {
                this.isyx = ixl;
            }
            y1 = Math.max(this.iy1, this.isy - this.isyd);
            y2 = Math.min(this.iy2, this.isy + this.isyd);
            if (this.isyx > 0) {
                this.isLowVScroll = y2 <= this.iy1;
                this.isHighVScroll = y1 >= this.iy2;
                rectY = this.isHighVScroll != false ? y2 - 7 : y1 - 1;
                rectWidth = Math.max(y2 - y1, 8);
                lineY1 = Math.min(y1, y2 - 2);
                lineY2 = Math.min(y2 - 2, y1 + 2);
                _g.drawRect(this.isyx - 2, rectY, 4, rectWidth);
                _g.setColor(this.theme.cwfh);
                _g.drawLine(this.isyx, lineY1, this.isyx, lineY2);
                _g.setColor(this.theme.cfg);
            }
        }
        if ((axis & 559232) != 0 && this.is2D) {
            if (this.xvy) {
                vUnitsStr = this.customXAxisLabel != null ? this.customXAxisLabel : DataFile.getUnitsName(this.getXUnits(), this.xnf.getCmult());
                hUnitsStr = this.customYAxisLabel != null ? this.customYAxisLabel : DataFile.getUnitsName(this.getYUnits(), this.ynf.getCmult());
            } else {
                hUnitsStr = this.customXAxisLabel != null ? this.customXAxisLabel : DataFile.getUnitsName(this.getXUnits(), this.xnf.getCmult());
                vUnitsStr = this.customYAxisLabel != null ? this.customYAxisLabel : DataFile.getUnitsName(this.getYUnits(), this.ynf.getCmult());
            }
            top = iyt - 4;
            bottom = iyb + 4 + 10;
            left = ixl - 6 - 10;
            right = ixr + 4;
            if ((axis & 16384) != 0) {
                top -= 12;
            }
            if ((axis & 262144) != 0) {
                bottom += 12;
            }
            if ((axis & 64) != 0) {
                left -= 4 * this.tw;
            }
            if ((axis & 1024) != 0) {
                right += 4 * this.tw;
            }
            drawH = hUnits != 0 && hUnits != 30 || this.xvy == false && this.customXAxisLabel != null || this.xvy != false && this.customYAxisLabel != null;
            v12 = drawV = vUnits != 0 && vUnits != 30 || this.xvy != false && this.customXAxisLabel != null || this.xvy == false && this.customYAxisLabel != null;
            if (drawH) {
                hUnitsStr = hUnitsStr + hDateTxt;
                offset = (ixr - ixl - hUnitsStr.length() * 6) / 2;
                if ((axis & 32768) != 0) {
                    _g.drawString(hUnitsStr, this.ix1 + offset, top);
                }
                if ((axis & 524288) != 0) {
                    _g.drawString(hUnitsStr, ixl + offset, bottom);
                }
            }
            if (drawV) {
                vUnitsStr = vUnitsStr + vDateTxt;
                offset = (iyt - iyb + vUnitsStr.length() * 6) / 2;
                if ((axis & 128) != 0) {
                    MPlot.drawVerticalText(_g, vUnitsStr, left, iyt - offset);
                }
                if ((axis & 2048) != 0) {
                    MPlot.drawVerticalText(_g, vUnitsStr, right, iyt - offset);
                }
            }
        }
        return 0;
    }

    private static void drawVerticalText(Graphics g, String str, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform transform = AffineTransform.getRotateInstance(-1.5707963267948966);
        Font oldFont = g2d.getFont();
        Font newFont = oldFont.deriveFont(transform);
        g2d.setFont(newFont);
        int offset = y + str.length() * 6;
        int i = 0;
        while (i < str.length()) {
            g2d.drawChars(str.toCharArray(), i, 1, x + 10, offset);
            ++i;
            offset -= 6;
        }
        g2d.setFont(oldFont);
    }

    public int getTicExp(double dmin, double dmax) {
        double absmax = Math.max(Math.abs(dmin), Math.abs(dmax));
        if (absmax == 0.0) {
            return 0;
        }
        int kengr = (int)(0.1447648 * Math.log(absmax / 2.0));
        if (absmax < 1.0) {
            --kengr;
        }
        return kengr * 3;
    }

    public double getTicDelta(double dmin, double dmax, int ndiv) {
        double LN2LOG10 = 0.43429448190325;
        if (dmax == dmin) {
            return 1.0;
        }
        double dran = Math.abs(dmax - dmin);
        double df = dran / (double)ndiv;
        double sig = df < 1.0E-36 ? -36.0 : LN2LOG10 * Math.log(df);
        double nsig = Math.floor(sig);
        sig = Math.pow(10.0, nsig);
        double ddf = df / sig;
        double dtic = sig == 0.0 ? 1.0 : (ddf < 1.75 ? sig : (ddf < 2.25 ? 2.0 * sig : (ddf < 3.5 ? 2.5 * sig : (ddf < 7.0 ? 5.0 * sig : 10.0 * sig))));
        return dtic;
    }

    public double getTicStart(double dmin, double dmax, double dtic) {
        double dpad = dmax > dmin ? (dmin >= 0.0 ? 0.995 : -0.005) : (dmin >= 0.0 ? 0.005 : -0.995);
        dtic = Math.abs(dtic);
        double dtic1 = dtic * Math.floor(dmin / dtic + dpad);
        if (dmin < 0.0) {
            dtic1 += dtic;
        }
        return dtic1;
    }

    public void setContrast(int mode) {
        int oldoptions = this.options;
        if (mode == 0) {
            this.options &= 0xFFFFFFF7;
        }
        if (mode == 1) {
            this.options |= 8;
        }
        if (mode == -1) {
            this.options ^= 8;
        }
        if (this.options != oldoptions) {
            this.refresh();
        }
    }

    public int getix(double x) {
        return (int)(x * this.mxx + this.mxb);
    }

    public int getiy(double y) {
        if (this.view == 12) {
            return this.viewMerc.ry2iy(y);
        }
        return (int)(y * this.myy + this.myb);
    }

    public void drawCircleLonLat(double lon, double lat, double radius, int div, Line line) {
        this.drawCircleLonLat(lon, lat, radius, div, line, this.gc);
    }

    public void drawCircleLonLat(double lon, double lat, double radius, int div, Line line, Graphics gc) {
        if (div == -1) {
            div = 90;
        }
        int len = (div + 1) * 2;
        double[] buf = new double[len];
        double ang = 0.0;
        if (lat >= 90.0 || lat <= -90.0) {
            double deg = 360 / div;
            int i = 0;
            while (i < buf.length && !this.cancel) {
                buf[i + 0] = ang;
                buf[i + 1] = lat == 90.0 ? 90.0 - radius : -90.0 + radius;
                i += 2;
                ang += deg;
            }
        } else {
            double w = Math.PI * 2 / (double)div;
            double latRad = Math.toRadians(lat);
            double sinLat = Math.sin(latRad);
            double cosLat = Math.cos(latRad);
            double d = Math.toRadians(radius);
            double cosD = Math.cos(d);
            double sinD = Math.sin(d);
            int i = 0;
            while (i < len && !this.cancel) {
                double yRad = Math.asin(sinLat * cosD + cosLat * sinD * Math.cos(ang));
                double xRad = Math.atan2(Math.sin(ang) * sinD * cosLat, cosD - sinLat * Math.sin(yRad));
                buf[i + 0] = Math.toDegrees(xRad) + lon;
                buf[i + 1] = Math.toDegrees(yRad);
                i += 2;
                ang += w;
            }
        }
        buf[len - 2] = buf[0];
        buf[len - 1] = buf[1];
        this.drawLine(buf, 0, 2, buf.length / 2, line, 18, gc, true);
    }

    public void drawLineLonLat(double[] buf, int off, int dim, int npts, Line line) {
        this.drawLine(buf, off, dim, npts, line, 18);
    }

    public int drawLine(float[] buf, int off, int dim, int npts, Line line, double xstart, double xdelta) {
        while (npts > 0 && buf != null) {
            int n = this.viewer.rwc2pix(buf, off, dim, npts, this.pix, xstart, xdelta);
            int pt1 = this.xvy ? this.pix.x[Math.max(0, n - 1)] : this.pix.x[0];
            int pt2 = this.xvy ? this.pix.x[0] : this.pix.x[Math.max(0, n - 1)];
            int d = Math.max(1, Math.abs(pt2 - pt1));
            if (n > 256 && n / d > this.maxcmp) {
                n = -n;
            }
            if (this.xvy) {
                this.drawPixels(this.pix.y, this.pix.x, n, line);
            } else {
                this.drawPixels(this.pix.x, this.pix.y, n, line);
            }
            npts -= this.pix.off;
            off += dim * this.pix.off;
        }
        return off;
    }

    public int drawLine(double[] buf, int off, int dim, int npts, Line line, double xstart, double xdelta) {
        while (npts > 0 && buf != null) {
            int n = this.viewer.rwc2pix(buf, off, dim, npts, this.pix, xstart, xdelta);
            int pt1 = this.xvy ? this.pix.x[Math.max(0, n - 1)] : this.pix.x[0];
            int pt2 = this.xvy ? this.pix.x[0] : this.pix.x[Math.max(0, n - 1)];
            int d = Math.max(1, Math.abs(pt2 - pt1));
            if (n > 256 && n / d > this.maxcmp) {
                n = -n;
            }
            if (this.xvy) {
                this.drawPixels(this.pix.y, this.pix.x, n, line);
            } else {
                this.drawPixels(this.pix.x, this.pix.y, n, line);
            }
            npts -= this.pix.off;
            off += dim * this.pix.off;
        }
        return off;
    }

    public void setMaxCompression(int value) {
        this.maxcmp = value;
    }

    public int drawLine(float[] buf, int off, int dim, int npts, Line line) {
        return this.drawLine(buf, off, dim, npts, line, 0);
    }

    public int drawLine(double[] buf, int off, int dim, int npts, Line line) {
        return this.drawLine(buf, off, dim, npts, line, 16);
    }

    int drawLine(double[] buf, int off, int dim, int npts, Line line, boolean highZoomFix) {
        return this.drawLine(buf, off, dim, npts, line, 16, highZoomFix);
    }

    private int drawLine(float[] buf, int off, int dim, int npts, Line line, int pixFlags) {
        this.pix.flags = pixFlags;
        while (npts > 0 && buf != null) {
            int n = this.viewer.rwc2pix(buf, off, dim, npts, this.pix);
            if (this.xvy) {
                this.drawPixels(this.pix.y, this.pix.x, n, line);
            } else {
                this.drawPixels(this.pix.x, this.pix.y, n, line);
            }
            npts -= this.pix.off;
            off += dim * this.pix.off;
            if (!this.pix.save) continue;
            if (this.xvy) {
                this.drawPixels(this.pix.sy, this.pix.sx, 2, line);
            } else {
                this.drawPixels(this.pix.sx, this.pix.sy, 2, line);
            }
            this.pix.save = false;
        }
        this.pix.flags = 0;
        return off;
    }

    int drawLineContour(double[] buf, int off, int dim, int npts, Line line) {
        this.pix.flags = 16;
        while (npts > 0 && buf != null) {
            int n = this.viewer.rwc2pix(buf, off, dim, npts, this.pix);
            if (this.xvy) {
                this.drawPixels(this.pix.y, this.pix.x, n, line);
            } else {
                this.drawPixels(this.pix.x, this.pix.y, n, line);
            }
            npts -= this.pix.off;
            off += dim * this.pix.off;
            if (!this.pix.save) continue;
            if (this.xvy) {
                this.drawPixels(this.pix.sy, this.pix.sx, this.pix.n, line);
            } else {
                this.drawPixels(this.pix.sx, this.pix.sy, this.pix.n, line);
            }
            this.pix.save = false;
        }
        this.pix.flags = 0;
        return off;
    }

    private int drawLine(double[] buf, int off, int dim, int npts, Line line, int pixFlags) {
        return this.drawLine(buf, off, dim, npts, line, pixFlags, this.gc, false);
    }

    int drawLine(double[] buf, int off, int dim, int npts, Line line, int pixFlags, boolean highZoomFix) {
        return this.drawLine(buf, off, dim, npts, line, pixFlags, this.gc, highZoomFix);
    }

    int drawLine(double[] buf, int off, int dim, int npts, Line line, int pixFlags, Graphics gc) {
        return this.drawLine(buf, off, dim, npts, line, pixFlags, gc, false);
    }

    int drawLine(double[] buf, int off, int dim, int npts, Line line, int pixFlags, Graphics gc, boolean highZoomFix) {
        boolean isContinuous;
        this.pix.flags = pixFlags;
        boolean resetPix = false;
        boolean highZoomMXX = this.view == 13 ? this.mxx >= 8.947848529166667E8 : this.mxx >= HIGH_ZOOM_MXX;
        boolean trimToVisibleLine = highZoomFix && highZoomMXX;
        DPix dpix = null;
        boolean bl = isContinuous = this.view == 14;
        if (trimToVisibleLine) {
            dpix = new DPix(npts, 0);
            dpix.flags = pixFlags;
        }
        while (npts > 0 && buf != null) {
            int n;
            int ns = 2;
            boolean dn = false;
            int dns = 2;
            if ((this.view == 11 || isContinuous || this.view == 12) && line.isTypeSet(8)) {
                if (!trimToVisibleLine) {
                    n = this.viewer.rwc2pix(buf, off, dim, npts, this.pix, line.isTypeSet(8));
                } else {
                    n = this.viewer.rwc2dpixClip(buf, off, dim, npts, this, dpix);
                    if (!isContinuous) {
                        ns = dpix.n;
                    }
                }
                resetPix = true;
            } else {
                n = !trimToVisibleLine ? this.viewer.rwc2pix(buf, off, dim, npts, this.pix, line.isTypeSet(8)) : this.viewer.rwc2dpix(buf, off, dim, npts, dpix);
            }
            if (!trimToVisibleLine) {
                if (this.xvy) {
                    this.drawPixels(this.pix.y, this.pix.x, n, line, gc);
                } else {
                    this.drawPixels(this.pix.x, this.pix.y, n, line, gc);
                }
                npts -= this.pix.off;
                off += dim * this.pix.off;
                if (!this.pix.save) continue;
                if (this.xvy) {
                    this.drawPixels(this.pix.sy, this.pix.sx, this.pix.n, line, gc);
                } else {
                    this.drawPixels(this.pix.sx, this.pix.sy, this.pix.n, line, gc);
                }
                this.pix.save = false;
                continue;
            }
            if (line.isTypeSet(8)) {
                boolean isViewAreaInsidePolygon = false;
                Rectangle2D.Double viewBounds = new Rectangle2D.Double(this.ix1, this.iy1, this.ix21, this.iy21);
                GeometricUtil.LineSegmentGroup[] intersectingLineSegGrp = GeometricUtil.polygonRectangleIntersect(dpix.x, dpix.y, dpix.off, 0, viewBounds);
                if (intersectingLineSegGrp == null) {
                    intersectingLineSegGrp = GeometricUtil.allOrNone(dpix.x, dpix.y, dpix.off, 0, viewBounds);
                    if (intersectingLineSegGrp == null) {
                        return off;
                    }
                    isViewAreaInsidePolygon = true;
                }
                if (intersectingLineSegGrp.length > 1 || isViewAreaInsidePolygon) {
                    int i;
                    for (i = 0; i < intersectingLineSegGrp.length; ++i) {
                        if (this.xvy) {
                            this.drawPixels(intersectingLineSegGrp[i].ycoords, intersectingLineSegGrp[i].xcoords, intersectingLineSegGrp[i].ycoords.length, line, gc);
                            continue;
                        }
                        this.drawPixels(intersectingLineSegGrp[i].xcoords, intersectingLineSegGrp[i].ycoords, intersectingLineSegGrp[i].ycoords.length, line, gc);
                    }
                    if (dpix.save) {
                        intersectingLineSegGrp = GeometricUtil.polygonRectangleIntersect(dpix.sx, dpix.sy, dpix.off, 0, viewBounds);
                        if (intersectingLineSegGrp == null) {
                            return off;
                        }
                        for (i = 0; i < intersectingLineSegGrp.length; ++i) {
                            if (this.xvy) {
                                this.drawPixels(intersectingLineSegGrp[i].ycoords, intersectingLineSegGrp[i].xcoords, intersectingLineSegGrp[i].ycoords.length, line, gc);
                            } else {
                                this.drawPixels(intersectingLineSegGrp[i].xcoords, intersectingLineSegGrp[i].ycoords, intersectingLineSegGrp[i].ycoords.length, line, gc);
                            }
                            dpix.save = false;
                        }
                    }
                } else {
                    int[][] lineSegmentGroup = GeometricUtil.connectTheDots(intersectingLineSegGrp[0].xcoords, intersectingLineSegGrp[0].ycoords, intersectingLineSegGrp[0].entry, intersectingLineSegGrp[0].exit, viewBounds, dpix.x, dpix.y, npts, 0);
                    if (this.xvy) {
                        this.drawPixels(lineSegmentGroup[1], lineSegmentGroup[0], lineSegmentGroup[1].length, line, gc);
                    } else {
                        this.drawPixels(lineSegmentGroup[0], lineSegmentGroup[1], lineSegmentGroup[1].length, line, gc);
                    }
                    if (dpix.save) {
                        intersectingLineSegGrp = GeometricUtil.polygonRectangleIntersect(dpix.sx, dpix.sy, dpix.off, 0, viewBounds);
                        if (intersectingLineSegGrp == null) {
                            return off;
                        }
                        lineSegmentGroup = GeometricUtil.connectTheDots(intersectingLineSegGrp[0].xcoords, intersectingLineSegGrp[0].ycoords, intersectingLineSegGrp[0].entry, intersectingLineSegGrp[0].exit, viewBounds, dpix.sx, dpix.sy, npts, 0);
                        for (int i = 0; i < intersectingLineSegGrp.length; ++i) {
                            if (this.xvy) {
                                this.drawPixels(lineSegmentGroup[1], lineSegmentGroup[0], lineSegmentGroup[1].length, line, gc);
                            } else {
                                this.drawPixels(lineSegmentGroup[0], lineSegmentGroup[1], lineSegmentGroup[1].length, line, gc);
                            }
                            dpix.save = false;
                        }
                    }
                }
                npts -= dpix.off;
                off += dim * dpix.off;
                continue;
            }
            Pix[] lineGrps = this.viewer.dpix2viewablePix(dpix, n, 0);
            if (lineGrps != null) {
                for (int g = 0; g < lineGrps.length; ++g) {
                    if (this.xvy) {
                        this.drawPixels(lineGrps[g].y, lineGrps[g].x, lineGrps[g].n, line, gc);
                    } else {
                        this.drawPixels(lineGrps[g].x, lineGrps[g].y, lineGrps[g].n, line, gc);
                    }
                    if (!lineGrps[g].save) continue;
                    if (this.xvy) {
                        this.drawPixels(lineGrps[g].sy, lineGrps[g].sx, dns, line, gc);
                    } else {
                        this.drawPixels(lineGrps[g].sx, lineGrps[g].sy, dns, line, gc);
                    }
                    dpix.save = false;
                }
            }
            npts -= dpix.off;
            off += dim * dpix.off;
        }
        this.pix.flags = 0;
        if (resetPix) {
            this.pix = new Pix(4096, this.pix.flags);
        }
        return off;
    }

    public int drawVertical(double x) {
        int ix = (int)(x * this.mxx + this.mxb);
        if (ix <= this.ix1 || ix >= this.ix2 || this.gc == null) {
            return 0;
        }
        this.gc.drawLine(ix, this.iy1, ix, this.iy2 - 2);
        return 1;
    }

    public int drawHorizontal(double y) {
        int iy = (int)(y * this.myy + this.myb);
        if (iy <= this.iy1 || iy >= this.iy2 || this.gc == null) {
            return 0;
        }
        this.gc.drawLine(this.ix1, iy, this.ix2 - 2, iy);
        return 1;
    }

    public int drawEllipse(double lon, double lat, double alt, double semiMajor, double semiMinor, double tilt, int div, Line line) {
        return this.drawEllipse(lon, lat, alt, semiMajor, semiMinor, tilt, div, line, this.gc, false);
    }

    int drawEllipse(double lon, double lat, double alt, double semiMajor, double semiMinor, double tilt, int div, Line line, boolean highZoomFix) {
        return this.drawEllipse(lon, lat, alt, semiMajor, semiMinor, tilt, div, line, this.gc, highZoomFix);
    }

    public int drawEllipse(double lon, double lat, double alt, double semiMajor, double semiMinor, double tilt, int div, Line line, Graphics gc) {
        return this.drawEllipse(lon, lat, alt, semiMajor, semiMinor, tilt, div, line, gc, false);
    }

    int drawEllipse(double lon, double lat, double alt, double semiMajor, double semiMinor, double tilt, int div, Line line, Graphics gc, boolean highZoomFix) {
        int i;
        double maxdiv = this.ediv;
        if (this.et == null) {
            this.et = new Transform();
        }
        this.et.setTOP(alt, lat, lon, tilt, 0.0, 0.0);
        double a2i = 1.0 / (semiMajor * semiMajor);
        double b2i = 1.0 / (semiMinor * semiMinor);
        if (div == -1) {
            DPix centerD = new DPix(1, 64);
            DPix pointD = new DPix(1, 64);
            double[] location = new double[]{Math.sqrt(1.0 / a2i), 0.0, 0.0};
            Transform.top2ecr(location, 1, 1, this.et);
            Transform.car2geo(location, 1, 1);
            this.getPoint(lon, lat, alt, centerD);
            this.getPoint(location[2], location[1], location[0], pointD);
            double delta = Math.max(Math.abs(centerD.x[0] - pointD.x[0]), Math.abs(centerD.y[0] - pointD.y[0]));
            maxdiv = Math.max(delta / 4.0, 1.0) * 8.0;
            if (delta < 2.0) {
                this.setColor(line.getColor());
                if (gc == null) {
                    return 0;
                }
                if (this.view == 13) {
                    centerD.flags = 1;
                    this.getPoint(lon, lat, alt, centerD);
                }
                gc.drawLine((int)centerD.x[0], (int)centerD.y[0], (int)centerD.x[0], (int)centerD.y[0]);
                return 1;
            }
        }
        if (div < 0) {
            div = (int)Math.min(maxdiv, (double)this.ediv);
        }
        int elen = (div + 1) * 3;
        if (this.edata == null || this.edata.length < elen) {
            this.edata = new double[elen];
        }
        double dtheta = Math.PI * 2 / (double)div;
        int j = 0;
        for (i = 0; i < div; ++i) {
            double theta = (double)i * dtheta;
            double ctheta = Math.cos(theta);
            double stheta = Math.sin(theta);
            double r = Math.sqrt(1.0 / (a2i * ctheta * ctheta + b2i * stheta * stheta));
            this.edata[j++] = r * ctheta;
            this.edata[j++] = r * stheta;
            this.edata[j++] = 0.0;
        }
        Transform.top2ecr(this.edata, 1, div, this.et);
        Transform.car2geo(this.edata, 1, div);
        Transform.all2lla(this.edata, div);
        for (i = 0; i < 3; ++i) {
            this.edata[j++] = this.edata[i];
        }
        this.drawLine(this.edata, 0, 3, div + 1, line, 18, gc, highZoomFix);
        return div;
    }

    int drawEllipsoidSliceXYZ(Position pos, boolean isGeodeticData, double[] semis, ellipseAxis axisDiscretized, double[][] yprTMatrix, int div, Line line, Graphics gc, boolean highZoomFix) {
        int i;
        double b2i;
        double a2i;
        if (div < 0) {
            div = this.ediv;
        }
        int elen = (div + 1) * 3;
        if (this.edata == null || this.edata.length < elen) {
            this.edata = new double[elen];
        }
        double dtheta = Math.PI * 2 / (double)div;
        if (this.edata == null || this.edata.length < elen) {
            this.edata = new double[elen];
        }
        dtheta = Math.PI * 2 / (double)div;
        switch (axisDiscretized) {
            case Z: {
                a2i = 1.0 / (semis[0] * semis[0]);
                b2i = 1.0 / (semis[1] * semis[1]);
                break;
            }
            case Y: {
                a2i = 1.0 / (semis[0] * semis[0]);
                b2i = 1.0 / (semis[2] * semis[2]);
                break;
            }
            default: {
                a2i = 1.0 / (semis[1] * semis[1]);
                b2i = 1.0 / (semis[2] * semis[2]);
            }
        }
        int j = 0;
        for (i = 0; i < div; ++i) {
            double _z;
            double _y;
            double _x;
            double theta = (double)i * dtheta;
            double ctheta = Math.cos(theta);
            double stheta = Math.sin(theta);
            double r = Math.sqrt(1.0 / (a2i * ctheta * ctheta + b2i * stheta * stheta));
            switch (axisDiscretized) {
                case Z: {
                    _x = r * ctheta;
                    _y = r * stheta;
                    _z = semis[2];
                    break;
                }
                case Y: {
                    _x = r * ctheta;
                    _y = semis[1];
                    _z = r * stheta;
                    break;
                }
                default: {
                    _x = semis[0];
                    _y = r * ctheta;
                    _z = r * stheta;
                }
            }
            double xT = _x * yprTMatrix[0][0] + _y * yprTMatrix[0][1] + _z * yprTMatrix[0][2];
            double yT = _x * yprTMatrix[1][0] + _y * yprTMatrix[1][1] + _z * yprTMatrix[1][2];
            double zT = _x * yprTMatrix[2][0] + _y * yprTMatrix[2][1] + _z * yprTMatrix[2][2];
            this.edata[j++] = isGeodeticData ? xT : xT + pos.x;
            this.edata[j++] = isGeodeticData ? yT : yT + pos.y;
            this.edata[j++] = isGeodeticData ? zT : zT + pos.z;
        }
        if (isGeodeticData) {
            this.et = new Transform();
            this.et.setTOP(pos.alt, pos.lat, pos.lon, 0.0, 0.0, 0.0);
            Transform.top2ecr(this.edata, 1, div, this.et);
            Transform.car2geo(this.edata, 1, div);
            Transform.all2lla(this.edata, div);
        }
        for (i = 0; i < 3; ++i) {
            this.edata[j++] = this.edata[i];
        }
        this.drawLine(this.edata, 0, 3, div + 1, line, 18, gc, highZoomFix);
        return div;
    }

    public int drawEllipseOnMap(double lon, double lat, double alt, double semiMajor, double semiMinor, double tilt, int div, Line line, Graphics gc) {
        return this.drawEllipse(lon, lat, alt, semiMajor, semiMinor, 90.0 - tilt, div, line, gc);
    }

    public int drawCone(Position p, Position q, int cut, int div, double angle, double range, Line line) {
        return this.drawCone(p, q, cut, div, angle, range, line, 1);
    }

    int drawCone(Position p, Position q, int cut, int div, double angle, double range, Line line, boolean highZoomFix) {
        return this.drawCone(p, q, cut, div, angle, range, line, 1, highZoomFix);
    }

    public int drawCone(Position p, Position q, int cut, int div, double angle, double range, Line line, int mode) {
        return this.drawCone(p, q, cut, div, angle, range, line, mode, false);
    }

    int drawCone(Position p, Position q, int cut, int div, double angle, double range, Line line, int mode, boolean highZoomFix) {
        int i;
        int j;
        int i2;
        if (line == null) {
            return cut;
        }
        if (mode == -1) {
            this.drawCone(p, q, cut, div, angle, range, line, 1, highZoomFix);
            mode = 0;
            line = line.copy();
            line.setType(2);
        }
        boolean trimToGeoSurface = false;
        if (cut == -1) {
            trimToGeoSurface = true;
            cut = 1;
        }
        int ii = 0;
        int npts = div + 2;
        int nrec = npts * cut + 1;
        int elen = nrec * 3;
        double rclip = 6388137.0;
        double[] data = new double[3];
        if (this.ctp == null) {
            this.ctp = new Transform();
        }
        if (this.ctq == null) {
            this.ctq = new Transform();
        }
        if (this.cdata == null || this.cdata.length < elen) {
            this.cdata = new double[elen];
        }
        if (p.referenceFrame != 1) {
            p.car2geo();
        }
        this.ctp.setTOP(p.alt, p.lat, p.lon);
        if (q.referenceFrame != 1) {
            q.car2geo();
        }
        this.ctq.setTOP(q.alt, q.lat, q.lon);
        data[2] = 0.0;
        data[1] = 0.0;
        data[0] = 0.0;
        Transform.top2top(data, 1, 1, this.ctq, this.ctp);
        double x = data[0];
        double y = data[1];
        double z = data[2];
        double r = Math.sqrt(x * x + y * y + z * z);
        double azim = 0.0;
        double elev = 0.0;
        double roll = 0.0;
        if (x != 0.0 || z != 0.0) {
            elev = 57.29577951308232 * Math.atan2(-x, z);
        }
        if (r != 0.0) {
            roll = 57.29577951308232 * Math.asin(Math.min(1.0, Math.max(-1.0, -y / r)));
        }
        this.ctp.setTOP(p.alt, p.lat, p.lon, azim, elev, roll);
        if (range > 0.0) {
            r = range;
        }
        double dtheta = Math.PI * 2 / (double)div;
        double cr = r * Math.tan(Math.PI / 180 * angle);
        double cz = range < 0.0 ? 0.0 : r;
        this.cdata[ii++] = 0.0;
        this.cdata[ii++] = 0.0;
        this.cdata[ii++] = cz;
        for (i2 = 0; i2 <= div; ++i2) {
            double theta = (double)i2 * dtheta;
            this.cdata[ii++] = cr * Math.cos(theta);
            this.cdata[ii++] = cr * Math.sin(theta);
            this.cdata[ii++] = cz;
        }
        for (j = 1; j < cut; ++j) {
            double factor = (double)(cut - j) / (double)cut;
            cz = range < 0.0 ? (1.0 - factor) * r : r * factor;
            int jj = 0;
            for (i = 0; i < npts; ++i) {
                this.cdata[ii++] = this.cdata[jj++] * factor;
                this.cdata[ii++] = this.cdata[jj++] * factor;
                this.cdata[ii++] = cz;
                ++jj;
            }
        }
        cz = range < 0.0 ? r : 0.0;
        this.cdata[ii++] = 0.0;
        this.cdata[ii++] = 0.0;
        this.cdata[ii++] = cz;
        Transform.top2ecr(this.cdata, 1, nrec, this.ctp);
        for (i2 = 0; i2 < 3; ++i2) {
            data[i2] = this.cdata[elen - 3 + i2];
        }
        j = 0;
        i = 0;
        while (j < cut) {
            x = this.cdata[i + 0];
            y = this.cdata[i + 1];
            z = this.cdata[i + 2];
            r = Math.sqrt(x * x + y * y + z * z);
            if (r < rclip) {
                Transform.clipAtEarth(this.cdata, i, npts, data, mode, trimToGeoSurface, p, angle);
            }
            ++j;
            i += npts * 3;
        }
        Transform.car2geo(this.cdata, 1, nrec);
        Transform.all2lla(this.cdata, nrec);
        if (trimToGeoSurface && Transform.getUseLegacyConeCode()) {
            j = 0;
            i = 5;
            while (j < npts) {
                this.cdata[i] = 0.0;
                ++j;
                i += 3;
            }
        }
        j = 0;
        i = 3;
        while (j < cut) {
            this.drawLine(this.cdata, i, 3, div + 1, line, 18, highZoomFix);
            ++j;
            i += npts * 3;
        }
        return cut;
    }

    public int drawPixels(int[] y, int[] x, int n, Line line) {
        return this.drawPixels(y, x, n, line, this.gc);
    }

    public int drawPixels(int[] pax, int[] pay, int n, Line line, Graphics gc) {
        Symbol sym;
        int i;
        if (line == null) {
            return n;
        }
        if (gc == null) {
            return 0;
        }
        if (line != this.lastLine || line.getNeedRefresh()) {
            line.updateGraphics(gc);
            line.clearNeedRefresh();
            this.lastLine = line;
        }
        this.setColor(line.getColor());
        if (n < 0) {
            return this.drawCompressedPixels(pax, pay, -n, line);
        }
        int type = line.getTypeInt();
        if (type == 1) {
            gc.drawPolyline(pax, pay, n);
            return n;
        }
        if ((type & 8) != 0 && n > 0) {
            this.setColor(line.getFillColor());
            gc.fillPolygon(pax, pay, n);
            this.setColor(line.getColor());
        }
        if ((type & 1) != 0) {
            gc.drawPolyline(pax, pay, n);
        }
        if ((type & 2) != 0) {
            for (i = 0; i < n; ++i) {
                gc.drawLine(pax[i], pay[i], pax[i], pay[i]);
            }
        }
        if ((type & 4) != 0) {
            int r = line.getRadius();
            int d = r * 2;
            for (int i2 = 0; i2 < n; ++i2) {
                gc.drawOval(pax[i2] - r, pay[i2] - r, d, d);
            }
        }
        if ((type & 0x10) != 0) {
            for (i = 0; i < n; ++i) {
                gc.drawLine(pax[i], pay[i], pax[i], this.iy2);
            }
        }
        if ((type & 0x20) != 0 && (sym = line.getSymbol()) != null) {
            for (int i3 = 0; i3 < n; ++i3) {
                sym.draw(pax[i3], pay[i3], gc);
            }
        }
        return n;
    }

    public int drawCompressedPixels(int[] pax, int[] pay, int n, Line line) {
        boolean sym;
        int y;
        int x;
        if (this.gc == null) {
            return 0;
        }
        int type = line.getTypeInt();
        if ((type & 1) != 0) {
            int[] tmp;
            if (this.xvy) {
                tmp = pax;
                pax = pay;
                pay = tmp;
            }
            int i = 0;
            while (i < n) {
                int y2;
                x = pax[i];
                int y1 = y2 = pay[i];
                while (i < n && pax[i] == x) {
                    y = pay[i];
                    if (y < y1) {
                        y1 = y;
                    } else if (y > y2) {
                        y2 = y;
                    }
                    ++i;
                }
                if (this.xvy) {
                    this.gc.drawLine(y1, x, y2, x);
                    continue;
                }
                this.gc.drawLine(x, y1, x, y2);
            }
            if (this.xvy) {
                tmp = pax;
                pax = pay;
                pay = tmp;
            }
        }
        boolean pnt = (type & 2) != 0;
        boolean dot = (type & 4) != 0;
        boolean bl = sym = (type & 0x20) != 0;
        if (pnt || dot || sym) {
            int r = line.getRadius();
            int d = r * 2;
            int _iy2 = this.iy2;
            if (_iy2 < 0) {
                return 0;
            }
            boolean[] yb = new boolean[_iy2];
            int i = 0;
            while (i < n) {
                x = pax[i];
                while (i < n && pax[i] == x) {
                    y = pay[i];
                    if (y > 0 && y < _iy2) {
                        yb[y] = true;
                    }
                    ++i;
                }
                for (y = this.iy1; y < _iy2; ++y) {
                    if (!yb[y]) continue;
                    if (pnt) {
                        this.gc.drawLine(x, y, x, y);
                    }
                    if (dot) {
                        this.gc.drawOval(x - r, y - r, d, d);
                    }
                    if (sym) {
                        line.getSymbol().draw(x, y, this.gc);
                    }
                    yb[y] = false;
                }
            }
        }
        return n;
    }

    public void drawImage(BufferedImage img, double north, double south, double east, double west) {
        boolean isViewGeo;
        double unwrappedEast;
        boolean imageCrossBounds;
        boolean debug = false;
        MPoint nwpx = new MPoint();
        MPoint sepx = new MPoint();
        double[] northWest = new double[]{west, north, 0.0};
        double[] southEast = new double[]{east, south, 0.0};
        int h = img.getHeight();
        int w = img.getWidth();
        double p = 1.0E-5;
        double leftBounds = this.viewer.MP.view == 14 ? this.viewer.MP.orx1 : (double)LONGITUDE_DEFAULT_MIN;
        double rightBounds = leftBounds + (double)LONGITUDE_RANGE;
        boolean crossOrigBounds = imageCrossBounds = Math.abs(west - east) > (double)(LONGITUDE_RANGE / 2);
        double d = unwrappedEast = imageCrossBounds ? east + (double)LONGITUDE_RANGE : east;
        if (debug) {
            System.out.println("crossDateLine =" + imageCrossBounds);
            System.out.println("east=" + east);
            System.out.println("west=" + west);
            System.out.println("viewer.mp.rx1=" + this.viewer.MP.rx1);
            System.out.println("viewer.mp.rx2=" + this.viewer.MP.rx2);
            System.out.println("viewer.mp.orx1=" + this.viewer.MP.orx1);
            System.out.println("viewer.mp.orx2=" + this.viewer.MP.orx2);
        }
        boolean reversed = false;
        double reversedWidth = 0.0;
        double smallest = west;
        double largest = unwrappedEast;
        if (west > unwrappedEast) {
            smallest = unwrappedEast;
            largest = west;
            reversedWidth = Math.max(east, west) - Math.min(east, west);
            reversed = true;
        }
        if (this.viewer.MP.view == 14 && this.viewer.MP.hasExtendedRange()) {
            boolean crossesLeftBounds;
            boolean crossesRightBounds = smallest < rightBounds && largest > rightBounds;
            boolean bl = crossesLeftBounds = smallest < leftBounds && largest > leftBounds;
            if (imageCrossBounds && !crossesRightBounds && !crossesLeftBounds) {
                southEast[0] = east += (double)LONGITUDE_RANGE;
                imageCrossBounds = false;
            } else if (!imageCrossBounds && (crossesRightBounds || crossesLeftBounds)) {
                imageCrossBounds = true;
                if (reversed) {
                    northWest[0] = east;
                    southEast[0] = west;
                }
            }
        } else if (imageCrossBounds && reversed) {
            northWest[0] = east;
            southEast[0] = west;
        }
        if (debug) {
            System.out.println("imageCrossBounds = " + imageCrossBounds);
            System.out.println("east after latloncheck=" + east);
        }
        if (!(isViewGeo = this.viewer instanceof ViewGeo) && imageCrossBounds) {
            double partialWidth;
            double continuousAdjust;
            double totalWidth;
            double max = rightBounds;
            double min = leftBounds;
            double[] newSouthEast = new double[]{max - p, south, 0.0};
            double[] newNorthWest = new double[]{min + p, north, 0.0};
            double supplementalRange = crossOrigBounds ? (double)LONGITUDE_RANGE : 0.0;
            double d2 = totalWidth = reversed ? reversedWidth : east + supplementalRange - west;
            double d3 = max > (double)LONGITUDE_DEFAULT_MAX + p && !(max - (reversed ? east : west) <= totalWidth) ? (double)LONGITUDE_RANGE : (continuousAdjust = 0.0);
            if (debug) {
                System.out.println("TotalWidth = " + totalWidth + " max:" + max + " continuousAdjust:" + continuousAdjust);
            }
            if ((partialWidth = newSouthEast[0] - continuousAdjust - (reversed ? east : west)) > totalWidth || partialWidth < 0.0) {
                partialWidth = totalWidth - (newSouthEast[0] - (reversed ? east : west));
            }
            double ratio = partialWidth / totalWidth;
            int newWidth = (int)((double)w * ratio);
            if (debug) {
                System.out.println("newSouthEast[0]=" + newSouthEast[0]);
                System.out.println("west = " + west);
                System.out.println("ratio1 = " + ratio);
                System.out.println("newWidth = " + newWidth);
            }
            this.viewer.rwc2pix(reversed ? newNorthWest : northWest, nwpx);
            this.viewer.rwc2pix(reversed ? southEast : newSouthEast, sepx);
            int splitLocationOfImage = reversed ? w - newWidth : newWidth;
            this.gc.drawImage(img, reversed ? sepx.x : nwpx.x, nwpx.y, reversed ? nwpx.x : sepx.x, sepx.y, 0, 0, splitLocationOfImage, h, this);
            if (debug) {
                System.out.println("ratio2 = " + ratio);
            }
            if (debug) {
                System.out.println("newWidth = " + newWidth);
            }
            this.viewer.rwc2pix(reversed ? northWest : newNorthWest, nwpx);
            this.viewer.rwc2pix(reversed ? newSouthEast : southEast, sepx);
            this.gc.drawImage(img, reversed ? sepx.x : nwpx.x, nwpx.y, reversed ? nwpx.x : sepx.x, sepx.y, splitLocationOfImage, 0, w, h, this);
        } else {
            this.viewer.rwc2pix(northWest, nwpx);
            this.viewer.rwc2pix(southEast, sepx);
            if (isViewGeo) {
                this.forceKeepWhenOneSideVisible(nwpx, sepx, northWest, southEast);
            }
            if (debug) {
                System.out.println("nwpx.x=" + nwpx.x + ", nwpx.y=" + nwpx.y + ", sepx.x=" + sepx.x + ", sepx.y=" + sepx.y + "h=" + h + "w=" + w);
            }
            this.gc.drawImage(img, nwpx.x, nwpx.y, sepx.x, sepx.y, 0, 0, w, h, this);
        }
        if (debug) {
            System.out.println("\n\n");
        }
    }

    private void forceKeepWhenOneSideVisible(MPoint nwpx, MPoint sepx, double[] northWest, double[] southEast) {
        boolean visSE;
        boolean visNW = nwpx.x != 0 || nwpx.y != 0;
        boolean bl = visSE = sepx.x != 0 || sepx.y != 0;
        if (visNW && !visSE) {
            this.tpix.flags = 64;
            this.viewer.rwc2pix(southEast, sepx);
            this.tpix.flags = 1;
        } else if (visSE && !visNW) {
            this.tpix.flags = 64;
            this.viewer.rwc2pix(northWest, nwpx);
            this.tpix.flags = 1;
        }
    }

    public void drawImage(Image im, int[] pixels, boolean mercator, double xstart, double xdelta, int nx, double ystart, double ydelta, int ny) {
        boolean outofrange;
        if (this.gc == null) {
            return;
        }
        double gx1 = xstart;
        double gx2 = xstart + (double)(nx - 1) * xdelta;
        double gy1 = ystart;
        double gy2 = ystart + (double)(ny - 1) * ydelta;
        if (this.view == 14) {
            this.drawImage(GraphicsUtil.toBufferedImage(im), gy1, gy2, gx2, gx1);
            return;
        }
        if (mercator) {
            gy1 = ViewMercader.mer2lat(gy1);
        }
        if (mercator) {
            gy2 = ViewMercader.mer2lat(gy2);
        }
        double[] gridBox = this.getXYGrid(xdelta > 0.0 ? gx1 : gx2, xdelta > 0.0 ? gx2 : gx1, ydelta > 0.0 ? gy1 : gy2, ydelta > 0.0 ? gy2 : gy1);
        gx1 = gridBox[0];
        gx2 = gridBox[1];
        gy1 = gridBox[2];
        gy2 = gridBox[3];
        if (mercator) {
            gy1 = ViewMercader.lat2mer(gy1);
        }
        if (mercator) {
            gy2 = ViewMercader.lat2mer(gy2);
        }
        int jx1 = 0;
        int jx2 = nx;
        int jy1 = 0;
        int jy2 = ny;
        if (xdelta > 0.0) {
            outofrange = xstart > gx2 || xstart + (double)nx * xdelta < gx1;
            jx1 = Math.max(jx1, (int)((gx1 - xstart) / xdelta + 0.49));
            jx2 = Math.min(jx2, (int)((gx2 - xstart) / xdelta + 1.51));
        } else {
            outofrange = xstart < gx1 || xstart + (double)nx * xdelta > gx2;
            jx1 = Math.max(jx1, (int)((gx2 - xstart) / xdelta + 0.49));
            jx2 = Math.min(jx2, (int)((gx1 - xstart) / xdelta + 1.51));
        }
        if (outofrange || this.cancel) {
            return;
        }
        if (ydelta > 0.0) {
            outofrange = ystart > gy2 || ystart + (double)ny * ydelta < gy1;
            jy1 = Math.max(jy1, (int)((gy1 - ystart) / ydelta + 0.49));
            jy2 = Math.min(jy2, (int)((gy2 - ystart) / ydelta + 1.51));
        } else {
            outofrange = ystart < gy1 || ystart + (double)ny * ydelta > gy2;
            jy1 = Math.max(jy1, (int)((gy2 - ystart) / ydelta + 0.49));
            jy2 = Math.min(jy2, (int)((gy1 - ystart) / ydelta + 1.51));
        }
        if (outofrange || this.cancel) {
            return;
        }
        if (this.xvy) {
            int _iy1 = (int)(this.mxx * (xstart + ((double)jx1 - 0.5) * xdelta) + this.mxb);
            int _iy2 = (int)(this.mxx * (xstart + ((double)jx2 - 0.5) * xdelta) + this.mxb);
            int _ix1 = (int)(this.myy * (ystart + ((double)jy1 - 0.5) * ydelta) + this.myb);
            int _ix2 = (int)(this.myy * (ystart + ((double)jy2 - 0.5) * ydelta) + this.myb);
            this.gc.drawImage(im, _ix1, _iy1, _ix2, _iy2, jx1, jy1, jx2, jy2, this);
        } else if (this.is2D && this.view != 12 && !mercator) {
            int _ix1 = (int)(this.mxx * (xstart + ((double)jx1 - 0.5) * xdelta) + this.mxb);
            int _ix2 = (int)(this.mxx * (xstart + ((double)jx2 - 0.5) * xdelta) + this.mxb);
            int _iy1 = (int)(this.myy * (ystart + ((double)jy1 - 0.5) * ydelta) + this.myb);
            int _iy2 = (int)(this.myy * (ystart + ((double)jy2 - 0.5) * ydelta) + this.myb);
            this.gc.drawImage(im, _ix1, _iy1, _ix2, _iy2, jx1, jy1, jx2, jy2, this);
        } else {
            boolean hasAlpha;
            BufferedImage bi = null;
            boolean usePixels = pixels != null;
            boolean bl = hasAlpha = !usePixels;
            if (!usePixels) {
                bi = (BufferedImage)im;
            }
            int jx21 = jx2 - jx1;
            double factor = 1.0 / this.mxx;
            if (this.view == 13) {
                factor /= Math.PI / 360;
            }
            if (this.is3DView()) {
                factor /= this.view3D.getScale();
            }
            int jd = Math.max(1, (int)((factor /= xdelta) + 0.3));
            int nx0 = (jx2 - jx1) / jd;
            int nx1 = nx0 + 1;
            int nx3 = nx1 * 3;
            int[] tx = new int[4];
            int[] ty = new int[4];
            Pix pa = new Pix(nx1, 1);
            Pix pb = new Pix(nx1, 1);
            double[] dbuf = new double[nx3];
            int jy = jy1 - 1;
            int k = 0;
            while (jy < jy2 && !this.cancel) {
                Pix p1;
                Pix p0;
                int i;
                int jx;
                double y = ystart + (double)(jy + 1) * ydelta;
                if (mercator) {
                    y = ViewMercader.mer2lat(y);
                }
                if (jy < jy1) {
                    jx = jx1;
                    i = 0;
                    while (i < nx3) {
                        dbuf[i++] = xstart + (double)jx * xdelta;
                        dbuf[i++] = y;
                        dbuf[i++] = 0.0;
                        jx += jd;
                    }
                } else {
                    for (i = 1; i < nx3; i += 3) {
                        dbuf[i] = y;
                    }
                }
                if (k == 0) {
                    p0 = pa;
                    p1 = pb;
                } else {
                    p0 = pb;
                    p1 = pa;
                }
                this.viewer.rwc2pix(dbuf, 0, 3, nx1, p1);
                if (jy >= jy1) {
                    jx = jx1;
                    i = 0;
                    while (i < nx0) {
                        tx[0] = p0.x[i];
                        tx[1] = p0.x[i + 1];
                        tx[2] = p1.x[i + 1];
                        tx[3] = p1.x[i];
                        ty[0] = p0.y[i];
                        ty[1] = p0.y[i + 1];
                        ty[2] = p1.y[i + 1];
                        ty[3] = p1.y[i];
                        if (this.view != 13 || tx[0] != 0 && tx[1] != 0 && tx[2] != 0 && tx[3] != 0) {
                            int color = usePixels ? pixels[jx + jy * nx] : bi.getRGB(jx, jy);
                            this.gc.setColor(new Color(color, hasAlpha));
                            this.gc.fillPolygon(tx, ty, 4);
                        }
                        ++i;
                        jx += jd;
                    }
                }
                jy += jd;
                k = 1 - k;
            }
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return true;
    }

    public int dataMode() {
        if (this.level == 0) {
            return 1;
        }
        if ((this.options & 0x200) != 0) {
            return 0;
        }
        if ((this.options & 0x100) != 0) {
            return -1;
        }
        return 1;
    }

    public Position getPosition() {
        this.getPosition(this.px, this.py, this.mp);
        return this.mp;
    }

    public Position getPosition(int px, int py) {
        Position p = new Position();
        this.getPosition(px, py, p);
        return p;
    }

    public void getPosition(int px, int py, Position p) {
        double[] rwc = new double[3];
        MPoint _pix = new MPoint(px, py);
        if (this.view == 12) {
            this.viewer.pix2rwc(_pix, rwc);
        } else {
            this.view2D.pix2rwc(_pix, rwc);
        }
        p.x = rwc[0];
        p.y = rwc[1];
        p.z = 0.0;
        p.t = -1.0;
        Layer lay = this.getBaseLayer();
        if (lay != null) {
            p = lay.getPositionMPlot(px, py, p);
        }
        if (p.t == -1.0) {
            double d = p.t = this.time > 0.0 ? this.time : p.x;
        }
        if (this.view == 13) {
            this.viewGeo.pix2rwc(_pix, rwc);
            p.lon = rwc[0];
            p.lat = rwc[1];
            p.alt = rwc[2];
        } else {
            p.lon = p.x;
            p.lat = p.y;
            p.alt = 0.0;
        }
        p.referenceFrame = this.isMapView() ? 1 : (this.view == 15 ? 2 : 0);
    }

    public MPoint getPoint(Position p) {
        MPoint _pix = new MPoint();
        this.getPoint(p, _pix);
        return _pix;
    }

    public int getPoint(Position p, MPoint pix) {
        if (p.referenceFrame == 1) {
            return this.getPoint(p.getLon(), p.getLat(), p.getAlt(), pix);
        }
        if (this.isMapView()) {
            p.car2geo();
            return this.getPoint(p.getLon(), p.getLat(), p.getAlt(), pix);
        }
        return this.getPoint(p.getX(), p.getY(), p.getZ(), pix);
    }

    int getPoint(Position p, DPix pix) {
        if (p.referenceFrame == 1 || p.referenceFrame == 2) {
            return this.getPoint(p.getLon(), p.getLat(), p.getAlt(), pix);
        }
        if (this.isMapView()) {
            p.car2geo();
            return this.getPoint(p.getLon(), p.getLat(), p.getAlt(), pix);
        }
        return this.getPoint(p.getX(), p.getY(), p.getZ(), pix);
    }

    public int getPoint(double x, double y, double z, MPoint pix) {
        double[] rwc = new double[]{x, y, z};
        return this.viewer.rwc2pix(rwc, pix);
    }

    int getPoint(double x, double y, double z, DPix pix) {
        double[] rwc = new double[]{x, y, z};
        return this.viewer.rwc2dpix(rwc, pix);
    }

    int getPoint(double x, double y, double z, MPoint pix, boolean rangeAdjust) {
        double[] rwc = new double[]{x, y, z};
        if (this.view == 14) {
            return this.viewer.rwc2pix(rwc, pix, rangeAdjust);
        }
        return this.viewer.rwc2pix(rwc, pix);
    }

    int getPoint(double x, double y, double z, DPix pix, boolean rangeAdjust) {
        double[] rwc = new double[]{x, y, z};
        return this.viewer.rwc2dpix(rwc, pix);
    }

    public void setEllipseDiv(int value) {
        this.ediv = value;
        this.refresh();
    }

    public String getView() {
        return Parser.get(viewList, this.view);
    }

    public String getMode() {
        return Parser.get(modeList, this.mode);
    }

    public boolean isMapView() {
        return this.view == 13 || this.view == 12 || this.view == 11 || this.view == 14;
    }

    boolean isLatLonView() {
        return this.view == 11 || this.view == 14;
    }

    boolean isStandardView() {
        return this.view == 11 || this.view == 14 || this.view == 13 || this.view == 12 || this.view == 15 || this.view == 9 || this.view == 10 || this.isStandardXYView();
    }

    boolean isStandardXYView() {
        return this.view == 8 || this.view == 4 || this.view == 6 || this.view == 2 || this.view == 7 || this.view == 3 || this.view == 5 || this.view == 1;
    }

    @Override
    public Object getNextLink() {
        return this.getBaseLayer();
    }

    @Override
    public Object getPrevLink() {
        return this.mh;
    }

    public void centerAndZoom(double xCenter, double yCenter, double xZoom, double yZoom) {
        double xMin = this.orx1;
        double xMax = this.orx2;
        double yMin = this.ory1;
        double yMax = this.ory2;
        double xCtr = xCenter == 0.0 ? xMin : (xMax - xMin) * xCenter + xMin;
        double yCtr = yCenter == 0.0 ? yMin : (yMax - yMin) * yCenter + yMin;
        double xDelta = (xMax - xMin) * xZoom / 2.0;
        double yDelta = (yMax - yMin) * yZoom / 2.0;
        this.zoom(new double[]{xCtr - xDelta, xCtr + xDelta, yCtr - yDelta, yCtr + yDelta}, 0);
        this.hardRefresh();
    }

    public String getXUnitsString() {
        return this.xnf.getCmult() + this.xnf.getUnits();
    }

    public String getYUnitsString() {
        return this.ynf.getCmult() + this.ynf.getUnits();
    }

    public int getXUnits() {
        if (this.view == 11 || this.view == 14 || this.view == 12) {
            return 61;
        }
        return this.xUnitsID;
    }

    public int getYUnits() {
        if (this.view == 11 || this.view == 14 || this.view == 12) {
            return 60;
        }
        return this.yUnitsID;
    }

    public int getZUnits() {
        return this.zUnitsID;
    }

    public void setXMult(int mult) {
        this.setMult(mult, 'X');
    }

    public void setXMult(String mult) {
        this.setMult(mult, 'X');
    }

    public void setMult(Object obj, char axis) {
        if (axis == 'X') {
            this.xnf = new Format("###0.### ?" + DataFile.getUnitsNameShort(this.getXUnits()));
            this.xnf.setExp(obj);
            this.xMult = this.xnf.getExp();
        } else if (axis == 'Y') {
            this.ynf = new Format("###0.### ?" + DataFile.getUnitsNameShort(this.getYUnits()));
            this.ynf.setExp(obj);
            this.yMult = this.ynf.getExp();
        }
        this.refresh();
    }

    public void setYMult(String mult) {
        this.setMult(mult, 'Y');
    }

    public void setYMult(int mult) {
        this.setMult(mult, 'Y');
    }

    public void setMult(int mult, char axis) {
        if (axis == 'X') {
            this.xnf = new Format("###0.### ?" + DataFile.getUnitsNameShort(this.getXUnits()));
            this.xnf.setExp(mult);
            this.xMult = mult;
        } else if (axis == 'Y') {
            this.ynf = new Format("###0.### ?" + DataFile.getUnitsNameShort(this.getYUnits()));
            this.ynf.setExp(mult);
            this.yMult = mult;
        }
        this.refresh();
    }

    public void setXUnits(int units) {
        this.setXUnits(units, true);
    }

    public void setXUnits(String units) {
        this.setXUnits(units.equalsIgnoreCase("DEFAULT") ? -1 : DataFile.getUnitsID(units), true);
    }

    private boolean setXUnits(int units, boolean refresh) {
        boolean xUnitsChanged;
        if (units < 0) {
            units = this.layers.size() > 1 ? this.getBaseLayer().getXUnits() : 0;
        }
        boolean bl = xUnitsChanged = units != this.xUnitsID;
        if (xUnitsChanged) {
            this.xUnitsID = units;
            if (refresh) {
                this.refresh();
            }
        }
        return xUnitsChanged;
    }

    public void setYUnits(int units) {
        this.setYUnits(units, true);
    }

    public void setYUnits(String units) {
        this.setYUnits(units.equalsIgnoreCase("DEFAULT") ? -1 : DataFile.getUnitsID(units), true);
    }

    private boolean setYUnits(int units, boolean refresh) {
        boolean yUnitsChanged;
        if (units < 0) {
            units = this.layers.size() > 1 ? this.getBaseLayer().getYUnits() : 0;
        }
        boolean bl = yUnitsChanged = units != this.yUnitsID;
        if (yUnitsChanged) {
            this.yUnitsID = units;
            if (refresh) {
                this.refresh();
            }
        }
        return yUnitsChanged;
    }

    public void setZUnits(int units) {
        this.setZUnits(units, true);
    }

    public void setZUnits(String units) {
        this.setZUnits(units.equalsIgnoreCase("DEFAULT") ? -1 : DataFile.getUnitsID(units), true);
    }

    private boolean setZUnits(int units, boolean refresh) {
        boolean zUnitsChanged;
        if (units < 0) {
            units = this.layers.size() > 1 ? this.getBaseLayer().getZUnits() : 0;
        }
        boolean bl = zUnitsChanged = units != this.zUnitsID;
        if (zUnitsChanged) {
            this.zUnitsID = units;
            if (refresh) {
                this.refresh();
            }
        }
        return zUnitsChanged;
    }

    public boolean setXYZUnits(int xunits, int yunits, int zunits, boolean refresh) {
        boolean unitsChanged;
        boolean xUnitsChanged = this.setXUnits(xunits, false);
        boolean yUnitsChanged = this.setYUnits(yunits, false);
        boolean zUnitsChanged = this.setZUnits(zunits, false);
        boolean bl = unitsChanged = xUnitsChanged || yUnitsChanged || zUnitsChanged;
        if (refresh && unitsChanged) {
            this.refresh();
        }
        return unitsChanged;
    }

    public void setXAxisLabel(String label) {
        this.setAxisLabels(label, this.customYAxisLabel);
    }

    public String getXAxisLabel() {
        if (this.customXAxisLabel != null) {
            return this.customXAxisLabel;
        }
        return DataFile.getUnitsName(this.xUnitsID);
    }

    public void setYAxisLabel(String label) {
        this.setAxisLabels(this.customXAxisLabel, label);
    }

    public String getYAxisLabel() {
        if (this.customYAxisLabel != null) {
            return this.customYAxisLabel;
        }
        return DataFile.getUnitsName(this.yUnitsID);
    }

    public void setZAxisLabel(String label) {
        this.setAxisLabels(this.customXAxisLabel, this.customYAxisLabel, label);
    }

    public String getZAxisLabel() {
        if (this.customZAxisLabel != null) {
            return this.customZAxisLabel;
        }
        return DataFile.getUnitsName(this.zUnitsID);
    }

    public void setAxisLabels(String xLabel, String yLabel) {
        if (xLabel == null || !xLabel.equals(this.customXAxisLabel)) {
            this.customXAxisLabel = xLabel == null || xLabel.isEmpty() ? null : xLabel;
        }
        if (yLabel == null || !yLabel.equals(this.customYAxisLabel)) {
            this.customYAxisLabel = yLabel == null || yLabel.isEmpty() ? null : yLabel;
        }
        this.panel.repaint();
    }

    private void setAxisLabels(String xLabel, String yLabel, String zLabel) {
        if (xLabel == null || !xLabel.equals(this.customXAxisLabel)) {
            this.customXAxisLabel = xLabel == null || xLabel.isEmpty() ? null : xLabel;
        }
        if (yLabel == null || !yLabel.equals(this.customYAxisLabel)) {
            this.customYAxisLabel = yLabel == null || yLabel.isEmpty() ? null : yLabel;
        }
        if (zLabel == null || !zLabel.equals(this.customZAxisLabel)) {
            this.customZAxisLabel = zLabel == null || zLabel.isEmpty() ? null : zLabel;
        }
        this.panel.repaint();
    }

    public int getScaleAvg() {
        return this.scaleAvg;
    }

    public void setScaleAvg(int frames) {
        this.scaleAvg = frames;
        if ((this.scale & 0x40) != 0) {
            if (this.scaleAvg > 256) {
                Shell.warning("MPlot.setScaleAverage: autoscale length capped to max for NOAVERAGE:256 user specified:" + this.scaleAvg);
                this.scaleAvg = 256;
            }
            for (int n = 1; n < this.layers.size(); ++n) {
                Layer lay = (Layer)this.layers.get(n);
                lay.setAutoscaleBuffersMaxActive(this.scaleAvg);
            }
        }
    }

    public static void setMaxMapOnDragBox(boolean maximizeMap) {
        maxMapOnDragBox = maximizeMap;
    }

    public void setDrawingSurface(BufferedImage img) {
        this.mxx = (double)img.getWidth() / (this.rx2 - this.rx1);
        this.myy = (double)img.getHeight() / (this.ry2 - this.ry1);
        this.mxb = -(this.rx1 * this.mxx);
        this.myb = -(this.ry1 * this.myy);
        double p = 1.0E-5;
        if ((this.rx1 < (double)LONGITUDE_DEFAULT_MIN - p || this.rx2 > (double)LONGITUDE_DEFAULT_MAX + p) && this.view == 14) {
            this.extendedRange = true;
        }
        this.gc = img.createGraphics();
    }

    public void setUseDBImageBackup(boolean useBackupIfNull) {
        this.useDBImageBackup = useBackupIfNull;
    }

    public static void setNeverUseDBImageBackup(boolean neverUseBackupIfNull) {
        neverUseDBImageBackup = neverUseBackupIfNull;
    }

    private boolean useDateString(int units, double t) {
        boolean uds = (this.readout & 0x4000000) > 0 && !this.isMapView() && this.view != 10 && !this.is3DView() && (units == 1 || units == 4) && Math.abs(t) > 100.0;
        return uds;
    }

    public void hardRefresh() {
        this.resetForRefresh();
        this.resize();
        this.refresh(0);
    }

    public void setDragAndDrop(boolean allow, MessageQueue mq) {
        this.allowDragAndDrop = allow;
        if (allow && this.stringDropTarget == null) {
            this.stringDropTarget = new StringDropTarget(this.MW.panel, mq);
        }
    }

    public boolean isDragAndDropEnabled() {
        return this.allowDragAndDrop;
    }

    @Deprecated
    public double getXS() {
        return this.getXStart();
    }

    private void setXS(double value) {
        this.setXStart(value);
    }

    private double getXS(int layer) {
        return this.getXStart(layer);
    }

    private void setXD(double size) {
        this.setXDelta(size);
    }

    private double getXD() {
        return this.getXDelta();
    }

    private double getXD(int layer) {
        return this.getXDelta(layer);
    }

    public void setUseMousePosition(boolean useMousePosition) {
        this.useMousePosition = useMousePosition;
    }

    public boolean hasExtendedRange() {
        return this.extendedRange;
    }

    public void setCurrentMMBClickedLocation(Point currentMMBClickedLocation) {
        this.currentMMBClickedLocation = currentMMBClickedLocation;
    }

    public boolean is3DView() {
        return this.view == 15 || this.view == 9;
    }

    double getZoomLevelAsDecimal() {
        double x1ToUse = this.rx1;
        double x2ToUse = this.rx2;
        if (this.rx1 < this.orx1) {
            x1ToUse = this.orx1;
        } else if (this.rx2 > this.orx2) {
            x2ToUse = this.orx2;
        }
        double zoomedRange = Math.abs(x1ToUse - x2ToUse);
        double outerBounds = Math.abs(this.orx1 - this.orx2);
        return zoomedRange / outerBounds;
    }

    @InternalUseOnly
    public void setCutsSwitchOnForPipedLayer2D(boolean cutsOnPipedLayer2D) {
        this.cutsOnPipedLayer2D = cutsOnPipedLayer2D;
    }

    boolean getCutsSwitchOnForPipedLayer2D() {
        return this.cutsOnPipedLayer2D;
    }

    private void nullArchivedFrames() {
        this.archivedFrames = null;
    }

    public static void setMapRefreshShouldClear(boolean mapRefreshShouldClear) {
        MPlot.mapRefreshShouldClear = mapRefreshShouldClear;
    }

    static {
        HIGH_ZOOM_MXX = Integer.MAX_VALUE / LONGITUDE_RANGE;
        Object val = null;
        if (!Shell.isHeadless()) {
            val = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        }
        doubleClickInterval = val instanceof Number ? ((Number)val).intValue() : 400;
        maxMapOnDragBox = true;
    }

    private class StringDropTarget
    implements DropTargetListener {
        private DropTarget dt = null;
        private String str = null;
        private MessageQueue mq = null;

        public StringDropTarget(Component comp, MessageQueue mq) {
            this.mq = mq;
            this.dt = new DropTarget(comp, 3, this);
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            block7: {
                try {
                    Transferable tr = dtde.getTransferable();
                    if (!tr.isDataFlavorSupported(DataFlavor.stringFlavor)) break block7;
                    dtde.acceptDrop(3);
                    this.str = (String)tr.getTransferData(DataFlavor.stringFlavor);
                    try {
                        Table t;
                        if (this.str.indexOf("<XML>") != -1 && this.str.indexOf("<XML>") < 10) {
                            Table xmlT = new Table();
                            XmlFile.fromXML(this.str, xmlT);
                            t = xmlT.getTable("XML");
                        } else {
                            t = new Table(this.str);
                        }
                        if (t != null) {
                            this.mq.put("DROPDATA", 0, t, "MAIN");
                        }
                    }
                    catch (Exception e) {
                        Shell.printStackTrace("MPlot Exception in dropData", e);
                    }
                    dtde.getDropTargetContext().dropComplete(true);
                }
                catch (Exception e) {
                    Shell.printStackTrace(e);
                }
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            dtde.acceptDrag(3);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    public static enum ellipseAxis {
        X,
        Y,
        Z;

    }
}

