/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.lang.reflect.Constructor;
import java.text.Format;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DropMode;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.ListFile;
import nxm.sys.inc.ListInterface;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Cache;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.MFormat;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.RecordComparator;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Util;
import nxm.sys.libg.GraphicsUtil;
import nxm.sys.libg.LargeJTable;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MWindow;
import nxm.sys.libg.Symbol;
import nxm.sys.libg.TableSorter;

public class MJList
extends LargeJTable
implements ListInterface {
    private static final long serialVersionUID = 2012021030311L;
    private transient Midas midas = null;
    private transient ListFile listFile = null;
    private String[] columnNames = null;
    private String[] columnFormats = null;
    private Color shadeColor = null;
    private int shadeInterval = 0;
    private long rowOffset = 1L;
    private long colOffset = 1L;
    private boolean editable = true;
    private boolean adjSelCells = false;
    private String defFgColor = null;
    private String defBgColor = null;
    private int defRowHeight = -1;
    private String globalFgColor = null;
    private String globalBgColor = null;
    private int globalRowHeight = -1;
    private boolean colDrag = true;
    private boolean autoHide = true;
    private boolean autoOrder = true;
    private Table savedTemplate = null;
    private Table mcolorTbl = null;
    private String primaryKey = null;
    private transient Cache priKeyCache = null;
    private JMenuBar menuBar = null;
    private Container parent = null;
    private JToggleButton ulButton = null;
    private JToggleButton urButton = null;
    private JToggleButton llButton = null;
    private JToggleButton lrButton = null;
    private transient ListMessageListener msgListener = null;
    private transient MessageHandler msgHandler = null;
    private static final int SEL_MSGS = 1;
    private static final int SEL_CLEAR = 2;
    private static final int SEL_IGNORE_CASE = 4;
    private final transient ActionListener MENU_ACTION = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MJList.this.msgHandler != null) {
                MJList.this.msgHandler.processMessage(new Message("MENU", 0, e.getActionCommand(), MJList.this.msgHandler, this));
            }
        }
    };
    private static final String[] DEFAULT_FORMATS = new String[]{"STRING", null, "NUMBER", "GEN", "DATE", "STD", "ANGLE", "DMS"};
    @InternalUseOnly
    private static final String FORCE_UPDATE = "Force Update";
    private boolean dragDrop = false;

    private MJList(int maxSortSize) {
        this.setModel(new TableSorter(this, new NmTableModel(this), this.getTableHeader(), maxSortSize));
        super.setColumnModel(new NmColumnModel());
        this.ulButton = new JToggleButton();
        this.ulButton.setEnabled(false);
        this.urButton = new JToggleButton();
        this.urButton.setEnabled(false);
        this.llButton = new JToggleButton();
        this.llButton.setEnabled(false);
        this.lrButton = new JToggleButton(new Symbol.ScrollEnd());
        this.lrButton.setEnabled(true);
        this.lrButton.setBorderPainted(false);
        this.lrButton.setToolTipText("Click to enable/disable ScrollEnd.");
        this.defFgColor = MColor.toString(this.getForeground());
        this.defBgColor = MColor.toString(this.getBackground());
        this.globalRowHeight = this.defRowHeight = this.getRowHeight();
        this.mcolorTbl = new Table();
        this.setDoubleBuffered(true);
        this.autoCreateColumnsFromModel = false;
        super.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                if (MJList.this.isShowing()) {
                    MJList.this.hack();
                    MJList.this.revalidate();
                }
            }

            @Override
            public void ancestorResized(HierarchyEvent e) {
                if (MJList.this.isShowing()) {
                    MJList.this.hack();
                    MJList.this.revalidate();
                }
            }
        });
    }

    public MJList(MWindow mw, int maxSortSize, int baseIndex) {
        this(null, mw, maxSortSize, baseIndex);
    }

    public MJList(Midas midas, MWindow mw, int maxSortSize, int baseIndex) {
        this(maxSortSize);
        Midas midas2 = this.midas = midas == null ? Shell.getSharedMidasContext() : midas;
        if (baseIndex >= 0 && baseIndex <= 1) {
            this.rowOffset = baseIndex;
            this.colOffset = baseIndex;
        } else {
            this.showErrorMsg("Illegal base index '" + baseIndex + "', using default.");
        }
        JScrollPane scrollPane = new JScrollPane(this, 22, 30);
        scrollPane.setVerticalScrollBar(this.getVertScrollBar());
        this.setAutoResizeMode(0);
        this.setVisible(true);
        this.setRowLabelsVisible(true);
        this.setCellSelectionEnabled(true);
        scrollPane.setCorner("UPPER_LEFT_CORNER", this.ulButton);
        scrollPane.setCorner("UPPER_RIGHT_CORNER", this.urButton);
        scrollPane.setCorner("LOWER_LEFT_CORNER", this.llButton);
        scrollPane.setCorner("LOWER_RIGHT_CORNER", this.lrButton);
        if (mw != null) {
            this.addAllListeners(mw);
            this.parent = mw.getPanel();
            this.menuBar = this.createMenu();
            this.parent.setLayout(new BorderLayout());
            this.parent.add((Component)this.menuBar, "North");
            this.parent.add((Component)scrollPane, "Center");
            scrollPane.setBounds(this.parent.getBounds());
            this.parent.setBounds(this.parent.getBounds());
            this.setMenuVisible(false);
        }
    }

    private void hack() {
        this.parent.invalidate();
        this.parent.validate();
    }

    public ListInterface getThreadSafeInstance() {
        return (ListInterface)GraphicsUtil.getThreadSafeInstance((Object)this, ListInterface.class);
    }

    @Override
    public void setMessageHandler(MessageHandler msgHandler) {
        this.msgHandler = msgHandler;
    }

    @Override
    public MessageHandler getMessageHandler() {
        return this.msgHandler;
    }

    private JMenuItem newMenuItem(String action, String text, int mnemonic) {
        JMenuItem menuItem = new JMenuItem(text, mnemonic);
        menuItem.setActionCommand(action);
        menuItem.addActionListener(this.MENU_ACTION);
        return menuItem;
    }

    private JMenu newMenu(String action, String text, int mnemonic) {
        JMenu menu = new JMenu(text);
        menu.setMnemonic(mnemonic);
        menu.setActionCommand(action);
        return menu;
    }

    private JMenuBar createMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = this.newMenu("FILE", "File", 70);
        menuBar.add(fileMenu);
        JMenu editMenu = this.newMenu("EDIT", "Edit", 69);
        menuBar.add(editMenu);
        JMenu naviMenu = this.newMenu("NAVI", "Navigate", 78);
        menuBar.add(naviMenu);
        JMenu tempMenu = this.newMenu("TEMP", "Template", 84);
        menuBar.add(tempMenu);
        JMenu helpMenu = this.newMenu("HELP", "Help", 72);
        menuBar.add(helpMenu);
        fileMenu.add(this.newMenuItem("FILE.LOAD", "Load...", 76));
        fileMenu.add(this.newMenuItem("FILE.REREAD", "Reread", 82));
        fileMenu.add(this.newMenuItem("FILE.SAVE_COPY", "Save Copy...", 83));
        fileMenu.addSeparator();
        fileMenu.add(this.newMenuItem("FILE.EXIT", "Exit LIST2", 88));
        editMenu.add(this.newMenuItem("EDIT.COPY", "Copy", 67));
        editMenu.add(this.newMenuItem("EDIT.PASTE", "Paste...", 80));
        editMenu.add(this.newMenuItem("EDIT.INSERT_ROW", "Insert Row...", 73));
        editMenu.add(this.newMenuItem("EDIT.INSERT_VAL", "Insert Values...", 86));
        editMenu.add(this.newMenuItem("EDIT.DELETE", "Delete Row...", 68));
        editMenu.addSeparator();
        editMenu.add(this.newMenuItem("EDIT.PREF", "Preferences...", 80));
        tempMenu.add(this.newMenuItem("TEMP.LOAD", "Load...", 76));
        tempMenu.add(this.newMenuItem("TEMP.SAVE_COPY", "Save Copy...", 83));
        tempMenu.addSeparator();
        tempMenu.add(this.newMenuItem("TEMP.COPY", "Copy", 67));
        tempMenu.add(this.newMenuItem("TEMP.PASTE", "Paste", 80));
        tempMenu.addSeparator();
        tempMenu.add(this.newMenuItem("TEMP.EDIT", "Edit...", 69));
        tempMenu.add(this.newMenuItem("TEMP.DEF", "Restore Default", 82));
        naviMenu.add(this.newMenuItem("NAVI.GOTO", "Go to Line...", 76));
        helpMenu.add(this.newMenuItem("HELP.ABOUT", "About", 65));
        helpMenu.add(this.newMenuItem("HELP.KEYS", "Keyboard Shortcuts", 75));
        return menuBar;
    }

    public boolean isMenuVisible() {
        return this.menuBar == null ? false : this.menuBar.isVisible();
    }

    public void setMenuVisible(boolean visible) {
        if (this.menuBar != null) {
            this.menuBar.setVisible(visible);
            this.parent.invalidate();
            this.parent.validate();
        }
    }

    public void setListMessageListener(ListMessageListener listener) {
        this.msgListener = listener;
    }

    @Override
    public long getRowOffset() {
        return this.rowOffset;
    }

    @Override
    public long getColOffset() {
        return this.colOffset;
    }

    public void setEditable(boolean val) {
        this.editable = val;
    }

    public boolean isEditable() {
        return this.editable;
    }

    private TableSorter getSortingModel() {
        return (TableSorter)this.getModel();
    }

    private TableModel getDataModel() {
        return this.getSortingModel().getTableModel();
    }

    public void addAllListeners(MWindow mw) {
        if (mw != null) {
            MJList.addAllListeners(this, mw);
            MJList.addAllListeners(this.getScrollPane(), mw);
        }
    }

    public void addMouseKeyListeners(MWindow mw) {
        if (mw != null) {
            MJList.addMouseKeyListeners(this, mw);
            MJList.addMouseKeyListeners(this.getScrollPane(), mw);
        }
    }

    private static void addAllListeners(Component comp, MWindow mw) {
        MJList.addMouseKeyListeners(comp, mw);
        comp.addComponentListener(mw);
        comp.addComponentListener(mw);
        comp.addFocusListener(mw);
    }

    private static void addMouseKeyListeners(Component comp, MWindow mw) {
        comp.addKeyListener(mw.hkl);
        comp.addKeyListener(mw);
        comp.addMouseListener(mw);
        comp.addMouseMotionListener(mw);
    }

    public void setAdjSelCells(boolean value) {
        this.adjSelCells = value;
    }

    public boolean getAdjSelCells() {
        return this.adjSelCells;
    }

    @Override
    public ListFile getListFile() {
        return this.listFile;
    }

    @Override
    public String getColumnOrder() {
        return ((NmColumnModel)this.getColumnModel()).getColumnOrder();
    }

    @Override
    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    @Override
    public final void setSelectMode(String mode) {
        int i = Parser.find("Single,SingleInterval,MultipleInterval", mode, this.getSelectionMode(), -1);
        if (i < 0) {
            throw new MidasException("Illegal selection mode '" + mode + "', expected one of '" + "Single,SingleInterval,MultipleInterval" + "'.");
        }
        this.setSelectionMode(i);
    }

    @Override
    public final String getSelectMode() {
        return Parser.get("Single,SingleInterval,MultipleInterval", this.getSelectionMode(), -1);
    }

    @Override
    public double pollData(boolean poll) {
        double numRead = 0.0;
        if (this.listFile != null) {
            if (this.listFile instanceof PollsOwnData) {
                numRead = ((PollsOwnData)this.listFile).pollData(poll);
            } else if (poll) {
                this.midas.warning("LIST2: Do not know how to poll '" + this.listFile.getURL() + "'.");
            }
        }
        return numRead;
    }

    @Override
    public void setListFile(ListFile listFile) {
        this.setListFile(listFile, false);
    }

    @Override
    public void setListFile(ListFile listFile, boolean readOnly) {
        if (listFile != null) {
            if (!listFile.isOpen()) {
                listFile.open(1);
            }
            if (listFile instanceof DataFile) {
                DataFile dataFile = (DataFile)listFile;
                if (dataFile.isPipe()) {
                    listFile = new PipedDataFile(this.midas, dataFile, this);
                    readOnly = true;
                } else {
                    listFile = new CachedDataFile(this.midas, dataFile, this);
                }
            }
            if (!listFile.getProtected() && !readOnly) {
                listFile.open(3);
            }
        }
        this.listFile = listFile;
        if (listFile != null) {
            int numCols = listFile.getRecordDefCount();
            this.columnNames = new String[numCols];
            this.columnFormats = new String[numCols];
            for (int i = 0; i < numCols; ++i) {
                Table def = listFile.getRecordDef(i);
                this.columnNames[i] = def.getS("NAME");
                this.columnFormats[i] = def.getS("FORMAT");
            }
        } else {
            this.columnNames = new String[0];
            this.columnFormats = new String[0];
        }
        this.doApplyTemplate(this.savedTemplate, true, true);
        this.getLargeTableModel().fireStructureChanged();
        this.showCell(0L, 0L);
    }

    @Override
    public Table getTemplate() {
        Table template = new Table();
        if (this.savedTemplate != null) {
            String[] keys;
            for (String key : keys = this.savedTemplate.getKeys()) {
                template.put(key, (Object)this.savedTemplate.getTable(key).copy());
            }
        }
        return template;
    }

    @Override
    public void setTemplate(Table template) {
        this.doApplyTemplate(template, true, false);
    }

    public void setTemplate(Object table) {
        this.setTemplate(Convert.o2t(table, this.midas));
    }

    @Override
    public void updateTemplate(Table template) {
        this.doApplyTemplate(template, false, false);
    }

    public void updateTemplate(Object template) {
        this.updateTemplate(Convert.o2t(template, this.midas));
    }

    @Override
    public long getNumberOfRows() {
        return this.listFile != null ? (long)this.listFile.getNumberOfRows() : 0L;
    }

    @Override
    public String[] getColumnNames() {
        String[] names = new String[this.getColumnCount()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.getColumnName(i);
        }
        return names;
    }

    @Override
    public Table getRow(long row) {
        return this.listFile != null ? this.listFile.getDataTable(this.getRealRowIndex(row)) : null;
    }

    @Override
    public Table getRow(Table row) {
        if (this.listFile == null) {
            return null;
        }
        long rowNum = this.getRowNumFrom(row);
        return this.listFile.getDataTable(rowNum);
    }

    @Override
    public Table getAllRows() {
        Table tab = new Table();
        for (long i = 0L; i < this.getNumberOfRows(); ++i) {
            tab.put("" + this.getMacroRowIndex(i), (Object)this.listFile.getDataTable(i));
        }
        return tab;
    }

    @Override
    public final void addRow(Table data) {
        int rowPos = data.getL("LIST__POS", -999);
        if (rowPos != -999) {
            this.midas.deprecate("LIST2: use addRow(long,Table) instead of LIST__POS " + rowPos);
            this.addRow(rowPos, data);
        } else {
            this.addRow(-1L, data);
        }
    }

    @Override
    public void addRow(long row, Table data) {
        if (this.listFile != null && data != null) {
            long rowNum = row < 0L ? this.getNumberOfRows() : this.getRealRowIndex(row);
            this.doAddRow(rowNum, data, true);
        }
    }

    @Override
    public final void addRows(Table rows) {
        if (rows != null) {
            String[] keys = rows.getKeys();
            Table[] array = new Table[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                array[i] = rows.getTable(keys[i]);
            }
            this.addRows(array);
        }
    }

    @Override
    public final void addRows(Table[] rows) {
        this.addRows(-1L, rows);
    }

    @Override
    public void addRows(long row, Table[] rows) {
        if (this.listFile != null && rows != null && rows.length > 0) {
            long first = -1L;
            long last = -1L;
            for (Table tbl : rows) {
                if (tbl == null) continue;
                if (first == -1L) {
                    last = row < 0L ? this.getNumberOfRows() : this.getRealRowIndex(row);
                    first = last;
                } else {
                    ++last;
                }
                this.doAddRow(last, tbl, false);
            }
            if (first != -1L) {
                this.getLargeTableModel().fireRowsInserted(first, last);
            }
        }
    }

    private void doAddRow(long rowNum, Table data, boolean fireInsert) {
        this.listFile.insertData(rowNum, data);
        if (fireInsert) {
            this.getLargeTableModel().fireRowsInserted(rowNum, rowNum);
        }
        if (rowNum != -1L && this.adjSelCells) {
            this.adjustSelectedCells(rowNum, true);
        }
    }

    private void adjustSelectedCells(long rowNum, boolean add) {
        if (rowNum < 0L) {
            return;
        }
        if (!add) {
            this.getTableSelectionModel().doRemoveRowSelection(rowNum - 1L, rowNum - 1L, null, false);
        }
        int move = add ? 1 : -1;
        for (LargeJTable.RowSelection row : this.getTableSelectionModel().getCurrentSelection()) {
            if (row.getIndex() < rowNum) continue;
            row.setIndex(row.getIndex() + (long)move);
        }
    }

    private void adjustSelectedCell(long changedRow, long selRow, int selCol, boolean add) {
        this.getTableSelectionModel().changeCellSelection(selRow, selCol, 3, false);
        if (changedRow == selRow + 1L) {
            return;
        }
        int offset = add ? 1 : -1;
        this.getTableSelectionModel().changeCellSelection(selRow + (long)offset, selCol, 3, false);
    }

    @Override
    public void removeAllRows() {
        this.doRemoveRows(this.getMacroRowIndex(0L), -1L);
    }

    @Override
    public final void removeRow(long row) {
        this.removeRows(row, row);
    }

    @Override
    public void removeRow(Table data) {
        long rowNum = this.getRowNumFrom(data);
        if (rowNum >= 0L) {
            this.listFile.removeData(rowNum);
            this.getLargeTableModel().fireRowsDeleted(rowNum, rowNum);
            if (this.adjSelCells) {
                this.adjustSelectedCells(rowNum + 1L, false);
            }
            if (this.getTopRowIndex() >= this.getNumberOfRows()) {
                this.setTopRowIndex(this.getTopRowIndex() - (long)(this.getNumberOfVisibleRows() / 2));
            }
        }
    }

    @Override
    public void removeRows(long start, long end) {
        long count = end - start + 1L;
        if (count < 0L) {
            throw new MidasException("LIST2: removeRows got invalid start and end row combination: start=" + start + " end=" + end);
        }
        this.doRemoveRows(start, count);
    }

    @Override
    public void removeRows(String rowNumbers) {
        if (rowNumbers != null) {
            Parser parser = new Parser(rowNumbers);
            long[] rows = new long[parser.elements()];
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = Convert.o2x(parser.get(i + 1));
            }
            this.doRemoveRows(rows);
        }
    }

    @Override
    public void removeRows(List<?> rowNumbers) {
        if (rowNumbers != null && rowNumbers.size() > 0) {
            long[] rows = new long[rowNumbers.size()];
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = Convert.o2x(rowNumbers.get(i));
            }
            this.doRemoveRows(rows);
        }
    }

    private void doRemoveRows(long row, long count) {
        long previousRowCount = this.getNumberOfRows();
        if (this.listFile != null) {
            long rowNum;
            long l = rowNum = row < 0L ? this.getNumberOfRows() : this.getRealRowIndex(row);
            if (count != 0L) {
                if (count > 0L) {
                    this.listFile.removeData(rowNum, count);
                    this.getLargeTableModel().fireRowsDeleted(rowNum, rowNum + count);
                    if (this.adjSelCells) {
                        for (long i = count - 1L; i >= 0L; --i) {
                            this.adjustSelectedCells(rowNum + 1L + i, false);
                        }
                    } else {
                        this.getTableSelectionModel().doRemoveRowSelection(this.getNumberOfRows(), previousRowCount, null, false);
                    }
                } else {
                    this.listFile.removeData(rowNum, -1L);
                    this.getLargeTableModel().fireRowsDeleted(rowNum, -1L);
                }
            }
            if (this.getTopRowIndex() >= this.getNumberOfRows()) {
                this.setTopRowIndex(this.getTopRowIndex() - (long)(this.getNumberOfVisibleRows() / 2));
            }
        }
    }

    private void doRemoveRows(long[] rows) {
        Arrays.sort(rows);
        if (this.listFile != null) {
            long previousRowCount = this.getNumberOfRows();
            for (int i = rows.length - 1; i >= 0; --i) {
                long rowNum = this.getRealRowIndex(rows[i]);
                this.listFile.removeData(rowNum);
                this.getLargeTableModel().fireRowsDeleted(rowNum, rowNum);
                if (!this.adjSelCells) continue;
                this.adjustSelectedCells(rowNum + 1L, false);
            }
            if (!this.adjSelCells) {
                this.getTableSelectionModel().doRemoveRowSelection(this.getNumberOfRows(), previousRowCount, null, false);
            }
        }
        if (this.getTopRowIndex() >= this.getNumberOfRows()) {
            this.setTopRowIndex(this.getTopRowIndex() - (long)(this.getNumberOfVisibleRows() / 2));
        }
    }

    @Override
    public final void sortData(String keys) {
        this.sortData(keys.split("[,|]"));
    }

    @Override
    public void sortData(String[] keys) {
        this.sortData(new RecordComparator(keys));
    }

    private void sortData(Comparator<Object> comparator) {
        if (this.getNumberOfRows() < 65536L) {
            Table[] rows = new Table[(int)this.getNumberOfRows()];
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = this.listFile.getDataTable(i);
            }
            Arrays.sort(rows, comparator);
            this.removeAllRows();
            this.addRows(rows);
        } else {
            this.showWarningMsg("Unable to sort data, file is too large.");
        }
    }

    @Override
    public void redraw(long row) {
        this.redraw(row, row);
    }

    @Override
    public void redraw(long startRow, long endRow) {
        long top = this.getRealRowIndex(startRow);
        long btm = this.getRealRowIndex(endRow);
        this.getLargeTableModel().fireNeedsRedraw(top, btm);
    }

    @Override
    public final void setCell(Table tbl) {
        String col = tbl.getS("COLUMN");
        if (col == null) {
            col = tbl.getS("COL");
        }
        this.setCell(tbl.getX("ROW"), col, tbl.get("VALUE"));
    }

    @Override
    public void setCell(long row, String col, Object val) {
        if (this.listFile != null) {
            long rowNum = this.getRealRowIndex(row);
            this.listFile.setData(rowNum, col, val);
            this.getLargeTableModel().fireNeedsRedraw(rowNum, rowNum);
        }
    }

    @Override
    public void setRow(long row, Table data) {
        this.doSetRow(this.getRealRowIndex(row), data);
    }

    @Override
    public void setRow(Table data) {
        this.doSetRow(this.getRowNumFrom(data), data);
    }

    private void doSetRow(long rowNum, Table data) {
        if (this.listFile != null && data != null) {
            if (rowNum < 0L || rowNum >= this.getNumberOfRows()) {
                this.doAddRow(rowNum, data, true);
            } else {
                this.listFile.setData(rowNum, data);
                this.getLargeTableModel().fireNeedsRedraw(rowNum, rowNum);
            }
        }
    }

    @Override
    public void updateRow(long row, Table data) {
        long rowNum = this.getRealRowIndex(row);
        Table rowData = this.mergeData(rowNum, data);
        this.doSetRow(rowNum, rowData);
    }

    @Override
    public void updateRow(Table data) {
        long rowNum = this.getRowNumFrom(data);
        Table rowData = this.mergeData(rowNum, data);
        this.doSetRow(rowNum, rowData);
    }

    @Override
    public final void updateRows(Table[] rows) {
        for (Table tbl : rows) {
            this.updateRow(tbl);
        }
    }

    private long getRowNumFrom(Table data) {
        long rowNum = -1L;
        if (this.listFile != null && data != null) {
            if (this.primaryKey != null) {
                String keyVal = data.getS(this.primaryKey);
                if (keyVal == null) {
                    throw new MidasException("updateRow(..) called, but primary key " + this.primaryKey + "= not found in " + data);
                }
                Number num = (Number)this.priKeyCache.get(keyVal);
                if (num != null && num.longValue() >= 0L && num.longValue() < this.getNumberOfRows()) {
                    Table oldRow = this.listFile.getDataTable(num.doubleValue());
                    if (keyVal.equals(oldRow.getS(this.primaryKey))) {
                        rowNum = num.longValue();
                    } else {
                        num = null;
                    }
                }
                for (long row = 0L; rowNum == -1L && row < this.getNumberOfRows(); ++row) {
                    Table oldRow = this.listFile.getDataTable(row);
                    if (!keyVal.equals(oldRow.getS(this.primaryKey))) continue;
                    rowNum = row;
                }
                if (rowNum == -1L) {
                    this.priKeyCache.remove(keyVal);
                } else {
                    if (num == null) {
                        num = rowNum;
                    }
                    this.priKeyCache.put(keyVal, num);
                }
            } else {
                String row = data.getS("ROW");
                if (row != null) {
                    rowNum = this.getRealRowIndex(Convert.o2x(row));
                } else {
                    throw new MidasException("updateRow(..) called, but no primary key specified and no ROW= in " + data);
                }
            }
        }
        return rowNum;
    }

    private Table mergeData(long rowNum, Table data) {
        Table tab;
        if (this.listFile == null || data == null) {
            tab = null;
        } else if (rowNum < 0L || rowNum > this.getNumberOfRows()) {
            tab = data;
        } else {
            boolean update = false;
            Table oldRow = this.listFile.getDataTable(rowNum);
            if (oldRow == null) {
                return data;
            }
            for (String key : oldRow.getKeys()) {
                Object newVal = data.getO(key);
                if (newVal == null) continue;
                update = update || !Util.equals(newVal, oldRow.getO(key));
                oldRow.put(key, newVal);
            }
            tab = update ? oldRow : null;
        }
        return tab;
    }

    @Override
    public void setPrimaryKey(String key) {
        this.primaryKey = key == null ? null : key.toUpperCase();
        this.priKeyCache = key == null ? null : new Cache(32);
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Table getAllSelectedCells() {
        Table selCells = new Table();
        Table inner = new Table();
        LargeJTable.RowSelection[] rowSel = this.getTableSelectionModel().getCurrentSelection();
        if (rowSel.length == 0) {
            return selCells;
        }
        long rowStart = rowSel[0].getIndex();
        long rowEnd = rowSel[rowSel.length - 1].getIndex();
        int cols = this.getColumnCount();
        for (long row = rowStart; row <= rowEnd; ++row) {
            for (long col = 0L; col <= (long)cols; ++col) {
                Object value;
                long rowIndex;
                long rowNum;
                if (this.getTableSelectionModel().isRowSelected(row)) {
                    rowNum = this.getSortingModel().toReal(row);
                    rowIndex = row < 0L ? -1L : this.getMacroRowIndex(rowNum);
                    value = this.getRow(rowIndex);
                    selCells.put(Long.toString(rowIndex), value);
                    continue;
                }
                if (!this.getTableSelectionModel().isCellSelected(row, col)) continue;
                rowNum = this.getSortingModel().toReal(row);
                rowIndex = row < 0L ? -1L : this.getMacroRowIndex(rowNum);
                String colName = this.getColID(col);
                value = this.getRow(rowIndex).get(colName);
                inner.put(colName, value);
                selCells.put(Long.toString(rowIndex), (Object)inner);
                inner = new Table();
            }
        }
        return selCells;
    }

    @Override
    public Table getAllSelectedRows() {
        LargeJTable.RowSelection[] rowSel = this.getTableSelectionModel().getCurrentSelection();
        Table tbl = new Table();
        for (LargeJTable.RowSelection aRowSel : rowSel) {
            long row = this.getMacroRowIndex(this.getSortingModel().toReal(aRowSel.getIndex()));
            Table value = this.getRow(row);
            tbl.setKey(Long.toString(row), value);
        }
        return tbl;
    }

    @Override
    public int getModelRowIndex(int viewIndex) {
        return (int)this.getSortingModel().toReal(viewIndex);
    }

    @Override
    public int getViewRowIndex(int modelIndex) {
        return (int)this.getSortingModel().toView(modelIndex);
    }

    @Override
    public long getRealRowIndex(int modelIndex) {
        return super.getRealRowIndex(modelIndex);
    }

    @Override
    public int getModelRowIndex(long realIndex) {
        return super.getModelRowIndex(realIndex);
    }

    @Override
    public int getModelColIndex(int viewIndex) {
        return super.getModelColIndex(viewIndex);
    }

    @Override
    public long getRealColIndex(int modelIndex) {
        return super.getRealColIndex(modelIndex);
    }

    @Override
    public int getModelColIndex(long realIndex) {
        return super.getModelColIndex(realIndex);
    }

    @Override
    public int getViewColIndex(int viewIndex) {
        return super.getViewColIndex(viewIndex);
    }

    @Override
    public long getMacroRowIndex(long fileIndex) {
        return fileIndex + this.rowOffset;
    }

    @Override
    public long getRealRowIndex(long macroIndex) {
        return macroIndex - this.rowOffset;
    }

    @Override
    public long getMacroColIndex(long fileIndex) {
        return fileIndex + this.colOffset;
    }

    @Override
    public long getRealColIndex(long macroIndex) {
        return macroIndex - this.colOffset;
    }

    long getMacroColIndex(String colName) {
        long index = this.getColumnIndex(colName);
        return index == -1L ? -1L : this.getMacroColIndex(index);
    }

    @Override
    public void showCell(long row, long column) {
        super.showCell(this.getRealRowIndex(row), column);
    }

    @Override
    protected String getRowID(long row) {
        String id = null;
        id = row < 0L ? super.getRowID(row) : String.valueOf(this.getMacroRowIndex(this.getSortingModel().toReal(row)));
        return id;
    }

    @Override
    long getColumnIndex(String col) {
        int index = -1;
        if (col != null && this.listFile != null) {
            col = col.toUpperCase();
            for (int i = 0; i < this.columnNames.length; ++i) {
                if (!col.equals(this.columnNames[i])) continue;
                index = i;
                break;
            }
            if (index < 0) {
                int val;
                String num = col;
                if (col.startsWith("_") && col.endsWith("_")) {
                    num = col.substring(1, col.length() - 1);
                }
                if (StringUtil.isNumber(num) && (val = Convert.o2l(num)) >= 0 && val < this.columnNames.length) {
                    index = val;
                }
            }
        }
        return index;
    }

    public boolean isGridVisible() {
        return this.getShowHorizontalLines() && this.getShowVerticalLines();
    }

    public boolean getRowLabelsVisible() {
        return this.getRowHeader().isVisible();
    }

    public boolean getColLabelsVisible() {
        return this.getTableHeader().isVisible();
    }

    public void setGridVisible(boolean showGrid) {
        this.setShowGrid(showGrid);
    }

    public void setCellForeground(int row, int col, Color color) {
        Shell.warning("setCellForeground(..)  Fix This >>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
    }

    @Override
    public final void selectRow(long row) throws IllegalArgumentException {
        this.selectRow(row, true);
    }

    @Override
    public void selectRow(long row, boolean clearCurrentSelection) throws IllegalArgumentException {
        this.checkRowNumber(row);
        long rownum = this.getRealRowIndex(row);
        if (clearCurrentSelection) {
            this.getTableSelectionModel().clearSelection(true);
        }
        this.getTableSelectionModel().changeRowSelection(rownum, rownum, -2, false);
    }

    @Override
    public void selectRow(long row, String flags) throws IllegalArgumentException {
        boolean clear;
        if (flags.equalsIgnoreCase("true")) {
            this.selectRow(row, true);
            return;
        }
        if (flags.equalsIgnoreCase("false")) {
            this.selectRow(row, false);
            return;
        }
        this.checkRowNumber(row);
        long rownum = this.getRealRowIndex(row);
        int sel = Parser.mask("MSG,CLEAR,IGNORECASE", flags, 0);
        boolean msg = (sel & 1) != 0;
        boolean bl = clear = (sel & 2) != 0;
        if (clear) {
            this.getTableSelectionModel().clearSelection(msg);
        }
        this.getTableSelectionModel().changeRowSelection(rownum, rownum, -2, msg);
    }

    @Override
    public void selectRow(String column, String value, boolean ignoreCase) {
        String flags = ignoreCase ? "-CLEAR|+IGNORECASE" : "-CLEAR|-IGNORECASE";
        this.selectRowByColVal(column, value, flags);
    }

    @Override
    public void selectRowByColVal(String column, String value, String flags) {
        if (flags.equalsIgnoreCase("true")) {
            flags = "-CLEAR|+MSG|+IGNORECASE";
        } else if (flags.equalsIgnoreCase("false")) {
            flags = "-CLEAR|+MSG|-IGNORECASE";
        }
        if (flags == null || flags.equals("")) {
            flags = "MSG,CLEAR,IGNORECASE";
        }
        if (this.listFile != null) {
            boolean ignoreCase;
            long colNo = this.getColumnIndex(column);
            int sel = Parser.mask("MSG,CLEAR,IGNORECASE", flags, 0);
            boolean msg = (sel & 1) != 0;
            boolean clear = (sel & 2) != 0;
            boolean bl = ignoreCase = (sel & 4) != 0;
            if (clear) {
                this.getTableSelectionModel().clearSelection(msg);
            }
            long row = 0L;
            while ((double)row < this.listFile.getNumberOfRows()) {
                boolean sorted = this.getSortingModel().isSorting();
                Object data = null;
                data = sorted ? this.getSortingModel().getValueAt(row, colNo) : this.listFile.getDataTable(row).getKey(column);
                boolean found = false;
                found = ignoreCase ? data != null && value.equalsIgnoreCase(data.toString()) : value.equals(data);
                if (found) {
                    this.getTableSelectionModel().changeRowSelection(row, row, -2, msg);
                }
                ++row;
            }
        }
    }

    private void checkRowNumber(long row) {
        if (row < 0L) {
            throw new IllegalArgumentException("Row numbers must be at least 0");
        }
    }

    void showErrorMsg(String msg) {
        if (this.msgListener != null) {
            this.msgListener.showErrorMsg(msg);
        } else if (this.isVisible()) {
            this.midas.warning("MJList: " + msg);
            JOptionPane.showMessageDialog(this, "ERROR: " + msg, "MJList", 0);
        } else {
            this.midas.warning("MJList: " + msg);
        }
    }

    void showWarningMsg(String msg) {
        if (this.msgListener != null) {
            this.msgListener.showWarningMsg(msg);
        } else if (this.isVisible()) {
            this.midas.warning("MJList:" + msg);
            JOptionPane.showMessageDialog(this, "WARNING: " + msg, "MJList", 2);
        } else {
            this.midas.warning("MJList: " + msg);
        }
    }

    void showDeprecatedMsg(String msg) {
        if (this.msgListener != null) {
            this.msgListener.showDeprecatedMsg(msg);
        } else {
            this.midas.deprecate("MJList: " + msg);
        }
    }

    @Override
    public JScrollPane getScrollPane() {
        Container parent = this.getParent();
        if (parent != null && parent instanceof JViewport && (parent = parent.getParent()) != null && parent instanceof JScrollPane) {
            return (JScrollPane)parent;
        }
        return null;
    }

    private int getDefaultColWidth(String colName, String fmt, Format format, String label) {
        if (label == null) {
            label = colName;
        }
        int charWidth = 0;
        int rowsToCheck = (int)Math.min(this.listFile.getNumberOfRows(), (double)this.getNumberOfVisibleRows() * 2.0);
        if (rowsToCheck > 0) {
            for (int i = 0; i < rowsToCheck; ++i) {
                String str;
                Object val = this.listFile.getDataTable(i).get(colName);
                String string = str = format != null ? format.format(val) : val.toString();
                if (str.equals("()")) {
                    str = val.toString();
                }
                charWidth = Math.max(charWidth, str.length());
            }
            charWidth = Math.max(charWidth, 4);
        } else if (fmt == null) {
            charWidth = 20;
        } else if (Data.isString((byte)fmt.charAt(1))) {
            charWidth = Data.getBPA(fmt);
        } else {
            int scalarWidth;
            int spa = Data.getSPA(fmt.charAt(0));
            switch (fmt.charAt(1)) {
                case 'D': {
                    scalarWidth = 14;
                    break;
                }
                case 'F': {
                    scalarWidth = 14;
                    break;
                }
                case 'X': {
                    scalarWidth = 8;
                    break;
                }
                case 'L': {
                    scalarWidth = 6;
                    break;
                }
                case 'I': {
                    scalarWidth = 4;
                    break;
                }
                case 'J': {
                    scalarWidth = 4;
                    break;
                }
                case 'B': {
                    scalarWidth = 3;
                    break;
                }
                default: {
                    scalarWidth = 8;
                }
            }
            charWidth = (scalarWidth + 2) * spa - 2;
        }
        return Math.max(charWidth, label.length());
    }

    private static String getDefaultFormat(String type, String fmt) {
        for (int i = 0; i < DEFAULT_FORMATS.length; i += 2) {
            if (!type.equals(DEFAULT_FORMATS[i])) continue;
            return DEFAULT_FORMATS[i + 1];
        }
        return null;
    }

    private static String getDefaultType(String fmt, String numForm, Table enumTbl) {
        if (numForm != null) {
            return "NUMBER";
        }
        if (enumTbl != null) {
            return "ENUM";
        }
        if (fmt == null) {
            return "STRING";
        }
        if (fmt.equals("SZ")) {
            return "TOGGLE";
        }
        if (Data.isString((byte)fmt.charAt(1))) {
            return "STRING";
        }
        if (fmt.charAt(1) == 'Z') {
            return "STRING";
        }
        return "NUMBER";
    }

    private static String getDefaultAlignment(String fmt) {
        if (fmt == null) {
            return "LEFT";
        }
        if (Data.isString((byte)fmt.charAt(1))) {
            return "LEFT";
        }
        if (fmt.charAt(0) == 'S') {
            return "RIGHT";
        }
        if (fmt.charAt(0) == '1') {
            return "RIGHT";
        }
        return "CENTER";
    }

    private Table getDefaultColumnTemplate(int col) {
        Table template = new Table();
        if (this.listFile != null) {
            String name = this.columnNames[col];
            String fmt = this.columnFormats[col];
            String type = MJList.getDefaultType(fmt, null, null);
            String format = MJList.getDefaultFormat(type, fmt);
            MFormat mfmt = this.getDefaultMFormat(type, format, fmt);
            int width = this.getDefaultColWidth(name, fmt, mfmt, null);
            String align = MJList.getDefaultAlignment(fmt);
            if (width > 0) {
                template.put("WIDTH", width);
            }
            if (align != null) {
                template.put("ALIGN", (Object)align);
            }
            if (type != null) {
                template.put("TYPE", (Object)type);
            }
            if (format != null) {
                template.put("FORMAT", (Object)format);
            }
        }
        return template;
    }

    private MFormat getDefaultMFormat(String type, String format, String fmt) {
        MFormat mfmt = null;
        if (type.equals("STRING")) {
            mfmt = MFormat.getStringFormat();
        } else if (type.equals("NUMBER")) {
            mfmt = MFormat.getNumberFormatFor(format, fmt, true);
        } else if (type.equals("DATE")) {
            mfmt = MFormat.getDateFormatFor(format);
        } else if (type.equals("ANGLE")) {
            mfmt = MFormat.getAngleFormatFor(format);
        }
        return mfmt;
    }

    private void addColumn(int col) {
        NmTableCellRenderer tcr = new NmTableCellRenderer();
        DefaultCellEditor tce = new DefaultCellEditor(new JTextField());
        int width = 8 * this.getTextWidth();
        this.addColumn(new TableColumn(col, width, tcr, tce));
    }

    private void removeAllColumns() {
        ((NmColumnModel)this.getColumnModel()).removeAllColumns();
    }

    private void doApplyTemplate(Table template, boolean override, boolean update) {
        if (this.savedTemplate == null || override) {
            this.savedTemplate = template != null ? template.copy() : new Table();
        } else {
            String[] keys;
            for (String key : keys = template.getKeys()) {
                Table oldEntry = this.savedTemplate.getTable(key);
                Table newEntry = template.getTable(key).copy();
                if (oldEntry == null) {
                    oldEntry = new Table();
                    this.savedTemplate.put(key, (Object)oldEntry);
                }
                oldEntry.merge(newEntry);
            }
        }
        if (override) {
            this.mcolorTbl.clear();
            this.removeAllColumns();
        }
        if (this.listFile != null) {
            Table globalTempl = this.getPutT(this.savedTemplate, "_GLOBAL_", "{TYPE=LIST2,AUTOHIDE=TRUE,AUTOORDER=TRUE}");
            String type = this.getPutS(globalTempl, "TYPE", "LIST2");
            int templCols = this.savedTemplate.size() - 1;
            if (type.equals("LIST2")) {
                this.applyGlobalTemplate(globalTempl, override);
            } else if (type.equals("XDATALIST")) {
                this.applyXmGlobalTemplate(globalTempl, override);
            } else {
                this.showErrorMsg("Invalid template type '" + type + "'.");
            }
            boolean ahide = this.autoHide && templCols != 0;
            boolean aorder = this.autoOrder && templCols != 0 && override && template != null && !update;
            for (int col = 0; col < this.columnNames.length; ++col) {
                String colName = this.columnNames[col];
                String colNum = "_" + col + "_";
                Table templ = null;
                if (templ == null) {
                    templ = this.savedTemplate.getTable(colName);
                }
                if (templ == null) {
                    templ = this.savedTemplate.getTable(colNum);
                }
                if (!ahide && templ == null) {
                    templ = this.getPutT(this.savedTemplate, colName, this.getDefaultColumnTemplate(col));
                }
                if (templ == null) continue;
                if (override) {
                    this.addColumn(col);
                }
                if (type.equals("LIST2")) {
                    this.applyColumnTemplate(col, templ, override, ahide);
                    continue;
                }
                if (type.equals("XDATALIST")) {
                    this.applyXmColumnTemplate(col, templ, override, ahide);
                    continue;
                }
                this.showWarningMsg("Unknown template TYPE='" + type + "', attempting to use it as TYPE=LIST2.");
                this.applyColumnTemplate(col, templ, override, ahide);
            }
            if (aorder) {
                String[] colNames = this.savedTemplate.getKeys();
                NmColumnModel colModel = (NmColumnModel)this.getColumnModel();
                int i = 0;
                int col = 0;
                while (i < colNames.length) {
                    int index = colModel.findColumnIndex(colNames[i]);
                    if (index >= 0) {
                        this.moveColumn(index, col);
                    } else {
                        --col;
                    }
                    ++i;
                    ++col;
                }
            }
            this.resizeAndRepaint();
        }
    }

    private String getPutS(Table tbl, String key, String def) {
        String val = def;
        if (tbl != null && (val = tbl.getS(key, def)) == null && def != null) {
            val = def;
            tbl.put(key, (Object)def);
        }
        return val;
    }

    private Table getPutT(Table tbl, String key, String def) {
        return this.getPutT(tbl, key, new Table(def));
    }

    private Table getPutT(Table tbl, String key, Table def) {
        Table val = def;
        if (tbl != null && (val = tbl.getTable(key)) == null && def != null) {
            val = def;
            tbl.put(key, (Object)def);
        }
        return val;
    }

    private void applyXmGlobalTemplate(Table template, boolean override) {
        Table tbl = template.copy();
        tbl.setKey("TYPE", "LIST2");
        String indexStr = tbl.getS("INDEX", "RIGHT").toUpperCase();
        boolean rows = indexStr.equals("RIGHT") || indexStr.equals("LEFT");
        boolean cols = tbl.getState("LABELS", true);
        if (rows && cols) {
            tbl.setKey("LABELS", "BOTH");
        } else if (rows) {
            tbl.setKey("LABELS", "ROW");
        } else if (cols) {
            tbl.setKey("LABELS", "COL");
        } else {
            tbl.setKey("LABELS", "NONE");
        }
        if (template.containsKey("INDEX")) {
            tbl.remove("INDEX");
        }
        if (tbl.containsKey("COLOR")) {
            tbl.setKey("FGCOLOR", this.convertColor(tbl.getS("COLOR")));
            tbl.remove("COLOR");
        }
        this.applyGlobalTemplate(tbl, override);
    }

    private void applyXmColumnTemplate(int column, Table template, boolean override, boolean autoHide) {
        String format;
        Table tbl = new Table(template.toString());
        if (tbl.containsKey("COLOR")) {
            tbl.setKey("FGCOLOR", this.convertColor(tbl.getS("COLOR")));
            tbl.remove("COLOR");
        }
        if (tbl.containsKey("COLUMNTYPE")) {
            String type = tbl.getS("COLUMNTYPE");
            tbl.setKey("TYPE", type);
            tbl.remove("COLUMNTYPE");
            if (type.equals("TIME")) {
                String timeFormat = tbl.getS("TIMEFMT", "STD");
                if (StringUtil.isNumber(timeFormat)) {
                    timeFormat = Parser.get("Std,Acq,Epoch,Norad,TCR,Vax,Filename,HMS,YMD,ISO8601,Full_Std,AcqDate,AcqTime", Convert.o2l(timeFormat));
                }
                tbl.setKey("TYPE", "NUMBER");
                tbl.setKey("FORMAT", timeFormat);
                tbl.remove("TIMEFMT");
            }
        } else if (tbl.containsKey("DISPFORM")) {
            tbl.setKey("TYPE", "NUMBER");
            tbl.setKey("FORMAT", tbl.getS("DISPFORM"));
            tbl.remove("DISPFORM");
        } else if (tbl.containsKey("TIMEFMT")) {
            tbl.setKey("TYPE", "NUMBER");
            tbl.setKey("FORMAT", tbl.getS("TIMEFMT", "STD"));
            tbl.remove("TIMEFMT");
        }
        if (tbl.containsKey("MENU")) {
            String menu = tbl.getS("MENU");
            Table enumTable = new Table();
            int enumCount = new Parser(menu).elements();
            String colors = tbl.getS("MCOLORS", null);
            String values = tbl.getS("MVALUES", null);
            tbl.remove("MENU");
            tbl.remove("MVALUES");
            for (int i = 1; i <= enumCount; ++i) {
                String name = "E" + i;
                enumTable.addTable(name);
                if (menu != null) {
                    enumTable.put(name + ".LABEL", (Object)Parser.get(menu, i));
                }
                if (colors != null) {
                    enumTable.put(name + ".COLOR", (Object)Parser.get(colors, i));
                }
                if (values == null) continue;
                enumTable.put(name + ".VALUE", (Object)Parser.get(values, i));
            }
            tbl.setKey("TYPE", "ENUM");
            tbl.setKey("ENUM", enumTable);
        }
        if (tbl.getS("TYPE", "").equals("NUMBER") && (format = tbl.getS("FORMAT", "")).startsWith("(") && format.endsWith(")")) {
            tbl.setKey("FORMAT", MFormat.convertFortranPattern(format));
        }
        this.applyColumnTemplate(column, tbl, override, autoHide);
    }

    private String convertColor(String color) {
        if (StringUtil.isNumber(color)) {
            color = MColor.toString(MColor.getColorByIndex(Convert.o2l(color)));
        }
        return color;
    }

    private void applyGlobalTemplate(Table template, boolean override) {
        String labels = template.getS("LABELS");
        String grid = template.getS("GRID");
        String fgColor = template.getS("FGCOLOR");
        String bgColor = template.getS("BGCOLOR");
        String colorMap = template.getS("COLORMAP");
        int numColors = -1;
        String shadeColor = template.getS("SHADECOLOR");
        String allowSort = template.getS("SORTENABLED");
        String sort2 = template.getS("SORT");
        String colDrag = template.getS("COLDRAG");
        String autoHide = template.getS("AUTOHIDE");
        String autoOrder = template.getS("AUTOORDER");
        int shadeInt = template.getL("SHADEINT", -1);
        float fontSize = template.getF("FONTSIZE", -1.0f);
        String fontStyle = template.getS("FONTSTYLE", null);
        String rowHtStr = template.getS("ROWHEIGHT", null);
        String adjSelCellsStr = template.getS("ADJSELCELLS", "OFF");
        int rowHeight = -1;
        if (override) {
            if (labels == null) {
                labels = "BOTH";
            }
            if (grid == null) {
                grid = "TRUE";
            }
            if (fgColor == null) {
                fgColor = this.defFgColor;
            }
            if (bgColor == null) {
                bgColor = this.defBgColor;
            }
            if (allowSort == null) {
                allowSort = "TRUE";
            }
            if (sort2 == null) {
                sort2 = "";
            }
            if (colDrag == null) {
                colDrag = "TRUE";
            }
            if (autoHide == null) {
                autoHide = "TRUE";
            }
            if (autoOrder == null) {
                autoOrder = "TRUE";
            }
            if (shadeColor == null) {
                shadeColor = this.defBgColor;
            }
            if (rowHtStr == null) {
                rowHtStr = "-1";
            }
        }
        if (rowHtStr != null && (rowHeight = Convert.s2l(rowHtStr)) != -1 && rowHeight < 0) {
            this.showWarningMsg("Invalid global template entry, ROWHEIGHT must be\ngreater than 0, ROWHEIGHT=-1 to use default height.");
            rowHtStr = FORCE_UPDATE;
            rowHeight = -1;
        }
        if (allowSort == null && sort2 != null) {
            allowSort = "TRUE";
        }
        if (labels != null) {
            if ((labels = labels.toUpperCase()).equals("ROW")) {
                this.setRowLabelsVisible(true);
                this.setColLabelsVisible(false);
            } else if (labels.equals("COL")) {
                this.setRowLabelsVisible(false);
                this.setColLabelsVisible(true);
            } else if (labels.equals("BOTH")) {
                this.setRowLabelsVisible(true);
                this.setColLabelsVisible(true);
            } else if (labels.equals("NONE")) {
                this.setRowLabelsVisible(false);
                this.setColLabelsVisible(false);
            } else {
                this.showWarningMsg("Invalid global template entry 'LABELS=" + labels + "'.\nPossible values for LABELS are 'ROW', 'COL', 'BOTH' or 'NONE'.");
            }
        }
        if (allowSort != null) {
            this.setSortingEnabled(StringUtil.isTrue(allowSort));
        }
        if (grid != null) {
            this.setGridVisible(StringUtil.isTrue(grid));
        }
        if (sort2 != null) {
            this.setSort(sort2);
        }
        if (fgColor != null) {
            this.globalFgColor = fgColor;
        }
        if (bgColor != null) {
            this.globalBgColor = bgColor;
        }
        if (rowHtStr != null) {
            this.globalRowHeight = rowHeight;
        }
        if (colDrag != null) {
            this.colDrag = StringUtil.isTrue(colDrag);
        }
        if (autoHide != null) {
            this.autoHide = StringUtil.isTrue(autoHide);
        }
        if (autoOrder != null) {
            this.autoOrder = StringUtil.isTrue(autoOrder);
        }
        if (shadeColor != null) {
            this.shadeColor = MColor.getColor(shadeColor);
        }
        boolean bl = this.adjSelCells = adjSelCellsStr.equalsIgnoreCase("ON");
        if (shadeInt >= 0) {
            if (shadeInt == 0 || shadeInt > 1) {
                this.shadeInterval = shadeInt;
            } else {
                this.showWarningMsg("Invalid global template entry, SHADEINT must be\nat least 2 use SHADEINT=0 to turn shading off.");
            }
        }
        if (fontSize > 0.0f) {
            Font newFont = this.getFont().deriveFont(fontSize);
            int oldHeight = this.getFontMetrics(this.getFont()).getHeight();
            int newHeight = this.getFontMetrics(newFont).getHeight();
            this.defRowHeight = this.defRowHeight - oldHeight + newHeight;
            rowHtStr = FORCE_UPDATE;
            this.setFont(newFont);
        }
        if (fontStyle != null) {
            int oldMask = this.getFont().getStyle();
            int newMask = Parser.mask("Bold,Italic", fontStyle, oldMask);
            Font newFont = this.getFont().deriveFont(newMask);
            this.setFont(newFont);
        }
        if (rowHtStr != null) {
            if (rowHeight == -1) {
                rowHeight = this.defRowHeight;
            }
            this.setRowHeight(rowHeight);
        }
        this.setColorMap("_GLOBAL_", colorMap, numColors);
    }

    private void applyColumnTemplate(int column, Table template, boolean override, boolean autoHide) {
        String colName = this.columnNames[column];
        String colFormat = this.columnFormats[column];
        String label = template.getS("LABEL");
        int width = template.getL("WIDTH", -1);
        String fgColor = template.getS("FGCOLOR", this.globalFgColor);
        String bgColor = template.getS("BGCOLOR", this.globalBgColor);
        String colorMap = template.getS("COLORMAP");
        int numColors = -1;
        String renderer = template.getS("RENDERER");
        Table renderOpts = template.getTable("RENDEROPTS");
        Table enumTbl = template.getTable("ENUM");
        String defFormat = template.getS("FORMAT", null);
        String defType = template.getS("TYPE", null);
        String timeZone = template.getS("TIMEZONE", "UTC");
        String type = this.getPutS(template, "TYPE", MJList.getDefaultType(colFormat, defFormat, enumTbl));
        String format = this.getPutS(template, "FORMAT", MJList.getDefaultFormat(type, colFormat));
        String align = this.getPutS(template, "ALIGN", MJList.getDefaultAlignment(colFormat));
        String mcolors = template.getS("MCOLORS");
        boolean hide = template.getState("HIDE", false);
        NmColumnModel colModel = (NmColumnModel)this.getColumnModel();
        TableColumn tableColumn = colModel.findColumn(column);
        if (tableColumn == null) {
            return;
        }
        TableCellRenderer cellRenderer = tableColumn.getCellRenderer();
        MFormat mformat = null;
        if (renderer != null && renderer.length() == 0) {
            renderer = null;
        }
        if (renderer != null) {
            cellRenderer = this.createRenderer(renderer, renderOpts);
        } else if (type != null) {
            if ((type = type.toUpperCase()).equals("STRING")) {
                mformat = MFormat.getStringFormat();
            } else if (type.equals("NUMBER")) {
                mformat = MFormat.getNumberFormatFor(format, colFormat, true);
            } else if (type.equals("DATE")) {
                mformat = MFormat.getDateFormatFor(format, timeZone);
            } else if (type.equals("ANGLE")) {
                mformat = MFormat.getAngleFormatFor(format);
            } else if (type.equals("TOGGLE")) {
                cellRenderer = new NmCheckboxRenderer();
            } else if (type.equals("ENUM")) {
                if (enumTbl != null) {
                    mformat = MFormat.getEnumFormat(enumTbl);
                } else {
                    this.showWarningMsg("Invalid column template entry for column " + colName + ", given 'TYPE=" + type + "'\nbut no ENUM table was found.");
                }
            } else {
                this.showWarningMsg("Invalid column template entry for column " + colName + " 'TYPE=" + type + "'.");
            }
        }
        if (mformat != null && renderer == null) {
            if (cellRenderer instanceof NmTableCellRenderer) {
                ((NmTableCellRenderer)cellRenderer).setFormat(mformat);
            } else {
                cellRenderer = new NmTableCellRenderer(mformat);
            }
        } else if (cellRenderer == null) {
            cellRenderer = new NmTableCellRenderer();
        }
        int prefWidth = width;
        int defWidth = width;
        if (width < 0) {
            prefWidth = colModel.findColumn(column).getPreferredWidth() / this.getTextWidth() - 2;
            defWidth = this.getDefaultColWidth(colName, format, mformat, label);
        }
        int pixWidth = (Math.max(defWidth, prefWidth) + 2) * this.getTextWidth();
        tableColumn.setPreferredWidth(pixWidth);
        if (label != null) {
            tableColumn.setHeaderValue(label);
        }
        this.setColorMap(colName, colorMap, numColors);
        if (mcolors != null) {
            Parser parser = new Parser(mcolors);
            Color[] colors = new Color[parser.elements() + 1];
            colors[0] = null;
            for (int i = 1; i < colors.length; ++i) {
                colors[i] = MColor.getColor(parser.get(i));
            }
            this.mcolorTbl.put(colName, (Object)colors);
        }
        if (cellRenderer instanceof Component) {
            Component comp = (Component)((Object)cellRenderer);
            this.setColumnColor(comp, fgColor, false);
            this.setColumnColor(comp, bgColor, true);
            if (align != null && comp instanceof JLabel) {
                JLabel jlabel = (JLabel)comp;
                String algn = align.toUpperCase();
                if (algn.equals("LEFT")) {
                    jlabel.setHorizontalAlignment(2);
                } else if (algn.equals("RIGHT")) {
                    jlabel.setHorizontalAlignment(4);
                } else if (algn.equals("CENTER")) {
                    jlabel.setHorizontalAlignment(0);
                } else {
                    this.showWarningMsg("Invalid column template entry 'ALIGN=" + align + "' for column " + colName + ".\nPossible values for ALIGN are 'LEFT,RIGHT,CENTER'.");
                }
            }
        }
        tableColumn.setCellRenderer(cellRenderer);
        colModel.setColumnVisible(column, !hide);
    }

    private TableCellRenderer createRenderer(String className, Table options) {
        TableCellRenderer cellRenderer = null;
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?>[] consts = clazz.getConstructors();
            Constructor<?> constMidas = null;
            Constructor<?> constEmpty = null;
            for (Constructor<?> constructor : consts) {
                Class<?>[] types = constructor.getParameterTypes();
                if (types.length == 0) {
                    constEmpty = constructor;
                    continue;
                }
                if (types.length != 1 || !types[0].equals(Midas.class)) continue;
                constMidas = constructor;
            }
            if (constMidas != null) {
                cellRenderer = (TableCellRenderer)constMidas.newInstance(this.midas);
            } else if (constEmpty != null) {
                cellRenderer = (TableCellRenderer)constEmpty.newInstance(null);
            } else {
                this.midas.warning("MJList: could not find constructor " + className + "() or " + className + "(Midas).");
                cellRenderer = null;
            }
        }
        catch (Exception e) {
            this.midas.printStackTrace("MJList: Error instantiating cell renderer " + className, e);
            cellRenderer = null;
        }
        if (cellRenderer != null) {
            KeyObject.setKeys(cellRenderer, options, this.midas, 5);
        }
        return cellRenderer;
    }

    private void setColumnColor(Component comp, String color, boolean background) {
        if (color == null) {
            return;
        }
        NmTableCellRenderer renderer = null;
        String overrideCol = null;
        if (comp instanceof NmTableCellRenderer) {
            renderer = (NmTableCellRenderer)comp;
        }
        if (color.startsWith("FIELD_")) {
            overrideCol = color.substring(6);
        } else if (color.startsWith("FIELD")) {
            int colNum = Convert.o2l(color.substring(5));
            overrideCol = this.columnNames[colNum - 1];
        }
        if (overrideCol == null) {
            if (background) {
                comp.setBackground(this.getColor(color, null));
            } else {
                comp.setForeground(this.getColor(color, null));
            }
        } else if (renderer != null) {
            if (background) {
                renderer.setBgOverrideCol(overrideCol);
            } else {
                renderer.setFgOverrideCol(overrideCol);
            }
        } else {
            this.showWarningMsg("Can not set color to " + color + " renderer does not extend NmTableCellRenderer.");
        }
    }

    private void setColorMap(String col, String colorMap, int numColors) {
        if (colorMap != null && colorMap.length() > 0) {
            if (colorMap.equalsIgnoreCase("DEFAULT")) {
                if (this.mcolorTbl.containsKey(col)) {
                    this.mcolorTbl.remove(col);
                }
            } else if (colorMap.startsWith("{")) {
                String[] keys;
                Table tbl = Convert.o2t(colorMap);
                Table eqs = new Table();
                for (String key : keys = tbl.getKeys()) {
                    String val = tbl.getS(key);
                    Object value = null;
                    value = val.startsWith("FIELD_") ? val : MColor.getColor(val);
                    if (key.startsWith("TEST(")) {
                        tbl.remove(key);
                        eqs.put(key, value);
                        continue;
                    }
                    tbl.put(key, value);
                }
                if (eqs.size() > 0) {
                    tbl.put("_EQUATIONSET_", (Object)new EquationSet(eqs));
                }
                this.mcolorTbl.put(col, (Object)tbl);
            } else {
                this.mcolorTbl.put(col, (Object)MColor.getColorMap(colorMap, numColors));
            }
        }
    }

    private static Color getColorInColormap(Object cmap, String value) {
        Color color = null;
        if (cmap != null) {
            if (cmap instanceof Color[] && StringUtil.isNumber(value)) {
                Color[] map = (Color[])cmap;
                int index = Math.abs(Convert.s2l(value));
                color = map[index % (map.length - 1) + 1];
            } else if (cmap instanceof Table) {
                Table tbl = (Table)cmap;
                Object clr = tbl.get(value);
                if (clr instanceof Color) {
                    color = (Color)clr;
                } else if (clr != null) {
                    color = MColor.getColor(clr.toString());
                    tbl.put(value, (Object)color);
                }
            } else {
                Shell.warning("MJList: Internal Error: Unknown colormap type: " + cmap.getClass());
            }
        }
        return color;
    }

    private Color getColor(int row, String col) {
        long column = this.getColumnIndex(col);
        Color color = null;
        String val = null;
        if (row >= 0 && (long)row < this.getNumberOfRows()) {
            if (column >= 0L) {
                long rowNum = this.getRealRowIndex(row);
                Object obj = this.getLargeTableModel().getValueAt(rowNum, column);
                val = Convert.o2s(obj);
            } else {
                Shell.warning("Column name " + col + " not found in MJList with column names " + Arrays.toString(this.getColumnNames()) + "\n      Using direct calls to openFile(), rather than the OPENFILE message, can create a timing conflict with the AWT thread and trigger this warning.");
            }
        } else {
            Shell.warning("Invalid row number, row=" + row);
        }
        if (val != null) {
            Object mc = this.mcolorTbl.get(col);
            if (mc == null) {
                mc = this.mcolorTbl.get("_GLOBAL_");
            }
            if (mc != null) {
                if (mc instanceof Table) {
                    Table ctbl = (Table)mc;
                    Object clr = null;
                    EquationSet eqSet = (EquationSet)ctbl.get("_EQUATIONSET_");
                    if (eqSet != null) {
                        clr = eqSet.test(val);
                    }
                    if (clr == null) {
                        clr = ctbl.getO(val);
                    }
                    if (clr == null) {
                        clr = ctbl.getO("_DEFAULT_");
                    }
                    if (clr instanceof Color || clr == null) {
                        color = (Color)clr;
                    } else if (clr.toString().startsWith("FIELD_")) {
                        color = this.getColor(row, clr.toString().substring(6));
                    }
                } else if (StringUtil.isNumber(val) && mc instanceof Color[]) {
                    Color[] cmap = (Color[])mc;
                    int index = Math.min(cmap.length - 1, Math.max(0, Convert.s2l(val)));
                    color = cmap[index];
                }
            } else {
                color = StringUtil.isNumber(val) && !val.startsWith("#") && !val.startsWith("0x") ? this.getColor(val, null) : MColor.getColor(val);
            }
        }
        return color;
    }

    private Color getColor(String cname, String field) {
        Color color = null;
        if (StringUtil.isNumber(cname) && !cname.startsWith("#") && !StringUtil.isHexInteger(cname)) {
            Object cmap;
            int index = Convert.s2l(cname);
            Object object = cmap = field == null ? null : this.mcolorTbl.get(field);
            if (cmap == null) {
                cmap = this.mcolorTbl.get("_GLOBAL_");
            }
            color = cmap != null ? MJList.getColorInColormap(cmap, cname) : MColor.getColorByIndex(index);
        }
        if (color == null) {
            color = MColor.getColor(cname);
        }
        return color;
    }

    public Color getShadeColor(int row, Color color) {
        if (this.shadeInterval > 0 && this.shadeColor != null) {
            int index = this.getViewRowIndex(row);
            Color bgColor = this.getBackground();
            if (index % this.shadeInterval == this.shadeInterval - 1) {
                color = color == null || color.equals(bgColor) ? this.shadeColor : new Color(this.shadeColor.getRGB() ^ bgColor.getRGB() ^ color.getRGB());
            }
        }
        return color;
    }

    @Override
    public void setSort(String column) {
        this.getSortingModel().setSortingStatus(column);
    }

    public String getSort() {
        return this.getSortingModel().getSortingStatus();
    }

    @Override
    public void setSortingEnabled(boolean enabled) {
        this.getSortingModel().setSortingEnabled(enabled);
    }

    @Override
    public boolean getSortingEnabled() {
        return this.getSortingModel().getSortingEnabled();
    }

    public void setDragAndDropEnabled(boolean enabled) {
        if (this.dragDrop == enabled) {
            return;
        }
        this.dragDrop = enabled;
        if (this.dragDrop) {
            this.setTransferHandler(new ListTransferHandler());
            this.setDropMode(DropMode.INSERT_ROWS);
        }
        this.setDragEnabled(enabled);
    }

    public boolean isDragAndDropEnabled() {
        return this.dragDrop;
    }

    public class ListTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 2013022100330L;

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof MJList) {
                String ss = ((MJList)c).getAllSelectedRows().toString();
                return new StringSelection(ss);
            }
            return null;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return MJList.this.isDragAndDropEnabled();
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            if (comp instanceof MJList) {
                try {
                    Object tdata = t.getTransferData(DataFlavor.stringFlavor);
                    Message msg = new Message("DROPDATA", 0, tdata);
                    ((MJList)comp).getMessageHandler().processMessage(msg);
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }
    }

    private static final class PipedDataFile
    extends AbstractCachedDataFile
    implements PollsOwnData {
        private final int DEFAULT_MAX = 16;
        private final int UPPER_MAX = 128;
        private final LinkedList<Table> cache = new LinkedList();
        private double start = 0.0;
        private int maxSize = (int)Math.min(128.0, Math.max(2.0, this.dataFile.getSize()));

        public PipedDataFile(Midas midas, DataFile df, MJList table) {
            super(midas, df, table);
        }

        @Override
        public boolean getProtected() {
            return true;
        }

        @Override
        public double getNumberOfRows() {
            return this.cache.size();
        }

        @Override
        public Table getDataTable(double offset) {
            double index = offset;
            Table tbl = null;
            if (index >= 0.0 && index < (double)this.cache.size()) {
                tbl = this.cache.get((int)index);
            }
            return tbl;
        }

        @Override
        public int setData(double offset, Table table) {
            return 0;
        }

        @Override
        public void setData(double element, String fieldName, Object obj) {
        }

        @Override
        public void insertData(double offset, Object obj) {
        }

        @Override
        public void removeData(double offset, long count) {
        }

        @Override
        public void removeData(double offset) {
            this.removeData(offset, 1L);
        }

        @Override
        public double pollData(boolean poll) {
            int oldLength = this.cache.size();
            int maxViewable = this.table.getNumberOfVisibleRows();
            double avail = Math.min((double)(maxViewable / 2), Math.floor(this.dataFile.avail()));
            int i = 0;
            while ((double)i < avail) {
                Table tbl = this.dataFile.getDataTable(this.dataFile.seek());
                this.cache.addLast(tbl);
                while (this.cache.size() > this.maxSize) {
                    this.cache.removeFirst();
                    this.start += 1.0;
                }
                ++i;
            }
            if (avail > 0.0) {
                this.table.rowOffset = (long)this.start;
                this.table.getLargeTableModel().fireRowsInserted(-1L, -1L);
            }
            return avail;
        }
    }

    private static final class CachedDataFile
    extends AbstractCachedDataFile
    implements PollsOwnData {
        private Cache cache = new Cache(128);
        private double lastSize = 0.0;

        public CachedDataFile(Midas midas, DataFile df, MJList table) {
            super(midas, df, table);
        }

        @Override
        public Table getDataTable(double offset) {
            Table tbl = null;
            if (this.isOpen()) {
                String index = Double.toString(offset);
                tbl = (Table)this.cache.get(index);
                if (tbl == null) {
                    tbl = this.dataFile.getDataTable(offset);
                    this.cache.put(index, tbl);
                }
            } else {
                this.midas.warning("MJList: Can not read from file, file is not open.");
            }
            return tbl;
        }

        @Override
        public int setData(double offset, Table table) {
            if (this.isOpen()) {
                this.cache.remove(Double.toString(offset));
                return this.dataFile.setData(offset, table);
            }
            this.midas.warning("MJList: Can not write to file, file is not open.");
            return 0;
        }

        @Override
        public void setData(double element, String fieldName, Object obj) {
            if (this.isOpen()) {
                this.cache.remove(Double.toString(element));
                this.dataFile.setData(element, fieldName, obj);
            } else {
                this.midas.warning("MJList: Can not write to file, file is not open.");
            }
        }

        @Override
        public void insertData(double offset, Object obj) {
            if (this.isOpen()) {
                this.cache.clear();
                this.dataFile.insertData(offset, obj);
            } else {
                this.midas.warning("MJList: Can not insert data, file is not open.");
            }
        }

        @Override
        public void removeData(double offset) {
            this.removeData(offset, 1L);
        }

        @Override
        public final void removeData(double offset, long count) {
            if (count != 0L) {
                this.cache.clear();
                if (this.isOpen()) {
                    this.dataFile.removeData(offset, count);
                } else {
                    this.midas.warning("MJList: Can not remove data, file is not open.");
                    this.cache.clear();
                    this.recordDef = null;
                }
            }
        }

        @Override
        public double pollData(boolean poll) {
            boolean resetAll = false;
            if (poll) {
                boolean dfIsOpen = this.isOpen();
                try {
                    this.dataFile = this.dataFile.reOpen();
                }
                catch (Exception e) {
                    this.midas.printStackTrace("MJList: Error reopening " + this.dataFile.getName() + " during poll", e);
                }
                resetAll = dfIsOpen != this.isOpen();
            }
            double newSize = this.getNumberOfRows();
            double avail = newSize - this.lastSize;
            if (this.isOpen()) {
                if (avail > 0.0 && !resetAll) {
                    this.table.getLargeTableModel().fireRowsInserted((long)this.lastSize, (long)newSize);
                }
                if (poll) {
                    Cache oldCache = this.cache;
                    avail = newSize;
                    this.cache = new Cache(128);
                    if (!resetAll) {
                        for (int i = 0; i < this.table.getNumberOfVisibleRows(); ++i) {
                            double offset = (double)i + (double)this.table.getTopRowIndex();
                            if (!(offset < this.lastSize)) continue;
                            Table newData = this.getDataTable(offset);
                            Table oldData = (Table)oldCache.get(Double.toString(offset));
                            if (this.rowEquals(oldData, newData)) continue;
                            this.table.getLargeTableModel().fireNeedsRedraw((long)offset, (long)offset);
                        }
                    }
                }
                this.lastSize = newSize;
            }
            if (resetAll) {
                this.table.getLargeTableModel().fireStructureChanged();
            }
            return avail;
        }

        private boolean rowEquals(Table oldData, Table newData) {
            boolean same;
            if (oldData == newData) {
                return true;
            }
            boolean bl = same = oldData != null && newData != null;
            if (same) {
                String[] keys = newData.getKeys();
                for (int i = 0; same && i < keys.length; ++i) {
                    Object newVal = newData.get(keys[i]);
                    Object oldVal = oldData.get(keys[i]);
                    same = newVal != null && oldVal != null && newVal.toString().equals(oldVal.toString());
                }
            }
            return same;
        }
    }

    private static abstract class AbstractCachedDataFile
    implements ListFile {
        protected final int CACHE_SIZE = 128;
        protected final MJList table;
        protected final Midas midas;
        protected DataFile dataFile;
        protected Table[] recordDef;
        protected Table recordDefs;

        protected AbstractCachedDataFile(Midas midas, DataFile df, MJList table) {
            this.dataFile = df;
            this.table = table;
            this.midas = midas;
        }

        @Override
        public boolean isOpen() {
            return this.dataFile != null && this.dataFile.isOpen();
        }

        @Override
        public boolean open(int flags) {
            return this.dataFile != null ? this.dataFile.open(flags) : false;
        }

        @Override
        public String getURL() {
            return this.dataFile != null ? this.dataFile.getURL() : null;
        }

        @Override
        public FileName getName() {
            return this.dataFile != null ? this.dataFile.getName() : null;
        }

        @Override
        public double getNumberOfRows() {
            return this.isOpen() ? this.dataFile.getNumberOfRows() : 0.0;
        }

        @Override
        public boolean getProtected() {
            return this.isOpen() ? this.dataFile.getProtected() : true;
        }

        @Override
        public void close() {
            if (this.isOpen()) {
                this.dataFile.close();
            }
        }

        @Override
        public void update() {
            if (this.isOpen()) {
                this.dataFile.update();
            }
        }

        @Override
        public int getRecordDefCount() {
            return this.getRecordDef().length;
        }

        @Override
        public void setRecordDefs(Table defs) {
            throw new MidasException(this.getClass().getName() + ": Altering recodr definitions not permitted.");
        }

        @Override
        public Table getRecordDefs() {
            this.getRecordDef();
            return this.recordDefs;
        }

        @Override
        public Table getRecordDef(int i) {
            return i < this.getRecordDef().length ? this.getRecordDef()[i] : null;
        }

        private Table[] getRecordDef() {
            if (!this.isOpen()) {
                this.recordDef = new Table[0];
                this.recordDefs = new Table();
            } else if (this.recordDef == null || this.recordDefs == null) {
                this.recordDef = new Table[this.dataFile.getRecordDefCount()];
                this.recordDefs = this.dataFile.getRecordDefs();
                for (int i = 0; i < this.recordDef.length; ++i) {
                    this.recordDef[i] = this.dataFile.getRecordDef(i);
                }
            }
            return this.recordDef;
        }

        protected void resetRecordDef() {
            this.recordDef = null;
            this.recordDefs = null;
        }
    }

    private static interface PollsOwnData
    extends ListFile {
        public double pollData(boolean var1);
    }

    public static class LegacySelectionModel
    extends NMTableSelectionModel {
        public LegacySelectionModel(MJList table, boolean autoSelect, MessageHandler msgHandler, boolean prevAndCurr) {
            super(table, msgHandler, new Table("AUTOSELECT=" + autoSelect + ",PREVANDCURR=" + prevAndCurr + ",LEGACY=true"));
        }
    }

    public static class NMTableSelectionModel
    extends LargeJTable.LargeTableSelectionModel {
        protected boolean prevAndCurr;
        protected boolean autoSelect;
        protected MessageHandler msgHandler;
        protected long lastRow = -1L;
        protected long lastCol = -1L;
        protected boolean legacy = false;

        public NMTableSelectionModel(MJList table, MessageHandler msgHandler, Table settings) {
            super(table);
            this.msgHandler = msgHandler;
            if (settings.containsKey("AUTOSELECT")) {
                this.autoSelect = settings.getState("AUTOSELECT");
            }
            if (settings.containsKey("PREVANDCURR")) {
                this.prevAndCurr = settings.getState("PREVANDCURR");
            }
            if (settings.containsKey("LEGACY")) {
                this.legacy = settings.getState("LEGACY");
            }
        }

        private MJList getMJList() {
            return (MJList)this.getTable();
        }

        private Message createReturnMessage(long row, long col, int type, Table prev) {
            long colIndex;
            String name = null;
            Table tbl = new Table();
            Table curr = null;
            Object value = null;
            String selType = null;
            long rowNum = this.getMJList().getSortingModel().toReal(row);
            long rowIndex = row < 0L ? -1L : this.getMJList().getMacroRowIndex(rowNum);
            String colName = col < 0L ? "" : this.getMJList().getColumnName((int)col);
            long l = colIndex = col < 0L ? -1L : this.getMJList().getMacroColIndex(colName);
            if (col < 0L && row < 0L) {
                selType = "ALL";
                value = new Table();
                curr = new Table();
            } else if (col < 0L || this.getTable().isCellClickActionRow()) {
                selType = "ROW";
                value = this.getMJList().getRow(rowIndex);
                curr = this.getMJList().getAllSelectedCells();
            } else if (row < 0L || this.getTable().isCellClickActionCol()) {
                selType = "COLUMN";
                value = "value";
            } else {
                selType = "CELL";
                value = this.getMJList().getRow(rowIndex).get(colName);
                curr = this.getMJList().getAllSelectedCells();
            }
            switch (type) {
                case 1: {
                    name = null;
                    break;
                }
                case 2: {
                    name = "SELECT";
                    break;
                }
                case 4: {
                    name = "SELECT";
                    break;
                }
                case 3: {
                    name = "SELECT";
                    break;
                }
                case 5: {
                    name = "DESELECT";
                    break;
                }
                default: {
                    name = "SELECT";
                }
            }
            if (!this.prevAndCurr) {
                if (type == 2) {
                    prev = null;
                    curr = null;
                }
                if (type == 5) {
                    curr = null;
                    colName = null;
                }
            }
            tbl.setKey("ROW", rowIndex);
            tbl.setKey("COLUMN", colIndex);
            tbl.setKey("TYPE", selType);
            if (colName != null) {
                tbl.setKey("NAME", colName);
            }
            if (value != null) {
                tbl.setKey("VALUE", value);
            }
            if (prev != null) {
                tbl.setKey("PREVSEL", prev);
            }
            if (curr != null) {
                tbl.setKey("CURRSEL", curr);
            }
            return new Message(name, 0, tbl);
        }

        @Override
        protected void changeRowSelection(long start, long end, int type, boolean msg) {
            if (this.msgHandler != null && type != 1 && msg) {
                Table prev = this.getMJList().getAllSelectedCells();
                super.changeRowSelection(start, end, type, msg);
                this.msgHandler.processMessage(this.createReturnMessage(start, -1L, type, prev));
            } else {
                super.changeRowSelection(start, end, type, msg);
            }
        }

        public void changeCellSelection(long row, long col, int type, String msg) {
            boolean bmsg = Convert.s2state(msg, true);
            this.changeCellSelection(row, col, type, bmsg);
        }

        @Override
        protected void changeCellSelection(long row, long col, int type, boolean msg) {
            if (type == 5 && row < 0L) {
                row = this.lastRow;
            }
            if (type == 5 && col < 0L) {
                col = this.lastCol;
            }
            this.lastRow = row;
            this.lastCol = col;
            if (this.msgHandler == null || type == 1 || !msg) {
                super.changeCellSelection(row, col, type, msg);
            } else {
                Table prev = this.getMJList().getAllSelectedCells();
                super.changeCellSelection(row, col, type, msg);
                this.msgHandler.processMessage(this.createReturnMessage(row, col, type, prev));
            }
        }

        protected void changeCellSelection(long row, long col, String type, boolean msg) {
            long realRow = this.getMJList().getRealRowIndex(row);
            long realCol = this.getMJList().getRealColIndex(col);
            int typeID = Parser.find("Anchor,Click,ShiftClick,CtrlClick,Deselect", type, -1);
            if (typeID < 0) {
                this.getMJList().showErrorMsg("Invalid selection type '" + type + "'.");
            } else {
                super.changeCellSelection(realRow, realCol, typeID, msg);
            }
        }
    }

    private static class NmCheckboxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 2012021070311L;
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private static final Border focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
        private transient Color normalfgcolor;
        private transient Color normalbgcolor;
        private transient Color fgcolor;
        private transient Color bgcolor;

        public NmCheckboxRenderer() {
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.setIcon(new Symbol.CheckBox(false));
            this.setSelectedIcon(new Symbol.CheckBox(true));
        }

        private static boolean isTrue(Object val) {
            String str = val == null ? "FALSE" : val.toString();
            boolean value = false;
            value = StringUtil.isNumber(str) ? Convert.s2d(str) != 0.0 : StringUtil.isTrue(str);
            return value;
        }

        @Override
        public Color getForeground() {
            return this.fgcolor != null ? this.fgcolor : super.getForeground();
        }

        @Override
        public Color getBackground() {
            return this.bgcolor != null ? this.bgcolor : super.getBackground();
        }

        @Override
        public void setForeground(Color color) {
            this.fgcolor = color;
            this.normalfgcolor = color;
        }

        @Override
        public void setBackground(Color color) {
            this.bgcolor = color;
            this.normalbgcolor = color;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object val, boolean sel, boolean focus, int row, int col) {
            this.setSelected(NmCheckboxRenderer.isTrue(val));
            this.fgcolor = this.normalfgcolor;
            this.bgcolor = sel ? table.getSelectionBackground() : ((MJList)table).getShadeColor(row, this.normalbgcolor);
            if (focus) {
                this.setBorder(focusBorder);
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }

    private static class NmTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 2012021060311L;
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private static final Border focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
        private Format format;
        private Color normalfgcolor;
        private Color normalbgcolor;
        private Color fgcolor;
        private Color bgcolor;
        private String fgColorCol;
        private String bgColorCol;

        public NmTableCellRenderer() {
            this((Format)null);
        }

        public NmTableCellRenderer(Format format) {
            this(format, 0);
        }

        public NmTableCellRenderer(Format format, int horizAlignment) {
            this.format = format;
            this.setHorizontalAlignment(horizAlignment);
        }

        @Override
        public Color getForeground() {
            return this.fgcolor != null ? this.fgcolor : super.getForeground();
        }

        @Override
        public Color getBackground() {
            return this.bgcolor != null ? this.bgcolor : super.getBackground();
        }

        @Override
        public void setForeground(Color color) {
            this.fgcolor = color;
            this.normalfgcolor = color;
        }

        @Override
        public void setBackground(Color color) {
            this.bgcolor = color;
            this.normalbgcolor = color;
        }

        public void setFgOverrideCol(String col) {
            this.fgColorCol = col;
        }

        public void setBgOverrideCol(String col) {
            this.bgColorCol = col;
        }

        @Override
        protected void setValue(Object value) {
            super.setValue(this.format(value));
        }

        public String format(Object val) {
            String str = null;
            str = val == null ? "" : (this.format == null ? val.toString() : this.format.format(val));
            if (str.equals("()")) {
                str = val.toString();
            }
            return str;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object val, boolean sel, boolean focus, int row, int col) {
            Component comp = super.getTableCellRendererComponent(table, val, sel, focus, row, col);
            if (comp != this) {
                ((MJList)table).showWarningMsg("WARNING: Internal error in rendering cells.");
            }
            Color defFgColor = this.getRowColor(table, row, this.normalfgcolor, this.fgColorCol);
            Color defBgColor = this.getRowColor(table, row, this.normalbgcolor, this.bgColorCol);
            this.fgcolor = this.getEnumColor(this.format, val, defFgColor);
            this.bgcolor = this.getShadeColor(table, row, defBgColor, sel);
            if (focus) {
                this.setBorder(focusBorder);
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }

        private Color getRowColor(JTable table, int row, Color defColor, String colorCol) {
            Color color = defColor;
            if (colorCol != null && table instanceof MJList) {
                MJList mjl = (MJList)table;
                color = mjl.getColor(row, colorCol);
            }
            return color;
        }

        private Color getEnumColor(Format format, Object val, Color defColor) {
            Color color = defColor;
            if (format instanceof MFormat && (color = ((MFormat)format).getColor(val)) == null) {
                color = defColor;
            }
            return color;
        }

        private Color getShadeColor(JTable table, int row, Color defColor, boolean sel) {
            Color color = defColor;
            if (sel) {
                color = table.getSelectionBackground();
            } else if (table instanceof MJList) {
                MJList mjl = (MJList)table;
                color = mjl.getShadeColor(row, defColor);
            }
            return color;
        }

        public void setFormat(Format format) {
            this.format = format;
        }
    }

    private class NmColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 2012021050311L;
        private Vector<TableColumn> hiddenColumns = new Vector();

        private NmColumnModel() {
        }

        public void removeAllColumns() {
            this.tableColumns.clear();
            this.hiddenColumns.clear();
        }

        @Override
        public void moveColumn(int columnIndex, int newIndex) {
            if (MJList.this.colDrag) {
                super.moveColumn(columnIndex, newIndex);
                if (columnIndex != newIndex) {
                    // empty if block
                }
            }
        }

        public String getColumnOrder() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.tableColumns.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.getColumnName(i));
            }
            return sb.toString();
        }

        private String getColumnName(int index) {
            TableColumn column = (TableColumn)this.tableColumns.get(index);
            int colNum = column.getModelIndex();
            return MJList.this.columnNames[colNum];
        }

        public int findColumnIndex(String name) {
            int num;
            String val;
            int index = -1;
            for (int i = 0; index == -1 && i < this.tableColumns.size(); ++i) {
                if (!this.getColumnName(i).equals(name)) continue;
                index = i;
            }
            if (index == -1 && name.startsWith("_") && name.endsWith("_") && StringUtil.isNumber(val = name.substring(1, name.length() - 1)) && (num = Convert.o2l(val, null, -1)) >= 0 && num < this.tableColumns.size()) {
                index = num;
            }
            return index;
        }

        public TableColumn findColumn(int index) {
            TableColumn col;
            int i;
            TableColumn column = null;
            for (i = 0; column == null && i < this.tableColumns.size(); ++i) {
                col = (TableColumn)this.tableColumns.get(i);
                if (col.getModelIndex() != index) continue;
                column = col;
            }
            for (i = 0; column == null && i < this.hiddenColumns.size(); ++i) {
                col = this.hiddenColumns.get(i);
                if (col.getModelIndex() != index) continue;
                column = col;
            }
            return column;
        }

        public void setColumnVisible(int column, boolean visible) {
            if (visible) {
                for (TableColumn col : this.hiddenColumns) {
                    if (col.getModelIndex() != column) continue;
                    this.hiddenColumns.remove(col);
                    this.addColumn(col);
                    break;
                }
            } else {
                for (TableColumn col : this.tableColumns) {
                    if (col.getModelIndex() != column) continue;
                    this.hiddenColumns.add(col);
                    this.removeColumn(col);
                    break;
                }
            }
        }
    }

    private static class NmTableModel
    extends AbstractTableModel
    implements LargeJTable.LargeTableModel {
        private static final long serialVersionUID = 2012021040311L;
        private final MJList table;

        private NmTableModel(MJList table) {
            this.table = table;
        }

        private ListFile getListFile() {
            return this.table.listFile;
        }

        @Override
        public int getRowCount() {
            int rowCount = 0;
            if (this.getListFile() != null) {
                long lastPage = (long)this.getListFile().getNumberOfRows() - this.table.getTopRowIndex();
                rowCount = (int)Math.min((long)this.table.getNumberOfVisibleRows(), lastPage);
            }
            return rowCount;
        }

        @Override
        public int getColumnCount() {
            return this.getListFile() != null ? this.getListFile().getRecordDefCount() : 0;
        }

        @Override
        public String getColumnName(int col) {
            return this.table.columnNames[col];
        }

        @Override
        public Class<?> getColumnClass(int col) {
            Class clazz = Object.class;
            String fmt = this.table.columnFormats[col];
            clazz = Data.isString((byte)fmt.charAt(1)) ? String.class : (fmt.charAt(0) == 'S' ? Number.class : (fmt.charAt(0) == '1' ? Number.class : Number[].class));
            return clazz;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.isCellEditable(this.table.getRealRowIndex(rowIndex), this.table.getRealColIndex(columnIndex));
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.getValueAt(this.table.getRealRowIndex(rowIndex), this.table.getRealColIndex(columnIndex));
        }

        @Override
        public void setValueAt(Object val, int rowIndex, int columnIndex) {
            this.setValueAt(val, this.table.getRealRowIndex(rowIndex), this.table.getRealColIndex(columnIndex));
        }

        @Override
        public boolean isCellEditable(long row, long col) {
            return !this.getListFile().getProtected() && this.table.editable;
        }

        @Override
        public Object getValueAt(long row, long col) {
            Object value = null;
            if (this.getListFile() != null) {
                String name = this.table.columnNames[(int)col];
                Table tbl = this.getListFile().getDataTable(row);
                if (tbl != null) {
                    value = tbl.getKey(name);
                }
            }
            return value;
        }

        @Override
        public void setValueAt(Object val, long row, long col) {
            if (this.getListFile() != null) {
                String name = this.table.columnNames[(int)col];
                if (this.isCellEditable(row, col)) {
                    this.getListFile().setData(row, name, val);
                } else {
                    this.table.showErrorMsg("Can not edit cell at (" + row + "," + col + "), cell is not editable.");
                }
            }
        }

        @Override
        public void fireNeedsRedraw(long top, long btm) {
            int[] rows = this.table.getModelRowsVisible(top, btm);
            if (rows != null) {
                this.fireTableRowsUpdated(rows[0], rows[1]);
                this.table.getRowHeader().getRowHeaderModel().fireTableRowsUpdated(rows[0], rows[1]);
            }
        }

        @Override
        public void fireRowsInserted(long top, long btm) {
            long[] range = this.table.getRowsVisible(top, -1L);
            if (range != null) {
                int[] rows = this.table.getModelRowsVisible(range[0], range[0] + (btm - top));
                this.fireTableRowsInserted(rows[0], rows[1]);
                this.table.getRowHeader().getRowHeaderModel().fireTableRowsInserted(rows[0], rows[1]);
            }
            this.table.getVertScrollBar().revalidate();
        }

        @Override
        public void fireRowsDeleted(long top, long btm) {
            long[] range = this.table.getRowsVisible(top, -1L);
            if (range != null) {
                int[] rows = this.table.getModelRowsVisible(range[0], range[0] + (btm - top));
                this.fireTableRowsDeleted(rows[0], rows[1]);
                this.table.getVertScrollBar().revalidate();
                this.table.getRowHeader().getRowHeaderModel().fireTableRowsDeleted(rows[0], rows[1]);
            }
            this.table.getVertScrollBar().revalidate();
        }

        @Override
        public void fireStructureChanged() {
            this.fireTableStructureChanged();
            this.table.getRowHeader().revalidate();
            this.table.getVertScrollBar().revalidate();
            this.table.getRowHeader().getRowHeaderModel().fireTableStructureChanged();
        }
    }

    public static interface ListMessageListener {
        public void showErrorMsg(String var1);

        public void showWarningMsg(String var1);

        public void showDeprecatedMsg(String var1);
    }

    private static final class EquationSet {
        private final Midas midas = new Midas();
        private final String[] equations;
        private final Object[] values;

        public EquationSet(Table tbl) {
            this.equations = tbl.getKeys();
            this.values = new Object[this.equations.length];
            for (int i = 0; i < this.equations.length; ++i) {
                this.values[i] = tbl.get(this.equations[i]);
            }
        }

        public Object test(Object x) {
            this.midas.getResults().put("X", x);
            Object val = null;
            for (int i = 0; i < this.equations.length && val == null; ++i) {
                if (!Convert.inLineTest(this.midas, this.equations[i])) continue;
                val = this.values[i];
            }
            return val;
        }
    }
}

