/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import nxm.sys.lib.Shell;
import nxm.sys.libg.MJHelp;

public class MJBrowser
extends JPanel
implements MJHelp.DocViewerIF {
    private static final long serialVersionUID = 2012102410330L;
    private ArrayList<URL> history = new ArrayList();
    private int currentPos = -1;
    private int backPos = -1;
    private int forwardPos = -1;
    private boolean debug = true;
    private static Desktop desktop = null;
    JButton back;
    JButton forward;
    JButton inBrowser;
    JEditorPane jEditorPane;
    JTextField jURL;
    JButton refresh;

    public MJBrowser() {
        this.initComponents();
        this.inBrowser.setEnabled(desktop != null);
    }

    private boolean displayURL(URL url) {
        boolean result = false;
        try {
            this.jURL.setText(url.toString());
            this.jEditorPane.setPage(url);
            this.jEditorPane.setBackground(Color.WHITE);
            result = true;
        }
        catch (FileNotFoundException fne) {
            this.jEditorPane.setText("Specified file to display not found:\n" + url);
        }
        catch (Exception ex) {
            String msg = "Cannot render this document. Open this URL in your web browser to display the contents:\n" + url;
            this.jEditorPane.setText(msg);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean showDocument(URL url) {
        boolean result = this.displayURL(url);
        if (result) {
            ArrayList<URL> arrayList = this.history;
            synchronized (arrayList) {
                ++this.currentPos;
                this.history.add(this.currentPos, url);
                if (this.currentPos > 0) {
                    ++this.backPos;
                }
                this.back.setEnabled(this.backPos >= 0);
                int size = this.history.size();
                for (int i = size - 1; i > this.currentPos; --i) {
                    this.history.remove(i);
                }
                this.forwardPos = -1;
                this.forward.setEnabled(false);
            }
        }
        return result;
    }

    public static boolean browse(URL url) {
        boolean result = false;
        if (desktop != null && url != null) {
            try {
                desktop.browse(new URI(url.toString()));
                result = true;
            }
            catch (Exception e) {
                Shell.printStackTrace(e);
            }
        }
        return result;
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JToolBar jToolBar = new JToolBar();
        this.back = new JButton();
        this.forward = new JButton();
        this.refresh = new JButton();
        this.inBrowser = new JButton();
        this.jURL = new JTextField();
        JScrollPane jScrollPane = new JScrollPane();
        this.jEditorPane = new JEditorPane();
        FormListener formListener = new FormListener();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setPreferredSize(new Dimension(640, 480));
        this.setLayout(new BorderLayout());
        jPanel1.setLayout(new BorderLayout());
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        this.back.setFont(new Font("Dialog", 1, 10));
        this.back.setText("Back");
        this.back.setToolTipText("Go back one page");
        this.back.setEnabled(false);
        this.back.addActionListener(formListener);
        jToolBar.add(this.back);
        this.forward.setFont(new Font("Dialog", 1, 10));
        this.forward.setText("Forward");
        this.forward.setToolTipText("Go forward one page");
        this.forward.setEnabled(false);
        this.forward.addActionListener(formListener);
        jToolBar.add(this.forward);
        this.refresh.setFont(new Font("Dialog", 1, 10));
        this.refresh.setText("Refresh");
        this.refresh.setToolTipText("Reload current page");
        this.refresh.addActionListener(formListener);
        jToolBar.add(this.refresh);
        this.inBrowser.setFont(new Font("Dialog", 1, 10));
        this.inBrowser.setText("Browser");
        this.inBrowser.setToolTipText("Display page in browser (Java6 only)");
        this.inBrowser.setDefaultCapable(false);
        this.inBrowser.setEnabled(false);
        this.inBrowser.setFocusable(false);
        this.inBrowser.setHorizontalTextPosition(0);
        this.inBrowser.setVerticalTextPosition(3);
        this.inBrowser.addActionListener(formListener);
        jToolBar.add(this.inBrowser);
        jPanel1.add((Component)jToolBar, "Before");
        this.jURL.setFont(new Font("Dialog", 0, 10));
        this.jURL.setText("URL");
        this.jURL.setToolTipText("URL of content. Open this URL in a web browser for better formatting.");
        this.jURL.setDragEnabled(true);
        this.jURL.addActionListener(formListener);
        jPanel1.add((Component)this.jURL, "Center");
        this.add((Component)jPanel1, "North");
        this.jEditorPane.setBorder(null);
        this.jEditorPane.setContentType("text/html");
        this.jEditorPane.setEditable(false);
        this.jEditorPane.setAlignmentX(0.0f);
        this.jEditorPane.setAlignmentY(0.0f);
        this.jEditorPane.setMargin(new Insets(0, 0, 0, 0));
        this.jEditorPane.addHyperlinkListener(formListener);
        jScrollPane.setViewportView(this.jEditorPane);
        this.add((Component)jScrollPane, "Center");
    }

    private void browser(ActionEvent evt) {
        block3: {
            if (this.currentPos < 0) {
                return;
            }
            try {
                URL url = this.history.get(this.currentPos);
                MJBrowser.browse(url);
            }
            catch (Exception ex) {
                if (!this.debug) break block3;
                ex.printStackTrace();
            }
        }
    }

    private void jEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (evt instanceof HTMLFrameHyperlinkEvent) {
                ((HTMLDocument)this.jEditorPane.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)evt);
            } else {
                this.showDocument(evt.getURL());
            }
        }
    }

    private void jURLActionPerformed(ActionEvent evt) {
        block2: {
            try {
                URL url = new URI(this.jURL.getText()).toURL();
                this.showDocument(url);
            }
            catch (Exception ex) {
                if (!this.debug) break block2;
                ex.printStackTrace();
            }
        }
    }

    private void refresh(ActionEvent evt) {
        if (this.currentPos < 0) {
            return;
        }
        URL url = this.history.get(this.currentPos);
        try {
            this.jEditorPane.read(url.openStream(), (Object)url);
        }
        catch (Exception e) {
            this.jEditorPane.setText("Unable to refresh contents of URL: " + url + "\n" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forward(ActionEvent evt) {
        ArrayList<URL> arrayList = this.history;
        synchronized (arrayList) {
            int size = this.history.size();
            if (this.forwardPos < size) {
                URL url = this.history.get(this.forwardPos);
                this.backPos = this.currentPos;
                this.currentPos = this.forwardPos++;
                this.back.setEnabled(true);
                this.displayURL(url);
            } else {
                this.forwardPos = -1;
            }
            if (this.forwardPos < 0 || this.forwardPos >= size) {
                this.forward.setEnabled(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void back(ActionEvent evt) {
        ArrayList<URL> arrayList = this.history;
        synchronized (arrayList) {
            if (this.backPos >= 0) {
                URL url = this.history.get(this.backPos);
                this.forwardPos = this.currentPos;
                this.currentPos = this.backPos--;
                this.forward.setEnabled(true);
                this.displayURL(url);
            }
            if (this.backPos < 0) {
                this.back.setEnabled(false);
            }
        }
    }

    static {
        try {
            desktop = Desktop.getDesktop();
        }
        catch (Exception e) {
            Shell.warning("Unable to get java.awt.Desktop instance for using browse(URI) method: " + e);
        }
    }

    private class FormListener
    implements ActionListener,
    HyperlinkListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == MJBrowser.this.back) {
                MJBrowser.this.back(evt);
            } else if (evt.getSource() == MJBrowser.this.forward) {
                MJBrowser.this.forward(evt);
            } else if (evt.getSource() == MJBrowser.this.refresh) {
                MJBrowser.this.refresh(evt);
            } else if (evt.getSource() == MJBrowser.this.inBrowser) {
                MJBrowser.this.browser(evt);
            } else if (evt.getSource() == MJBrowser.this.jURL) {
                MJBrowser.this.jURLActionPerformed(evt);
            }
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent evt) {
            if (evt.getSource() == MJBrowser.this.jEditorPane) {
                MJBrowser.this.jEditorPaneHyperlinkUpdate(evt);
            }
        }
    }
}

