/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.Table;
import nxm.sys.libg.Layer;
import nxm.sys.libg.Line;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.Theme;
import nxm.sys.prim.plot;

public class LayerPoly
extends Layer {
    public float[] fbuf;
    public int dim = 2;
    private float[] ftmp = new float[6];
    private Table ctab;
    private boolean showWarning = true;
    private static boolean autoAdjustLineColor = false;

    public LayerPoly() {
        super("POLY");
    }

    public LayerPoly(int cmap) {
        this();
        this.setColorMap(cmap);
        if (cmap == 8) {
            this.ctab = MColor.getMapColorTable();
        }
    }

    public LayerPoly(Table ctab) {
        this();
        this.setColorTable(ctab);
    }

    @Override
    protected void init(plot p, String layerName, int layerIndex, Layer oldLayer) {
        super.init(p, layerName, layerIndex, oldLayer);
        if (!Theme.getOption(4) || !Theme.getOption(32)) {
            this.MP.setOptions("+BS");
        }
    }

    @Override
    public int getDefaultView() {
        if (this.pf == null) {
            return super.getDefaultView();
        }
        switch (this.pf.getType()) {
            case 1998: {
                return 9;
            }
            case 1999: {
                return 11;
            }
        }
        return super.getDefaultView();
    }

    @Override
    public boolean setFile(PlotFile pf, Table tab, Args MA) {
        super.setFile(pf, tab, MA);
        this.dim = pf.getMode();
        this.showWarning = true;
        return true;
    }

    @Override
    public void process() {
        this.ndata = 0;
        if (this.data == null) {
            return;
        }
        this.ndata = this.data.size * this.data.ape;
        this.fbuf = new float[this.ndata * this.dim];
        this.data.toArray(this.fbuf);
    }

    @Override
    public void findRange() {
        this.x1 = 180.0;
        this.x2 = -180.0;
        this.y1 = 90.0;
        this.y2 = -90.0;
        this.z1 = 0.0;
        this.z2 = 0.0;
        int j = 0;
        while (j < this.ndata * this.dim) {
            int npts = (int)this.fbuf[j];
            int ncol = (int)this.fbuf[j + 1];
            int k = j + (3 + npts) * this.dim;
            if (ncol != -998) {
                j += this.dim;
                int n = j++;
                float xy = this.fbuf[n];
                if ((double)xy < this.x1) {
                    this.x1 = xy;
                }
                int n2 = j++;
                xy = this.fbuf[n2];
                if ((double)xy < this.y1) {
                    this.y1 = xy;
                }
                if (this.dim == 3) {
                    int n3 = j++;
                    xy = this.fbuf[n3];
                    if ((double)xy < this.z1) {
                        this.z1 = xy;
                    }
                }
                int n4 = j++;
                xy = this.fbuf[n4];
                if ((double)xy > this.x2) {
                    this.x2 = xy;
                }
                int n5 = j++;
                xy = this.fbuf[n5];
                if ((double)xy > this.y2) {
                    this.y2 = xy;
                }
                if (this.dim == 3) {
                    int n6 = j++;
                    xy = this.fbuf[n6];
                    if ((double)xy > this.z2) {
                        this.z2 = xy;
                    }
                }
            }
            j = k;
        }
        this.a1 = this.y1;
        this.a2 = this.y2;
    }

    @Override
    public void draw(int flag) {
        super.draw(flag);
        if (this.ndata <= 0) {
            return;
        }
        Line lin = this.line.copy();
        int j = 0;
        while (j < this.ndata * this.dim && !this.MP.cancel) {
            int k;
            block13: {
                int ncol;
                int npts;
                block14: {
                    block16: {
                        block15: {
                            block12: {
                                npts = (int)this.fbuf[j];
                                ncol = (int)this.fbuf[j + 1];
                                if (this.showWarning && (float)ncol != this.fbuf[j + 1]) {
                                    this.showWarning = false;
                                    this.warning("LayerPoly: expecting integer color number, but got " + this.fbuf[j + 1]);
                                }
                                k = j + (3 + npts) * this.dim;
                                j += this.dim;
                                if (this.MP.view != 14) break block12;
                                if ((double)this.fbuf[j] >= this.MP.rx2 || (double)this.fbuf[j + 1] >= this.MP.ry2 || (double)this.fbuf[j += this.dim] <= this.MP.rx1 && !((double)(this.fbuf[j - this.dim] + (float)MPlot.LONGITUDE_RANGE) < this.MP.rx2) || (double)this.fbuf[j + 1] <= this.MP.ry1) break block13;
                                j += this.dim;
                                break block14;
                            }
                            if (!this.MP.is2D) break block15;
                            if ((double)this.fbuf[j] >= this.MP.rx2 || (double)this.fbuf[j + 1] >= this.MP.ry2 || (double)this.fbuf[j += this.dim] <= this.MP.rx1 || (double)this.fbuf[j + 1] <= this.MP.ry1) break block13;
                            j += this.dim;
                            break block14;
                        }
                        if (this.MP.view != 13 && this.MP.view != 9) break block16;
                        int i = this.MP.viewer.rwc2pix(this.fbuf, j, this.dim, 2, this.MP.tpix);
                        if (i == 0) {
                            if (this.dim == 2) {
                                this.ftmp[0] = this.fbuf[j];
                                this.ftmp[1] = this.fbuf[j + 3];
                                this.ftmp[2] = this.fbuf[j + 2];
                                this.ftmp[3] = this.fbuf[j + 1];
                                i = this.MP.viewer.rwc2pix(this.ftmp, 0, this.dim, 2, this.MP.tpix);
                            } else if (this.dim == 3) {
                                this.ftmp[0] = this.fbuf[j];
                                this.ftmp[1] = this.fbuf[j + 3];
                                this.ftmp[2] = this.fbuf[j + 5];
                                this.ftmp[3] = this.fbuf[j + 3];
                                this.ftmp[4] = this.fbuf[j + 1];
                                this.ftmp[5] = this.fbuf[j + 2];
                                i = this.MP.viewer.rwc2pix(this.ftmp, 0, this.dim, 2, this.MP.tpix);
                            }
                        }
                        j += 2 * this.dim;
                        if (i != 0) break block14;
                        break block13;
                    }
                    j += 2 * this.dim;
                }
                if (ncol != -998) {
                    if (ncol == -999) {
                        k = j;
                    } else {
                        if (ncol < 1) {
                            lin.setColor(MColor.getSpecialXMidasColor(ncol));
                        } else {
                            int colorIndex = (ncol - 1) % (this.colors.length - 1) + 1;
                            lin.setColor(this.colors[colorIndex]);
                        }
                        this.MP.drawLine(this.fbuf, j, this.dim, npts, lin);
                    }
                }
            }
            j = k;
        }
    }

    public Table getColorTable() {
        return this.ctab;
    }

    public void setColorTable(Table ctab) {
        this.setColorMap(MColor.getColorMap(ctab));
        this.ctab = ctab;
    }

    @Override
    public void setColor(String value) {
        super.setColor(value);
        if (autoAdjustLineColor && this.colors != null && this.colors.length > 1) {
            this.colors[1] = this.line.getColor();
        }
    }

    @Override
    public void setColor(int value) {
        super.setColor(value);
        if (autoAdjustLineColor && this.colors != null && this.colors.length > 1) {
            this.colors[1] = this.line.getColor();
        }
    }

    @Override
    public void setColor(Color value) {
        super.setColor(value);
        if (autoAdjustLineColor && this.colors != null && this.colors.length > 1) {
            this.colors[1] = this.line.getColor();
        }
    }

    public static void setAutoAdjustLineColor(boolean matchColormap) {
        autoAdjustLineColor = matchColormap;
    }

    public static boolean getAutoAdjustLineColor() {
        return autoAdjustLineColor;
    }

    @Override
    public void setColors(String value) {
        this.setColorMap(value);
    }

    @Override
    public void setColorMap(String value) {
        super.setColorMap(value);
        if (autoAdjustLineColor && this.colors != null && this.colors.length > 1) {
            this.line.setColor(this.colors[1]);
        }
    }

    @Override
    public void setColorMap(int value) {
        this.setColorMap(value, -1);
    }

    @Override
    public void setColorMap(int value, int ncolors) {
        super.setColorMap(value, ncolors);
        if (autoAdjustLineColor && this.colors != null && this.colors.length > 1) {
            this.line.setColor(this.colors[1]);
        }
    }
}

