/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Arrays;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Position;
import nxm.sys.lib.Table;
import nxm.sys.lib.TimeLine;
import nxm.sys.lib.TuneAdjust;
import nxm.sys.libg.Contour;
import nxm.sys.libg.GraphicsUtil;
import nxm.sys.libg.Layer;
import nxm.sys.libg.Line;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MImage;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.MPoint;
import nxm.sys.libg.Pix;
import nxm.sys.libm.Tolerance;
import nxm.sys.prim.plot;

public class Layer2D
extends Layer {
    public final String compressionList = "None,Max,Min,Avg,Mean,SWMax";
    public final int CMP_NONE = 1;
    public final int CMP_MAX = 2;
    public final int CMP_MIN = 3;
    public final int CMP_AVG = 4;
    public final int CMP_MEAN = 5;
    public final int CMP_SWMAX = 6;
    private static final int DEFAULT_LPS = 128;
    protected float[] fbuf;
    protected MImage mimage;
    protected byte[] buf;
    private byte[] bufv;
    private byte[] cmpbuf;
    private int cmpLeft;
    private Contour contour;
    private double[] dbuf;
    private Pix pa;
    private Pix pb;
    private int lpb;
    private int lpi;
    private int index;
    private int pass;
    private int index1;
    private int mindex;
    private int indexAdjust;
    private int compression;
    private boolean useRaster;
    private boolean useContour;
    private boolean usePoly;
    private boolean xvy;
    private boolean xIsTime;
    private int jx1;
    private int jx2;
    private int jy1;
    private int jy2;
    private int ixn;
    private int iyn;
    protected float scl0;
    protected float scl1;
    private int dcmap = 2;
    private boolean reScale = false;
    protected boolean directColor = false;
    private int[] imageBuf;
    private int[] imageBufv;
    private int[] cmpbufv;
    private int alpha = -1;
    private boolean scaleZ = false;
    private double lrz1;
    private double lrz2;
    private int lcmp;
    private boolean yCompressionWarn = true;
    private int compressByteWarn = 0;
    private int compressIntWarn = 0;
    @Deprecated
    public TimeLine timeLineSave = null;
    @Deprecated
    public double indexSave = 0.0;
    private boolean awaiting_data = true;
    private boolean force_proc_order = true;

    public Layer2D() {
        super("2D");
        this.setEnableNonLocal(false, false, true);
        this.indexAdjust = 0;
        this.pass = 0;
        this.index1 = 0;
        this.index = 0;
        this.ndata = 0;
        this.defmode = 2;
        this.zaxis = true;
    }

    Layer2D(int cm, int nc) {
        this();
        this.cmap = cm;
        this.ncolors = nc;
        this.colors = MColor.getColorMap(cm, nc);
    }

    @Override
    protected void init(plot p, String layerName, int layerIndex, Layer oldLayer) {
        super.init(p, layerName, layerIndex, oldLayer);
        switch (p.getPlotTypeID()) {
            case 3: {
                this.setSurface(8);
                break;
            }
            case 4: {
                this.setSurface(2);
                break;
            }
            case 5: {
                this.setSurface(4);
            }
        }
        if (oldLayer instanceof Layer2D) {
            Layer2D prev = (Layer2D)oldLayer;
            this.index = this.frame * Math.min(this.size - 1, prev.index / prev.frame);
            int framesLeft = (this.mindex - this.index) / this.frame;
            this.data.size = Math.min(this.data.size, framesLeft);
            this.pass = prev.pass;
            if (prev.mimage != null) {
                if (this.buf == null) {
                    this.getBuffer();
                }
                if (this.mimage == null) {
                    this.getImage();
                }
                double factor = (double)prev.frame / (double)this.frame;
                int jmax = prev.mindex - 1;
                for (int i = 0; i < this.mindex; ++i) {
                    int j = Math.min(jmax, (int)(0.5 + (double)i * factor));
                    this.buf[i] = prev.buf[j];
                }
            }
            this.index1 = this.index;
        }
    }

    @Override
    public int getDefaultComplexMode() {
        return 1;
    }

    @Override
    public int getDefaultView() {
        if (this.pf == null) {
            return super.getDefaultView();
        }
        return this.pf.getYUnits() == 1 ? 2 : super.getDefaultView();
    }

    @Override
    public boolean setFile(PlotFile pf, Table tab, Args MA) {
        this.setFile(pf);
        if (this.typeClass != 2) {
            return false;
        }
        if (MA.find("/FORCEORDER")) {
            this.force_proc_order = MA.getState("/FORCEORDER", this.force_proc_order);
        }
        this.ncolors = MA.getL("NC", 32);
        this.cmap = 2;
        if (pf.getXUnits() == 61) {
            this.cmap = 5;
        }
        this.cmap = MA.getSelectionIndex("CMAP", "GrayScale,Ramp,XRamp,Wheel,Terrain,Multi,T5Layer,MapLine,Grid,Spectrum,XDatalist", this.cmap);
        this.cmap = MA.getSelectionIndex("/CMAP", "GrayScale,Ramp,XRamp,Wheel,Terrain,Multi,T5Layer,MapLine,Grid,Spectrum,XDatalist", this.cmap);
        if (MA.isPresent("/COLORS")) {
            String colorArray = MA.getS("/COLORS");
            this.colors = MColor.getColorMap(colorArray, this.ncolors);
        } else {
            this.colors = MColor.getColorMap(this.cmap, this.ncolors);
        }
        String scaleBy = MA.getS("/SCALEZ", "PLOT");
        this.scaleZ = scaleBy.equals("LAYER");
        this.setXAxis(pf.getXStart(), pf.getXDelta());
        this.setYAxis(pf.getYStart(), pf.getYDelta());
        this.setFrame(pf.getXFrame());
        double fsize = pf.getSize();
        if (pf instanceof DataFile) {
            TuneAdjust tuneAdjustments;
            DataFile df = (DataFile)pf;
            if ((df.flags & 4) != 0) {
                fsize = df.getOutByte(0) / df.dbpe;
            }
            if (this.useRaster && df.getRasterTuneAdjust() && (tuneAdjustments = df.getTuneAdjustments()) != null && tuneAdjustments.isTuneAdjustAvailable()) {
                this.setXAxis(tuneAdjustments.getXStartIF(), pf.getXDelta());
            }
        }
        int ts = (int)Math.min(fsize, 1.0E7);
        int ss = Math.max(8, this.MP.iy21);
        int _lps = Math.min(ts, ss);
        if (this.realtime) {
            _lps = ss;
        } else if ((long)ts * (long)this.frame < 0x100000L) {
            _lps = ts;
        }
        int lpsSwitch = MA.getL("/LPS", 0);
        if (lpsSwitch > 0) {
            _lps = lpsSwitch;
        } else if (lpsSwitch < 0) {
            _lps = 128;
        }
        this.isPaged = !this.realtime && _lps < ts;
        this.lpi = this.lpb = MA.getL("/LPB", Math.min(16, _lps));
        if (this.lpb > _lps) {
            throw new MidasException("Layer2D.setFile invalid setting LPB:" + this.lpb + " > LPS:" + _lps);
        }
        if (this.isPaged) {
            _lps = MA.getL("/LPB", 128);
            if (lpsSwitch > 0 && lpsSwitch != _lps) {
                this.warning("Layer2D.setFile in Paging mode user specified LPS is overrriden by /LPB or default LPS");
            }
        }
        if (!this.realtime) {
            this.lpi = this.lpb = _lps;
        }
        this.setSize(_lps);
        if (this.isPipeWithCuts() && (this.MP.archivedFrames == null || this.MP.archivedFrames.length != this.size)) {
            this.MP.archivedFrames = new float[this.size][];
            this.MP.archivedFramesWriteIdx = 0;
        }
        this.setData(pf.getDataBuffer(this.lpb));
        this.compression = 2;
        this.xIsTime = pf.getXUnits() == 1;
        this.mindex = this.frame * this.size;
        this.update();
        return true;
    }

    @InternalUseOnly
    public TuneAdjust getTuneAdjustments() {
        if (this.useRaster && this.pf != null && this.pf instanceof DataFile) {
            return ((DataFile)this.pf).getTuneAdjustments();
        }
        return null;
    }

    @Override
    public void update() {
        this.setUse();
        if (this.MP.xvy != this.xvy && this.mimage != null && this.ndata > 0) {
            this.getImage();
        }
        if (this.useRaster && this.mimage == null && this.ndata > 0) {
            this.getImage();
        }
        if (this.MP.mode != 0 && this.MP.mode != this.MP.modeLast && this.cmap != 1) {
            if (this.MP.mode == 2) {
                this.dcmap = this.cmap;
                this.setColorMap(4);
            } else if (this.MP.modeLast == 2) {
                this.setColorMap(this.dcmap);
            }
        }
        if (this.ndata > 0 && !this.realtime) {
            this.pass = 0;
            this.index1 = 0;
            this.index = 0;
            this.process();
        }
    }

    @Override
    public void setSurface(int value) {
        super.setSurface(value);
        this.setUse();
    }

    @Override
    public void setColorMap(Color[] colors) {
        super.setColorMap(colors);
        if (this.mimage != null) {
            this.getImage();
            this.mimage.setColors(colors);
        }
        this.reScale = true;
    }

    @Override
    public boolean clear() {
        this.clearIndexValues();
        this.buf = null;
        this.imageBuf = null;
        this.mimage = null;
        return true;
    }

    private void clearIndexValues() {
        this.indexAdjust = 0;
        this.pass = 0;
        this.index1 = 0;
        this.index = 0;
        this.ndata = 0;
        this.cmpLeft = 0;
    }

    @Override
    public boolean reset() {
        boolean inReset = this.isReset;
        boolean reset = super.reset();
        if (reset && !inReset) {
            this.clearIndexValues();
        }
        this.yCompressionWarn = true;
        this.cmpLeft = 0;
        return reset;
    }

    @Override
    public void process() {
        this.indexAdjust = 0;
        this.ndata = 0;
        if (this.data == null) {
            return;
        }
        this.process(this.data.size);
    }

    @Override
    public void process(int ndo) {
        this.indexAdjust = 0;
        this.ndata = 0;
        if (this.data == null) {
            return;
        }
        this.ndata = this.indexAdjust = ndo * this.data.ape;
        if (this.ndata <= 0) {
            return;
        }
        if (this.directColor) {
            this.imageBuf = this.data2la(this.data, this.ndata, this.imageBuf, 0);
            if (this.alpha >= 0) {
                MColor.applyAlpha(this.imageBuf, this.alpha);
            }
        } else {
            this.fbuf = this.data2fa(this.data, this.ndata, this.fbuf, 0, this.MP.mode);
            if (this.isPipeWithCuts()) {
                for (int i = 0; i < this.ndata; i += this.frame) {
                    this.MP.archivedFrames[this.MP.archivedFramesWriteIdx++] = this.ndata - i < this.frame ? Arrays.copyOfRange(this.fbuf, i, this.ndata) : Arrays.copyOfRange(this.fbuf, i, i + this.frame);
                    this.MP.archivedFramesWriteIdx %= this.size;
                }
            }
        }
        if (this.pf instanceof DataFile) {
            DataFile df = (DataFile)this.pf;
            if (this.timeLineSave != df.timeLine) {
                this.timeLineSave = df.timeLine;
                this.indexSave = (double)(this.index + this.mindex * this.pass) / (double)df.ape;
            }
        }
        this.adjustIndex();
        this.awaiting_data = false;
    }

    @Override
    public int getData(int mode) {
        if (this.force_proc_order && !this.awaiting_data) {
            if (this.MP.isPanelVisible() && this.isVisible()) {
                this.MP.refresh(1);
            } else {
                this.draw(1);
            }
        }
        return super.getData(mode);
    }

    @Override
    public void findRange() {
        double t;
        if (this.MP.view == 15) {
            this.findGraphRange();
            return;
        }
        boolean findZ1 = !this.getUseLocalZMin();
        boolean findZ2 = !this.getUseLocalZMax();
        this.x1 = this.xstart - this.xdelta / 2.0;
        this.x2 = this.x1 + (double)this.frame * this.xdelta;
        if (this.x1 > this.x2) {
            t = this.x1;
            this.x1 = this.x2;
            this.x2 = t;
        }
        this.y1 = this.ystart - this.ydelta / 2.0;
        this.y2 = this.y1 + (double)this.size * this.ydelta;
        if (this.y1 > this.y2) {
            t = this.y1;
            this.y1 = this.y2;
            this.y2 = t;
        }
        if (this.MP.mode == 2) {
            this.a1 = -180.0;
            this.a2 = 180.0;
            if (findZ1) {
                this.z1 = this.a1;
            }
            if (findZ2) {
                this.z2 = this.a2;
            }
            return;
        }
        if (this.directColor || this.fbuf == null) {
            if (findZ1) {
                this.z1 = 0.0;
            }
            if (findZ2) {
                this.z2 = 1.0;
            }
            return;
        }
        if (findZ1) {
            this.z1 = this.fbuf[0];
            for (int i = 1; i < this.ndata; ++i) {
                if (!((double)this.fbuf[i] < this.z1)) continue;
                this.z1 = this.fbuf[i];
            }
        }
        if (findZ2) {
            this.z2 = this.fbuf[0];
            for (int i = 1; i < this.ndata; ++i) {
                if (!((double)this.fbuf[i] > this.z2)) continue;
                this.z2 = this.fbuf[i];
            }
        }
        this.autoScale4FindRange(this.z1, this.z2);
    }

    private void findGraphRange() {
        this.x1 = this.xstart - this.xdelta / 2.0;
        this.x2 = this.x1 + (double)this.frame * this.xdelta;
        double xMaxAbs = Math.max(Math.abs(this.x1), Math.abs(this.x2));
        this.x1 = -xMaxAbs;
        this.x2 = xMaxAbs;
        this.y1 = this.ystart - this.ydelta / 2.0;
        this.y2 = this.y1 + (double)this.size * this.ydelta;
        double yMaxAbs = Math.max(Math.abs(this.x1), Math.abs(this.x2));
        this.y1 = -yMaxAbs;
        this.y2 = yMaxAbs;
        if (this.fbuf == null) {
            this.z1 = 0.0;
            this.z2 = 1.0;
            return;
        }
        double zMaxAbs = Math.abs(this.fbuf[0]);
        for (int i = 1; i < this.ndata; ++i) {
            double absZ = Math.abs(this.fbuf[i]);
            if (!(absZ > zMaxAbs)) continue;
            zMaxAbs = absZ;
        }
        this.z1 = -zMaxAbs;
        this.z2 = zMaxAbs;
    }

    @Override
    public void findFullRange() {
        this.findFullRange(this.pf);
    }

    @Override
    public void findFullRange(PlotFile pf) {
        this.fx1 = this.x1;
        this.fx2 = this.x2;
        this.fy1 = this.y1;
        this.fy2 = this.y2;
        this.fz1 = this.z1;
        this.fz2 = this.z2;
        if (pf != null && !this.realtime) {
            this.fy1 = pf.getYStart();
            double fsize = pf.getSize();
            if (pf instanceof DataFile) {
                DataFile df = (DataFile)pf;
                if ((df.flags & 4) != 0) {
                    fsize = df.getOutByte(0) / df.dbpe;
                }
            }
            this.fy2 = this.fy1 + (fsize - 1.0) * pf.getYDelta();
            if (this.fy1 > this.fy2) {
                double t = this.fy1;
                this.fy1 = this.fy2;
                this.fy2 = t;
            }
        }
    }

    public void setCompression(String value) {
        this.compression = Parser.find("None,Max,Min,Avg,Mean,SWMax", value, this.compression, 0, 1);
        this.refresh();
    }

    public String getCompression() {
        return Parser.get("None,Max,Min,Avg,Mean,SWMax", this.compression);
    }

    private void setUse() {
        this.useRaster = (this.stype & 1) != 0;
        this.useContour = (this.stype & 8) != 0;
        boolean bl = this.usePoly = (this.stype & 6) != 0 || !this.MP.is2D;
        if (this.usePoly) {
            this.useRaster = false;
        }
    }

    private boolean recomputeBounds() {
        boolean outofrangeX = false;
        boolean outofrangeY = false;
        if (this.MP.view == 14) {
            double effectiveRx1 = this.MP.rx1;
            double effectiveRx2 = this.MP.rx2;
            if (this.MP.rx2 > (double)MPlot.LONGITUDE_DEFAULT_MAX) {
                effectiveRx2 -= (double)MPlot.LONGITUDE_RANGE;
                effectiveRx1 -= (double)MPlot.LONGITUDE_RANGE;
            }
            if (this.xdelta > 0.0) {
                boolean outofrangeXC;
                double xend = this.xstart + (double)this.frame * this.xdelta;
                outofrangeX = this.xstart > this.MP.rx2 || xend < this.MP.rx1;
                double continuousXstart = this.xstart;
                boolean bl = outofrangeXC = this.xstart > effectiveRx2 || xend < effectiveRx1;
                if (outofrangeX && !outofrangeXC) {
                    continuousXstart += (double)MPlot.LONGITUDE_RANGE;
                }
                outofrangeX &= outofrangeXC;
                this.jx1 = Math.max(this.jx1, (int)((this.MP.rx1 - continuousXstart) / this.xdelta + 0.49));
                this.jx2 = Math.min(this.jx2, (int)((this.MP.rx2 - continuousXstart) / this.xdelta + 1.51));
            } else {
                outofrangeX = this.xstart < this.MP.rx1 || this.xstart + (double)this.frame * this.xdelta > this.MP.rx2;
                this.jx1 = Math.max(this.jx1, (int)((this.MP.rx2 - this.xstart) / this.xdelta + 0.49));
                this.jx2 = Math.min(this.jx2, (int)((this.MP.rx1 - this.xstart) / this.xdelta + 1.51));
            }
            if (this.ydelta > 0.0) {
                outofrangeY = this.ystart > this.MP.ry2 || this.ystart + (double)this.size * this.ydelta < this.MP.ry1;
                this.jy1 = Math.max(this.jy1, (int)((this.MP.ry1 - this.ystart) / this.ydelta + 0.49));
                this.jy2 = Math.min(this.jy2, (int)((this.MP.ry2 - this.ystart) / this.ydelta + 1.51));
            } else {
                outofrangeY = this.ystart < this.MP.ry1 || this.ystart + (double)this.size * this.ydelta > this.MP.ry2;
                this.jy1 = Math.max(this.jy1, (int)((this.MP.ry2 - this.ystart) / this.ydelta + 0.49));
                this.jy2 = Math.min(this.jy2, (int)((this.MP.ry1 - this.ystart) / this.ydelta + 1.51));
            }
            if (this.jx1 < 4) {
                this.jx1 = 0;
            }
            if (this.frame - this.jx2 < 4) {
                this.jx2 = this.frame;
            }
        } else if (this.MP.is2D) {
            if (this.xdelta > 0.0) {
                outofrangeX = this.xstart > this.MP.rx2 || this.xstart + (double)this.frame * this.xdelta < this.MP.rx1;
                this.jx1 = Math.max(this.jx1, (int)((this.MP.rx1 - this.xstart) / this.xdelta + 0.49));
                this.jx2 = Math.min(this.jx2, (int)((this.MP.rx2 - this.xstart) / this.xdelta + 1.51));
            } else {
                outofrangeX = this.xstart < this.MP.rx1 || this.xstart + (double)this.frame * this.xdelta > this.MP.rx2;
                this.jx1 = Math.max(this.jx1, (int)((this.MP.rx2 - this.xstart) / this.xdelta + 0.49));
                this.jx2 = Math.min(this.jx2, (int)((this.MP.rx1 - this.xstart) / this.xdelta + 1.51));
            }
            if (this.ydelta > 0.0) {
                outofrangeY = this.ystart > this.MP.ry2 || this.ystart + (double)this.size * this.ydelta < this.MP.ry1;
                this.jy1 = Math.max(this.jy1, (int)((this.MP.ry1 - this.ystart) / this.ydelta + 0.49));
                this.jy2 = Math.min(this.jy2, (int)((this.MP.ry2 - this.ystart) / this.ydelta + 1.51));
            } else {
                outofrangeY = this.ystart < this.MP.ry1 || this.ystart + (double)this.size * this.ydelta > this.MP.ry2;
                this.jy1 = Math.max(this.jy1, (int)((this.MP.ry2 - this.ystart) / this.ydelta + 0.49));
                this.jy2 = Math.min(this.jy2, (int)((this.MP.ry1 - this.ystart) / this.ydelta + 1.51));
            }
            if (this.jx1 < 4) {
                this.jx1 = 0;
            }
            if (this.frame - this.jx2 < 4) {
                this.jx2 = this.frame;
            }
        }
        if (this.MP.is2D) {
            if (this.MP.xvy) {
                this.ixn = (int)(this.MP.myy * (this.ystart + ((double)(this.index / this.frame) - 0.5) * this.ydelta) + this.MP.myb);
                if (this.MP.myy * this.ydelta < 0.0) {
                    --this.ixn;
                }
            } else {
                this.iyn = (int)(this.MP.myy * (this.ystart + ((double)(this.index / this.frame) - 0.5) * this.ydelta) + this.MP.myb);
                this.iyn = this.MP.myy * this.ydelta < 0.0 ? --this.iyn : ++this.iyn;
            }
        }
        return outofrangeX || outofrangeY;
    }

    public void adjustIndex() {
        if (this.index >= this.mindex) {
            this.index -= this.mindex;
            ++this.pass;
        }
        if (this.isPaged) {
            this.index1 = 0;
            this.index = 0;
        }
        this.index += this.indexAdjust;
        this.indexAdjust = 0;
        int framesLeft = (this.mindex - this.index) / this.frame;
        this.data.size = framesLeft <= 0 || framesLeft >= this.lpb || this.isPaged ? this.lpb : framesLeft;
    }

    @Override
    public void draw(int flag) {
        boolean outofrange;
        boolean scaleZMax;
        super.draw(flag);
        if (this.ndata == 0 && this.index == 0 && this.pass == 0) {
            return;
        }
        double rz1 = this.MP.is2D ? this.MP.rz1 : this.MP.orz1;
        double rz2 = this.MP.is2D ? this.MP.rz2 : this.MP.orz2;
        boolean scaleZMin = this.scaleZ && ((this.MP.scale & 1) != 0 || this.getUseLocalZMin());
        boolean bl = scaleZMax = this.scaleZ && ((this.MP.scale & 2) != 0 || this.getUseLocalZMax());
        if (this.MP.is2D && scaleZMin) {
            rz1 = this.z1;
        }
        if (this.MP.is2D && scaleZMax) {
            rz2 = this.z2;
        }
        boolean forceReread = rz1 != this.lrz1 || rz2 != this.lrz2 || this.compression != this.lcmp || this.reScale;
        this.jx1 = 0;
        this.jx2 = this.frame;
        this.jy1 = 0;
        this.jy2 = this.size;
        if (this.index != this.index1 || this.size == 1 || forceReread) {
            if (this.index1 >= this.mindex) {
                this.index1 -= this.mindex;
            }
            this.jy1 = this.index1 / this.frame;
            this.jy2 = this.jy1 + (this.index - this.index1) / this.frame;
            if (this.cmap == 5) {
                this.scl0 = (float)Math.min(rz1, -rz2);
                this.scl1 = (float)this.ncolors / (-2.0f * this.scl0);
            } else {
                this.scl0 = (float)rz1;
                this.scl1 = (float)((double)this.ncolors / (rz2 - rz1));
            }
            if (this.index == 0) {
                this.loadRasterBuffer(this.index1, this.mindex);
            } else {
                this.loadRasterBuffer(this.index1, this.index);
            }
            this.index1 = this.index;
        } else if (this.ndata == 0 && Tolerance.equalsWithTolerance(this.MP.fry2, this.MP.ory2)) {
            this.jy2 = 0;
        }
        if (flag == 0) {
            this.jy1 = 0;
            this.jy2 = this.size;
        }
        boolean bl2 = outofrange = this.recomputeBounds() && this.MP.view != 14;
        if (this.directColor && this.usePoly) {
            this.warning("Layer2D: 3D not supported with USECOLOR=true");
            outofrange = true;
        }
        if (!outofrange && !this.MP.cancel) {
            if (this.useRaster) {
                this.drawRaster();
            }
            if (this.useContour) {
                this.drawContour();
            }
            if (this.usePoly) {
                this.drawPoly();
            }
            this.awaiting_data = true;
        }
        this.lrz1 = rz1;
        this.lrz2 = rz2;
        this.lcmp = this.compression;
        this.reScale = false;
    }

    protected void loadRasterBuffer(int i, int j) {
        int nc = this.ncolors;
        if (this.buf == null) {
            this.getBuffer();
        }
        if (this.directColor) {
            return;
        }
        if (j > this.buf.length) {
            j = this.buf.length;
        }
        if (this.fbuf == null) {
            return;
        }
        int k = 0;
        while (i < j && i < this.buf.length && k < this.fbuf.length) {
            int b;
            if ((b = (int)((this.fbuf[k++] - this.scl0) * this.scl1)) < 0) {
                b = 0;
            }
            if (++b > nc) {
                b = nc;
            }
            this.buf[i++] = (byte)b;
        }
    }

    private void drawPoly() {
        int kyd;
        int ky2;
        int ky1;
        int kxd;
        int kx2;
        int kx1;
        int i;
        if (this.MP.gc == null) {
            return;
        }
        Graphics gc = this.MP.gc;
        Color mc = new Color(0x505050);
        int[] tx = new int[4];
        int[] ty = new int[4];
        boolean fill = (this.stype & 1) != 0;
        boolean mesh = (this.stype & 2) != 0;
        boolean dots = (this.stype & 4) != 0;
        int tileOrder = 1;
        if (this.pa == null) {
            this.pa = new Pix(this.frame, 1);
        }
        if (this.pb == null) {
            this.pb = new Pix(this.frame, 1);
        }
        if (this.dbuf == null) {
            this.dbuf = new double[this.frame * 3];
        }
        if (this.MP.view == 9) {
            i = 0;
            this.dbuf[i++] = this.xstart;
            this.dbuf[i++] = this.ystart;
            this.dbuf[i++] = 0.0;
            this.dbuf[i++] = this.xstart + (double)(this.frame - 1) * this.xdelta;
            this.dbuf[i++] = this.ystart;
            this.dbuf[i++] = 0.0;
            this.dbuf[i++] = this.xstart + (double)(this.frame - 1) * this.xdelta;
            this.dbuf[i++] = this.ystart + (double)(this.size - 1) * this.ydelta;
            this.dbuf[i++] = 0.0;
            this.dbuf[i++] = this.xstart;
            this.dbuf[i++] = this.ystart + (double)(this.size - 1) * this.ydelta;
            this.dbuf[i++] = 0.0;
            this.MP.viewer.rwc2pix(this.dbuf, 0, 3, 4, this.pa);
            float[] z = this.pa.z;
            if (z[0] <= z[1] && z[0] <= z[2] && z[0] <= z[3]) {
                tileOrder = 1;
            }
            if (z[1] <= z[0] && z[1] <= z[2] && z[1] <= z[3]) {
                tileOrder = 2;
            }
            if (z[2] <= z[0] && z[2] <= z[1] && z[2] <= z[3]) {
                tileOrder = 3;
            }
            if (z[3] <= z[0] && z[3] <= z[1] && z[2] <= z[3]) {
                tileOrder = 4;
            }
        }
        int nx = this.jx2 - this.jx1;
        int ny = this.jy2 - this.jy1;
        if (tileOrder == 1 || tileOrder == 4) {
            kx1 = this.jx1;
            kx2 = this.jx2;
            kxd = 1;
        } else {
            kx1 = this.jx2 - 1;
            kx2 = this.jx1 - 1;
            kxd = -1;
        }
        if (tileOrder == 1 || tileOrder == 2) {
            ky1 = this.jy1;
            ky2 = this.jy2;
            kyd = 1;
        } else {
            ky1 = this.jy2 - 1;
            ky2 = this.jy1 - 1;
            kyd = -1;
        }
        double y = this.ystart + (double)ky1 * this.ydelta;
        int kx = kx1;
        int j = ky1 * this.frame + kx1;
        i = 0;
        while (kx != kx2) {
            this.dbuf[i++] = this.xstart + (double)kx * this.xdelta;
            this.dbuf[i++] = y;
            this.dbuf[i++] = this.fbuf[j];
            kx += kxd;
            j += kxd;
        }
        this.MP.viewer.rwc2pix(this.dbuf, 0, 3, this.frame, this.pa);
        gc.setColor(mc);
        if (mesh) {
            gc.drawPolyline(this.pa.x, this.pa.y, nx);
        }
        int ky = ky1 + kyd;
        int k = 0;
        while (ky != ky2 && !this.MP.cancel) {
            Pix p1;
            Pix p0;
            y = this.ystart + (double)ky * this.ydelta;
            kx = kx1;
            j = ky * this.frame + kx1;
            i = 0;
            while (kx != kx2) {
                int n = ++i;
                this.dbuf[n] = y;
                int n2 = ++i;
                ++i;
                this.dbuf[n2] = this.fbuf[j];
                kx += kxd;
                j += kxd;
            }
            if (k == 0) {
                p0 = this.pa;
                p1 = this.pb;
            } else {
                p0 = this.pb;
                p1 = this.pa;
            }
            this.MP.viewer.rwc2pix(this.dbuf, 0, 3, nx, p1);
            if (fill) {
                j = ky * this.frame + kx1;
                i = 0;
                while (i < nx - 1) {
                    tx[0] = p0.x[i];
                    tx[1] = p0.x[i + 1];
                    tx[2] = p1.x[i + 1];
                    tx[3] = p1.x[i];
                    ty[0] = p0.y[i];
                    ty[1] = p0.y[i + 1];
                    ty[2] = p1.y[i + 1];
                    ty[3] = p1.y[i];
                    if (this.MP.view != 13 || tx[0] != 0 && tx[1] != 0 && tx[2] != 0 && tx[3] != 0) {
                        gc.setColor(this.colors[this.buf[j]]);
                        gc.fillPolygon(tx, ty, 4);
                    }
                    ++i;
                    j += kxd;
                }
            }
            if (mesh) {
                gc.setColor(mc);
                gc.drawPolyline(p1.x, p1.y, nx);
                for (i = 0; i < nx; ++i) {
                    gc.drawLine(p0.x[i], p0.y[i], p1.x[i], p1.y[i]);
                }
            }
            ky += kyd;
            k = 1 - k;
        }
    }

    private void drawContour() {
        if (this.ndata <= 0) {
            return;
        }
        float[] ftmp = new float[4];
        Line lin = this.line.copy();
        if (this.contour == null) {
            this.contour = new Contour();
            this.contour.setXAxis(this.xstart, this.xdelta, this.frame);
            this.contour.setYAxis(this.ystart, this.ydelta, this.size);
        }
        this.contour.setBounds(this.jx1, this.jy1, this.jx2, this.jy2);
        for (int ic = 0; ic < this.ncolors && !this.MP.cancel; ++ic) {
            lin.setColor(this.colors[ic + 1]);
            double z = this.scl0 + (float)ic / this.scl1;
            this.contour.setZAxis(z, z, 1);
            this.contour.process(this.fbuf);
            float[] fout = this.contour.out;
            int j = 0;
            while (j < this.contour.nout && !this.MP.cancel) {
                int k;
                block10: {
                    int npts;
                    block11: {
                        block9: {
                            npts = (int)fout[j++];
                            int ncol = (int)fout[j++];
                            k = j + (2 + npts) * 2;
                            if (!this.MP.is2D) break block9;
                            if ((double)fout[j++] >= this.MP.rx2) break block10;
                            if ((double)fout[j++] >= this.MP.ry2) break block10;
                            if ((double)fout[j++] <= this.MP.rx1) break block10;
                            int n = j++;
                            if (!((double)fout[n] <= this.MP.ry1)) break block11;
                            break block10;
                        }
                        int i = this.MP.viewer.rwc2pix(fout, j, 2, 2, this.MP.tpix);
                        if (i == 0) {
                            ftmp[0] = fout[j];
                            ftmp[1] = fout[j + 3];
                            ftmp[2] = fout[j + 2];
                            ftmp[3] = fout[j + 1];
                            i = this.MP.viewer.rwc2pix(ftmp, 0, 2, 2, this.MP.tpix);
                        }
                        j += 4;
                        if (i == 0) break block10;
                    }
                    this.MP.drawLine(fout, j, 2, npts, lin);
                }
                j = k;
            }
        }
    }

    private void getImage() {
        int height;
        int width;
        if (this.MP.xvy) {
            width = this.lpi;
            height = this.frame;
        } else {
            width = this.frame;
            height = this.lpi;
        }
        this.mimage = this.directColor ? new MImage(this.MP, width, height, this.imageBufv) : new MImage(this.MP, width, height, this.bufv, this.colors);
        this.xvy = this.MP.xvy;
    }

    protected void getBuffer() {
        this.buf = new byte[this.frame * this.size];
        if (this.directColor) {
            this.imageBufv = new int[this.frame * this.lpi];
            this.cmpbufv = new int[this.frame];
        } else {
            this.bufv = new byte[this.frame * this.lpi];
            this.cmpbuf = new byte[this.frame];
        }
    }

    private void checkYCompression(int ycmp) {
        if (this.yCompressionWarn && ycmp > this.lpi && !this.realtime) {
            this.yCompressionWarn = false;
            this.warning("Y-compression [" + ycmp + "] > /LPB [" + this.lpi + "] which may cause data not to appear.");
        }
    }

    private void drawRaster() {
        boolean cmp;
        if (this.MP.gc == null) {
            return;
        }
        boolean bl = cmp = this.compression != 1;
        if (this.buf == null) {
            this.getBuffer();
        }
        if (this.mimage == null) {
            this.getImage();
        }
        int l_frame = this.frame;
        byte[] l_buf = this.buf;
        byte[] l_bufv = this.bufv;
        int[] l_imageBuf = this.imageBuf;
        int[] l_imageBufv = this.imageBufv;
        int l_jx1 = this.jx1;
        int l_jx2 = this.jx2;
        int l_jy1 = this.jy1;
        int l_jy2 = this.jy2;
        int l_bufLen = l_buf != null ? l_buf.length : 0;
        int l_bufvLen = l_bufv != null ? l_bufv.length : 0;
        int l_imageBufLen = l_imageBuf != null ? l_imageBuf.length : 0;
        int l_imageBufvLen = l_imageBufv != null ? l_imageBufv.length : 0;
        this.MP.setColor(this.MP.theme.cfg);
        int xcmp = (int)(Math.abs(1.0 / (this.MP.mxx * this.xdelta)) + 0.95);
        int ycmp = (int)(Math.abs(1.0 / (this.MP.myy * this.ydelta)) + 0.95);
        this.checkYCompression(ycmp);
        int l_lpi = this.lpi;
        if (this.MP.is2D) {
            if (this.MP.xvy) {
                int jyd;
                int iy1 = (int)(this.MP.mxx * (this.xstart + ((double)l_jx1 - 0.5) * this.xdelta) + this.MP.mxb);
                int iy2 = (int)(this.MP.mxx * (this.xstart + ((double)l_jx2 - 0.5) * this.xdelta) + this.MP.mxb);
                cmp = cmp && (xcmp > 1 || ycmp > 1);
                for (int jy = l_jy1; jy < l_jy2; jy += jyd) {
                    jyd = l_jy2 - jy;
                    if (jyd > l_lpi) {
                        jyd = l_lpi;
                    }
                    int ix1 = (int)(this.MP.myy * (this.ystart + ((double)jy - 0.5) * this.ydelta) + this.MP.myb);
                    int ix2 = (int)(this.MP.myy * (this.ystart + ((double)(jy + jyd) - 0.5) * this.ydelta) + this.MP.myb);
                    if (cmp) {
                        if (this.directColor) {
                            this.compressInt(l_imageBuf, jy * l_frame, l_imageBufv, 0, l_frame, jyd, xcmp, ycmp, this.MP.xvy);
                        } else {
                            this.compressByte(l_buf, jy * l_frame, l_bufv, 0, l_frame, jyd, xcmp, ycmp, this.MP.xvy);
                        }
                    } else {
                        this.transpose(jyd, jy);
                    }
                    this.mimage.source.newPixels(0, 0, jyd, l_frame);
                    this.drawImage(this.mimage.image, ix1, iy1, ix2, iy2, 0, l_jx1, jyd, l_jx2, xcmp, ycmp, this.mimage);
                }
                if (this.realtime && this.index != 0 && this.ixn > this.MP.ix1 && this.ixn < this.MP.ix2 - 1) {
                    int i1 = Math.max(this.MP.iy1, Math.min(iy1, iy2));
                    int i2 = Math.min(this.MP.iy2, Math.max(iy1, iy2));
                    this.MP.gc.drawLine(this.ixn, i1 + 1, this.ixn, i2 - 2);
                }
            } else {
                int jyd;
                int ix1 = (int)(this.MP.mxx * (this.xstart + ((double)l_jx1 - 0.5) * this.xdelta) + this.MP.mxb);
                int ix2 = (int)(this.MP.mxx * (this.xstart + ((double)l_jx2 - 0.5) * this.xdelta) + this.MP.mxb);
                if (this.realtime) {
                    ycmp = 1;
                }
                cmp = cmp && (xcmp > 1 || ycmp > 1);
                for (int jy = l_jy1; jy < l_jy2; jy += jyd) {
                    int copyLength;
                    int maxCopyLen;
                    int maxSrcCopyLen;
                    int srcPos;
                    jyd = l_jy2 - jy;
                    if (jyd > l_lpi) {
                        jyd = l_lpi;
                    }
                    int iy1 = (int)(this.MP.myy * (this.ystart + ((double)jy - 0.5) * this.ydelta) + this.MP.myb);
                    int iy2 = (int)(this.MP.myy * (this.ystart + ((double)(jy + jyd) - 0.5) * this.ydelta) + this.MP.myb);
                    if (this.directColor) {
                        if (cmp) {
                            this.compressInt(l_imageBuf, jy * l_frame, l_imageBufv, 0, l_frame, jyd, xcmp, ycmp, this.MP.xvy);
                        } else {
                            srcPos = jy * l_frame;
                            maxSrcCopyLen = l_imageBufLen - srcPos;
                            maxCopyLen = Math.min(maxSrcCopyLen, l_imageBufvLen);
                            copyLength = Math.min(jyd * l_frame, maxCopyLen);
                            System.arraycopy(l_imageBuf, srcPos, l_imageBufv, 0, copyLength);
                        }
                    } else if (cmp) {
                        this.compressByte(l_buf, jy * l_frame, l_bufv, 0, l_frame, jyd, xcmp, ycmp, this.MP.xvy);
                    } else {
                        copyLength = jyd * l_frame;
                        srcPos = jy * l_frame;
                        maxSrcCopyLen = l_bufLen - srcPos;
                        maxCopyLen = Math.min(maxSrcCopyLen, l_bufvLen);
                        if (copyLength > maxCopyLen) {
                            copyLength = maxCopyLen;
                            this.warning("Avoiding ArrayIndexOutOfBounds in Layer2D.drawRaster bufLen:" + l_bufLen + " bufvLen:" + l_bufvLen + " l_frame:" + l_frame + " jy:" + jy + " jyd:" + jyd + " lpi:" + l_lpi + " jy1:" + l_jy1 + " jy2:" + l_jy2 + " index:" + this.index + " index1:" + this.index1 + " mindex:" + this.mindex);
                        }
                        System.arraycopy(l_buf, srcPos, l_bufv, 0, copyLength);
                    }
                    this.mimage.source.newPixels(0, 0, l_frame, jyd);
                    if (l_jx1 > l_jx2 && this.MP.view != 14) continue;
                    this.drawImage(this.mimage.image, ix1, iy1, ix2, iy2, l_jx1, 0, l_jx2, jyd, xcmp, ycmp, this.mimage);
                }
                if (this.realtime && this.index != 0 && this.iyn > this.MP.iy1 && this.iyn < this.MP.iy2 - 1) {
                    int i1 = Math.max(this.MP.ix1, Math.min(ix1, ix2));
                    int i2 = Math.min(this.MP.ix2, Math.max(ix1, ix2));
                    this.MP.gc.drawLine(i1 + 1, this.iyn, i2 - 2, this.iyn);
                }
            }
        }
    }

    protected boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, int xcmp, int ycmp, ImageObserver observer) {
        if (this.MP.view == 14) {
            MPoint point = new MPoint();
            MPoint point2 = new MPoint();
            double[] rwc1 = new double[3];
            double[] rwc2 = new double[3];
            point.x = dx1;
            point.y = dy1;
            point2.x = dx2;
            point2.y = dy2;
            this.MP.viewer.pix2rwc(point, rwc1);
            this.MP.viewer.pix2rwc(point2, rwc2);
            double xstartToUse = this.xstart > 180.0 ? this.xstart - (double)MPlot.LONGITUDE_RANGE : this.xstart;
            this.MP.drawImage(GraphicsUtil.toBufferedImage(this.mimage.image), rwc1[1], rwc2[1], xstartToUse + this.xdelta * (double)this.mimage.w, xstartToUse);
            return true;
        }
        return this.MP.gc.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    private void transpose(int jyd, int jy) {
        int l_lpi = this.lpi;
        int l_frame = this.frame;
        byte[] l_buf = this.buf;
        byte[] l_bufv = this.bufv;
        int[] l_imageBuf = this.imageBuf;
        int[] l_imageBufv = this.imageBufv;
        int jyf = jy * l_frame;
        for (int i = 0; i < l_frame; ++i) {
            int ko = i * l_lpi;
            int ki = jyf + i;
            int j = 0;
            while (j < jyd) {
                if (this.directColor) {
                    l_imageBufv[ko] = l_imageBuf[ki];
                } else {
                    l_bufv[ko] = l_buf[ki];
                }
                ++j;
                ki += l_frame;
                ++ko;
            }
        }
    }

    private void compressByte(byte[] buf, int boff, byte[] bufv, int bvoff, int nx, int ny, int icmp, int jcmp, boolean transpose) {
        int l_lpi = this.lpi;
        byte[] l_cmpbuf = this.cmpbuf;
        int imid = icmp >> 1;
        if (icmp < 1) {
            icmp = 1;
        }
        if (icmp > nx) {
            if (this.compressByteWarn++ % 100 == 0) {
                this.warning("compressByte() icmp(" + icmp + ") > nx (" + nx + "), resetting to nx. count=" + this.compressByteWarn);
            }
            icmp = nx;
        }
        switch (this.compression) {
            case 2: {
                int idx;
                int ncells;
                byte bm;
                int maxIndex;
                int off;
                for (int iy = 0; iy < ny; ++iy) {
                    off = iy * nx + boff;
                    maxIndex = Math.min(off + nx, buf.length);
                    for (int ix = off; ix < maxIndex; ix += icmp) {
                        bm = buf[ix];
                        ncells = ix + icmp > maxIndex ? maxIndex - ix : icmp;
                        for (int i = ix + 1; i < ix + ncells; ++i) {
                            if (buf[i] <= bm) continue;
                            bm = buf[i];
                        }
                        idx = transpose ? (ix - off) * l_lpi + iy : ix - boff;
                        bufv[idx] = bm;
                    }
                }
                if (jcmp > 1) {
                    int iy_block_inc;
                    int y_inc;
                    int ycmp = Math.min(ny, jcmp);
                    boolean firstycmp = false;
                    if (jcmp > this.lpi) {
                        if (this.cmpLeft > 0) {
                            this.cmpLeft -= ycmp;
                        } else {
                            this.cmpLeft = jcmp - ycmp;
                            firstycmp = true;
                        }
                    }
                    if (transpose) {
                        y_inc = 1;
                        iy_block_inc = ycmp;
                    } else {
                        y_inc = nx;
                        iy_block_inc = nx * ycmp;
                    }
                    for (int ix = 0; ix < nx; ix += icmp) {
                        if (transpose) {
                            off = ix * l_lpi;
                            maxIndex = off + l_lpi;
                        } else {
                            off = ix;
                            maxIndex = nx * ny;
                        }
                        if (firstycmp) {
                            l_cmpbuf[ix] = bufv[off];
                        }
                        for (int iy = off; iy < maxIndex; iy += iy_block_inc) {
                            bm = bufv[iy];
                            ncells = 1;
                            if (this.cmpLeft > 0 && l_cmpbuf[ix] > bm) {
                                bm = l_cmpbuf[ix];
                            }
                            int ii = iy + y_inc;
                            while (ii < iy + iy_block_inc && ii < maxIndex) {
                                if (bufv[ii] > bm) {
                                    bm = bufv[ii];
                                }
                                ii += y_inc;
                                ++ncells;
                            }
                            ii = iy;
                            for (int jj = 0; jj < ncells; ++jj) {
                                bufv[ii] = bm;
                                ii += y_inc;
                            }
                            if (ncells < ycmp) {
                                int moreCells = ycmp - ncells + 1;
                                if (bm > bufv[iy - y_inc]) {
                                    for (int ii2 = iy - y_inc * moreCells; ii2 < iy; ii2 += y_inc) {
                                        bufv[ii2] = bm;
                                    }
                                }
                            }
                            if (this.cmpLeft <= 0 || l_cmpbuf[ix] >= bm) continue;
                            l_cmpbuf[ix] = bm;
                        }
                    }
                }
                int x_inc = transpose ? l_lpi : 1;
                for (int iy = 0; iy < ny; ++iy) {
                    off = iy * nx;
                    maxIndex = off + nx;
                    for (int ix = off; ix < maxIndex; ix += icmp) {
                        idx = transpose ? (ix - off) * l_lpi + iy : ix;
                        bm = bufv[idx];
                        ncells = ix + icmp > maxIndex ? maxIndex - ix : icmp;
                        for (int ii = idx + x_inc; ii < idx + ncells * x_inc; ii += x_inc) {
                            bufv[ii] = bm;
                        }
                        if (ncells >= icmp) continue;
                        int moreCells = icmp - ncells + 1;
                        if (bm <= bufv[idx - x_inc]) continue;
                        for (int ii = idx - moreCells * x_inc; ii < idx; ii += x_inc) {
                            bufv[ii] = bm;
                        }
                    }
                }
                break;
            }
            case 6: {
                for (int iy = 0; iy < ny; ++iy) {
                    int ix;
                    int off = iy * nx;
                    byte bm = buf[off + boff];
                    for (ix = off; ix < off + imid; ++ix) {
                        bufv[ix] = buf[ix + boff];
                    }
                    for (ix = off + imid + 1; ix < off + nx - imid; ++ix) {
                        byte b1 = buf[boff + ix - imid - 1];
                        byte b2 = buf[boff + ix + imid];
                        if (b2 >= bm) {
                            bm = b2;
                        } else if (b1 >= bm) {
                            int i = boff + ix - imid;
                            bm = buf[i];
                            ++i;
                            while (i <= boff + ix + imid) {
                                if (buf[i] > bm) {
                                    bm = buf[i];
                                }
                                ++i;
                            }
                        }
                        bufv[ix] = bm;
                    }
                    for (ix = off + nx - imid; ix < off + nx; ++ix) {
                        bufv[ix] = buf[ix + boff];
                    }
                }
                break;
            }
        }
    }

    private void compressInt(int[] buf, int boff, int[] bufv, int bvoff, int nx, int ny, int icmp, int jcmp, boolean transpose) {
        int l_lpi = this.lpi;
        int[] l_cmpbufv = this.cmpbufv;
        int imid = icmp >> 1;
        if (icmp < 1) {
            icmp = 1;
        }
        if (icmp > nx) {
            if (this.compressIntWarn++ % 100 == 0) {
                this.warning("compressInt() icmp(" + icmp + ") > nx (" + nx + "), resetting to nx. count=" + this.compressIntWarn);
            }
            icmp = nx;
        }
        switch (this.compression) {
            case 2: {
                int idx;
                int ncells;
                int bm;
                int maxIndex;
                int off;
                for (int iy = 0; iy < ny; ++iy) {
                    off = iy * nx + boff;
                    maxIndex = Math.min(off + nx, buf.length);
                    for (int ix = off; ix < maxIndex; ix += icmp) {
                        bm = buf[ix];
                        ncells = ix + icmp > maxIndex ? maxIndex - ix : icmp;
                        for (int i = ix + 1; i < ix + ncells; ++i) {
                            if (buf[i] <= bm) continue;
                            bm = buf[i];
                        }
                        idx = transpose ? (ix - off) * l_lpi + iy : ix - boff;
                        bufv[idx] = bm;
                    }
                }
                if (jcmp > 1) {
                    int iy_block_inc;
                    int y_inc;
                    int ycmp = Math.min(ny, jcmp);
                    boolean firstycmp = false;
                    if (jcmp > l_lpi) {
                        if (this.cmpLeft > 0) {
                            this.cmpLeft -= ycmp;
                        } else {
                            this.cmpLeft = jcmp - ycmp;
                            firstycmp = true;
                        }
                    }
                    if (transpose) {
                        y_inc = 1;
                        iy_block_inc = ycmp;
                    } else {
                        y_inc = nx;
                        iy_block_inc = nx * ycmp;
                    }
                    for (int ix = 0; ix < nx; ix += icmp) {
                        if (transpose) {
                            off = ix * l_lpi;
                            maxIndex = off + l_lpi;
                        } else {
                            off = ix;
                            maxIndex = nx * ny;
                        }
                        if (firstycmp) {
                            l_cmpbufv[ix] = bufv[off];
                        }
                        for (int iy = off; iy < maxIndex; iy += iy_block_inc) {
                            bm = bufv[iy];
                            ncells = 1;
                            if (this.cmpLeft > 0 && l_cmpbufv[ix] > bm) {
                                bm = l_cmpbufv[ix];
                            }
                            int ii = iy + y_inc;
                            while (ii < iy + iy_block_inc && ii < maxIndex) {
                                if (bufv[ii] > bm) {
                                    bm = bufv[ii];
                                }
                                ii += y_inc;
                                ++ncells;
                            }
                            ii = iy;
                            for (int jj = 0; jj < ncells; ++jj) {
                                bufv[ii] = bm;
                                ii += y_inc;
                            }
                            if (ncells < ycmp) {
                                int moreCells = ycmp - ncells + 1;
                                if (bm > bufv[iy - y_inc]) {
                                    for (int ii2 = iy - y_inc * moreCells; ii2 < iy; ii2 += y_inc) {
                                        bufv[ii2] = bm;
                                    }
                                }
                            }
                            if (this.cmpLeft <= 0 || l_cmpbufv[ix] >= bm) continue;
                            l_cmpbufv[ix] = bm;
                        }
                    }
                }
                int x_inc = transpose ? l_lpi : 1;
                for (int iy = 0; iy < ny; ++iy) {
                    off = iy * nx;
                    maxIndex = off + nx;
                    for (int ix = off; ix < maxIndex; ix += icmp) {
                        idx = transpose ? (ix - off) * l_lpi + iy : ix;
                        bm = bufv[idx];
                        ncells = ix + icmp > maxIndex ? maxIndex - ix : icmp;
                        for (int ii = idx + x_inc; ii < idx + ncells * x_inc; ii += x_inc) {
                            bufv[ii] = bm;
                        }
                        if (ncells >= icmp) continue;
                        int moreCells = icmp - ncells + 1;
                        if (bm <= bufv[idx - x_inc]) continue;
                        for (int ii = idx - moreCells * x_inc; ii < idx; ii += x_inc) {
                            bufv[ii] = bm;
                        }
                    }
                }
                break;
            }
            case 6: {
                for (int iy = 0; iy < ny; ++iy) {
                    int ix;
                    int off = iy * nx;
                    int bm = buf[off + boff];
                    for (ix = off; ix < off + imid; ++ix) {
                        bufv[ix] = buf[ix + boff];
                    }
                    for (ix = off + imid + 1; ix < off + nx - imid; ++ix) {
                        int b1 = buf[boff + ix - imid - 1];
                        int b2 = buf[boff + ix + imid];
                        if (b2 >= bm) {
                            bm = b2;
                        } else if (b1 >= bm) {
                            int i = boff + ix - imid;
                            bm = buf[i];
                            ++i;
                            while (i <= boff + ix + imid) {
                                if (buf[i] > bm) {
                                    bm = buf[i];
                                }
                                ++i;
                            }
                        }
                        bufv[ix] = bm;
                    }
                    for (ix = off + nx - imid; ix < off + nx; ++ix) {
                        bufv[ix] = buf[ix + boff];
                    }
                }
                break;
            }
        }
    }

    @Override
    public String getReadOut(Position mp) {
        if (this.realtime) {
            return null;
        }
        int jx = (int)Math.round((mp.x - this.xstart) / this.xdelta);
        if (jx < 0 || jx >= this.frame) {
            return null;
        }
        int jy = (int)Math.round((mp.y - this.ystart) / this.ydelta);
        if (jy < 0 || jy >= this.size) {
            return null;
        }
        StringBuilder sb = new StringBuilder(this.name);
        sb.append(" (z=");
        double dz = 1.0f / this.scl1;
        if (this.useRaster && (this.buf != null || this.directColor && this.imageBuf != null)) {
            int i = jy * this.frame + jx;
            if (this.directColor && i < this.imageBuf.length) {
                sb.append("0x").append(Integer.toHexString(this.imageBuf[i]));
            } else if (i < this.buf.length) {
                int b = this.buf[i];
                if (b < 0) {
                    b += 256;
                }
                double z = (float)b / this.scl1 + this.scl0;
                sb.append(this.MP.formNumber(z, 0, 0));
            }
        }
        sb.append(' ').append('\u00b1').append(' ');
        sb.append(this.MP.formNumber(dz, 0, 0)).append(")");
        return sb.toString();
    }

    @Override
    protected Position getPosition(int px, int py, Position p) {
        super.getPosition(px, py, p);
        p.z = this.getZAtPos(p);
        return p;
    }

    public double getZAtPos(Position mp) {
        if (this.realtime) {
            return Double.NaN;
        }
        int jx = (int)Math.round((mp.x - this.xstart) / this.xdelta);
        if (jx < 0 || jx >= this.frame) {
            return Double.NaN;
        }
        int jy = (int)Math.round((mp.y - this.ystart) / this.ydelta);
        if (jy < 0 || jy >= this.size) {
            return Double.NaN;
        }
        double z = 0.0;
        if (this.useRaster && (this.buf != null || this.directColor && this.imageBuf != null)) {
            int i = jy * this.frame + jx;
            if (this.directColor && i < this.imageBuf.length) {
                z = this.imageBuf[i];
            } else if (i < this.buf.length) {
                int b = this.buf[i];
                if (b < 0) {
                    b += 256;
                }
                z = (float)b / this.scl1 + this.scl0;
            }
        }
        return z;
    }

    private int getPixHeight() {
        return this.MP.xvy ? this.MP.ix2 - this.MP.ix1 : this.MP.iy2 - this.MP.iy1;
    }

    private double getPixPerFrame() {
        double min = this.MP.xvy ? this.MP.getry(this.MP.ix1, 0) : this.MP.getry(0, this.MP.iy1);
        double max = this.MP.xvy ? this.MP.getry(this.MP.ix2, 0) : this.MP.getry(0, this.MP.iy2);
        double pps = (double)this.getPixHeight() / (max - min);
        return pps * this.pf.getDelta();
    }

    @Override
    public double getTime(int px, int py) {
        double timeAt;
        if (!this.MP.is2D) {
            return Double.NaN;
        }
        this.recomputeBounds();
        if (this.MP.xvy && (px > this.MP.ix2 || px < this.MP.ix1) || py > this.MP.iy2 || py < this.MP.iy1) {
            return 0.0;
        }
        if (this.realtime) {
            double frames = (double)(this.MP.xvy ? this.ixn - px : this.iyn - py) / this.getPixPerFrame();
            if (frames < 0.0) {
                frames += (double)this.size;
            }
            timeAt = this.pf.getTimeAt(-frames);
        } else {
            double frames = Math.round(((double)(this.MP.xvy ? px : py) - this.MP.myb - this.ystart * this.MP.myy) / this.getPixPerFrame());
            if (frames < 0.0) {
                frames = 0.0;
            }
            timeAt = this.pf.getTimeAt(frames);
        }
        if (this.xIsTime) {
            timeAt += this.MP.getrx(px, py);
        }
        return timeAt;
    }

    @Override
    @Deprecated
    public double getYPosAtTime(double time) {
        return this.getPosAtTime(time);
    }

    @Override
    public double getPosAtTime(double time) {
        DataFile df = (DataFile)this.pf;
        int myPass = this.pass;
        int myIndex = this.index;
        if (this.index == 0 && myPass > 0) {
            --myPass;
            myIndex = this.mindex;
        }
        double thisIndex = df.getIndexAt(time) + this.indexSave;
        if (this.realtime && (thisIndex -= (double)(this.mindex * myPass / df.ape)) < 0.0 && thisIndex + (double)this.size > (double)(myIndex / df.ape)) {
            thisIndex += (double)this.size;
        }
        return thisIndex * df.getYDelta();
    }

    @Deprecated
    public void underlay(Layer2D prev) {
        this.index = this.frame * Math.min(this.size - 1, prev.index / prev.frame);
        this.pass = prev.pass;
        if (prev.mimage != null) {
            if (this.buf == null) {
                this.getBuffer();
            }
            if (this.mimage == null) {
                this.getImage();
            }
            double factor = (double)prev.frame / (double)this.frame;
            int jmax = prev.mindex - 1;
            for (int i = 0; i < this.mindex; ++i) {
                int j = Math.min(jmax, (int)(0.5 + (double)i * factor));
                this.buf[i] = prev.buf[j];
            }
        }
        this.index1 = this.index;
    }

    protected static boolean isDirectColorSupported(String format) {
        return format.equals("SL") || format.equals("QB");
    }

    public boolean isDirectColor() {
        return this.directColor;
    }

    public void setDirectColor(boolean useColor) {
        if (this.directColor != useColor) {
            if (!useColor || Layer2D.isDirectColorSupported(this.data.getFormat())) {
                this.directColor = useColor;
                this.clear();
                this.reread();
            } else {
                this.warning("Layer2D: format " + this.data.getFormat() + " NOT supported for DirectColor mode");
            }
        }
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        if (this.alpha != alpha) {
            this.alpha = alpha;
            if (this.directColor && alpha >= 0 && this.imageBuf != null) {
                MColor.applyAlpha(this.imageBuf, alpha);
                this.refresh();
            } else if (this.colors != null) {
                int a = (alpha & 0xFF) << 24;
                for (int i = 1; i < this.colors.length; ++i) {
                    int argb = a | this.colors[i].getRGB() & 0xFFFFFF;
                    this.colors[i] = new Color(argb, true);
                }
                if (this.mimage != null) {
                    this.mimage.setColors(this.colors);
                }
                this.refresh();
            }
        }
    }

    public void drawLegend(MBox pos, Graphics g) {
        int nc = this.colors.length;
        double scale = (double)nc / (double)pos.w;
        int iy1 = pos.y;
        int iy2 = pos.y + pos.h - 1;
        for (int i = 0; i < pos.w; ++i) {
            int j = (int)(scale * (double)i);
            g.setColor(this.colors[j]);
            int ix = pos.x + i;
            g.drawLine(ix, iy1, ix, iy2);
        }
    }

    @InternalUseOnly
    public boolean isPipeWithCuts() {
        return this.MP.isActingBaseLayer(this) && this.MP.getCutsSwitchOnForPipedLayer2D() && !this.directColor && ((DataFile)this.pf).isPipe();
    }

    @InternalUseOnly
    public Data[] getDataElementsForPipeCut2D(char cutType, double xOry) {
        float[] archivedFrameRow;
        if (cutType == 'X') {
            double y = xOry;
            double relativeYPer = (y - this.MP.ory1) / (this.MP.ory2 - this.MP.ory1);
            double pixelWidthPerLine = (double)this.MP.iy21 / (double)this.getSize();
            int row = (int)(relativeYPer * (double)this.MP.iy21 / pixelWidthPerLine);
            if (row == this.MP.archivedFrames.length) {
                --row;
            }
            float[] archivedFrameRow2 = this.MP.archivedFrames[row];
            Data[] elements = new Data[archivedFrameRow2.length];
            for (int col = 0; col < archivedFrameRow2.length; ++col) {
                elements[col] = new Data(archivedFrameRow2[col]);
            }
            return elements;
        }
        double x = xOry;
        double relativeXPer = (x - this.MP.orx1) / (this.MP.orx2 - this.MP.orx1);
        ArrayList<Data> arrListData = new ArrayList<Data>(this.MP.archivedFrames.length);
        for (int row = 0; row < this.MP.archivedFrames.length && (archivedFrameRow = this.MP.archivedFrames[row]) != null; ++row) {
            int col = (int)(relativeXPer * (double)archivedFrameRow.length);
            if (col == archivedFrameRow.length) {
                --col;
            }
            arrListData.add(new Data(archivedFrameRow[col]));
        }
        arrListData.trimToSize();
        Data[] elements = new Data[arrListData.size()];
        elements = arrListData.toArray(elements);
        return elements;
    }
}

