/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Font;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import nxm.sys.inc.Chainable;
import nxm.sys.inc.Drawable;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.PlotFile;
import nxm.sys.inc.PlotFileNH;
import nxm.sys.lib.Args;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.LogUtilities;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Position;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libg.Feature;
import nxm.sys.libg.FeatureGroup;
import nxm.sys.libg.FeatureGroupMap;
import nxm.sys.libg.GLegend;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPrompt;
import nxm.sys.libg.GQuery;
import nxm.sys.libg.LayerUtil;
import nxm.sys.libg.Line;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MJPopup;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.SlidingMinMax;
import nxm.sys.libg.Symbol;
import nxm.sys.prim.plot;

public class Layer
implements MessageHandler,
Chainable,
Drawable,
MidasReference {
    public static final String configureList = "Rename,Delete,Enable,Scale,Line,Symbol,Surface,Feature,Color,Colors,ColorMap,Query,Effects";
    private static final String colorMapList = "GrayScale,Ramp,XRamp,Wheel,Terrain,Multi,T5Layer,MapLine,Grid,Spectrum,XDatalist,Custom";
    static double threeDGraphMarginFactor = 1.25;
    public static final String effectsList = "InvertColors,ReverseColors";
    public static final int E_INVERT_COLORS = 1;
    public static final int E_REVERSE_COLORS = 2;
    public static final int DEF_EFFECTS = 0;
    private String label;
    private static final int LOCAL_XMIN = 1;
    private static final int LOCAL_XMAX = 2;
    private static final int MPLOT_XMIN = 16;
    private static final int MPLOT_XMAX = 32;
    private static final int MPLOT_X = 192;
    private static final int LOCAL_YMIN = 256;
    private static final int LOCAL_YMAX = 512;
    private static final int MPLOT_YMIN = 4096;
    private static final int MPLOT_YMAX = 8192;
    private static final int MPLOT_Y = 49152;
    private static final int LOCAL_ZMIN = 65536;
    private static final int LOCAL_ZMAX = 131072;
    private static final int MPLOT_ZMIN = 0x100000;
    private static final int MPLOT_ZMAX = 0x200000;
    private static final int MPLOT_Z = 0xC00000;
    @InternalUseOnly
    public static final int RR_DISABLED = 0;
    @InternalUseOnly
    public static final int RR_AUTO = -1;
    @InternalUseOnly
    public static final int RR_DISABLED_BUT_CALC_STATS = -2;
    private static final int DEF_RR_AUTO_REFRESH_RATE = 30;
    private static final float DEF_RR_SMOOTHING_FACTOR = 0.1f;
    private static final int DEF_RR_MAX_SKIP_MULTIPLIER = 2;
    @InternalUseOnly(value="since 3.3.3, will become protected in 3.7+")
    public int ndata;
    @InternalUseOnly(value="since 3.3.3, will become protected in 3.7+ (instead use getFrame()")
    public int frame;
    @InternalUseOnly(value="since 3.3.3, will become protected in 3.7+ (instead use getSize()")
    public int size;
    @InternalUseOnly(value="since 3.3.3, will become protected in 3.7+ (instead use getScale()")
    public int scaleable = 15;
    @InternalUseOnly(value="since 3.3.3, will become protected in 3.7+ (instead use getEnable()")
    public int enable = 255;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use getXStart(), setXStart()")
    public double xstart;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use getXDelta(), setXDelta()")
    public double xdelta;
    private int xunits;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use getYStart(), setYStart()")
    public double ystart;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use getYDelta(), setYDelta()")
    public double ydelta;
    private int yunits;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use getZStart(), setZStart()")
    public double zstart;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use getZDelta(), setZDelta()")
    public double zdelta;
    private int zunits;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public double time;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public double fseek;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use getX1(), setX1()")
    public double x1 = 0.0;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use getX2(), setX2()")
    public double x2 = 1.0;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use getY1(), setY1()")
    public double y1 = 0.0;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use getY2(), setY2()")
    public double y2 = 1.0;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use getZ1(), setZ1()")
    public double z1 = 0.0;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use getZ2(), setZ2()")
    public double z2 = 1.0;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use getZDelta(), setZDelta()")
    public double zd = 0.1;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public double a1 = 0.0;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public double a2 = 0.0;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public double fx1 = 0.0;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public double fx2 = 1.0;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public double fy1 = 0.0;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public double fy2 = 1.0;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public double fz1 = 0.0;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public double fz2 = 1.0;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public boolean realtime;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use isPaged()")
    public boolean isPaged;
    @InternalUseOnly(value="since 3.3.3, will become protected in 3.7+ (instead use getNeedRefresh()")
    public boolean needRefresh;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public boolean isReset;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public boolean isDone;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public boolean zaxis;
    protected boolean isBlank = true;
    private boolean needsRescale;
    private int useLocal;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public int ncolors;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public Color[] colors;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use setColorMap()")
    public int cmap;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public int typeClass;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public int defmode = 1;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use setSurface()")
    public int stype = 1;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+")
    public MPlot MP;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use getFeature()")
    public Feature feature;
    KeyVector layFeatures = new KeyVector(16);
    FeatureGroupMap featureGroups;
    @InternalUseOnly(value="since 3.5.1")
    public PlotFile pf;
    protected PlotFileNH pfnh;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use setData()")
    public Data data;
    @Deprecated
    public String comment;
    protected MidasReference ref;
    private Midas M;
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use getLine()")
    public Line line = new Line(this);
    @InternalUseOnly(value="since 3.5.1, will become protected in 3.9+ (instead use getName(), setName()")
    public String name;
    private String groupName;
    private boolean baseLayer = false;
    float[] ffbuf;
    protected GLegend.Entry legendEntry = new GLegend.Entry(this);
    @Deprecated
    public int effects = 0;
    private boolean timeAlign = false;
    private int nthAutoScaleFrame = -1;
    private SlidingMinMax autoscaleMinMaxBuffer = null;
    protected int debugMask;
    private int refreshRate = 0;
    private float rrSmoothingFactor = 0.1f;
    private int rrMaxSkipMultiplier = 2;
    private transient float rrInDataRate = 0.0f;
    private transient float rrLastNumScreenAvail;
    private transient int rrElemsReadSinceLastUpdate;
    private transient double rrLastUpdateTime;
    private double smallFactor = 1.0;
    private double mediumFactor = 0.75;
    private double largeFactor = 0.5;
    private Font numberFontSmall;
    private Font numberFontMedium;
    private Font numberFontLarge;

    public Layer() {
    }

    protected Layer(String name) {
        this();
        this.name = name;
    }

    public static Layer getLayer(Table tab) {
        if (tab == null) {
            return null;
        }
        String className = tab.getS("LAYERTYPE");
        if (className == null) {
            className = tab.getS("LT");
        }
        if (className == null) {
            return null;
        }
        if (className.indexOf(46) < 0) {
            className = "nxm.sys.libg.Layer" + className;
        }
        try {
            Class<?> c = Class.forName(className);
            Layer lay = (Layer)c.getConstructor(new Class[0]).newInstance(new Object[0]);
            return lay;
        }
        catch (Exception e) {
            throw new MidasException("Err loading Layer class: " + className, e);
        }
    }

    @InternalUseOnly
    public static Layer getLayer(Table tab, PlotFile pf, int plotType) {
        Layer lay = Layer.getLayer(tab);
        if (lay != null) {
            return lay;
        }
        if (pf instanceof DataFile) {
            return LayerUtil.getDataFileLayer((DataFile)pf, plotType);
        }
        LayerUtil.refreshRegistry();
        if (LayerUtil.getFunction(pf.getClass()) == null) {
            LogUtilities.log(Level.WARNING, "Using the deprecated PlotFile.getLayer() method. Please add getLayer() to the registry going forward. For info nxm.sys.lib.LayerUtil.java");
            Object layer = null;
            try {
                Method getLayerMethod = PlotFile.class.getMethod("getLayer", new Class[0]);
                layer = getLayerMethod.invoke((Object)pf, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new MidasException("Error accessing getLayer method for PlotFile: " + pf, e);
            }
            return (Layer)layer;
        }
        return LayerUtil.getFunction(pf.getClass()).apply(pf);
    }

    @InternalUseOnly
    public final void init(plot plot2, String layerName, int layerIndex, PlotFile pf, Table tab, Layer oldLayer) {
        boolean rt = plot2.isRealTimeMode() || pf.isStream();
        this.setMPlot(plot2.getMPlot());
        this.setName(layerName);
        this.setRealTime(rt);
        this.setFile(pf, tab, plot2.getMA());
        if (rt && this.MP.getOption(1) && this.isEnabled(-1)) {
            this.M.warning("Backing Store not recommended for real-time plots due to Graphics performance. layer = " + this);
        }
        if (plot2.isReverseColorsMode()) {
            this.reverseColorMap();
        }
        this.init(plot2, layerName, layerIndex, oldLayer);
    }

    protected void init(plot p, String layerName, int layerIndex, Layer oldLayer) {
    }

    public boolean setFile(PlotFile pf, Table tab, Args MA) {
        this.setFile(pf);
        this.setSize((int)pf.getSize());
        this.setData(pf.getDataBuffer(this.size));
        return true;
    }

    public PlotFile getFile() {
        return this.pf;
    }

    public void setGroup(String name) {
        this.groupName = name;
    }

    public String getGroup() {
        return this.groupName;
    }

    public void makeBaseLayer() {
        this.setBaseLayer(true);
    }

    public void setBaseLayer(boolean base) {
        if (base != this.baseLayer) {
            this.baseLayer = base;
            this.needRefresh = true;
            if (this.baseLayer && this.MP != null) {
                this.MP.setBaseLayer(this);
            }
        }
    }

    public boolean isBaseLayer() {
        return this.baseLayer;
    }

    public int getDefaultComplexMode() {
        return 5;
    }

    public int getDefaultView() {
        return 1;
    }

    public void close() {
        if (this.pf != null && this.pf.isOpen()) {
            this.pf.close();
        }
    }

    public int getData(int mode) {
        if (this.pf == null || !this.pf.isOpen() || this.data == null || this.isDone) {
            return 0;
        }
        int stat = 0;
        int ndo = (int)this.pf.avail();
        int numElementsToSkipAfterRead = this.getElementsToSkipAfterRead(ndo);
        if (ndo > 0) {
            ndo = Math.min(ndo, this.data.size);
            this.fseek = this.pf.seek();
            if (this.isPaged) {
                double s = this.pf.getStart();
                double d = this.pf.getDelta();
                if (this.typeClass == 2) {
                    if (d > 0.0) {
                        ndo = Math.min(ndo, (int)((this.MP.ry2 - s) / d - this.fseek + 2.0));
                    }
                    if (d < 0.0) {
                        ndo = Math.min(ndo, (int)((this.MP.ry1 - s) / d - this.fseek + 2.0));
                    }
                    this.setYStart(s + this.fseek * d);
                } else {
                    if (d > 0.0) {
                        ndo = Math.min(ndo, (int)((this.MP.rx2 - s) / d - this.fseek + 2.0));
                    }
                    if (d < 0.0) {
                        ndo = Math.min(ndo, (int)((this.MP.rx1 - s) / d - this.fseek + 2.0));
                    }
                    this.setXStart(s + this.fseek * d);
                }
            }
        }
        if (ndo > 0) {
            if (this.ffbuf != null) {
                this.data.buf = Native.uncastF(this.ffbuf);
                ndo = this.pf.read(this.data, ndo);
                this.ffbuf = Native.castF(this.data.buf);
            } else {
                ndo = this.pf.read(this.data, ndo);
            }
            if (ndo <= 0) {
                return 0;
            }
            this.rrElemsReadSinceLastUpdate += ndo;
            if (numElementsToSkipAfterRead > 0) {
                if (this.pf instanceof DataFile) {
                    ((DataFile)this.pf).skip(numElementsToSkipAfterRead);
                } else {
                    this.pf.seek(this.pf.seek() + (double)numElementsToSkipAfterRead);
                }
            }
            this.process(ndo);
            stat = this.isReset ? 1 : (this.isPaged ? 2 : this.defmode);
        } else if (this.isPaged) {
            this.pf.seek(this.pf.getSize());
            if (this.typeClass == 2) {
                this.setYStart(this.pf.getStart());
            } else {
                this.setXStart(this.pf.getStart());
            }
            this.isDone = true;
            this.ndata = 0;
        } else if (!this.realtime) {
            stat = 0;
        } else if (this.pf.isStream() && !this.pf.isStreaming()) {
            stat = -1;
        }
        return stat;
    }

    public boolean isPaged(int dir) {
        if (dir == 1) {
            return this.isPaged && this.typeClass != 2;
        }
        if (dir == 2) {
            return this.isPaged && this.typeClass == 2;
        }
        return this.isPaged;
    }

    public boolean reread() {
        if (this.pf == null || !this.pf.isOpen() || this.realtime) {
            return false;
        }
        if (this.pf instanceof DataFile) {
            DataFile df = (DataFile)this.pf;
            this.pf = df.reOpen();
        }
        if ((this.MP.options & 1) != 0 && (this.enable & 4) != 0) {
            this.MP.reset(-1);
        }
        this.pf.seek(0.0);
        this.isDone = false;
        return true;
    }

    @Override
    public boolean reset() {
        if (this.isPaged && this.pf != null && this.pf.isOpen()) {
            double s = this.pf.getStart();
            double d = this.pf.getDelta();
            double offset = 0.0;
            if (this.typeClass == 2) {
                if (d > 0.0) {
                    offset = Math.floor((this.MP.ry1 - s) / d);
                }
                if (d < 0.0) {
                    offset = Math.floor((this.MP.ry2 - s) / d);
                }
            } else {
                if (d > 0.0) {
                    offset = Math.floor((this.MP.rx1 - s) / d);
                }
                if (d < 0.0) {
                    offset = Math.floor((this.MP.rx2 - s) / d);
                }
            }
            offset = Math.max(0.0, Math.min(this.pf.getSize(), offset));
            if (this.fseek < 0.0 || this.isDone || offset != this.pf.seek()) {
                this.pf.seek(offset);
                this.isReset = true;
                this.isDone = false;
            }
        }
        return this.isReset;
    }

    public boolean clear() {
        return false;
    }

    public final void setLayerType(String value) {
    }

    public final String getLayerType() {
        return this.getClass().getName();
    }

    public void setFile(PlotFile pf) {
        this.pf = pf;
        this.pfnh = FileUtil.asPlotFileNH(pf);
        this.typeClass = pf.getType() / 1000;
        this.fseek = -1.0;
        this.setXUnits(pf.getXUnits());
        this.setYUnits(this.typeClass == 2 ? pf.getYUnits() : 0);
        this.setZUnits(0);
        this.nthAutoScaleFrame = -1;
    }

    @Override
    public void setMPlot(MPlot value) {
        this.MP = value;
        if (this.line != null) {
            this.line.setPlot(this.MP);
        }
        if (this.feature != null) {
            this.feature.MP = this.MP;
        }
    }

    public void setName(String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        value = value.toUpperCase();
        if (this.MP != null && this.name != null) {
            this.MP.layers.rename(this.name, value);
        }
        this.name = value;
    }

    public void setData(Data value) {
        this.data = value;
    }

    public void update() {
        if (this.ndata == 0 && this.isPaged && this.data != null) {
            this.ndata = this.data.size;
        }
        if (this.ndata > 0) {
            this.process();
        }
    }

    @Override
    public void setEnable(int value) {
        if (this.enable != value) {
            this.enable = value;
            this.needRefresh = true;
            this.refresh();
        }
    }

    public void toggle() {
        this.setEnable(this.enable ^ 1);
    }

    @Override
    public void setEnable(String value) {
        this.setEnable(Parser.mask("Global,Labels,BStore,Thin,Base,Zoom,FastBase,FastZoom", value, this.enable));
    }

    @Override
    public int getEnable() {
        return this.enable;
    }

    @Override
    public String getEnableString() {
        return Parser.mask2s("Global,Labels,BStore,Thin,Base,Zoom,FastBase,FastZoom", this.enable);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Line getLine() {
        return this.line;
    }

    @Override
    public MPlot getMPlot() {
        return this.MP;
    }

    @Override
    public Object getNextLink() {
        return this.getLine();
    }

    @Override
    public Object getPrevLink() {
        return this.getMPlot();
    }

    public void setScale(int value) {
        this.scaleable = value;
    }

    public final void setScale(String value) {
        this.setScale(Parser.mask("AutoMin,AutoMax,MinRange,MaxRange,MinZRange,MaxZRange,NoAverage,ExpandOnly", value, this.scaleable));
    }

    public int getScale() {
        return this.scaleable;
    }

    public void setXStart(double value) {
        this.xstart = value;
    }

    public double getXStart() {
        return this.xstart;
    }

    public void setXDelta(double value) {
        this.xdelta = value;
    }

    public double getXDelta() {
        return this.xdelta;
    }

    public void setXAxis(double start, double delta) {
        this.setAxis(start, delta, 'X');
    }

    public void setYStart(double value) {
        this.ystart = value;
    }

    public double getYStart() {
        return this.ystart;
    }

    public void setYDelta(double value) {
        this.ydelta = value;
    }

    public double getYDelta() {
        return this.ydelta;
    }

    public void setYAxis(double start, double delta) {
        this.setAxis(start, delta, 'Y');
    }

    public void setZStart(double value) {
        this.zstart = value;
    }

    public double getZStart() {
        return this.zstart;
    }

    public void setZDelta(double value) {
        this.zdelta = value;
    }

    public double getZDelta() {
        return this.zdelta;
    }

    public void setZAxis(double start, double delta) {
        this.setAxis(start, delta, 'Z');
    }

    private void setAxis(double start, double delta, char c) {
        boolean precision = true;
        if (this.MP.isAxisIndex()) {
            precision = false;
        } else if (delta != 0.0 && start != Double.MAX_VALUE) {
            precision = start + delta != start;
        }
        if (!precision) {
            if (!this.MP.isAxisIndex()) {
                String text = "WARNING: " + c + " Axis START / DELTA values combination is    \nbeyond precision: \n     START = " + start + " \n     DELTA = " + delta + " \nSetting to INDEX mode: \n     START = 0 \n     DELTA = 1";
                MJPopup popup2 = MJPopup.createOk(this.MP.getPanel(), "Beyond Precision", 2, text);
                popup2.display(0);
                this.warning(text);
            }
            start = 0.0;
            delta = 1.0;
            this.MP.setAxisIndex(true);
        }
        switch (c) {
            case 'X': {
                this.xstart = start;
                this.xdelta = delta;
                break;
            }
            case 'Y': {
                this.ystart = start;
                this.ydelta = delta;
                break;
            }
            case 'Z': {
                this.zstart = start;
                this.zdelta = delta;
                break;
            }
            default: {
                this.warning("Invalid axis type: " + c);
            }
        }
    }

    public void setFrame(int value) {
        this.frame = value;
    }

    public int getFrame() {
        return this.frame;
    }

    public void setSize(int value) {
        this.size = value;
    }

    public int getSize() {
        return this.size;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTime() {
        return this.time;
    }

    synchronized void setAutoscaleBuffersMaxActive(int autoscaleLength) {
        if (this.autoscaleMinMaxBuffer == null) {
            this.autoscaleMinMaxBuffer = new SlidingMinMax(256, autoscaleLength);
        } else {
            this.autoscaleMinMaxBuffer.setMaxActive(autoscaleLength);
        }
    }

    @Deprecated
    public void setRef(Object ref) {
        this.setRef(Convert.ref2Midas(ref));
    }

    public void setRef(MidasReference ref) {
        this.ref = ref;
        if (ref != null) {
            this.M = ref.getMidas();
        }
    }

    public MidasReference getRef() {
        return this.ref;
    }

    @Override
    public Midas getMidas() {
        return this.M;
    }

    public void setRealTime(boolean rt) {
        this.realtime = rt;
        if (rt) {
            this.enable &= 0xFFFFFFFB;
        }
    }

    public String getReadOut(Position mp) {
        return null;
    }

    protected Position getPosition(int px, int py, Position p) {
        p.t = this.getTime(px, py);
        return p;
    }

    @InternalUseOnly
    Position getPositionMPlot(int px, int py, Position p) {
        return this.getPosition(px, py, p);
    }

    @Override
    public boolean getNeedRefresh() {
        return this.needRefresh || this.line.getNeedRefresh();
    }

    @Override
    public void clearNeedRefresh() {
        this.needRefresh = false;
        this.line.clearNeedRefresh();
    }

    @Override
    public void refresh() {
        if ((this.enable & 1) != 0) {
            this.needRefresh = true;
        }
        if (this.isEnabled(-1) && this.MP != null) {
            this.MP.reset(-1);
        }
    }

    public void refresh(int drawmode) {
        this.MP.refresh(drawmode);
    }

    public void process() {
        this.isBlank = false;
    }

    public void process(int elem) {
        int origSize = this.data.size;
        if (elem < this.data.size) {
            this.data.setSize(elem);
        }
        this.process();
        if (elem != origSize) {
            this.data.setSize(origSize);
        }
    }

    @Override
    public void findRange() {
        this.x1 = 0.0;
        this.x2 = 1.0;
        this.y1 = 0.0;
        this.y2 = 1.0;
        this.z1 = 0.0;
        this.z2 = 1.0;
        this.a1 = 0.0;
        this.a2 = 1.0;
    }

    public void findFullRange() {
        this.fx1 = this.x1;
        this.fx2 = this.x2;
        this.fy1 = this.y1;
        this.fy2 = this.y2;
        this.fz1 = this.z1;
        this.fz2 = this.z2;
    }

    public void findFullRange(PlotFile pf) {
        this.fx1 = this.x1;
        this.fx2 = this.x2;
        this.fy1 = this.y1;
        this.fy2 = this.y2;
        this.fz1 = this.z1;
        this.fz2 = this.z2;
        if (pf != null && !this.realtime) {
            this.fx1 = pf.getXStart();
            this.fx2 = this.fx1 + (pf.getSize() - 1.0) * pf.getXDelta();
            if (this.fx1 > this.fx2) {
                double t = this.fx1;
                this.fx1 = this.fx2;
                this.fx2 = t;
            }
        }
    }

    public boolean isTimeAlign() {
        return this.timeAlign;
    }

    public void setTimeAlign(boolean val) {
        this.timeAlign = val;
    }

    @Override
    public void draw(int flag) {
        this.clearNeedRefresh();
        this.isReset = false;
    }

    @InternalUseOnly
    public int drawDataSegment(Line lin, double start, double end) {
        return -1;
    }

    public void configure() {
        String menuItems = this.layFeatures.size() > 0 ? "Rename,Delete,Enable,Scale,Line,Symbol,Surface,Feature,Color,Colors,ColorMap,Query,Effects,Features" : configureList;
        new GMenu(this.MP, "Layer.cfg", menuItems, 0, 0, this);
    }

    @Override
    public int processMessage(Message msg) {
        String text = Convert.o2s(msg.data);
        switch (msg.name) {
            case "LAYER.CFG": {
                switch (text) {
                    case "RENAME": {
                        new GPrompt(this.MP, "Name", this.name, 0, (MessageHandler)this);
                        break;
                    }
                    case "QUERY:": {
                        new GQuery(this.MP, "Layer " + this.name, this, 0, (MessageHandler)this);
                        break;
                    }
                    case "SYMBOL": {
                        new GMenu(this.MP, "Symbol", "Aero,Arrow,Circle,Cross,Diamond,Dot,Plus,Square,Star,Triangle,UTri,DTri,RTri,LTri,A,B,C,D,Ascii-XYZ,None", 0, 0, this.line);
                        break;
                    }
                    case "ENABLE": {
                        new GMenu(this.MP, "Enable", "Global,Labels,BStore,Thin,Base,Zoom,FastBase,FastZoom", this.enable, 1024, this);
                        break;
                    }
                    case "SCALE": {
                        new GMenu(this.MP, "Scale", "AutoMin,AutoMax,MinRange,MaxRange,MinZRange,MaxZRange,NoAverage,ExpandOnly", this.scaleable, 1024, this);
                        break;
                    }
                    case "SURFACE": {
                        new GMenu(this.MP, "Surface", "Fill,Mesh,Dot,Contour", this.stype, 1024, this);
                        break;
                    }
                    case "COLORMAP": {
                        new GMenu(this.MP, "ColorMap", colorMapList, this.cmap, 0, this);
                        break;
                    }
                    case "EFFECTS": {
                        new GMenu(this.MP, "Effects", effectsList, this.effects, 1024, this);
                        break;
                    }
                    case "DELETE": {
                        this.MP.removeLayer(this.name);
                        break;
                    }
                    case "LINE": {
                        this.line.configure();
                        break;
                    }
                    case "FEATURE": {
                        this.getFeature().configure();
                        break;
                    }
                    case "FEATURES": {
                        if (this.featureGroups.size() > 0) {
                            String menuItems = String.join((CharSequence)",", this.featureGroups.keySet());
                            new GMenu(this.MP, "FeatureGrp", menuItems, 0, 0, this);
                            break;
                        }
                        new GMenu(this.MP, "LayFeature", this.layFeatures.getKeyList(), 0, 0, this);
                        break;
                    }
                    case "COLOR": {
                        String colorString = MColor.toString(this.getColor());
                        int len = colorString != null ? Math.max(colorString.length(), 20) : 20;
                        new GPrompt(this.MP, "Color", colorString, len, 0, this);
                        break;
                    }
                    case "COLORS": {
                        int lgth = Math.max(Math.min(this.getColorMap().length(), 500), 20);
                        new GPrompt(this.MP, "Colors", this.getColorMap(), lgth, 0, this);
                    }
                }
                break;
            }
            case "COLORMAP": {
                if (msg.data.toString().equalsIgnoreCase("CUSTOM")) {
                    new GPrompt(this.MP, "Colors", this.getColorMap(), 0, (MessageHandler)this);
                    break;
                }
                this.setColorMap(msg.info);
                break;
            }
            case "EFFECTS": {
                if (msg.data.toString().equals("REVERSECOLORS")) {
                    this.reverseColorMap();
                    break;
                }
                if (!msg.data.toString().equals("INVERTCOLORS")) break;
                this.invertColorMap();
                break;
            }
            case "LAYFEATURE": {
                Feature f = (Feature)this.layFeatures.get(text);
                f.configure();
                break;
            }
            case "FEATUREGRP": {
                FeatureGroup group2 = (FeatureGroup)this.featureGroups.get((String)msg.data);
                String menuitems = String.join((CharSequence)",", group2.getFeatures().keySet());
                new GMenu(this.MP, "LayFeature", menuitems, 0, 0, this);
                break;
            }
            case "COLOR": {
                this.setColor(text);
                break;
            }
            case "COLORS": {
                this.setColors(text);
                break;
            }
            case "ENABLE": {
                this.setEnable(msg.info);
                break;
            }
            case "SCALE": {
                this.setScale(msg.info);
                break;
            }
            case "SURFACE": {
                this.setSurface(msg.info);
                break;
            }
            case "NAME": {
                this.setName(text);
                break;
            }
            case "RENAME": {
                this.setName(text);
                break;
            }
            case "NEWNAME": {
                this.setName(text);
                break;
            }
            default: {
                return 0;
            }
        }
        return 1;
    }

    @Override
    public boolean isEnabled(int flag) {
        if ((this.enable & 1) == 0) {
            return false;
        }
        if (flag == 0) {
            return true;
        }
        return flag > 0 ^ (this.enable & 4) != 0;
    }

    public boolean isBlank() {
        return this.isBlank;
    }

    public boolean isVisible() {
        return (this.enable & 1) != 0;
    }

    public final void setX1(double r1) {
        this.setXMin(r1);
    }

    public final void setX2(double r2) {
        this.setXMax(r2);
    }

    public final void setX(double r1, double r2) {
        this.setXBounds(r1, r2);
    }

    public final void setY1(double r1) {
        this.setYMin(r1);
    }

    public final void setY2(double r2) {
        this.setYMax(r2);
    }

    public final void setY(double r1, double r2) {
        this.setYBounds(r1, r2);
    }

    public final void setZ1(double r1) {
        this.setZMin(r1);
    }

    public final void setZ2(double r2) {
        this.setZMax(r2);
    }

    public final void setZ(double r1, double r2) {
        this.setZBounds(r1, r2);
    }

    public final double getX1() {
        return this.getXMin();
    }

    public final double getX2() {
        return this.getXMax();
    }

    public final double getY1() {
        return this.getYMin();
    }

    public final double getY2() {
        return this.getYMax();
    }

    public final double getZ1() {
        return this.getZMin();
    }

    public final double getZ2() {
        return this.getZMax();
    }

    public void setXMin(double r1) {
        this.setXBounds(r1, r1 + this.x2 - this.x1);
    }

    public void setXMax(double r2) {
        this.setXBounds(this.x1, r2);
    }

    public void setXBounds(double r1, double r2) {
        this.x1 = Math.min(r1, r2);
        this.x2 = Math.max(r1, r2);
        this.needRefresh = true;
    }

    public void setYMin(double r1) {
        this.setYBounds(r1, r1 + this.y2 - this.y1);
    }

    public void setYMax(double r2) {
        this.setYBounds(this.y1, r2);
    }

    public void setYBounds(double r1, double r2) {
        this.y1 = Math.min(r1, r2);
        this.y2 = Math.max(r1, r2);
        this.needRefresh = true;
    }

    public void setZMin(double r1) {
        this.setUseLocalZMin(true);
        this.setZBounds(r1, r1 + this.z2 - this.z1);
    }

    public void setZMax(double r2) {
        this.setUseLocalZMax(true);
        this.setZBounds(this.z1, r2);
    }

    public void setZBounds(double r1, double r2) {
        this.z1 = Math.min(r1, r2);
        this.z2 = Math.max(r1, r2);
        this.needRefresh = true;
    }

    @Override
    public double getXMin() {
        return this.x1;
    }

    @Override
    public double getXMax() {
        return this.x2;
    }

    @Override
    public double getYMin() {
        return this.y1;
    }

    @Override
    public double getYMax() {
        return this.y2;
    }

    @Override
    public double getZMin() {
        return this.getUseLocalZMin() ? this.z1 : this.MP.getZMin();
    }

    @Override
    public double getZMax() {
        return this.getUseLocalZMax() ? this.z2 : this.MP.getZMax();
    }

    final boolean getUseLocalZMin() {
        return this.getUseLocalFlag(65536);
    }

    final boolean getUseLocalZMax() {
        return this.getUseLocalFlag(131072);
    }

    final void setUseLocalZMin(boolean use) {
        this.setUseLocalFlag(65536, use);
    }

    final void setUseLocalZMax(boolean use) {
        this.setUseLocalFlag(131072, use);
    }

    final void setUseMPlotZMin(boolean use) {
        this.setUseMPlotFlag(0x100000, use);
    }

    final void setUseMPlotZMax(boolean use) {
        this.setUseMPlotFlag(0x200000, use);
    }

    private boolean getUseLocalFlag(int flag) {
        if (this.MP == null) {
            return true;
        }
        return (this.useLocal & flag << 6) != 0 && (this.useLocal & flag << 4) == 0 && (this.useLocal & flag) != 0;
    }

    private void setUseLocalFlag(int flag, boolean use) {
        this.useLocal &= ~(flag << 4 | flag);
        if (use) {
            this.useLocal |= flag;
        }
    }

    private void setUseMPlotFlag(int flag, boolean use) {
        this.useLocal &= ~flag;
        if (use) {
            this.useLocal |= flag;
        }
    }

    protected final void setEnableNonLocal(boolean x, boolean y, boolean z) {
        this.useLocal &= 0xFF3F3F3F;
        if (x) {
            this.useLocal |= 0xC0;
        }
        if (y) {
            this.useLocal |= 0xC000;
        }
        if (z) {
            this.useLocal |= 0xC00000;
        }
    }

    public double getTime(int px, int py) {
        return this.time;
    }

    public double getPosAtTime(double time) {
        return -1.0;
    }

    @Deprecated
    public double getYPosAtTime(double time) {
        return -1.0;
    }

    public double getNearestYValue(double x) throws ArithmeticException {
        if (this.xdelta == 0.0) {
            throw new ArithmeticException();
        }
        int i = (int)((x - this.xstart) / this.xdelta + 0.5);
        if (i < 0) {
            i = 0;
        }
        if (i >= this.ndata) {
            i = this.ndata - 1;
        }
        return this.getNearestYValue(i);
    }

    public double getNearestYValue(int i) {
        return 0.0;
    }

    public Feature getFeature() {
        if (this.feature != null) {
            return this.feature;
        }
        this.feature = new Feature(this);
        this.feature.setType(0);
        this.feature.setName("_LAYER_" + this.getName() + "_");
        this.feature.setEnable(0);
        return this.feature;
    }

    public void setSurface(int value) {
        this.stype = value;
        this.refresh();
    }

    public void setSurface(String value) {
        this.setSurface(Parser.mask("Fill,Mesh,Dot,Contour", value, this.stype));
    }

    public void setColor(String value) {
        this.line.setColor(value);
    }

    public void setColor(int value) {
        this.line.setColor(value);
    }

    public void setColor(Color value) {
        this.line.setColor(value);
    }

    public Color getColor() {
        return this.line.getColor();
    }

    public void setColors(String value) {
        this.setColorMap(value);
    }

    public void setColorMap(int value) {
        this.setColorMap(value, -1);
    }

    public void setColorMap(int value, int ncolors) {
        if (value == -1) {
            value = this.cmap;
        }
        if (value < 1 || value > 9) {
            return;
        }
        if (value == this.cmap && ncolors == this.ncolors) {
            return;
        }
        this.cmap = value;
        this.setColorMap(MColor.getColorMap(value, ncolors));
    }

    public void setColorMap(Color[] colors) {
        if (this.effects != 0) {
            colors = this.applyEffects(colors, this.effects);
        }
        this.colors = colors;
        this.ncolors = colors.length - 1;
        this.refresh();
    }

    public void setColorMap(String value) {
        if (value.length() == 0) {
            return;
        }
        this.setColorMap(MColor.getColorMap(value, -1));
    }

    public String getColorMap() {
        if (this.colors == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (int i = 1; i < this.colors.length; ++i) {
            if (i != 1) {
                str.append(',');
            }
            str.append(MColor.toString(this.colors[i]));
        }
        return str.toString();
    }

    public String getEffects() {
        return Parser.mask2s(effectsList, this.effects);
    }

    public boolean setEffects(int arg) {
        if (arg == this.effects) {
            return false;
        }
        this.effects = arg;
        this.setColorMap(this.cmap);
        return true;
    }

    public boolean setEffects(String arg) {
        return this.setEffects(Parser.mask(effectsList, arg, this.effects));
    }

    public boolean getEffect(int mask) {
        return (this.effects & mask) != 0;
    }

    private Color[] applyEffects(Color[] colors, int effects) {
        if ((effects & 1) != 0) {
            colors = MColor.invertColorsMap(colors);
        }
        if ((effects & 2) != 0) {
            colors = MColor.reverseColorMap(colors);
        }
        return colors;
    }

    public void reverseColorMap() {
        if (this.colors == null) {
            this.warning("No color map in use, therefore cannot reverse it for " + this);
            return;
        }
        this.effects ^= 2;
        this.setColorMap(this.cmap);
    }

    public void setReverseColorMap(boolean val) {
        if (val) {
            this.reverseColorMap();
        }
    }

    public void invertColorMap() {
        if (this.colors == null) {
            this.warning("No color map in use, therefore cannot invert it for " + this);
            return;
        }
        this.effects ^= 1;
        this.setColorMap(this.cmap);
    }

    public void setInvertColorMap(boolean val) {
        if (val) {
            this.invertColorMap();
        }
    }

    public void setHiMode(int value) {
        if (value == 1) {
            value = 2;
        } else if (value == 2) {
            value = 8;
        } else if (value == 3) {
            value = 10;
        }
        this.getFeature().setType(value);
    }

    public void setHiX(double value) {
        this.getFeature().setX(value);
    }

    public void setHiXD(double value) {
        this.getFeature().setDX(value);
    }

    public void setHiColor(String value) {
        this.getFeature().getLine().setColor(value);
    }

    public double getHiX() {
        return this.getFeature().getX();
    }

    public double getHiXD() {
        return this.getFeature().getDX();
    }

    public int getx1i() {
        int i = (int)((this.MP.rx1 - this.xstart) / this.xdelta);
        return Math.max(1, Math.min(this.frame, i + 1));
    }

    public int getx2i() {
        int i = (int)((this.MP.rx2 - this.xstart) / this.xdelta);
        return Math.max(1, Math.min(this.frame, i + 1));
    }

    @Deprecated
    protected void prepDATAX(double x1, double x2, boolean delta, boolean marker) {
        if (this.MP.gc == null) {
            return;
        }
        int ic = 0;
        int ixc1 = this.MP.getix(x1);
        int ixc2 = this.MP.getix(x2) + 1;
        if (delta) {
            this.MP.gc.clearRect(ixc1 + 1, this.MP.iy1, ixc2 - ixc1 + ic, this.MP.iy21);
        }
        if (marker && ixc2 > this.MP.ix1 && ixc2 < this.MP.ix2 - 1) {
            this.MP.gc.drawLine(ixc2 + 1, this.MP.iy1 + 3, ixc2 + 1, this.MP.iy2 - 4);
        }
    }

    protected static float setScale(Data data, int plotMode) {
        return (float)Layer.getScaleFactor(data.spa, plotMode);
    }

    static double getScaleFactor(int spa, int mode) {
        double scale = 1.0;
        if (mode == 7) {
            scale = 10.0 / Math.log(10.0);
        }
        if (mode == 8) {
            scale = 20.0 / Math.log(10.0);
        }
        if (spa != 1) {
            scale /= 2.0;
        }
        if (mode == 2) {
            scale = 57.29577951308232;
        }
        return scale;
    }

    protected float[] data2fa(Data data, int ndata, float[] fbuf, int offset, int mode) {
        block32: {
            float scale;
            int i2;
            int i;
            block31: {
                i = offset;
                i2 = i + ndata;
                int spa = data.spa;
                scale = Layer.setScale(data, mode);
                if (this.ffbuf != null) {
                    fbuf = this.ffbuf;
                } else {
                    if (fbuf == null || fbuf.length < i2 * spa) {
                        try {
                            fbuf = new float[i2 * spa];
                        }
                        catch (OutOfMemoryError e) {
                            throw new MidasException("Not enough memory to allocate a (float) buffer of size " + i2 * spa * 4 + " bytes. Current free memory is " + Runtime.getRuntime().freeMemory() + " bytes.", e);
                        }
                    }
                    Convert.bb2ja(data.buf, 0, data.type, fbuf, i * spa, (byte)70, ndata * spa);
                }
                if (data.spa != 1) break block31;
                switch (mode) {
                    case 7: 
                    case 8: {
                        while (i < i2) {
                            fbuf[i] = Math.min(1.0E37f, scale * (float)Math.log(Math.max(1.0E-19, Math.abs((double)fbuf[i]))));
                            ++i;
                        }
                        break block1;
                    }
                }
                break block32;
            }
            if (data.spa == 2) {
                int j = i;
                switch (mode) {
                    case 1: {
                        while (i < i2) {
                            fbuf[i] = Math.min(1.0E37f, (float)Math.sqrt(fbuf[j] * fbuf[j] + fbuf[j + 1] * fbuf[j + 1]));
                            ++i;
                            j += 2;
                        }
                        break;
                    }
                    case 2: {
                        while (i < i2) {
                            fbuf[i] = Math.min(1.0E37f, scale * (float)Math.atan2(fbuf[j + 1], fbuf[j]));
                            ++i;
                            j += 2;
                        }
                        break;
                    }
                    case 4: 
                    case 10: {
                        ++j;
                    }
                    case 3: 
                    case 9: {
                        while (i < i2) {
                            fbuf[i] = fbuf[j];
                            ++i;
                            j += 2;
                        }
                        break;
                    }
                    case 7: 
                    case 8: {
                        while (i < i2) {
                            fbuf[i] = Math.min(1.0E37f, scale * (float)Math.log(Math.max(1.0E-20, (double)(fbuf[j] * fbuf[j] + fbuf[j + 1] * fbuf[j + 1]))));
                            ++i;
                            j += 2;
                        }
                        break;
                    }
                }
            } else if (data.spa == 3) {
                int j = i;
                switch (mode) {
                    case 1: {
                        while (i < i2) {
                            fbuf[i] = Math.min(1.0E37f, (float)Math.sqrt(fbuf[j] * fbuf[j] + fbuf[j + 1] * fbuf[j + 1] + fbuf[j + 2] * fbuf[j + 2]));
                            ++i;
                            j += 3;
                        }
                        break;
                    }
                    case 11: {
                        ++j;
                    }
                    case 4: 
                    case 10: {
                        ++j;
                    }
                    case 3: 
                    case 9: {
                        while (i < i2) {
                            fbuf[i] = fbuf[j];
                            ++i;
                            j += 3;
                        }
                        break;
                    }
                }
            }
        }
        return fbuf;
    }

    protected int[] data2la(Data data, int ndata, int[] buf, int offset) {
        int i = offset;
        int i2 = i + ndata;
        if (data.getFormat().equals("SL")) {
            if (buf == null || buf.length < i2) {
                buf = new int[i2];
            }
            Convert.bb2ja(data.buf, 0, data.type, buf, i, (byte)76, ndata);
        } else if (data.getFormat().equals("QB")) {
            if (buf == null || buf.length < i2) {
                buf = new int[i2];
            }
            if (!Convert.sameEndian(data.rep, Shell.rep)) {
                Convert.swap4(data.buf, 0, ndata);
            }
            Convert.bb2ja(data.buf, 0, (byte)76, buf, i, (byte)76, ndata);
        } else {
            this.warning("Layer.data2la: data format " + data.getFormat() + " NOT supported for this conversion.");
        }
        return buf;
    }

    public int getXUnits() {
        return this.xunits;
    }

    public int getYUnits() {
        return this.yunits;
    }

    public int getZUnits() {
        return this.zunits;
    }

    public String getXUnitsName() {
        return DataFile.getUnitsVarName(this.getXUnits());
    }

    public String getYUnitsName() {
        return DataFile.getUnitsVarName(this.getYUnits());
    }

    public String getZUnitsName() {
        return DataFile.getUnitsVarName(this.getZUnits());
    }

    public void setXUnits(String units) {
        this.setXUnits(DataFile.getUnitsID(units));
    }

    public void setYUnits(String units) {
        this.setYUnits(DataFile.getUnitsID(units));
    }

    public void setZUnits(String units) {
        this.setZUnits(DataFile.getUnitsID(units));
    }

    public void setXUnits(int units) {
        this.xunits = units;
    }

    public void setYUnits(int units) {
        this.yunits = units;
    }

    public void setZUnits(int units) {
        this.zunits = units;
    }

    public Symbol getSymbol() {
        if (this.getLine().isSymbolOn()) {
            return this.getLine().getSymbol();
        }
        return null;
    }

    String getClassName() {
        String className = this.getClass().getName();
        if (className.startsWith("nxm.sys.libg.")) {
            className = className.substring(13);
        }
        return className;
    }

    public String toString() {
        String className = this.getClass().getName();
        if (className.startsWith("nxm.sys.libg.")) {
            className = className.substring(13);
        }
        return className + ": " + this.getName();
    }

    public void processMouseMessage(Message msg, int type) {
    }

    public boolean isViewSupported(int view) {
        return true;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    void rescale() {
        this.setNeedsRescale(false);
        this.findRange();
    }

    public boolean getNeedsRescale() {
        return this.needsRescale;
    }

    protected void setNeedsRescale(boolean rescale) {
        this.needsRescale = rescale;
    }

    public GLegend.Entry getLegendEntry() {
        return this.legendEntry;
    }

    public GLegend.Entry[] getLegendSubEntries() {
        return null;
    }

    protected void autoScale4FindRange(double newMin, double newMax) {
        double DELTA_FOR_BIG_NUM = 1.0E23;
        if (newMin < (double)-1.0E37f) {
            newMin = -1.0E37f;
        } else if (newMin > (double)1.0E37f) {
            newMin = 9.999999933815712E36;
        } else if (Double.isNaN(newMin)) {
            newMin = this.a1;
        }
        if (newMin < (double)-1.0E37f) {
            newMin = -9.999999933815712E36;
        } else if (newMax > (double)1.0E37f) {
            newMax = 1.0E37f;
        } else if (Double.isNaN(newMax)) {
            newMax = this.a2;
        }
        if ((this.MP.scale & 0x80) != 0) {
            if (newMax > this.a2) {
                this.a2 = newMax;
            }
            if (newMin < this.a1) {
                this.a1 = newMin;
            }
        } else if ((this.MP.scale & 0x40) != 0 && this.MP.scaleAvg > 0) {
            double[] minMax = this.autoscaleMinMaxBuffer.updateMinMax(newMin, newMax);
            this.a1 = minMax[0];
            this.a2 = minMax[1];
        } else if (this.MP.scaleAvg > 0) {
            double p = 1.0 / (double)this.MP.scaleAvg;
            if (this.a1 == this.a2) {
                p = 1.0;
            }
            this.a1 = this.a1 * (1.0 - p) + newMin * p;
            this.a2 = this.a2 * (1.0 - p) + newMax * p;
        }
    }

    @InternalUseOnly
    public int getDebugMask() {
        return this.debugMask;
    }

    @InternalUseOnly
    public void setDebugMask(int newVal) {
        this.debugMask = newVal;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int newRefresRate) {
        if (newRefresRate < -2) {
            throw new IllegalArgumentException("Invalid refresh rate! " + newRefresRate);
        }
        if (newRefresRate == -1) {
            newRefresRate = 30;
        } else if (newRefresRate == 0) {
            this.rrInDataRate = 0.0f;
        }
        this.refreshRate = newRefresRate;
        if (this.debugMask != 0) {
            System.out.println("setRefreshRate() refreshRate=" + this.refreshRate + " " + this);
        }
    }

    @InternalUseOnly
    public float getRefreshSmoothingFactor() {
        return this.rrSmoothingFactor;
    }

    @InternalUseOnly
    public void setRefreshSmoothingFactor(float newVal) {
        if (newVal > 1.0f || newVal <= 0.0f) {
            throw new IllegalArgumentException("Invalid refresh rate smoothing factor; must be in range of (0 - 1]! " + newVal);
        }
        this.rrSmoothingFactor = newVal;
        if (this.debugMask != 0) {
            System.out.println("setRefreshSmoothingFactor() smoothingFactor=" + this.rrSmoothingFactor + " " + this);
        }
    }

    @InternalUseOnly
    public int getMaxSkipMultiplier() {
        return this.rrMaxSkipMultiplier;
    }

    @InternalUseOnly
    public void setMaxSkipMultiplier(int newVal) {
        if (newVal < 1) {
            throw new IllegalArgumentException("Invalid (refresh rate) max (avail elements) skip multiplier; must be >= 1! " + newVal);
        }
        this.rrMaxSkipMultiplier = newVal;
    }

    @InternalUseOnly
    public float getInputDataRate() {
        return this.rrInDataRate;
    }

    @InternalUseOnly
    public int getElementsPerScreen() {
        int frameSize;
        int lps = this.getSize();
        if (lps < 1) {
            lps = 1;
        }
        if (this.typeClass == 1 && (frameSize = this.getFrame()) > 0) {
            return frameSize * lps;
        }
        return lps;
    }

    @InternalUseOnly
    protected int getElementsToSkipAfterRead(int elementsAvail) {
        double curTime;
        double elapsedTime;
        int elementsToDrop = 0;
        if (elementsAvail >= 0 && (this.refreshRate > 0 || this.refreshRate == -2) && (elapsedTime = (curTime = Time.current()) - this.rrLastUpdateTime) > 0.01) {
            int screensToDrop;
            float screensReadSinceLastUpdate;
            int elementsPerScreen = this.getElementsPerScreen();
            float screensAvailable = (float)elementsAvail / (float)elementsPerScreen;
            float newScreenAvailable = screensAvailable - (this.rrLastNumScreenAvail - (screensReadSinceLastUpdate = (float)this.rrElemsReadSinceLastUpdate / (float)elementsPerScreen));
            if (newScreenAvailable > 0.0f) {
                if ((this.debugMask & 1) != 0) {
                    System.out.println("new data avail, elapsedTime=" + elapsedTime + " newFrames=" + newScreenAvailable + " framesAvail=" + screensAvailable + " lastNumFramesAvail=" + this.rrLastNumScreenAvail);
                }
                this.rrLastUpdateTime = curTime;
                this.rrElemsReadSinceLastUpdate = 0;
                this.rrLastNumScreenAvail = newScreenAvailable;
            } else if ((this.debugMask & 2) != 0) {
                System.out.println("   no new data, elapsedTime=" + elapsedTime + " newFrames=" + newScreenAvailable + " framesAvail=" + screensAvailable + " lastNumFramesAvail=" + this.rrLastNumScreenAvail + " elementsReadSinceUpdate=" + this.rrElemsReadSinceLastUpdate);
            }
            float newInDataRate = this.rrLastNumScreenAvail / (float)elapsedTime;
            this.rrInDataRate = this.rrInDataRate * (1.0f - this.rrSmoothingFactor) + newInDataRate * this.rrSmoothingFactor;
            if ((this.debugMask & 4) != 0) {
                System.out.println("inDataRate=" + (int)this.rrInDataRate + " tmpDateRate=" + newInDataRate + " elapsedTime=" + elapsedTime + " lastNumFramesAvail=" + this.rrLastNumScreenAvail + " framesAvail=" + screensAvailable + " newFrames=" + newScreenAvailable + " elementsAvail=" + elementsAvail);
            }
            if (screensAvailable > 0.0f && this.refreshRate > 0 && (screensToDrop = (int)(this.rrInDataRate - (float)this.refreshRate)) > 0) {
                int desiredNumToDrop = elementsToDrop = screensToDrop * elementsPerScreen;
                elementsToDrop = Math.min(elementsToDrop, elementsAvail * this.rrMaxSkipMultiplier);
                if ((this.debugMask & 8) != 0 || (this.debugMask & 0x10) != 0 && elementsToDrop < desiredNumToDrop) {
                    System.out.println("skipping " + elementsToDrop + " vs " + desiredNumToDrop + " elements. inDataRate=" + (int)this.rrInDataRate + " screensToDrop=" + screensToDrop + " elemsAvail=" + elementsAvail);
                }
            }
        }
        return elementsToDrop;
    }

    protected void warning(CharSequence msg) {
        Midas midas = Convert.ref2Midas(this.M);
        midas.warning(msg);
    }

    @Override
    public boolean isAtPosition(Position pos, int dpx, int dpy) {
        if (dpx != -2) {
            if (pos.getX() < this.getXMin()) {
                return false;
            }
            if (pos.getX() > this.getXMax()) {
                return false;
            }
        }
        if (dpy != -2) {
            if (pos.getY() < this.getYMin()) {
                return false;
            }
            if (pos.getY() > this.getYMax()) {
                return false;
            }
        }
        return true;
    }

    @InternalUseOnly(value="since created in 3.7.0")
    public static double[] testSlidingMinMax(int buffLength, int autoL, int indexResetAutoL, int newAutoL, double[][] minMaxValues, int indexReportMinMax) {
        SlidingMinMax forTestingMinMax = new SlidingMinMax(buffLength, autoL);
        double[] minMax = null;
        for (int i = 0; i <= indexReportMinMax; ++i) {
            if (i == indexResetAutoL) {
                forTestingMinMax.setMaxActive(newAutoL);
            }
            minMax = forTestingMinMax.updateMinMax(minMaxValues[i][0], minMaxValues[i][1]);
        }
        return minMax;
    }

    public static void setThreeDGraphMarginFactor(double threeDGraphMarginFactor) {
        Layer.threeDGraphMarginFactor = threeDGraphMarginFactor;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    void setClusterFontSizes() {
        this.numberFontSmall = new Font("Small Font", 1, (int)((double)this.MP.gc.getFont().getSize() * this.smallFactor));
        this.numberFontMedium = new Font("Medium Font", 1, (int)((double)this.MP.gc.getFont().getSize() * this.mediumFactor));
        this.numberFontLarge = new Font("Large Font", 1, (int)((double)this.MP.gc.getFont().getSize() * this.largeFactor));
    }

    @InternalUseOnly
    public void setSmallFactor(double smallFactor) {
        this.smallFactor = smallFactor;
    }

    @InternalUseOnly
    public void setMediumFactor(double mediumFactor) {
        this.mediumFactor = mediumFactor;
    }

    @InternalUseOnly
    public void setLargeFactor(double largeFactor) {
        this.largeFactor = largeFactor;
    }

    @InternalUseOnly
    public Font getNumberFontSmall() {
        return this.numberFontSmall;
    }

    @InternalUseOnly
    public Font getNumberFontMedium() {
        return this.numberFontMedium;
    }

    @InternalUseOnly
    public Font getNumberFontLarge() {
        return this.numberFontLarge;
    }
}

