/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import nxm.sys.lib.Command;
import nxm.sys.lib.Message;
import nxm.sys.lib.Table;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.GridSheet;
import nxm.sys.libg.MFrame;
import nxm.sys.libg.MJFrame;
import nxm.sys.libg.MPanel;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.MWindow;

public class HelpKeyListener
extends KeyAdapter {
    MWindow mwindow = null;

    public HelpKeyListener(MWindow mw) {
        this.mwindow = mw;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keycode = e.getKeyCode();
        if (keycode == 112) {
            Component sourceComp = (Component)e.getSource();
            Container cont = sourceComp.getParent();
            while (!(cont instanceof Frame)) {
                cont = cont.getParent();
            }
            MWindow topmw = null;
            if (cont instanceof MFrame) {
                topmw = ((MFrame)cont).MW;
            } else if (cont instanceof MJFrame) {
                topmw = ((MJFrame)cont).MW;
            } else {
                return;
            }
            Command cmd = null;
            if (topmw.mh instanceof Command) {
                cmd = (Command)topmw.mh;
            }
            if (cmd == null || cmd.M.macro == null) {
                return;
            }
            ArrayList<Component> allComps = this.getComponents(cont);
            MWindow mw = null;
            String compName = "";
            Object compValue = null;
            Table data = new Table();
            for (Component c : allComps) {
                mw = null;
                if (!(c instanceof MPanel)) continue;
                mw = ((MPanel)c).MW;
                if (!mw.pactive) continue;
                if (mw instanceof GWidget) {
                    GWidget gw = (GWidget)mw;
                    compName = gw.getLabel();
                    compValue = gw.getValue();
                } else if (mw instanceof MPlot) {
                    if (mw.mh instanceof Command) {
                        compName = ((Command)mw.mh).getID();
                    }
                } else {
                    Component compo = mw.panel.getComponentAt(mw.px, mw.py);
                    if (mw.mh instanceof Command) {
                        if (mw.mh instanceof GridSheet.GridSheetReference) {
                            GridSheet gs = ((GridSheet.GridSheetReference)((Object)mw.mh)).getGridSheet();
                            int row = gs.getSelectedRow();
                            int col = gs.getSelectedColumn();
                            data.put("ROW", row);
                            data.put("COL", col);
                            if (row > 0 && col > 0) {
                                compValue = gs.getCell(row, col);
                            }
                        }
                        compName = ((Command)mw.mh).getID();
                    }
                }
                if (compName.equals("")) continue;
                break;
            }
            if (compName.equals("")) {
                return;
            }
            data.put("NAME", (Object)compName);
            data.put("VALUE", compValue);
            Message msg = new Message("HELP", 0, data);
            cmd.M.macro.processMessage(msg);
            e.consume();
        }
    }

    private ArrayList<Component> getComponents(Component c) {
        Component[] comps;
        ArrayList<Component> clist = new ArrayList<Component>();
        ArrayList<Component> al = null;
        clist.add(c);
        if (!(c instanceof Container)) {
            return clist;
        }
        for (Component comp : comps = ((Container)c).getComponents()) {
            al = this.getComponents(comp);
            for (Component childComp : al) {
                clist.add(childComp);
            }
        }
        return clist;
    }
}

