/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.Message;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.lib.XmlFile;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MPanel;
import nxm.sys.libg.MWindow;

public class GridSheet
extends MPanel
implements Keyable,
MessageHandler,
ComponentListener,
MouseListener,
MouseMotionListener,
ChangeListener {
    private static final long serialVersionUID = 2012012000311L;
    private static final boolean JC4_IMPROVED_DRAW = true;
    private static final boolean DEBUG_REFRESH = false;
    static int maxdisprows = 100;
    static int maxdispcols = 75;
    static int hscrlheight = 10;
    static int vscrlwidth = 10;
    static int vblockincrement = 10;
    static int hblockincrement = 1;
    private static final int T_ONTYPE = 1;
    private static final int T_VECTOR = 2;
    private static final int T_TABLE = 3;
    private static final int T_CELL = 1;
    private static final int T_ROW = 2;
    private static final int T_COL = 3;
    private static final int T_STRING = 1;
    private static final int T_PANEL = 2;
    private static final int T_RASTER = 3;
    private static final int T_LINE = 4;
    private static final int T_TOGGLE = 5;
    private static final int T_TIME = 6;
    private static final int T_CENTER = 1;
    private static final int T_RIGHT = 2;
    private static final int T_LEFT = 3;
    private boolean allowDragAndDrop = false;
    private transient StringDragSource stringDragSource = null;
    private transient StringDropTarget stringDropTarget = null;
    public static final int DND_XML = 1;
    public static final int DND_TABLE = 2;
    private int dragExportType = 1;
    private int dropImportType = 1;
    int rowheight = 20;
    int columnbuttonheight = 20;
    int rowbuttonwidth = 39;
    int colbuttondefaultwidth = 79;
    int charwidth = 10;
    int startcol = 0;
    int startrow = 0;
    int currows = 0;
    int curcols = 0;
    int xval;
    int yval;
    int dragging = 0;
    int dragCol = -1;
    int savpos = 0;
    public int selRow = -1;
    public int selColumn = -1;
    boolean gridon = true;
    boolean collabelson = true;
    boolean rowlabelson = true;
    boolean selectOne = true;
    boolean wayneMode = false;
    boolean wayneDoubleClick = false;
    boolean selectRange = false;
    int lastRow = -1;
    public static final int MULTISEL_OFF = 0;
    public static final int MULTISEL_FULL = 1;
    public static final int MULTISEL_LIST = 2;
    public int MultiSelMsgMode = 0;
    String delimiters = "\t,";
    int collabjus = 1;
    public boolean scrollEndSw = false;
    boolean scrollEnd = false;
    Color defaultsel = new Color(10502399);
    Color gridcolor = Color.darkGray;
    Scrollbar horizontalScrollbar;
    Scrollbar verticalScrollbar;
    Vector<Column> columns;
    Vector<Row> rows;
    int sortIndex = 0;
    boolean sortDesc = false;
    int outtype = 1;
    int curmode = 1;
    boolean fgHilite = false;
    boolean full = true;
    boolean needsFullDraw = false;
    transient Graphics g;
    transient Graphics mg;
    transient BufferedImage drawimg;
    public boolean autoSelect = false;
    transient Keywords templateKeys;
    public static final String refreshChoices = "Legacy,Timer";
    public static final int RM_LEGACY = 1;
    public static final int RM_TIMER = 2;
    private int refreshMode = 2;
    private final int refreshDelay = 300;
    private boolean needRefresh = false;
    private boolean inRefresh = false;
    private Timer refreshTimer;
    private transient ActionListener refreshListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (GridSheet.this.needRefresh) {
                GridSheet.this.forceRefresh();
            }
        }
    };

    public GridSheet() {
        if (!Shell.isHeadless() && !Shell.isRunningFromJarFile()) {
            this.refreshTimer = new Timer(300, this.refreshListener);
            this.refreshTimer.start();
        }
    }

    public void setDragAndDrop(boolean in) {
        if (in) {
            this.allowDragAndDrop = true;
            if (this.stringDragSource == null) {
                String meth = this.dragExportType == 1 ? "getSelectedData" : "getSelectedRowsTable";
                this.stringDragSource = new StringDragSource(this, meth, new Class[0]);
            }
            if (this.stringDropTarget == null) {
                this.stringDropTarget = new StringDropTarget(this, "dropData", new Class[]{String.class});
            }
        } else {
            this.allowDragAndDrop = false;
        }
    }

    public void setDragAndDrop(String type) {
        if ("|N|NO|F|FALSE|OFF|0|FAIL|INDEX|IND|IN|".contains(type)) {
            this.setDragAndDrop(false);
        } else if ("|Y|YES|T|TRUE|ON|1|PASS|SUCCESS|ABSC|ABS|AB|".contains(type)) {
            this.setDragAndDrop(true);
        } else {
            this.setDragDataType(type);
            this.setDropDataType(type);
            this.setDragAndDrop(true);
        }
    }

    public boolean isDragAndDropEnabled() {
        return this.allowDragAndDrop;
    }

    public void setDragDataType(String type) {
        if (type.equalsIgnoreCase("XML")) {
            this.dragExportType = 1;
        } else if (type.equalsIgnoreCase("TABLE")) {
            this.dragExportType = 2;
        }
    }

    public String getDragDataType() {
        if (this.dragExportType == 2) {
            return "TABLE";
        }
        return "XML";
    }

    public void setDropDataType(String type) {
        if (type.equalsIgnoreCase("XML")) {
            this.dropImportType = 1;
        } else if (type.equalsIgnoreCase("TABLE")) {
            this.dropImportType = 2;
        }
    }

    public String getDropDataType() {
        if (this.dragExportType == 2) {
            return "TABLE";
        }
        return "XML";
    }

    public void dropData(String inputdata) {
        try {
            Table t = new Table();
            if (inputdata == null || inputdata.length() < 7) {
                return;
            }
            if (this.dropImportType == 1) {
                XmlFile.fromXML(inputdata, t);
            } else {
                t = new Table(inputdata);
            }
            this.MW.process("DROPDATA", 0, t);
        }
        catch (Exception e) {
            System.err.println("Exception in dropData;" + e);
            e.printStackTrace();
        }
    }

    public String getSelectedData() {
        return this.getSelectedRows(this.MW.name);
    }

    public void setWayneMode(boolean wayne) {
        this.wayneMode = wayne;
    }

    public void addTo(MWindow mw) {
        try {
            this.initHierarchyListener();
            this.MW = mw;
            this.defaultsel = this.MW.theme.cwfh.darker();
            this.gridcolor = this.MW.theme.cfg.darker().darker();
            if (this.MW.panel != null) {
                this.MW.panel.add((Component)this, 0);
            }
            this.mg = this.getGraphics();
            if (this.mg != null) {
                int width = Math.max(1, this.MW.pos.w);
                int height = Math.max(1, this.MW.pos.h);
                this.drawimg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(width, height);
                this.g = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(this.drawimg);
                this.g.setFont(new Font("Monospaced", 0, 12));
                this.addComponentListener(this);
                this.addMouseListener(this);
                if (!this.allowDragAndDrop) {
                    this.addMouseMotionListener(this);
                }
                this.addMouseListener(this.MW);
                this.addKeyListener(this.MW);
                this.init();
            }
        }
        catch (Exception e) {
            System.out.println("Exception in addTo;" + e);
            e.printStackTrace();
        }
    }

    private void initHierarchyListener() {
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent evt) {
                GridSheet.this.mg = GridSheet.this.getGraphics();
            }
        });
    }

    public void close() {
        this.removeComponentListener(this);
        this.removeMouseListener(this);
        if (!this.allowDragAndDrop) {
            this.removeMouseMotionListener(this);
        }
        this.removeMouseListener(this.MW);
        this.removeKeyListener(this.MW);
        if (this.g != null) {
            this.g.dispose();
        }
        if (this.MW.panel != null) {
            this.MW.panel.remove(this);
        }
        if (this.refreshTimer != null) {
            this.refreshTimer.removeActionListener(this.refreshListener);
            this.refreshTimer.stop();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.MW == null) {
            return;
        }
        try {
            if (this.horizontalScrollbar != null && this.verticalScrollbar != null) {
                int hscroll = hscrlheight;
                if (!this.horizontalScrollbar.isVisible()) {
                    hscroll = 0;
                }
                int numVisRows = this.MW.pos.h - this.columnbuttonheight - hscroll < maxdisprows * this.rowheight + this.columnbuttonheight ? (this.MW.pos.h - this.columnbuttonheight - hscroll) / this.rowheight : maxdisprows;
                this.verticalScrollbar.setValues(this.startrow, numVisRows, 0, this.currows);
            }
        }
        catch (Exception ee) {
            System.out.println("Exception in processEvent;" + ee);
            ee.printStackTrace();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int mods = ((InputEvent)e).getModifiersEx();
        if (this.wayneMode) {
            boolean bl = this.wayneDoubleClick = e.getClickCount() == 2;
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            if ((mods & 0x40) != 0) {
                this.selectOne = false;
                this.selectRange = true;
            } else if ((mods & 0x80) != 0) {
                this.selectOne = false;
                this.selectRange = false;
            } else {
                this.selectOne = true;
                this.selectRange = false;
            }
            this.xval = e.getX();
            this.yval = e.getY();
            this.processMouse1Event(this.xval, this.yval);
            this.requestFocus();
            this.qrefresh();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.dragging = 1;
            this.setCursor(Cursor.getPredefinedCursor(11));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.xval = e.getX();
            this.yval = e.getY();
            try {
                int colCount = this.columns.size();
                int strtpos = this.rowlabelson ? this.rowbuttonwidth : 0;
                int colpos = strtpos;
                for (int i = this.startcol; i < colCount; ++i) {
                    Column gc = this.columns.elementAt(i);
                    if (!gc.visible) continue;
                    if (this.xval >= colpos && this.xval <= colpos + gc.width) {
                        this.savpos = colpos;
                        this.dragCol = i;
                    }
                    colpos += gc.width;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (this.dragging == 1 && this.dragCol != -1) {
            this.xval = e.getX();
            Column gc = this.columns.elementAt(this.dragCol);
            int newWidth = this.xval - this.savpos;
            gc.width = newWidth > gc.origWidth ? this.xval - this.savpos : gc.origWidth;
            if (gc.cellType == 2) {
                this.adjustColPanelWidth(gc.origIndex, gc.width);
            }
            this.qrefresh();
            this.dragging = 0;
            this.dragCol = -1;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.xval = e.getX();
        this.yval = e.getY();
        this.processMouseMove(this.xval, this.yval);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void init() {
        try {
            this.setLayout(null);
            this.setSize(this.MW.pos.w, this.MW.pos.h);
            this.setBackground(this.MW.theme.cbg);
            this.setFont(new Font("Monospaced", 0, 12));
            this.columns = new Vector();
            this.rows = new Vector();
            this.horizontalScrollbar = new Scrollbar(0);
            this.horizontalScrollbar.setBounds(0, this.MW.pos.h - hscrlheight, this.MW.pos.w - vscrlwidth, hscrlheight);
            this.horizontalScrollbar.setBlockIncrement(hblockincrement);
            this.horizontalScrollbar.addAdjustmentListener(new HScrollAdjustmentListener());
            this.horizontalScrollbar.setValues(0, 0, 0, 0);
            this.verticalScrollbar = new Scrollbar(1);
            this.verticalScrollbar.setBounds(this.MW.pos.w - vscrlwidth, 0, vscrlwidth, this.MW.pos.h - hscrlheight);
            this.verticalScrollbar.addAdjustmentListener(new VScrollAdjustmentListener());
            this.verticalScrollbar.setValues(0, 0, 0, 0);
            this.add(this.horizontalScrollbar);
            this.add(this.verticalScrollbar);
            GridComponentAdapter gridca = new GridComponentAdapter();
            this.addComponentListener(gridca);
            Container child = this;
            Container parent = this.getParent();
            while (parent != null) {
                if (parent instanceof JTabbedPane) {
                    ((JTabbedPane)parent).addChangeListener(this);
                }
                child = parent;
                parent = child.getParent();
            }
            this.qrefresh();
        }
        catch (Exception e) {
            System.out.println("Exception in init;" + e);
            e.printStackTrace();
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        try {
            Rectangle rect = g.getClip().getBounds();
            if (rect.width <= 1 || rect.height <= 1) {
                return;
            }
            if (this.MW == null) {
                return;
            }
            this.full = false;
            this.MW.process("REFRESH", 0, rect);
        }
        catch (Exception e) {
            System.out.println("Exception in paint;" + e);
            e.printStackTrace();
        }
    }

    public void qrefresh() {
        this.full = true;
        this.MW.process("REFRESH", 0, null);
    }

    public void refresh(boolean refreshGraphics) {
        if (refreshGraphics) {
            if (this.g != null) {
                this.g.dispose();
            }
            this.mg = this.getGraphics();
            int width = Math.max(1, this.MW.pos.w);
            int height = Math.max(1, this.MW.pos.h);
            this.drawimg = new BufferedImage(width, height, 1);
            if (!Shell.isHeadless()) {
                this.g = this.drawimg.getGraphics();
            }
        }
        this.refresh();
    }

    public void setRefreshMode(int in_mode) {
        this.refreshMode = in_mode;
    }

    private int getNumVisRows() {
        return (this.MW.pos.h - this.columnbuttonheight - hscrlheight) / this.rowheight;
    }

    public void refresh() {
        if (this.refreshMode == 2) {
            this.needRefresh = true;
        } else {
            this.forceRefresh();
        }
    }

    @Override
    public void print(Graphics pg) {
        super.print(pg);
        if (pg != null && this.drawimg != null) {
            pg.drawImage(this.drawimg, 0, 0, this);
        }
    }

    public void forceRefresh() {
        if (this.inRefresh) {
            return;
        }
        this.inRefresh = true;
        this.needRefresh = false;
        try {
            Row arow;
            int i;
            int mode;
            int width = Math.max(1, this.MW.pos.w);
            int height = Math.max(1, this.MW.pos.h);
            this.drawimg = new BufferedImage(width, height, 1);
            if (!Shell.isHeadless()) {
                this.g = this.drawimg.getGraphics();
                this.g.setFont(new Font("Monospaced", 0, 12));
            }
            if (this.g != null) {
                FontMetrics fm = this.g.getFontMetrics();
                this.charwidth = fm.charWidth('M');
                this.rowheight = fm.getHeight() + 2;
                this.g.setColor(this.MW.theme.cbg);
                if (this.full || this.needsFullDraw) {
                    this.g.fillRect(0, 0, this.MW.pos.w, this.MW.pos.h);
                }
                this.needsFullDraw = false;
                this.g.setColor(this.gridcolor);
            }
            if (this.horizontalScrollbar == null || this.verticalScrollbar == null) {
                return;
            }
            int hscroll = hscrlheight;
            if (!this.horizontalScrollbar.isVisible()) {
                hscroll = 0;
            }
            int curcolsize = 0;
            int sindex = -1;
            for (int i2 = 0; i2 < this.curcols; ++i2) {
                try {
                    Column gc = this.columns.elementAt(i2);
                    if (gc.visible) {
                        curcolsize += gc.width;
                    }
                    if (!gc.stretch) continue;
                    sindex = i2;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("out of bounds, i: " + i2);
                }
            }
            if (sindex != -1) {
                curcolsize = this.stretchColumn(sindex, curcolsize);
            }
            int rowbuttonwidth = this.rowlabelson ? this.rowbuttonwidth : 0;
            int colpos = rowbuttonwidth;
            int colIndex = this.startcol;
            int numVisCols = 0;
            int realWidth = this.MW.pos.w - rowbuttonwidth;
            int tmpsize = 0;
            int savtmp = 0;
            for (int i3 = 0; i3 < maxdispcols && colIndex <= this.curcols; ++i3) {
                try {
                    Column gc = this.columns.elementAt(colIndex);
                    if (gc.visible) {
                        int colsize = gc.width;
                        if (colsize < 0) {
                            colsize = 0;
                        }
                        if ((tmpsize += gc.width) != savtmp && tmpsize < realWidth) {
                            ++numVisCols;
                            savtmp = tmpsize;
                        }
                        colpos += colsize;
                        if (this.gridon && colsize > 0) {
                            this.g.drawLine(colpos - 1, this.columnbuttonheight, colpos - 1, this.MW.pos.h);
                        }
                    }
                    ++colIndex;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException gc) {
                    // empty catch block
                }
            }
            if (curcolsize < this.MW.pos.w) {
                this.horizontalScrollbar.setVisible(false);
                this.startcol = 0;
                this.verticalScrollbar.setBounds(this.MW.pos.w - vscrlwidth, 0, vscrlwidth, this.MW.pos.h);
            } else {
                this.horizontalScrollbar.setVisible(true);
                this.horizontalScrollbar.setValues(this.startcol, numVisCols, 0, this.curcols);
                this.verticalScrollbar.setBounds(this.MW.pos.w - vscrlwidth, 0, vscrlwidth, this.MW.pos.h - hscrlheight);
            }
            int vscroll = vscrlwidth;
            if (!this.verticalScrollbar.isVisible()) {
                vscroll = 0;
            }
            int rowpos = this.columnbuttonheight - 2;
            for (int j = 0; j < maxdisprows; ++j) {
                if (this.gridon) {
                    this.g.setColor(this.gridcolor);
                    this.g.drawLine(rowbuttonwidth, rowpos, this.MW.pos.w, rowpos);
                }
                rowpos += this.rowheight;
            }
            if (this.currows * this.rowheight + this.columnbuttonheight + hscroll <= this.MW.pos.h) {
                this.verticalScrollbar.setVisible(false);
                this.startrow = 0;
                this.horizontalScrollbar.setBounds(0, this.MW.pos.h - hscrlheight, this.MW.pos.w, hscrlheight);
            } else {
                this.verticalScrollbar.setVisible(true);
                this.horizontalScrollbar.setBounds(0, this.MW.pos.h - hscrlheight, this.MW.pos.w - vscrlwidth, hscrlheight);
                if (this.scrollEnd) {
                    int numVisRows = (this.MW.pos.h - this.columnbuttonheight - hscroll) / this.rowheight;
                    this.startrow = this.currows - numVisRows;
                    this.verticalScrollbar.setValues(this.startrow, numVisRows, 0, this.currows);
                    this.scrollEnd = false;
                }
            }
            int endcol = Math.min(this.startcol + maxdispcols, this.curcols);
            colpos = rowbuttonwidth;
            for (int j = this.startcol; j < endcol; ++j) {
                Column gc = this.columns.elementAt(j);
                if (!gc.visible) continue;
                if (gc.selected) {
                    this.g.setColor(this.defaultsel);
                    mode = -1;
                } else {
                    this.g.setColor(this.MW.theme.cwfg);
                    mode = 0;
                }
                this.shadowbox(colpos, 0, gc.width, this.columnbuttonheight, mode);
                int pos = (gc.width - gc.label.length() * this.charwidth) / 2;
                if (this.collabjus == 3) {
                    pos = 1;
                } else if (this.collabjus == 2) {
                    pos = gc.width - gc.label.length() * this.charwidth - 1;
                }
                this.g.drawString(gc.label, colpos + pos, this.columnbuttonheight - 5);
                colpos += gc.width;
            }
            int numVisRowsGap = 2;
            int endrow = Math.min(this.startrow + this.getNumVisRows() + 2, this.currows);
            rowpos = this.columnbuttonheight + this.rowheight - 2;
            for (i = 0; i < this.startrow; ++i) {
                arow = null;
                arow = this.rows.elementAt(i);
                for (int j = this.startcol; j < endcol; ++j) {
                    int jj;
                    Column gc = this.columns.elementAt(j);
                    if (!gc.visible || !(arow.cells[jj = gc.origIndex] instanceof CellPanel) && !(arow.cells[jj] instanceof CellRaster)) continue;
                    arow.cells[jj].hidePanel();
                }
            }
            i = this.startrow;
            int rowIdx = 0;
            while (i < endrow && i < this.rows.size()) {
                block61: {
                    Column gc;
                    int j;
                    arow = null;
                    try {
                        arow = this.rows.elementAt(i);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        System.out.println("out of bounds, i: " + i);
                        break block61;
                    }
                    if (arow.selected) {
                        this.g.setColor(this.defaultsel);
                        mode = -1;
                    } else {
                        this.g.setColor(this.MW.theme.cwfg);
                        mode = 0;
                    }
                    this.shadowbox(0, rowIdx * this.rowheight + this.columnbuttonheight, rowbuttonwidth - 1, this.rowheight, mode);
                    int pos = 0;
                    try {
                        pos = (rowbuttonwidth - arow.label.length() * this.charwidth) / 2;
                    }
                    catch (Exception e) {
                        System.out.println("GS: arow;" + arow + "," + arow.label + " ???");
                    }
                    if (arow.label != null) {
                        this.g.drawString(arow.label, pos, (rowIdx + 1) * this.rowheight + this.columnbuttonheight - 4);
                    }
                    colpos = rowbuttonwidth;
                    for (j = 0; j < this.startcol; ++j) {
                        int jj;
                        gc = null;
                        try {
                            gc = this.columns.elementAt(j);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            System.out.println("out of bounds, j: " + j);
                        }
                        if (!gc.visible || !(arow.cells[jj = gc.origIndex] instanceof CellPanel) && !(arow.cells[jj] instanceof CellRaster)) continue;
                        arow.cells[jj].hidePanel();
                    }
                    for (j = this.startcol; j < endcol; ++j) {
                        gc = null;
                        try {
                            gc = this.columns.elementAt(j);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            System.out.println("out of bounds, j: " + j);
                        }
                        int jj = gc.origIndex;
                        if (gc.visible) {
                            try {
                                arow.cells[jj].showPanel();
                                arow.cells[jj].setRectangle(colpos, rowpos, gc.width, this.rowheight);
                                arow.cells[jj].setMaxX(colpos + gc.width - 1);
                                if (arow.selected || gc.selected || arow.cells[j].isSelected()) {
                                    arow.cells[jj].setSelected(this.fgHilite, this.defaultsel);
                                } else {
                                    int rs = arow.rowData.size();
                                    arow.cells[jj].setColors(gc.getColorRule().getColor(arow.rowData.subList(0, rs)), arow.cells[jj].getDefBg());
                                }
                                arow.cells[jj].refresh();
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                // empty catch block
                            }
                            colpos += gc.width;
                            continue;
                        }
                        try {
                            if (!(arow.cells[jj] instanceof CellPanel) && !(arow.cells[jj] instanceof CellRaster)) continue;
                            arow.cells[jj].hidePanel();
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                    rowpos += this.rowheight;
                }
                ++i;
                ++rowIdx;
            }
            if (this.collabelson && this.rowlabelson) {
                this.shadowbox(0, 0, rowbuttonwidth, this.columnbuttonheight, 0);
            }
            if (vscroll > 0 && hscroll > 0) {
                this.shadowbox(this.MW.pos.w - vscrlwidth, this.MW.pos.h - hscrlheight, hscrlheight, vscrlwidth, 0);
            }
            if (this.mg != null) {
                this.mg.drawImage(this.drawimg, 0, 0, this);
            }
        }
        catch (Exception e) {
            if (e instanceof ArrayIndexOutOfBoundsException) {
                Shell.writeln("Out of Bounds " + e);
            }
            Shell.printStackTrace("Exception in GridSheet.refresh(): " + e, e);
        }
        this.inRefresh = false;
        this.needRefresh = false;
    }

    @Override
    public int processMessage(Message msg) {
        return this.processMessage(msg, null, null);
    }

    public int processMessage(Message msg, Object msgid, Object parent) {
        int stat = 1;
        boolean done = false;
        for (int i = 0; i < this.curcols; ++i) {
            try {
                Column gc = this.columns.elementAt(i);
                if (!gc.label.equalsIgnoreCase(msg.name)) continue;
                Table t = new Table();
                t.put("TYPE", (Object)"CELL");
                t.put("ROW", (Object)gc.selRow);
                t.put("COLUMN", (Object)gc.subr);
                t.put("NAME", (Object)gc.subr);
                EnumColorRule erule = (EnumColorRule)gc.getColorRule();
                String mitem = Convert.o2s(msg.data);
                t.put("ITEM", (Object)mitem);
                if (this.selectOne) {
                    t.put("SELECTONE", 1);
                } else {
                    t.put("SELECTONE", 0);
                }
                if (this.selectRange) {
                    t.put("SELECTRANGE", 1);
                } else {
                    t.put("SELECTRANGE", 0);
                }
                Table.Iterator ti = erule.dataTable.iterator();
                while (ti.getNext() && !done) {
                    String dKey = ti.key;
                    String dVal = Convert.o2s(ti.value).toUpperCase();
                    if (!dVal.equalsIgnoreCase(mitem)) continue;
                    t.put("VALUE", (Object)dKey);
                    done = true;
                }
                this.setCell(t);
                this.MW.process("SELECT", 0, t);
                continue;
            }
            catch (Exception e) {
                System.out.println("Exception in processMessage;" + e);
                e.printStackTrace();
            }
        }
        return stat;
    }

    private void adjustColPanelWidth(int colIndex, int newWidth) {
        try {
            for (int i = 0; i < this.currows; ++i) {
                try {
                    Row arow = this.rows.elementAt(i);
                    Component[] c = ((CellPanel)arow.cells[colIndex]).cellPanel.getComponents();
                    for (int j = 0; j < c.length; ++j) {
                        c[j].setSize(newWidth, this.rowheight);
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aie) {
                    System.out.println("out of bounds, i: " + i);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in adjustColPanelWidth;" + e);
            e.printStackTrace();
        }
    }

    private void setColLabels(String[] plabels, int labelcount, boolean repaint) {
        try {
            for (int i = 0; i < labelcount; ++i) {
                Column gc = new Column();
                gc.subr = plabels[i].trim();
                gc.label = plabels[i].trim();
                gc.width = (plabels[i].length() + 2) * this.charwidth;
                gc.index = i;
                gc.origIndex = i;
                gc.cellType = 1;
                gc.setColorRule(new ConstColorRule(this.MW.theme.cfg));
                if (this.columns == null) continue;
                this.columns.addElement(gc);
            }
            this.curcols = labelcount;
            if (repaint) {
                this.qrefresh();
            }
        }
        catch (Exception e) {
            System.out.println("Exception in setColLabels:" + e);
            e.printStackTrace();
        }
    }

    private void addRows(Vector<? super Object> values, int rowSize, boolean repaint, int rowPos) {
        try {
            int index = 0;
            for (int i = 0; i < values.size(); i += rowSize) {
                Row arow = new Row(rowSize);
                index = i;
                int k = 0;
                for (int j = 0; j < rowSize; ++j) {
                    Column gc = this.columns.elementAt(j);
                    k = gc.origIndex;
                    if (gc.definedColor == null) {
                        gc.definedColor = this.MW.theme.cfg;
                    }
                    arow.cells[k] = gc.cellType == 2 ? new CellPanel(this.MW, this, this.MW.theme.cbg, this.MW.theme.cfg) : (gc.cellType == 5 ? new CellToggle(this.MW.theme.cbg, this.MW.theme.cfg) : (gc.cellType == 3 ? new CellRaster(this.MW, gc.rasterFrame, gc.rasterLevels, gc.rasterColorMap, gc.rasterSelColor) : (gc.cellType == 6 ? new CellString(gc.getColorRule().getColor(values.subList(index, index + rowSize)), this.MW.theme.cbg, gc.timeFormat) : new CellString(gc.getColorRule().getColor(values.subList(index, index + rowSize)), this.MW.theme.cbg))));
                    if (values.elementAt(k + index) instanceof String && gc.nf == null && !gc.dms) {
                        if (gc.getColorRule() instanceof EnumColorRule) {
                            if (values.elementAt(k + index).toString().length() > 0) {
                                arow.cells[k].setData(gc.getColorRule().getData(values.elementAt(k + index).toString()).trim());
                                arow.cells[k].setColors(gc.getColorRule().getColor(values.subList(index, index + rowSize)), arow.cells[k].getDefBg());
                            } else {
                                arow.cells[k].setData("ERROR");
                            }
                        } else {
                            arow.cells[k].setData(values.elementAt(k + index).toString().trim());
                            arow.cells[k].setColors(gc.getColorRule().getColor(values.subList(index, index + rowSize)), arow.cells[k].getDefBg());
                        }
                        arow.rowData.addElement(arow.cells[k].getData());
                    } else {
                        if (gc.getColorRule() instanceof EnumColorRule) {
                            String s = gc.getColorRule().getData(values.elementAt(k + index).toString());
                            values.setElementAt(s, k + index);
                        } else {
                            String str = values.elementAt(k + index).toString();
                            if (str.length() > 0) {
                                Double d = Double.valueOf(str);
                                values.setElementAt(d, k + index);
                            } else {
                                values.setElementAt(str, k + index);
                            }
                        }
                        String data = "";
                        Object aValue = values.elementAt(k + index);
                        data = aValue instanceof Double ? gc.format((Double)aValue) : values.elementAt(k + index).toString().trim();
                        arow.cells[k].setData(data);
                        arow.cells[k].setColors(gc.getColorRule().getColor(values.subList(index, index + rowSize)), arow.cells[k].getDefBg());
                        arow.rowData.addElement(values.elementAt(k + index));
                    }
                    if (gc.cellType == 3) {
                        arow.rowData.setElementAt(arow.cells[k].getDataObj(), k + index);
                    }
                    if (gc.width == this.colbuttondefaultwidth) {
                        gc.width = (arow.cells[k].getData().length() + 2) * this.charwidth;
                    }
                    if ((arow.cells[k].getData().length() + 2) * this.charwidth > gc.width) {
                        gc.width = (arow.cells[k].getData().length() + 2) * this.charwidth;
                    }
                    if (gc.label.length() == 0) {
                        gc.label = "F" + (j + 1);
                    }
                    if ((gc.label.length() + 1) * this.charwidth > gc.width) {
                        gc.width = (gc.label.length() + 1) * this.charwidth;
                    }
                    if (gc.origWidth == 0) {
                        gc.origWidth = gc.width;
                    }
                    this.columns.setElementAt(gc, j);
                }
                if (rowPos > 0) {
                    if (--rowPos > this.rows.size()) {
                        rowPos = this.rows.size();
                    }
                    this.rows.insertElementAt(arow, rowPos);
                } else {
                    this.rows.addElement(arow);
                }
                this.currows = this.rows.size();
                if (rowPos > 0) {
                    this.renumberRows(false);
                } else {
                    arow.label = "" + this.currows;
                }
                this.rowbuttonwidth = Math.max(this.rowbuttonwidth, (arow.label.length() + 1) * this.charwidth);
                if (rowSize > this.curcols) {
                    this.curcols = rowSize;
                }
                int hscroll = hscrlheight;
                if (!this.horizontalScrollbar.isVisible()) {
                    hscroll = 0;
                }
                int numVisRows = this.MW.pos.h - this.columnbuttonheight - hscroll < maxdisprows * this.rowheight + this.columnbuttonheight ? (this.MW.pos.h - this.columnbuttonheight - hscroll) / this.rowheight : maxdisprows;
                this.verticalScrollbar.setValues(0, numVisRows, 0, this.currows);
                if (!repaint) continue;
                this.qrefresh();
            }
        }
        catch (Exception e) {
            System.out.println("Exception in addRow:" + e);
            e.printStackTrace();
        }
    }

    private void pollRows(Vector<?> values, int rowSize, boolean repaint, int row) {
        try {
            int index = 0;
            for (int i = 0; i < values.size(); i += rowSize) {
                Row arow = this.rows.elementAt(row);
                index = i;
                int k = 0;
                for (int j = 0; j < rowSize; ++j) {
                    Column gc = this.columns.elementAt(j);
                    k = gc.origIndex;
                    if (gc.getColorRule() instanceof EnumColorRule) {
                        arow.cells[k].setData(gc.getColorRule().getData(values.elementAt(k + index).toString()));
                    } else {
                        arow.cells[k].setData(values.elementAt(k + index).toString());
                    }
                    arow.cells[k].refresh();
                }
                this.rows.set(row, arow);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in pollRows:" + e);
            e.printStackTrace();
        }
    }

    private int stretchColumn(int sindex, int currTotalWidth) {
        try {
            int colsize = currTotalWidth;
            int vscroll = !this.verticalScrollbar.isVisible() ? 0 : vscrlwidth;
            int rbw = this.rowlabelson ? this.rowbuttonwidth : 0;
            Column gc = this.columns.elementAt(sindex);
            if (colsize > this.MW.pos.w) {
                colsize -= gc.width;
                colsize += gc.origWidth;
                gc.width = gc.origWidth;
            }
            if (colsize < this.MW.pos.w - 1) {
                int diff = this.MW.pos.w - colsize - rbw - vscroll;
                colsize -= gc.width;
                gc.width = gc.width + diff - 1;
                colsize += gc.width;
            }
            return colsize;
        }
        catch (Exception e) {
            System.out.println("Exception in stretchColumn:" + e);
            e.printStackTrace();
            return currTotalWidth;
        }
    }

    private void processMouseMove(int xval, int yval) {
        try {
            String tmp = null;
            if (xval <= 0 && yval <= 0) {
                return;
            }
            int selRow = (yval - this.columnbuttonheight + this.startrow * this.rowheight) / this.rowheight;
            if (selRow > this.currows) {
                return;
            }
            try {
                if (!this.rowlabelson || xval >= this.rowbuttonwidth - 1) {
                    Row arow = this.rows.elementAt(selRow);
                    int colpos = this.rowbuttonwidth;
                    for (int i = this.startcol; i < arow.count; ++i) {
                        if (this.collabelson && yval < this.columnbuttonheight) continue;
                        Column gc = this.columns.elementAt(i);
                        int oi = gc.origIndex;
                        if (!arow.cells[oi].inXBounds(xval)) continue;
                        if (gc.cellType == 3) {
                            boolean found = ((CellRaster)arow.cells[oi]).getValueDisp(new Point(xval, yval));
                            tmp = ((CellRaster)arow.cells[oi]).getData(gc.label.toLowerCase());
                            continue;
                        }
                        if (gc.cellType != 1) continue;
                        tmp = ((CellString)arow.cells[oi]).getData();
                    }
                }
                this.MW.setAltTitle(tmp);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        catch (Exception e) {
            System.out.println("Exception in strecthColumn:" + e);
            e.printStackTrace();
        }
    }

    private void processMouse1Event(int xval, int yval) {
        try {
            if (xval <= 0 && yval <= 0) {
                return;
            }
            int selRow = (yval - this.columnbuttonheight + this.startrow * this.rowheight) / this.rowheight;
            if (selRow > this.currows) {
                return;
            }
            try {
                if (this.rowlabelson && xval < this.rowbuttonwidth - 1) {
                    this.processSelection("ROW", selRow, -1);
                } else if (this.collabelson && yval < this.columnbuttonheight) {
                    int colpos;
                    Row arow = this.rows.elementAt(selRow);
                    int n = colpos = this.rowlabelson ? this.rowbuttonwidth : 0;
                    for (int i = this.startcol; i < arow.count; ++i) {
                        Column gc = this.columns.elementAt(i);
                        if (!gc.visible) continue;
                        if (xval >= colpos && xval <= colpos + gc.width) {
                            this.processSelection("COLUMN", -1, i);
                        }
                        colpos += gc.width;
                    }
                } else if (this.curmode == 2) {
                    this.processSelection("ROW", selRow, -1);
                } else {
                    int colpos;
                    Row arow = this.rows.elementAt(selRow);
                    int n = colpos = this.rowlabelson ? this.rowbuttonwidth : 0;
                    for (int i = this.startcol; i < arow.count; ++i) {
                        Column gc = this.columns.elementAt(i);
                        if (this.curmode == 3) {
                            if (xval >= colpos && xval <= colpos + gc.width) {
                                if (gc.visible) {
                                    this.processSelection("COLUMN", -1, i);
                                }
                                return;
                            }
                            colpos += gc.width;
                            continue;
                        }
                        int oi = gc.origIndex;
                        if (!arow.cells[oi].inXBounds(xval)) continue;
                        if (gc.cellType == 3) {
                            boolean bl = ((CellRaster)arow.cells[oi]).getValue(new Point(xval, yval));
                        } else if (gc.cellType == 5) {
                            arow.cells[oi].toggle();
                        }
                        this.processSelection("CELL", selRow, i);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
        }
        catch (Exception e) {
            System.out.println("Exception in processMouse1Event:" + e);
            e.printStackTrace();
        }
    }

    private void shadowbox(int x, int y, int w, int h, int mode) {
        try {
            if (this.g == null) {
                return;
            }
            if (mode == 0) {
                this.g.setColor(this.MW.theme.cwbg);
            } else {
                this.g.setColor(this.MW.theme.cwbg);
            }
            if (mode == -2) {
                this.g.fillRect(x, y, w, h);
                this.g.setColor(this.MW.theme.cfg);
                return;
            }
            if (mode == 0 || mode == -1) {
                this.g.fillRect(x, y, w, h);
            }
            if (mode >= 0) {
                this.g.setColor(this.MW.theme.cwts);
            } else {
                this.g.setColor(this.MW.theme.cwbs);
            }
            this.g.drawLine(x, y, x + w - 1, y);
            this.g.drawLine(x, y + 1, x + w - 2, y + 1);
            this.g.drawLine(x, y, x, y + h - 1);
            this.g.drawLine(x + 1, y, x + 1, y + h - 2);
            if (mode >= 0) {
                this.g.setColor(this.MW.theme.cwbs);
            } else {
                this.g.setColor(this.MW.theme.cwts);
            }
            this.g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            this.g.drawLine(x + 1, y + h - 2, x + w - 1, y + h - 2);
            this.g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            this.g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 1);
            if (mode == 2) {
                this.g.setColor(this.MW.theme.cbg);
                this.g.drawLine(x + 2, y + 2, x + w - 3, y + h - 3);
            }
            this.g.setColor(this.MW.theme.cfg);
        }
        catch (Exception e) {
            System.out.println("Exception in shadowbox:" + e);
            e.printStackTrace();
        }
    }

    private void renumberRows(boolean repaint) {
        try {
            for (int i = 0; i < this.currows; ++i) {
                Row arow = this.rows.elementAt(i);
                arow.label = "" + (i + 1);
                this.rowbuttonwidth = Math.max(this.rowbuttonwidth, (arow.label.length() + 1) * this.charwidth);
            }
            if (repaint) {
                this.qrefresh();
            }
        }
        catch (Exception e) {
            System.out.println("Exception in renumberRows:" + e);
            e.printStackTrace();
        }
    }

    public int getColIndex(String subrName, boolean ignorecase) {
        try {
            for (int i = 0; i < this.curcols; ++i) {
                Column gc = this.columns.elementAt(i);
                if (!ignorecase && subrName.equals(gc.subr)) {
                    return gc.origIndex;
                }
                if (!ignorecase || !subrName.equalsIgnoreCase(gc.subr)) continue;
                return gc.origIndex;
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getColIndex:" + e);
            e.printStackTrace();
        }
        return -1;
    }

    public int getColIndex(String subrName) {
        try {
            return this.getColIndex(subrName, false);
        }
        catch (Exception e) {
            System.out.println("Exception in getColIndex:" + e);
            e.printStackTrace();
            return -1;
        }
    }

    private Column getColByName(String subrName, boolean ignorecase) {
        try {
            for (int i = 0; i < this.curcols; ++i) {
                Column gc = this.columns.elementAt(i);
                if (ignorecase && subrName.equalsIgnoreCase(gc.subr)) {
                    return gc;
                }
                if (ignorecase || !subrName.equals(gc.subr)) continue;
                return gc;
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getColByName:" + e);
            e.printStackTrace();
        }
        return null;
    }

    private Column getColByName(String subrName) {
        try {
            return this.getColByName(subrName, false);
        }
        catch (Exception e) {
            System.out.println("Exception in getColByName:" + e);
            e.printStackTrace();
            return null;
        }
    }

    private Row getRowByIndex(int index) {
        try {
            Row arow = null;
            try {
                if (this.rows != null) {
                    arow = this.rows.elementAt(index - 1);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            return arow;
        }
        catch (Exception e) {
            System.out.println("Exception in getRowByIndex;" + e);
            e.printStackTrace();
            return null;
        }
    }

    private void setSelect(int rowIdx, int colIdx) {
        this.selRow = rowIdx;
        this.selColumn = colIdx;
    }

    public int getMultiSelMsgMode() {
        return this.MultiSelMsgMode;
    }

    public void setMultiSelMsgMode(String ms_mode) {
        if (ms_mode.equals("FULL")) {
            this.setMultiSelMsgMode(1);
        } else {
            this.setMultiSelMsgMode(0);
        }
    }

    public void setMultiSelMsgMode(int ms_mode) {
        if (ms_mode == 2) {
            System.out.println("WARNING: Multi select mode LIST " + ms_mode + " is TBD. Setting mode OFF.");
            this.MultiSelMsgMode = 0;
        } else {
            this.MultiSelMsgMode = ms_mode;
        }
    }

    public boolean getMultiSelMode() {
        return !this.selectOne || this.selectRange;
    }

    public boolean getGrid() {
        return this.gridon;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColCount() {
        return this.columns.size();
    }

    public boolean getColLabelsVisible() {
        return this.collabelson;
    }

    public boolean getRowLabelsVisible() {
        return this.rowlabelson;
    }

    public int getRowHeight() {
        return this.rowheight;
    }

    public int getHighlight() {
        return this.defaultsel.getRGB();
    }

    public int getOutputType() {
        return this.outtype;
    }

    public Object getCell(int row, int column) {
        Object obj = null;
        Column gc = null;
        Row arow = null;
        try {
            gc = this.columns.elementAt(column - 1);
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.out.println("Column index out of bounds: " + column);
            return obj;
        }
        try {
            arow = this.rows.elementAt(row - 1);
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            return obj;
        }
        obj = arow.cells[gc.origIndex].getDataObj();
        return obj;
    }

    public Object getCell(int rowIndx, String subrName) {
        Object obj = null;
        Row arow = null;
        try {
            arow = this.rows.elementAt(rowIndx - 1);
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            return obj;
        }
        int colIndx = this.getColIndex(subrName);
        if (colIndx != -1) {
            obj = arow.cells[colIndx].getDataObj();
        }
        return obj;
    }

    public Object getRow(int index, int type) {
        Iterable<String> obj = null;
        Row arow = this.getRowByIndex(index);
        if (arow != null) {
            switch (type) {
                case 3: {
                    obj = arow.toTable();
                    break;
                }
                default: {
                    obj = arow.rowData;
                }
            }
        }
        return obj;
    }

    public Object getRowVector(int index) {
        return this.getRow(index, 2);
    }

    public Object getRowTable(int index) {
        return this.getRow(index, 3);
    }

    public Object getRow(int index) {
        return this.getRow(index, this.outtype);
    }

    public Object getSelectedRowData() {
        if (this.selRow == -1) {
            return null;
        }
        return this.getRow(this.selRow);
    }

    public Object getRows(int type) {
        Object obj = null;
        switch (type) {
            case 3: {
                obj = this.getAllRows();
                break;
            }
            default: {
                obj = this.getRowsVector();
            }
        }
        return obj;
    }

    public Object getRowsVector() {
        int numRows = this.rows.size();
        Vector<Object> vov = new Vector<Object>(numRows);
        for (int i = 0; i < numRows; ++i) {
            vov.addElement(this.getRowVector(i + 1));
        }
        return vov;
    }

    public Object getRowsTable() {
        return this.getAllRows();
    }

    public Object getAllRows() {
        Table retTable = new Table();
        try {
            Row arow = null;
            this.currows = this.rows.size();
            for (int i = 0; i < this.currows; ++i) {
                arow = this.rows.elementAt(i);
                String tmpstr = "" + (i + 1);
                retTable.put(tmpstr, this.getRowTable(i + 1));
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getAllRows:" + e);
            e.printStackTrace();
        }
        return retTable;
    }

    public int getRowByValue(Table t) {
        Vector v;
        int index = 0;
        Object obj = t.get("COLUMN");
        if (obj instanceof String) {
            String subrName = Convert.o2s(obj);
            v = (Vector)this.getColumnVector(subrName);
        } else {
            int colIndx = Convert.o2l(obj);
            v = (Vector)this.getColumnVector(colIndx);
        }
        Object val = t.get("VALUE");
        int vsize = v.size();
        for (int i = 0; i < vsize; ++i) {
            if (!v.elementAt(i).equals(val)) continue;
            return i + 1;
        }
        return index;
    }

    public Object getColumn(int colIdx, int type) {
        Iterable<String> obj = null;
        Column gc = null;
        try {
            gc = this.columns.elementAt(colIdx - 1);
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.out.println("Column index out of bounds: " + colIdx);
            return obj;
        }
        switch (type) {
            case 3: {
                obj = gc.toTable(this.rows);
                break;
            }
            default: {
                obj = gc.toVector(this.rows);
            }
        }
        return obj;
    }

    public Object getColumn(String subrName, int type) {
        Iterable<String> obj = null;
        Column gc = this.getColByName(subrName);
        if (gc != null) {
            switch (type) {
                case 3: {
                    obj = gc.toTable(this.rows);
                    break;
                }
                default: {
                    obj = gc.toVector(this.rows);
                }
            }
        }
        return obj;
    }

    public Object getColumn(int colIdx) {
        return this.getColumn(colIdx, this.outtype);
    }

    public Object getColumnTable(int colIdx) {
        return this.getColumn(colIdx, 3);
    }

    public Object getColumnVector(int colIdx) {
        return this.getColumn(colIdx, 2);
    }

    public Object getColumn(String subrName) {
        return this.getColumn(subrName, this.outtype);
    }

    public Object getColumnTable(String subrName) {
        return this.getColumn(subrName, 3);
    }

    public Object getColumnVector(String subrName) {
        return this.getColumn(subrName, 2);
    }

    public Object getSelectedColumnData() {
        if (this.selColumn == -1) {
            return null;
        }
        return this.getColumn(this.selColumn);
    }

    public Object getSelRowsTable() {
        Table retTable = new Table();
        try {
            Row arow = null;
            this.currows = this.rows.size();
            for (int i = 0; i < this.currows; ++i) {
                arow = this.rows.elementAt(i);
                if (!arow.selected) continue;
                String tmpstr = "" + (i + 1);
                retTable.put(tmpstr, this.getRowTable(i + 1));
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getSelRowsTable:" + e);
            e.printStackTrace();
        }
        return retTable;
    }

    public Object getSelRowsVector() {
        Vector<Object> retVec = new Vector<Object>();
        try {
            Row arow = null;
            this.currows = this.rows.size();
            for (int i = 0; i < this.currows; ++i) {
                arow = this.rows.elementAt(i);
                if (!arow.selected) continue;
                retVec.addElement(this.getRowVector(i + 1));
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getSelRowsVector:" + e);
            e.printStackTrace();
        }
        return retVec;
    }

    public String getSelectedRows() {
        String returnvalue = new String();
        returnvalue = "<SELECTED>";
        try {
            Row arow = null;
            this.currows = this.rows.size();
            for (int i = 0; i < this.currows; ++i) {
                arow = this.rows.elementAt(i);
                if (!arow.selected) continue;
                returnvalue = returnvalue + "<ROW " + (i + 1) + ">";
                for (int j = 0; j < arow.count; ++j) {
                    returnvalue = returnvalue + "<VALUE " + (j + 1) + ">" + arow.cells[j].getData() + "</VALUE " + (j + 1) + ">";
                }
                returnvalue = returnvalue + "</ROW " + (i + 1) + ">";
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getSelectedRows:" + e);
            e.printStackTrace();
        }
        returnvalue = returnvalue + "</SELECTED>";
        return returnvalue;
    }

    public String getSelectedRows(String tagname) {
        String returnvalue = null;
        try {
            this.currows = this.rows.size();
            if (this.currows > 0) {
                returnvalue = "<" + tagname + ">";
                Row arow = null;
                for (int i = 0; i < this.currows; ++i) {
                    arow = this.rows.elementAt(i);
                    if (!arow.selected) continue;
                    returnvalue = returnvalue + "<ROW ";
                    for (int j = 0; j < arow.count; ++j) {
                        Column gc = this.columns.elementAt(j);
                        String tgc = gc.label.replaceAll(" ", "_");
                        returnvalue = returnvalue + tgc + "=\"" + arow.cells[j].getData() + "\" ";
                    }
                    returnvalue = returnvalue + " />";
                }
                returnvalue = returnvalue + "</" + tagname + ">";
            }
        }
        catch (Exception e) {
            System.err.println("Exception in getSelectedRows:" + e);
            e.printStackTrace();
        }
        return returnvalue;
    }

    public Table getSelectedRowsTable() {
        Table t = new Table();
        try {
            Row arow = null;
            this.currows = this.rows.size();
            int c = 1;
            for (int i = 0; i < this.currows; ++i) {
                arow = this.rows.elementAt(i);
                if (!arow.selected) continue;
                Table r = new Table();
                for (int j = 0; j < arow.count; ++j) {
                    Column gc = this.columns.elementAt(j);
                    String tgc = gc.label;
                    r.put(tgc.toUpperCase(), (Object)arow.cells[j].getData());
                }
                r.put("ROWNUM", i + 1);
                t.put("ROW_" + c, (Object)r);
                ++c;
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getSelectedRowsTable:" + e);
            e.printStackTrace();
        }
        return t;
    }

    public int getSelectedRow() {
        return this.selRow;
    }

    public boolean isRowSelected(int i) {
        return this.rows.elementAt((int)(i - 1)).selected;
    }

    public int getRowSelected(int i) {
        if (this.rows.elementAt((int)(i - 1)).selected) {
            return 1;
        }
        return 0;
    }

    public int getSelectedColumn() {
        return this.selColumn;
    }

    public Table getSelectedCell() {
        Table t = new Table();
        t.put("ROW", this.selRow);
        t.put("COLUMN", this.selColumn);
        return t;
    }

    public Object getSelectedCellData() {
        if (this.selRow == -1 || this.selColumn == -1) {
            return null;
        }
        return this.getCell(this.selRow, this.selColumn);
    }

    public Vector<?> getColumnPanels(String subrName) {
        Vector<Object> retVec = new Vector();
        Column gc = this.getColByName(subrName);
        if (gc != null) {
            if (gc.cellType != 2) {
                retVec = this.changeColumnRender(subrName, 2);
            } else {
                for (int j = 0; j < this.currows; ++j) {
                    Row arow = this.rows.elementAt(j);
                    CellPanel cp = new CellPanel(this.MW, this, this.MW.theme.cbg, this.MW.theme.cfg);
                    retVec.addElement(cp.cellPanel);
                }
            }
        }
        return retVec;
    }

    public Vector<Object> changeColumnRender(String subrName, int type) {
        Vector<Object> retVec = new Vector<Object>();
        int changeIdx = 0;
        Column gc = this.getColByName(subrName);
        if (gc != null) {
            changeIdx = gc.origIndex;
            if (gc.cellType == type) {
                return null;
            }
            gc.cellType = type;
        }
        for (int i = 0; i < this.currows; ++i) {
            CellPanel cp;
            CellString cs;
            Row arow = this.rows.elementAt(i);
            if (type == 2) {
                CellPanel cp2 = new CellPanel(this.MW, this, this.MW.theme.cbg, this.MW.theme.cfg);
                retVec.addElement(cp2.cellPanel);
                cp2.setData(arow.cells[changeIdx].getData());
                arow.cells[changeIdx] = cp2;
                continue;
            }
            if (type == 3) {
                CellRaster cr = new CellRaster(this.MW);
                arow.cells[changeIdx] = cr;
                cr.setData(arow.cells[changeIdx].getData());
                arow.rowData.setElementAt(arow.cells[changeIdx].getDataObj(), changeIdx - 1);
                continue;
            }
            if (type == 5) {
                CellToggle ct = new CellToggle(this.MW.theme.cbg, this.MW.theme.cfg);
                arow.cells[changeIdx] = ct;
                ct.setData(arow.cells[changeIdx].getData());
                arow.rowData.setElementAt(arow.cells[changeIdx].getDataObj(), changeIdx - 1);
                continue;
            }
            if (type == 6) {
                cs = new CellString(this.MW.theme.cbg, this.MW.theme.cfg, gc.timeFormat);
                retVec.addElement(cs.getData());
                if (arow.cells[changeIdx] instanceof CellPanel) {
                    cp = (CellPanel)arow.cells[changeIdx];
                    cp.cellPanel.setBackground(this.MW.theme.cbg);
                    this.remove(cp.cellPanel);
                }
                cs.setData(arow.cells[changeIdx].getData());
                arow.cells[changeIdx] = cs;
                continue;
            }
            cs = new CellString(this.MW.theme.cbg, this.MW.theme.cfg);
            retVec.addElement(cs.getData());
            if (arow.cells[changeIdx] instanceof CellPanel) {
                cp = (CellPanel)arow.cells[changeIdx];
                cp.cellPanel.setBackground(this.MW.theme.cbg);
                this.remove(cp.cellPanel);
            }
            cs.setData(arow.cells[changeIdx].getData());
            arow.cells[changeIdx] = cs;
        }
        this.qrefresh();
        return retVec;
    }

    public void setRasterData(Table t, byte[] buf) {
        CellRaster cr;
        int rowIndx = Convert.o2l(t.get("ROW"));
        Object obj = t.get("COLUMN");
        if (obj instanceof String) {
            String subrName = Convert.o2s(obj);
            cr = (CellRaster)this.getCell(rowIndx - 1, subrName);
        } else {
            int colIndx = Convert.o2l(obj);
            cr = (CellRaster)this.getCell(rowIndx - 1, colIndx);
        }
        cr.setData(buf);
        this.qrefresh();
    }

    public void setCell(Table t) {
        Object obj = t.get("VALUE");
        if (obj == null) {
            return;
        }
        int rowIdx = Convert.o2l(t.get("ROW"));
        if (rowIdx == -2) {
            rowIdx = this.getSelectedRow();
        }
        if (rowIdx == -1) {
            return;
        }
        Object colObj = t.get("COLUMN");
        if (colObj == null) {
            colObj = t.get("NAME");
        }
        if (colObj instanceof String) {
            String subrName = Convert.o2s(colObj);
            this.setCell(rowIdx, subrName, obj);
        } else {
            int colIdx = Convert.o2l(colObj);
            this.setCell(rowIdx, colIdx, obj);
        }
    }

    public void setCell(int rowIdx, int colIdx, Object val) {
        Row arow;
        Column gc;
        try {
            gc = this.columns.elementAt(colIdx - 1);
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.out.println("Column index out of bounds: " + colIdx);
            return;
        }
        try {
            if (rowIdx == -2) {
                rowIdx = this.getSelectedRow();
            }
            if (rowIdx == -1) {
                return;
            }
            arow = this.rows.elementAt(rowIdx - 1);
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            return;
        }
        if (gc.cellType == 1 || gc.cellType == 6) {
            arow.cells[gc.origIndex].setData(gc.getColorRule().getData(val.toString()));
            arow.rowData.setElementAt(val, gc.origIndex);
            int rs = arow.rowData.size();
            arow.cells[gc.origIndex].setColors(gc.getColorRule().getColor(arow.rowData.subList(0, rs)), arow.cells[gc.origIndex].getDefBg());
        } else if (gc.cellType == 5) {
            arow.cells[gc.origIndex].setDataObj(val);
            arow.rowData.setElementAt(val, gc.origIndex);
        } else if (gc.cellType == 3) {
            arow.cells[gc.origIndex].setDataObj(val);
        }
        this.qrefresh();
    }

    public void setCell(int rowIdx, String subrName, Object val) {
        Column gc = this.getColByName(subrName);
        if (gc != null) {
            Row arow;
            try {
                if (rowIdx == -2) {
                    rowIdx = this.getSelectedRow();
                }
                if (rowIdx == -1) {
                    return;
                }
                arow = this.rows.elementAt(rowIdx - 1);
            }
            catch (ArrayIndexOutOfBoundsException aie) {
                return;
            }
            if (gc.cellType == 1 || gc.cellType == 6) {
                arow.cells[gc.origIndex].setData(gc.getColorRule().getData(val.toString()));
                arow.rowData.setElementAt(val, gc.origIndex);
                int rs = arow.rowData.size();
                arow.cells[gc.origIndex].setColors(gc.getColorRule().getColor(arow.rowData.subList(0, rs)), arow.cells[gc.origIndex].getDefBg());
            } else if (gc.cellType == 5) {
                arow.cells[gc.origIndex].setDataObj(val);
                arow.rowData.setElementAt(val, gc.origIndex);
            } else if (gc.cellType == 3) {
                arow.cells[gc.origIndex].setDataObj(val);
            }
        }
        this.qrefresh();
    }

    public void setAutoSelect(boolean autoon) {
        this.autoSelect = autoon;
    }

    public void setGrid(boolean on) {
        this.gridon = on;
        this.qrefresh();
    }

    public void setTemplate(Keywords keys) {
        this.templateKeys = keys;
        this.qrefresh();
    }

    public void setColVisible(String subrName, boolean onoff) {
        for (int i = 0; i < this.curcols; ++i) {
            Column gc = this.columns.elementAt(i);
            if (subrName.equals("ALLCOLUMNS")) {
                gc.visible = onoff;
                continue;
            }
            if (!subrName.equals(gc.subr)) continue;
            gc.visible = onoff;
        }
        this.qrefresh();
    }

    public void setColWidth(String subrName, int width) {
        for (int i = 0; i < this.curcols; ++i) {
            Column gc = this.columns.elementAt(i);
            if (!subrName.equals(gc.subr)) continue;
            gc.width = width;
        }
        this.qrefresh();
    }

    public void setColWidth(String subrName) {
        for (int i = 0; i < this.curcols; ++i) {
            Column gc = this.columns.elementAt(i);
            if (!subrName.equals(gc.subr)) continue;
            gc.width = gc.origWidth;
        }
        this.qrefresh();
    }

    public int getColWidth(String subrName) {
        Column gc = null;
        for (int i = 0; i < this.curcols; ++i) {
            gc = this.columns.elementAt(i);
            if (subrName.equals(gc.subr)) break;
        }
        if (gc == null) {
            return -1;
        }
        return gc.width;
    }

    public void setCursorMode(int value) {
        this.curmode = value;
        this.deselectAll();
        this.qrefresh();
    }

    public void setHighlight(int value) {
        this.defaultsel = MColor.getColorByIndex(value);
        this.qrefresh();
    }

    public void setHighlight(Color clr) {
        this.defaultsel = clr;
        this.qrefresh();
    }

    public void setHighlight(String value) {
        this.defaultsel = MColor.getColor(value);
        this.qrefresh();
    }

    public void setCellColors(int column, int row, Color fg, Color bg) {
        int colToUse = column - 1;
        for (int j = 0; j < this.columns.size(); ++j) {
            Column gc = this.columns.elementAt(j);
            if (gc.field != column) continue;
            colToUse = gc.origIndex;
        }
        Row arow = this.rows.elementAt(row - 1);
        if (fg == null) {
            fg = this.MW.theme.getForeground();
        }
        if (bg == null) {
            bg = this.MW.theme.getBackground();
        }
        arow.cells[colToUse].setColors(fg, bg);
        this.qrefresh();
    }

    public void setRowColors(int row, Color fg, Color bg) {
        if (fg == null) {
            fg = this.MW.theme.getForeground();
        }
        if (bg == null) {
            bg = this.MW.theme.getBackground();
        }
        Row arow = this.rows.elementAt(row - 1);
        for (int i = 0; i < arow.count; ++i) {
            arow.cells[i].setColors(fg, bg);
        }
        this.qrefresh();
    }

    public void setColColors(int column, Color fg, Color bg) {
        if (fg == null) {
            fg = this.MW.theme.getForeground();
        }
        if (bg == null) {
            bg = this.MW.theme.getBackground();
        }
        int colToUse = column - 1;
        for (int j = 0; j < this.columns.size(); ++j) {
            Column gc = this.columns.elementAt(j);
            if (gc.field != column) continue;
            colToUse = gc.origIndex;
        }
        for (int i = 0; i < this.rows.size(); ++i) {
            Row arow = this.rows.elementAt(i);
            arow.cells[colToUse].setColors(fg, bg);
        }
        this.qrefresh();
    }

    public void setRowButtonWidth(int prbsize) {
        try {
            if (prbsize >= 0) {
                this.rowbuttonwidth = prbsize;
            }
        }
        catch (RuntimeException e) {
            System.out.println("Exception in setRowButtonWidth:" + e);
            e.printStackTrace();
        }
    }

    public void setTheme() {
        if (this.MW.panel != null) {
            this.MW.panel.setForeground(this.MW.theme.cfg);
            this.MW.panel.setBackground(this.MW.theme.cbg);
            if (this.horizontalScrollbar != null) {
                this.horizontalScrollbar.setForeground(this.MW.theme.cfg);
                this.horizontalScrollbar.setBackground(this.MW.theme.cbg);
            }
            if (this.verticalScrollbar != null) {
                this.verticalScrollbar.setForeground(this.MW.theme.cfg);
                this.verticalScrollbar.setBackground(this.MW.theme.cbg);
            }
            this.gridcolor = this.MW.theme.cfg.darker().darker();
            this.MW.process("COLOR", 1, null);
            this.qrefresh();
        }
    }

    public void setColLabJus(String just) {
        String j = just.toUpperCase();
        this.collabjus = j.equals("RIGHT") ? 2 : (j.equals("LEFT") ? 3 : 1);
        this.qrefresh();
    }

    public void setColLabels(boolean on) {
        if (on) {
            this.columnbuttonheight = 20;
            this.collabelson = true;
        } else {
            this.columnbuttonheight = 0;
            this.collabelson = false;
        }
        this.qrefresh();
    }

    public void setColLabels(String[] plabels) {
        this.setColLabels(plabels, plabels.length, false);
    }

    public void setColLabels(String plabels) {
        try {
            StringTokenizer st = new StringTokenizer(plabels, this.delimiters, true);
            String[] arow = new String[st.countTokens()];
            int valuecount = 0;
            boolean token = false;
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (this.delimiters.indexOf(s) < 0) {
                    arow[valuecount] = s;
                    ++valuecount;
                    token = false;
                    continue;
                }
                if (token) {
                    arow[valuecount] = "";
                    ++valuecount;
                }
                token = true;
            }
            this.setColLabels(arow, valuecount, true);
        }
        catch (Exception e) {
            System.out.println("Exception in setColLabels:" + e);
            e.printStackTrace();
        }
    }

    public void setRowLabels(boolean on) {
        this.rowlabelson = on;
        this.qrefresh();
    }

    public void setRow(int index, Table t) {
        if (index < 0) {
            this.addRow(t);
        } else {
            int offset = index - 1;
            Row arow = this.rows.elementAt(offset);
            Vector<Object> v = arow.rowData;
            for (int i = 0; i < arow.count; ++i) {
                Column gc = this.columns.elementAt(i);
                Object o = t.get(gc.subr);
                if (o == null) continue;
                v.setElementAt(o, i);
                String newVal = "";
                if (o instanceof Data) {
                    byte datatype = ((Data)o).type;
                    newVal = datatype == 66 || datatype == 73 || datatype == 76 || datatype == 88 || datatype == 70 || datatype == 68 ? (gc.getColorRule() instanceof EnumColorRule ? gc.getColorRule().getData(v.elementAt(i).toString()).trim() : gc.format(((Data)o).toD())) : ((Data)o).getValue();
                } else if (o instanceof Number) {
                    newVal = gc.format(((Number)o).doubleValue());
                } else {
                    String str = o.toString();
                    newVal = gc.getColorRule() instanceof EnumColorRule && StringUtil.isInteger(str) ? gc.getColorRule().getData(v.elementAt(i).toString()).trim() : str;
                }
                arow.cells[i].setData(newVal);
            }
            arow.rowData = v;
            try {
                this.rows.setElementAt(arow, offset);
                this.qrefresh();
            }
            catch (Exception e) {
                System.out.println("Exception in setRow:" + e);
                e.printStackTrace();
            }
        }
    }

    public void setOutputType(int type) {
        this.outtype = type;
    }

    public void setFgHilite(boolean useFg) {
        this.fgHilite = useFg;
        this.qrefresh();
    }

    public void setSelectColor(Color c) {
        this.defaultsel = c;
    }

    public void addColumns(String plabels) {
        try {
            StringTokenizer st = new StringTokenizer(plabels, this.delimiters, true);
            String[] newCols = new String[st.countTokens()];
            int valuecount = 0;
            boolean token = false;
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (this.delimiters.indexOf(s) < 0) {
                    newCols[valuecount] = s.trim();
                    ++valuecount;
                    token = false;
                    continue;
                }
                if (token) {
                    newCols[valuecount] = "";
                    ++valuecount;
                }
                token = true;
            }
            int i = this.curcols;
            for (int j = 0; j < valuecount; ++j) {
                Column gc = new Column();
                gc.label = newCols[j].trim();
                gc.subr = newCols[j].trim();
                gc.width = (newCols[j].length() + 2) * this.charwidth;
                gc.index = this.curcols;
                gc.origIndex = this.curcols;
                gc.cellType = 1;
                gc.visible = true;
                this.columns.addElement(gc);
                ++i;
            }
            int endcol = this.curcols + valuecount;
            if (endcol > this.curcols) {
                this.curcols = endcol;
            }
            this.qrefresh();
        }
        catch (Exception e) {
            System.out.println("Exception in addColumns:" + e);
            e.printStackTrace();
        }
    }

    public void addRow(Table t) {
        Vector<Object> data = new Vector<Object>();
        for (int i = 0; i < this.curcols; ++i) {
            Column gc = this.columns.elementAt(i);
            Object o = t.get(gc.subr);
            if (o != null) {
                data.addElement(o);
                continue;
            }
            data.addElement("");
        }
        int rowPos = Convert.o2l(t.get("LIST__POS"));
        if (rowPos > 0) {
            this.addRows(data, this.curcols, true, rowPos);
        } else {
            this.addRows(data, this.curcols, true, 0);
        }
    }

    public void addRows(Vector<? super Object> values, int rowlen) {
        this.addRows(values, rowlen, false, 0);
        this.qrefresh();
    }

    @Deprecated
    public void pollRows(Vector<?> values, int rowlen) {
        Shell.getSharedMidasContext().deprecate("This method is no longer supported. See /POLL switch on LIST");
        this.pollRows(values, rowlen, false, 0);
        this.qrefresh();
    }

    public void addRows(Vector<Vector<Object>> vov) {
        try {
            for (int i = 0; i < vov.size(); ++i) {
                Vector<Object> rowValues = vov.elementAt(i);
                int rowlen = rowValues.size();
                this.addRows(rowValues, rowlen, false, 0);
            }
            this.qrefresh();
        }
        catch (Exception e) {
            System.out.println("Exception in addRows:" + e);
            e.printStackTrace();
        }
    }

    public void pollRows(Vector<Vector<Object>> vov) {
        for (int i = 0; i < vov.size(); ++i) {
            Vector<Object> rowValues = vov.elementAt(i);
            int rowlen = rowValues.size();
            this.pollRows(rowValues, rowlen, false, i);
        }
    }

    public void removeRow(int row) {
        try {
            if (row == -2) {
                row = this.getSelectedRow();
            }
            if (row > this.currows || row <= 0) {
                return;
            }
            this.rows.removeElementAt(row - 1);
            this.currows = this.rows.size();
            if (this.currows > 0) {
                this.renumberRows(false);
                this.selRow = -1;
            } else {
                this.deselectAll();
            }
            this.qrefresh();
        }
        catch (Exception e) {
            System.out.println("Exception in removeRow:" + e);
            e.printStackTrace();
        }
    }

    public void removeRows(int startRow, int endRow) {
        try {
            for (int row = endRow; row >= startRow; --row) {
                this.rows.removeElementAt(row - 1);
            }
            this.currows = this.rows.size();
            if (this.currows > 0) {
                this.renumberRows(false);
                this.selRow = -1;
            } else {
                this.deselectAll();
            }
            this.qrefresh();
        }
        catch (Exception e) {
            System.out.println("Exception in removeRows:" + e);
            e.printStackTrace();
        }
    }

    public void clear(int tmp) {
        this.rows.removeAllElements();
        this.currows = 0;
        this.startrow = 0;
        this.scrollEnd = this.scrollEndSw;
        this.qrefresh();
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean doRefresh) {
        try {
            for (int i = 0; i < this.currows; ++i) {
                Row arow = this.rows.elementAt(i);
                for (int j = 0; j < arow.count; ++j) {
                    if (!(arow.cells[j] instanceof CellPanel) && !(arow.cells[j] instanceof CellRaster)) continue;
                    CellPanel cp = (CellPanel)arow.cells[j];
                    this.remove(cp.cellPanel);
                }
            }
            if (this.rows != null) {
                this.rows.removeAllElements();
            }
            if (this.columns != null) {
                this.columns.removeAllElements();
            }
            this.selRow = -1;
            this.selColumn = -1;
            this.currows = 0;
            this.curcols = 0;
            this.startcol = 0;
            this.startrow = 0;
            this.scrollEnd = this.scrollEndSw;
            if (doRefresh) {
                this.qrefresh();
            }
            this.rowbuttonwidth = 39;
        }
        catch (Exception e) {
            System.out.println("Exception in clear:" + e);
            e.printStackTrace();
        }
    }

    public void deselectAll() {
        this.deselectAll(false);
    }

    public void deselectAll(boolean sendMsg) {
        boolean deselected = false;
        this.selectRange = false;
        this.lastRow = -1;
        Table msgDataTbl = new Table();
        msgDataTbl.put("TYPE", (Object)"ROW");
        msgDataTbl.put("ROW", (Object)this.selRow);
        msgDataTbl.put("COLUMN", (Object)this.selColumn);
        msgDataTbl.put("VALUE", this.getRowTable(this.selRow));
        Object preSelRowsObj = null;
        switch (this.outtype) {
            case 3: {
                preSelRowsObj = new Table();
                if (this.MultiSelMsgMode != 1) break;
                preSelRowsObj = this.getSelRowsTable();
                break;
            }
            default: {
                preSelRowsObj = this.MultiSelMsgMode == 1 ? this.getSelRowsVector() : new Vector();
            }
        }
        if (this.MultiSelMsgMode != 0) {
            msgDataTbl.put("PREVSEL", preSelRowsObj);
        }
        try {
            for (int i = 0; i < this.currows; ++i) {
                Row arow = this.rows.elementAt(i);
                if (arow.selected) {
                    deselected = true;
                }
                arow.selected = false;
                this.setSelect(-1, -1);
                for (int j = 0; j < arow.count; ++j) {
                    Column gc = this.columns.elementAt(j);
                    if (gc.selected) {
                        deselected = true;
                    }
                    gc.selected = false;
                    arow.cells[j].setSelected(false);
                    this.columns.setElementAt(gc, j);
                }
                this.rows.setElementAt(arow, i);
            }
            this.qrefresh();
        }
        catch (Exception e) {
            System.out.println("Exception in deselectAll:" + e);
            e.printStackTrace();
        }
        if (sendMsg && deselected) {
            this.MW.process("DESELECT", 0, msgDataTbl);
        }
    }

    private void selectCell(int row, int column) {
        try {
            if (row > this.currows || column > this.curcols) {
                return;
            }
            if (this.selectOne) {
                this.deselectAll();
            }
            Row arow = this.rows.elementAt(row - 1);
            Column gc = this.columns.elementAt(column - 1);
            if (arow.cells[column - 1].isSelected()) {
                arow.cells[column - 1].setSelected(false);
                this.setSelect(-1, -1);
            } else {
                arow.cells[column - 1].setSelected(true);
                this.setSelect(row, column);
            }
            this.qrefresh();
        }
        catch (Exception e) {
            System.out.println("Exception in selectCell:" + e);
            e.printStackTrace();
        }
    }

    public void selectCell(Table t) {
        int rowIndex = Convert.o2l(t.get("ROW"));
        int colIndex = Convert.o2l(t.get("COLUMN"));
        this.selectCell(rowIndex, colIndex);
    }

    public void selectAll() {
        try {
            for (int i = 0; i < this.currows; ++i) {
                Row arow = this.rows.elementAt(i);
                arow.selected = true;
                for (int j = 0; j < arow.count; ++j) {
                    Column gc = this.columns.elementAt(j);
                    gc.selected = true;
                    arow.cells[j].setSelected(true);
                    this.columns.setElementAt(gc, j);
                }
                this.rows.setElementAt(arow, i);
            }
            this.qrefresh();
        }
        catch (Exception e) {
            System.out.println("Exception in selectAll:" + e);
            e.printStackTrace();
        }
    }

    public void selectRowByColsValue(Table colValues) {
        try {
            this.deselectAll();
            if (colValues == null) {
                return;
            }
            boolean selectIt = false;
            for (int i = 0; i < this.currows; ++i) {
                Row arow = this.rows.elementAt(i);
                selectIt = false;
                Table.Iterator ti = colValues.iterator();
                while (ti.getNext()) {
                    String dKey = ti.key;
                    String dVal = Convert.o2s(ti.value);
                    int colnum = this.getColIndex(dKey, true);
                    if (colnum < 0) continue;
                    if (!dVal.equalsIgnoreCase(arow.cells[colnum].getData())) {
                        selectIt = false;
                        break;
                    }
                    selectIt = true;
                }
                if (!selectIt) continue;
                arow.selected = true;
                this.setSelect(i, -1);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in method selectRowByColsValues: " + e);
            e.printStackTrace();
        }
    }

    public void selectRowsByColValue(String colname, String colvalue, boolean ignoreCase) {
        try {
            this.deselectAll();
            if (colname == null || colvalue == null) {
                return;
            }
            int colnum = this.getColIndex(colname, ignoreCase);
            if (colnum < 0) {
                return;
            }
            for (int i = 0; i < this.currows; ++i) {
                Row arow = this.rows.elementAt(i);
                if (!ignoreCase || !colvalue.equalsIgnoreCase(arow.cells[colnum].getData())) continue;
                arow.selected = true;
                this.setSelect(i, -1);
            }
            this.qrefresh();
        }
        catch (Exception e) {
            System.out.println("Exception in method selectRowsByColValue: " + e);
            e.printStackTrace();
        }
    }

    public int selectRowByColValue(String colname, String colvalue, boolean ignorecase) {
        int selected = -1;
        try {
            if (this.selectOne) {
                this.deselectAll();
            }
            if (colname == null || colvalue == null) {
                return selected;
            }
            int colnum = this.getColIndex(colname, ignorecase);
            if (colnum < 0) {
                return selected;
            }
            for (int i = 0; i < this.currows; ++i) {
                Row arow = this.rows.elementAt(i);
                if (ignorecase && colvalue.equalsIgnoreCase(arow.cells[colnum].getData())) {
                    arow.selected = true;
                    selected = i;
                    this.setSelect(selected, -1);
                    if (!this.selectOne) continue;
                    break;
                }
                if (ignorecase || !colvalue.equals(arow.cells[colnum].getData())) continue;
                arow.selected = true;
                selected = i;
                this.setSelect(selected, -1);
                if (this.selectOne) break;
            }
            if (this.selectOne && selected > -1) {
                int numVisRows = (this.MW.pos.h - this.columnbuttonheight - hscrlheight) / this.rowheight;
                if (selected < this.startrow || selected > this.startrow + numVisRows) {
                    this.startrow = selected;
                    if (this.startrow < 0) {
                        this.startrow = 0;
                    } else if (this.startrow > this.currows) {
                        this.startrow = this.currows;
                    }
                    this.verticalScrollbar.setValues(this.startrow, numVisRows, 0, this.currows);
                }
            }
            this.qrefresh();
            return selected;
        }
        catch (Exception e) {
            System.out.println("Exception in selectRow:" + e);
            e.printStackTrace();
            return selected;
        }
    }

    public void selectRow(int row) {
        try {
            if (this.selectOne) {
                this.deselectAll();
            }
            if (row <= 0 || row > this.rows.size()) {
                return;
            }
            if (this.rows.elementAt((int)(row - 1)).selected) {
                this.rows.elementAt((int)(row - 1)).selected = false;
                this.setSelect(-1, -1);
            } else {
                this.rows.elementAt((int)(row - 1)).selected = true;
                this.setSelect(row, -1);
                if (this.lastRow == -1 || this.selectOne) {
                    this.lastRow = row;
                }
                if (this.selectRange && this.lastRow != -1) {
                    for (int zz = this.lastRow; zz <= row; ++zz) {
                        this.setSelect(zz, -1);
                        this.rows.elementAt((int)(zz - 1)).selected = true;
                    }
                }
            }
            int numVisRows = (this.MW.pos.h - this.columnbuttonheight - hscrlheight) / this.rowheight;
            if (row - 1 < this.startrow || row - 1 > this.startrow + numVisRows) {
                this.startrow = row - 1;
                if (this.startrow < 0) {
                    this.startrow = 0;
                } else if (this.startrow > this.currows) {
                    this.startrow = this.currows;
                }
                this.verticalScrollbar.setValues(this.startrow, numVisRows, 0, this.currows);
            }
            this.qrefresh();
        }
        catch (Exception e) {
            System.out.println("Exception in selectRow:" + e);
            e.printStackTrace();
        }
    }

    public void deSelectRow(int row) {
        try {
            if (row <= 0 || row > this.rows.size()) {
                return;
            }
            if (this.rows.elementAt((int)(row - 1)).selected) {
                this.rows.elementAt((int)(row - 1)).selected = false;
                this.setSelect(-1, -1);
                this.qrefresh();
            }
        }
        catch (Exception e) {
            System.out.println("Exception in deSelectRow:" + e);
            e.printStackTrace();
        }
    }

    public void selectRow(int row, boolean clear) {
        try {
            if (row > this.currows) {
                return;
            }
            if (clear) {
                this.deselectAll();
            }
            if (row <= 0) {
                return;
            }
            this.rows.elementAt((int)(row - 1)).selected = true;
            this.setSelect(row, -1);
            this.qrefresh();
        }
        catch (Exception e) {
            System.out.println("Exception in selectRow:" + e);
            e.printStackTrace();
        }
    }

    public void selectColumn(int column) {
        try {
            if (column > this.curcols) {
                return;
            }
            if (this.selectOne) {
                this.deselectAll();
            }
            Column gc = this.columns.elementAt(column - 1);
            if (gc.selected) {
                gc.selected = false;
                this.setSelect(-1, -1);
            } else {
                gc.selected = true;
                this.setSelect(-1, column);
            }
            this.qrefresh();
        }
        catch (Exception e) {
            System.out.println("Exception in selectColumn:" + e);
            e.printStackTrace();
        }
    }

    public void selectCells(Table t) {
        String subrecs = Convert.o2s(t.get("NAMES")).toUpperCase();
        StringTokenizer st = new StringTokenizer(subrecs, this.delimiters, true);
        String[] eachsubr = new String[st.countTokens()];
        int valuecount = 0;
        boolean token = false;
        boolean selRow = false;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (this.delimiters.indexOf(s) < 0) {
                eachsubr[valuecount] = s.trim();
                ++valuecount;
                token = false;
                continue;
            }
            if (token) {
                eachsubr[valuecount] = "";
                ++valuecount;
            }
            token = true;
        }
        int[] columnIndexs = new int[valuecount];
        for (int i = 0; i < this.curcols; ++i) {
            Column gc = this.columns.elementAt(i);
            for (int j = 0; j < valuecount; ++j) {
                if (!gc.subr.equals(eachsubr[j])) continue;
                columnIndexs[j] = i;
            }
        }
        int rowIndex = Convert.o2l(t.get("ROW"));
        this.selectCells(rowIndex, columnIndexs);
    }

    private void selectCells(int row, int[] columnIdxs) {
        if (row > this.currows) {
            return;
        }
        this.deselectAll();
        try {
            Row arow = this.rows.elementAt(row - 1);
            for (int i = 0; i < columnIdxs.length; ++i) {
                int indx = columnIdxs[i];
                Column gc = this.columns.elementAt(indx);
                arow.cells[gc.origIndex].setSelected(true);
            }
            this.setSelect(row, columnIdxs[0]);
            this.qrefresh();
        }
        catch (Exception e) {
            System.out.println("Exception in selectCells:" + e);
            e.printStackTrace();
        }
    }

    public void applyTemplate() {
        this.applyTemplate(this.templateKeys);
    }

    public void applyTemplate(Keywords keywds) {
        Table t;
        Column gc;
        int i;
        if (this.refreshMode == 2) {
            this.forceRefresh();
        }
        this.deselectAll();
        Object obj = keywds.getKey("GRID");
        if (obj != null) {
            String g = Convert.o2s(obj);
            if (g.equals("OFF")) {
                this.setGrid(false);
            } else {
                this.setGrid(true);
            }
        }
        if ((obj = keywds.getKey("LABELS")) != null) {
            String clabs = Convert.o2s(obj);
            if (clabs.equals("OFF")) {
                this.setColLabels(false);
            } else {
                this.setColLabels(true);
            }
        }
        if ((obj = keywds.getKey("COLLABJUS")) != null) {
            String clabjus = Convert.o2s(obj);
            this.setColLabJus(clabjus);
        }
        if ((obj = keywds.getKey("INDEX")) != null) {
            String rlabs = Convert.o2s(obj);
            if (rlabs.equals("OFF")) {
                this.setRowLabels(false);
            } else {
                this.setRowLabels(true);
            }
        }
        if ((obj = keywds.getKey("FIELDS")) == null) {
            return;
        }
        int fields = Convert.o2l(obj);
        obj = keywds.getKey("COLOR");
        String defaultColor = obj != null ? Convert.o2s(obj) : this.MW.theme.cfg.toString();
        Table tmpTable = new Table();
        for (int k = 1; k <= fields; ++k) {
            if (keywds.setScope("FIELD=" + k) != 1) continue;
            Table subrTable = new Table();
            obj = keywds.getKey("FIELD");
            if (obj != null) {
                subrTable.put("FIELD", (Object)Integer.valueOf(Convert.o2s(obj)));
            }
            Object subrObj = keywds.getKey("SUBR");
            obj = keywds.getKey("LABEL");
            if (obj != null) {
                subrTable.put("LABEL", (Object)Convert.o2s(obj));
            }
            if ((obj = keywds.getKey("COLOR")) != null) {
                subrTable.put("COLOR", (Object)Convert.o2s(obj));
            }
            if ((obj = keywds.getKey("WIDTH")) != null) {
                subrTable.put("WIDTH", (Object)Integer.valueOf(Convert.o2s(obj)));
            }
            if ((obj = keywds.getKey("DISPFORM")) != null) {
                subrTable.put("DISPFORM", (Object)Convert.o2s(obj));
            }
            if ((obj = keywds.getKey("HIDE")) != null) {
                subrTable.put("HIDE", (Object)Integer.valueOf(Convert.o2s(obj)));
            }
            if ((obj = keywds.getKey("COLUMNTYPE")) != null) {
                subrTable.put("COLUMNTYPE", (Object)Convert.o2s(obj));
            }
            if ((obj = keywds.getKey("RASTERFRAME")) != null) {
                subrTable.put("RASTERFRAME", (Object)Integer.valueOf(Convert.o2s(obj)));
            }
            if ((obj = keywds.getKey("RASTERLEVELS")) != null) {
                subrTable.put("RASTERLEVELS", (Object)Integer.valueOf(Convert.o2s(obj)));
            }
            if ((obj = keywds.getKey("RASTERCOLORMAP")) != null) {
                subrTable.put("RASTERCOLORMAP", (Object)Convert.o2s(obj));
            }
            if ((obj = keywds.getKey("RASTERSELCOLOR")) != null) {
                subrTable.put("RASTERSELCOLOR", (Object)Convert.o2s(obj));
            }
            if ((obj = keywds.getKey("STRETCH")) != null) {
                subrTable.put("STRETCH", (Object)Integer.valueOf(Convert.o2s(obj)));
            }
            if ((obj = keywds.getKey("TIMEFMT")) != null) {
                subrTable.put("TIMEFMT", (Object)Integer.valueOf(Convert.o2s(obj)));
            }
            if ((obj = keywds.getKey("MENU")) != null) {
                subrTable.put("MENU", (Object)Convert.o2s(obj));
            }
            if ((obj = keywds.getKey("MVALUES")) != null) {
                subrTable.put("MVALUES", (Object)Convert.o2s(obj));
            }
            if ((obj = keywds.getKey("MCOLORS")) != null) {
                subrTable.put("MCOLORS", (Object)Convert.o2s(obj));
            }
            if (subrObj == null) continue;
            tmpTable.put(Convert.o2s(subrObj), (Object)subrTable);
        }
        int numCols = this.columns.size();
        boolean templateSetup = false;
        if (numCols == 0) {
            String[] sa = tmpTable.getKeys();
            this.setColLabels(sa, sa.length, false);
            numCols = this.columns.size();
            templateSetup = true;
        }
        for (i = 0; i < numCols; ++i) {
            gc = this.columns.elementAt(i);
            t = (Table)tmpTable.get(gc.subr);
            if (t != null) {
                gc.index = (Integer)t.get("FIELD");
                gc.field = Convert.o2l(t.get("FIELD"));
                if (templateSetup) {
                    gc.origIndex = gc.index - 1;
                }
                gc.origWidth = gc.width = ((Integer)t.get("WIDTH") + 2) * this.charwidth;
                gc.label = ((String)t.get("LABEL")).trim();
                if (t.get("COLUMNTYPE") != null) {
                    String columnType = ((String)t.get("COLUMNTYPE")).trim();
                    if (columnType.equals("PANEL")) {
                        gc.cellType = 2;
                    } else if (columnType.equals("TOGGLE")) {
                        gc.cellType = 5;
                    } else if (columnType.equals("RASTER")) {
                        gc.cellType = 3;
                    } else if (columnType.equals("TIME")) {
                        gc.cellType = 6;
                        gc.timeFormat = t.get("TIMEFMT") != null ? (Integer)t.get("TIMEFMT") : 1;
                    } else {
                        gc.cellType = 1;
                    }
                }
                if (t.get("DISPFORM") != null) {
                    gc.setFormatter(((String)t.get("DISPFORM")).trim());
                }
                if (t.get("RASTERFRAME") != null) {
                    gc.rasterFrame = (Integer)t.get("RASTERFRAME");
                }
                if (t.get("RASTERLEVELS") != null) {
                    gc.rasterLevels = (Integer)t.get("RASTERLEVELS");
                }
                if (t.get("RASTERCOLORMAP") != null) {
                    gc.rasterColorMap = (String)t.get("RASTERCOLORMAP");
                }
                if (t.get("RASTERSELCOLOR") != null) {
                    gc.rasterSelColor = (String)t.get("RASTERSELCOLOR");
                }
                gc.visible = t.get("HIDE") != null ? (Integer)t.get("HIDE") == 0 : true;
                if (t.get("STRETCH") != null) {
                    gc.stretch = (Integer)t.get("STRETCH") == 1;
                    continue;
                }
                gc.stretch = false;
                continue;
            }
            gc.visible = false;
        }
        for (i = 0; i < numCols; ++i) {
            String tempField;
            gc = this.columns.elementAt(i);
            t = (Table)tmpTable.get(gc.subr);
            if (t == null) continue;
            if (t.get("MCOLORS") != null) {
                String tempMenu = Convert.o2s(t.get("MENU"));
                String tempValues = Convert.o2s(t.get("MVALUES"));
                String tempColors = Convert.o2s(t.get("MCOLORS"));
                gc.setColorRule(new EnumColorRule(tempMenu, tempValues, tempColors, gc.origIndex));
                continue;
            }
            if (t.get("COLOR") != null) {
                try {
                    if (Convert.o2s(t.get("COLOR")).substring(0, 5).equalsIgnoreCase("FIELD")) {
                        tempField = Convert.o2s(t.get("COLOR")).substring(5);
                        gc.setColorRule(new TrackColorRule(Convert.o2l(tempField)));
                        continue;
                    }
                    String tempIndex = Convert.o2s(t.get("COLOR"));
                    gc.definedColor = MColor.getColor(tempIndex);
                    gc.setColorRule(new ConstColorRule(MColor.getColor(tempIndex)));
                }
                catch (StringIndexOutOfBoundsException e) {
                    String tempIndex = Convert.o2s(t.get("COLOR"));
                    if (tempIndex.charAt(0) < "0".charAt(0) || tempIndex.charAt(0) > "9".charAt(0)) {
                        gc.definedColor = MColor.getColor(tempIndex);
                        gc.setColorRule(new ConstColorRule(MColor.getColor(tempIndex)));
                        continue;
                    }
                    gc.setColorRule(new ConstColorRule(MColor.getColorByIndex(Convert.o2l(t.get("COLOR")))));
                }
                continue;
            }
            try {
                if (defaultColor.substring(0, 5).equalsIgnoreCase("FIELD")) {
                    tempField = defaultColor.substring(5);
                    gc.setColorRule(new TrackColorRule(Convert.o2l(tempField)));
                    continue;
                }
                gc.definedColor = MColor.getColor(defaultColor);
                gc.setColorRule(new ConstColorRule(MColor.getColor(defaultColor)));
                continue;
            }
            catch (StringIndexOutOfBoundsException e) {
                if (defaultColor.charAt(0) < "0".charAt(0) || defaultColor.charAt(0) > "9".charAt(0)) {
                    gc.definedColor = MColor.getColor(defaultColor);
                    gc.setColorRule(new ConstColorRule(MColor.getColor(defaultColor)));
                    continue;
                }
                gc.setColorRule(new ConstColorRule(MColor.getColorByIndex(Integer.decode(defaultColor))));
            }
        }
        this.qrefresh();
    }

    public void sort(String subrToSort, boolean sortDesc) {
        boolean sortFound = false;
        for (int i = 0; i < this.columns.size(); ++i) {
            Column col = this.columns.elementAt(i);
            if (!subrToSort.equals(col.subr)) continue;
            this.sortIndex = i;
            sortFound = true;
        }
        if (sortFound) {
            this.sortDesc = sortDesc;
            Collections.sort(this.rows);
            this.renumberRows(true);
        }
    }

    public void sort(String subrToSort) {
        this.sort(subrToSort, !this.sortDesc);
    }

    public void sort() {
        Column col = this.columns.elementAt(this.sortIndex);
        String subrToSort = col.subr;
        this.sort(subrToSort, this.sortDesc);
    }

    public void processSelection(String type, int selRow, int[] selCols) {
        Table t = new Table();
        t.put("TYPE", (Object)type);
        if (this.selectOne) {
            t.put("SELECTONE", 1);
        } else {
            t.put("SELECTONE", 0);
        }
        if (this.selectRange) {
            t.put("SELECTRANGE", 1);
        } else {
            t.put("SELECTRANGE", 0);
        }
        if (type.equals("CELLS")) {
            t.put("ROW", (Object)(selRow + 1));
            Row arow = this.rows.elementAt(selRow);
            for (int i = 0; i < selCols.length; ++i) {
                Column gc = this.columns.elementAt(selCols[i]);
                t.put(gc.subr, (Object)arow.cells[gc.origIndex].getData());
            }
        }
        this.MW.process("SELECT", 0, t);
    }

    public void processSelection(String type, int selRow, int selCol) {
        Iterable<String> obj = null;
        boolean selected = true;
        Object prevRowsObj = this.getSelRowsTable();
        Object selRowsObj = null;
        Table t = new Table();
        t.put("TYPE", (Object)type);
        if (type.equals("CELL")) {
            if (this.autoSelect) {
                this.selectCell(selRow + 1, selCol + 1);
            }
            t.put("ROW", (Object)(selRow + 1));
            t.put("COLUMN", (Object)(selCol + 1));
            Row arow = this.rows.elementAt(selRow);
            Column gc = this.columns.elementAt(selCol);
            if (gc.getColorRule() instanceof EnumColorRule) {
                EnumColorRule erule = (EnumColorRule)gc.getColorRule();
                gc.selRow = selRow + 1;
                new GMenu(this.MW, gc.label, erule.menuItems, 0, 0, this);
                return;
            }
            t.put("VALUE", (Object)arow.cells[gc.origIndex].getData());
            t.put("NAME", (Object)gc.subr);
        } else if (type.equals("ROW")) {
            if (this.autoSelect) {
                this.selectRow(selRow + 1);
            }
            t.put("ROW", (Object)(selRow + 1));
            t.put("COLUMN", (Object)-1);
            if (this.wayneMode && this.wayneDoubleClick) {
                t.put("DOUBLECLICK", (Object)"TRUE");
            }
            Row arow = this.rows.elementAt(selRow);
            selected = arow.selected;
            switch (this.outtype) {
                case 3: {
                    obj = arow.toTable();
                    selRowsObj = new Table();
                    if (this.selectOne || this.MultiSelMsgMode != 1) break;
                    selRowsObj = this.getSelRowsTable();
                    break;
                }
                default: {
                    obj = arow.rowData;
                    if (this.selectOne || this.MultiSelMsgMode != 1) break;
                    selRowsObj = this.getSelRowsVector();
                }
            }
            t.put("NAME", (Object)"");
            t.put("VALUE", (Object)obj);
            if (this.MultiSelMsgMode != 0) {
                t.put("CURRSEL", selRowsObj);
                t.put("PREVSEL", prevRowsObj);
            }
        } else if (type.equals("COLUMN")) {
            if (this.autoSelect) {
                this.selectColumn(selCol + 1);
            }
            t.put("ROW", (Object)-1);
            t.put("COLUMN", (Object)(selCol + 1));
            Column gc = this.columns.elementAt(selCol);
            switch (this.outtype) {
                case 3: {
                    obj = gc.toTable(this.rows);
                    break;
                }
                default: {
                    obj = gc.toVector(this.rows);
                }
            }
            t.put("VALUE", (Object)obj);
            t.put("NAME", (Object)gc.subr);
        }
        if (this.selectOne) {
            t.put("SELECTONE", 1);
        } else {
            t.put("SELECTONE", 0);
        }
        if (this.selectRange) {
            t.put("SELECTRANGE", 1);
        } else {
            t.put("SELECTRANGE", 0);
        }
        if (!this.selectRange || selected) {
            this.MW.process("SELECT", 0, t);
        }
    }

    @Override
    public String[] getKeys() {
        return null;
    }

    @Override
    public Object setKey(String name, Object value) {
        if (name.equals("SELECTROW")) {
            this.selectRow(Convert.o2l(value));
        } else if (name.equals("SCROLLEND")) {
            this.scrollEnd = this.scrollEndSw;
        } else {
            return null;
        }
        return value;
    }

    @Override
    public Object getKey(String name) {
        if (name.startsWith("DATA")) {
            return this.rows;
        }
        if (name.equals("SELECTEDROW")) {
            return Convert.l2o(this.getSelectedRow());
        }
        if (name.equals("SELECTEDCOLUMN")) {
            return Convert.l2o(this.getSelectedColumn());
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.needsFullDraw) {
            this.needsFullDraw = true;
        }
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.5.4")
    public static interface GridSheetReference {
        public GridSheet getGridSheet();
    }

    public class StringDragSource
    implements DragSourceListener,
    DragGestureListener {
        Component comp;
        DragSource ds;
        DragGestureRecognizer dgr;
        Method dm;

        public StringDragSource(Component comp, String methodname, Class<?>[] args) {
            try {
                this.dm = comp.getClass().getMethod(methodname, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.comp = comp;
            this.ds = new DragSource();
            this.dgr = this.ds.createDefaultDragGestureRecognizer(comp, 3, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            Object obj = null;
            String s = null;
            try {
                obj = this.dm.invoke((Object)this.comp, new Object[0]);
                s = obj instanceof Table ? ((Table)obj).toString() : (String)obj;
                this.ds.startDrag(dge, DragSource.DefaultCopyDrop, new StringSelection(s), this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
            e.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        }

        @Override
        public void dragExit(DragSourceEvent e) {
            e.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
        }
    }

    public class StringDropTarget
    implements DropTargetListener {
        Component comp;
        DropTarget dt;
        Method dm;
        String str;

        public StringDropTarget(Component comp, String methodname, Class<?>[] args) {
            try {
                this.dm = comp.getClass().getMethod(methodname, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.comp = comp;
            this.dt = new DropTarget(comp, 3, this);
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            e.acceptDrag(3);
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                Transferable tr = dtde.getTransferable();
                if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    dtde.acceptDrop(3);
                    this.str = (String)tr.getTransferData(DataFlavor.stringFlavor);
                    this.dm.invoke((Object)this.comp, this.str);
                    dtde.getDropTargetContext().dropComplete(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }
    }

    public class EnumColorRule
    extends AbstractColorRule {
        Table dataTable;
        Table menuTable;
        Table colorTable;
        String menuItems;
        int colToUse;

        public EnumColorRule(String menu, String mvalues, String mcolors, int field) {
            this.dataTable = new Table();
            this.menuTable = new Table();
            this.colorTable = new Table();
            this.menuItems = "";
            try {
                this.colToUse = field;
                this.menuItems = menu;
                StringTokenizer st1 = new StringTokenizer(menu, GridSheet.this.delimiters);
                StringTokenizer st2 = new StringTokenizer(mvalues, GridSheet.this.delimiters);
                StringTokenizer st3 = new StringTokenizer(mcolors, GridSheet.this.delimiters);
                while (st1.hasMoreTokens()) {
                    String s1 = st1.nextToken();
                    String s2 = st2.nextToken();
                    String s3 = st3.nextToken();
                    if (s1.indexOf(".") != -1) {
                        s1 = s1.substring(0, s1.indexOf("."));
                    }
                    if (s2.indexOf(".") != -1) {
                        s2 = s2.substring(0, s2.indexOf("."));
                    }
                    this.menuTable.put(s1, (Object)s2);
                    this.dataTable.put(s2, (Object)s1);
                    if (s3.length() > 5 && s3.substring(0, 5).equalsIgnoreCase("FIELD")) {
                        String tempField = s3.substring(5);
                        this.colorTable.put(s2, (Object)new TrackColorRule(Convert.o2l(tempField)));
                        continue;
                    }
                    this.colorTable.put(s2, (Object)s3);
                }
            }
            catch (Exception e) {
                System.out.println("Error in EnumColorRule::contructor : " + e);
                e.printStackTrace();
            }
        }

        @Override
        public Color getColor(List<?> rule) {
            try {
                String tempKey = null;
                String tempData = Convert.o2s(rule.get(this.colToUse));
                if (tempData.indexOf(".") != -1) {
                    tempData = tempData.substring(0, tempData.indexOf("."));
                }
                tempKey = this.menuTable.getKey(tempData) != null ? Convert.o2s(this.menuTable.getKey(tempData)) : (this.dataTable.getKey(tempData) != null ? tempData : null);
                String tempIndex = null;
                if (tempKey != null) {
                    if (this.colorTable.getKey(tempKey) instanceof TrackColorRule) {
                        TrackColorRule newTCR = (TrackColorRule)this.colorTable.getKey(tempKey);
                        return newTCR.getColor(rule);
                    }
                    tempIndex = Convert.o2s(this.colorTable.getKey(tempKey)).toLowerCase();
                    if (tempIndex != null && (tempIndex.charAt(0) < "0".charAt(0) || tempIndex.charAt(0) > "9".charAt(0))) {
                        return MColor.getColor(tempIndex);
                    }
                    return MColor.getColorByIndex(Convert.o2l(this.colorTable.getKey(tempKey)));
                }
                return Color.white;
            }
            catch (Exception e) {
                System.out.println("Error in EnumColorRule::getColor : " + e);
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public String getData(String s) {
            try {
                if (s.indexOf(".") != -1) {
                    s = s.substring(0, s.indexOf("."));
                }
                if (this.dataTable.getData(s) != null) {
                    return Convert.o2s(this.dataTable.getData(s));
                }
                return s;
            }
            catch (Exception e) {
                System.out.println("Error in EnumColorRule::getData: " + e);
                e.printStackTrace();
                return null;
            }
        }
    }

    public class TrackColorRule
    extends AbstractColorRule {
        int ColumnToFollow;

        public TrackColorRule(int ctf) {
            this.ColumnToFollow = ctf;
        }

        @Override
        public Color getColor(List<?> rule) {
            try {
                for (int i = 0; i < GridSheet.this.columns.size(); ++i) {
                    Column gc = GridSheet.this.columns.elementAt(i);
                    if (gc.field != this.ColumnToFollow) continue;
                    return gc.getColorRule().getColor(rule);
                }
            }
            catch (Exception e) {
                System.out.println("Error in TrackColorRule::getColor : " + e);
                e.printStackTrace();
            }
            return null;
        }
    }

    public class ConstColorRule
    extends AbstractColorRule {
        Color myColor;

        public ConstColorRule(Color c) {
            this.myColor = c;
        }

        @Override
        public Color getColor(List<?> rule) {
            return this.myColor;
        }
    }

    public abstract class AbstractColorRule
    implements ColorRule {
        @Override
        public Color getColor(List<?> rule) {
            return null;
        }

        @Override
        public String getData(String s) {
            return s;
        }
    }

    public static interface ColorRule {
        public Color getColor(List<?> var1);

        public String getData(String var1);
    }

    public class Column
    implements Comparable<Object> {
        Integer index;
        int origIndex;
        int width;
        int origWidth = 0;
        int cellType;
        int timeFormat;
        String label;
        String subr;
        boolean stretch = false;
        boolean selected;
        boolean visible = true;
        public DecimalFormat nf;
        int rasterFrame = 16;
        int rasterLevels = 16;
        String rasterSelColor = "GREEN";
        String rasterColorMap = "MULTI";
        Vector<Object> colData = new Vector();
        Color definedColor = null;
        ColorRule Crule;
        int field;
        int selRow;
        boolean dms = false;

        public Table toTable(Vector<Row> vov) {
            Table t = new Table();
            int numRows = vov.size();
            for (int i = 0; i < numRows; ++i) {
                Row row = vov.elementAt(i);
                Integer tmp = i + 1;
                t.put(tmp.toString(), row.rowData.elementAt(this.origIndex));
            }
            return t;
        }

        public Vector<Object> toVector(Vector<Row> vov) {
            this.colData.clear();
            int numRows = vov.size();
            for (int i = 0; i < numRows; ++i) {
                Row row = vov.elementAt(i);
                this.colData.addElement(row.rowData.elementAt(this.origIndex));
            }
            return this.colData;
        }

        @Override
        public int compareTo(Object o) {
            try {
                Integer A = this.index;
                Integer B = ((Column)o).index;
                return A.compareTo(B);
            }
            catch (Exception e) {
                System.out.println("Error in compareTo: " + e);
                e.printStackTrace();
                return 0;
            }
        }

        public ColorRule getColorRule() {
            return this.Crule;
        }

        public void setColorRule(ColorRule cr) {
            this.Crule = cr;
        }

        public void setFormatter(String pattern) {
            if (pattern == null || pattern.trim().equals("") || pattern.startsWith("(") || pattern.startsWith("[") || pattern.equalsIgnoreCase("ENUM") || pattern.equalsIgnoreCase("GEN") || pattern.equalsIgnoreCase("SCI") || pattern.equalsIgnoreCase("ENG") || pattern.equalsIgnoreCase("MAN") || pattern.equalsIgnoreCase("VIS") || pattern.equalsIgnoreCase("HMS")) {
                Shell.getSharedMidasContext().warning("Invalid value for DISPFORM template keyword: " + pattern);
                return;
            }
            if (pattern.trim().equalsIgnoreCase("DMS")) {
                this.dms = true;
                return;
            }
            this.nf = new DecimalFormat(pattern);
        }

        public String format(double data) {
            if (this.nf == null) {
                if (this.dms) {
                    return Convert.deg2dms(data, "00.00");
                }
                return Double.valueOf(data).toString();
            }
            return this.nf.format(data);
        }
    }

    public class CellRaster
    extends AbstractCellRenderer {
        MWindow MW;
        CImage cimage;
        Color[] colors;
        boolean newdata;
        int size;
        int levels;
        int frame;
        String colormap;
        Rectangle r;
        int rindex;
        int rindexDisp;
        boolean enableSel;
        boolean visible;
        Color selColor;
        byte selByteVal;
        byte[] saveBytes;
        String label;
        public byte[] currBuf;
        public double[] timeBuf;
        public Vector<Object> timeObj;

        public CellRaster(MWindow mw) {
            this.newdata = false;
            this.size = 1;
            this.levels = 16;
            this.frame = 16;
            this.colormap = "RAMP";
            this.rindex = -1;
            this.rindexDisp = -1;
            this.enableSel = false;
            this.visible = true;
            this.selColor = Color.green;
            this.selByteVal = 0;
            this.saveBytes = new byte[3];
            this.label = "";
            this.MW = mw;
            this.selected = false;
            this.minX = 0;
            this.maxX = 0;
        }

        public CellRaster(MWindow mw, int frame, int levels, String colormap, String selColor) {
            this.newdata = false;
            this.size = 1;
            this.levels = 16;
            this.frame = 16;
            this.colormap = "RAMP";
            this.rindex = -1;
            this.rindexDisp = -1;
            this.enableSel = false;
            this.visible = true;
            this.selColor = Color.green;
            this.selByteVal = 0;
            this.saveBytes = new byte[3];
            this.label = "";
            this.frame = frame;
            this.levels = levels;
            this.colormap = colormap;
            this.selColor = MColor.getColor(selColor);
            this.MW = mw;
            this.selected = false;
            this.minX = 0;
            this.maxX = 0;
            this.r = new Rectangle();
            this.currBuf = new byte[frame];
            this.timeBuf = new double[frame];
            this.timeObj = new Vector(frame, 10);
            this.setData(this.currBuf);
        }

        @Override
        public Object getDataObj() {
            return this;
        }

        @Override
        public void setDataObj(Object obj) {
            byte[] bptr = Convert.o2ba(obj);
            this.setData(bptr);
        }

        public void setData(byte[] buf) {
            if (this.cimage == null) {
                this.currBuf = buf;
                Color[] tmpcolors = MColor.getColorMap(this.colormap, this.levels);
                int plusOne = tmpcolors.length + 1;
                this.colors = new Color[plusOne];
                System.arraycopy(tmpcolors, 0, this.colors, 0, tmpcolors.length);
                this.colors[plusOne - 1] = this.selColor;
                this.selByteVal = (byte)(plusOne - 1);
                this.cimage = new CImage(GridSheet.this.g, this.frame, this.size, buf, this.colors);
                this.cimage.setColors(this.colors);
            } else {
                this.cimage.source.newPixels(1, 1, this.frame, 1);
                this.cimage.image.flush();
                this.cimage.setColors(this.colors);
            }
        }

        public String getData(String columnLabel) {
            this.label = columnLabel;
            return this.getDataDisp();
        }

        public String getDataDisp() {
            String tmp = "";
            if (this.rindexDisp > -1) {
                String tmpT = null;
                String tmpC = null;
                String tmpD = null;
                tmpT = Time.format(this.timeBuf[this.rindexDisp], 1);
                tmpT = StringUtil.trim(tmpT, "::", "");
                tmpC = Time.format(this.timeBuf[0], 1);
                tmpC = StringUtil.trim(tmpC, "::", "");
                tmpD = Time.format(this.timeBuf[0] - this.timeBuf[this.rindexDisp], 1);
                tmpD = StringUtil.trim(tmpD, "::", "");
                tmp = "(current=" + tmpC + " " + this.label + "=" + tmpT + " delta=" + tmpD + ")";
            } else {
                tmp = "" + this.rindexDisp;
            }
            return tmp;
        }

        public int getFrame() {
            return this.frame;
        }

        public Vector<Object> getTimeVector() {
            return this.timeObj;
        }

        public Object getTimeObject(int index) {
            try {
                if (index >= 0 && index < this.timeObj.size()) {
                    return this.timeObj.get(index);
                }
                return null;
            }
            catch (Exception e) {
                System.out.println("Exception in getTimeObject:" + e);
                return null;
            }
        }

        public Object setTimeObject(int index, Object obj) {
            try {
                if (index >= 0 && index < this.timeObj.size()) {
                    return this.timeObj.set(index, obj);
                }
                return null;
            }
            catch (Exception e) {
                System.out.println("Exception in setTimeObject:" + e);
                return null;
            }
        }

        public boolean addTimeObject(Object obj) {
            try {
                return this.timeObj.add(obj);
            }
            catch (Exception e) {
                System.out.println("Exception in addTimeObject:" + e);
                return false;
            }
        }

        public Object removeTimeObject(int index) {
            try {
                return this.timeObj.remove(index);
            }
            catch (Exception e) {
                System.out.println("Exception in addTimeObject:" + e);
                return null;
            }
        }

        public boolean shiftTimeObject(Object obj) {
            try {
                if (this.timeObj.size() >= this.frame) {
                    this.timeObj.remove(0);
                    return this.timeObj.add(obj);
                }
                return this.timeObj.add(obj);
            }
            catch (Exception e) {
                System.out.println("Exception in shiftTimeObject:" + e);
                return false;
            }
        }

        public double getTimeDiff(int latestindex, int toindex) {
            if (latestindex >= 0 && toindex >= 0 && latestindex <= this.frame && toindex <= this.frame) {
                return this.timeBuf[latestindex] - this.timeBuf[toindex];
            }
            return 0.0;
        }

        public double getTimeDiff(int index) {
            if (index >= 0) {
                return this.timeBuf[0] - this.timeBuf[index];
            }
            return 0.0;
        }

        @Override
        public String getData() {
            return "" + this.rindex;
        }

        public boolean getValueDisp(Point p) {
            boolean found = false;
            if (this.r.contains(p)) {
                int i;
                double rw = (double)this.r.width / (double)this.frame;
                this.rindexDisp = i = (int)((double)(p.x - this.r.x) / rw);
            }
            return found;
        }

        public boolean getValue(Point p) {
            boolean found = false;
            if (this.r.contains(p)) {
                int i;
                double rw = (double)this.r.width / (double)this.frame;
                this.rindex = i = (int)((double)(p.x - this.r.x) / rw);
            }
            return found;
        }

        public void enableRasterSelect() {
            this.enableSel = true;
        }

        public void clearRasterSelect() {
            this.rindex = -1;
            this.enableSel = false;
            GridSheet.this.needRefresh = true;
        }

        @Override
        public void hidePanel() {
            this.visible = false;
        }

        @Override
        public void showPanel() {
            this.visible = true;
        }

        public void newData(int tmp) {
            if (this.enableSel && this.rindex > -1) {
                if (this.rindex > this.currBuf.length - 2) {
                    this.rindex = this.currBuf.length - 2;
                }
                System.arraycopy(this.currBuf, this.rindex - 1, this.saveBytes, 0, 3);
                for (int i = this.rindex - 1; i <= this.rindex + 1; ++i) {
                    this.currBuf[i] = this.selByteVal;
                }
            }
            this.cimage.source.newPixels(1, 1, this.frame, 1);
            this.cimage.image.flush();
            this.cimage.setColors(this.colors);
            if (this.enableSel && this.rindex > 0) {
                System.arraycopy(this.saveBytes, 0, this.currBuf, this.rindex - 1, 3);
            }
            GridSheet.this.needRefresh = true;
        }

        @Override
        public void refresh() {
            this.r.setRect(this.minX, this.Y - this.height + 1, this.width - 1, this.height - 1);
            if (this.cimage != null && this.visible) {
                GridSheet.this.g.drawImage(this.cimage.image, this.r.x, this.r.y, this.r.width, this.r.height, this.cimage);
                GridSheet.this.needRefresh = true;
            }
            GridSheet.this.processMouseMove(this.MW.px, this.MW.py);
        }

        public class CImage
        implements ImageObserver {
            public Image image;
            public ColorModel colormodel;
            public MemoryImageSource source;
            public int w;
            public int h;
            private Graphics g;
            private byte[] buf;

            public CImage(Graphics g, int width, int height, byte[] buf, Color[] colors) {
                this.g = g;
                this.w = width;
                this.h = height;
                this.buf = buf;
                this.setColors(colors);
                this.source = new MemoryImageSource(this.w, this.h, this.colormodel, buf, 0, this.w);
                this.source.setAnimated(true);
                this.image = Toolkit.getDefaultToolkit().createImage(this.source);
            }

            public void setColors(Color[] colors) {
                this.colormodel = null;
                this.colormodel = MColor.getColorModel(colors);
                if (this.source != null) {
                    this.source.newPixels(this.buf, this.colormodel, 0, this.w);
                }
            }

            public void draw(Graphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
                g.drawImage(this.image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
            }

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                return true;
            }
        }
    }

    public class CellToggle
    extends AbstractCellRenderer {
        public String onVal;
        public String offVal;
        private boolean state;

        public CellToggle(Color defFore, Color defBack) {
            this.onVal = "ON";
            this.offVal = "";
            this.state = false;
            this.defFg = defFore;
            this.defBg = defBack;
            this.forecolor = defFore;
            this.backcolor = defBack;
            this.selected = false;
            this.minX = 0;
            this.maxX = 0;
        }

        @Override
        public Object getDataObj() {
            return this.data;
        }

        @Override
        public void setDataObj(Object obj) {
            this.state = Convert.o2s(obj).equals(this.onVal);
        }

        @Override
        public void toggle() {
            this.state = !this.state;
            this.refresh();
        }

        @Override
        public void refresh() {
            if (this.state) {
                int mode = -1;
            } else {
                boolean mode = false;
            }
            GridSheet.this.g.setColor(this.forecolor);
            int tmp = (this.width - this.height) / 2;
            if (this.state) {
                this.data = this.onVal;
                GridSheet.this.g.fill3DRect(this.minX + tmp, this.Y - this.height + 5, this.width - tmp * 2, this.height - 10, true);
            } else {
                this.data = this.offVal;
                GridSheet.this.shadowbox(this.minX + tmp, this.Y - this.height + 5, this.width - tmp * 2, this.height - 10, -1);
            }
        }
    }

    public class CellString
    extends AbstractCellRenderer {
        double tmp;
        int xoff;

        public CellString(Color defFore, Color defBack, int fmt) {
            this.xoff = 5;
            this.defFg = defFore;
            this.defBg = defBack;
            this.forecolor = defFore;
            this.backcolor = defBack;
            this.selected = false;
            this.minX = 0;
            this.maxX = 0;
            this.fmt = fmt;
        }

        public CellString(Color defFore, Color defBack) {
            this.xoff = 5;
            this.defFg = defFore;
            this.defBg = defBack;
            this.forecolor = defFore;
            this.backcolor = defBack;
            this.selected = false;
            this.minX = 0;
            this.maxX = 0;
        }

        @Override
        public Object getDataObj() {
            return this.data;
        }

        @Override
        public void setDataObj(Object obj) {
            this.data = Convert.o2s(obj);
        }

        @Override
        public void setColors(Color fg, Color bg) {
            this.defFg = fg;
            this.defBg = bg;
            this.forecolor = fg;
            this.backcolor = bg;
            GridSheet.this.needRefresh = true;
        }

        @Override
        public void refresh() {
            GridSheet.this.g.setColor(this.backcolor);
            GridSheet.this.g.fillRect(this.minX, this.Y - this.height + 1, this.width - 1, this.height - 1);
            GridSheet.this.g.setColor(this.forecolor);
            if (this.fmt > 0) {
                this.tmp = Convert.s2d(this.data);
                GridSheet.this.g.drawString(Time.format(this.tmp, this.fmt, -1), this.minX + this.xoff, this.Y - 2);
            } else {
                GridSheet.this.g.drawString(this.data, this.minX + this.xoff, this.Y - 2);
            }
        }
    }

    public class CellPanel
    extends AbstractCellRenderer {
        MPanel cellPanel;
        GridSheet GS;

        public CellPanel(MWindow mw, GridSheet gs, Color defFore, Color defBack) {
            this.cellPanel = new MPanel();
            this.cellPanel.setForeground(defFore);
            this.cellPanel.setBackground(defBack);
            this.GS = gs;
            this.addTo(mw);
        }

        @Override
        public void addTo(MWindow mw) {
            this.cellPanel.MW = mw;
            this.GS.add(this.cellPanel);
        }

        @Override
        public void hidePanel() {
            this.cellPanel.setVisible(false);
        }

        @Override
        public void showPanel() {
            this.cellPanel.setVisible(true);
        }

        @Override
        public Object getDataObj() {
            return this.cellPanel;
        }

        @Override
        public void setDataObj(Object obj) {
            this.cellPanel = (MPanel)obj;
        }

        @Override
        public void refresh() {
            this.cellPanel.setBounds(this.minX, this.Y - this.height + 1, this.width - 1, this.height - 1);
            this.cellPanel.setBackground(this.backcolor);
        }
    }

    public abstract class AbstractCellRenderer
    implements CellRenderer {
        String data;
        Color defFg;
        Color forecolor;
        Color defBg;
        Color backcolor;
        boolean selected;
        int minX;
        int maxX;
        int Y;
        int width;
        int height;
        int fmt = 0;

        @Override
        public void refresh() {
        }

        @Override
        public void hidePanel() {
        }

        @Override
        public void showPanel() {
        }

        @Override
        public void toggle() {
        }

        @Override
        public void setDataObj(Object obj) {
        }

        @Override
        public Object getDataObj() {
            return null;
        }

        @Override
        public void addTo(MWindow mw) {
        }

        @Override
        public void setData(String val) {
            this.data = val;
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public void setSelected(boolean val) {
            this.selected = val;
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public Color getDefFg() {
            return this.defFg;
        }

        @Override
        public Color getDefBg() {
            return this.defBg;
        }

        @Override
        public void setColors() {
            this.forecolor = this.defFg;
            this.backcolor = this.defBg;
        }

        @Override
        public void setColors(Color fg, Color bg) {
            this.forecolor = fg;
            this.backcolor = bg;
        }

        @Override
        public void setRectangle(int x, int y, int width, int height) {
            this.minX = x;
            this.Y = y;
            this.width = width;
            this.height = height;
        }

        public void setStringFmt(int fmt) {
            this.fmt = fmt;
        }

        @Override
        public void setMaxX(int maxX) {
            this.maxX = maxX;
        }

        @Override
        public boolean inXBounds(int xval) {
            return xval >= this.minX && xval <= this.maxX;
        }

        @Override
        public void setSelected(boolean fgHilite, Color selcolor) {
            if (fgHilite) {
                this.forecolor = selcolor;
                this.backcolor = this.defBg;
            } else {
                this.forecolor = this.defFg;
                this.backcolor = selcolor;
            }
        }

        @Override
        public void setSelected(boolean fgHilite, Color selcolor, Color fg, Color bg) {
            if (fgHilite) {
                this.backcolor = bg;
                this.forecolor = selcolor;
            } else {
                this.forecolor = fg;
                this.backcolor = selcolor;
            }
        }
    }

    public static interface CellRenderer {
        public String getData();

        public void setData(String var1);

        public void setRectangle(int var1, int var2, int var3, int var4);

        public void setMaxX(int var1);

        public void setColors(Color var1, Color var2);

        public void setColors();

        public void setSelected(boolean var1, Color var2);

        public void setSelected(boolean var1, Color var2, Color var3, Color var4);

        public void setSelected(boolean var1);

        public boolean isSelected();

        public boolean inXBounds(int var1);

        public void refresh();

        public void addTo(MWindow var1);

        public void hidePanel();

        public void showPanel();

        public void toggle();

        public Object getDataObj();

        public void setDataObj(Object var1);

        public Color getDefFg();

        public Color getDefBg();
    }

    public class Row
    implements Comparable<Object> {
        Vector<Object> rowData = new Vector();
        CellRenderer[] cells;
        int count;
        boolean selected = false;
        String label;

        public Row(int rowSize) {
            this.count = rowSize;
            this.cells = new CellRenderer[rowSize];
        }

        public Table toTable() {
            Table t = new Table();
            for (int i = 0; i < this.count; ++i) {
                Column gc = GridSheet.this.columns.elementAt(i);
                t.put(gc.subr.toUpperCase(), (Object)this.cells[gc.origIndex].getData());
            }
            return t;
        }

        public void setCells(CellRenderer[] cells) {
            this.cells = cells;
        }

        public CellRenderer[] getCells() {
            return this.cells;
        }

        @Override
        public int compareTo(Object o) {
            Object Y;
            Object X;
            Object A = this.rowData.elementAt(GridSheet.this.sortIndex);
            Object B = ((Row)o).rowData.elementAt(GridSheet.this.sortIndex);
            if (GridSheet.this.sortDesc) {
                X = B;
                Y = A;
            } else {
                X = A;
                Y = B;
            }
            if (B.getClass().isInstance(A)) {
                if (A instanceof Double) {
                    return ((Double)X).compareTo((Double)Y);
                }
                if (A instanceof Float) {
                    return ((Float)X).compareTo((Float)Y);
                }
                if (A instanceof Long) {
                    return ((Long)X).compareTo((Long)Y);
                }
                if (A instanceof Integer) {
                    return ((Integer)X).compareTo((Integer)Y);
                }
                if (A instanceof Byte) {
                    return ((Byte)X).compareTo((Byte)Y);
                }
                return X.toString().compareTo((String)Y);
            }
            return 0;
        }
    }

    class HScrollAdjustmentListener
    implements AdjustmentListener {
        HScrollAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent event) {
            try {
                int atype = event.getAdjustmentType();
                if (atype == 3) {
                    GridSheet.this.startcol -= hblockincrement;
                    if (GridSheet.this.startcol < 0) {
                        GridSheet.this.startcol = 0;
                    }
                } else if (atype == 4) {
                    GridSheet.this.startcol += hblockincrement;
                    if (GridSheet.this.startcol > GridSheet.this.curcols) {
                        GridSheet.this.startcol = GridSheet.this.curcols - 1;
                    }
                } else if (atype == 2) {
                    --GridSheet.this.startcol;
                    if (GridSheet.this.startcol < 0) {
                        GridSheet.this.startcol = 0;
                    }
                } else if (atype == 1) {
                    ++GridSheet.this.startcol;
                    if (GridSheet.this.startcol > GridSheet.this.curcols) {
                        GridSheet.this.startcol = GridSheet.this.curcols - 1;
                    }
                } else if (atype == 5) {
                    int slidevalue = event.getValue();
                    if (GridSheet.this.startcol != slidevalue) {
                        GridSheet.this.startcol = slidevalue;
                    }
                    if (GridSheet.this.startcol > GridSheet.this.curcols) {
                        GridSheet.this.startcol = GridSheet.this.curcols - 1;
                    }
                    if (GridSheet.this.startcol > GridSheet.this.curcols) {
                        GridSheet.this.startcol = GridSheet.this.curcols - 1;
                    }
                }
                GridSheet.this.qrefresh();
            }
            catch (Exception e) {
                System.out.println("Exception in HScroll listener:" + e);
            }
        }
    }

    class VScrollAdjustmentListener
    implements AdjustmentListener {
        VScrollAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent event) {
            try {
                int atype = event.getAdjustmentType();
                if (atype == 3) {
                    GridSheet.this.startrow -= vblockincrement;
                    if (GridSheet.this.startrow < 0) {
                        GridSheet.this.startrow = 0;
                    }
                } else if (atype == 4) {
                    GridSheet.this.startrow += vblockincrement;
                    if (GridSheet.this.startrow >= GridSheet.this.currows) {
                        GridSheet.this.startrow = GridSheet.this.currows - 1;
                    }
                } else if (atype == 2) {
                    --GridSheet.this.startrow;
                    if (GridSheet.this.startrow < 0) {
                        GridSheet.this.startrow = 0;
                    }
                } else if (atype == 1) {
                    ++GridSheet.this.startrow;
                    if (GridSheet.this.startrow > GridSheet.this.currows) {
                        GridSheet.this.startrow = GridSheet.this.currows - 1;
                    }
                } else if (atype == 5) {
                    int slidevalue;
                    GridSheet.this.startrow = slidevalue = event.getValue();
                    if (GridSheet.this.startrow < 0) {
                        GridSheet.this.startrow = 0;
                    }
                    if (GridSheet.this.startrow > GridSheet.this.currows) {
                        GridSheet.this.startrow = GridSheet.this.currows - 1;
                    }
                }
                GridSheet.this.qrefresh();
            }
            catch (Exception e) {
                System.out.println("Exception in VScroll listener:" + e);
            }
        }
    }

    class GridComponentAdapter
    extends ComponentAdapter {
        GridComponentAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent event) {
            Object object = event.getSource();
            if (object == GridSheet.this) {
                GridSheet.this.setSize(GridSheet.this.MW.pos.w, GridSheet.this.MW.pos.h);
                GridSheet.this.g.setClip(0, 0, GridSheet.this.MW.pos.w, GridSheet.this.MW.pos.h);
                GridSheet.this.qrefresh();
            }
        }
    }
}

