/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Format;
import nxm.sys.lib.Message;
import nxm.sys.lib.Time;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MJTextField;

public class GValue
extends GWidget
implements ActionListener {
    public static final String flagsList = GWidget.flagsList + ",NoNumb,Slider,Gauge,VuMeter,Minimum,Maximum,Percent,Hex,Discrete,MsgOnDrag,RightJustify";
    public static final int NOTEXT = 256;
    public static final int SLIDER = 512;
    public static final int GAUGE = 1024;
    public static final int VUM = 2048;
    public static final int MINIMUM = 4096;
    public static final int MAXIMUM = 8192;
    public static final int PERCENT = 16384;
    public static final int HEX = 32768;
    public static final int DISCRETE = 65536;
    public static final int MSGONDRAG = 131072;
    public static final int RIGHTJUSTIFY = 262144;
    private MJTextField jtexti;
    private String sval;
    private double val;
    private double minVal;
    private double maxVal;
    private double deltaVal;
    private boolean edit;
    private boolean dragValue;
    private char datatype = (char)68;
    private MBox bp;
    private MBox bt;
    private MBox bc;
    private int digits;
    private int pw;
    private Format nf;
    private int mouseMode = 0;
    private boolean waiting = false;

    public GValue(Object parent, String name, double val, double val1, double val2, double vald, char type, int flags, MessageHandler mh) {
        super("GValue", parent, name, flags, mh);
        this.open(name, val, val1, val2, vald, type);
        this.addTo(parent);
    }

    public GValue(Object parent, String name, double val, double val1, double val2, double vald, int flags, MessageHandler mh) {
        this(parent, name, val, val1, val2, vald, 'D', flags, mh);
    }

    public GValue(Object parent, String name, float val, float val1, float val2, float vald, int flags, MessageHandler mh) {
        this(parent, name, val, val1, val2, vald, 'F', flags, mh);
    }

    public GValue(Object parent, String name, int val, int val1, int val2, int vald, int flags, MessageHandler mh) {
        this(parent, name, val, val1, val2, vald, 'L', flags, mh);
    }

    public void open(String name, double val, double val1, double val2, double vald, char type) {
        super.open();
        this.minVal = val1;
        this.maxVal = val2;
        this.deltaVal = vald;
        this.val = val;
        this.datatype = type;
        this.pw = this.stringWidth(this.title);
        this.setupTextField();
        this.pos.w = 0;
        this.nf = new Format();
        if (this.datatype == 'T') {
            this.setFormat("HH:MM:SS");
        } else if (this.datatype == 'L') {
            this.setFormat("#0");
        } else {
            this.setFormat("##0.###E0");
        }
    }

    public void setupTextField() {
        if (!this.is(Integer.MIN_VALUE)) {
            this.jtexti = new MJTextField("", 20);
            this.jtexti.setFont(this.font);
            this.jtexti.setForeground(this.theme.cwfg);
            this.jtexti.setBackground(this.theme.cwbg);
            this.jtexti.addActionListener(this);
        }
    }

    @Override
    public void setWidgetTheme(Object o) {
        super.setWidgetTheme(o);
        if (!this.is(Integer.MIN_VALUE)) {
            this.jtexti.setForeground(this.theme.cwfg);
            this.jtexti.setBackground(this.theme.cwbg);
        }
    }

    public void setFormat(String format) {
        this.setFormat(format, null);
    }

    public void setFormat(String format, Object unitMult) {
        if (format == null || format.length() == 0) {
            return;
        }
        this.digits = format.length();
        this.digits += 2;
        this.nf.setFormat(format);
        if (unitMult != null) {
            this.nf.setExp(unitMult);
        } else {
            this.nf.setExp(this.minVal, this.maxVal);
        }
        this.setup();
        this.sval = null;
        this.setValue(this.val, 0);
    }

    public String getFormat() {
        return this.nf.getFormat();
    }

    @Override
    public void setup() {
        this.bw = this.is(32) ? 0 : 4;
        int h = this.th + this.ta - (this.edit ? 0 : this.compression);
        int w = this.tw * this.digits;
        if (this.units != null) {
            w += this.tw * (1 + this.units.length());
        }
        this.bp = new MBox(this.bw + this.tw, this.bw, this.pw, h);
        this.bc = new MBox(this.bp.x + this.bp.w, this.bw, this.th + this.tw, h);
        this.bt = new MBox(this.bc.x + this.bc.w, this.bw + h / 2 - this.th / 2, w, this.th);
        this.pos.w = this.bt.x + this.bt.w + this.tw + this.bw;
        this.pos.h = h + this.bw + this.bw;
        if (this.fixWidth > this.pos.w) {
            this.pos.w = this.fixWidth;
            this.bt.w = this.pos.w - this.bt.x - this.bw - this.tw;
        }
        this.layout();
    }

    @Override
    public void resize(int mode) {
        super.resize(mode);
        this.bt.w = this.pos.w - this.bt.x - this.bw - this.tw;
        this.placeTextInput(this.bc, this.jtexti);
    }

    @Override
    @Deprecated
    public void paint() {
        this.refresh();
    }

    @Override
    @ProvisionalUseOnly(value="Treat this as protected and should only be called by subclass paintComponent methods")
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int ty = this.pos.h / 2 + this.ta / 2;
        this.shadowbox(g, 0, 0, this.pos.w, this.pos.h, -2, 0);
        this.setColor(g, this.theme.cwti);
        this.setTextClip(g, this.panel, this.title, this.bp.x);
        g.drawString(this.title, this.bp.x, ty);
        g.setColor(this.theme.cwfg);
        if (this.edit) {
            return;
        }
        boolean sat = this.is(512) && !this.is(256);
        this.setValueBox(this.bt.x - 3, this.bt.y, this.bt.w + 5, this.bt.h + (sat ? 3 : 0));
        if (!this.is(1536)) {
            this.drawValueBox(g, 1);
        }
        if (this.is(1024) && this.maxVal > this.minVal) {
            this.shadowbox(g, this.bt.x - 2, this.bt.y + 1, this.bt.w + 4, this.bt.h, 0);
            int ip = (int)((double)this.bt.w * (this.val - this.minVal) / (this.maxVal - this.minVal));
            this.setColor(g, this.theme.cwfh);
            g.fillRect(this.bt.x, this.bt.y + 3, ip, this.bt.h - 4);
        }
        if (this.is(512)) {
            double p = this.maxVal > this.minVal ? (this.val - this.minVal) / (this.maxVal - this.minVal) : 0.5;
            this.sliderbox(g, this.bt.x, this.bt.y + (sat ? this.bt.h : this.bt.h / 2), this.bt.w, 0, p, 0);
        }
        if (this.is(2048) && this.maxVal > this.minVal) {
            this.shadowbox(g, this.bt.x - 2, this.bt.y + 1, this.bt.w + 4, this.bt.h, 0);
            double f = (this.val - this.minVal) / (this.maxVal - this.minVal);
            int i1 = (int)((double)this.bt.w * 0.08);
            int ip = (int)((double)this.bt.w * f);
            int i2 = (int)((double)this.bt.w * 0.8);
            int i3 = (int)((double)this.bt.w * 0.9);
            int vw = 5;
            this.setColor(g, MColor.getColor(ip < i1 ? 0xA0A000 : 32768));
            g.fillRect(this.bt.x, this.bt.y + 3, ip, this.bt.h - 4);
            if (ip > i2) {
                this.setColor(g, MColor.getColor(ip > i3 ? 0x801000 : 0xA0A000));
                g.fillRect(this.bt.x + i2, this.bt.y + 3, ip - i2, this.bt.h - 4);
            }
            if (ip < i1) {
                g.drawRect(this.bt.x + 1, this.bt.y + 3, this.bt.w - 2, this.bt.h - 4);
            }
            this.setColor(g, this.theme.cwbs);
            for (int i = this.bt.x + vw - 1; i < this.bt.x + this.bt.w; i += vw) {
                g.drawLine(i, this.bt.y + 4, i, this.bt.y + this.bt.h - 2);
            }
        }
        if (this.is(256)) {
            this.nf.setDigitPos(-1);
        } else {
            String text = this.sval;
            int xLocation = 0;
            if (this.is(4096)) {
                text = "" + this.nf.form(this.minVal) + " / " + text;
            }
            if (this.is(8192)) {
                text = text + " / " + this.nf.form(this.maxVal);
            }
            if (this.units != null && this.units.length() > 0) {
                text = text + " " + this.units;
            }
            if (this.is(2048)) {
                text = "";
            }
            if (this.is(16384)) {
                text = text + " | " + Convert.l2s((int)(100.0 * (this.val - this.minVal) / (this.maxVal - this.minVal))) + "%";
            }
            if (this.is(262144)) {
                int textPixelLength = g.getFontMetrics().stringWidth(text);
                xLocation = this.fixWidth - textPixelLength - 5;
            } else {
                xLocation = this.bt.x;
            }
            if (sat) {
                ty -= 2;
            }
            this.setColor(g, this.theme.cwfg);
            this.setTextClip(g, this.panel, text, this.bt.x);
            g.drawString(text, xLocation, ty);
            int digit = this.nf.getDigitPos();
            if (digit >= 0 && digit < this.sval.length()) {
                this.setColor(g, this.theme.cwfh);
                char c = this.sval.charAt(digit);
                if (c >= '0' && c <= '9') {
                    g.drawRect(this.bt.x + digit * this.tw, ty + 2, this.tw - 1, 1);
                    String tmpstr = this.sval.substring(digit, digit + 1);
                    this.setTextClip(g, this.panel, tmpstr, this.bt.x);
                    g.drawString(tmpstr, this.bt.x + digit * this.tw, ty);
                }
                this.setColor(g, this.theme.cwfg);
            }
        }
        this.drawDiamond(g, this.bc.x + this.bc.w / 2, this.bc.y + this.bc.h / 2, this.tw * 2 / 3, this.mouseMode);
    }

    public void setSelectedTextColor(Color c) {
        this.jtexti.setSelectedTextColor(c);
    }

    public Color getSelectedTextColor() {
        return this.jtexti.getSelectedTextColor();
    }

    public void setSelectionColor(Color c) {
        this.jtexti.setSelectionColor(c);
    }

    public Color getSelectionColor() {
        return this.jtexti.getSelectionColor();
    }

    public void setSelectedTextColor(String color) {
        this.setSelectedTextColor(MColor.getColor(color));
    }

    public String getSelectedTextColorString() {
        return MColor.toString(this.getSelectedTextColor());
    }

    public void setSelectionColor(String c) {
        this.setSelectionColor(MColor.getColor(c));
    }

    public String getSelectionColorString() {
        return MColor.toString(this.getSelectionColor());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String text = this.getTextFieldText();
        double value = this.val;
        try {
            if (!this.nf.isSimpleDateFormat()) {
                value = Convert.s2d(text);
            } else {
                String pattern = this.nf.getFormat().substring(4);
                try {
                    value = new Time(text, pattern).getSec();
                }
                catch (Exception ex) {
                    value = Convert.s2d(text);
                }
            }
        }
        catch (Exception ex) {
            this.M.warning("You entered an invalid number = '" + text + "'");
        }
        this.panel.remove(this.jtexti);
        this.panel.requestFocus();
        this.edit = false;
        this.setup();
        this.setValue(value, 1);
    }

    private void sendMessage() {
        Object value = this.getValue();
        if (this.is(0x20000000)) {
            this.M.results.put(this.monitorName, value);
        }
        if (!this.waiting) {
            this.setActionType();
            this.sendWidgetMessage(this.label, this.actionType, value);
        }
    }

    @Override
    public Object getValue() {
        Number data = null;
        if (this.datatype == 'T') {
            data = this.val;
        } else if (this.datatype == 'D') {
            data = this.val;
        } else if (this.datatype == 'F') {
            data = Float.valueOf((float)this.val);
        } else if (this.datatype == 'L') {
            data = (int)this.val;
        }
        return data;
    }

    @Override
    public String getValueString() {
        return this.sval;
    }

    @Override
    public boolean poll() {
        String monitorName = this.monitorName;
        if (monitorName == null || !this.is(0x20000000)) {
            return false;
        }
        double newval = this.M.results.getD(monitorName);
        if (newval == this.val) {
            return false;
        }
        this.setActionType(-1);
        this.setValue(newval, 0);
        this.sendWidgetMessage(this.label, -1, this.getValue());
        return true;
    }

    @Override
    public String getLegend() {
        String rm = "";
        if (!this.is(1)) {
            rm = ",RM=Cancel";
        }
        if (this.mouseMode == 0) {
            if (!this.is(1)) {
                return "(MM=Configure,RM=Cancel)";
            }
            return "(MM=Configure)";
        }
        if (this.mouseMode == 1) {
            return "(LM=Inc" + rm + ")";
        }
        if (this.mouseMode == 2) {
            return "(LM=Dec" + rm + ")";
        }
        if (this.mouseMode == 3) {
            return "(MM=Configure" + rm + ")";
        }
        if (this.is(1536)) {
            return "(LM=Set,RM=Edit)";
        }
        return "(LM=SelectDigit,RM=Edit)";
    }

    @Override
    public int processEventMessage(String name, int info, Object data) {
        int keycode;
        if (name.equals("POINTER")) {
            int mm = 0;
            mm = info < 0 ? 0 : (this.px > this.bc.x + this.bc.w ? 8 : (this.px <= this.bc.x ? 0 : (this.py > this.bc.y + this.bc.h / 2 ? 2 : 1)));
            if (mm != this.mouseMode) {
                this.mouseMode = mm;
                this.refresh(this.bc);
                if (info == 0) {
                    info = 1;
                }
            }
            if (this.is(128) && Math.abs(info) == 9) {
                this.refreshValue();
            }
            this.formatReadOut(info);
        }
        if (this.dragValue && name.equals("DRAGBOX")) {
            this.dragValue = false;
            return 1;
        }
        int drag = name.equals("DRAG") ? info : 0;
        int button = name.equals("BUTTON") ? info : 0;
        int n = keycode = name.equals("KEYPRESS") ? info : 0;
        if (button == 0 && keycode == 0 && drag == 0) {
            return -1;
        }
        if (button == 2 && this.px < this.bc.x) {
            this.configure();
        } else if (!this.is(8)) {
            if (button >= 2 && this.px > this.bt.x && this.px < this.bt.x + this.bt.w) {
                String str = this.sval;
                if (this.datatype != 'T') {
                    str = this.datatype == 'L' ? Convert.l2s((int)this.val) : Convert.d2s(this.val);
                } else if (this.nf.isSimpleDateFormat()) {
                    str = new Time(this.val).toString(this.nf.getSdfDisplayPattern());
                }
                this.jtexti.setText(str);
                this.edit = true;
                this.setup();
                this.panel.add((Component)this.jtexti, 0);
                this.jtexti.requestFocus();
                this.placeTextInput(this.bc, this.jtexti);
                this.nf.setDigitPos(-1);
            } else if (button == 3 && !this.is(1)) {
                this.close();
            } else if (button > 0 && this.mouseMode != 0 && this.mouseMode != 8) {
                double dv;
                double d = dv = this.nf.isDigitSel() ? this.getUpDownDelta() : this.deltaVal;
                if (button == 1 && this.mouseMode == 2) {
                    dv = -dv;
                }
                if (button == 3 && this.mouseMode != 2) {
                    dv = -dv;
                }
                if (button == 1 && this.mouseMode != 3) {
                    this.setValue(this.val + dv, 1);
                }
            } else if (button == 1 && this.mouseMode == 8) {
                if (this.is(1024) || this.is(2048) || this.is(512) && (this.is(256) || this.py > this.bt.y + this.bt.h - 4)) {
                    this.userAction = true;
                    this.setValue(this.minVal + this.deltaVal * (double)((int)((this.maxVal - this.minVal) * (double)(this.px - this.bt.x) / (double)this.bt.w / this.deltaVal + 0.5)), 1);
                } else if (!this.is(256)) {
                    this.nf.setDigitPos((this.px - this.bt.x) / this.tw);
                    this.refresh(this.bbox);
                }
            } else if (this.is(1536) && drag == 1 && this.mouseMode == 8) {
                this.userAction = true;
                this.setValue(this.minVal + this.deltaVal * (double)((int)((this.maxVal - this.minVal) * (double)(this.px - this.bt.x) / (double)this.bt.w / this.deltaVal + 0.5)), 1);
                this.dragValue = true;
            } else if (keycode == 38) {
                double dv = this.nf.isDigitSel() ? this.getUpDownDelta() : this.deltaVal;
                this.setValue(this.val + dv, 1);
            } else if (keycode == 40) {
                double dv = this.nf.isDigitSel() ? this.getUpDownDelta() : this.deltaVal;
                this.setValue(this.val - dv, 1);
            } else if (keycode == 37) {
                this.nf.incDigitPos();
                this.refresh(this.bbox);
            } else if (keycode == 39) {
                this.nf.decDigitPos();
                this.refresh(this.bbox);
            } else if (keycode == 10 && !this.is(1)) {
                this.close();
            }
        }
        this.formatReadOut(1);
        return 1;
    }

    private double getUpDownDelta() {
        if (!this.nf.isSimpleDateFormat()) {
            int ndp = this.nf.getDecPlacesHMS();
            if (ndp == 0) {
                return this.nf.getDigitInc();
            }
            int selected = this.nf.getDigitSel();
            if (selected == ndp) {
                return 0.0;
            }
            int dotAdjustment = selected > ndp ? 1 : 0;
            return this.nf.getDigitInc(selected - ndp - dotAdjustment);
        }
        return this.deltaSimpleDateFormat();
    }

    private double deltaSimpleDateFormat() {
        int pos = this.nf.getDigitPos();
        String charAtPos = "" + this.sval.charAt(pos);
        if (!charAtPos.matches("[0-9]")) {
            return 0.0;
        }
        boolean digitsAfter = pos < this.sval.length();
        String ending = digitsAfter ? this.sval.substring(pos + 1) : "";
        String val0 = this.sval.substring(0, pos) + 0 + ending;
        String val1 = this.sval.substring(0, pos) + 1 + ending;
        Time val0Time = new Time(val0, this.nf.getFormat().substring(4));
        Time val1Time = new Time(val1, this.nf.getFormat().substring(4));
        double deltaTime = val1Time.diff(val0Time);
        return deltaTime;
    }

    public void setValue(double value) {
        this.setValue(value, 0);
    }

    public void setValue(double value, int flag) {
        if (this.maxVal > this.minVal) {
            value = Math.max(this.minVal, this.maxVal == -1.0 ? value : Math.min(this.maxVal, value));
        }
        if (value == this.val && this.sval != null && flag < 2) {
            return;
        }
        if (this.is(65536)) {
            value = this.minVal + (double)Math.round((value - this.minVal) / this.deltaVal) * this.deltaVal;
        }
        if (this.datatype == 'L') {
            value = Math.round(value);
        }
        this.val = value;
        this.sval = this.is(32768) ? Convert.l2x((int)value) : this.nf.form(this.val);
        this.refresh(this.bbox);
        if (this.dragging == 1 && !this.is(131072) && flag >= 1) {
            this.waiting = true;
        }
        if (flag >= 1) {
            this.sendMessage();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.waiting) {
            this.waiting = false;
            this.sendMessage();
        }
    }

    @Override
    public void setValue(String value) {
        this.setValue(Convert.s2d(value), 0);
    }

    @Override
    public void setAction(String value) {
        this.setActionType();
        if (value.equals("Inc")) {
            this.setValue(this.val + this.deltaVal, 2);
        } else if (value.equals("Dec")) {
            this.setValue(this.val - this.deltaVal, 2);
        } else if (value.equals("Min")) {
            this.setValue(this.minVal, 2);
        } else if (value.equals("Max")) {
            this.setValue(this.maxVal, 2);
        } else if (value.equals("Mid")) {
            this.setValue((this.minVal + this.maxVal) / 2.0, 2);
        } else {
            this.setValue(Convert.s2d(value), 2);
        }
    }

    public char getType() {
        return this.datatype;
    }

    public double getMin() {
        return this.minVal;
    }

    public double getMax() {
        return this.maxVal;
    }

    public double getDelta() {
        return this.deltaVal;
    }

    public void setMin(double value) {
        this.minVal = value;
        if (this.is(4096) || this.is(16384)) {
            this.refreshValue();
        }
    }

    public void setMax(double value) {
        this.maxVal = value;
        if (this.is(8192) || this.is(16384)) {
            this.refreshValue();
        }
    }

    public void setDelta(double value) {
        this.deltaVal = value;
    }

    public String getText() {
        return this.sval;
    }

    private String getTextFieldText() {
        return this.jtexti.getText();
    }

    @Override
    public int processMessage(Message msg) {
        if (msg.name.equals("GVALUE.CFG")) {
            this.flags = msg.info;
            this.setup();
            this.refresh();
        }
        return 1;
    }

    @Override
    public String toString() {
        return this.toList("" + this.val, "" + this.minVal + "," + this.deltaVal + "<," + this.sval + ",>" + this.deltaVal + "," + this.maxVal);
    }
}

