/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Terminal;
import nxm.sys.lib.Time;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.MJText;
import nxm.sys.libg.MWText;

public class GTerminal
extends Terminal
implements ActionListener,
MessageHandler {
    private MJText mjtext;
    private MWText MW;
    private String textinput = null;
    private int interrupt = 0;
    private int mode;

    public GTerminal(Midas m, MWText mwtext) {
        this.M = m;
        this.MW = mwtext;
        this.setupTextArea(mwtext);
    }

    private void setupTextArea(MWText mwtext) {
        this.mjtext = mwtext.mtext;
        if (this.mjtext != null) {
            this.mjtext.addActionListener(this);
        }
    }

    public void setTextInput(String text) {
        this.textinput = text;
    }

    @Override
    public synchronized void print(String text) {
        if (this.mjtext == null) {
            return;
        }
        this.mjtext.addText(text);
    }

    private boolean needExit() {
        if (this.M.pipeMode == 5) {
            this.textinput = "EXIT";
        }
        return this.M.status == -3;
    }

    @Override
    public String getInput(String prompt, String seed, int flags) {
        this.mode = flags;
        boolean copy = true;
        if (prompt == null) {
            prompt = "";
        }
        if (seed == null) {
            seed = "";
        }
        if (this.mjtext != null) {
            this.mjtext.setPrompt(prompt);
            this.mjtext.setInput(seed);
        }
        while (this.textinput == null && !this.needExit()) {
            Time.sleep(0.1);
        }
        if (this.mjtext != null) {
            this.mjtext.setPrompt("");
            this.mjtext.setInput("");
            if (this.mode == -2) {
                this.mjtext.replace("");
            }
        }
        if (this.mode != -2 && this.textinput != null) {
            if (this.textinput.startsWith("!") && this.mode != 2) {
                copy = false;
            } else if (this.textinput.startsWith("!") && this.mode == 2) {
                this.textinput = seed;
            }
            if (copy) {
                this.print(prompt + this.textinput + "\n");
            }
        }
        String text = this.textinput;
        this.textinput = null;
        this.mode = 0;
        return text;
    }

    @Override
    public int getInterrupt() {
        return this.interrupt;
    }

    @Override
    public int getRows() {
        return this.mjtext.getRows() - 1;
    }

    @Override
    public int getColumns() {
        return this.mjtext.getColumns();
    }

    @Override
    public boolean isExtCmdSupported() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("ENTER")) {
            this.textinput = this.mjtext.getInput();
            if (this.mode == -2) {
                this.textinput = "\n";
            }
        } else if (action.equals("KEYPRESS")) {
            if (this.mode == -2) {
                this.textinput = this.mjtext.getInput();
            }
        } else if (action.equals("POPCODE")) {
            if (this.mode == 2) {
                return;
            }
            int popcode = e.getModifiers();
            switch (popcode) {
                case -2: {
                    this.textinput = "!LASTREF";
                    break;
                }
                case -1: {
                    this.textinput = "!LAST";
                    break;
                }
                case 1: {
                    this.textinput = "!NEXT";
                    break;
                }
                case 2: {
                    this.textinput = "!NEXTREF";
                }
            }
        } else if (action.equals("POP")) {
            if (this.MW.status != -3) {
                this.MW.pop(-1);
            }
        } else if (action.equals("BANNER")) {
            if (this.MW.status != -3) {
                this.MW.pop(-1);
            }
        } else if (!action.equals("SELECT")) {
            int button;
            if (action.equals("INTERRUPT")) {
                this.textinput = this.mjtext.getInput();
                if (this.mode == -2) {
                    this.textinput = "\n";
                }
                this.interrupt = 1;
            } else if (action.equals("BUTTON") && ((button = e.getModifiers()) == 2 || button == 3)) {
                new GMenu(this.MW, "GTerminal", "Copy,Paste,Clear,Configure,Exit", 0, 0, this);
                this.mjtext.refreshO();
            }
        }
    }

    @Override
    public int processMessage(Message msg) {
        if (msg.name.equals("GTERMINAL")) {
            String action = (String)msg.data;
            if (action.equals("CLEAR")) {
                this.mjtext.removeAll();
            }
            if (action.equals("PASTE")) {
                this.mjtext.paste();
            }
            if (action.equals("COPY")) {
                this.mjtext.copy();
            }
            if (action.equals("CONFIGURE")) {
                new GMenu(this.MW, "GTerminal.cfg", "Multiple,Fifo,Tree,Columns,NoSelect,NoHilite,BackLite,Input,Text,Wrap,Color,Banner,AddPlus,Logger", this.mjtext.getFlags(), 1024, this);
            }
            if (action.equals("EXIT")) {
                this.MW.process("MENUEXIT", 0);
            }
        } else if (msg.name.equals("GTERMINAL.CFG")) {
            this.mjtext.setFlags(msg.info);
        }
        return 0;
    }

    @Override
    public void more(String text) {
        if (this.morestat >= 0 && this.morestat == 0) {
            String ans = this.getInput("Press RETURN=NextLine, SPACE=NextPage, or Q=Quit: ", "", -2);
            this.morestat = ans == null ? -1 : (ans.startsWith("q") ? -1 : (ans.startsWith("Q") ? -1 : (ans.equals("\n") ? 1 : this.getRows() - 1)));
        }
        if (this.morestat > 0) {
            this.writeln(text);
            if (this.mjtext != null) {
                this.morestat -= this.mjtext.getNbrWraps(text);
                this.morestat = Math.max(0, this.morestat);
            } else {
                --this.morestat;
            }
        }
    }
}

