/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Message;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.libg.GValue;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MJTextField;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.MWindow;

public class GMenu
extends GWidget
implements ActionListener {
    private static final boolean SET_TOGGLE_WITH_MASK = true;
    public static String flagsList = GWidget.flagsList + ",Choice,Button,Toggle,ChkBox,TTop,TLeft,TRight,TBottom,TOff,OneRow,NColumn,setColumns>,ToggleList,Input,CS,NoState,NoDepress,Rollup,Flat,AssumeState,Shade";
    public static final int CHOICE = 256;
    public static final int BUTTON = 512;
    public static final int TOGGLE = 1024;
    public static final int CHKBOX = 2048;
    public static final int TTOP = 4096;
    public static final int TLEFT = 8192;
    public static final int TRIGHT = 16384;
    public static final int TBOTTOM = 32768;
    public static final int TMASK = 61440;
    public static final int TOFF = 65536;
    public static final int ONEROW = 131072;
    public static final int NCOL = 262144;
    public static final int SETCOL = 524288;
    public static final int TOGGLELIST = 0x100000;
    public static final int INPUT = 0x200000;
    public static final int CS = 0x400000;
    public static final int NOSTATE = 0x800000;
    public static final int NODEPRESS = 0x1000000;
    public static final int ROLLUP = 0x2000000;
    public static final int FLAT = 0x4000000;
    public static final int ASSUMESTATE = 0x8000000;
    public static final int SHADE = 0x10000000;
    private static final int pixPerIndent = 16;
    public static final Color DEF_DISABLED_COLOR = Color.GRAY;
    private String[] itemv;
    private int rows;
    private int columns;
    private int items;
    private int titlex1;
    private int titley1;
    private int titlex2;
    private int titley2;
    private int itemwidth = 0;
    private int maxwidth = 0;
    private int titlewidth = 0;
    private int altwidth = 0;
    private int altheight = 0;
    private int maxheight = 0;
    private int curitem = 0;
    private int defitem = 0;
    private int nc = 2;
    private int noStateMask = 0;
    private int disableMask = 0;
    protected MBox posi = new MBox();
    private MBox bp;
    private MBox bc;
    private MBox bt;
    private Font fontb;
    private GMenu gchoice;
    private MJTextField jtexti;
    public String list;
    public Table ctab = null;
    private Table savedColors = null;
    private int mouseMode = 0;
    private boolean altzone = false;
    private HashMap<Integer, String> disabledItems;
    private Color disabledItemColor = DEF_DISABLED_COLOR;
    private boolean isSetup = false;
    private boolean shouldScroll = false;
    private static final int SCROLLBAR_WIDTH = 10;
    private static double scrollY = 0.0;
    private double scrollYAtStartOfSlide = 0.0;
    private boolean slidingKnob = false;
    private int startDisplayAt = 0;
    private int maxMenuHeight = 0;
    private boolean isPopup = false;

    public GMenu(Object parent, String name, String list3, int item, int flags, MessageHandler mh) {
        super("GMenu", parent, name, flags, mh);
        this.open(name, list3, item);
        this.addTo(parent);
        if (parent != null) {
            this.panel.requestFocusInWindow();
        }
    }

    public GMenu(String label, Object parent, String name, int flags, MessageHandler mh) {
        super(label, parent, name, flags, mh);
    }

    void open(String name) {
        super.open();
        if (name.equals("GCHOICE")) {
            this.label = name;
            this.title = "";
        }
        this.fontb = this.newFont(this.font, "", 1, -1);
        this.titlewidth = this.fontb == null ? this.tw * this.title.length() : this.panel.getFontMetrics(this.fontb).stringWidth(this.title);
        if (this.is(0x100000)) {
            this.flags |= 0x400;
        }
        if (!this.is(1) && this.is(1024)) {
            this.flags ^= 0x800;
        }
        if (this.parent != null && this.parent instanceof MPlot) {
            ++((MPlot)this.parent).popupCount;
        }
        if (this.parent != null && this.parent instanceof GWidget) {
            this.setWidgetTheme(((GWidget)this.parent).getWidgetTheme());
        }
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        this.titlew = this.stringWidth(title);
        this.titlewidth = this.fontb == null ? this.tw * title.length() : this.panel.getFontMetrics(this.fontb).stringWidth(title);
        if (this.isSetup) {
            this.setup();
            this.refresh();
        }
    }

    public void open(String name, String list3, int item) {
        this.open(name);
        this.setItems(list3);
        this.defitem = item;
        this.resize(1);
    }

    @Override
    public void close() {
        if (this.mh instanceof GMenu) {
            ((GMenu)this.mh).gchoice = null;
        }
        if (this.parent != null && this.parent instanceof MPlot) {
            --((MPlot)this.parent).popupCount;
        }
        super.close();
    }

    public void setItems(String list3) {
        Parser parser = new Parser(list3, false);
        parser.setUseSpaceDelimiter(false);
        this.itemwidth = 0;
        boolean redo = this.list != null;
        String item0 = redo ? this.getValue(this.defitem, false) : "";
        this.list = list3;
        this.items = 0;
        if (list3.length() > 0) {
            this.items = parser.elements();
        }
        if (this.is(1024) && this.items > 31) {
            Shell.warning("GMenu: TOGGLE list has max length of 31, ignoring entries 32 to " + this.items + " in " + list3);
            this.items = 31;
        }
        this.itemv = new String[this.items + 1];
        this.itemv[0] = item0 != null ? item0 : "";
        int ndefitem = 0;
        for (int i = 1; i <= this.items; ++i) {
            String tmpstr;
            this.itemv[i] = tmpstr = parser.get(i);
            int w = this.stringWidth(tmpstr);
            if (w > this.itemwidth) {
                this.itemwidth = w;
            }
            if (!redo || this.defitem == 0 || !tmpstr.equals(item0)) continue;
            ndefitem = i;
        }
        if (!this.is(1024)) {
            this.defitem = ndefitem;
        }
        this.itemwidth += this.tw * 2;
        this.setup();
        if (redo) {
            this.refresh();
        }
    }

    void setItems(Object[] array, int len) {
        this.itemwidth = 0;
        boolean redo = this.list != null;
        String item0 = redo ? this.itemv[0] : "";
        this.list = "";
        this.items = len;
        this.itemv = new String[this.items + 1];
        this.itemv[0] = item0;
        for (int i = 1; i <= this.items; ++i) {
            String tmpstr;
            this.itemv[i] = tmpstr = array[i - 1].toString();
            this.list = i > 1 ? this.list + "," + tmpstr : this.list + tmpstr;
            int w = this.stringWidth(tmpstr) + this.getIndent(i) * 16;
            if (w <= this.itemwidth) continue;
            this.itemwidth = w;
        }
        this.itemwidth += this.tw * 2;
        this.setup();
        if (redo) {
            this.refresh();
        }
    }

    public String getItems() {
        return this.list;
    }

    public int getItemCount() {
        if (this.itemv == null) {
            return 0;
        }
        int nitems = this.itemv.length;
        if (this.itemv[0].length() <= 0 || Arrays.asList(this.itemv).lastIndexOf(this.itemv[0]) > 0) {
            --nitems;
        }
        return nitems;
    }

    @Override
    public void resize(int mode) {
        super.resize(mode);
        if (this.is(256)) {
            this.bt.w = this.pos.w - this.bt.x - this.bw - this.titlex2;
        }
    }

    @Override
    public void setup() {
        this.bw = this.is(32) ? 0 : 2;
        if (this.is(256)) {
            this.setupChoice();
        } else {
            this.setupMenu();
        }
        this.layout();
        this.isSetup = true;
    }

    protected void setupChoice() {
        this.maxheight = this.th + this.ta - this.compression;
        this.maxwidth = this.itemwidth + this.altwidth + this.tw;
        if (this.units != null) {
            this.maxwidth += this.tw + this.stringWidth(this.units);
        }
        if (this.fixLineHeight > this.maxheight) {
            this.maxheight = this.fixLineHeight;
        }
        this.titley2 = 0;
        this.titlex2 = 0;
        this.titley1 = 0;
        this.titlex1 = 0;
        if (!this.is(65536)) {
            if (this.is(4096)) {
                this.titley1 = this.maxheight + 2;
            }
            if (this.is(8192)) {
                this.titlex1 = this.titlewidth + this.tw + this.tw;
            }
            if (this.is(32768)) {
                this.titley2 = this.maxheight + 2;
            }
            if (this.is(16384)) {
                this.titlex2 = this.titlewidth + this.tw + this.tw;
            }
            if (this.title.length() > 0 && !this.is(61440)) {
                this.titlex1 = this.titlewidth + this.tw + this.tw;
            }
        }
        this.pos.w = this.maxwidth + this.bw * 2 + this.titlex1 + this.titlex2;
        this.pos.h = this.maxheight + this.bw * 2 + this.titley1 + this.titley2;
        if (this.fixWidth > this.pos.w) {
            this.pos.w = this.fixWidth;
        }
        this.bp = this.titlex1 > 0 ? new MBox(this.bw + this.tw, this.bw + this.titley1, this.titlewidth, this.maxheight) : (this.titley1 > 0 ? new MBox(this.pos.w / 2 - this.titlewidth / 2, this.bw, this.titlewidth, this.maxheight) : (this.titlex2 > 0 ? new MBox(this.pos.w - this.bw - this.titlewidth - this.tw, this.bw + this.titley1, this.titlewidth, this.maxheight) : (this.titley2 > 0 ? new MBox(this.pos.w / 2 - this.titlewidth / 2, this.pos.h - this.bw - this.maxheight, this.titlewidth, this.maxheight) : new MBox(this.bw, this.bw, 0, 0))));
        this.bc = this.titlex1 > 0 ? new MBox(this.bw + this.titlex1 - this.tw, this.bw + this.titley1, this.th + this.tw, this.maxheight) : new MBox(this.bw, this.bw + this.titley1, this.th + this.tw, this.maxheight);
        this.bt = new MBox(this.bc.x + this.bc.w, this.bc.y + this.bc.h / 2 - this.th / 2, this.maxwidth, this.th);
    }

    protected void setupMenu() {
        int maxcolumns;
        int maxrows;
        int parentWidth;
        int parentHeight;
        this.maxheight = this.th + 5 - this.compression;
        if (this.is(512)) {
            this.maxheight += 5;
        }
        this.maxwidth = this.itemwidth + this.altwidth + this.tw;
        if (this.is(2048)) {
            this.maxwidth += this.tw * 2;
        }
        if (this.fixLineHeight > this.maxheight) {
            this.maxheight = this.fixLineHeight;
        }
        boolean bl = this.isPopup = this.fixWidth == 0;
        if (this.parent instanceof MWindow) {
            parentHeight = this.MW.pos.h;
            parentWidth = this.MW.pos.w;
            Container outerParent = this.getOuterContainerOfParent(1);
            if (outerParent != null && this.isPopup) {
                if (outerParent.getWidth() > parentWidth) {
                    parentWidth = outerParent.getWidth();
                }
                if (outerParent.getHeight() > parentHeight) {
                    parentHeight = outerParent.getHeight();
                }
            }
        } else if (this.parent instanceof Container) {
            parentHeight = this.pos.h;
            parentWidth = this.pos.w;
        } else {
            parentHeight = 1000;
            parentWidth = 1000;
        }
        int maxMenuWidth = parentWidth;
        this.maxMenuHeight = parentHeight;
        if (this.fixWidth > 0) {
            maxMenuWidth = this.fixWidth;
        }
        this.titley2 = 0;
        this.titlex2 = 0;
        this.titley1 = 0;
        this.titlex1 = 0;
        if (!this.is(65536)) {
            if (this.is(4096)) {
                this.titley1 = this.maxheight + 2;
            }
            if (this.is(8192)) {
                this.titlex1 = this.titlewidth + this.tw + this.tw;
            }
            if (this.is(32768)) {
                this.titley2 = this.maxheight + 2;
            }
            if (this.is(16384)) {
                this.titlex2 = this.titlewidth + this.tw + this.tw;
            }
            if (this.title.length() > 0 && !this.is(61440)) {
                if (this.maxMenuHeight > this.maxheight * Math.min(3, this.items + 1)) {
                    this.titley1 = this.maxheight + 2;
                } else {
                    this.titlex1 = this.titlewidth + 10;
                }
            }
        }
        this.shouldScroll = this.items > (maxrows = Math.max(1, (this.maxMenuHeight - this.titley1 - this.titley2 - 2 * this.bw) / this.maxheight)) * (maxcolumns = Math.max(1, (maxMenuWidth - this.titlex1 - this.titlex2 - 2 * this.bw) / this.maxwidth)) && this.isPopup;
        int widthForScrollBar = 0;
        if (this.shouldScroll) {
            widthForScrollBar = 10;
            maxcolumns = Math.max(1, (maxMenuWidth - this.titlex1 - this.titlex2 - 10 - 2 * this.bw) / this.maxwidth);
        }
        scrollY = 0.0;
        int ilw = this.is(32) && this.pGroup != null ? 4 : 0;
        this.columns = (this.items - 1) / Math.min(10, maxrows) + 1;
        this.columns = Math.min(this.columns, maxcolumns);
        if (this.is(262144) && this.nc > 0) {
            this.columns = this.nc;
        }
        if (this.is(262144) && this.nc < 0) {
            this.columns = this.items;
        }
        if (this.is(131072)) {
            this.columns = this.items;
        }
        this.rows = (this.items + this.columns - 1) / this.columns;
        this.pos.w = this.maxwidth * this.columns + this.bw * 2 + ilw * 2 + this.titlex1 + this.titlex2 + widthForScrollBar;
        if (this.titley1 > 0 || this.titley2 > 0) {
            this.pos.w = Math.max(this.titlewidth + this.tw + this.bw * 2, this.pos.w);
        }
        if (this.fixWidth > this.pos.w) {
            this.pos.w = this.fixWidth;
        }
        this.maxwidth = (this.pos.w - this.bw * 2 - ilw * 2 - this.titlex1 - this.titlex2 - widthForScrollBar) / this.columns;
        this.pos.h = this.bw * 2 + this.titley1 + this.titley2;
        if (!this.is(0x2000000)) {
            this.pos.h += this.maxheight * this.rows;
        }
        if (this.fixLineHeight > this.pos.h) {
            this.pos.h = this.fixLineHeight;
        }
    }

    private Container getOuterContainerOfParent(int levelsOut) {
        Container outerParent;
        block4: {
            int currentLevelOut;
            block3: {
                outerParent = null;
                if (levelsOut == 0) {
                    return outerParent;
                }
                if (!(this.parent instanceof MWindow)) break block3;
                Container nextParent = outerParent = this.MW.panel.getParent();
                for (currentLevelOut = 1; nextParent != null && (levelsOut < 0 || currentLevelOut < levelsOut); ++currentLevelOut) {
                    outerParent = nextParent;
                    nextParent = outerParent.getParent();
                }
                break block4;
            }
            if (!(this.parent instanceof Container)) break block4;
            Container nextParent = outerParent = ((Container)this.parent).getParent();
            while (nextParent != null && (levelsOut < 0 || currentLevelOut < levelsOut)) {
                ++currentLevelOut;
                outerParent = nextParent;
                nextParent = outerParent.getParent();
            }
        }
        return outerParent;
    }

    @Override
    @Deprecated
    public void paint() {
        this.refresh();
    }

    @Override
    @ProvisionalUseOnly(value="Treat this as protected and should only be called by subclass paintComponent methods")
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.is(256)) {
            this.paintChoice(g);
        } else {
            this.paintMenu(g);
        }
    }

    protected final void paintChoice() {
    }

    protected final void paintMenu() {
    }

    protected void paintChoice(Graphics g) {
        int y;
        int b2 = 2 * this.bw;
        int bf = this.is(0x10000000) ? -5 : (this.is(32) ? -2 : 0);
        Rectangle r = g.getClipBounds();
        if (this.hasLocalTheme() && !this.is(0x10000000)) {
            Color origColor = g.getColor();
            g.setColor(this.theme.cwbg);
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(origColor);
        }
        if (this.bc.equals(r)) {
            if (this.is(0x10000000)) {
                this.shadowbox(g, 0, 0, this.pos.w, this.pos.h, bf);
            }
            this.drawArrows(g);
            return;
        }
        this.shadowbox(g, 0, 0, this.pos.w, this.pos.h, bf);
        this.setValueBox(this.bt.x - 3, this.bt.y, this.bt.w - 2, this.bt.h);
        this.drawValueBox(g, 1);
        g.setFont(this.fontb);
        int ty = this.bw + this.titley1 + this.maxheight / 2 + this.ta / 2;
        int x = this.pos.w / 2 - this.titlewidth / 2;
        if (this.titley1 > 0) {
            int dh = this.titley1;
            int j1 = (int)((double)dh * 0.15);
            y = this.bw + this.maxheight / 2 + this.ta / 2 - 1;
            this.setTextClip(g, this.panel, this.title, x);
            this.setColor(g, this.theme.cwti);
            g.drawString(this.title, x, y);
            y = this.bw + this.maxheight - 2;
            if (!this.is(32)) {
                this.setColor(g, this.theme.cwbs);
                g.drawLine(b2, y, this.pos.w - b2 - 1, y);
                this.setColor(g, this.theme.cwms);
                g.drawLine(b2, y += 2, this.pos.w - b2 - 1, y);
            }
        }
        if (this.titley2 > 0) {
            y = this.pos.h - this.bw - this.maxheight / 2 + this.ta / 2;
            this.setTextClip(g, this.panel, this.title, x);
            this.setColor(g, this.theme.cwti);
            g.drawString(this.title, x, y);
            y = this.pos.h - this.bw - this.maxheight - 1;
            if (!this.is(32)) {
                this.setColor(g, this.theme.cwbs);
                g.drawLine(b2, y, this.pos.w - b2 - 1, y);
                this.setColor(g, this.theme.cwms);
                g.drawLine(b2, y += 2, this.pos.w - b2 - 1, y);
            }
        }
        g.setFont(this.font);
        y = (this.titley1 + this.pos.h - this.titley2) / 2 + this.maxheight / 4;
        if (this.titlex1 > 0) {
            x = this.bw + this.tw;
            this.setTextClip(g, this.panel, this.title, x);
            this.setColor(g, this.theme.cwti);
            g.drawString(this.title, x, y);
        }
        if (this.titlex2 > 0) {
            x = this.pos.w - this.titlewidth - this.bw - this.tw;
            this.setTextClip(g, this.panel, this.title, x);
            this.setColor(g, this.theme.cwti);
            g.drawString(this.title, x, y);
        }
        this.setTextClip(g, this.panel, this.title, this.bp.x);
        g.setColor(this.theme.cwfg);
        String text = this.getValue(this.defitem, false);
        if (this.is(1024)) {
            text = Parser.mask2s(this.list, this.defitem);
            text = text.length() <= 1 ? "" : text.substring(1, text.length() - 1);
        }
        Color c = null;
        if (this.ctab != null) {
            c = (Color)this.ctab.get(text.toUpperCase());
        }
        if (c == null) {
            c = this.theme.cwfg;
        }
        this.setColor(g, c);
        if (this.units != null) {
            text = text + " " + this.units;
        }
        this.setTextClip(g, this.panel, text, this.bt.x);
        g.drawString(text, this.bt.x, ty);
        g.setColor(this.theme.cwfg);
        this.drawArrows(g);
    }

    private void drawArrows(Graphics g) {
        this.drawDiamond(g, this.bc.x + this.bc.w / 2, this.bc.y + this.bc.h / 2, this.tw * 2 / 3, this.mouseMode);
    }

    protected void paintMenu(Graphics g) {
        int totalHeight;
        int y;
        int i;
        int b2 = 2 * this.bw;
        int bf = this.is(0x10000000) ? -5 : (this.is(32) ? -2 : 0);
        g.setFont(this.font);
        this.setColor(g, this.theme.cwfg);
        this.shadowbox(g, 0, 0, this.pos.w, this.pos.h, bf);
        this.setColor(g, this.theme.cwfg);
        int x = this.pos.w / 2 - this.titlewidth / 2;
        boolean rollup = this.is(0x2000000);
        if (this.titley1 > 0) {
            int dh = this.titley1;
            int j1 = (int)((double)dh * 0.15);
            if (!this.is(0x4000000)) {
                for (i = 1; i <= dh; ++i) {
                    if (i < j1) {
                        g.setColor(MColor.getColorMix(this.theme.cwbg, this.theme.cwbs, (double)i / (double)j1));
                    } else {
                        g.setColor(MColor.getColorMix(this.theme.cwbs, this.theme.cwms, (double)(i - j1) / (double)(dh - j1 - 1)));
                    }
                    g.drawLine(1, i, this.pos.w - 2, i);
                }
                g.drawLine(0, 0, this.pos.w, 0);
            }
            if (this.is(0x4000000)) {
                this.setColor(g, this.theme.cwti);
                g.setFont(this.fontb);
            } else if (rollup) {
                this.setColor(g, this.theme.cwti.darker());
            } else {
                this.setColor(g, this.theme.cwbs);
                g.drawLine(this.bw + 1, dh, this.pos.w - this.bw - 1, dh);
                this.setColor(g, this.theme.cwti);
            }
            y = this.bw + this.maxheight / 2 + this.ta / 2 - 1;
            this.setTextClip(g, this.panel, this.title, x);
            g.drawString(this.title, x, y);
            y = this.bw + this.maxheight - 2;
            if (this.is(0x4000000) && !this.is(32)) {
                this.setColor(g, this.theme.cwbs);
                g.drawLine(b2, y, this.pos.w - b2 - 1, y);
                this.setColor(g, this.theme.cwms);
                g.drawLine(b2, y += 2, this.pos.w - b2 - 1, y);
            }
        }
        if (rollup) {
            return;
        }
        g.setFont(this.fontb);
        int n = totalHeight = this.isPopup ? this.maxMenuHeight : this.pos.h;
        if (this.titley2 > 0) {
            y = totalHeight - this.bw - this.maxheight / 2 + this.ta / 2;
            this.setColor(g, this.theme.cwti);
            this.setTextClip(g, this.panel, this.title, x);
            g.drawString(this.title, x, y);
            y = totalHeight - this.bw - this.maxheight - 1;
            if (!this.is(32)) {
                this.setColor(g, this.theme.cwbs);
                g.drawLine(b2, y, this.pos.w - b2 - 1, y);
                this.setColor(g, this.theme.cwms);
                g.drawLine(b2, y += 2, this.pos.w - b2 - 1, y);
            }
        }
        int heightForTitleX = this.pos.h < this.maxMenuHeight ? this.pos.h : this.maxMenuHeight;
        y = (this.titley1 + heightForTitleX - this.titley2) / 2 + this.maxheight / 4;
        if (this.titlex1 > 0) {
            x = this.bw + this.tw;
            this.setColor(g, this.theme.cwti);
            this.setTextClip(g, this.panel, this.title, x);
            g.drawString(this.title, x, y);
            x = this.bw + this.titlex1 - 4;
            if (!this.is(32)) {
                this.setColor(g, this.theme.cwbs);
                g.drawLine(x, this.titley1 + b2, x, heightForTitleX - this.titley2 - b2 - 1);
                this.setColor(g, this.theme.cwms);
                g.drawLine(x += 2, this.titley1 + b2, x, heightForTitleX - this.titley2 - b2 - 1);
            }
        }
        if (this.titlex2 > 0) {
            x = this.pos.w - this.bw - this.titlex2 + 4 + this.tw;
            this.setColor(g, this.theme.cwti);
            this.setTextClip(g, this.panel, this.title, x);
            g.drawString(this.title, x, y);
            x = this.pos.w - this.bw - this.titlex2 + 1;
            if (!this.is(32)) {
                this.setColor(g, this.theme.cwbs);
                g.drawLine(x, this.titley1 + b2, x, heightForTitleX - this.titley2 - b2 - 1);
                this.setColor(g, this.theme.cwms);
                g.drawLine(x += 2, this.titley1 + b2, x, heightForTitleX - this.titley2 - b2 - 1);
            }
        }
        g.setFont(this.font);
        g.setColor(this.theme.cwfg);
        for (i = 1; i <= this.items; ++i) {
            this.refreshItem(g, i, false);
        }
        if (this.shouldScroll) {
            this.paintScroll(g);
        }
    }

    private void paintScroll(Graphics g) {
        int x = this.pos.w - 10 - this.bw - this.titlex2 + 1;
        int y = this.titley1;
        int flags = 6 | (this.shouldScroll ? 1 : 0);
        int maxHeight = this.maxMenuHeight - this.titley1 - this.titley2 - 2 * this.bw;
        MWindow.drawVSlider(x, y, 10, maxHeight, scrollY / (double)maxHeight, flags, g, this.theme);
    }

    boolean isToggled(int i) {
        return (1 << i - 1 & this.defitem) != 0;
    }

    public void setNoStateMask(int mask) {
        this.noStateMask = mask;
        this.flags |= 0x8000000;
    }

    private boolean isNoState(int i) {
        return (1 << i - 1 & this.noStateMask) != 0;
    }

    public void setDisableMask(int mask) {
        this.disableMask = mask;
    }

    private boolean isDisable(int i) {
        return (1 << i & this.disableMask) != 0;
    }

    public void setSelectedTextColor(Color c) {
        this.jtexti.setSelectedTextColor(c);
    }

    public void setSelectedTextColor(String color) {
        this.setSelectedTextColor(MColor.getColor(color));
    }

    public String getSelectedTextColorString() {
        return MColor.toString(this.getSelectedTextColor());
    }

    public Color getSelectedTextColor() {
        return this.jtexti.getSelectedTextColor();
    }

    public void setSelectionColor(Color c) {
        this.jtexti.setSelectionColor(c);
    }

    public void setSelectionColor(String c) {
        this.setSelectionColor(MColor.getColor(c));
    }

    public String getSelectionColorString() {
        return MColor.toString(this.getSelectionColor());
    }

    public Color getSelectionColor() {
        return this.jtexti.getSelectionColor();
    }

    int getIndent(int i) {
        return 0;
    }

    @Deprecated
    protected void refreshItem(int i, boolean overwrite) {
        this.refreshItem(this.g, i, overwrite);
    }

    protected void refreshItem(Graphics g, int i, boolean overwrite) {
        boolean standout;
        int totalHeight;
        if (this.is(0x2000000)) {
            return;
        }
        if (g == null) {
            return;
        }
        if (this.isPopup) {
            totalHeight = this.maxMenuHeight;
            int maxHeight = totalHeight - this.titley1 - this.titley2 - 2 * this.bw;
            this.startDisplayAt = (int)((double)this.pos.h * (scrollY / (double)maxHeight));
            this.startDisplayAt = Math.min(this.pos.h - maxHeight, this.startDisplayAt);
            this.startDisplayAt = Math.max(0, this.startDisplayAt);
        } else {
            totalHeight = this.pos.h;
            int maxHeight = totalHeight - this.titley1 - this.titley2 - 2 * this.bw;
        }
        boolean butt = this.is(512);
        boolean togg = this.is(1024);
        boolean chk = this.is(2048);
        String tmpstr = this.getItem(i);
        if (!this.is(256)) {
            this.getitemloc(i, this.posi);
        }
        if (togg) {
            standout = this.isToggled(i);
        } else {
            boolean bl = standout = i == this.defitem && !this.is(0x1000000);
        }
        if (overwrite) {
            this.shadowbox(g, this.posi.x, this.posi.y, this.posi.w, this.posi.h, 0);
        }
        if (butt) {
            this.shadowbox(g, this.posi.x + 2, this.posi.y + 2, this.posi.w - 4, this.posi.h - 4, standout ? -3 : 1);
        }
        int x = this.posi.x + this.tw;
        int y = this.posi.y + this.maxheight / 2;
        if (chk) {
            int w = this.tw * 3 / 2;
            this.shadowbox(g, (x += this.tw / 2) - w / 2, y - w / 2, w, w, standout ? 2 : 1);
            x += 3 * this.tw / 2;
        }
        if (butt) {
            x += (this.posi.x + this.posi.w - this.tw - x - this.stringWidth(tmpstr)) / 2;
        }
        Color c = this.theme.cwfg;
        if (this.ctab != null) {
            c = (Color)this.ctab.get(tmpstr.toUpperCase());
        }
        if (standout && !butt && !chk) {
            c = this.theme.cwfh;
        }
        if (c == null) {
            c = this.theme.cwfg;
        }
        this.setColor(g, c);
        this.setTextClip(g, this.panel, tmpstr, x);
        if (y > this.titley1 + this.bw && y + this.ta / 2 - 1 < totalHeight - this.titley2 - this.bw) {
            g.drawString(tmpstr, x, y + this.ta / 2 - 1);
        }
        if (i == this.curitem) {
            this.shadowbox(g, this.posi.x, this.posi.y, this.posi.w, this.posi.h, butt ? -4 : 1);
        }
        if (this.altwidth > 0) {
            this.posi.x += this.posi.w - this.tw - this.altwidth;
            this.posi.w = this.altwidth;
            this.posi.y += 4;
            this.posi.h -= 8;
            this.refreshItemAlt(g, i, this.posi);
        }
    }

    @Deprecated
    protected void refreshItemAlt(int i, MBox posi) {
        this.shadowarrow(posi.x + this.pos.w / 2, this.pos.y + this.pos.h / 2, this.tw * 2 / 3, 'r');
    }

    protected void refreshItemAlt(Graphics g, int i, MBox posi) {
        this.shadowarrow(g, posi.x + this.pos.w / 2, this.pos.y + this.pos.h / 2, this.tw * 2 / 3, 'r');
    }

    protected void highlight(int i) {
        if (i == this.curitem) {
            return;
        }
        if (this.curitem != 0) {
            this.getitemloc(this.curitem, this.posi);
            this.refresh(this.posi);
        }
        if (i == 0) {
            this.curitem = 0;
        } else if (i > 0) {
            this.curitem = i;
            this.getitemloc(this.curitem, this.posi);
            this.refresh(this.posi);
        } else if (i < 0) {
            this.getitemloc(-i, this.posi);
            this.refresh(this.posi);
        }
    }

    private void getitemloc(int index, MBox posj) {
        int indt = this.getIndent(index) * 16;
        int ic = (index - 1) / this.rows;
        int ir = index - 1 - ic * this.rows;
        posj.x = ic * this.maxwidth + this.bw + this.titlex1 + indt;
        posj.y = ir * this.maxheight + this.bw + this.titley1 - this.startDisplayAt;
        posj.w = this.maxwidth - indt;
        posj.h = this.maxheight;
        if (this.is(32) && this.pGroup != null) {
            posj.x += 4;
        }
    }

    private int getindex(int x, int y) {
        if (y < this.titley1 || y > this.pos.h - this.titley2) {
            return 0;
        }
        if (x < this.titlex1 || x > this.pos.w - this.titlex2) {
            return 0;
        }
        int ic = (x - this.titlex1 - this.bw) / this.maxwidth;
        int ir = this.shouldScroll ? (y - this.titley1 - this.bw + this.startDisplayAt) / this.maxheight : (y - this.titley1 - this.bw) / this.maxheight;
        ic = Math.max(0, Math.min(ic, this.columns - 1));
        ir = Math.max(0, Math.min(ir, this.rows - 1));
        int i = Math.max(0, Math.min(ic * this.rows + ir + 1, this.items));
        this.altzone = this.altwidth > 0 && x > (ic + 1) * this.maxwidth - this.tw - this.altwidth;
        return i;
    }

    @Override
    public String getLegend() {
        String rm = "";
        if (!this.is(256)) {
            return "(LM=Select)";
        }
        if (!this.is(1)) {
            rm = ",RM=Cancel";
        }
        if (this.mouseMode == 0) {
            if (!this.is(1)) {
                return "(MM=Configure, RM=Cancel)";
            }
            return "(MM=Configure)";
        }
        if (this.mouseMode == 1) {
            return "(LM=UP" + rm + ")";
        }
        if (this.mouseMode == 2) {
            return "(LM=Down" + rm + ")";
        }
        if (this.mouseMode == 3) {
            return "(MM=Configure" + rm + ")";
        }
        if (this.is(0x200000)) {
            return "(LM=PopupMenu,RM=EditItem)";
        }
        return "(LM=PopupMenu" + rm + ")";
    }

    @Override
    protected int processEventMessage(String name, int info, Object data) {
        if (this.is(256)) {
            this.processChoiceEventMessage(name, info, data);
        } else {
            this.processMenuEventMessage(name, info, data);
        }
        return -1;
    }

    protected int processChoiceEventMessage(String name, int info, Object data) {
        if (name.equals("KEYPRESS")) {
            this.handleKeyPress(info, (String)data);
        } else if (name.equals("POINTER")) {
            int mm = 0;
            if (info < 0) {
                mm = 0;
            } else if (this.px > this.bc.x + this.bc.w) {
                mm = 8;
            } else if (this.px <= this.bc.x) {
                mm = 0;
            } else if (!this.is(1024)) {
                mm = this.py > this.bc.h / 2 + this.titley1 ? 2 : 1;
            }
            if (mm != this.mouseMode) {
                this.mouseMode = mm;
                this.refresh(this.bc);
                if (info == 0) {
                    info = 1;
                }
            }
            if (this.is(128) && Math.abs(info) == 9) {
                this.refreshValue();
            }
            this.formatReadOut(info);
        }
        if (!name.equals("BUTTON")) {
            return -1;
        }
        if (this.button == 1 && this.px > this.bt.x && this.items > 0) {
            if (this.gchoice == null) {
                int pflags = this.flags & 0x40400;
                this.gchoice = new GMenu(this, "GCHOICE", this.list, this.defitem, pflags, this);
                if (this.is(262144)) {
                    this.gchoice.setColumns(this.nc);
                }
            }
            this.gchoice.ctab = this.ctab;
        } else if (this.button == 2 && this.curitem <= 0) {
            this.configure();
        } else if (this.button == 3 && !this.is(1) && !this.is(0x200000)) {
            this.selectChoice(this.defitem);
            this.close();
        } else if (this.button > 0 && this.mouseMode != 0 && this.mouseMode != 8) {
            int mitem;
            int item = this.defitem;
            int n = mitem = this.is(0x200000) && this.itemv[0].length() > 0 ? 0 : 1;
            if (this.button == 1 && this.mouseMode == 1) {
                item = Math.max(this.defitem - 1, mitem);
            } else if (this.button == 1 && this.mouseMode == 2) {
                item = Math.min(this.defitem + 1, this.items);
            }
            if (item != this.defitem) {
                this.selectChoice(item);
            }
        } else if (this.button == 3 && this.bt.within(this.px, this.py) && this.is(0x200000)) {
            this.setupTextField();
        }
        this.formatReadOut(1);
        return 1;
    }

    private void handleKeyPress(int keyCode, String keyText) {
        int diff = 0;
        if (this.rows == 0) {
            this.rows = 1;
        }
        block0 : switch (keyCode) {
            case 40: {
                diff = 1;
                break;
            }
            case 38: {
                diff = -1;
                break;
            }
            case 39: {
                diff = this.rows;
                break;
            }
            case 37: {
                diff = -this.rows;
                break;
            }
            case 10: {
                this.select(this.curitem, 1);
                this.formatReadOut(1);
                break;
            }
            default: {
                for (int i = 1; i <= this.items; ++i) {
                    String tmpstr = this.getValue(i, !this.is(0x400000));
                    if (!tmpstr.startsWith(keyText)) continue;
                    this.select(i, 1);
                    break block0;
                }
            }
        }
        if (diff != 0) {
            this.highlight((this.curitem + diff - 1 + this.items) % this.items + 1);
        }
    }

    protected void setupTextField() {
        this.jtexti = new MJTextField("", 20);
        this.jtexti.setFont(this.font);
        this.jtexti.setForeground(this.theme.cwfg);
        this.jtexti.setBackground(this.theme.cwbg);
        this.jtexti.addActionListener(this);
        this.jtexti.setText(this.getValue(this.defitem, true));
        this.panel.add(this.jtexti);
        this.jtexti.requestFocus();
        int hd = 2;
        this.jtexti.setBounds(this.bc.x + hd, this.bc.y + hd, this.bc.w + this.bt.w - hd - hd, this.bc.h - hd - hd);
    }

    protected int processMenuEventMessage(String name, int info, Object data) {
        if (name.equals("POINTER")) {
            int extraMarginX = 2;
            if (this.shouldScroll && (this.px > this.pos.w - this.titlex2 - this.bw - 10 - extraMarginX || this.py + this.ta / 2 > this.maxMenuHeight - this.titley2 - this.bw - 1)) {
                this.highlight(0);
            } else {
                int i = this.getindex(this.px, this.py);
                if (this.dragging == 0) {
                    if (info < 0) {
                        this.highlight(0);
                    } else {
                        this.highlight(i);
                    }
                }
                this.formatReadOut(info);
            }
        } else if (name.equals("BUTTON")) {
            int leftOfScrollBar = this.pos.w - this.titlex2 - this.bw - 10;
            int extraMarginX = 2;
            if (this.shouldScroll && this.px > leftOfScrollBar - extraMarginX && this.px < leftOfScrollBar + 10 + 2 * extraMarginX) {
                int maxHeight = this.maxMenuHeight - this.titley1 - this.titley2;
                int yAdjustedForTitle = this.py - this.titley1;
                if ((double)yAdjustedForTitle > scrollY + 16.0) {
                    scrollY += (double)((float)maxHeight * ((float)maxHeight / (float)this.pos.h));
                    scrollY = Math.min(scrollY, (double)maxHeight);
                    this.layout();
                } else if ((double)yAdjustedForTitle < scrollY) {
                    scrollY -= (double)((float)maxHeight * ((float)maxHeight / (float)this.pos.h));
                    scrollY = Math.max(scrollY, 0.0);
                    this.layout();
                }
            } else {
                int i = this.getindex(this.px, this.py);
                if (info == 0) {
                    this.highlight(-i);
                } else if (info == 1 && this.py < this.titley1) {
                    this.setFlags(this.flags ^ 0x2000000);
                } else if (info == 2 && this.curitem <= 0) {
                    this.configure();
                } else if (info == 1 && this.altzone) {
                    this.selectAlt(this.curitem, info);
                } else {
                    this.select(this.curitem, info);
                }
                this.formatReadOut(1);
            }
        } else if (name.equals("KEYPRESS")) {
            this.handleKeyPress(info, (String)data);
        } else if (name.equals("DRAG")) {
            MBox dragBox = (MBox)data;
            int x = dragBox.x;
            int extraMarginX = 2;
            int leftOfScrollBar = this.pos.w - this.titlex2 - this.bw - 10;
            if (this.shouldScroll && x > leftOfScrollBar - extraMarginX && x < leftOfScrollBar + 10 + 2 * extraMarginX) {
                int y = dragBox.y;
                int h = dragBox.h;
                int yAdjustedForTitle = y - this.titley1;
                int extraMarginY = 15;
                if (!this.slidingKnob && (double)yAdjustedForTitle >= scrollY - (double)extraMarginY && (double)yAdjustedForTitle <= scrollY + 16.0 + (double)extraMarginY) {
                    this.scrollYAtStartOfSlide = scrollY;
                    this.slidingKnob = true;
                    this.setScrollNoMove(true);
                }
                if (this.slidingKnob) {
                    scrollY = this.scrollYAtStartOfSlide + (double)h;
                    scrollY = Math.max(0.0, scrollY);
                    int maxHeight = this.maxMenuHeight - this.titley1 - this.titley2;
                    scrollY = Math.min((double)maxHeight, scrollY);
                    this.layout();
                }
            }
        } else if (name.equals("DRAGBOX")) {
            if (this.slidingKnob) {
                this.slidingKnob = false;
            }
        } else {
            return -1;
        }
        return 1;
    }

    @Override
    public void setFlags(int flags) {
        if (this.is(32)) {
            flags &= 0xFDFFFFFF;
        }
        if (flags == this.flags) {
            return;
        }
        this.flags = flags;
        this.setup();
        this.resize(1);
        this.refresh();
    }

    @Override
    public int processMessage(Message msg) {
        if (this.status != -3) {
            if (msg.name.equals("GCHOICE")) {
                this.selectChoice(msg.info);
                if (!this.is(1)) {
                    this.close();
                }
            } else if (msg.name.equals("GMENU.CFG")) {
                String text = (String)msg.data;
                if (text.equals("SETCOLUMNS>")) {
                    new GValue((Object)this, "GMenu.columns", this.nc, -1, 8, 1, 0, (MessageHandler)this);
                } else {
                    this.setFlags(msg.info);
                }
            } else if (msg.name.equals("GMENU.COLUMNS")) {
                this.setColumns(Convert.o2l(msg.data));
            } else {
                return super.processMessage(msg);
            }
        }
        return -1;
    }

    public void select(int i, int button) {
        boolean stateChange;
        String sitem = "NULL";
        if (this.disabledItems != null && this.disabledItems.get(i) != null) {
            return;
        }
        if (button == 3) {
            i = this.is(1024) ? 0 : this.defitem;
        }
        if (i >= 0 && i <= this.items) {
            sitem = this.getValue(i, !this.is(0x400000));
        }
        boolean bl = stateChange = (this.defitem != 0 || this.is(0x8000000)) && !this.isNoState(i);
        if (this.is(1024) && !sitem.endsWith(">")) {
            if (button != 3) {
                this.defitem ^= 1 << i - 1;
            }
            if (this.is(0x100000)) {
                sitem = Parser.mask2s(this.list, this.defitem);
            }
            this.sendMessage(this.label, this.defitem, sitem);
        } else if (this.is(1024) && button == 2 && sitem.endsWith(">")) {
            if (this.is(0x100000)) {
                sitem = Parser.mask2s(this.list, this.defitem);
            }
            this.sendMessage(this.label, this.defitem, sitem);
        } else if (button != 3 || this.defitem != 0 && !this.label.equals("GCHOICE")) {
            if (i != 0 && stateChange) {
                this.defitem = i;
            }
            this.sendMessage(this.label, i, sitem);
        }
        if (this.is(1) || this.is(2) && button != 3 || !this.is(3) && button == 2) {
            if (i >= 0 && !this.is(1024)) {
                if (this.is(0x800000)) {
                    this.defitem = 0;
                } else if (stateChange) {
                    this.defitem = i;
                }
            }
            this.refresh();
        } else {
            this.close();
        }
    }

    public void selectAlt(int i, int button) {
        String sitem = "NULL";
        if (button == 3) {
            i = this.is(1024) ? 0 : this.defitem;
        }
        if (i > 0 && i <= this.items) {
            sitem = this.getValue(i, !this.is(0x400000));
        }
        this.sendMessage(this.label + ".ALT", i, sitem);
    }

    @Override
    public boolean poll() {
        if (this.monitorName == null || !this.is(0x20000000)) {
            return false;
        }
        String sval = this.M.results.getS(this.monitorName);
        int item = 0;
        item = StringUtil.isNumber(sval) ? (int)this.M.results.getD(this.monitorName) : this.getItemIndex(sval);
        if (item == this.defitem || item < 0 || item > this.items) {
            return false;
        }
        this.defitem = item;
        this.sendMessage(this.label, item, this.getValue(item, !this.is(0x400000)));
        this.refresh();
        return true;
    }

    private void selectChoice(int item) {
        if (item < 0) {
            return;
        }
        if (item > this.items && !this.is(1024)) {
            return;
        }
        if (this.disabledItems != null && this.disabledItems.get(item) != null) {
            return;
        }
        this.defitem = item;
        this.sendMessage(this.label, item, this.getValue(item, !this.is(0x400000)));
        this.refresh();
    }

    private void sendMessage(String name, int info, Object data) {
        if (this.monitorName != null && this.is(0x20000000)) {
            this.M.results.put(this.monitorName, data);
        }
        this.sendWidgetMessage(name, info, data);
    }

    public boolean isSet(String maskName) {
        boolean maskIsSet = false;
        if (this.is(1024)) {
            int i = Parser.mask(this.list, maskName, 0);
            if ((i & this.defitem) != 0) {
                maskIsSet = true;
            }
        } else {
            this.M.warning("GMenu.isSet method only intended for /TOGGLE menus");
        }
        return maskIsSet;
    }

    @Override
    public Object getValue() {
        if (this.is(1024)) {
            return Parser.mask2s(this.list, this.defitem);
        }
        return this.getValue(this.defitem, !this.is(0x400000));
    }

    public String getItem(int i) {
        if (i < 0 || i > this.items) {
            return null;
        }
        return this.itemv[i];
    }

    public String getValue(int item, boolean uc) {
        if (item < 0 || item > this.items) {
            return "";
        }
        String sitem = this.getItem(item);
        if (uc) {
            sitem = sitem.toUpperCase();
        }
        return sitem;
    }

    @Override
    public void setAction(String text) {
        this.setActionType();
        int indx = this.getItemIndex(text);
        if (indx < 0 && this.is(0x200000)) {
            this.itemv[0] = text;
            indx = 0;
        }
        if (indx >= 0) {
            if (this.is(256)) {
                this.selectChoice(indx);
            } else {
                this.select(indx, 1);
            }
        }
    }

    public int getItemIndex(String text) {
        int i;
        if (text == null || text.length() == 0) {
            return -1;
        }
        boolean ofNumbers = false;
        boolean isNumber = StringUtil.isNumber(text);
        String uctext = text.toUpperCase();
        for (i = 1; i <= this.items; ++i) {
            String value = this.getItem(i).toUpperCase();
            if (value.equals(uctext) && !this.is(1024)) {
                return i;
            }
            if (ofNumbers || !StringUtil.isNumber(value)) continue;
            ofNumbers = true;
        }
        if (isNumber && ofNumbers && text.endsWith(".0")) {
            String tntext = text.substring(0, text.length() - 2);
            for (int i2 = 1; i2 <= this.items; ++i2) {
                String value = this.getItem(i2).toUpperCase();
                if (!value.equals(tntext)) continue;
                return i2;
            }
        }
        if (isNumber && text.length() == 1 && !ofNumbers && !this.is(0x200000)) {
            return Convert.s2l(text);
        }
        if (this.is(1024) && (i = Parser.mask(this.list, text, this.defitem)) > 0) {
            return i;
        }
        if (!isNumber && !ofNumbers) {
            for (i = 1; i <= this.items; ++i) {
                String value = this.getItem(i).toUpperCase();
                if (!value.startsWith(uctext)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void setValue(String text) {
        String value;
        int i;
        if (text == null || text.length() == 0) {
            return;
        }
        boolean strippedDecimal = false;
        if (text.endsWith(".0") && StringUtil.isFloat(text)) {
            text = text.substring(0, text.length() - 2);
            strippedDecimal = true;
        }
        boolean ofNumbers = false;
        boolean isNumber = StringUtil.isNumber(text);
        String uctext = text.toUpperCase();
        for (i = 1; i <= this.items; ++i) {
            value = this.getItem(i).toUpperCase();
            if ((value.equals(uctext) || strippedDecimal && value.equals(uctext + ".0")) && !this.is(1024)) {
                this.setValue(i);
                return;
            }
            if (ofNumbers || !StringUtil.isNumber(value)) continue;
            ofNumbers = true;
        }
        if (isNumber && text.length() == 1 && !ofNumbers && !this.is(0x200000)) {
            if (this.is(1024)) {
                this.M.deprecate("GMENU: setting a toggle mask with the number [" + text + "] has been deprecated since NeXtMidas 2.9.0. Use text String from list: [" + this.list + "]");
            }
            this.setValue(Convert.s2l(text));
            return;
        }
        if (this.is(1024) && (i = Parser.mask(this.list, text, this.defitem)) > 0) {
            this.setValue(i);
            return;
        }
        if (!isNumber && !ofNumbers) {
            for (i = 1; i <= this.items; ++i) {
                value = this.getItem(i).toUpperCase();
                if (!value.startsWith(uctext)) continue;
                this.setValue(i);
                return;
            }
        }
        this.itemv[0] = text;
        this.setValue(0);
    }

    public void setValue(int item) {
        if (item == -1 && this.is(1024)) {
            item = (1 << this.items) - 1;
        }
        this.defitem = item;
        this.refresh();
    }

    public void setColumns(int nc) {
        this.nc = nc;
        this.flags = nc == 0 ? (this.flags &= 0xFFFBFFFF) : (this.flags |= 0x40000);
        this.setup();
        this.resize(1);
        this.refresh();
    }

    public void addItem(String item) {
        if (this.items > 0) {
            this.list = this.list + ',';
        }
        this.list = this.list + item;
        this.setItems(this.list);
    }

    public void addItem(String item, boolean toggleOn) {
        this.addItem(item);
        if (toggleOn && this.is(1024)) {
            int mask = 1 << this.items - 1;
            this.defitem |= mask;
            this.setValue(this.defitem);
        }
    }

    public void remItem(String item) {
        int i;
        int removeIndex = 0;
        int newdi = 0;
        int comparemask = 0;
        int addmask = 0;
        int addmaskindex = 0;
        for (i = 1; i <= this.items; ++i) {
            if (!item.equalsIgnoreCase(this.itemv[i])) continue;
            removeIndex = i;
            this.itemv[i] = null;
            if (this.disabledItems == null || this.disabledItems.get(i) == null) continue;
            this.disabledItems.remove(i);
            for (int index = i + 1; index < this.disabledItems.size(); ++index) {
                if (this.disabledItems.get(index) == null) continue;
                this.disabledItems.put(index - 1, this.getValue(index, false));
            }
        }
        if (removeIndex < 1) {
            return;
        }
        this.itemv2list();
        this.setItems(this.list);
        if (!this.is(1024) && removeIndex == this.defitem) {
            --this.defitem;
        } else if (this.is(1024)) {
            for (i = 1; i <= this.items + 1; ++i) {
                comparemask = 1 << i - 1;
                if (i == removeIndex) continue;
                addmask = 1 << ++addmaskindex - 1;
                if ((this.defitem & comparemask) != comparemask) continue;
                newdi += addmask;
            }
            this.defitem = newdi;
        }
        this.setValue(this.defitem);
    }

    public void setItem(int index, String item) {
        if (index < 1 || index > this.items) {
            return;
        }
        this.itemv[index] = item;
        this.itemv2list();
        this.setItems(this.list);
    }

    private void itemv2list() {
        this.list = null;
        for (int i = 1; i <= this.items; ++i) {
            if (this.itemv[i] == null) continue;
            this.list = this.list == null ? this.itemv[i] : this.list + "," + this.itemv[i];
        }
        if (this.list == null) {
            this.list = "";
        }
    }

    public int getItemIndex() {
        return this.defitem;
    }

    public void setItemColorTable(Table t) {
        this.ctab = t;
    }

    public void setItemColors(Table t) {
        if (this.ctab == null) {
            this.ctab = new Table();
        }
        Table.Iterator ti = t.iterator();
        while (ti.getNext()) {
            this.ctab.put(ti.key, (Object)MColor.getColor((String)ti.value));
        }
        this.refresh();
    }

    public void setItemColor(String item, String color) {
        this.setItemColor(item, MColor.getColor(color));
    }

    public void setItemColor(String item, Color color) {
        if (color == null && this.ctab != null) {
            this.ctab.remove(item);
        } else {
            if (this.ctab == null) {
                this.ctab = new Table();
            }
            this.ctab.put(item, (Object)color);
        }
        this.refresh();
    }

    public void setDisabledItems(String items) {
        if (items == null || items.equals("")) {
            return;
        }
        String list3 = items;
        int i = list3.indexOf(44);
        if (i < 0) {
            this.disableItem(list3);
            return;
        }
        while (i > 0) {
            this.disableItem(list3.substring(0, i));
            if ((i = (list3 = list3.substring(i + 1)).indexOf(44)) >= 0) continue;
            this.disableItem(list3);
            return;
        }
    }

    public void disableItem(String item) {
        int iItem = this.getItemIndex(item);
        if (iItem < 0) {
            this.M.warning("Attempt to disable an item that does not exist: '" + item + "'.");
            return;
        }
        if (this.defitem == iItem) {
            this.defitem &= ~iItem;
        }
        item = item.toUpperCase();
        this.saveItemColor(item);
        this.setItemColor(item, this.disabledItemColor);
        if (this.disabledItems == null) {
            this.disabledItems = new HashMap();
        }
        this.disabledItems.put(iItem, item);
        this.refresh();
    }

    public void enableItem(String item) {
        int iItem = this.getItemIndex(item);
        if (iItem < 0) {
            this.M.warning("Attempt to enable an item that does not exist: '" + item + "'.");
            return;
        }
        if (this.disabledItems != null && this.disabledItems.get(iItem) != null) {
            this.disabledItems.remove(iItem);
        }
        this.restoreColor(item.toUpperCase());
        this.refresh();
    }

    public boolean isItemEnabled(String item) {
        boolean enabled = true;
        int iItem = this.getItemIndex(item);
        if (this.disabledItems != null && this.disabledItems.get(iItem) != null) {
            enabled = false;
        }
        return enabled;
    }

    public void enableAllItems() {
        for (int index = 1; index <= this.items; ++index) {
            String item = this.getItem(index);
            if (this.isItemEnabled(item)) continue;
            this.enableItem(item);
        }
    }

    public void disableAllItems() {
        for (int index = 1; index <= this.items; ++index) {
            String item = this.getItem(index);
            if (this.isItemEnabled(item)) continue;
            this.disableItem(item);
        }
    }

    private void saveItemColor(String item) {
        if (this.savedColors == null) {
            this.savedColors = new Table();
        }
        if (this.ctab != null && this.ctab.get(item) != null) {
            Color color = (Color)this.ctab.get(item);
            this.savedColors.put(item, (Object)color);
        }
    }

    private void restoreColor(String item) {
        Color color = this.savedColors != null && this.savedColors.get(item) != null ? (Color)this.savedColors.get(item) : null;
        this.setItemColor(item, color);
    }

    public void setDisabledItemColor(Color color) {
        this.disabledItemColor = color;
    }

    public void setDisabledItemColor(String color) {
        this.setDisabledItemColor(MColor.getColor(color));
    }

    public Color getDisabledItemColor() {
        return this.disabledItemColor;
    }

    public String getDisabledItemColorString() {
        return MColor.toString(this.disabledItemColor);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cval = this.getValue(this.defitem, false);
        String nval = this.getText();
        this.panel.remove(this.jtexti);
        if (nval.equals(cval)) {
            this.refresh(this.bbox);
            return;
        }
        this.itemv[0] = nval;
        this.setValue(0);
        this.selectChoice(0);
        if (!this.is(1)) {
            this.close();
        }
    }

    public String getText() {
        return this.jtexti.getText();
    }

    @Override
    public Object setKey(String name, Object value) {
        if (name.equals("ACTION")) {
            this.setAction((String)value);
        } else if (name.equals("VALUE")) {
            this.setValue((String)value);
        } else if (name.equals("ITEM")) {
            this.setValue(Convert.o2l(value));
        } else {
            value = super.setKey(name, value);
        }
        return value;
    }

    @Override
    public Object getKey(String name) {
        Object value = name.equals("ITEM") ? Convert.l2o(this.defitem) : super.getKey(name);
        return value;
    }

    @Override
    public String toString() {
        return this.toList((String)this.getValue(), this.getItems());
    }

    public void setAltSize(int width, int height) {
        this.altwidth = width;
        this.altheight = height;
    }
}

