/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Graphics;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Shell;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MColor;
import nxm.sys.libg.Theme;

public class GLine
extends GWidget {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int CENTER = 3;
    public static final Color DEF_COLOR = Theme.global().cfg;
    private Color color = DEF_COLOR;
    public static final int DEF_THICKNESS = 4;
    private int thickness = 4;
    private int percent = 100;
    public static final int DEF_LINE_POS = 3;
    private int linePos = 3;

    public GLine() {
    }

    public GLine(Object parent, String name, Color color, int thickness, int percent, int linePos, int flags, MessageHandler mh) {
        super("GLine", parent, name, flags, mh);
        if (thickness > 0) {
            this.thickness = thickness;
        }
        if (percent >= 0 && percent <= 100) {
            this.percent = percent;
        }
        this.color = color;
        if (linePos == 1 || linePos == 2 || linePos == 3) {
            this.linePos = linePos;
        }
        this.open();
        this.addTo(parent);
    }

    @Override
    public void open() {
        super.open();
        this.setSize();
    }

    private void setSize() {
        this.panel.setSize(this.pw, this.thickness + this.bw + this.bw + 2 + 2);
    }

    @Override
    public void setup() {
        if (this.status == -2) {
            this.status = 1;
        }
        this.setSize();
        this.bw = this.is(32) ? 0 : 4;
        if (this.is(0x10000000)) {
            this.titleh = this.th + this.ta;
            this.bw = 4;
        } else {
            this.titleh = 0;
        }
        if (this.pw > 0 && this.thickness > 0) {
            this.pos.w = this.pw;
            this.pos.h = this.thickness + this.bw + this.bw + 2 + 2;
        }
        this.layout();
    }

    @Override
    @Deprecated
    public void paint() {
        this.refresh();
    }

    @Override
    @ProvisionalUseOnly(value="Treat this as protected and should only be called by subclass paintComponent methods")
    public void paintComponent(Graphics g) {
        int x1;
        super.paintComponent(g);
        this.shadowbox(g, 0, 0, this.pw, this.ph, -2);
        g.setClip(4, 2, this.pw - 8, this.panel.getHeight() - 4);
        g.setColor(this.color);
        int panelWidth = this.panel.getWidth();
        int lineWidth = (int)((double)panelWidth * ((double)this.percent / 100.0));
        int panelCenter = panelWidth / 2;
        switch (this.linePos) {
            case 3: {
                x1 = panelCenter - lineWidth / 2;
                break;
            }
            case 2: {
                x1 = panelWidth - lineWidth;
                break;
            }
            default: {
                x1 = 0;
            }
        }
        g.fillRect(x1, 0, lineWidth, this.thickness);
    }

    public void setColor(String color) {
        this.setColor(MColor.getColor(color));
    }

    @Override
    public void setColor(Color color) {
        if (color.getRGB() != this.color.getRGB()) {
            this.color = color;
            this.panel.repaint();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public String getColorString() {
        return MColor.toString(this.color);
    }

    public void setThickness(int pix) {
        if (pix != this.thickness && pix > 0) {
            this.thickness = pix;
            this.setSize();
            this.panel.repaint();
        }
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setLinePos(String pos) {
        pos = pos.toUpperCase();
        int iPos = -1;
        switch (pos) {
            case "LEFT": {
                iPos = 1;
                break;
            }
            case "RIGHT": {
                iPos = 2;
                break;
            }
            case "CENTER": {
                iPos = 3;
                break;
            }
            default: {
                Shell.warning("Invalid Line Position given: '" + pos + "'. Position must be 'LEFT', 'RIGHT', or 'CENTER'.");
            }
        }
        if (iPos > 0 && iPos != this.linePos) {
            this.linePos = iPos;
            this.panel.repaint();
        }
    }

    public String getLinePos() {
        switch (this.linePos) {
            case 1: {
                return "LEFT";
            }
            case 2: {
                return "RIGHT";
            }
        }
        return "CENTER";
    }

    public void setPercent(int val) {
        if (this.percent != val) {
            this.percent = val;
            this.panel.repaint();
        }
    }

    public int getPercent() {
        return this.percent;
    }

    public static int getLinePosValue(String pos) {
        switch (pos.toUpperCase()) {
            case "LEFT": {
                return 1;
            }
            case "RIGHT": {
                return 2;
            }
        }
        return 3;
    }

    @Override
    protected int processEventMessage(String name, int info, Object data) {
        if (this.button == 3 && !this.is(1)) {
            this.close();
            return 1;
        }
        return -1;
    }
}

